UNIT UVersion;

INTERFACE

USES
  Forms;

TYPE
  TVersionInfo =
    ( viCompanyName, viFileDescription, viFileVersion, viInternalName,
      viLegalCopyright, viLegalTradeMarks, viOriginalFilename, viProductName,
      viProductVersion, viComments
    );

FUNCTION GetPVInfo( theApplication: TApplication; aVersionInfo: TVersionInfo ): STRING;
(*++++++++++++++++++++++++++++++++++++++++++++++++++++++*)
IMPLEMENTATION

USES
  Windows, SysUtils;

(*------------------------------------------------------*)
FUNCTION GetPVInfo( theApplication : TApplication; aVersionInfo: TVersionInfo ): STRING;

VAR
  dwSize, iLen	: DWORD;
  pszBuf	: PCHAR;
  pszAnswer	: PCHAR;
  strWhat	: STRING;

BEGIN
dwSize := GetFileVersionInfoSize( PCHAR( theApplication.ExeName ), dwSize );
IF dwSize > 0 THEN
  BEGIN
  GetMem( pszBuf, dwSize );
  GetFileVersionInfo( PCHAR( theApplication.ExeName ), 0, dwSize, pszBuf );
  strWhat := '';
  CASE aVersionInfo OF
    viCompanyName	: strWhat := 'CompanyName';
    viFileDescription   : strWhat := 'FileDescription';
    viFileVersion	: strWhat := 'FileVersion';
    viInternalName	: strWhat := 'InternalName';
    viLegalCopyright	: strWhat := 'LegalCopyright';
    viLegalTradeMarks	: strWhat := 'LegalCopyright';
    viOriginalFilename	: strWhat := 'OriginalFilename';
    viProductName	: strWhat := 'ProductName';
    viProductVersion	: strWhat := 'ProductVersion';
    viComments		: strWhat := 'Comments';
    END;
  strWhat := 'StringFileInfo\040704E4\'+strWhat;
  IF VerQueryValue( pszBuf, PCHAR( strWhat ), POINTER( pszAnswer ), iLen ) THEN
     Result := StrPas( pszAnswer )
    ELSE
     Result := 'no entry';
  FreeMem( pszBuf, dwSize );
  END;
END;

(*++++++++++++++++++++++++++++++++++++++++++++++++++++++*)
END.



