UNIT Globals;

INTERFACE

TYPE
  TSSMode = (ssSetPwd,ssPreview,ssConfig,ssRun);

CONST
  aSSMode	: TSSMode = ssRun;
  bTestMode	: Boolean = false;
  bSound	: BOOLEAN = false;

VAR
  sstrFile		: ShortString;
  fileText		: TextFile;

PROCEDURE AppendText( CONST sstr: ShortString );

(*++++++++++++++++++++++++++++++++++++++*)
IMPLEMENTATION

USES
  SysUtils, MMSystem;

(*--------------------------------------*)
PROCEDURE AppendText( CONST sstr: ShortString );

BEGIN
Append( fileText ); WriteLn( fileText, DateTimeToStr( Now ), sstr );  CloseFile( fileText );
END;

(*++++++++++++++++++++++++++++++++++++++*)
INITIALIZATION
bSound	:= (WaveOutGetNumDevs <> 0);
sstrFile := '\BerlinPieSCR.txt';
AssignFile( fileText, sstrFile );
IF FileExists( sstrFile ) THEN
  Append( fileText )
 ELSE
  ReWrite( fileText );
WriteLn( fileText, DateTimeToStr(Now),'  [', ParamStr(1), '] [', ParamStr(2), ']' );
CloseFile( fileText );
END.
