PROGRAM BerlinPie;
{$D SCRNSAVE BerlinPie}

uses
  MMSystem,
  Classes,
  Controls,
  SysUtils,
  Windows,
  Messages,
  Graphics,
  Forms,
  UPie,
  Config in 'CONFIG.PAS' {DialogConfig},
  Globals in 'Globals.pas',
  UBerlinSCR in 'UBerlinSCR.pas' {FormSpecSCR};

{$R *.RES}
{$E SCR}		// Extension
{$R StrTable.RES}	// In dieser Datei steht der in der Systemsteuerung angezeigte Name
{$R Sounds.RES}		// die Klnge

VAR
  hSemaphore		: THandle;
  sstrArg1, sstrArg2	: SHORTString;
  hMod   		: THandle;
  strSysDir      	: String;
  iNewLen      		: Integer;
  functionPwd  		: function (a : PChar; ParentHandle : THandle; b, c : Integer): Integer; stdcall;
  hPrevWnd		: HWnd;
  aRect			: TRect;
  iScrWidth, iScrHeight : Integer;
  aCanvas    		: TCanvas;
  aRegEntries		: TBerlinUhrRegEntries;
  aSettings		: TBerlinUhrColors;
  aBerlinUhr		: TBerlinUhr;

(*++++++++++++++++++++++++++++++++++*)
BEGIN
hSemaphore := CreateSemaphore( nil, 0, 1, 'BerlinPieSCRSemaphore' );
IF ((hSemaphore <> 0) and (GetLastError = ERROR_ALREADY_EXISTS)) THEN
  BEGIN
  AppendText(' halted (ERROR_ALREADY_EXISTS)' );
  CloseHandle(hSemaphore);
  Halt;
  END;

sstrArg1 := UpperCase(ParamStr(1));
sstrArg2 := UpperCase(ParamStr(2));

IF (Copy(sstrArg1,1,2) = '/A') OR (Copy(sstrArg1,1,2) = '-A') OR
   (Copy(sstrArg1,1,1) = 'A') THEN
  aSSMode := ssSetPwd;

IF (Copy(sstrArg1,1,2) = '/P') OR (Copy(sstrArg1,1,2) = '-P') OR
   (Copy(sstrArg1,1,1) = 'P') THEN
  aSSMode := ssPreview;

IF (Copy(sstrArg1,1,2) = '/C') OR (Copy(sstrArg1,1,2) = '-C') OR
   (Copy(sstrArg1,1,1) = 'C') OR (sstrArg1 = '') THEN
  aSSMode := ssConfig;

IF aSSMode = ssSetPwd THEN
  BEGIN
  SetLength(strSysDir,MAX_PATH);
  iNewLen := GetSystemDirectory(PChar(strSysDir),MAX_PATH);
  SetLength( strSysDir, iNewLen);
  IF (Length( strSysDir ) > 0) and (strSysDir[Length(strSysDir)] <> '\') THEN
    strSysDir := strSysDir+'\';
  hMod := LoadLibrary(PChar(strSysDir+'MPR.DLL'));
  IF hMod <> 0 THEN
    BEGIN
    functionPwd := GetProcAddress( hMod,'PwdChangePasswordA');
    IF Assigned( functionPwd ) THEN
      functionPwd('SCRSAVE',StrToInt(sstrArg2),0,0);
    FreeLibrary(hMod);
    END;
  AppendText(' halted (ssSetPWD)' );
  Halt;
  END;

Application.Initialize;
Application.Title := 'BerlinPieSCR -  00 U.Creutzburg 9x/NT';
IF aSSMode = ssPreview THEN
  BEGIN
  aRegEntries	:= TBerlinUhrRegEntries.Create;
  aSettings	:= aRegEntries.BerlinUhrColors;
  aRegEntries.Free;

  hPrevWnd := StrToInt( sstrArg2 );
  WHILE NOT IsWindowVisible( hPrevWnd ) DO
    Application.ProcessMessages;
  GetWindowRect( hPrevWnd, aRect );
  iScrWidth	:= aRect.Right-aRect.Left+1;
  iScrHeight	:= aRect.Bottom-aRect.Top+1;

  aBerlinUhr	:= TBerlinUhr.Create( aSettings, iScrWidth, iScrHeight, 3 );
  aRect		:= Rect( 0, 0, iScrWidth-1, iScrHeight-1 );
  aCanvas	:= TCanvas.Create;
  aCanvas.Handle:= GetDC( hPrevWnd );
  aCanvas.CopyMode := cmSrcCopy;		//!!!
  WHILE IsWindowVisible( hPrevWnd ) DO
    BEGIN
    aCanvas.Draw(0,0, aBerlinUhr.GetBitmap( Now ) );
    Sleep(1);
    Application.ProcessMessages;
    END;
  aCanvas.Free;
  aBerlinUhr.Free;
  CloseHandle( hSemaphore );
  AppendText( ' halted (ssPreview)' );
  Halt;
  END
 ELSE
  IF aSSMode = ssConfig THEN
    BEGIN
    Application.CreateForm(TDialogConfig, DialogConfig);
    Application.CreateForm(TFormSpecSCR, FormSpecSCR);
    Application.Run;
    END
   ELSE
    BEGIN
    IF bSound THEN
      PlaySound( 'BRIDGE5', hInstance, SND_Resource OR SND_Async );
    Application.CreateForm(TFormSpecSCR, FormSpecSCR);
    Application.Run;
    Application.ProcessMessages;
    END;

AppendText( ' normal shutdown' );
CloseHandle(hSemaphore);
END.
