{*************************************************
 * Demo2 application                             *
 *                                               *
 * This sample show how to create a customized   *
 * registration form.                            *
 *                                               *
 *     Part of the AVLock Pro package            *
 *     (c) Alcides Valega, 2002                  *
 *************************************************}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, AVLockPro;

type
  TForm1 = class(TForm)
    MM1: TMainMenu;
    Modulo11: TMenuItem;
    Item111: TMenuItem;
    Item121: TMenuItem;
    Modulo21: TMenuItem;
    Item211: TMenuItem;
    Item221: TMenuItem;
    m1Opcin31: TMenuItem;
    Modulo31: TMenuItem;
    m3Opcin11: TMenuItem;
    m3Opcin21: TMenuItem;
    m3Opcin31: TMenuItem;
    Modulo41: TMenuItem;
    m4Opcin11: TMenuItem;
    m4Opcin21: TMenuItem;
    Archivos1: TMenuItem;
    Salir1: TMenuItem;
    Registrar1: TMenuItem;
    avlockpro1: TAVLockPro;
    Module51: TMenuItem;
    Module61: TMenuItem;
    Module71: TMenuItem;
    Module81: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Registrar1Click(Sender: TObject);
    procedure Item111Click(Sender: TObject);
    procedure Item121Click(Sender: TObject);
    procedure m1Opcin31Click(Sender: TObject);
    procedure Item211Click(Sender: TObject);
    procedure Item221Click(Sender: TObject);
    procedure m3Opcin11Click(Sender: TObject);
    procedure m3Opcin21Click(Sender: TObject);
    procedure m3Opcin31Click(Sender: TObject);
    procedure m4Opcin11Click(Sender: TObject);
    procedure m4Opcin21Click(Sender: TObject);
    procedure Salir1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Procedure setreg;
    function MyExecute(force:boolean):boolean;
    procedure legend(m,i:integer);
  end;

var
  Form1: TForm1;

implementation
uses RegUnit1;
{$R *.DFM}

Procedure TForm1.setreg;
begin
  avlockpro1.read;
  MM1.Items[1].visible := avlockpro1.m1;
  MM1.Items[2].visible := avlockpro1.m2;
  MM1.Items[3].visible := avlockpro1.m3;
  MM1.Items[4].visible := avlockpro1.m4;
  MM1.Items[5].visible := avlockpro1.m5;
  MM1.Items[6].visible := avlockpro1.m6;
  MM1.Items[7].visible := avlockpro1.m7;
  MM1.Items[8].visible := avlockpro1.m8;
end;

function TForm1.MyExecute(force:boolean):boolean;
var F:TRegForm1;
    s:string;
begin
  Result:=False;
  setreg;
  if avlockpro1.firsttime then avlockpro1.maketrial;
  if avlockpro1.Authorized then avlockpro1.writelastdate;
  if (avlockpro1.Registered or (avlockpro1.Authorized and (avlockpro1.EndDate-date > 10) and not avlockpro1.Expired)) then Result:=True;
  if not result or force then with avlockpro1 do begin
    WriteLastDate;
    Result:=False;
    F:=TRegForm1.Create(nil);
    try
    F.Caption:=AppName;
    F.EdCodInstal.text:=Instalcode;
    F.BtnOk.Enabled:=not expired;
    F.Panel1.Visible := not registered and not expired;

    if authorized then s:='authorized ' else s:= 'evaluation ';
    if expired then s:=s+'period expired.'
    else s:= 'You are in the day '+inttostr(trunc(now-begindate+1))
    +' of your '+inttostr(days)+' day '+s+'period.';
    if registered then s:='Application registered.';
    F.Ltext.caption:=s;

    s:='';
    F.memo2.Clear;
    if m1 then s:=s+'  >'+module1Text;
    if m2 then s:=s+'  >'+module2Text;
    if m3 then s:=s+'  >'+module3Text;
    if m4 then s:=s+'  >'+module4Text;
    if m5 then s:=s+'  >'+module5Text;
    if m6 then s:=s+'  >'+module6Text;
    if m7 then s:=s+'  >'+module7Text;
    if m8 then s:=s+'  >'+module8Text;
    F.memo2.Lines.add(s);

    F.memo1.Lines.Clear;
    with avlockpro1 do begin
      if expired then F.memo1.lines.add(TextExpired)
      else if not registered and (EndDate-date < 11) then F.memo1.lines.add(TextWarning)
      else if not registered and not authorized
      then F.memo1.lines.add(TextCongratulation);
    end;
    F.LDate1.Caption := datetostr(begindate);
    F.LDate2.Caption := datetostr(enddate);
    F.PBar1.Min :=0;
    F.PBar1.Max :=trunc(enddate-begindate);
    F.Pbar1.Position := trunc(date-begindate);

    F.ClientWidth:=F.Line2.Left+F.Line2.Width+3;
    F.ClientHeight:=F.btnOk.Top+F.btnOk.Height+20;

    F.ShowModal;
    if F.modalresult = mrYes then begin
      if check(F.Edit1.text) then begin
        erasereg;
        write(F.Edit1.text);
        setreg;
        showmessage('Registration successful');
        if not expired then Result:=True;
      end else showmessage('Invalid Registration Code');
      F.Panel1.Visible := not registered and not expired;
    end;
    if (F.modalresult = mrOk) and not expired then Result:=True;
    finally
    F.Free;
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  //if not myExecute(false) then application.Terminate;
end;

procedure TForm1.legend(m,i:integer);
begin
  //added to avoid cracking ----------------------
  if avlockpro1.Expired then application.terminate;
  //-----------------------------------------------
  showmessage('Module: '+inttostr(m)+'       Item: '+inttostr(i)+#13#10+
  '--------------------------------------------'+#13#10+
  'Sample program for the AVLock Pro component');
end;

procedure TForm1.Registrar1Click(Sender: TObject);
begin
  myexecute(true);
end;

procedure TForm1.Item111Click(Sender: TObject);
begin
  legend(1,1);
end;

procedure TForm1.Item121Click(Sender: TObject);
begin
  legend(1,2);
end;

procedure TForm1.m1Opcin31Click(Sender: TObject);
begin
  legend(1,3);
end;

procedure TForm1.Item211Click(Sender: TObject);
begin
  legend(2,1);
end;

procedure TForm1.Item221Click(Sender: TObject);
begin
  legend(2,2);
end;

procedure TForm1.m3Opcin11Click(Sender: TObject);
begin
  legend(3,1);
end;

procedure TForm1.m3Opcin21Click(Sender: TObject);
begin
  legend(3,2);
end;

procedure TForm1.m3Opcin31Click(Sender: TObject);
begin
  legend(3,3);
end;

procedure TForm1.m4Opcin11Click(Sender: TObject);
begin
  legend(4,1);
end;

procedure TForm1.m4Opcin21Click(Sender: TObject);
begin
  legend(4,2);
end;

procedure TForm1.Salir1Click(Sender: TObject);
begin
  Close;
end;

end.
