unit frmUpdateInfo;

{*******************************************************************************
      frmUpdateInfo - Form to display information about downloaded update

                    (c) Copyright 1999, 2000 Cynthesis Software Inc.

  Author:

    James Waletzky (cynthesis@home.com)
                   (http://www.npsnet.com/waletzky/)

  Description:

    This form is displayed once it has been determined that an update is
    available on the server for download. Information displayed includes the
    name of the update, version of the update, details, etc.

  Limitations of Use:

    The TCynthesisAppUpdate component (and its various pieces) is free (no
    strings attached) for NON-COMMERICAL use. For use in a commercial
    application, please contact James Waletzky via e-mail at cynthesis@home.com
    for information about licensing fees.

    The source code for this component (for NON-COMMERCIAL use) is available
    from Cynthesis Software for a cost of $10. Please remit a cheque or money
    order payable to Cynthesis Software Inc. to the following address:

             Cynthesis Software Inc.
             408 - 260 Newport Drive
             Port Moody, BC
             Canada
             V3H 5C6

    This source code may NOT be distributed to other sources, and is for the
    exclusive use of the licensee. The source code may be used in any
    application developed by the licensee on a royalty-free basis, as long as
    that application is distributed as freeware. For use in a commercial
    application, see the terms of the licensing agreement.

  Request:

    Please send your comments about the TCynthesisAppUpdate component, or
    suggestions for improvement, to cynthesis@home.com. The comoponent can only
    get better with your help!

*******************************************************************************}

interface

uses
  Classes, Controls, Forms, StdCtrls,
  CynthesisAppUpdateVersionInfo;

type

{ this class is a standard Delphi form that displays information about the
  update that is available for download from the server }

  TFormUpdateInfo = class(TForm)
    gbUpdateInformation: TGroupBox;
    lblUpdateName: TLabel;
    lblUpdateNameValue: TLabel;
    lblCurrentVersion: TLabel;
    lblCurrentVersionValue: TLabel;
    lblUpdateVersion: TLabel;
    lblUpdateVersionValue: TLabel;
    lblUpdateDescription: TLabel;
    editUpdateDescriptionValue: TEdit;
    lblUpdateSize: TLabel;
    lblUpdateSizeValue: TLabel;
    lblUpdateURL: TLabel;
    editUpdateURLValue: TEdit;
    lblReadmeURL: TLabel;
    editReadmeURLValue: TEdit;
    lblInstructions: TLabel;
    btnOk: TButton;
    btnCancel: TButton;

    procedure lblURLClick(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);

  public
    procedure Initialize(versionInfo: TCynthesisAppUpdateVersionInfo);

  end;  { class TFormUpdateInfo }

implementation

{$R *.DFM}

uses
  Windows, ShellAPI, SysUtils;


{*******************************************************************************
* TFormUpdateInfo
*******************************************************************************}


{-------------------------------------------------------------------------------

  Name:       Initialize
  Member of:  TFormUpdateInfo

  Purpose:    Initializes the fields in the dialog box with the update
              information that is supplied via an input parameter.

-------------------------------------------------------------------------------}
procedure TFormUpdateInfo.Initialize(versionInfo: TCynthesisAppUpdateVersionInfo);
begin
  with versionInfo do
  begin
    lblUpdateNameValue.Caption := Name;
    lblCurrentVersionValue.Caption := CurrentVersion;
    lblUpdateVersionValue.Caption := NewVersion;

    { hide or show the update size label depending on whether or not the update
      size is available }
    lblUpdateSize.Visible := (UpdateSize > 0);
    lblUpdateSizeValue.Visible := lblUpdateSize.Visible;
    lblUpdateSizeValue.Caption := IntToStr(UpdateSize);

    editUpdateDescriptionValue.Text := Details;
    editUpdateURLValue.Text := UpdateURL;
    editReadmeURLValue.Text := ReadmeURL;

  end;  { with versionInfo }

end;  { Initialize }


{-------------------------------------------------------------------------------

  Name:       lblURLClick
  Member of:  TFormUpdateInfo

  Purpose:    Event handler that is triggered when the user clicks on the label
              displaying a URL. An example is when the user clicks on the label
              displaying the URL to the README file - once clicked, the README
              is displayed in the user's web browser.

-------------------------------------------------------------------------------}
procedure TFormUpdateInfo.lblURLClick(Sender: TObject);
begin
  { make a best attempt to launch the user's default web browser to
    connect to the URL as contained in the label caption }
  ShellExecute(Self.Handle,
               PChar('open' + #0),
               PChar((Sender as TEdit).Text + #0),
               PChar( #0 ),
               PChar( #0 ),
               SW_SHOW);

end;  { lblURLClick }


{-------------------------------------------------------------------------------

  Name:       btnOkClick
  Member of:  TFormUpdateInfo

  Purpose:    Event handler that is triggered via a click on the Ok button.
              This code simply has the effect of closing the dialog and
              returning a value indicating Ok was pressed.

-------------------------------------------------------------------------------}
procedure TFormUpdateInfo.btnOkClick(Sender: TObject);
begin
  ModalResult := mrOk;

end;  { btnOkClick }


{-------------------------------------------------------------------------------

  Name:       btnCancelClick
  Member of:  TFormUpdateInfo

  Purpose:    Event handler that is triggered via a click on the Cancel button.
              This code simply has the effect of closing the dialog and
              returning a value indicating Click was pressed.

-------------------------------------------------------------------------------}
procedure TFormUpdateInfo.btnCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;

end;  { btnCancelClick }

end.
