unit CynthesisAppUpdateTypes;

{*******************************************************************************
      CynthesisAppUpdateTypes - Generic types used by AppUpdate component

                    (c) Copyright 1999 Cynthesis Software Inc.

  Author:

    James Waletzky (waletzky@npsnet.com)
                   (http://www.npsnet.com/waletzky/)

  Description:

    Generic types used by AppUpdate modules.

  Limitations of Use:

    The TCynthesisAppUpdate component (and its various pieces) is free (no
    strings attached) for NON-COMMERICAL use. For use in a commercial
    application, please contact James Waletzky via e-mail at waletzky@npsnet.com
    for permission and licensing of source code.

    The source code for this component (for non-commercial use) is available
    from Cynthesis Software for a cost of $10. Please remit a cheque or money
    order payable to Cynthesis Software Inc. to the following address:

             Cynthesis Software Inc.
             408 - 260 Newport Drive
             Port Moody, BC
             Canada
             V3H 5C6

    This source code may NOT be distributed to other sources, and is for the
    exclusive use of the licensee. The source code may be used in any
    application developed by the licensee on a royalty-free basis.

  Request:

    If you decide to make use of this component, I would like to hear from you
    as to your comments about the component, or suggestions for improvement.

*******************************************************************************}

interface

uses
  Classes;
  
const

  COMPONENT_VERSION_APPUPDATE = '2.0.0.0';

type

  { possible actions that can be completed when an update is to be installed }
  TCynthesisAppUpdateInstallActions =
    (iaNone,           { take no action once the update is downloaded }
     iaUseUpdate,      { use the update helper to unzip the update and install }
     iaRunExecutable   { simply run the update file that was downloaded }
    );  { TCynthesisAppUpdateInstallActions }

  { online modes }
  TCynthesisAppUpdateOnlineModes =
    (olHTTP,    { uses HTTP mode for file transfer from a URL }
     olFTP,     { uses FTP file transfer from an FTP host + path + filename }
     olLANWAN);  { uses d:\path\filename or \\server\share\path\filename }

  { update modes }
  TCynthesisAppUpdateModes =
    (umManual,         { the client application must implement the UI }
     umAutoWithUI,     { update is automatic with the component handling the UI }
     umAutoNoUI);      { update is automatic without any UI intervention }

  { reasons that the update operation could have been aborted }
  TUpdateAbortReasons =
    (arUnknown,        { reason for abort is unknown }
     arUpdateRefused,  { user refused an update - used when auto updating }
     arCancelled,      { triggered when a client calls the CancelUpdate method }
     arError);         { used whenever the abort event is fired from within the
                         error handler method }

  { return codes that are returned to a caller of one of the methods }
  TCynthesisAppUpdateReturnCodes =
    (rcOK,                   { everything is Ok }
     rcError,                { an error occurred during the update }
     rcHTTPError,            { problem connecting to the web server }
     rcInvalidHost,          { an invalid host was specified as the download server }
     rcCannotConnect,        { cannot connect to the host (invalid password? }
     rcTimeout,              { timeout connecting to the web server }
     rcNoAppInfo,            { no valid INI file is available describing the update }
     rcNoInternalVersion,    { no embedded version information in the exe }
     rcDownloadError,        { error during download }
     rcAppNotFound,          { the application to update could not be found }
     rcIncompatibleVersion,  { update not compatible with current version }
     rcFTPChangeDir,         { Error during FTP ChangeDir command }
     rcFTPDownloadFile,      { Error downloading file }
     rcFTPDownloadInfo,      { Error during FTP Download command of Info file}
     rcFTPDownloadUpdate,    { Error during FTP Download command of Update file}
     rcSourcePathExists,     { Source path does not exist for LANWAN mode copy }
     rcUNCConnect,           { Cannot Connect to UNC \\machine\Sharename }
     rcSourceFileExists,     { Source file does not exist for LANWAN mode copy }
     rcOpenSourceFile,       { cannot open source file for LANWAN mode copy }
     rcTempDriveLetterAvail, { no temp drive letters avail for UNC mapping }
     rcCreateTempFile        { cannot create temp file for LANWAN mode copy }
    );


  TCynthesisAppUpdateINIReturnCodes =
    (rcINIOK,                   { everything is Ok }
     rcININoVersion,            { no version information describing the update in the INI }
     rcINIBadSmartCompare,      { SmartCompare INI parameter set to invalid value }
     rcINIBadCaseSensitiveComp, { CaseSensitiveComp INI parameter set to invalid value }
     rcINIBadInstallAction,     { InstallAction INI parameter set to invalid value }
     rcININoUpdateURL           { the Application Update File is missing the Update URL }
    );  { TCynthesisAppUpdateINIReturnCodes }


  { object state enumerated type - used internally to track the state
    of the update process }
  TCynthesisAppUpdateStates = (auIdle, auError, auTimeout, auInvalidHost,
                               auCheckForUpdate, auDownloadUpdate,
                               auInstallUpdate, auNoINIVersion, auAborted,
                               auNoUpdateAvailable, auNoUpdateURL,
                               auBadSmartCompare, auBadCaseSensitiveComp,
                               auBadInstallAction, auNoInternalVersion,
                               auFTPChangeDir,
                               auFTPInfoDownLoad, auFTPUpdateDownload,
                               auFinishedInfoDownLoad, auFinshedUpdateDownload,
                               auSourcePathExists, auSourceFileExists,
                               auOpenSourceFile, auCreateTempFile);

  TCynthesisAppUpdateVersionCompares =
    (vcSameVersion,     { Version1 same as version 2 }
     vcNewerVersion,    { Version1 newer than as version 2 }
     vcOlderversion     { Version1 older than as version 2 }
     );

  { record that stores the error information for a method. The Error code
  is an enumerated type above; the error message is a string describing the
  return code, and the action is a recommended user action to overcome the
  error }
  TCynthesisAppUpdateError = record
    { message describing the error }
    ErrorMsg: string;

    { action that the user may take to abolish the error }
    ErrorAction: string;

    { enumerated type describing the error }
    case i: Integer of
      0: (ErrorCode: TCynthesisAppUpdateReturnCodes);
      1: (ErrorCodeINI: TCynthesisAppUpdateINIReturnCodes);

  end;  { TCynthesisAppUpdateError }

  TCynthesisDownloadInfo = record
    URL: string;
    TargetFile: string;
    UserName: string;
    UserPassword: string;
    ProxyServer: string;
    ProxyPort: LongInt;
  end;  { TCynthesisDownloadInfo }

  TCynthesisAppUpdateBase = class
  public
    constructor Create(Owner: TComponent); virtual;
    destructor Destroy; override;

    procedure Initialize; virtual; abstract;
    function DownloadFile(downloadInfo: TCynthesisDownloadInfo): string; virtual; abstract;
    procedure CancelDownloadFile; virtual; abstract;

    function ParseHostName(strURL: string): string; virtual; abstract;

  protected

    function getHost: string; virtual; abstract;

  public

    property Host: string read getHost;

  end;  { TCynthesisAppUpdateBase }


implementation


constructor TCynthesisAppUpdateBase.Create(Owner: TComponent);
begin
  inherited Create;
end;  { Create }

destructor TCynthesisAppUpdateBase.Destroy;
begin
  inherited Destroy;
end;  { Destroy }

end.
