unit uOpenUrl;

interface

uses   
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  uAdvHttp, StdCtrls;

type
  TfrmOpenUrl = class(TForm)
    wi: TAdvHttp;
    bStart: TButton;
    lbEvents: TListBox;
    mBody: TMemo;
    eUrl: TEdit;
    mHeaders: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    bStop: TButton;
    cbMethod: TComboBox;
    Label5: TLabel;
    cbSync: TCheckBox;
    SaveDialog1: TSaveDialog;
    procedure bStartClick(Sender: TObject);
    procedure wiClosingConnection(Sender: TObject);
    procedure wiConnectedToServer(Sender: TObject);
    procedure wiConnectingToServer(Sender: TObject);
    procedure wiConnectionClosed(Sender: TObject);
    procedure wiDataAvailable(Sender: TObject);
    procedure wiHandleClosing(Sender: TObject);
    procedure wiHandleCreated(Sender: TObject);
    procedure wiIntermediateResponse(Sender: TObject);
    procedure wiNameResolved(Sender: TObject);
    procedure wiReceivingResponse(Sender: TObject);
    procedure wiRedirect(Sender: TObject);
    procedure wiRequestComplete(Sender: TObject);
    procedure wiRequestSent(Sender: TObject);
    procedure wiResolvingName(Sender: TObject);
    procedure wiResponseReceived(Sender: TObject);
    procedure wiSendingRequest(Sender: TObject);
    procedure wiStateChange(Sender: TObject);
    procedure wiUnknownStatus(Sender: TObject);
    procedure wiError(Sender: TObject);
    procedure bStopClick(Sender: TObject);
    procedure wiNeedAuth(Sender: TObject);
    procedure wiNeedProxyAuth(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    Fpepe: integer;
    procedure Trace(s: string);
    procedure Setpepe(const Value: integer);
    { Private declarations }
  public
    { Public declarations }
    property pepe:integer read Fpepe write Setpepe;
  end;

var
  frmOpenUrl: TfrmOpenUrl;

implementation

{$R *.DFM}

procedure TfrmOpenUrl.Trace(s:string);
begin
  if csDestroying in ComponentState then exit;
  lbEvents.Items.add(s);
end;

procedure TfrmOpenUrl.bStartClick(Sender: TObject);
begin
  wi.URL:=eUrl.Text;
  wi.Method:=cbMethod.Items[cbMethod.ItemIndex];
  mBody.Text:='';
  mHeaders.Text:='';
  if cbSync.Checked then begin
    bStart.Enabled:=False;
    try
      wi.StartSync
    finally
      bStart.Enabled:=True;
    end
  end else begin
    wi.Start;
    bStart.Enabled:=False;
    bStop.Enabled:=True;
  end;
end;

procedure TfrmOpenUrl.wiClosingConnection(Sender: TObject);
begin
  Trace('Closing connection');
end;

procedure TfrmOpenUrl.wiConnectedToServer(Sender: TObject);
begin
  Trace(Format('Connected to %s',[wi.HostAddress]));
end;

procedure TfrmOpenUrl.wiConnectingToServer(Sender: TObject);
begin
  Trace(Format('Connecting to %s',[wi.HostAddress]));
end;

procedure TfrmOpenUrl.wiConnectionClosed(Sender: TObject);
begin
  Trace('Connection closed');
end;

procedure TfrmOpenUrl.wiDataAvailable(Sender: TObject);
begin
  Trace(format('Data available. Bytes: %d',[wi.BytesAvailable]));
end;

procedure TfrmOpenUrl.wiHandleClosing(Sender: TObject);
begin
//  Trace('Handle closing');
end;

procedure TfrmOpenUrl.wiHandleCreated(Sender: TObject);
begin
//  Trace('Handle created');
end;

procedure TfrmOpenUrl.wiIntermediateResponse(Sender: TObject);
begin
  Trace('Intermediate response');
end;

procedure TfrmOpenUrl.wiNameResolved(Sender: TObject);
begin
  Trace('Site found');
end;

procedure TfrmOpenUrl.wiReceivingResponse(Sender: TObject);
begin
  Trace('Receiving response');
end;

procedure TfrmOpenUrl.wiRedirect(Sender: TObject);
begin
  Trace(Format('Redirecting to %s',[wi.RedirectedUrl]));
end;

procedure TfrmOpenUrl.wiRequestComplete(Sender: TObject);
var n : Integer;
    ct : string;
begin
  bStart.Enabled:=True;
  bStop.Enabled:=False;
  Trace('Request complete');
  mHeaders.lines.Assign(wi.ResponseHeaders);
  for n:=0 to wi.ResponseHeaders.Count-1 do
    if StrliComp(PChar(wi.ResponseHeaders[n]),'Content-Type:',13)=0 then begin
       ct:=trim(Copy(wi.ResponseHeaders[n],14,Length(wi.ResponseHeaders[n])));
       if pos('text',ct)=0 then begin
          if SaveDialog1.Execute then
             wi.ResponseStream.SaveToFile(Savedialog1.FileName);
       end;
       break;
    end;
  mBody.Text:=wi.Text;
end;

procedure TfrmOpenUrl.wiRequestSent(Sender: TObject);
begin
  Trace(Format('%d bytes sent.',[wi.BytesSent]));
end;

procedure TfrmOpenUrl.wiResolvingName(Sender: TObject);
begin
  Trace(Format('Finding site: %s',[wi.HostName]));
end;

procedure TfrmOpenUrl.wiResponseReceived(Sender: TObject);
begin
  Trace(Format('%d bytes received.',[wi.BytesReceived]));
end;

procedure TfrmOpenUrl.wiSendingRequest(Sender: TObject);
begin
  Trace(Format('Openning page %s',[wi.URL]));
end;

procedure TfrmOpenUrl.wiStateChange(Sender: TObject);
begin
  Trace('State Changed');
end;

procedure TfrmOpenUrl.wiUnknownStatus(Sender: TObject);
begin
  Trace('Unknown Status');
end;

procedure TfrmOpenUrl.wiError(Sender: TObject);
begin
  Trace(wi.FormatMessage(wi.LastError));
  bStart.Enabled:=True;
  bStop.Enabled:=False;
end;

procedure TfrmOpenUrl.bStopClick(Sender: TObject);
begin
  wi.Stop;
end;

procedure TfrmOpenUrl.wiNeedAuth(Sender: TObject);
begin
  Trace('Need server authentication');
end;

procedure TfrmOpenUrl.wiNeedProxyAuth(Sender: TObject);
begin
  Trace('Need proxy authentication');
end;

procedure TfrmOpenUrl.FormShow(Sender: TObject);
begin
  cbMethod.ItemIndex:=0;
end;

procedure TfrmOpenUrl.Setpepe(const Value: integer);
begin
  Fpepe := Value;
end;

end.
