{Project AccessDao

 Comentarios en Espaol

 Autor: (c) Jose Maria Gias - Sigecom
 email: sigekom@arrakis.es

 Home:  http://www.arrakis.es/~sigecom

 Delphi 4  +  DAO 3.5

 Freeware

 # Herramienta para trabajar con tablas de MSAccess 97, con el DAO 3.5 y con el
 BDE. Crea y borra Alias en el BDE. Crea ficheros de Base de datos .mdb. Accede
 a los ficheros .mdb sin necesidad de introducir el nombre de usuario ni el
 Password en el Login prompt de MSAccess (Solo ficheros sin usuario ni password
 definidos previamente). Convierte y aade tablas dBase/Paradox a un base de
 datos .mdb con el DAO 3.5 o con el BDE. Realiza consultas SQL a las tablas con
 el DAO 3.5 o con el BDE. Visualiza los datos de cualquier tabla de una base de
 datos .mdb. Compacta y repara ficheros .mdb de MSAccess 97. Comentarios en
 Ingls y Espaol

 Por ser Freeware, no se ofrecen garantas.

 Usted puede copiarlo, distribuirlo, publicarlo en una pgina Web / Libro / CD,
 etc. o utilizarlo lbremente bajo su criterio sin permiso del autor, siempre
 que se distribuya el fichero original completo.

 Cdigo fuente de la unidad F_Access.pas : 15 Euros

 Version: 4.0

 04/27/1999

}
unit Access;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComObj, Db, DBTables, DbiTypes, ExtCtrls, DBCtrls, Grids, DBGrids,
  Buttons, F_Access;

type
  TForm1 = class(TForm)
    Table1: TTable;
    TableAccess: TTable;
    DataSourceAccess: TDataSource;
    BClose: TBitBtn;
    OpenDialog1: TOpenDialog;
    OpenDialog2: TOpenDialog;
    DBGrid1: TDBGrid;
    Database1: TDatabase;
    GroupBox1: TGroupBox;
    BSelectDataBase: TBitBtn;
    Label1: TLabel;
    EditAccessDataBase: TEdit;
    Label4: TLabel;
    CBTables: TComboBox;
    Label3: TLabel;
    GroupBox2: TGroupBox;
    BSelectTable: TBitBtn;
    EditTableForAppend: TEdit;
    BAppendDao: TBitBtn;
    CBOverWrite: TCheckBox;
    Label5: TLabel;
    EditPath: TEdit;
    DBNavigator1: TDBNavigator;
    EditAlias: TEdit;
    BAppendBde: TBitBtn;
    Query1: TQuery;
    GroupBox3: TGroupBox;
    BQueryDao: TBitBtn;
    Memo1: TMemo;
    BQueryBde: TBitBtn;
    DataSourceQuery: TDataSource;
    GroupBox4: TGroupBox;
    RBTable: TRadioButton;
    RBQuery: TRadioButton;
    TableQuery: TTable;
    BCompact: TBitBtn;
    BRepair: TBitBtn;
    BAbout: TBitBtn;
    GroupBox5: TGroupBox;
    CBAlias: TComboBox;
    Memo2: TMemo;
    BDeleteALias: TBitBtn;
    CBIndex: TComboBox;
    Label2: TLabel;
    CBFields: TComboBox;
    Label6: TLabel;
    CbIndexInfo: TComboBox;
    Label7: TLabel;
    BNewIndex: TBitBtn;
    BDeleteIndex: TBitBtn;
    Bevel1: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure BCloseClick(Sender: TObject);
    procedure BSelectTableClick(Sender: TObject);
    procedure BSelectDataBaseClick(Sender: TObject);
    procedure BAppendDaoClick(Sender: TObject);
    procedure CBTablesChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BQueryBdeClick(Sender: TObject);
    procedure RBTableClick(Sender: TObject);
    procedure BAboutClick(Sender: TObject);
    procedure BCompactClick(Sender: TObject);
    procedure BRepairClick(Sender: TObject);
    procedure CBAliasChange(Sender: TObject);
    procedure BDeleteALiasClick(Sender: TObject);
    procedure CBIndexChange(Sender: TObject);
    procedure BDeleteIndexClick(Sender: TObject);
    procedure BNewIndexClick(Sender: TObject);
  private
   { Private declarations }
    procedure GetAlias;
    procedure GetParamAlias;
  public
    { Public declarations }
    // Dir,sDataBaseName, sTableName, sAlias: String; // They are defined in unit F_Access
  end;

var
  Form1: TForm1;

implementation

 uses Acercade;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
 // Obtener el path de la aplicacin
 Dir := ExtractFilePath(Application.ExeName);
 if Dir[Length(Dir)] <> '\' then Dir := Dir + '\';
 OpenDialog1.InitialDir := Dir;
 CreateExampleTable(Table1); // Crear Base de datos y tablas para el ejemplo
 GetAlias; // Obtener los nombres de los Alias definidos en el BDE
end;

procedure TForm1.BCloseClick(Sender: TObject);
begin
 Close;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Application.Terminate;
end;

procedure TForm1.GetAlias;
begin
 // Obtener los nombres de los Alias definidos en el BDE
 try
  CBAlias.Items.Clear;
  CbAlias.Text := '';
  Session.GetAliasNames(CBAlias.Items);
 except
  CBAlias.Items.Clear;
 end;
end;

procedure TForm1.GetParamAlias;
begin
 // Obtener los parmetros del alias seleccionado
 if CBAlias.Text = '' then Exit;
 try
  Session.GetAliasParams(CBAlias.Text, Memo2.Lines);
 except
  Memo2.Lines.Clear;
 end;
end;

procedure TForm1.BSelectDataBaseClick(Sender: TObject);
var
 sPath: String;
 i: Integer;
begin
 // Obtener el nombre del fichero .mdb de la base de datos de MsAccess 97,
 // existente o nuevo

 if not OpenDialog1.Execute then Exit;

 EditAccessDataBase.Text := OpenDialog1.FileName;
 sAlias     := ExtractFileName(OpenDialog1.FileName);
 sPath      := ExtractFilePath(OpenDialog1.FileName);
 if sPath[Length(sPath)] <> '\' then sPath := sPath + '\';
 if Pos('.MDB',UpperCase(sAlias)) > 0
  then sAlias := Copy(sAlias,1,Length(sAlias)-4)
  else Exit;

 // Comprueba si existe el alias en el BDE. Si no existe, crea un nuevo fichero
 // .mdb de MsAccess 97
 if not TestAlias(sAlias, 'MSACCESS', sPath) then begin
  ShowMessage('Cannot create the Alias ' + sAlias);
  Exit;
 end;

 EditAlias.Text := sAlias;
 EditPath.Text  := sPath;
 OpenDialog1.InitialDir := sAlias;

 // Configura el objeto TDataBase para trabajar con bases de datos de MSAccess 97
 ConfigDataBase(DataBase1, // Objeto TDataBase que pasamos (hay que tener uno en el form)
                False);    // Mostrar la ventana con el login de MsAccess al abrir

 GetAlias;

 // Obtener los nombres de las tablas que contiene la base de datos de MsAccess
 // por medio del BDE
 CbTables.Text := '';
 CbTables.Items.Clear;
 Session.GetTableNames(sAlias,'',True,False,CbTables.Items);
 if CbTables.Items.Count = 0 then Exit;
 CbTables.Text := CbTables.Items[0];

 // Utilizamos los componentes estandar de Delphi para visualizar los datos,
 // como si fuera un .dbf o .db
 with TableAccess do begin
  Close;
  DataBaseName := sAlias;
  TableName    := CbTables.Text;
  try
   Open;
   CbFields.Text := '';
   CbFields.Items.Clear;
   GetFieldNames(CbFields.Items);
   CbIndex.Items.Clear;
   CbIndex.Text := '';
   CbIndexInfo.Text := '';
   GetIndexNames(CbIndex.Items);
  except
   ShowMessage('The selected table is not TTable ');
   Exit;
  end;
 end;

 DbGrid1.DataSource := DataSourceAccess;

 // Escribir en el Memo1 una pequea instruccin SQL para realizar un ejemplo
 // de Query contra la tabla abierta. Nota: La sintxis SQL de MsAccess es en
 // parte distinta a la que se utiliza para las tablas dBase o Paradox

 with Memo1 do begin
  Lines.Clear;
  Memo1.Lines.Add('SELECT * FROM ' + CbTables.Text + ' WHERE fieldname LIKE ' + #39 + '**' + #39);
 end;
end;

procedure TForm1.BSelectTableClick(Sender: TObject);
var
 sPath: String;
begin
 // Seleccionar una tabla .db/.dbf para aadirla a la base de datos MSAccess seleccionada
 if OpenDialog2.Execute then begin
  sPath      := ExtractFilePath(OpenDialog2.FileName);
  sTableName := ExtractFileName(OpenDialog2.FileName);
  with Table1 do begin
   Close;
   DataBaseName := sPath;
   TableName    := sTableName;
   try
    Open;
   except
    ShowMessage('Cannot open ' + TableName);
    EditTableForAppend.Text := '';
    Exit;
   end;
  end;

  if Pos('.DBF', UpperCase(sTableName)) > 0 then begin
   sTableName := Copy(sTableName, 1, Pos('.DBF', UpperCase(sTableName)) - 1);
  end else if Pos('.DB', UpperCase(sTableName)) > 0 then begin
            sTableName := Copy(sTableName, 1, Pos('.DB', UpperCase(sTableName)) - 1);
           end;
  EditTableForAppend.Text := sTableName;
 end;
end;

procedure TForm1.BAppendDaoClick(Sender: TObject);
var
 i: Integer;
 Exists: Boolean;
 TimeStart: Double;
 Hour,Min,Sec,MSec : Word;  // Coger la hora hasta los Milisegundos
begin

 if (Length(EditAccessDataBase.Text) = 0) or
    (Length(EditTableForAppend.Text) = 0) then Exit;
 Screen.Cursor := crHourGlass;
 TableAccess.Close;

 // Aadir una tabla dBase o Paradox a una base de datos de MsAccess por medio
 // de llamadas directas al DAO 3.5.
 if Sender = BAppendDao then
  i := AppendTableDao(Table1, // Tabla de origen, (Tabla a aadir)
                      EditAccessDataBase.Text, // Fichero .mdb de MsAccess
                      EditTableForAppend.Text, // Nombre de la nueva tabla en Access
                      CbOverWrite.Checked) // Sobre escribir la tabla en MsAccess si existe

 // Aadir una tabla dBase o Paradox a una base de datos de MsAccess por medio
 // del BDE. Esto cuesta un tiempo 4 veces mayor que con el DAO 3.5
 else begin
  Table1.Close;
  Table1.Open;
  with TableAccess do begin
   DataBaseName := sAlias;
   TableName := EditTableForAppend.Text;
   DisableControls;
   i := AppendTableBde(Table1, // Table de origen
                       TableAccess, // Table de destino
                       CbOverWrite.Checked); // Sobre escribir la tabla en MsAccess si existe
   EnableControls;
  end;
 end;

 Screen.Cursor := crDefault;
 ConfigDataBase(DataBase1,False);

 // Actualizar el ComboBox de las tablas
 Exists := False;
 for i := 0 to CbTables.Items.Count-1 do
  if CbTables.Items[i] = EditTableForAppend.Text
   then begin
    Exists := True;
    CbTables.Text := EditTableForAppend.Text;
   end;
 if not Exists then begin
  CbTables.Items.Add(EditTableForAppend.Text);
  CbTables.Text := EditTableForAppend.Text;
 end;
 CBTablesChange(nil); // Visualizar la tabla aadida
end;

procedure TForm1.BQueryBdeClick(Sender: TObject);
var
 i: Integer;
begin

 Screen.Cursor := crHourGlass;
 // El procedimiento es comn para el Dao y el BDE, en funcin del Sender que se
 // le pasa al llamarlo

 // Query con el BDE. Es ms rpido que directamente con DAO 3.5
 if Sender = BQueryBde then begin
  if QueryBDE(Query1,
              sAlias,
              Memo1.Text) < 1
   then begin // Si no encuentra ningn registro para el filtro SQL indicado
    Screen.Cursor := crDefault;
    ShowMessage('There are not data for the selected approach. ');
    Exit;
   end;
  DataSourceQuery.DataSet := Query1;
 end else begin // Query con el Dao
  try
   if QueryDao(DataBase1,
               TableAccess,
               TableQuery,
               EditAccessDataBase.Text,
               CbTables.Text,
               Memo1.Text) < 1
    then begin
     // Si el valor devuelto < 1, es que no hay datos para el criterio indicado
     Screen.Cursor := crHourGlass;
     ShowMessage('There are not data for the selected approach. ');
     Exit;
    end;
  finally
   Screen.Cursor := crHourGlass;
  end;
  DataSourceQuery.DataSet := TableQuery;
  TableQuery.Open;
 end;

 RbQuery.Checked := True;

 Screen.Cursor := crDefault;
end;

procedure TForm1.CBTablesChange(Sender: TObject);
begin

 // Actualizar la tabla y grid de trabajo con la tabla seleccionada
 if CbTables.Text <> '' then begin
  with TableAccess do begin
   Close;
   DataBaseName := sAlias;
   TableName    := CbTables.Text;
   try
    Open;
   except
    ShowMessage('The selected table is not TTable ');
    Exit;
   end;
   CbFields.Text := '';
   CbFields.Items.Clear;
   GetFieldNames(CbFields.Items);
   CbIndex.Text := '';
   CbIndex.Items.Clear;
   CbIndexInfo.Text := '';
   GetIndexNames(CbIndex.Items);
  end;


  DbGrid1.DataSource := DataSourceAccess;
  RbTable.Checked := True;

  // Escribir la sintxis SQL para el query con los datos de la nueva tabla
  // seleccionada
  with Memo1 do begin
   Lines.Clear;

   Memo1.Lines.Add('SELECT * FROM ' + CbTables.Text +
                   ' WHERE Text LIKE ' + #39 + '*Field 3*' + #39);

// Ejemplo genrico para buscar un string
//   Memo1.Lines.Add('SELECT * FROM ' + CbTables.Text +
//                   ' WHERE StringField LIKE ' + #39 + '*String to find*' + #39);

// Ejemplo para buscar un nmero
// Memo1.Lines.Add('SELECT * FROM ' + CbTables.Text + ' WHERE IntegerField = 333);
  end;
 end;
end;

procedure TForm1.RBTableClick(Sender: TObject);
begin
 if RbTable.Checked then begin
  DbGrid1.DataSource      := DataSourceAccess;
  DbNavigator1.DataSource := DataSourceAccess;
 end else begin
  DbGrid1.DataSource      := DataSourceQuery;
  DbNavigator1.DataSource := DataSourceQuery;
 end;
end;

procedure TForm1.BAboutClick(Sender: TObject);
begin
 FmAcercaDe.ShowModal;
end;

procedure TForm1.BCompactClick(Sender: TObject);
begin
 if EditAccessDataBase.Text = '' then Exit;
 Screen.Cursor := crHourGlass;
 DataBase1.Close;
 if not CompactDataBaseDao(EditAccessDataBase.Text)
  then ShowMessage('No es posible compactar la base de datos')
  else begin
   ConfigDataBase(DataBase1,False);
   TableAccess.Open;
  end;
 Screen.Cursor := crDefault;
end;

procedure TForm1.BRepairClick(Sender: TObject);
begin
 if EditAccessDataBase.Text = '' then Exit;
 Screen.Cursor := crHourGlass;
 DataBase1.Close;
 if not RepairDataBaseDao(EditAccessDataBase.Text)
  then ShowMessage('No es posible reparar la base de datos')
  else begin
   ConfigDataBase(DataBase1,False);
   TableAccess.Open;
  end;
 Screen.Cursor := crDefault;
end;

procedure TForm1.CBAliasChange(Sender: TObject);
begin
 GetParamAlias;
end;

procedure TForm1.BDeleteALiasClick(Sender: TObject);
var
 fConfigMode: TConfigMode;
begin
 if CBAlias.ItemIndex = -1 then begin
  ShowMessage('Please, select the Alias');
  Exit;
 end;

 if MessageDlg('Delete Alias: ' + CBAlias.Text + ' ?' , mtConfirmation, [mbYes, mbNo], 0) = mrYes
  then begin
   Screen.Cursor := CrHourGlass;

   // Borrar el alias del Bde
   fConfigMode := Session.ConfigMode;
   try
    DbiInit(nil);
    Session.DeleteAlias(CBAlias.Text);
    Session.SaveConfigFile;
   finally
    Session.ConfigMode := fConfigMode;
   end;

   GetAlias;
   Memo2.Lines.Clear;
   Screen.Cursor := CrDefault;
  end;
end;

procedure TForm1.CBIndexChange(Sender: TObject);
begin
 try
  if CbIndex.Text <> ''
   then begin
    InfoIndex(TableAccess, CbIndex.Text, CbIndexInfo);
    TableAccess.IndexName := CbIndex.Text;
   end else begin
    CbIndexInfo.Text := '';
    TableAccess.IndexName := '';
   end;
 except
 end;
end;

procedure TForm1.BDeleteIndexClick(Sender: TObject);
begin
 try
  TableAccess.Close;
  if CbIndex.Text <> '' then TableAccess.DeleteIndex(CbIndex.Text);
  CbIndex.Text := '';
  CbIndex.Items.Clear;
  CbIndexInfo.Text := '';
  TableAccess.Open;
  TableAccess.GetIndexNames(CbIndex.Items);
 except
  TableAccess.Open;
  ShowMessage('I cannot erase the index ' + CbIndex.Text);
 end;
end;

procedure TForm1.BNewIndexClick(Sender: TObject);
var
 i: Integer;
 b: Boolean;
begin
 if CbFields.Text = '' then Exit;
 if CbIndex.Text = '' then CbIndex.Text := CbFields.Text;

 // Comprobar si el campo indicado para el ndice existe
 b := False;
 for i := 0 to CbFields.Items.Count -1 do
  if CbFields.Text = CbFields.Items[i] then b := True;
 if not b then begin
  ShowMessage('The selected field doesn' + #39 + 't exist');
  Exit;
 end;

 // Comprobar si el ndice indicado existe
 b := False;
 for i := 0 to CbIndex.Items.Count -1 do
  if CbIndex.Text = CbIndex.Items[i] then b := True;
 if b then begin
  ShowMessage('The selected Index exists');
  Exit;
 end;

 with TableAccess do begin
  try
   Close;
   AddIndex(CbIndex.Text, CbFields.Text, []);
   CbIndex.Items.Clear;
   CbIndexInfo.Text := '';
   Open;
   GetIndexNames(CbIndex.Items);
   CbIndexInfo.Text := '';
   CBIndexChange(nil);
  except
   ShowMessage('Cannot create the index');
   Open;
  end;
 end;

end;

end.


