{Project AccessDao

 Autor: (c) Jose Maria Gias - Sigecom
 email: sigekom@arrakis.es

 Home:  http://www.arrakis.es/~sigecom

 Delphi 4  +  DAO 3.5

 Freeware

 Comment in file AccDaoEn.Txt

 Source code of unit F_Access.pas : 15 Euros

 Version: 4.0

 04/27/1999

}
unit Access;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComObj, Db, DBTables, DbiTypes, ExtCtrls, DBCtrls, Grids, DBGrids,
  Buttons, F_Access;

type
  TForm1 = class(TForm)
    Table1: TTable;
    TableAccess: TTable;
    DataSourceAccess: TDataSource;
    BClose: TBitBtn;
    OpenDialog1: TOpenDialog;
    OpenDialog2: TOpenDialog;
    DBGrid1: TDBGrid;
    Database1: TDatabase;
    GroupBox1: TGroupBox;
    BSelectDataBase: TBitBtn;
    Label1: TLabel;
    EditAccessDataBase: TEdit;
    Label4: TLabel;
    CBTables: TComboBox;
    Label3: TLabel;
    GroupBox2: TGroupBox;
    BSelectTable: TBitBtn;
    EditTableForAppend: TEdit;
    BAppendDao: TBitBtn;
    CBOverWrite: TCheckBox;
    Label5: TLabel;
    EditPath: TEdit;
    DBNavigator1: TDBNavigator;
    EditAlias: TEdit;
    BAppendBde: TBitBtn;
    Query1: TQuery;
    GroupBox3: TGroupBox;
    BQueryDao: TBitBtn;
    Memo1: TMemo;
    BQueryBde: TBitBtn;
    DataSourceQuery: TDataSource;
    GroupBox4: TGroupBox;
    RBTable: TRadioButton;
    RBQuery: TRadioButton;
    TableQuery: TTable;
    BCompact: TBitBtn;
    BRepair: TBitBtn;
    BAbout: TBitBtn;
    GroupBox5: TGroupBox;
    CBAlias: TComboBox;
    Memo2: TMemo;
    BDeleteALias: TBitBtn;
    CBIndex: TComboBox;
    Label2: TLabel;
    CBFields: TComboBox;
    Label6: TLabel;
    CbIndexInfo: TComboBox;
    Label7: TLabel;
    BNewIndex: TBitBtn;
    BDeleteIndex: TBitBtn;
    Bevel1: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure BCloseClick(Sender: TObject);
    procedure BSelectTableClick(Sender: TObject);
    procedure BSelectDataBaseClick(Sender: TObject);
    procedure BAppendDaoClick(Sender: TObject);
    procedure CBTablesChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BQueryBdeClick(Sender: TObject);
    procedure RBTableClick(Sender: TObject);
    procedure BAboutClick(Sender: TObject);
    procedure BCompactClick(Sender: TObject);
    procedure BRepairClick(Sender: TObject);
    procedure CBAliasChange(Sender: TObject);
    procedure BDeleteALiasClick(Sender: TObject);
    procedure CBIndexChange(Sender: TObject);
    procedure BDeleteIndexClick(Sender: TObject);
    procedure BNewIndexClick(Sender: TObject);
  private
   { Private declarations }
    procedure GetAlias;
    procedure GetParamAlias;
  public
    { Public declarations }
    // Dir,sDataBaseName, sTableName, sAlias: String;
    // They are defined in unit F_Access
  end;

var
  Form1: TForm1;

implementation

 uses Acercade;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
 // Gets the application path
 Dir := ExtractFilePath(Application.ExeName);
 if Dir[Length(Dir)] <> '\' then Dir := Dir + '\';
 OpenDialog1.InitialDir := Dir;
 CreateExampleTable(Table1); // Creates DataBase and tables for the example
 GetAlias; // To get info of the all BDE alias names
end;

procedure TForm1.BCloseClick(Sender: TObject);
begin
 Close;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Application.Terminate;
end;

procedure TForm1.GetAlias;
begin
 // To get info of the all BDE Alias names
 try
  CBAlias.Items.Clear;
  CbAlias.Text := '';
  Session.GetAliasNames(CBAlias.Items);
 except
  CBAlias.Items.Clear;
 end;
end;

procedure TForm1.GetParamAlias;
begin
 // Get parameters of the Alias
 if CBAlias.Text = '' then Exit;
 try
  Session.GetAliasParams(CBAlias.Text, Memo2.Lines);
 except
  Memo2.Lines.Clear;
 end;
end;

procedure TForm1.BSelectDataBaseClick(Sender: TObject);
var
 sPath: String;
begin

 // Obtain the name of the MsAccess 97 .mdb database file

 if not OpenDialog1.Execute then Exit;

 EditAccessDataBase.Text := OpenDialog1.FileName;
 sAlias     := ExtractFileName(OpenDialog1.FileName);
 sPath      := ExtractFilePath(OpenDialog1.FileName);
 if sPath[Length(sPath)] <> '\' then sPath := sPath + '\';
 if Pos('.MDB',UpperCase(sAlias)) > 0
  then sAlias := Copy(sAlias,1,Length(sAlias)-4)
  else Exit;

 // Tests if there is an existing alias in the BDE.  If it doesnt exist,
 // creates a new MsAccess 97 .mdb file

 if not TestAlias(sAlias, 'MSACCESS', sPath) then begin
  ShowMessage('Cannot create the Alias ' + sAlias);
  Exit;
 end;

 EditAlias.Text := sAlias;
 EditPath.Text  := sPath;
 OpenDialog1.InitialDir := sAlias;
 // Configures the TDataBase object to work with MsAcces 97 databases

 ConfigDataBase(DataBase1, // TDataBase object
                False);    // Show Login prompt of MsAccess

 GetAlias;

 //  Obtains the names of the tables that contain the MsAccess database thru BDE

 CbTables.Text := '';
 CbTables.Items.Clear;
 Session.GetTableNames(sAlias,'',True,False,CbTables.Items);
 if CbTables.Items.Count = 0 then Exit;
 CbTables.Text := CbTables.Items[0];

 //  We use the standard Delphi components to visualize data, as if it were a
 // .dbf o .db
 with TableAccess do begin
  Close;
  DataBaseName := sAlias;
  TableName    := CbTables.Text;
  try
   Open;
   CbFields.Text := '';
   CbFields.Items.Clear;
   GetFieldNames(CbFields.Items);
   CbIndex.Items.Clear;
   CbIndex.Text := '';
   CbIndexInfo.Text := '';
   GetIndexNames(CbIndex.Items);
  except
   ShowMessage('The selected table is not TTable ');
   Exit;
  end;
 end;

 DbGrid1.DataSource := DataSourceAccess;

 //  Writes on Memo1 a brief SQL instruction to perform a test of a Query when a
 //  table is open.  Note:  The MsAccess SQL syntax is somehow different to the
 //  one used by dBase or Paradox

 with Memo1 do begin
  Lines.Clear;
  Memo1.Lines.Add('SELECT * FROM ' + CbTables.Text + ' WHERE fieldname LIKE ' + #39 + '**' + #39);
 end;
end;

procedure TForm1.BSelectTableClick(Sender: TObject);
var
 sPath: String;
begin
 //  Selects a .db/.dbf table to add it to the selected MsAccess database

 if OpenDialog2.Execute then begin
  sPath      := ExtractFilePath(OpenDialog2.FileName);
  sTableName := ExtractFileName(OpenDialog2.FileName);
  with Table1 do begin
   Close;
   DataBaseName := sPath;
   TableName    := sTableName;
   try
    Open;
   except
    ShowMessage('Cannot open ' + TableName);
    EditTableForAppend.Text := '';
    Exit;
   end;
  end;

  if Pos('.DBF', UpperCase(sTableName)) > 0 then begin
   sTableName := Copy(sTableName, 1, Pos('.DBF', UpperCase(sTableName)) - 1);
  end else if Pos('.DB', UpperCase(sTableName)) > 0 then begin
            sTableName := Copy(sTableName, 1, Pos('.DB', UpperCase(sTableName)) - 1);
           end;
  EditTableForAppend.Text := sTableName;
 end;
end;

procedure TForm1.BAppendDaoClick(Sender: TObject);
var
 i: Integer;
 Exists: Boolean;
begin

 if (Length(EditAccessDataBase.Text) = 0) or
    (Length(EditTableForAppend.Text) = 0) then Exit;
 Screen.Cursor := crHourGlass;
 TableAccess.Close;

 //  Adds a dBase or a Paradox table to a MsAccess database by means of direct
 //  calls to DAO 3.5.

 if Sender = BAppendDao then
  i := AppendTableDao(Table1, // Table Source, (Table to Append)
                      EditAccessDataBase.Text, // File .mdb of Access
                      EditTableForAppend.Text, // Name of new table into Access
                      CbOverWrite.Checked) // Overwrite the table in Access if exists

 //  Adding a dBase or Paradox table to a MsAccess database by means of calls to
 //  BDE takes around 4 times longer than with DAO 3.5.

 else begin
  Table1.Close;
  Table1.Open;
  with TableAccess do begin
   DataBaseName := sAlias;
   TableName := EditTableForAppend.Text;
   DisableControls;
   i := AppendTableBde(Table1, // Table Source
                       TableAccess, // Table Target
                       CbOverWrite.Checked); // Overwrite the table in Access
   EnableControls;
  end;
 end;

 Screen.Cursor := crDefault;
 ConfigDataBase(DataBase1,False);

 //  Updates the tables ComboBox

 Exists := False;
 for i := 0 to CbTables.Items.Count-1 do
  if CbTables.Items[i] = EditTableForAppend.Text
   then begin
    Exists := True;
    CbTables.Text := EditTableForAppend.Text;
   end;
 if not Exists then begin
  CbTables.Items.Add(EditTableForAppend.Text);
  CbTables.Text := EditTableForAppend.Text;
 end;
 CBTablesChange(nil); // Visualize the added table
end;

procedure TForm1.BQueryBdeClick(Sender: TObject);
var
 i: Integer;
begin

 Screen.Cursor := crHourGlass;
 // This procedure is the same for the DAO and the BDE.  It depends on the
 // function of the Sender that is sent when it is called.
//  Queries with the BDE.  This is quicker than doing it with DAO 3.5 directly

 if Sender = BQueryBde then begin
  if QueryBDE(Query1,
              sAlias,
              Memo1.Text) < 1
   then begin // it has not found that wanted
    Screen.Cursor := crDefault;
    ShowMessage('There are not data for the selected approach. ');
    Exit;
   end;
  DataSourceQuery.DataSet := Query1;
 end else begin // Query with DAO
  try
   if QueryDao(DataBase1,
               TableAccess,
               TableQuery,
               EditAccessDataBase.Text,
               CbTables.Text,
               Memo1.Text) < 1
    then begin
    //  If returned value is < 1, there are no data for the indicated criteriao
     Screen.Cursor := crHourGlass;
     ShowMessage('There are not data for the selected approach. ');
     Exit;
    end;
  finally
   Screen.Cursor := crHourGlass;
  end;
  DataSourceQuery.DataSet := TableQuery;
  TableQuery.Open;
 end;

 RbQuery.Checked := True;

 Screen.Cursor := crDefault;
end;

procedure TForm1.CBTablesChange(Sender: TObject);
begin
  // Updates the table and the grid with the selected table
 if CbTables.Text <> '' then begin
  with TableAccess do begin
   Close;
   DataBaseName := sAlias;
   TableName    := CbTables.Text;
   try
    Open;
   except
    ShowMessage('The selected table is not TTable ');
    Exit;
   end;
   CbFields.Text := '';
   CbFields.Items.Clear;
   GetFieldNames(CbFields.Items);
   CbIndex.Text := '';
   CbIndex.Items.Clear;
   CbIndexInfo.Text := '';
   GetIndexNames(CbIndex.Items);
  end;


  DbGrid1.DataSource := DataSourceAccess;
  RbTable.Checked := True;
  //  Write the SQL syntax for the query with the data of the new selected table

  with Memo1 do begin
   Lines.Clear;

   Memo1.Lines.Add('SELECT * FROM ' + CbTables.Text +
                   ' WHERE Text LIKE ' + #39 + '*Field 3*' + #39);

   //  Generic example to find a string
//   Memo1.Lines.Add('SELECT * FROM ' + CbTables.Text +
//                   ' WHERE StringField LIKE ' + #39 + '*String to find*' + #39);

//  Example to find a number
// Memo1.Lines.Add('SELECT * FROM ' + CbTables.Text + ' WHERE IntegerField = 333);
  end;
 end;
end;

procedure TForm1.RBTableClick(Sender: TObject);
begin
 if RbTable.Checked then begin
  DbGrid1.DataSource      := DataSourceAccess;
  DbNavigator1.DataSource := DataSourceAccess;
 end else begin
  DbGrid1.DataSource      := DataSourceQuery;
  DbNavigator1.DataSource := DataSourceQuery;
 end;
end;

procedure TForm1.BAboutClick(Sender: TObject);
begin
 FmAcercaDe.ShowModal;
end;

procedure TForm1.BCompactClick(Sender: TObject);
begin
 if EditAccessDataBase.Text = '' then Exit;
 Screen.Cursor := crHourGlass;
 DataBase1.Close;
 if not CompactDataBaseDao(EditAccessDataBase.Text)
  then ShowMessage('No es posible compactar la base de datos')
  else begin
   ConfigDataBase(DataBase1,False);
   TableAccess.Open;
  end;
 Screen.Cursor := crDefault;
end;

procedure TForm1.BRepairClick(Sender: TObject);
begin
 if EditAccessDataBase.Text = '' then Exit;
 Screen.Cursor := crHourGlass;
 DataBase1.Close;
 if not RepairDataBaseDao(EditAccessDataBase.Text)
  then ShowMessage('No es posible reparar la base de datos')
  else begin
   ConfigDataBase(DataBase1,False);
   TableAccess.Open;
  end;
 Screen.Cursor := crDefault;
end;

procedure TForm1.CBAliasChange(Sender: TObject);
begin
 GetParamAlias;
end;

procedure TForm1.BDeleteALiasClick(Sender: TObject);
var
 fConfigMode: TConfigMode;
begin
 if CBAlias.ItemIndex = -1 then begin
  ShowMessage('Please, select the Alias');
  Exit;
 end;

 if MessageDlg('Delete Alias: ' + CBAlias.Text + ' ?' , mtConfirmation, [mbYes, mbNo], 0) = mrYes
  then begin
   Screen.Cursor := CrHourGlass;
   // Delete the alias
   fConfigMode := Session.ConfigMode;
   try
    DbiInit(nil);
    Session.DeleteAlias(CBAlias.Text);
    Session.SaveConfigFile;
   finally
    Session.ConfigMode := fConfigMode;
   end;

   GetAlias;
   Memo2.Lines.Clear;
   Screen.Cursor := CrDefault;
  end;
end;

procedure TForm1.CBIndexChange(Sender: TObject);
begin
 try
  if CbIndex.Text <> ''
   then begin
    InfoIndex(TableAccess, CbIndex.Text, CbIndexInfo);
    TableAccess.IndexName := CbIndex.Text;
   end else begin
    CbIndexInfo.Text := '';
    TableAccess.IndexName := '';
   end;
 except
 end;
end;

procedure TForm1.BDeleteIndexClick(Sender: TObject);
begin
 try
  TableAccess.Close;
  if CbIndex.Text <> '' then TableAccess.DeleteIndex(CbIndex.Text);
  CbIndex.Text := '';
  CbIndex.Items.Clear;
  CbIndexInfo.Text := '';
  TableAccess.Open;
  TableAccess.GetIndexNames(CbIndex.Items);
 except
  TableAccess.Open;
  ShowMessage('I cannot erase the index ' + CbIndex.Text);
 end;
end;

procedure TForm1.BNewIndexClick(Sender: TObject);
var
 i: Integer;
 b: Boolean;
begin
 if CbFields.Text = '' then Exit;
 if CbIndex.Text = '' then CbIndex.Text := CbFields.Text;

 // Checks if the field to index exists
 b := False;
 for i := 0 to CbFields.Items.Count -1 do
  if CbFields.Text = CbFields.Items[i] then b := True;
 if not b then begin
  ShowMessage('The selected field doesn' + #39 + 't exist');
  Exit;
 end;

 // Checks if the index to create exists
 b := False;
 for i := 0 to CbIndex.Items.Count -1 do
  if CbIndex.Text = CbIndex.Items[i] then b := True;
 if b then begin
  ShowMessage('The selected Index exists');
  Exit;
 end;

 with TableAccess do begin
  try
   Close;
   AddIndex(CbIndex.Text, CbFields.Text, []);
   CbIndex.Items.Clear;
   CbIndexInfo.Text := '';
   Open;
   GetIndexNames(CbIndex.Items);
   CbIndexInfo.Text := '';
   CBIndexChange(nil);
  except
   ShowMessage('Cannot create the index');
   Open;
  end;
 end;

end;

end.
