//**********************************************************************************************************************
//
//  A9RD-TProgressCyl
//
//  Copyright (C) 2000-2002 by Jean Darveau
//  All rights reserved.
//
//  THIS VERSION IS FOR PERSONNAL USE ONLY
//
//  COMMENTS : REMOVED
//  CODE : UNFORMATED
//  PROEFFECT : 3 EXEMPLES ONLY (32 IN THE COMMERCIAL VERSION : 20$ WITH FULL SOURCE AND DOCUMENTATION)
//
//  For conditions of distribution and use, see LICENSE.TXT.
//
//**********************************************************************************************************************
unit ProgressCyl;
interface
uses  Classes, Windows, Controls, Graphics, ExtCtrls, ComCtrls, SysUtils, Messages, Forms;
procedure Register();
type
TCylinderEffect = (ceFlat, ceUltraLow, ceLow, ceMedium, ceHigh, ceMaximum);
TCylinderStyle = (csColor, csSatin, csEngrave, csMetalic, csNeon, csPsychadelic, csLightInvert);
TFontEffect = (feNone, feInvert, feShadowTopLeft, feShadowBottomRight);
TFontOrientation = (foLeftToRight, foTopToBottom, foBottomToTop);
TBackStyle = (bsColor, bsDark);
TProEffect = (peSystem,peMetalic,peSunken);
const
MAXPCSCAN = 2048;MAXRGB = 255;DEFWIDTH = 150;DEFHEIGHT = 22;DEFTEXT = '%';
DEFTEXTDONE = '';DEFFONT = 'Arial';DEFFONTSIZE = 9;DEFFONTSTYLE = fsBold;
DEFFONTORIENTATION = foLeftToRight;DEFSHOWTEXT = true;DEFMIN = 0;
DEFMAX = 100;DEFSTEP = 1;DEFORIENTATION = pbHorizontal;DEFBEVELOUTER = bvLowered;
DEFBORDERWIDTH = 2;DEFBEVELWIDTH = 1;DEFBEVELINNER = bvRaised;
DEFSTOPATMAX = true;DEFCOLOR = clBtnFace;DEFBEVELCOLOR = clBtnFace;
BEVELFACTOR = 64;TEXTLEFTTORIGHT = 1;
TEXTBOTTOMTOTOP = 900;TEXTTOPTOBOTTOM = 2700;F_EFFECT = 1;
UL_EFFECT = 51;L_EFFECT = 102;M_EFFECT = 153;H_EFFECT = 204;X_EFFECT = 255;DEFCYLINDEREFFECT = ceMaximum;
DEFFORECOLOR = clWhite;DEFFORELINECOLOR = clHighlight;DEFBACKCOLOR = clBtnFace;
DEFBACKBORDERCOLOR = clBlack;DEFBACKSTYLE = bsColor;DEFFONTCOLOR = clBlack;
DEFFONTEFFECT = feShadowBottomRight;DEFFONTSHADOWCOLOR = clBtnFace;
type
TPCScan = ARRAY[0..MAXPCSCAN] OF TRGBTriple;
TOnMouseEnterEvent = procedure(Sender: TObject) of object;
TOnMouseLeaveEvent = procedure(Sender: TObject) of object;
TOnProgressDoneEvent = procedure(Sender: TObject) of object;
TProgressCyl = class;
TPCColorStyle = class(TPersistent)
private
FProgressCyl: TProgressCyl;
FIntensityRGB: Integer;
FIntensity: Single;
FIntensityFactor: Single;
FRangeRGB: Integer;
FColorRGB: Integer;
FColorFactor: Single;
FLightAngle: Single;
procedure SetIntensityRGB(Value: Integer);
procedure SetIntensity(Value: Single);
procedure SetIntensityFactor(Value: Single);
procedure SetRangeRGB(Value: Integer);
procedure SetColorRGB(Value: Integer);
procedure SetColorFactor(Value: Single);
procedure SetLightAngle(Value: Single);
public
constructor Create(AOwner: TProgressCyl);
published
property IntensityRGB: Integer read FIntensityRGB write SetIntensityRGB;
property Intensity: Single read FIntensity write SetIntensity;
property IntensityFactor: Single read FIntensityFactor write SetIntensityFactor;
property RangeRGB: Integer read FRangeRGB write SetRangeRGB;
property ColorRGB: Integer read FColorRGB write SetColorRGB;
property ColorFactor: Single read FColorFactor write SetColorFactor;
property LightAngle: Single read FLightAngle write SetLightAngle;
end;
TProgressCyl = class(TGraphicControl)
private
FInit, FMouseIsEntered : Boolean;
FCylFXFactor: Byte;
FFontFXFactor: Integer;
FLastPos, FLinePos, APosition, FPourcent, FLastPour: Integer;
FCylTL,FCylR,FCylB: Integer;
FInnTL,FInnR,FInnB: Integer;
FOutTL,FOutR,FOutB: Integer;
FFactorFR,FFactorFG,FFactorFB: Single;
FFactorBR,FFactorBG,FFactorBB: Single;
FFactorLR,FFactorLG,FFactorLB: Single;
FPaceV,FPaceH,FRange: Single;
FColInnTL, FColInnBR, FColOutTL, FColOutBR: TColor;
FclBtnHighlight, FclBtnShadow, Fcl3DLight, Fcl3DDkShadow: TColor;
FBmpShow: TBitmap;FbmpFont: TBitmap;
FBackBorderColor: TColor;FBackColor: TColor;
FBackStyle: TPCColorStyle;FBevelColor: TColor;
FBevelInner: TBevelCut;FBevelOuter: TBevelCut;
FBevelWidth: TBevelWidth;FBorderWidth: TBorderWidth;
FCylinderEffect: TCylinderEffect;
FFontEffect: TFontEffect;
FFontShadowColor: TColor;
FFontOrientation: TFontOrientation;
FForeColor:	TColor;FForeLineColor: TColor;FForeStyle: TPCColorStyle;
FMax: Integer;FMin: Integer;
FOnProgressDone: TOnProgressDoneEvent;
FOnMouseEnter: TOnMouseEnterEvent;
FOnMouseLeave: TOnMouseLeaveEvent;
FOrientation: TProgressBarOrientation;
FPosition: Longint;
FProEffect: TProEffect;
FShowText: Boolean;
FStep: Integer;
FStopAtMax: Boolean;
FText: String;FTextDone: String;
procedure SetBackBorderColor(Value: TColor);
procedure SetBackColor(Value: TColor);
procedure SetBackStyle(Value: TPCColorStyle);
procedure SetBevelColor(Value: TColor);
procedure SetBevelInner(Value: TBevelCut);
procedure SetBevelOuter(Value: TBevelCut);
procedure SetBevelWidth(Value: TBevelWidth);
procedure SetBorderWidth(Value: TBorderWidth);
procedure SetCylinderEffect(Value: TCylinderEffect);
procedure SetFontEffect(Value: TFontEffect);
procedure SetFontOrientation(Value: TFontOrientation);
procedure SetFontShadowColor(Value: TColor);
procedure SetForeColor(Value: TColor);
procedure SetForeLineColor(Value: TColor);
procedure SetForeStyle(Value: TPCColorStyle);
procedure SetMax(Value: Integer);
procedure SetMin(Value: Integer);
procedure SetOrientation(Value: TProgressBarOrientation);
procedure SetPosition(Value: Longint);
procedure SetProEffect(Value: TProEffect);
procedure SetShowText(Value: Boolean);
procedure SetStep(Value: Integer);
procedure SetText(Value: String);
procedure SetTextDone(Value: String);
procedure CMSysColorChange(var Message: TMessage); message CM_SYSCOLORCHANGE;
procedure CMMouseEnter(var AMsg: TMessage); message CM_MOUSEENTER;
procedure CMMouseLeave(var AMsg: TMessage); message CM_MOUSELEAVE;
procedure PaintHorz;
procedure PaintVert;
procedure PaintText;
procedure PaintInvertText;
procedure PaintBevel;
procedure ResetBevel;
procedure ResetBorder;
procedure ResetColor;
procedure ResetFont(WasShowing, WasInvert: Boolean);
function  TestBorder: Boolean;
function  ValidateRGB(iC: Integer): Integer;
protected
procedure Paint; override;
procedure Resize; override;
procedure WMEraseBkgnd(var Message: TWMEraseBkgnd); message WM_ERASEBKGND;
public
property Progress: Longint read FPosition write SetPosition;
procedure StepIt; overload;
procedure StepIt(Value: Integer); overload;
procedure AddProgress; overload;
procedure AddProgress(value: Integer); overload;
constructor Create(AOwner: TComponent); override;
destructor Destroy; override;
published
property Align;
property Anchors;
property BackBorderColor: TColor read FBackBorderColor write SetBackBorderColor;
property BackColor: TColor read FBackColor write SetBackColor;
property BackStyle: TPCColorStyle read FBackStyle write SetBackStyle;
property BevelColor: TColor read FBevelColor write SetBevelColor;
property BevelInner: TBevelCut read FBevelInner write SetBevelInner;
property BevelOuter: TBevelCut read FBevelOuter write SetBevelOuter;
property BevelWidth: TBevelWidth read FBevelWidth write SetBevelWidth;
property BorderWidth: TBorderWidth read FBorderWidth write SetBorderWidth;
property Color;
property Constraints;
property Cursor;
property CylinderEffect: TCylinderEffect read FCylinderEffect write SetCylinderEffect;
property DragCursor;
property DragKind;
property DragMode;
property Enabled;
property Font;
property FontEffect: TFontEffect read FFontEffect write SetFontEffect;
property FontOrientation: TFontOrientation read FFontOrientation write SetFontOrientation;
property FontShadowColor: TColor read FFontShadowColor write SetFontShadowColor;
property ForeColor: TColor read FForeColor write SetForeColor;
property ForeLineColor: TColor read FForeLineColor write SetForeLineColor;
property ForeStyle: TPCColorStyle read FForeStyle write SetForeStyle;
property Height;
property Hint;
property Left;
property Max: Integer read FMax write SetMax default 1;
property Min: Integer read FMin write SetMin default 0;
property Name;
property Orientation: TProgressBarOrientation read FOrientation write SetOrientation;
property ParentFont;
property ParentShowHint;
property PopupMenu;
property Position: Longint read FPosition write SetPosition;
property ProEffect: TProEffect read FProEffect write SetProEffect;
property ShowHint;
property ShowText: Boolean read FShowText write SetShowText;
property Text: String read FText write SetText;
property TextDone: String read FTextDone write SetTextDone;
property Step: Integer read FStep write SetStep;
property StopAtMax: Boolean read FStopAtMax write FStopAtMax;
property Tag;
property Top;
property Visible;
property Width;
property OnClick;
property OnDblClick;
property OnDragOver;
property OnDragDrop;
property OnEndDock;
property OnEndDrag;
property OnMouseDown;
property OnMouseEnter: TOnMouseEnterEvent read FOnMouseEnter write FOnMouseEnter;
property OnMouseLeave: TOnMouseLeaveEvent read FOnMouseLeave write FOnMouseLeave;
property OnMouseMove;
property OnMouseUp;
property OnProgressDone: TOnProgressDoneEvent read FOnProgressDone write FOnProgressDone;
property OnResize;
property OnStartDock;
property OnStartDrag;
end;
implementation
constructor  TPCColorStyle.Create(AOwner: TProgressCyl);
begin
inherited Create;
FProgressCyl := AOwner;
FIntensityRGB := 255;
FIntensity := 4.0;
FIntensityFactor := -1.0;
FRangeRGB := 255;
FColorRGB := 255;
FColorFactor := -1.0;
FLightAngle := -3.0;
end;
procedure TPCColorStyle.SetIntensityRGB(Value: Integer);
begin
if FIntensityRGB <> Value then
begin
FIntensityRGB := Value;
FProgressCyl.ResetColor;
end;
end;
procedure TPCColorStyle.SetIntensity(Value: Single);
begin
if (FIntensity <> Value) and (Value <> 0) then
begin
FIntensity := Value;
FProgressCyl.ResetColor;
end;
end;
procedure TPCColorStyle.SetIntensityFactor(Value: Single);
begin
if FIntensityFactor <> Value then
begin
FIntensityFactor := Value;
FProgressCyl.ResetColor;
end;
end;
procedure TPCColorStyle.SetRangeRGB(Value: Integer);
begin
if (FRangeRGB <> Value) and (Value <> 0) then
begin
FRangeRGB := Value;
FProgressCyl.ResetColor;
end;
end;
procedure TPCColorStyle.SetColorRGB(Value: Integer);
begin
if FColorRGB <> Value then
begin
FColorRGB := Value;
FProgressCyl.ResetColor;
end;
end;
procedure TPCColorStyle.SetColorFactor(Value: Single);
begin
if FColorFactor <> Value then
begin
FColorFactor := Value;
FProgressCyl.ResetColor;
end;
end;
procedure TPCColorStyle.SetLightAngle(Value: Single);
begin
if (FLightAngle <> Value) and (Value <> 0) then
begin
FLightAngle := Value;
FProgressCyl.ResetColor;
end;
end;
constructor TProgressCyl.Create(AOwner: TComponent);
begin
FInit := false;
inherited Create(AOwner);
ControlStyle := ControlStyle + [csFramed, csOpaque];
Width := DEFWIDTH;
Height := DEFHEIGHT;
FBmpShow := TBitmap.Create;
FBmpShow.PixelFormat := pf24bit;
Font.Name := DEFFONT;
Font.Size := DEFFONTSIZE;
Font.Style := [DEFFONTSTYLE];
Font.Color := DEFFONTCOLOR;
Text := DEFTEXT;
TextDone := DEFTEXTDONE;
FontEffect := DEFFONTEFFECT;
FontShadowColor := DEFFONTSHADOWCOLOR;
FontOrientation := DEFFONTORIENTATION;
ShowText := DEFSHOWTEXT;
Min := DEFMIN;
Max := DEFMAX;
Step := DEFSTEP;
FForeStyle := TPCColorStyle.Create(self);
FBackStyle := TPCColorStyle.Create(self);
SetForeStyle(ForeStyle);
SetBackStyle(BackStyle);
Orientation := DEFORIENTATION;
BevelOuter := DEFBEVELOUTER;
BorderWidth := DEFBORDERWIDTH;
BevelWidth := DEFBEVELWIDTH;
BevelInner := DEFBEVELINNER;
FStopAtMax := DEFSTOPATMAX;
BackColor := DEFBACKCOLOR;
BackBorderColor := DEFBACKBORDERCOLOR;
ForeLineColor := DEFFORELINECOLOR;;
ForeColor := DEFFORECOLOR;
FLastPos := DEFMIN;
Position := DEFMIN;
CylinderEffect := DEFCYLINDEREFFECT;
FInit := true;
Color := DEFCOLOR;
BevelColor := DEFBEVELCOLOR;
end;
procedure TProgressCyl.SetText(Value: String);
begin
if FText <> Value then
begin
FText := Value;
Refresh;
end;
end;
procedure TProgressCyl.SetTextDone(Value: String);
begin
if FTextDone <> Value then
begin
FTextDone := Value;
Refresh;
end;
end;
procedure TProgressCyl.SetFontEffect(Value: TFontEffect);
var
WasInvert : Boolean;
procedure InvertFree;
begin
if FFontEffect = feInvert then
begin
FbmpFont.Free;
end;
end;
begin
if FFontEffect <> Value then
begin
WasInvert := (FFontEffect=feInvert);
FFontEffect := Value;
ResetFont(FShowText, WasInvert);
end;
end;
procedure TProgressCyl.SetShowText(Value: Boolean);
var
WasShowing : Boolean;
begin
if FShowText <> Value then
begin
WasShowing := FShowText;
FShowText := Value;
ResetFont(WasShowing, (FFontEffect=feInvert));
Refresh;
end;
end;
procedure TProgressCyl.SetFontOrientation(Value: TFontOrientation);
begin
if FFontOrientation <> Value then
begin
FFontOrientation := Value;
ResetFont(FShowText, (FFontEffect=feInvert));
Refresh;
end;
end;
procedure TProgressCyl.ResetFont(WasShowing, WasInvert: Boolean);
begin
if (WasShowing) then
begin
if (WasInvert) then
FbmpFont.Free;
if (FShowText) then ResetFont(false,false);
end
else if (FShowText) then
begin
if FFontEffect = feInvert then
begin
FbmpFont := TBitmap.Create;
FbmpFont.PixelFormat := pf24bit;
FbmpFont.Width := FBmpShow.Width;
FbmpFont.Height := FBmpShow.Height;
end
else if FFontEffect = feShadowTopLeft then FFontFXFactor := -1
else if FFontEffect = feShadowBottomRight then FFontFXFactor := 1
else FFontFXFactor := 0;
end;
Refresh;
end;
procedure TProgressCyl.PaintText;
var
strText             : String;
iX, iY              : Integer;
FontInfo            : TLogFont;
NewFont, OldFont    : HFont;
procedure AccessTheFont;
begin
FBmpShow.Canvas.Font := Self.Font;
LStrCpy(FontInfo.lfFaceName, PChar(FBmpShow.Canvas.Font.Name));
FontInfo.lfHeight := FBmpShow.Canvas.Font.Height;
FontInfo.lfWidth := 0;
FontInfo.lfCharSet := FBmpShow.Canvas.Font.Charset;
if fsBold in FBmpShow.Canvas.Font.Style then FontInfo.lfWeight := FW_BOLD
else FontInfo.lfWeight := FW_NORMAL;
if fsItalic in FBmpShow.Canvas.Font.Style then FontInfo.lfItalic := 1
else FontInfo.lfItalic := 0;
if fsUnderline in FBmpShow.Canvas.Font.Style then FontInfo.lfUnderline := 1
else FontInfo.lfUnderline := 0;
if fsStrikeOut in FBmpShow.Canvas.Font.Style then FontInfo.lfStrikeOut := 1
else FontInfo.lfStrikeOut := 0;
end;
procedure CreateTheFont(iFO: Integer);
begin
FontInfo.lfEscapement := iFO;
FontInfo.lfOrientation := iFO;
end;
begin
FBmpShow.Canvas.Brush.Style := bsClear;
AccessTheFont;
if (FTextDone <> '') and (FPourcent = 100) then strText := FTextDone
else strText := IntToStr(FPourcent) + FText;
if FFontOrientation = foTopToBottom then
begin
CreateTheFont(TEXTTOPTOBOTTOM);
iX := FBmpShow.Canvas.TextHeight(strText) + (FOutR - FBmpShow.Canvas.TextHeight(strText)) div 2 - 1;
iY := (FOutB - FBmpShow.Canvas.TextWidth(strText)) div 2;
end
else if FFontOrientation = foBottomToTop then
begin
CreateTheFont(TEXTBOTTOMTOTOP);
iX := (FOutR - FBmpShow.Canvas.TextHeight(strText)) div 2 + 1;
iY := FBmpShow.Canvas.TextWidth(strText) + (FOutB - FBmpShow.Canvas.TextWidth(strText)) div 2;
end
else
begin
CreateTheFont(TEXTLEFTTORIGHT);
iX := (FOutR - FBmpShow.Canvas.TextWidth(strText)) div 2;
iY := (FOutB - FBmpShow.Canvas.TextHeight(strText)) div 2 + 1;
end;
NewFont := CreateFontIndirect(FontInfo);
OldFont := SelectObject(FBmpShow.Canvas.Handle, NewFont);
if FFontEffect <> feNone then
begin
SetTextColor(FBmpShow.Canvas.Handle, ColorToRGB(FontShadowColor));
FBmpShow.Canvas.TextRect(Rect(FOutTL,FOutTL,FOutR,FOutB), iX+FFontFXFactor, iY+FFontFXFactor, strText);
end;
SetTextColor(FBmpShow.Canvas.Handle, ColorToRGB(FBmpShow.Canvas.Font.Color));
FBmpShow.Canvas.TextRect(Rect(FOutTL,FOutTL,FOutR,FOutB), iX, iY, strText);
SelectObject(FBmpShow.Canvas.Handle, OldFont);
DeleteObject(NewFont);
end;
procedure TProgressCyl.PaintInvertText;
var
strText             : String;
iX, iY              : Integer;
FontInfo            : TLogFont;
NewFont, OldFont    : HFont;
procedure AccessTheInvertFont;
begin
FbmpFont.Canvas.Font := Self.Font;
LStrCpy(FontInfo.lfFaceName, PChar(FbmpFont.Canvas.Font.Name));
FontInfo.lfHeight := FbmpFont.Canvas.Font.Height;
FontInfo.lfWidth := 0;
FontInfo.lfCharSet := FbmpFont.Canvas.Font.Charset;
if fsBold in FbmpFont.Canvas.Font.Style then FontInfo.lfWeight := FW_BOLD
else FontInfo.lfWeight := FW_NORMAL;
if fsItalic in FbmpFont.Canvas.Font.Style then FontInfo.lfItalic := 1
else FontInfo.lfItalic := 0;
if fsUnderline in FbmpFont.Canvas.Font.Style then FontInfo.lfUnderline := 1
else FontInfo.lfUnderline := 0;
if fsStrikeOut in FbmpFont.Canvas.Font.Style then FontInfo.lfStrikeOut := 1
else FontInfo.lfStrikeOut := 0;
end;
procedure CreateTheInvertFont(iFO: Integer);
begin
FontInfo.lfEscapement := iFO;
FontInfo.lfOrientation := iFO;
end;
begin
FbmpFont.Width := FBmpShow.Width;
FbmpFont.Height := FBmpShow.Height;
FbmpFont.Canvas.CopyMode := cmBlackness;
FbmpFont.Canvas.CopyRect(Rect(0, 0, Width, Height), FbmpFont.Canvas, Rect(0, 0, Width, Height));
FbmpFont.Canvas.CopyMode := cmSrcCopy;
FbmpFont.Canvas.Brush.Style := bsClear;
AccessTheInvertFont;
if (FTextDone <> '') and (FPourcent = 100) then strText := FTextDone
else strText := IntToStr(FPourcent) + FText;
if FFontOrientation = foTopToBottom then
begin
CreateTheInvertFont(TEXTTOPTOBOTTOM);
iX := FbmpFont.Canvas.TextHeight(strText) + (FOutR - FbmpFont.Canvas.TextHeight(strText)) div 2 - 1;
iY := (FOutB - FbmpFont.Canvas.TextWidth(strText)) div 2;
end
else if FFontOrientation = foBottomToTop then
begin
CreateTheInvertFont(TEXTBOTTOMTOTOP);
iX := (FOutR - FbmpFont.Canvas.TextHeight(strText)) div 2 + 1;
iY := FbmpFont.Canvas.TextWidth(strText) + (FOutB - FbmpFont.Canvas.TextWidth(strText)) div 2;
end
else
begin
CreateTheInvertFont(TEXTLEFTTORIGHT);
iX := (FOutR - FbmpFont.Canvas.TextWidth(strText)) div 2;
iY := (FOutB - FbmpFont.Canvas.TextHeight(strText)) div 2 + 1;
end;
NewFont := CreateFontIndirect(FontInfo);
OldFont := SelectObject(FbmpFont.Canvas.Handle, NewFont);
SetTextColor(FbmpFont.Canvas.Handle, clWhite);
FbmpFont.Canvas.TextRect(Rect(FOutTL,FOutTL,FOutR,FOutB), iX, iY, strText);
SelectObject(FbmpFont.Canvas.Handle, OldFont);
DeleteObject(NewFont);
FBmpShow.Canvas.CopyMode := cmSrcInvert;
FBmpShow.Canvas.Draw(0, 0, FbmpFont);
FBmpShow.Canvas.CopyMode := cmSrcCopy;
end;
destructor TProgressCyl.Destroy;
begin
ShowText := false;
inherited Destroy;
FBmpShow.Free;
end;
procedure TProgressCyl.Paint;
begin
if (FInit) then
begin
FBmpShow.Height := Height;
FBmpShow.Width 	:= Width;
if FOrientation = pbHorizontal then
PaintHorz
else
PaintVert;
if (FShowText) then
if FFontEffect = feInvert then
PaintInvertText
else
PaintText;
Canvas.Draw(0, 0, FBmpShow);
end;
end;
procedure TProgressCyl.PaintHorz;
var
iX,iY,iKF,iTF,iKB,iTB : Integer;
pScan               : ^TPCScan;
begin
with FBmpShow.Canvas do
begin
Brush.Color := Color;
FillRect(Rect(FOutTL,FOutTL,FOutR,FOutB));
end;
iTF := Trunc((FCylB-FCylTL)/FForeStyle.LightAngle);
iKF := iTF;
iTB := Trunc((FCylB-FCylTL)/FBackStyle.LightAngle);
iKB := iTB;
for iY := FCylTL to FCylB - 1 do
begin
pScan := FBmpShow.Scanline[iY];
for iX := FCylTL to FLinePos do
begin
pScan[iX].rgbtRed := ValidateRGB(Trunc((FForeStyle.ColorRGB+(Abs(iKF)*FPaceH)*FForeStyle.ColorFactor)*FFactorFR));
pScan[iX].rgbtGreen := ValidateRGB(Trunc((FForeStyle.ColorRGB+(Abs(iKF)*FPaceH)*FForeStyle.ColorFactor)*FFactorFG));
pScan[iX].rgbtBlue := ValidateRGB(Trunc((FForeStyle.ColorRGB+(Abs(iKF)*FPaceH)*FForeStyle.ColorFactor)*FFactorFB));
end;
pScan[FLinePos].rgbtRed := ValidateRGB(Trunc((FForeStyle.ColorRGB+(Abs(iKF)*FPaceH)*FForeStyle.ColorFactor)*FFactorLR));
pScan[FLinePos].rgbtGreen := ValidateRGB(Trunc((FForeStyle.ColorRGB+(Abs(iKF)*FPaceH)*FForeStyle.ColorFactor)*FFactorLG));
pScan[FLinePos].rgbtBlue := ValidateRGB(Trunc((FForeStyle.ColorRGB+(Abs(iKF)*FPaceH)*FForeStyle.ColorFactor)*FFactorLB));
for iX := FLinePos+1 to FCylR-1 do
begin
pScan[iX].rgbtRed := ValidateRGB(Trunc((FBackStyle.ColorRGB+(Abs(iKB)*FPaceH)*FBackStyle.ColorFactor)*FFactorBR));
pScan[iX].rgbtGreen := ValidateRGB(Trunc((FBackStyle.ColorRGB+(Abs(iKB)*FPaceH)*FBackStyle.ColorFactor)*FFactorBG));
pScan[iX].rgbtBlue := ValidateRGB(Trunc((FBackStyle.ColorRGB+(Abs(iKB)*FPaceH)*FBackStyle.ColorFactor)*FFactorBB));
end;
iKF := iKF + 1;
iKB := iKB + 1;
end;
PaintBevel;
end;
procedure TProgressCyl.PaintVert;
var
iX,iY,iKF,iTF,iKB,iTB : Integer;
pScan               : ^TPCScan;
begin
with FBmpShow.Canvas do
begin
Brush.Color := Color;
FillRect(Rect(FOutTL,FOutTL,FOutR,FOutB));
end;
iTF := Trunc((FCylR-FCylTL)/FForeStyle.LightAngle);
iTB := Trunc((FCylR-FCylTL)/FBackStyle.LightAngle);
for iY := FCylTL to FLinePos do
begin
pScan := FBmpShow.Scanline[iY];
iKB := iTB;
for iX := FCylTL to FCylR-1 do
begin
pScan[iX].rgbtRed := ValidateRGB(Trunc((FBackStyle.ColorRGB+(Abs(iKB)*FPaceV)*FBackStyle.ColorFactor)*FFactorBR));
pScan[iX].rgbtGreen := ValidateRGB(Trunc((FBackStyle.ColorRGB+(Abs(iKB)*FPaceV)*FBackStyle.ColorFactor)*FFactorBG));
pScan[iX].rgbtBlue := ValidateRGB(Trunc((FBackStyle.ColorRGB+(Abs(iKB)*FPaceV)*FBackStyle.ColorFactor)*FFactorBB));
iKB := iKB + 1;
end;
end;
pScan := FBmpShow.Scanline[FLinePos];
iKF := iTF;
for iX := FCylTL to FCylR-1 do
begin
pScan[iX].rgbtRed := ValidateRGB(Trunc((FForeStyle.ColorRGB+(Abs(iKF)*FPaceV)*FForeStyle.ColorFactor)*FFactorLR));
pScan[iX].rgbtGreen := ValidateRGB(Trunc((FForeStyle.ColorRGB+(Abs(iKF)*FPaceV)*FForeStyle.ColorFactor)*FFactorLG));
pScan[iX].rgbtBlue := ValidateRGB(Trunc((FForeStyle.ColorRGB+(Abs(iKF)*FPaceV)*FForeStyle.ColorFactor)*FFactorLB));
iKF := iKF + 1;
end;
for iY := FLinePos+1 to FCylB-1 do
begin
pScan := FBmpShow.Scanline[iY];
iKF := iTF;
for iX := FCylTL to FCylR-1 do
begin
pScan[iX].rgbtRed := ValidateRGB(Trunc((FForeStyle.ColorRGB+(Abs(iKF)*FPaceV)*FForeStyle.ColorFactor)*FFactorFR));
pScan[iX].rgbtGreen := ValidateRGB(Trunc((FForeStyle.ColorRGB+(Abs(iKF)*FPaceV)*FForeStyle.ColorFactor)*FFactorFG));
pScan[iX].rgbtBlue := ValidateRGB(Trunc((FForeStyle.ColorRGB+(Abs(iKF)*FPaceV)*FForeStyle.ColorFactor)*FFactorFB));
iKF := iKF + 1;
end;
end;
PaintBevel;
end;
procedure  TProgressCyl.PaintBevel;
var
rctTmp: TRect;
begin
rctTmp := Rect(FCylTL,FCylTL,FCylR,FCylB);
Frame3D(FBmpShow.Canvas, rctTmp, FBackBorderColor, FBackBorderColor, 1);
rctTmp := Rect(FInnTL,FInnTL,FInnR,FInnB);
if FBevelInner <> bvNone then Frame3D(FBmpShow.Canvas, rctTmp, FColInnTL, FColInnBR, FBevelWidth);
rctTmp := Rect(FOutTL,FOutTL,FOutR,FOutB);
if FBevelOuter <> bvNone then Frame3D(FBmpShow.Canvas, rctTmp, FColOutTL, FColOutBR, FBevelWidth);
end;
procedure TProgressCyl.SetForeColor(Value: TColor);
begin
FForeColor := Value;
FFactorFR := (((FForeStyle.IntensityRGB+(GetRValue(ColorToRGB(Value))*FForeStyle.IntensityFactor))
/FForeStyle.Intensity)+GetRValue(ColorToRGB(Value)))/FForeStyle.RangeRGB;
FFactorFG := (((FForeStyle.IntensityRGB+(GetGValue(ColorToRGB(Value))*FForeStyle.IntensityFactor))
/FForeStyle.Intensity)+GetGValue(ColorToRGB(Value)))/FForeStyle.RangeRGB;
FFactorFB := (((FForeStyle.IntensityRGB+(GetBValue(ColorToRGB(Value))*FForeStyle.IntensityFactor))
/FForeStyle.Intensity)+GetBValue(ColorToRGB(Value)))/FForeStyle.RangeRGB;
Refresh;
end;
procedure TProgressCyl.SetForeLineColor(Value: TColor);
begin
FForeLineColor := Value;
FFactorLR := (((FForeStyle.IntensityRGB+(GetRValue(ColorToRGB(Value))*FForeStyle.IntensityFactor) )
/FForeStyle.Intensity)+GetRValue(ColorToRGB(Value)))/FForeStyle.RangeRGB;
FFactorLG := (((FForeStyle.IntensityRGB+(GetGValue(ColorToRGB(Value))*FForeStyle.IntensityFactor))
/FForeStyle.Intensity)+GetGValue(ColorToRGB(Value)))/FForeStyle.RangeRGB;
FFactorLB := (((FForeStyle.IntensityRGB+(GetBValue(ColorToRGB(Value))*FForeStyle.IntensityFactor))
/FForeStyle.Intensity)+GetBValue(ColorToRGB(Value)))/FForeStyle.RangeRGB;
Refresh;
end;
procedure TProgressCyl.SetBackColor(Value: TColor);
begin
FBackColor := Value;
FFactorBR := (((FBackStyle.IntensityRGB+(GetRValue(ColorToRGB(Value))*FBackStyle.IntensityFactor))
/FBackStyle.Intensity)+GetRValue(ColorToRGB(Value)))/FBackStyle.RangeRGB;
FFactorBG := (((FBackStyle.IntensityRGB+(GetGValue(ColorToRGB(Value))*FBackStyle.IntensityFactor))
/FBackStyle.Intensity)+GetGValue(ColorToRGB(Value)))/FBackStyle.RangeRGB;
FFactorBB := (((FBackStyle.IntensityRGB+(GetBValue(ColorToRGB(Value))*FBackStyle.IntensityFactor))
/FBackStyle.Intensity)+GetBValue(ColorToRGB(Value)))/FBackStyle.RangeRGB;
Refresh;
end;
procedure TProgressCyl.SetBevelColor(Value: TColor);
begin
FBevelColor := Value;
if FBevelColor = clBtnFace then
begin
FclBtnHighlight := clBtnHighLight;
FclBtnShadow := clBtnShadow;
Fcl3DLight := cl3DLight;
Fcl3DDkShadow := cl3DDkShadow;
end
else
begin
FclBtnHighlight := RGB(ValidateRGB(GetRValue(ColorToRGB(Value))+BEVELFACTOR),
ValidateRGB(GetGValue(ColorToRGB(Value))+BEVELFACTOR),
ValidateRGB(GetBValue(ColorToRGB(Value))+BEVELFACTOR));
FclBtnShadow := RGB(ValidateRGB(GetRValue(ColorToRGB(Value))-BEVELFACTOR),
ValidateRGB(GetGValue(ColorToRGB(Value))-BEVELFACTOR),
ValidateRGB(GetBValue(ColorToRGB(Value))-BEVELFACTOR));
Fcl3DLight := FclBtnHighlight;
Fcl3DDkShadow := FclBtnShadow;
end;
ResetBevel;
Refresh;
end;
procedure TProgressCyl.ResetBevel;
begin
if FBevelInner = bvSpace then
begin
FColInnTL := Color;
FColInnBR := Color;
end
else if FBevelInner = bvLowered then
begin
if (FBevelOuter = bvLowered) and (FBorderWidth = 0) then
begin
FColInnTL := Fcl3DDkShadow;
FColInnBR := Fcl3DLight;
end
else
begin
FColInnTL := FclBtnShadow;
FColInnBR := FclBtnHighlight;
end;
end
else if FBevelInner = bvRaised then
begin
if (FBevelOuter = bvRaised) and (FBorderWidth = 0) then
FColInnTL := Fcl3DLight
else
FColInnTL := FclBtnHighlight;
FColInnBR := FclBtnShadow;
end;
if FBevelOuter = bvSpace then
begin
FColOutTL := Color;
FColOutBR := Color;
end
else if FBevelOuter = bvLowered then
begin
FColOutTL := FclBtnShadow;
FColOutBR := FclBtnHighlight;
end
else if FBevelOuter = bvRaised then
begin
FColOutTL := FclBtnHighlight;
if (FBevelInner = bvRaised) and (FBorderWidth = 0) then
FColOutBR := Fcl3DDkShadow
else
FColOutBR := FclBtnShadow;
end;
ResetBorder;
end;
procedure TProgressCyl.SetBackBorderColor(Value: TColor);
begin
if FBackBorderColor <> Value then
begin
FBackBorderColor := Value;
Refresh;
end;
end;
procedure TProgressCyl.SetFontShadowColor(Value: TColor);
begin
if FFontShadowColor <> Value then
begin
FFontShadowColor := Value;
Refresh;
end;
end;
procedure TProgressCyl.ResetColor;
begin
SetForeColor(FForeColor);
SetForeLineColor(FForeLineColor);
SetFontShadowColor(FFontShadowColor);
SetBackColor(FBackColor);
SetBackBorderColor(FBackBorderColor);
SetBevelColor(FBevelColor);
end;
function  TProgressCyl.ValidateRGB(iC: Integer): Integer;
begin
if iC>MAXRGB then iC:=MAXRGB else if iC<0 then iC:=0;
result:=iC;
end;
procedure TProgressCyl.SetPosition(Value: Longint);
var
FPaintPos: Integer;
begin
if Value > FMax then FPosition := FMax
else if Value < FMin then FPosition := FMin
else FPosition := Value;
APosition := FPosition - FMin;
FPourcent := Round((APosition/(FMax-FMin))*100);
if (FOrientation = pbHorizontal) then
begin
FPaintPos := FCylTL * 2 + Integer(Round(Width*APosition*FRange))
- Integer(Round(FCylTL*APosition*FRange*2));
FLinePos := FPaintPos-FCylTL;
if (FLinePos < FCylTL+1) then FLinePos := FCylTL+1;
end
else
begin
FPaintPos := FCylTL * 2 + Integer(Round(Height*APosition*FRange))
- Integer(Round(FCylTL*2*APosition*FRange));
FLinePos := FCylB-(FPaintPos-(FCylTL*2));
if (FCylTL > FCylB-1) then FCylTL := FCylB-1;
end;
if (FLastPos <> FPaintPos) or (FLastPour <> FPourcent) then
begin
FLastPos := FPaintPos;
FLastPour := FPourcent;
if FPosition = FMax then
if Assigned(FOnProgressDone) then FOnProgressDone(Self);
Refresh;
end;
end;
function TProgressCyl.TestBorder: Boolean;
begin
result := false;
if (Width < 1) or (Height < 1) then Exit;
FOutTL  := 0;
FOutR   := Width;
FOutB   := Height;
FInnTL  := FBevelWidth + BorderWidth;
FInnR   := Width - FInnTL;
FInnB   := Height - FInnTL;
if (FInnB-FInnTL < 1) or (FInnR-FInnTL < 1) then Exit;
FCylTL  := (FBevelWidth*2) + BorderWidth;
FCylR   := Width - FCylTL;
FCylB   := Height - FCylTL;
if (FCylB-FCylTL < 1) or (FCylR-FCylTL < 1) then Exit;
result := true;
end;
procedure TProgressCyl.ResetBorder;
begin
FOutTL:=0;FOutR:=Width;FOutB:=Height;
FInnTL:=FBevelWidth+FBorderWidth;FInnR:=Width-FInnTL;FInnB:=Height-FInnTL;
FCylTL:=(FBevelWidth*2)+BorderWidth;FCylR:=Width-FCylTL;FCylB:=Height-FCylTL;
if(FCylR-FCylTL>0)then FPaceH:=FCylFXFactor div(FCylB-FCylTL);
if(FCylR-FCylTL>0)then FPaceV:=FCylFXFactor div(FCylR-FCylTL);
SetPosition(FPosition);
end;
procedure TProgressCyl.SetMax(Value: Integer);
begin
if FMax <> Value then
begin
if Value = FMin then Value := Value + 1;
if Value > FMin then
begin
FMax := Value;
FRange := 1/(FMax-FMin);
if FPosition > FMax then FPosition := FMax;
end;
ResetBorder;
end;
end;
procedure TProgressCyl.SetMin(Value: Integer);
begin
if FMin <> Value then
begin
if Value = FMax then Value := Value - 1;
if Value < FMax then
begin
FMin := Value;
FRange := 1/(FMax - FMin);
if FPosition < FMin then FPosition := FMin;
end;
ResetBorder;
end;
end;
procedure TProgressCyl.SetStep(Value: Integer);
begin
if FStep <> Value then
FStep := Value;
end;
procedure TProgressCyl.StepIt;
begin
FPosition := FPosition + FStep;
if FPosition > FMax then
begin
if (FStopAtMax) then
FPosition := FMax
else
FPosition := FPosition-FMax;
end;
SetPosition(FPosition);
end;
procedure TProgressCyl.StepIt(Value: Integer);
begin
FPosition := FPosition + Value;
if FPosition > FMax then
begin
if (FStopAtMax) then
FPosition := FMax
else
FPosition := FPosition-FMax;
end;
SetPosition(FPosition);
end;
procedure TProgressCyl.AddProgress;
begin
StepIt;
end;
procedure TProgressCyl.AddProgress(value: Integer);
begin
StepIt(Value);
end;
procedure TProgressCyl.SetBevelInner(Value: TBevelCut);
var
FTmp:       TBevelCut;
begin
if FbevelInner <> Value then
begin
FTmp := FBevelInner;
FBevelInner := Value;
if not (TestBorder) then FBevelInner := FTmp;
ResetBevel;
Refresh;
end;
end;
procedure TProgressCyl.SetBevelOuter(Value: TBevelCut);
var
FTmp:       TBevelCut;
begin
if FbevelOuter <> Value then
begin
FTmp := FBevelOuter;
FBevelOuter := Value;
if not (TestBorder) then FBevelOuter := FTmp;
ResetBevel;
Refresh;
end;
end;
procedure TProgressCyl.SetBevelWidth(Value: TBevelWidth);
var
FTmp:       TBevelWidth;
begin
if FBevelWidth <> Value then
begin
FTmp := FBevelWidth;
FBevelWidth := Value;
if not (TestBorder) then FBevelWidth := FTmp;
ResetBevel;
Refresh;
end;
end;
procedure TProgressCyl.SetBorderWidth(Value: TBorderWidth);
var
FTmp:       TBorderWidth;
begin
if FBorderWidth <> Value then
begin
FTmp := FBorderWidth;
FBorderWidth := Value;
if not (TestBorder) then FBorderWidth := FTmp;
ResetBevel;
Refresh;
end;
end;
procedure TProgressCyl.SetCylinderEffect(Value: TCylinderEffect);
begin
if FCylinderEffect <> Value then
begin
case Value of
ceFlat: FCylFXFactor := F_EFFECT;
ceUltraLow: FCylFXFactor := UL_EFFECT;
ceLow: FCylFXFactor := L_EFFECT;
ceMedium: FCylFXFactor := M_EFFECT;
ceHigh: FCylFXFactor := H_EFFECT;
else
FCylFXFactor := X_EFFECT;
end;
FCylinderEffect := Value;
ResetBorder;
Refresh;
end;
end;
procedure TProgressCyl.SetBackStyle(Value: TPCColorStyle);
begin
with FBackStyle do
begin
IntensityRGB := Value.IntensityRGB;
Intensity := Value.Intensity;
IntensityFactor := Value.IntensityFactor;
RangeRGB := Value.RangeRGB;
ColorRGB := Value.ColorRGB;
ColorFactor := Value.ColorFactor;
LightAngle := Value.LightAngle;
end;
end;
procedure TProgressCyl.SetForeStyle(Value: TPCColorStyle);
begin
with FForeStyle do
begin
IntensityRGB := Value.IntensityRGB;
Intensity := Value.Intensity;
IntensityFactor := Value.IntensityFactor;
RangeRGB := Value.RangeRGB;
ColorRGB := Value.ColorRGB;
ColorFactor := Value.ColorFactor;
LightAngle := Value.LightAngle;
end;
end;
procedure TProgressCyl.SetOrientation(Value: TProgressBarOrientation);
begin
if FOrientation <> Value then
begin
FOrientation := Value;
if FOrientation = pbHorizontal then
FFontOrientation := foLeftToRight
else
FFontOrientation := foBottomToTop;
ResetBorder;
Refresh;
end;
end;
procedure TprogressCyl.SetProEffect(Value: TProEffect);
begin
case Value of
peSystem:
begin
Visible:=False;
CylinderEffect:=ceMaximum;BevelOuter:=bvLowered;BevelInner:=bvRaised;BorderWidth:=2;
ShowText:=True;Font.Color:=clBlack;FontShadowColor:=clBtnFace;FontEffect:=feShadowBottomRight;
ForeColor:=clBtnFace;BackColor:=clWhite;ForeLineColor:=clHighlight;BackBorderColor:=clBlack;Color:=clBtnFace;BevelColor:=clBtnFace;
FBackStyle.IntensityRGB:=255;FBackStyle.Intensity:=4.0;FBackStyle.IntensityFactor:=-1.0;FBackStyle.RangeRGB:=255;
FBackStyle.ColorRGB:=255;FBackStyle.ColorFactor:=-1.0;FBackStyle.LightAngle:=-3.0;
FForeStyle.IntensityRGB:=255;FForeStyle.Intensity:=4.0;FForeStyle.IntensityFactor:=-1.0;FForeStyle.RangeRGB:=255;
FForeStyle.ColorRGB:=255;FForeStyle.ColorFactor:=-1.0;FForeStyle.LightAngle:=-3.0;
Visible:=True;
end;
peSunken:
begin
Visible:=False;
CylinderEffect:=ceMaximum;BevelOuter:=bvNone;BevelInner:=bvRaised;BorderWidth:=2;
ShowText:=True;Font.Color:=clBlack;FontShadowColor:=clBlack;FontEffect:=feInvert;
ForeColor:=clWhite;BackColor:=clMaroon;ForeLineColor:=clRed;BackBorderColor:=clBlack;Color:=clBtnFace;BevelColor:=clBtnFace;
FBackStyle.IntensityRGB:=255;FBackStyle.Intensity:=2.0;FBackStyle.IntensityFactor:=-1.0;FBackStyle.RangeRGB:=153;
FBackStyle.ColorRGB:=0;FBackStyle.ColorFactor:=1.0;FBackStyle.LightAngle:=-3.0;
FForeStyle.IntensityRGB:=255;FForeStyle.Intensity:=4.0;FForeStyle.IntensityFactor:=-1.0;FForeStyle.RangeRGB:=255;
FForeStyle.ColorRGB:=255;FForeStyle.ColorFactor:=-1.0;FForeStyle.LightAngle:=-3.0;
Visible:=True;
end;
peMetalic:
begin
Visible:=False;
CylinderEffect:=ceMaximum;BevelOuter:=bvNone;BevelInner:=bvLowered;BorderWidth:=2;
ShowText:=False;Font.Color:=clBlack;FontShadowColor:=clWhite;FontEffect:=feShadowBottomRight;
ForeColor:=RGB(127,212,255);BackColor:=clWhite;ForeLineColor:=clBlack;BackBorderColor:=clBlack;Color:=clBtnFace;BevelColor:=clBtnFace;
FBackStyle.IntensityRGB:=-100;FBackStyle.Intensity:=4.0;FBackStyle.IntensityFactor:=-1.7;FBackStyle.RangeRGB:=-100;
FBackStyle.ColorRGB:=-100;FBackStyle.ColorFactor:=-1.0;FBackStyle.LightAngle:=-1.6;
FForeStyle.IntensityRGB:=-100;FForeStyle.Intensity:=4.0;FForeStyle.IntensityFactor:=-1.7;FForeStyle.RangeRGB:=-100;
FForeStyle.ColorRGB:=-100;FForeStyle.ColorFactor:=-1.0;FForeStyle.LightAngle:=-1.6;
Visible:=True;
end;
end;
end;
procedure TProgressCyl.Resize;
begin
if (FInit) and (TestBorder) then
begin
FBmpShow.Height := Height;
FBmpShow.Width 	:= Width;
if (FShowText) and (FFontEffect = feInvert) then
begin
FbmpFont.Width := FBmpShow.Width;
FbmpFont.Height := FBmpShow.Height;
end;
ResetBorder;
Refresh;
end;
end;
procedure TProgressCyl.WMEraseBkgnd(var Message: TWMEraseBkgnd);
begin
//-----
end;
procedure TProgressCyl.CMSysColorChange(var Message: TMessage);
begin
ResetColor;
end;
procedure TProgressCyl.CMMouseEnter(var AMsg: TMessage);
begin
if Assigned(FOnMouseEnter) then FOnMouseEnter(Self);
FMouseIsEntered := True;
Paint;
end;
procedure TProgressCyl.CMMouseLeave(var AMsg: TMessage);
begin
if Assigned(FOnMouseLeave) then FOnMouseLeave(Self);
FMouseIsEntered := False;
Paint;
end;
procedure Register;
begin
RegisterComponents('A9RD', [TProgressCyl]);
end;
end.

