//  Version info Label.
//  Simply install this component through 'Component/Install component' in a new or existing package.
//  Now you can drop this Label anywhere on your Form or any other VCL component. If you switched on
//  by 'Project/Project options/Versioninfo' to include the version info in your executable, this
//  value will be shown by the caption of this label on runtime.
//  this version is tested in Delphi 4.

//  Copyright P. Keus, Jacob van Heemskerkstraat 2, 3223SE Hellevoetsluis tel 0(031)181-323557
//  This source is freeware. As all freeware, i take no responsibility for using this code.

unit VersionLabel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TVersionLabel = class(TCustomLabel)
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(Owner: TComponent); override;
    procedure paint;  override;
  published
    { Published declarations }
    property Align;
    property Alignment;
    property Anchors;
    property AutoSize;
    property BiDiMode;
    property Color;
    property Constraints;
    property Enabled;
    property Font;
    property ParentColor;
    property ParentFont;
    property Visible;
  end;

var
  versie : string;


procedure Register;

implementation

constructor TVersionLabel.create(Owner: TComponent);
var
  Size, Size2: DWord;
  Point, Point2: Pointer;
  prg  : string;
begin
  inherited Create(Owner);
  prg := paramstr(0);
  Size := GetFileVersionInfoSize(PChar (prg), Size2);
  if Size > 0 then
    begin
      GetMem (Point, Size);
      try
        If GetFileVersionInfo (PChar (prg), 0, Size, Point) then
        begin
	     VerQueryValue (Point, '\', Point2, Size2);
	     with TVSFixedFileInfo (Point2^) do
	     begin
                   versie := IntToStr (HiWord (dwFileVersionMS)) + '.' +
                                      IntToStr (LoWord (dwFileVersionMS)) + '.' +
                                      IntToStr (HiWord (dwFileVersionLS)) + '.' +
                                      IntToStr (LoWord (dwFileVersionLS));
             end;
        end
        else
        begin
            versie := 'error';
        end;
      finally
        FreeMem (Point);
      end;
    end
  else
    begin
      versie := 'undefined';
    end;
end;

procedure TVersionLabel.paint;
begin
     if csdesigning in ComponentState then
     begin
          self.caption := 'version info';
     end
     else
         self.caption := versie;
     inherited paint;
end;

procedure Register;
begin
  RegisterComponents('PKeus', [TVersionLabel]);
end;

end.
