unit UniPrv;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Printers, Spin, Buttons, StdCtrls, ComCtrls;

type

  TPreviewScale=(ps100, ps75, ps50, psWidth, psPage);

  TPreview = class(TForm)
    StatusBar1: TStatusBar;
    ScrollBox1: TScrollBox;
    Panel1: TPanel;
    cbScale: TComboBox;
    edPage: TEdit;
    UpDown1: TUpDown;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    btnPrint: TBitBtn;
    btnPrinterSetup: TBitBtn;
    PrinterSetupDialog1: TPrinterSetupDialog;
    PaintSurface: TPaintBox;
    pcBackground: TPaintBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnPrintClick(Sender: TObject);
    procedure UpDown1Click(Sender: TObject; Button: TUDBtnType);
    procedure cbScaleChange(Sender: TObject);
    procedure ScrollBox1MouseWheelDown(Sender: TObject; Shift: TShiftState;
      MousePos: TPoint; var Handled: Boolean);
    procedure ScrollBox1MouseWheelUp(Sender: TObject; Shift: TShiftState;
      MousePos: TPoint; var Handled: Boolean);
    procedure btnPrinterSetupClick(Sender: TObject);
    procedure Image12Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure edPageExit(Sender: TObject);
  private
    { Private declarations }
    function GetGurrentPage: integer;
  public
    { Public declarations }
    MaxPages: integer;
    PrintProcedure: TNotifyEvent;
    PreviewHeight: integer;
    PreviewWidth: integer;
    property CurrentPage: integer read GetGurrentPage;
  end;

const xMarigin=20;
      yMarigin=20;
var
  Preview: TPreview;

implementation


{$R *.DFM}

function TPreview.GetGurrentPage: integer;
begin
Result:=UpDown1.Position;
end;


procedure TPreview.FormClose(Sender: TObject; var Action: TCloseAction);
begin
Action:=caFree;
end;

procedure TPreview.btnPrintClick(Sender: TObject);
begin
if Assigned(PrintProcedure) then PrintProcedure(Self);
end;

procedure TPreview.UpDown1Click(Sender: TObject; Button: TUDBtnType);
begin
ScrollBox1.Repaint;
end;

procedure TPreview.cbScaleChange(Sender: TObject);
begin
case TPreviewScale(cbScale.ItemIndex) of
     ps100: begin
            PreviewHeight:=(Printer.PageHeight*PixelsPerInch) div GetDeviceCaps(Printer.Handle,LogPixelSY);
            PreviewWidth:=(Printer.PageWidth*PixelsPerInch) div GetDeviceCaps(Printer.Handle,LogPixelSX);
            end;
     ps75:  begin
            PreviewHeight:=(Printer.PageHeight*3*PixelsPerInch) div (4*GetDeviceCaps(Printer.Handle,LogPixelSY));
            PreviewWidth:=(Printer.PageWidth*3*PixelsPerInch) div (4*GetDeviceCaps(Printer.Handle,LogPixelSX));
            end;
     ps50:  begin
            PreviewHeight:=(Printer.PageHeight*PixelsPerInch) div (2*GetDeviceCaps(Printer.Handle,LogPixelSY));
            PreviewWidth:=(Printer.PageWidth*PixelsPerInch) div (2*GetDeviceCaps(Printer.Handle,LogPixelSX));
            end;
    psWidth:begin
            PreviewWidth:=ScrollBox1.ClientWidth-(2*xMarigin)-(GetSystemMetrics(SM_CXVSCROLL));
            PreviewHeight:=(Int64(Printer.PageHeight)*PreviewWidth*GetDeviceCaps(Printer.Handle,LogPixelSX)) div (Printer.PageWidth*GetDeviceCaps(Printer.Handle,LogPixelSY));
            end;
    psPage: begin
            PreviewWidth:=ScrollBox1.ClientWidth-(2*xMarigin)-(GetSystemMetrics(SM_CXVSCROLL));
            PreviewHeight:=(Int64(Printer.PageHeight)*PreviewWidth*GetDeviceCaps(Printer.Handle,LogPixelSX)) div (Printer.PageWidth*GetDeviceCaps(Printer.Handle,LogPixelSY));
            if PreviewHeight>(ScrollBox1.ClientHeight-(2*yMarigin)-(GetSystemMetrics(SM_CYHSCROLL))) then
               begin
               PreviewHeight:=(ScrollBox1.ClientHeight-(2*yMarigin)-(GetSystemMetrics(SM_CYHSCROLL)));
               PreviewWidth:=(Int64(Printer.PageWidth)*PreviewHeight*GetDeviceCaps(Printer.Handle,LogPixelSY)) div (Printer.PageHeight*GetDeviceCaps(Printer.Handle,LogPixelSX));
               end;
            end;
    end;
ScrollBox1.HorzScrollBar.Position:=0;
ScrollBox1.VertScrollBar.Position:=0;
PaintSurface.Width:=PreviewWidth;
PaintSurface.Height:=PreviewHeight;
PaintSurface.Left:=xMarigin;
PaintSurface.Top:=yMarigin;
pcBackGround.Left:=xMarigin;
pcBackGround.Top:=yMarigin;
pcBackground.Width:=PaintSurface.Width+xMarigin;
pcBackground.Height:=PaintSurface.Height+yMarigin;
end;

procedure TPreview.ScrollBox1MouseWheelDown(Sender: TObject;
  Shift: TShiftState; MousePos: TPoint; var Handled: Boolean);
begin
ScrollBox1.VertScrollBar.Position:=ScrollBox1.VertScrollBar.Position+ScrollBox1.VertScrollBar.Increment*2;
end;

procedure TPreview.ScrollBox1MouseWheelUp(Sender: TObject;
  Shift: TShiftState; MousePos: TPoint; var Handled: Boolean);
begin
ScrollBox1.VertScrollBar.Position:=ScrollBox1.VertScrollBar.Position-ScrollBox1.VertScrollBar.Increment*2;
end;

procedure TPreview.btnPrinterSetupClick(Sender: TObject);
begin
if PrinterSetupDialog1.Execute then
   cbScaleChange(Sender);
end;

procedure TPreview.Image12Click(Sender: TObject);
begin
btnPrint.SetFocus;
end;

procedure TPreview.FormShow(Sender: TObject);
begin
cbScale.ItemIndex:=3;
cbScaleChange(Self);
ActiveControl:=btnPrint;
btnPrint.Enabled:=Assigned(PrintProcedure);
UpDown1.Max:=MaxPages;
end;

procedure TPreview.edPageExit(Sender: TObject);
begin
UpDown1.Position:=StrToIntDef(edPage.Text, 1);
ScrollBox1.Repaint;
end;

end.
