unit UnitTypeString;

interface

uses
  TypInfo, Math,Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

resourcestring
  STypeInfoNeeded = 'TypeInfo needed';
  SInvalidTypeInfo = 'Invalid TypeInfo';

procedure SetToStrings(SetTypeInfo: PTypeInfo; const SetValue;
  Strings: TStrings);
procedure StringsToSet(SetTypeInfo: PTypeInfo; var SetValue;
  Strings: TStrings);
function EnumToStr(EnumTypeInfo: PTypeInfo; Value: Integer): string;
procedure EnumToStrings(EnumTypeInfo: PTypeInfo; Strings: TStrings);
function StrToEnum(EnumTypeInfo: PTypeInfo; Name: string): Integer;

implementation

type
  TDummySet = set of Byte;

procedure SetToStrings(SetTypeInfo: PTypeInfo; const SetValue;
  Strings: TStrings);
var
  BaseType: PTypeInfo;
  BaseTypeData: PTypeData;
  nMinValue: Integer;
  nMaxValue: Integer;
  I: Integer;
begin
  if not Assigned(SetTypeInfo) then begin
    raise EConvertError.Create(STypeInfoNeeded);
  end;
  if SetTypeInfo.Kind <> tkSet then begin
    raise EConvertError.Create(SInvalidTypeInfo);
  end;
  BaseType := GetTypeData(SetTypeInfo).CompType^;
  BaseTypeData := GetTypeData(BaseType);
  nMinValue := BaseTypeData.MinValue;
  nMaxValue := BaseTypeData.MaxValue;
  Strings.Clear;
  for I := nMinValue to nMaxValue do begin
    if I in TDummySet(SetValue) then begin
      Strings.Add(GetEnumName(BaseType, I));
    end;
  end;
end;

procedure StringsToSet(SetTypeInfo: PTypeInfo; var SetValue;
  Strings: TStrings);
var
  BaseType: PTypeInfo;
  BaseTypeData: PTypeData;
  nMinValue: Integer;
  nMaxValue: Integer;
  I: Integer;
  nSizeOfSet: Integer;
  sEnumName: string;
begin
  if not Assigned(SetTypeInfo) then begin
    raise EConvertError.Create(STypeInfoNeeded);
  end;
  if SetTypeInfo.Kind <> tkSet then begin
    raise EConvertError.Create(SInvalidTypeInfo);
  end;
  BaseType := GetTypeData(SetTypeInfo).CompType^;
  BaseTypeData := GetTypeData(BaseType);
  nMinValue := BaseTypeData.MinValue;
  nMaxValue := BaseTypeData.MaxValue;
  nSizeOfSet := Ceil((nMaxValue - nMinValue + 1) / 8);
  FillChar(SetValue, nSizeOfSet, 0);
  for I := 0 to Strings.Count-1 do begin
    sEnumName := Strings[I];
    Include(TDummySet(SetValue), GetEnumValue(BaseType, sEnumName));
  end;
end;

function EnumToStr(EnumTypeInfo: PTypeInfo; Value: Integer): string;
begin
  if not Assigned(EnumTypeInfo) then begin
    raise EConvertError.Create(STypeInfoNeeded);
  end;
  if EnumTypeInfo.Kind <> tkEnumeration then begin
    raise EConvertError.Create(SInvalidTypeInfo);
  end;
  Result := GetEnumName(EnumTypeInfo, Value);
end;

procedure EnumToStrings(EnumTypeInfo: PTypeInfo; Strings: TStrings);
var
  EnumTypeData: PTypeData;
  nMinValue: Integer;
  nMaxValue: Integer;
  I: Integer;
begin
  if not Assigned(EnumTypeInfo) then begin
    raise EConvertError.Create(STypeInfoNeeded);
  end;
  if EnumTypeInfo.Kind <> tkEnumeration then begin
    raise EConvertError.Create(SInvalidTypeInfo);
  end;
  EnumTypeData := GetTypeData(EnumTypeInfo);
  nMinValue := EnumTypeData.MinValue;
  nMaxValue := EnumTypeData.MaxValue;
  Strings.Clear;
  for I := nMinValue to nMaxValue do begin
    Strings.Add(GetEnumName(EnumTypeInfo, I));
  end;
end;

function StrToEnum(EnumTypeInfo: PTypeInfo; Name: string): Integer;
begin
  if not Assigned(EnumTypeInfo) then begin
    raise EConvertError.Create(STypeInfoNeeded);
  end;
  if EnumTypeInfo.Kind <> tkEnumeration then begin
    raise EConvertError.Create(SInvalidTypeInfo);
  end;
  Result := GetEnumValue(EnumTypeInfo, Name);
end;

end.
 