{ TPowerpoint is a component to control Microsoft Powerpoint TM via it's OLE Interface.
  Version 1.0
  Comments are very wellcome
  
Coppyright : Heiko Groschupp; h.groschupp@media-ag.com



Disclaimer
----------
THIS SOFTWARE IS PROVIDED BY HEIKO GROSCHUPP "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
 }
unit TPowerpoint;
interface

uses
Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,comobj,ExtCtrls,
StdCtrls,PowPntConst;
Type
 TTransEffect = ( EffectAppear, EffectBlindsHorizontal, EffectBlindsVertical,
                         EffectBoxIn, EffectBoxOut, EffectCheckerboardAcross,
                         EffectCheckerboardDown, EffectCoverDown, EffectCoverLeft,
                         EffectCoverLeftDown, EffectCoverLeftUp, EffectCoverRight,
                         EffectCoverRightDown, EffectCoverRightUp, EffectCoverUp,
                         EffectCut , EffectCutThroughBlack,
                         EffectDissolve, EffectFade,
                         EffectNone,
                         EffectRandom,
                         EffectRandomBarsHorizontal, EffectRandomBarsVertical, 
                         EffectSplitHorizontalIn,EffectSplitHorizontalOut, EffectSplitVerticalIn, EffectSplitVerticalOut,
                         EffectStripsDownLeft, EffectStripsDownRight, EffectStripsLeftDown,
                         EffectStripsLeftUp, EffectStripsRightDown, EffectStripsRightUp,
                         EffectStripsUpLeft, EffectStripsUpRight, 
                         EffectUncoverDown, EffectUncoverLeft,EffectUncoverLeftDown, EffectUncoverLeftUp, EffectUncoverRight,
                         EffectUncoverRightDown, EffectUncoverRightUp, EffectUncoverUp,
                         EffectWipeDown, EffectWipeLeft, EffectWipeRight, EffectWipeUp);

TTransspeed = (TransitionSpeedFast,TransitionSpeedMedium,TransitionSpeedMixed,TransitionSpeedSlow);
TSlideShowMode  = (ShowTypeKiosk,ShowTypeSpeaker,ShowTypeWindow);
TSlideShowState= (SlideShowBlackScreen,SlideShowDone,SlideShowPaused,SlideShowRunning,SlideShowWhiteScreen);
TSlideshowPointer = ( SlideShowPointerAlwaysHidden,SlideShowPointerArrow,
                    SlideShowPointerAutoArrow,SlideShowPointerNone,SlideShowPointerPen);
TSlideShowAdvancedMode = (SlideShowManualAdvance,SlideShowRehearseNewTimings,SlideShowUseSlideTimings);

TExportType = (exBMP,exGIF,exHTML,exJPG,exMETA,exPNG,exRTF,exSHOW);

TPPTProperties = Record
               TransEffect : TTransEffect;
               Transspeed:TTransSpeed;
               TransInterval :Integer;
               SlideShowMode : TSlideshowmode;
               SlideShowState: TSlideshowstate;
               SlideshowPointer :TSlideshowPointer;
               SlideShowAdvancedMode :TSlideShowAdvancedMode;
               SlideCount :Integer;
               AdvancedMode : TSlideShowAdvancedMode;
               PresentationName :String;
               PresentationPath :String;
        end; //Record



// Events
TOnPPTConnect = procedure (Sender : Tobject; PPTVersion :String)of Object;
TOnBeforePPTClose = procedure (Sender : Tobject; Var AllowClose :Boolean) of Object;
TOnPPTClose = procedure (Sender : Tobject)of Object;
TOnSlideChange = procedure (Sender :TObject;SlideIDBefore:Integer; SlideIDNow : Integer; SlideName:String) of Object;
TOnSlideShowClose = procedure (Sender :Tobject)of Object;
//TOnDocumentClose  = procedure (Sender :TObject ;PresentationName :String)of Object;
TOnSlideShowStarted = Procedure (SEnder :TObject; Status :TSlideshowState)of Object;
TOnAccesserror = procedure (Sender :TObject; ErrorNAme : String)of Object; 


TPowPnt = class (TComponent)

Private

FTransEffect : TTransEffect;
FTransspeed:TTransSpeed;
FTransInterval :Integer;
FSlideShowMode : TSlideshowmode;
FSlideShowState: TSlideshowstate;
FSlideshowPointer :TSlideshowPointer;
FSlideShowAdvancedMode :TSlideShowAdvancedMode;

FSlideShowAllowMouse : Boolean;
FSlideshowuseinternalTimer :Boolean;
FPollProperties:Boolean;

FConnected :Boolean;
FSlideShowrunning:Boolean;
FAutoConnect:Boolean;
FPPTAutoQuit :Boolean;
FLoadedPresentationName :String;
FLooped: Boolean;
FActiveSlideName:String;
FPowerpointVersion :String;
FPowPntHandle :Hwnd;


FPowerPoint :Variant;

//Events
FOnPPTConnect:TOnPPTConnect;
FOnPPTClose:TOnPPTClose;
FOnBeforePPTClose :TOnBeforePPTClose;
FOnSlideChange:TOnSlideChange;
FOnSlideShowClose:TOnSlideShowClose;
//FOnDocumentClose :TOnDocumentClose ;
FOnSlideShowStarted:TOnSlideShowStarted;
FOnAccesserror:TOnAccesserror;



Procedure FSetTransEffect(Value:TTransEffect);
procedure FSetTransspeed(Value:TTransSpeed) ;
procedure FSetTransInterval(Value:Integer) ;
procedure FSetSlideShowMode(Value:TSlideShowMode) ;
procedure FsetSlideShowState(Value:TSlideShowState) ;
procedure FSetSlideShowPointer(Value:TSlideShowPointer) ;
Procedure FSetAutoConnect (Value :Boolean);
Procedure FSetPptAutoQuit(Value :Boolean);
Procedure FApplyPropperties(SlideID :Integer);
Procedure Fsetlooped (Value :Boolean);
Procedure FSetSlideShowAdvancedMode (Value :TSlideShowAdvancedMode);
Procedure FsetSlideshowuseinternalTimer(Value : Boolean);
Procedure FSetSlideShowAllowMouse(Value :Boolean);

Function FPresLoaded : Boolean;
Function FSlideShowActive :Boolean;
Function FSelectSlide(SlideID :Integer):Boolean ;
Function FGetPowpntVersion :String;



public
constructor Create(AOwner: TComponent);override;
destructor Destroy; override;

Function Connect:Boolean;
Function PPTClose :Boolean;
Function GetSlidesCount :Integer;
Function LoadPresentation (PresFile : String):Boolean;
Function SavePresentation (PresFileName :String):Boolean;
Function ExportPresentation (ExportType :TexportType) :Boolean;

// Function SlideSaveAs (Format type): Boolean;


Function Play:Boolean;
Function Stop: Boolean;
Function GotoNext: Boolean;
Function GotoPrevious :Boolean;
Function GotoLAst :Boolean;
Function GotoSlide (SlideID : Integer):Boolean;
Function getCurrentSlideId : Integer;
Function GEtCurrentSlideNAme :String;

Function MoveSlide (fromPos : integer; toPos :Integer) : Boolean;
Function DeleteSlide (SlideID : Integer):Boolean;
Function HideSlide (SlideID : Integer;Hided :Boolean) :Boolean;

published

Property Transisioneffect :TTransEffect read FTransEffect write FSetTranseffect default Effectnone;
Property Connected : boolean read FConnected;
Property TransisionSpeed :TTransspeed read FTransspeed write FSetTransspeed default TransitionSpeedMedium;
Property TransisionInterval :Integer read Ftransinterval write FsetTransInterval Default 5 ;
Property SlideShowMode : TSlideShowMode read fSlideShowMode write FSetSlideShowMode default ShowTypeSpeaker;
Property SlideShowState : TSlideShowState read FSlideShowState write FsetSlideShowState default SlideShowRunning;
Property SlideShowPointer : TSlideshowPointer read FSlideshowPointer write FSetSlideShowPointer default SlideShowPointerNone;
property SlideshowTrigger :  TSlideshowAdvancedMode read FSlideshowAdvancedMode write FSetSlideShowAdvancedMode default SlideShowUseSlideTimings;
property SlideShowActiv : Boolean read FSlideshowRunning;
Property AutoConnect : Boolean read FAutoConnect write FSetAutoConnect  Default false;
Property PPTAutoQuit : Boolean read FPPTAutoQuit write FSetPptAutoQuit default False;
Property LoadedPresentationName :String read FLoadedPresentationName;
Property Looped :Boolean read FLooped write Fsetlooped ;
Property SlideShowAllowMouse : Boolean read FSlideShowAllowMouse write FSetSlideShowAllowMouse default true;
Property SlideshowUseInternalTimer :Boolean read FSlideshowuseinternalTimer write FSetSlideshowuseinternalTimer;
Property PowerPointVersion : String read FPowerpointVersion;
Property PowerpointWindowhandle : hwnd read fpowpnthandle;


//Events

property OnPPTConnect :TOnPPTConnect read FOnPPTConnect write FOnPPTConnect;
Property OnBeforePPTClose : TOnBeforePPTClose read FOnBeforePPTClose write FOnBeforePPTClose;
property OnPPTClose :TOnPPTClose read FOnPPTClose write FOnPPTClose;
property OnSlideChange :TOnSlideChange read FOnSlideChange write FOnSlideChange;
property OnSlideShowClose :TOnSlideShowClose read FOnSlideShowClose write FOnSlideShowClose;
//property OnDocumentClose  :TOnDocumentClose  read FOnDocumentClose  write FOnDocumentClose ;
property OnSlideShowStart :TOnSlideShowStarted read FOnSlideShowStarted write FOnSlideShowStarted;
property OnAccessError :TOnAccesserror read FOnAccesserror write FOnAccesserror;





end;//Type

procedure Register;



const

//Arrays fr den Zugriff auf die eigenen Constanten Typen

  FArrayTransEffects: array[EffectAppear..EffectWipeUp] of integer =
    (ppEffectAppear,ppEffectBlindsHorizontal,ppEffectBlindsVertical,
    ppEffectBoxIn,ppEffectBoxOut,ppEffectCheckerboardAcross,
    ppEffectCheckerboardDown,ppEffectCoverDown,ppEffectCoverLeft,
    ppEffectCoverLeftDown,ppEffectCoverLeftUp,ppEffectCoverRight,
    ppEffectCoverRightDown,ppEffectCoverRightUp,ppEffectCoverUp,
    ppEffectCut,ppEffectCutThroughBlack,
    ppEffectDissolve,ppEffectFade,
    ppEffectNone,
    ppEffectRandom,
    ppEffectRandomBarsHorizontal,ppEffectRandomBarsVertical,ppEffectSplitHorizontalIn,
    ppEffectSplitHorizontalOut,ppEffectSplitVerticalIn,ppEffectSplitVerticalOut,
    ppEffectStripsDownLeft,ppEffectStripsDownRight,ppEffectStripsLeftDown,
    ppEffectStripsLeftUp,ppEffectStripsRightDown,ppEffectStripsRightUp,
    ppEffectStripsUpLeft,ppEffectStripsUpRight,
    ppEffectUncoverDown,ppEffectUncoverLeft,ppEffectUncoverLeftDown,
    ppEffectUncoverLeftUp,ppEffectUncoverRight,ppEffectUncoverRightDown,
    ppEffectUncoverRightUp,ppEffectUncoverUp,
    ppEffectWipeDown,ppEffectWipeLeft,ppEffectWipeRight,ppEffectWipeUp);

FArrayTransspeed: Array [ TransitionSpeedFast .. TransitionSpeedSlow ] of Integer = 
                  (ppTransitionSpeedFast,
                  ppTransitionSpeedMedium,
                  ppTransitionSpeedMixed,
                  ppTransitionSpeedSlow);

FArraySlideShowMode : Array [ShowTypeKiosk .. ShowTypeWindow] of Integer = (ppShowTypeKiosk,ppShowTypeSpeaker,ppShowTypeWindow);

FArraySlideShowState: Array [SlideShowBlackScreen  ..SlideShowWhiteScreen ] of Integer = (ppSlideShowBlackScreen,ppSlideShowDone,ppSlideShowPaused,ppSlideShowRunning,ppSlideShowWhiteScreen);

FArraySlideshowPointer :Array [SlideShowPointerAlwaysHidden  .. SlideShowPointerPen] of Integer = ( ppSlideShowPointerAlwaysHidden,ppSlideShowPointerArrow,
                                                   ppSlideShowPointerAutoArrow,ppSlideShowPointerNone,ppSlideShowPointerPen);
FArraySlideShowadvancedMode : Array [SlideShowManualAdvance .. SlideShowUseSlideTimings] of Integer = 
                            (ppSlideShowManualAdvance,ppSlideShowRehearseNewTimings,ppSlideShowUseSlideTimings);
  
FArrayExportType : Array [exBMP .. exShow] of Integer = (ppSaveAsBMP,ppSaveAsGIF,ppSaveAsHTML,ppSaveAsJPG,
                                                         ppSaveAsMetaFile,ppSaveAsPNG,ppSaveAsRTF,ppSaveAsShow);

implementation


// +++++++++++++++++++++++++++++++++++ Public procedures  ++++++++++++++++++++++++++++++++++++++++++++++++


Function TpowPnt.HideSlide (SlideID : Integer; hided :Boolean) :Boolean;
Begin
Result := false;
if not FSelectSlide(SlideID )then 
   Begin
   if Assigned (FOnAccessError) then FOnAccessError(self,'Hide operation failed!'); 
   exit; 
   end;
Try 
if Hided then Fpowerpoint.ActiveWindow.Selection.SlideRange.SlideShowTransition.Hidden := msoTrue else
         Fpowerpoint.ActiveWindow.Selection.SlideRange.SlideShowTransition.Hidden := msoFalse;

Result:= true;
except
if Assigned (FOnAccessError) then FOnAccessError(self,'Hide- OP failed!'); 
end;

end;

Function TPowPnt.ExportPresentation (ExportType :TexportType) :Boolean;
Begin
Result := false;
Try
IF FPresLoaded then BEgin
   Fpowerpoint.ActivePresentation.saveas(FLoadedPresentationName,FArrayExportType[ExportType]);
   Result := true;
   end else if Assigned (FOnAccessError) then FOnAccessError(self,'No Presentation loaded!');;   
   except

   if Assigned (FOnAccessError) then FOnAccessError(self,'Export failed!');
   end;
end;


Function TPowPnt.GetSlidesCount :Integer;
Begin
Result := 0;
try
Result := FPowerpoint.ActivePresentation.Slides.Count;
Except 
Result := -1;
   if Assigned (FOnAccessError) then FOnAccessError(self,'Could not read count of slides!');
end;
end;


Function TPowPnt.PPTClose :Boolean;
Var AllowClose :Boolean;
Begin
Result := False;
AllowClose := true;
Try
if not Fconnected then
   begin
   if Assigned (FOnAccessError) then FOnAccessError(self,'Not connected!');
   exit;
   end;
If Assigned( FOnBeforePPTClose) then FonBeforePPtClose(Self,AllowClose);
if not AllowClose then exit;
Fpowerpoint.Quit;
FPowerpointVersion := FgetPowPntVersion;
if FpowerPOintVersion = '' then 
Begin
 REsult := true;
 FConnected := false;
 closeHandle(FPowPntHandle);
 if Assigned(FOnPPTClose ) then FOnPPTClose(self);
 end;
 Except
    if Assigned (FOnAccessError) then FOnAccessError(self,'Close PPT failed!');
 end;
end;

Function TpowPnt.GotoLAst :Boolean;
Var currentSlideBefore, CurrentSlide: Integer;
Begin
REsult := false;
if (not FSlideShowActive) or (not FConnected) then
Begin
      if Assigned (FOnAccessError) then FOnAccessError(self,'Slideshow not running!');
   exit;
   end;
Try 
    CurrentSlideBefore := getCurrentSlideId;
    if FSlideShowrunning then FPowerpoint.ActivePresentation.Slideshowwindow.View.Last;
    CurrentSlide := GEtcurrentslideID;
    if CurrentSlide <> CurrentSlidebefore then
       if Assigned(FOnSlideChange) then FOnSlideChange(Self, CurrentSlideBefore,CurrentSlide,GEtCurrentSlideNAme); 
                       
    Result := true;
    except
       if Assigned (FOnAccessError) then FOnAccessError(self,'Could not go to last slide!');
    Result := False
    end;

end;


Function TpowPnt.GotoNext: Boolean;
Var currentSlideBefore, CurrentSlide: Integer;
Begin
REsult := false;
if (not FSlideShowActive) or (not Connected) then 
   Begin
      if Assigned (FOnAccessError) then FOnAccessError(self,'Slideshow not running!');
   exit;
   end;
Try 
    CurrentSlideBefore := getCurrentSlideId;
    if FSlideShowrunning then FPowerpoint.ActivePresentation.Slideshowwindow.View.Next;
    CurrentSlide := GEtcurrentslideID;
    if CurrentSlide <> CurrentSlidebefore then
       if Assigned(FOnSlideChange) then FOnSlideChange(Self, CurrentSlideBefore,CurrentSlide,GEtCurrentSlideNAme); 
    
    Result := true;
    except
    Result := False;
       if Assigned (FOnAccessError) then FOnAccessError(self,'Could not go to next Slide!');
    end;
end;


Function TpowPnt.GotoPrevious :Boolean;
Var currentSlideBefore, CurrentSlide: Integer;
Begin
REsult := false;
if (not FSlideShowActive) or (not Connected) then 
   Begin
      if Assigned (FOnAccessError) then FOnAccessError(self,'Slideshow not running!');
   exit;
   end;
Try 
    CurrentSlideBefore := getCurrentSlideId;
    if FSlideShowrunning then FPowerpoint.ActivePresentation.Slideshowwindow.View.previous;
    CurrentSlide := GEtcurrentslideID;
    if CurrentSlide <> CurrentSlidebefore then
       if Assigned(FOnSlideChange) then FOnSlideChange(Self, CurrentSlideBefore,CurrentSlide,GEtCurrentSlideNAme); 
    
    Result := true;
    except
    Result := False;
       if Assigned (FOnAccessError) then FOnAccessError(self,'Could not go to previous slide!');
    end;
end;


Function TpowPnt.GotoSlide (SlideID : Integer):Boolean;
Var currentSlideBefore, CurrentSlide: Integer;
Begin
REsult := false;
if (not FSlideShowActive) or (not Connected) then 
   Begin
      if Assigned (FOnAccessError) then FOnAccessError(self,'Slideshow not running!');
   exit;
   end;
Try 
    CurrentSlideBefore := getCurrentSlideId;
    if FSlideShowrunning then FPowerpoint.ActivePresentation.Slideshowwindow.View.GotoSlide(SlideID);
    CurrentSlide := GEtcurrentslideID;
    if CurrentSlide <> CurrentSlidebefore then
       if Assigned(FOnSlideChange) then FOnSlideChange(Self, CurrentSlideBefore,CurrentSlide,GEtCurrentSlideNAme); 
    

    Result := true;

    except
    Result := False;
       if Assigned (FOnAccessError) then FOnAccessError(self,'Could not go to slide : '+ inttostr(SlideID));
    end;

end;


Function TpowPnt.getCurrentSlideId : Integer;
Begin
REsult := -1;
if (not FSlideShowActive) or (not FConnected) then 
   Begin
      if Assigned (FOnAccessError) then FOnAccessError(self,'Slideshow not running!');
   exit;
   end;
Try 
    if FSlideShowrunning then Result := FPowerpoint.ActivePresentation.Slideshowwindow.View.CurrentShowPosition;
   
    except
    if Assigned (FOnAccessError) then FOnAccessError(self,'Could not determine slide- ID');
    end;
end;


Function TpowPnt.GEtCurrentSlideNAme :String;
Begin
REsult := '';
if (not FSlideShowActive) or (not FConnected) then 
   Begin
      if Assigned (FOnAccessError) then FOnAccessError(self,'Slideshow not running!');
   exit;
   end;
Try 
    if FSlideShowrunning then Result := FPowerpoint.ActivePresentation.Slideshowwindow.View.Slide.Name;
   
    except
    Result := '';
    if Assigned (FOnAccessError) then FOnAccessError(self,'Could not determine name of current slide');
    end;
end;



Function TpowPnt.MoveSlide (fromPos : integer; toPos :Integer) : Boolean;
Begin
Result := False;
if FSlideShowActive or ( not  FPresLoaded ) or (FromPos=Topos)  then 
   Begin
       if Assigned (FOnAccessError) then FOnAccessError(self,'Slideshow is running or no presentation is loaded!');
   exit;
   end;


Try
if FPowerpoint.ActivePresentation.Slides.Count <= 1 then 
   BEgin
       if Assigned (FOnAccessError) then FOnAccessError(self,'Presentation contains less then 2 slides!');
   exit;
   end;
if toPos = 1 then 
   Begin
   Fpowerpoint.ActivePresentation.Slides.Range(1).select;
   Fpowerpoint.ActivePresentation.Slides.Range(1).copy;
   Fpowerpoint.ActiveWindow.View.Paste;
   Fpowerpoint.ActivePresentation.Slides.Range(frompos+1).cut;
   Fpowerpoint.ActivePresentation.Slides.Range(1).select;
   Fpowerpoint.ActiveWindow.View.Paste;
   Fpowerpoint.ActivePresentation.Slides.Range(1).Delete;
   Result:= true;
   end else begin
            Fpowerpoint.ActivePresentation.Slides.Range(frompos).cut;
            Fpowerpoint.ActivePresentation.Slides.Range(Topos-1).select;
            Fpowerpoint.ActiveWindow.View.Paste;
            Result := true;
            end;                                     
Except
Result := false;
    if Assigned (FOnAccessError) then FOnAccessError(self,'Could not move slide from index ' + inttostr(Frompos)+ ' to index ' +inttoStr(ToPos)+ ' !');
end;

end;


Function TpowPnt.DeleteSlide (SlideID : Integer):Boolean;

Begin
REsult := False;

Try 
if FSlideShowActive or 
   (not Connected)or 
   (SlideID <=0) or 
   (SlideID > FPowerpoint.ActivePresentation.Slides.Count) then 
            Begin
                if Assigned (FOnAccessError) then FOnAccessError(self,'Could not delete slide with index : '+inttoStr(SlideID)+ ' !');
            exit;
            end;
    Fpowerpoint.ActivePresentation.Slides.Range(SlideID).Delete;
    Result := true;
    except
    if Assigned (FOnAccessError) then FOnAccessError(self,'Could not delete slide with index : '+inttoStr(SlideID)+ ' !');
    Result := False;
    end;
end;




Function TpowPnt.Stop:Boolean;
Begin
REsult := false;
    
if not FConnected Then 
   Begin
   if Assigned (FOnAccessError) then FOnAccessError(self,'Not connected!');
   exit;
   end;
Try 
   if FSlideShowActive    then 
       begin
       FPowerpoint.ActivePresentation.Slideshowwindow.View.Exit;
       if assigned (FOnslideshowClose) then FOnslideshowClose(Self); 
       FSlideShowRunning := false;
       Result := true;
       end else
        if Assigned (FOnAccessError) then FOnAccessError(self,'No Presentation active!');
    except
    Result := False;
    if Assigned (FOnAccessError) then FOnAccessError(self,'Not connected!');
    end;
end;




Function TpowPnt.Play:Boolean;
Begin
REsult := false;
if not FConnected Then 
   Begin
       if Assigned (FOnAccessError) then FOnAccessError(self,'Not connected!');
   exit;
   end;
Try 
    if FPresLoaded then 
       begin 
       FApplyPropperties(0);
       FPowerpoint.ActivePresentation.SlideShowSettings.RangeType := ppShowAll;
       FPowerpoint.ActivePresentation.SlideShowSettings.Run.View.PointerType := FArraySlideshowPointer[FSlideShowPointer];
       FPowerpoint.ActivePresentation.SlideShowSettings.Run;
       FPowerpoint.ActivePresentation.Slideshowwindow.View.State := FArraySlideShowState[FSlideShowstate];
       if Assigned(FOnSlideShowStarted) then FOnSlideshowSTarted (self,FSlideshowstate);
       Result := true;
       end else if Assigned (FOnAccessError) then FOnAccessError(self,'No Presentation loaded!');
    except
    Result := False;
    if Assigned (FOnAccessError) then FOnAccessError(self,'Could not start!');
    end;
end;

Function TpowPnt.SavePresentation (PresFileName :String):Boolean;
Begin
Result := False;
if not FConnected then 
   Begin
       if Assigned (FOnAccessError) then FOnAccessError(self,'Not connected!');
   exit;
   end;
try
 
Fpowerpoint.ActivePresentation.SaveAs(PresfileNAme,1);
FLoadedPresentationName := FPOwerpoint.ActivePresentation.Name;
FApplyPropperties(0);
Result := true;
except
Result := false;
    if Assigned (FOnAccessError) then FOnAccessError(self,'Could not save!');
end;

end;


Function TpowPnt.LoadPresentation (PresFile : String):Boolean;
begin
Result := False;
if not FConnected then 
   Begin
          if Assigned (FOnAccessError) then FOnAccessError(self,'Not connected!');
   exit;
   end;
try 
While FSlideShowActive do 
Stop;
While FPresLoaded do 
FPowerPoint.ActiveWindow.Close;
Fpowerpoint.Presentations.Open(Presfile,MSOFalse);
FLoadedPresentationName := FPOwerpoint.ActivePresentation.Name;
Result := true;
except
Result := false;
end;

end;
destructor TPowPnt.Destroy;
Begin
 closeHandle(FPowPntHandle);
// hier zustzliches freigeben
try
if  FPPTAutoQuit then FPowerpoint.quit;
except
end;
inherited Destroy;
end;

procedure Register;
Begin
RegisterComponents('OLE', [TPowPnt]);
end;

Function TPowPnt.Connect :Boolean;
Begin
if csdesigning  in componentState then Begin Result := False;exit;end;
try 
FPowerPoint := createOLEObject('PowerPoint.Application');
FPowerPoint.Visible := msotrue;
result := true;

if Not Fconnected then FPowPntHandle := FindWindow(nil,pchar('Microsoft Powerpoint'));
FConnected := true;
FPowerpointVersion := FgetPowPntVersion;
if Assigned (FOnPPTConnect) then 
   FOnPPTConnect(Self,FPowerpointVersion);

except

Result := false;
          if Assigned (FOnAccessError) then FOnAccessError(self,'Could not connect!');
   end;
end;


constructor TPowPnt.Create(AOwner: TComponent);
Begin
inherited Create(AOwner);


FConnected := False;
FTransEffect := EffectNone;
FTransspeed := TransitionSpeedMedium;
FSlideShowMode := ShowTypeSpeaker;
FSlideShowState:= SlideShowRunning;
FSlideshowPointer:= SlideShowPointerNone;
FTRansInterval := 5;
FSlideshowAdvancedMode:= SlideShowUseSlideTimings;
FPollProperties := False;

FSlideShowAllowMouse :=true;
FSlideshowuseinternalTimer :=true;
end;


// -------------------------------End Public procedures -----------------------------------------


// +++++++++++++++++++++++++++++++ Private Procedures +++++++++++++++++++++++++++++++++++++


Function TPowpnt.FGetPowpntVersion :String;
Begin
if not Fconnected then Begin Result := '' ;Exit;end;
Try Result := FpowerPoint.version;
except
Result := '';
end;
end;



Function TpowPnt.FSelectSlide(SlideID :Integer):Boolean ;
BEgin
REsult := False;

Try 
if FSlideShowActive or 
   (not Connected)or 
   (SlideID <=0) or 
   (SlideID > FPowerpoint.ActivePresentation.Slides.Count) then exit;
    Fpowerpoint.ActivePresentation.Slides.Range(SlideID).select;
    Result := true;
    except
    Result := False;
    end;


end;


Function TPowPnt.FPresLoaded : Boolean;
Begin
Result := true;
if not FConnected then Result := false;
try 
FLoadedPresentationName:= Fpowerpoint.ActivePresentation.Name;
Except
FLoadedPresentationName := '';
Result := false;
exit;
end;

end;

function TPowPnt.FSlideShowActive :Boolean;
Begin
if not FConnected then Result := false;
Try

   FActiveSlideName:= FPowerpoint.ActivePresentation.SlideShowWindow.View.Slide.Name;
   FSlideShowRunning := true;
   except
         Try 
         if FPowerpoint.ActivePresentation.Slideshowwindow.View.State = ppSlideShowDONE THEN
         Result := True;
         except
   FActiveSlideNAme:='';
   Result := false;
   FSlideShowrunning := False;
   exit;
         end;
   end;
Result := true;
end;



Procedure TPOwPnt.FApplyPropperties(SlideID :Integer);
Begin
if (not FPresLoaded) or FSlideShowActive then exit;
 
   if FLooped then FPowerpoint.ActivePresentation.SlideShowSettings.LoopuntilStopped := MSOTrue else FPowerpoint.ActivePresentation.SlideShowSettings.LoopuntilStopped := msoFalse;
if (SlideID <= 0) then Begin

    
   FPowerPoint.ActivePresentation.SlideShowSettings.AdvanceMode := FArraySlideShowAdvancedMode[FSlideshowAdvancedMode];
   FpowerPoint.ActivePresentation.SlideShowSettings.ShowType := FArraySlideshowmode[FSlideShowMode];
   Fpowerpoint.ActivePresentation.Slides.Range.SlideShowTransition.EntryEffect := FArrayTransEffects[FTransEffect];
   Fpowerpoint.ActivePresentation.Slides.Range.SlideShowTransition.speed:= FArrayTransspeed[FTransSpeed];
   Fpowerpoint.ActivePresentation.Slides.Range.SlideShowTransition.AdvanceTime:=FTransInterval;
   if FSlideShowAllowMouse then   FPowerPoint.ActivePresentation.Slides.Range.SlideShowTransition.AdvanceOnClick := msoTrue 
      else FPowerPoint.ActivePresentation.Slides.Range.SlideShowTransition.AdvanceOnClick := msoFalse;
   if FSlideshowuseinternalTimer then FPowerPoint.ActivePresentation.Slides.Range.SlideShowTransition.AdvanceOnTime := msoTrue 
   else FPowerPoint.ActivePresentation.Slides.Range.SlideShowTransition.AdvanceOnTime := msoFalse;
    end else 
         if SlideID <= FPowerpoint.ActivePresentation.Slides.Count then 
            Begin
            FPowerPoint.ActivePresentation.SlideShowSettings.AdvanceMode := FArraySlideShowAdvancedMode[FSlideshowAdvancedMode];
            FpowerPoint.ActivePresentation.SlideShowSettings.ShowType := FArraySlideshowmode[FSlideShowMode];
            Fpowerpoint.ActivePresentation.Slides.Range(SlideID).Select.ActiveWindow.Selection.SlideRange.SlideShowTransition.EntryEffect := FArrayTransEffects[FTransEffect];
            Fpowerpoint.ActivePresentation.Slides.Range(SlideID).SlideShowTransition.speed:= FArrayTransspeed[FTransSpeed];
            Fpowerpoint.ActivePresentation.Slides.Range(SlideID).SlideShowTransition.AdvanceTime:=FTransInterval;
            FPowerPoint.ActivePresentation.Slides.Range(SlideID).SlideShowTransition.AdvanceOnClick := msoTrue;
            FPowerPoint.ActivePresentation.Slides.Range(SlideID).SlideShowTransition.AdvanceOnTime := msoTrue;
   
            end;
end;




//++++++++++++++++++++++++++++++++ Begin private Property procedures ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


Procedure TPowPnt.FsetSlideshowuseinternalTimer(Value : Boolean);
Begin
FSlideshowuseinternalTimer := Value;
FApplyPropperties(0);
end;


Procedure TPowPnt.FSetSlideShowAllowMouse(Value :Boolean);
Begin
FSlideShowAllowMouse := Value;
FApplyPropperties(0);
end;


Procedure TPOwPnt.FSetSlideShowAdvancedMode (Value :TSlideShowAdvancedMode);
Begin
FSlideShowAdvancedMode := Value;
FApplyPropperties(0);
end;


Procedure TPowPnt.FSetTransInterval (Value :Integer);
Begin
FTransInterval := Value;
end;

Procedure TPOwPnt.Fsetlooped(Value :Boolean);
Begin             
FLooped := Value;
FApplyPropperties(0);
end;


Procedure TPOwPnt.FSetPptAutoQuit(Value:Boolean);
Begin
FPPTAutoQuit := Value;
End;


Procedure TPowPnt.FSetAutoConnect (Value :Boolean);
Begin
FAutoConnect := Value;
if (FAutoConnect) AND(Not FConnected) then 
   FConnected := Connect;

End;

procedure TPowPnt.FSetTransEffect(Value:TTransEffect);
Begin
FTransEffect := Value;
FApplyPropperties(0);
end;

procedure TPowPnt.FSetTransspeed(Value:TTransSpeed);
Begin
FTransSpeed := Value;
FApplyPropperties(0);
end;

procedure TPowPnt.FSetSlideShowMode(Value:TSlideShowMode);
Begin
FSlideshowmode := Value;
Flooped := true;
FApplyPropperties(0);
end;

procedure TPowPnt.FsetSlideShowState(Value:TSlideShowState);
Begin
FSlideshowstate := Value;
if FSlideShowActive then FPowerpoint.ActivePresentation.Slideshowwindow.View.State := FArraySlideShowState[Value] 
   else if Assigned (FOnAccessError) then FOnAccessError(self,'Could not change slideshow state!');
end;

procedure TPowPnt.FSetSlideShowPointer(Value:TSlideShowPointer);
Begin
FSlideShowPointer := Value;
end;

end.
