(*

  TMPHexEditor v 10-25-2002<br>

  @author((C) 1997-2002 markus stephany, merkes@mirkes.de, all rights reserved.)
  @abstract(TMPHexEditor displays and edits hexadecimal/binary files)
  @lastmod(10-25-2002)

  credits to :<br><br>
  - John Hamm, http://users.snapjax.com/john/<br><br>

  - Christophe Le Corfec for introducing the EBCDIC format and the nice idea about
    half byte insert/delete<br><br>

  - Philippe Chessa for his suggestions about AsText, AsHex and better support for
    the french keyboard layout<br><br>

  - Daniel Jensen for octal offset display and the INS-key recognition stuff<br><br>

  - Shmuel Zeigerman for introducing more flexible offset display formats<br><br>

  - Vaf, http://carradio.al.ru for reporting missing delver.inc and suggesting OnChange<br><br>

  - Eugene Tarasov for reporting that setting the BytesPerColumn value to 4 at design
    time didn't work.

  <h3>history:</h3>
  <p><ul>
  <li>v 10-25-2002: october 25, 2002<br><br>
         - corrected the BytesPerColumn default value<br><br></li>

  <li>v 08-18-2002: august 18, 2002<br><br>
         - modified painting and selection<br>
	 - implemented an additional ruler bar at the top<br>
         - new properties: @link(ShowRuler), @link(DrawGutter3D)<br><br></li>

  <li>v 08-12-2002: august 12, 2002<br><br>
	 - modified Changed calls to get correct Modified property in
           OnChange handler<br><br></li>


  <li>v 08-09-2002: august 09, 2002<br><br>
	 - included missing include file delver.inc<br>
	 - added OnChange event<br><br></li>


  <li>v 07-21-2002: july 21, 2002<br><br>
	 too many changes to mention here (completely rewritten, basic and advanced versions
	 TMPHexEditor and TMPHexEditorEx), plz read the documentation included with this
	 package for more information</li>
  </ul></p>

*)

unit MPHexEditor;
{$R *.res}

{$IFNDEF PASDOC}
  {$I DELVER.INC}
{$ENDIF}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Grids;

const
  // block size in file i/o
  MPTH_FILEIO_BLOCKSIZE = $F000;


  // this message is posted to the hex editor when it should update the caret position
  WM_INTUPDATECARET = WM_USER + 3;


  (* translation tables from/to ms windows ansi (~ MS Latin-1)  *)

  // conversion macintosh .. ms ansi (cp 1252) (taken from recode 3.5)
  tblMac2MSAnsi: array [128..255] of char = (#$C4, #$C5, #$C7, #$C9,
    #$D1, #$D6, #$DC, #$E1, #$E0, #$E2, #$E4, #$E3,
    #$E5, #$E7, #$E9, #$E8, #$EA, #$EB, #$ED, #$EC, #$EE, #$EF, #$F1, #$F3,
    #$F2, #$F4, #$F6, #$F5, #$FA, #$F9, #$FB, #$FC, #$A0, #$B0, #$A2, #$A3,
    #$A7, #$B4, #$B6, #$DF, #$AE, #$A9, #$8E, #$82, #$8C, #$AD, #$C6, #$D8,
    #$8D, #$B1, #$B2, #$B3, #$A5, #$B5, #$A6, #$B7, #$B8, #$B9, #$BC, #$AA,
    #$BA, #$BD, #$E6, #$F8, #$BF, #$A1, #$AC, #$92, #$80, #$81, #$A8, #$AB,
    #$BB, #$83, #$BE, #$C0, #$C3, #$D5, #$91, #$93, #$D0, #$84, #$96, #$94,
    #$95, #$90, #$F7, #$D7, #$FF, #$DD, #$98, #$97, #$86, #$99, #$DE, #$A4,
    #$88, #$87, #$89, #$8B, #$8A, #$C2, #$CA, #$C1, #$CB, #$C8, #$CD, #$CE,
    #$CF, #$CC, #$D3, #$D4, #$F0, #$D2, #$DA, #$DB, #$D9, #$9B, #$9A, #$85,
    #$8F, #$9D, #$9C, #$9E, #$9F, #$FD, #$FE, #$AF

    (* alternative 1:
    #$C4, #$C5, #$C7, #$C9, #$D1, #$D6, #$DC, #$E1, #$E0, #$E2, #$E4, #$E3,
    #$E5, #$E7, #$E9, #$E8, #$EA, #$EB, #$ED, #$EC, #$EE, #$EF, #$F1, #$F3,
    #$F2, #$F4, #$F6, #$F5, #$FA, #$F9, #$FB, #$FC, #$BE, #$B0, #$A2, #$A3,
    #$A7, #$82, #$B6, #$DF, #$AE, #$A9, #$8E, #$B4, #$A8, #$AD, #$C6, #$D8,
    #$8D, #$B1, #$B2, #$B3, #$A5, #$B5, #$A6, #$87, #$9F, #$B9, #$BC, #$AA,
    #$BA, #$BD, #$E6, #$F8, #$BF, #$A1, #$AC, #$92, #$80, #$81, #$8C, #$AB,
    #$BB, #$83, #$A0, #$C0, #$C3, #$90, #$91, #$93, #$D0, #$84, #$96, #$94,
    #$95, #$D5, #$F7, #$D7, #$FF, #$99, #$98, #$A4, #$86, #$DD, #$DE, #$97,
    #$88, #$B7, #$89, #$8B, #$8A, #$C2, #$CA, #$C1, #$CB, #$C8, #$CD, #$CE,
    #$CF, #$CC, #$D3, #$D4, #$F0, #$D2, #$DA, #$DB, #$D9, #$9B, #$9A, #$85,
    #$AF, #$9D, #$9C, #$9E, #$B8, #$FD, #$FE, #$8F*)

    (* alternative 2:
    #$C4, #$C5, #$C7, #$C9, #$D1, #$D6,
    #$DC, #$E1, #$E0, #$E2, #$E4, #$E3, #$E5, #$E7, #$E9, #$E8,
    #$EA, #$EB, #$ED, #$EC, #$EE, #$EF, #$F1, #$F3, #$F2, #$F4, #$F6,
    #$F5, #$FA, #$F9, #$FB, #$FC,
    #$DD, #$B0, #$A2, #$A3, #$A7, #$80, #$B6, #$DF, #$AE, #$A9, #$81,
    #$B4, #$A8, #$82, #$C6, #$D8,
    #$83, #$B1, #$BE, #$84, #$A5, #$B5, #$8F, #$85, #$BD, #$BC, #$86,
    #$AA, #$BA, #$87, #$E6, #$F8,
    #$BF, #$A1, #$AC, #$88, #$9F, #$89, #$90, #$AB, #$BB, #$8A, #$A0,
    #$C0, #$C3, #$D5, #$91, #$A6,
    #$AD, #$8B, #$B3, #$B2, #$8C, #$B9, #$F7, #$D7, #$FF, #$8D, #$8E,
    #$A4, #$D0, #$F0, #$DE, #$FE,
    #$FD, #$B7, #$92, #$93, #$94, #$C2, #$CA, #$C1, #$CB, #$C8, #$CD,
    #$CE, #$CF, #$CC, #$D3, #$D4,
    #$95, #$D2, #$DA, #$DB, #$D9, #$9E, #$96, #$97, #$AF, #$98, #$99,
    #$9A, #$B8, #$9B, #$9C, #$9D);*)
    );


  // conversion ms ansi (cp 1252) .. macintosh (taken from recode 3.5)
  tblMSAnsi2Mac: array [128..255] of char = (#$C4, #$C5, #$AB, #$C9,
    #$D1, #$F7, #$DC, #$E1, #$E0, #$E2, #$E4, #$E3,
    #$AC, #$B0, #$AA, #$F8, #$D5, #$CE, #$C3, #$CF, #$D3, #$D4, #$D2, #$DB,
    #$DA, #$DD, #$F6, #$F5, #$FA, #$F9, #$FB, #$FC, #$A0, #$C1, #$A2, #$A3,
    #$DF, #$B4, #$B6, #$A4, #$C6, #$A9, #$BB, #$C7, #$C2, #$AD, #$A8, #$FF,
    #$A1, #$B1, #$B2, #$B3, #$A5, #$B5, #$A6, #$B7, #$B8, #$B9, #$BC, #$C8,
    #$BA, #$BD, #$CA, #$C0, #$CB, #$E7, #$E5, #$CC, #$80, #$81, #$AE, #$82,
    #$E9, #$83, #$E6, #$E8, #$ED, #$EA, #$EB, #$EC, #$D0, #$84, #$F1, #$EE,
    #$EF, #$CD, #$85, #$D7, #$AF, #$F4, #$F2, #$F3, #$86, #$D9, #$DE, #$A7,
    #$88, #$87, #$89, #$8B, #$8A, #$8C, #$BE, #$8D, #$8F, #$8E, #$90, #$91,
    #$93, #$92, #$94, #$95, #$F0, #$96, #$98, #$97, #$99, #$9B, #$9A, #$D6,
    #$BF, #$9D, #$9C, #$9E, #$9F, #$FD, #$FE, #$D8

    (* alternative 1:
    #$C4, #$C5, #$A5, #$C9, #$D1, #$F7, #$DC, #$B7, #$E0, #$E2, #$E4, #$E3,
    #$C6, #$B0, #$AA, #$FF, #$CD, #$CE, #$C3, #$CF, #$D3, #$D4, #$D2, #$DF,
    #$DA, #$D9, #$F6, #$F5, #$FA, #$F9, #$FB, #$B8, #$CA, #$C1, #$A2, #$A3,
    #$DB, #$B4, #$B6, #$A4, #$AC, #$A9, #$BB, #$C7, #$C2, #$AD, #$A8, #$F8,
    #$A1, #$B1, #$B2, #$B3, #$AB, #$B5, #$A6, #$E1, #$FC, #$B9, #$BC, #$C8,
    #$BA, #$BD, #$A0, #$C0, #$CB, #$E7, #$E5, #$CC, #$80, #$81, #$AE, #$82,
    #$E9, #$83, #$E6, #$E8, #$ED, #$EA, #$EB, #$EC, #$D0, #$84, #$F1, #$EE,
    #$EF, #$D5, #$85, #$D7, #$AF, #$F4, #$F2, #$F3, #$86, #$DD, #$DE, #$A7,
    #$88, #$87, #$89, #$8B, #$8A, #$8C, #$BE, #$8D, #$8F, #$8E, #$90, #$91,
    #$93, #$92, #$94, #$95, #$F0, #$96, #$98, #$97, #$99, #$9B, #$9A, #$D6,
    #$BF, #$9D, #$9C, #$9E, #$9F, #$FD, #$FE, #$D8*)

   (* alternative 2:
    #$A5, #$AA, #$AD, #$B0, #$B3, #$B7,
    #$BA, #$BD, #$C3, #$C5, #$C9, #$D1, #$D4, #$D9, #$DA, #$B6,
    #$C6, #$CE, #$E2, #$E3, #$E4, #$F0, #$F6, #$F7, #$F9, #$FA, #$FB,
    #$FD, #$FE, #$FF, #$F5, #$C4,
    #$CA, #$C1, #$A2, #$A3, #$DB, #$B4, #$CF, #$A4, #$AC, #$A9, #$BB,
    #$C7, #$C2, #$D0, #$A8, #$F8,
    #$A1, #$B1, #$D3, #$D2, #$AB, #$B5, #$A6, #$E1, #$FC, #$D5, #$BC,
    #$C8, #$B9, #$B8, #$B2, #$C0,
    #$CB, #$E7, #$E5, #$CC, #$80, #$81, #$AE, #$82, #$E9, #$83, #$E6,
    #$E8, #$ED, #$EA, #$EB, #$EC,
    #$DC, #$84, #$F1, #$EE, #$EF, #$CD, #$85, #$D7, #$AF, #$F4, #$F2,
    #$F3, #$86, #$A0, #$DE, #$A7,
    #$88, #$87, #$89, #$8B, #$8A, #$8C, #$BE, #$8D, #$8F, #$8E, #$90,
    #$91, #$93, #$92, #$94, #$95,
    #$DD, #$96, #$98, #$97, #$99, #$9B, #$9A, #$D6, #$BF, #$9D, #$9C,
    #$9E, #$9F, #$E0, #$DF, #$D8);*)

    );

  // conversion ebcdic cp 38 .. ms ansi (cp 1252) (taken from recode 3.5)
  tblBCD2MSAnsi: array [0..255] of char = (#$00, #$01, #$02, #$03,
    #$F7, #$09, #$D2, #$7F, #$F2, #$A8, #$93, #$0B,
    #$0C, #$0D, #$0E, #$0F, #$10, #$11, #$12, #$13, #$D3, #$A1, #$08, #$D7,
    #$18, #$19, #$96, #$D0, #$1C, #$1D, #$1E, #$1F, #$7C, #$D6, #$81, #$C0,
    #$D1, #$0A, #$17, #$1B, #$D4, #$E9, #$E0, #$D5, #$92, #$05, #$06, #$07,
    #$F0, #$F1, #$16, #$F3, #$F4, #$F5, #$F6, #$04, #$F8, #$F9, #$A9, #$94,
    #$14, #$15, #$95, #$1A, #$20, #$C1, #$C2, #$C3, #$C4, #$C5, #$C6, #$C7,
    #$C8, #$C9, #$5B, #$2E, #$3C, #$28, #$2B, #$21, #$26, #$D8, #$D9, #$E2,
    #$E3, #$E4, #$E5, #$E6, #$E7, #$E8, #$5D, #$24, #$2A, #$29, #$3B, #$5E,
    #$2D, #$2F, #$82, #$83, #$84, #$85, #$86, #$87, #$88, #$89, #$A6, #$2C,
    #$25, #$5F, #$3E, #$3F, #$97, #$98, #$99, #$A2, #$A3, #$A4, #$A5, #$91,
    #$A7, #$60, #$3A, #$23, #$40, #$27, #$3D, #$22, #$80, #$61, #$62, #$63,
    #$64, #$65, #$66, #$67, #$68, #$69, #$8A, #$8B, #$8C, #$8D, #$8E, #$8F,
    #$90, #$6A, #$6B, #$6C, #$6D, #$6E, #$6F, #$70, #$71, #$72, #$9A, #$9B,
    #$9C, #$9D, #$9E, #$9F, #$A0, #$7E, #$73, #$74, #$75, #$76, #$77, #$78,
    #$79, #$7A, #$AA, #$AB, #$AC, #$AD, #$AE, #$AF, #$B0, #$B1, #$B2, #$B3,
    #$B4, #$B5, #$B6, #$B7, #$B8, #$B9, #$BA, #$BB, #$BC, #$BD, #$BE, #$BF,
    #$7B, #$41, #$42, #$43, #$44, #$45, #$46, #$47, #$48, #$49, #$CA, #$CB,
    #$CC, #$CD, #$CE, #$CF, #$7D, #$4A, #$4B, #$4C, #$4D, #$4E, #$4F, #$50,
    #$51, #$52, #$DA, #$DB, #$DC, #$DD, #$DE, #$DF, #$5C, #$E1, #$53, #$54,
    #$55, #$56, #$57, #$58, #$59, #$5A, #$EA, #$EB, #$EC, #$ED, #$EE, #$EF,
    #$30, #$31, #$32, #$33, #$34, #$35, #$36, #$37, #$38, #$39, #$FA, #$FB,
    #$FC, #$FD, #$FE, #$FF

   (*#$00, #$01, #$02, #$03, #$9C, #$09, #$86, #$7F, #$97, #$8D, #$8E, #$0B,
    #$0C, #$0D, #$0E, #$0F, #$10, #$11, #$12, #$13, #$9D, #$85, #$08, #$87,
    #$18, #$19, #$92, #$8F, #$1C, #$1D, #$1E, #$1F, #$80, #$81, #$82, #$83,
    #$84, #$0A, #$17, #$1B, #$88, #$89, #$8A, #$8B, #$8C, #$05, #$06, #$07,
    #$90, #$91, #$16, #$93, #$94, #$95, #$96, #$04, #$98, #$99, #$9A, #$9B,
    #$14, #$15, #$9E, #$1A, #$20, #$C1, #$C2, #$C3, #$C4, #$C5, #$C6, #$C7,
    #$C8, #$C9, #$5B, #$2E, #$3C, #$28, #$2B, #$21, #$26, #$D8, #$D9, #$E2,
    #$E3, #$E4, #$E5, #$E6, #$E7, #$E8, #$5D, #$24, #$2A, #$29, #$3B, #$5E,
    #$2D, #$2F, #$D6, #$C0, #$D1, #$A1, #$D2, #$D7, #$D4, #$E9, #$A6, #$2C,
    #$25, #$5F, #$3E, #$3F, #$F2, #$F8, #$F9, #$A2, #$A3, #$A4, #$A5, #$F1,
    #$A7, #$60, #$3A, #$23, #$40, #$27, #$3D, #$22, #$7C, #$61, #$62, #$63,
    #$64, #$65, #$66, #$67, #$68, #$69, #$E0, #$D5, #$F6, #$A8, #$F3, #$D0,
    #$F0, #$6A, #$6B, #$6C, #$6D, #$6E, #$6F, #$70, #$71, #$72, #$A9, #$F4,
    #$F7, #$D3, #$F5, #$FF, #$A0, #$7E, #$73, #$74, #$75, #$76, #$77, #$78,
    #$79, #$7A, #$AA, #$AB, #$AC, #$AD, #$AE, #$AF, #$B0, #$B1, #$B2, #$B3,
    #$B4, #$B5, #$B6, #$B7, #$B8, #$B9, #$BA, #$BB, #$BC, #$BD, #$BE, #$BF,
    #$7B, #$41, #$42, #$43, #$44, #$45, #$46, #$47, #$48, #$49, #$CA, #$CB,
    #$CC, #$CD, #$CE, #$CF, #$7D, #$4A, #$4B, #$4C, #$4D, #$4E, #$4F, #$50,
    #$51, #$52, #$DA, #$DB, #$DC, #$DD, #$DE, #$DF, #$5C, #$E1, #$53, #$54,
    #$55, #$56, #$57, #$58, #$59, #$5A, #$EA, #$EB, #$EC, #$ED, #$EE, #$EF,
    #$30, #$31, #$32, #$33, #$34, #$35, #$36, #$37, #$38, #$39, #$FA, #$FB,
    #$FC, #$FD, #$FE, #$9F*)

    (*#0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0,
    #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0,
    #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0,
    #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0,
    ' ', #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, '.', '<', '(', '+', '',
    '&', '&', #0, #0, #0, #0, #0, #0, #0, #0, '!', '$', '*', ')', ';', #0,
    '-', '/', #0, #0, #0, #0, #0, #0, #0, #0, '|', ',', '%', '_', '>', '?',
    #0, #0, #0, #0, #0, #0, #0, #0, #0, '`', ':', '#', '@', '''', '=', '"',
    #0, 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', #0, #0, #0, #0, #0, #0,
    #0, 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', #0, #0, #0, #0, #0, #0,
    #0, '~', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', #0, #0, #0, #0, #0, #0,
    #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0, #0,
    #0, 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', #0, #0, #0, #0, #0, #0,
    #0, 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', #0, #0, #0, #0, #0, #0,
    '\', #0, 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', #0, #0, #0, #0, #0, #0,
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', #0, #0, #0, #0, #0, #0*)

    );

  // conversion ms ansi (cp 1252) .. ebcdic cp 38 (taken from recode 3.5)
  tblMSAnsi2BCD: array [0..255] of char = (#$00, #$01, #$02, #$03,
    #$37, #$2D, #$2E, #$2F, #$16, #$05, #$25, #$0B,
    #$0C, #$0D, #$0E, #$0F, #$10, #$11, #$12, #$13, #$3C, #$3D, #$32, #$26,
    #$18, #$19, #$3F, #$27, #$1C, #$1D, #$1E, #$1F, #$40, #$4F, #$7F, #$7B,
    #$5B, #$6C, #$50, #$7D, #$4D, #$5D, #$5C, #$4E, #$6B, #$60, #$4B, #$61,
    #$F0, #$F1, #$F2, #$F3, #$F4, #$F5, #$F6, #$F7, #$F8, #$F9, #$7A, #$5E,
    #$4C, #$7E, #$6E, #$6F, #$7C, #$C1, #$C2, #$C3, #$C4, #$C5, #$C6, #$C7,
    #$C8, #$C9, #$D1, #$D2, #$D3, #$D4, #$D5, #$D6, #$D7, #$D8, #$D9, #$E2,
    #$E3, #$E4, #$E5, #$E6, #$E7, #$E8, #$E9, #$4A, #$E0, #$5A, #$5F, #$6D,
    #$79, #$81, #$82, #$83, #$84, #$85, #$86, #$87, #$88, #$89, #$91, #$92,
    #$93, #$94, #$95, #$96, #$97, #$98, #$99, #$A2, #$A3, #$A4, #$A5, #$A6,
    #$A7, #$A8, #$A9, #$C0, #$20, #$D0, #$A1, #$07, #$80, #$22, #$62, #$63,
    #$64, #$65, #$66, #$67, #$68, #$69, #$8A, #$8B, #$8C, #$8D, #$8E, #$8F,
    #$90, #$77, #$2C, #$0A, #$3B, #$3E, #$1A, #$70, #$71, #$72, #$9A, #$9B,
    #$9C, #$9D, #$9E, #$9F, #$A0, #$15, #$73, #$74, #$75, #$76, #$6A, #$78,
    #$09, #$3A, #$AA, #$AB, #$AC, #$AD, #$AE, #$AF, #$B0, #$B1, #$B2, #$B3,
    #$B4, #$B5, #$B6, #$B7, #$B8, #$B9, #$BA, #$BB, #$BC, #$BD, #$BE, #$BF,
    #$23, #$41, #$42, #$43, #$44, #$45, #$46, #$47, #$48, #$49, #$CA, #$CB,
    #$CC, #$CD, #$CE, #$CF, #$1B, #$24, #$06, #$14, #$28, #$2B, #$21, #$17,
    #$51, #$52, #$DA, #$DB, #$DC, #$DD, #$DE, #$DF, #$2A, #$E1, #$53, #$54,
    #$55, #$56, #$57, #$58, #$59, #$29, #$EA, #$EB, #$EC, #$ED, #$EE, #$EF,
    #$30, #$31, #$08, #$33, #$34, #$35, #$36, #$04, #$38, #$39, #$FA, #$FB,
    #$FC, #$FD, #$FE, #$FF

    (*#$00, #$01, #$02, #$03, #$37, #$2D, #$2E, #$2F, #$16, #$05, #$25, #$0B,
    #$0C, #$0D, #$0E, #$0F, #$10, #$11, #$12, #$13, #$3C, #$3D, #$32, #$26,
    #$18, #$19, #$3F, #$27, #$1C, #$1D, #$1E, #$1F, #$40, #$4F, #$7F, #$7B,
    #$5B, #$6C, #$50, #$7D, #$4D, #$5D, #$5C, #$4E, #$6B, #$60, #$4B, #$61,
    #$F0, #$F1, #$F2, #$F3, #$F4, #$F5, #$F6, #$F7, #$F8, #$F9, #$7A, #$5E,
    #$4C, #$7E, #$6E, #$6F, #$7C, #$C1, #$C2, #$C3, #$C4, #$C5, #$C6, #$C7,
    #$C8, #$C9, #$D1, #$D2, #$D3, #$D4, #$D5, #$D6, #$D7, #$D8, #$D9, #$E2,
    #$E3, #$E4, #$E5, #$E6, #$E7, #$E8, #$E9, #$4A, #$E0, #$5A, #$5F, #$6D,
    #$79, #$81, #$82, #$83, #$84, #$85, #$86, #$87, #$88, #$89, #$91, #$92,
    #$93, #$94, #$95, #$96, #$97, #$98, #$99, #$A2, #$A3, #$A4, #$A5, #$A6,
    #$A7, #$A8, #$A9, #$C0, #$80, #$D0, #$A1, #$07, #$20, #$21, #$22, #$23,
    #$24, #$15, #$06, #$17, #$28, #$29, #$2A, #$2B, #$2C, #$09, #$0A, #$1B,
    #$30, #$31, #$1A, #$33, #$34, #$35, #$36, #$08, #$38, #$39, #$3A, #$3B,
    #$04, #$14, #$3E, #$FF, #$A0, #$65, #$73, #$74, #$75, #$76, #$6A, #$78,
    #$8D, #$9A, #$AA, #$AB, #$AC, #$AD, #$AE, #$AF, #$B0, #$B1, #$B2, #$B3,
    #$B4, #$B5, #$B6, #$B7, #$B8, #$B9, #$BA, #$BB, #$BC, #$BD, #$BE, #$BF,
    #$63, #$41, #$42, #$43, #$44, #$45, #$46, #$47, #$48, #$49, #$CA, #$CB,
    #$CC, #$CD, #$CE, #$CF, #$8F, #$64, #$66, #$9D, #$68, #$8B, #$62, #$67,
    #$51, #$52, #$DA, #$DB, #$DC, #$DD, #$DE, #$DF, #$8A, #$E1, #$53, #$54,
    #$55, #$56, #$57, #$58, #$59, #$69, #$EA, #$EB, #$EC, #$ED, #$EE, #$EF,
    #$90, #$77, #$70, #$8E, #$9B, #$9E, #$8C, #$9C, #$71, #$72, #$FA, #$FB,
    #$FC, #$FD, #$FE, #$9F*)

    (*#00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00,
    #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00,
    '@', 'Z', '', '{', '[', 'l', 'P', '}', 'M', ']', '\', 'N', 'k', '`', 'K', 'a',
    '', '', '', '', '', '', '', '', '', '', 'z', '^', 'L', '~', 'n', 'o',
    '|', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', #00, '', #00, #00, 'm',
    'y', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
    '', '', '', '', '', '', '', '', '', '', '', #00, 'j', #00, '', #00,
    #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00,
    #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00,
    #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00,
    #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00,
    #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00,
    #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00,
    #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00,
    #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, #00, 'O', #00*)

    );

type
  // custom Exception class
  EMPHException = class(Exception);


  (* bookmark record:<br>
     defined by pressing SHIFT+CTRL+[0..9], goto bookmark by pressing CTRL+[0..9]<br><br>

     - mPosition: file position<br>
     - mInCharField: cursor in character pane (True) or hex number pane
  *)
  TMPHBookmark = record
    mPosition: integer;
    mInCharField: boolean;
  end;

  // array of bookmarks, representing keys 0..9
  TMPHBookmarks = array[0..9] of TMPHBookmark;


  (* look of the editor's caret:<br>
     - ckFull: full block<br>
     - ckLeft: left line<br>
     - ckBottom: bottom line<br>
     - ckAuto: left line if @link(InsertMode), full block otherwise
  *)
  TMPHCaretKind = (ckFull,
    ckLeft,
    ckBottom,
    ckAuto
    );


  (* how to show a file's content in the character pane of the editor:<br>
    - tkAsIs:    leave as is (current windows code page)<br>
    - tkDos8:    current dos codepage<br>
    - tkASCII:   7 bit ascii<br>
    - tkMac:     macintosh charset (translation always from/to ms cp 1252 (ms latin1)!!<br>
    - tkBCD:     ibm ebcdic codepage 38 (translation always from/to ms cp 1252 (ms latin1)!!<br>
    - tkCustom:  custom codepage stored in @link(MPHCustTransFieldFrom)[0..255] and @link(MPHCustTransFieldTo)[0..255]
  *)
  TMPHTranslationKind = (tkAsIs,
    tkDos8,
    tkASCII,
    tkMac,
    tkBCD,
    tkCustom
    );


  (* action indicator used in @link(OnLoadSaveProgress) event handler:<br>
    - pkLoad:  loading data<br>
    - pkSave:  saving data
  *)
  TMPHProgressKind = (pkLoad,
    pkSave
    );

  (* progress event handler, used in @link(OnLoadSaveProgress)<br><br>

       - ProgressType: am i loading or saving? (see @link(TMPHProgressKind))<br>
       - aName: name of file to be load from/saved to<br>
       - Percent: current progress (0..100)<br>
       - Cancel: if set to true, the load/save procedure will abort<br>
  *)
  TMPHProgressEvent = procedure(Sender: TObject;
    const ProgressType: TMPHProgressKind;
    const aName: TFileName;
    const Percent: byte;
    var Cancel: boolean) of object;


  // @exclude(flags internally used in the undo storage)
  TMPHUndoFlag = (
    // kind of undo storage
    ufKindByteChanged,
    ufKindByteRemoved,
    ufKindInsertBuffer,
    ufKindReplaceSelection,
    ufKindAppendBuffer,
    ufKindNibbleInsert,
    ufKindNibbleDelete,
    ufKindConvert,
    ufKindCombined,
    // additional information
    ufFlagByteChanged,
    ufFlagModified,
    ufFlag2ndByteCol,
    ufFlagInCharField,
    ufFlagHasSelection,
    ufFlagInsertMode
    );

  // @exclude(set of undo flags)
  TMPHUndoFlags = set of TMPHUndoFlag;

type
  // persistent color storage (contains the colors in hex editors)
  TMPHColors = class(TPersistent)
  private
    FParent: TControl;
    FOffset: TColor;
    FOddColumn: TColor;
    FEvenColumn: TColor;
    FCursorFrame: TColor;
    FBackground: TColor;
    FChangedText: TColor;
    FChangedBackground: TColor;
    FCurrentOffsetBackground: TColor;
    FOffsetBackGround: TColor;
    FCurrentOffset: TColor;
    FGrid: TColor;
    procedure SetOffsetBackGround(const Value: TColor);
    procedure SetCurrentOffset(const Value: TColor);
    procedure SetParent(const Value: TControl);
    procedure SetGrid(const Value: TColor);
    procedure SetBackground(const Value: TColor);
    procedure SetChangedBackground(const Value: TColor);
    procedure SetChangedText(const Value: TColor);
    procedure SetCursorFrame(const Value: TColor);
    procedure SetEvenColumn(const Value: TColor);
    procedure SetOddColumn(const Value: TColor);
    procedure SetOffset(const Value: TColor);
    procedure SetCurrentOffsetBackground(const Value: TColor);
  public
    // @exclude(constructor)
    constructor Create(Parent: TControl);
    // @exclude()
    procedure Assign(Source: TPersistent); override;
    // parent hex editor control
    property Parent: TControl read FParent write SetParent;
  published
    // background color
    property Background: TColor read FBackground write SetBackground;
    // background color of modified bytes (in overwrite mode)
    property ChangedBackground: TColor read FChangedBackground write SetChangedBackground;
    // foreground color of modified bytes (in overwrite mode)
    property ChangedText: TColor read FChangedText write SetChangedText;
    // color of the cursor and position frame in the second pane
    property CursorFrame: TColor read FCursorFrame write SetCursorFrame;
    // foreground color of the line offsets
    property Offset: TColor read FOffset write SetOffset;
    // foreground color of odd columns
    property OddColumn: TColor read FOddColumn write SetOddColumn;
    // foreground color of even columns
    property EvenColumn: TColor read FEvenColumn write SetEvenColumn;
    // background color of the current line in the offset pane (gutter)
    property CurrentOffsetBackground: TColor 
      read FCurrentOffsetBackground write SetCurrentOffsetBackground;
    // background color of the offset pane (gutter)
    property OffsetBackGround: TColor read FOffsetBackGround write SetOffsetBackGround;
    // foreground color of the current line in the offset pane (gutter)
    property CurrentOffset: TColor read FCurrentOffset write SetCurrentOffset;
    // pen color of the grid
    property Grid: TColor read FGrid write SetGrid;
  end;

  // @exclude(not yet overwritten)
  TMPHMemoryStream = class(TMemoryStream);

  // @exclude(undo storage implementation)
  TMPHUndoStorage = class;

  // @exclude(offset format flags)
  TMPHOffsetFormatFlag = (offCalcWidth,
    // calculate minwidth depending on data size (width field = '-')
    offCalcRow,
    // calculate BytesPerUnit depending on bytes per row (=real line numbers)
    offCalcColumn  // " bytes per column (= column numbers)
    );

  // @exclude(set of the above flags)
  TMPHOffsetFormatFlags = set of TMPHOffsetFormatFlag;

  // @exclude(offset format record)
  TMPHOffsetFormat = record
    Format: string;     // format as string
    Prefix,
    Suffix: string;     // splitted format
    MinWidth: integer;  // min length of value (zero padded on the left)
    Flags:              // auto calculation flags
    TMPHOffsetFormatFlags;
    Radix,              // radix (base) of display (2..16)
    BytesPerUnit: byte; // length of one unit (1 Byte...BytesPerRow Bytes)
  end;

  // protected ancestor of the hex editor components
  TCustomMPHexEditor = class(TCustomGrid)
  private
    FCharWidth,
    FCharHeight: integer;
    FBookmarkImageList: TImageList;
    FInsertModeOn: boolean;
    FCaretBitmap: TBitmap;
    FColors: TMPHColors;
    FBytesPerRow: integer;
    FOffSetDisplayWidth: integer;
    FBytesPerRowDup: integer;
    FDataSize: integer;
    FDataStorage: TMPHMemoryStream;
    FSwapNibbles: integer;
    FFocusFrame: boolean;
    FIsFileReadonly: boolean;
    FBytesPerCol: integer;
    FPosInCharField: boolean;
    FFileName: string;
    FModifiedBytes: TBits;
    FBookmarks: TMPHBookmarks;
    FSelStart,
    FSelPosition,
    FSelEnd: integer;
    FSelBeginPosition: integer;
    FTranslation: TMPHTranslationKind;
    FModified: boolean;
    FCaretKind: TMPHCaretKind;
    FLastKeyWasMenuKey: boolean;
    FReplaceUnprintableCharsBy: char;
    FDisallowSizeChange: boolean;
    FAllowInsertMode: boolean;
    FWantTabs: boolean;
    FReadOnlyView: boolean;
    FHideSelection: boolean;
    FGraySelOnLostFocus: boolean;
    FOnFileProgress: TMPHProgressEvent;
    FMouseDownCol,
    FMouseDownRow: integer;
    FShowDrag: boolean;
    FShowDragCol,
    FShowDragRow: integer;
    FMouseUpCanResetSel: boolean;
    FOnInvalidKey,
    FOnTopLeftChanged: TNotifyEvent;
    FDrawGridLines: boolean;
    FDrawGutter3D: boolean;
    FGutterWidth: integer;
    FOffsetFormat: TMPHOffsetFormat;
    FSelectionPossible: boolean;
    FBookmarkBitmap: TBitmap;
    FCursorList: array of integer;
    FHasCustomBMP: boolean;
    FStreamFileName: string;
    FHasFile: boolean;
    FMaxUndo: integer;
    FHexChars: array[0..15] of char;
    FHexLowerCase: boolean;
    FOnChange: TNotifyEvent;
    FShowRuler: boolean;
    property Color;
    procedure InternalErase(const KeyWasBackspace: boolean; const UndoDesc: string = '');
    procedure SetReadOnlyView(const Value: boolean);
    procedure SetCaretKind(const Value: TMPHCaretKind);
    procedure SetFocusFrame(const Value: boolean);
    procedure SetBytesPerColumn(const Value: integer);
    procedure SetSwapNibbles(const Value: boolean);
    function GetSwapNibbles: boolean;
    function GetBytesPerColumn: integer;
    procedure SetOffsetDisplayWidth;
    procedure SetColors(const Value: TMPHColors);
    procedure SetReadOnlyFile(const Value: boolean);
    procedure SetTranslation(const Value: TMPHTranslationKind);
    procedure SetModified(const Value: boolean);
    procedure SetChanged(DataPos: integer; const Value: boolean);
    procedure SetNoSizeChange(const Value: boolean);
    procedure SetAllowInsertMode(const Value: boolean);
    function GetInsertMode: boolean;
    procedure SetWantTabs(const Value: boolean);
    procedure SetHideSelection(const Value: boolean);
    procedure SetGraySelectionIfNotFocused(const Value: boolean);
    function CalcColCount: integer;
    function GetLastCharCol: integer;
    function GetPropColCount: integer;
    function GetPropRowCount: integer;
    function GetMouseOverSelection: boolean;
    function CursorOverSelection(const X, Y: integer): boolean;
    function MouseOverFixed(const X, Y: integer): boolean;
    procedure AdjustBookmarks(const From, Offset: integer);
    procedure IntSetCaretPos(const X, Y: integer);
    procedure TruncMaxPosition(var DataPos: integer);
    procedure SetSelection(const DataPos, StartPos, EndPos: integer);
    procedure NewSelection(const SelFrom, SelTo: integer);
    function GetCurrentValue: integer;
    procedure SetInsertMode(const Value: boolean);
    function GetModified: boolean;
    function GetDataPointer: Pointer;
    procedure SetBytesPerRow(const Value: integer);
    procedure SetMaskChar(const Value: char);
    procedure SetAsText(const Value: string);
    procedure SetAsHex(const Value: string);
    function GetAsText: string;
    function GetAsHex: string;
    procedure WMTimer(var Msg: TWMTimer); message WM_TIMER;
    function CheckMouseCoord(var X, Y: integer): TGridCoord;
    // get the row according to the given buffer position
    function GetRow(const DataPos: integer): integer;
    // invalid key pressed (in ebcdic)
    procedure WrongKey;
    // create a colored caret bitmap
    procedure CreateColoredCaret;
    // get start of selection
    function GetSelStart: integer;
    // get end of selection
    function GetSelEnd: integer;
    // get selection count
    function GetSelCount: integer;
    // set selection start
    procedure SetSelStart(aValue: integer);
    // set selection end
    procedure SetSelEnd(aValue: integer);
    // position the caret in the given field
    procedure SetInCharField(const Value: boolean);
    // is the caret in the char field ?
    function GetInCharField: boolean;
    // insert a buffer (internal)
    procedure InternalInsertBuffer(Buffer: PChar; const Size, Position: integer);
    // append some data (int)
    procedure InternalAppendBuffer(Buffer: PChar; const Size: integer);
    // store the caret properties
    procedure InternalGetCurSel(var StartPos, EndPos, ACol, ARow: integer);
    // delete data
    procedure InternalDelete(StartPos, EndPos, ACol, ARow: integer);
    // delete one half byte
    function InternalDeleteNibble(const Pos: integer;
      const HighNibble: boolean): boolean;
    // insert half byte
    function InternalInsertNibble(const Pos: integer;
      const HighNibble: boolean): boolean;
    // used by nibble functions
    function CreateShift4BitStream(const StartPos: integer;
      var FName: TFileName): TFileStream;
    // convert a given amount of data from ansi to something different and vice versa
    procedure InternalConvertRange(const aFrom, aTo: integer; const aTransFrom,
      aTransTo: TMPHTranslationKind);
    // move data in buffer to a different position
    procedure MoveFileMem(const aFrom, aTo, aCount: integer);
    function GetBookmark(Index: byte): TMPHBookmark;
    procedure SetBookmark(Index: byte; const Value: TMPHBookmark);
    procedure SetBookmarkVals(const Index: byte; const Position: integer;
      const InCharField: boolean);
    procedure SetDrawGridLines(const Value: boolean);
    procedure SetGutterWidth(const Value: integer);
    // images have changed
    procedure BookmarkBitmapChanged(Sender: TObject);
    procedure SetBookmarkBitmap(const Value: TBitmap);
    function GetVersion: string;
    procedure SetVersion(const Value: string);
    // free alloc'd memory of one of the storage streams;
    procedure FreeStorage(FreeUndo: boolean = False);
    function GetCanUndo: boolean;
    function GetCanRedo: boolean;
    function GetUndoDescription: string;
    function GetOffsetFormat: string;
    procedure SetOffsetFormat(const Value: string);
    // generate offset format
    procedure GenerateOffsetFormat(Value: string);
    procedure SetHexLowerCase(const Value: boolean);
    procedure SetDrawGutter3D(const Value: boolean);
    procedure SetShowRuler(const Value: boolean);
  protected
    // True: cells are currently to be selected
    FIsSelecting: boolean;
    // memory stream which contains the undo/redo data
    FUndoStorage: TMPHUndoStorage;
    // call changed on every undo creation for OnChange event
    procedure Changed; virtual;
    // returns the drop file position after a drag'n'drop operation
    function DropPosition: integer;
    // copy a stream to a second one and fire the OnLoadSaveProgress handler
    procedure Stream2Stream(strFrom, strTo: TStream; const Operation: TMPHProgressKind);
    // copy the data to a stream
    procedure CopyToStream(strTo: TStream; const Operation: TMPHProgressKind;
      const FileName: string);
    (* allows descendants to take special action if contents are to be saved
     to the file from where the data was load *)
    procedure PrepareOverwriteDiskFile; virtual;
    // store the current Cursor and set it to crHourGlass (see also @link(OldCursor))
    procedure WaitCursor;
    // reset the Cursor to the previous value (see also @link(WaitCursor))
    procedure OldCursor;
    // @exclude(override paint)
    procedure Paint; override;
    // @exclude(view changed)
    procedure TopLeftChanged; override;
    // get the data at the specified position
    function GetMemory(aIndex: integer): char;
    // set the data at the specified position
    procedure SetMemory(aIndex: integer; const aChar: char);
    // adjust cell widths/heigths depending on font, offset format, bytes per row/column...
    procedure AdjustMetrics;
    // get the size of the contained data
    function GetDataSize: integer;
    // @exclude(calculate the grid sizes)
    procedure CalcSizes;
    // @exclude(select one cell)
    function SelectCell(ACol, ARow: longint): boolean; override;
    // @exclude(get the data position depending on col and row)
    function GetPosAtCursor(const aCol, aRow: integer): integer;
    // @exclude(vice versa)
    function GetCursorAtPos(const aPos: integer; const aChars: boolean): TGridCoord;
    // @exclude(get the column of the other field (hex<->char))
    function GetOtherFieldCol(const aCol: integer; var Chars: boolean): integer;
    // @exclude(can the cell be selected ?)
    function CheckSelectCell(aCol, aRow: integer): boolean;
    // @exclude(char message handler)
    procedure WMChar(var Msg: TWMChar); message WM_CHAR;
    // @exclude(posted message to update the caret position)
    procedure WMINTUPDATECARET(var Msg: TMessage); message WM_INTUPDATECARET;
    // @exclude(for shortcuts)
    procedure WMGetDlgCode(var Msg: TWMGetDlgCode); message WM_GETDLGCODE;
    // @exclude(readjust grid sizes after font has changed)
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
    // @exclude(get a specified part of the data (buffer must be large enough))
    procedure GetMemAtPos(aBuffer: PByteArray; const aPos, aCount: integer);
    // @exclude(overwrite the buffer data)
    procedure SetMemAtPos(aBuffer: PByteArray; const aPos, aCount: integer);
    // @exclude(change a byte at the given position)
    procedure IntChangeByte(const aOldByte, aNewByte: byte;
      aPos, aCol, aRow: integer; const UndoDesc: string = '');
    // @exclude(keydown handler)
    procedure KeyDown(var Key: word; Shift: TShiftState); override;
    // @exclude(keyup handler)
    procedure KeyUp(var Key: word; Shift: TShiftState); override;
    // @exclude(has this byte been modified ?)
    function HasChanged(aPos: integer): boolean;
    // @exclude(parse control keys)
    function ParseKeyDown(aShift: TShiftState; aChar: char): boolean; virtual;
    // @exclude(is the cell part of the selection ?)
    function IsSelected(const aPos: integer): boolean;
    // @exclude(redraw some lines)
    procedure RedrawPos(aFrom, aTo: integer);
    // @exclude(make a selection)
    procedure Select(const aCurCol, aCurRow, aNewCol, aNewRow: integer);
    // @exclude(mouse down handler)
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: integer); override;
    // @exclude(mouse move handler)
    procedure MouseMove(Shift: TShiftState; X, Y: integer); override;
    // @exclude(mouse up handler)
    procedure MouseUP(Button: TMouseButton; Shift: TShiftState;
      X, Y: integer); override;
    // @exclude(add an undo to the undo buffer)
    function CreateUndo(const aKind: TMPHUndoFlag;
      const aPos, aCount, aReplCount: integer;
      const sDesc: string = ''): boolean;
    // @exclude(after loading)
    procedure Loaded; override;
    // @exclude(override CreateWnd)
    procedure CreateWnd; override;
    // @exclude(wm_setfocus handler)
    procedure WMSetFocus(var Msg: TWMSetFocus); message WM_SETFOCUS;
    // @exclude(wm_killfocus handler)
    procedure WMKillFocus(var Msg: TWMKillFocus); message WM_KILLFOCUS;
    // @exclude(wm_vscroll handler)
    procedure WMVScroll(var Msg: TWMVScroll); message WM_VSCROLL;
    // @exclude(wm_hscroll handler)
    procedure WMHScroll(var Msg: TWMHScroll); message WM_HSCROLL;
    // @exclude(resize the control)
    procedure Resize; override;
    // @exclude(store bitmap ? (its set to true, if a custom bitmap has been stored in BookmarkBitmap))
    function HasCustomBookmarkBitmap: boolean;
    // number of bytes to show in each row
    property BytesPerRow: integer read FBytesPerRow write SetBytesPerRow;
    // number of bytes to show in each column
    property BytesPerColumn: integer read GetBytesPerColumn write SetBytesPerColumn default 2;
    (* translation kind of the data (used to show characters on and to handle key presses in the char pane),
       (see also @link(TMPHTranslationKind))
    *)
    property Translation: TMPHTranslationKind read FTranslation write SetTranslation;
    (* offset display ("line numbers") format, in the form<br>
       [r|c|&lt;HEXNUM&gt;%][-|&lt;HEXNUM&gt;!]&lt;HEXNUM&gt;:[Prefix]|[Suffix]<br>
       (&lt;HEXNUM&gt; means a number in hexadecimal format (without prefix/suffix))<br><br>
       - first field (up to the percent sign):<br>
       <ul>
       <li>sets the "bytes per unit field" of the offset display format</li>
       <li>if it's set to 1, each row offset displays the data position in bytes</li>
       <li>if it's set to 2, each row offset displays the data position in words</li>
       <li>if it's set to 4, each row offset displays the data position in dwords</li>
       <li>if it's set to "r", each row offset displays the current row number (1st row=0,
       see also @link(BytesPerRow))</li>
       <li>if it's set to "c", each row offset displays the current column number (1st column=0,
       see also @link(BytesPerColumn))</li>
       <li>if this field is omitted, bytes per unit is set to 1</li>
       </ul><br>
       - second field (up to the exclamation mark):<br>
       <ul>
       <li>sets the minimum width of the number part, if the number is shorter, it will be padded
       by '0' chars at the left</li>
       <li>if this field reads -!, the the minimum width is automatically set to the longest number
       that can appear in the editor (the data's size)</li>
       <li>if this field is omitted, the minimum width is set to 1</li>
       </ul><br>
       - third field (up to the colon):<br>
       <ul>
       <li>sets the radix (base) of the offset format in hex notation</li>
       <li>set this to '10' (without quotes) for hexadecimal offset display, set it to '08' for
       octal and to '0a' for decimal offset display</li>
       <li>this field cannot be omitted, but the whole format string my be blank to avoid the display of
       offset identifiers</li>
       </ul></br>
       - fourth field (up to the pipe ('|') char):<br>
       <ul>
       <li>the prefix that is put in front of the "number" string (e.g. '0x' or '$' to show that numbers are in hex format)
       </li><li>this field may be omitted (but not the pipe char!)</li>
       </ul><br>
       - fifth (and last) field:<br>
       <ul>
       <li>the suffix to put after the "number string" (e.g. 'h' to show hex numbers)</li>
       <li>this field may be omitted</li></ul>
    *)
    property OffsetFormat: string read GetOffsetFormat write SetOffsetFormat;
    // look of the editor's caret (see @link(TMPHCaretKind))
    property CaretKind: TMPHCaretKind read FCaretKind write SetCaretKind default ckAuto;
    // colors to display (see @link(TMPHColors))
    property Colors: TMPHColors read FColors write SetColors;
    (* if FocusFrame is set to True, the current caret position will be displayed in the
       second field (hex - characters) as a dotted focus frame, if set to False, it will
       be shown as an ordinary rectangle
    *)
    property FocusFrame: boolean read FFocusFrame write SetFocusFrame;
    (* if SwapNibbles is set to True, the hex pane will show all bytes in the order
       lower 4 bits-higher 4 bits (i.e. the value 192 dec = C0 hex will be drawn as
       0C). if set to False, hex values will be displayed in usual order. this
       setting also affects hex data input and hex-string conversions
    *)
    property SwapNibbles: boolean read GetSwapNibbles write SetSwapNibbles default False;
    // replace whitespaces (#0..#31) with the following character in the character pane
    property MaskChar: char read FReplaceUnprintableCharsBy write SetMaskChar default '.';
    (* if set to True, the data size is readonly, e.g. no data may be appended, deleted
       or inserted, just overwriting is allowed. this also affects @link(InsertMode).
    *)
    property NoSizeChange: boolean read FDisallowSizeChange write SetNoSizeChange
      default False;
    (* if set to False, switching between overwrite and insert mode is not allowed
       (see also @link(InsertMode) and @link(NoSizeChange))
    *)
    property AllowInsertMode: boolean read FAllowInsertMode write SetAllowInsertMode
      default True;
    (* if set to True, the Tab key is used to switch the caret between hex and character pane.
       if set to False, the Tab key can be used to switch between controls. then the
       combination CTRL+T is used to switch the panes
    *)
    property WantTabs: boolean read FWantTabs write SetWantTabs default True;
    // if set to True, the data can not be edited, just cursor movement is allowed ("Hex Viewer" mode)
    property ReadOnlyView: boolean read FReadOnlyView write SetReadOnlyView default False;
    // hide the current selection when the hex editor looses focus (see also @link(GraySelectionIfNotFocused))
    property HideSelection: boolean read FHideSelection write SetHideSelection default False;
    (* if set to True and @link(HideSelection) is False, then the current selection will be
       grayed when the hex editor looses focus (the values from the @link(Colors) property will
       be converted to grayscale colors)
    *)
    property GraySelectionIfNotFocused: boolean 
      read FGraySelOnLostFocus write SetGraySelectionIfNotFocused default False;
    (* this event is called in @link(LoadFromFile) and @link(SaveToFile) routines, so a
       progress indicator may be updated (see also @link(TMPHProgressEvent))
    *)
    property OnLoadSaveProgress: TMPHProgressEvent 
      read FOnFileProgress write FOnFileProgress;
    (* this event is fired if an invalid character has been typed (like non-hex characters
       in the hex pane)
    *)
    property OnInvalidKey: TNotifyEvent read FOnInvalidKey write FOnInvalidKey;
    // this event is fired if the first visible row or column have been changed (e.g. on scrolling)
    property OnTopLeftChanged: TNotifyEvent read FOnTopLeftChanged write FOnTopLeftChanged;
    // returns the current selection in hex format ('00010203...') as string, uses @link(SwapNibbles)
    function GetSelectionAsHex: string;
    (* replace the current selection by a string containing data in hex format ('00 01 02 03' or similar),
      uses @link(SwapNibbles)
    *)
    procedure SetSelectionAsHex(const s: string);
    // returns a string containing the currently selected data
    function GetSelectionAsText: string;
    // replaces the currently selected data with the string's contents
    procedure SetSelectionAsText(const s: string);
    // if set to True, a grid is drawn
    property DrawGridLines: boolean read FDrawGridLines write SetDrawGridLines;
    // width of the offset display gutter, if set to -1, automatically adjust the gutter's width
    property GutterWidth: integer read FGutterWidth write SetGutterWidth default - 1;
    (* bitmap containing 20 10x10 pixels pictures for bokkmarks (they are displayed in the offset
      gutter), the first ten pictures represent the bookmarks 0(10)..9, if they are set in the
      hexpane, the last 10 pics are shown if bookmarks are set in the character pane (see also
      @link(TMPHBookMark))
    *)
    property BookmarkBitmap: TBitmap read FBookmarkBitmap write SetBookmarkBitmap
      stored HasCustomBookmarkBitmap;
    // current version of the hex editor component (returns the build data), readonly
    property Version: string read GetVersion write SetVersion stored False;
    // maximum memory that is used for undo storage (in bytes, approximately)
    property MaxUndo: integer read FMaxUndo write FMaxUndo default 1024 * 1024;
    (* insert mode (typed characters are inserted at the current position) or
       overwrite mode (typed characters replace values at the current position), see also
       @link(AllowInsertMode), @link(NoSizeChange) and @link(ReadOnlyView)
    *)
    property InsertMode: boolean read GetInsertMode write SetInsertMode default False;
    // if set to True, hex data and hex offsets are displayed in lower case
    property HexLowerCase: boolean read FHexLowerCase write SetHexLowerCase default False;
    // this event is called on every data change (load/empty/undo/redo)
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    // if set to True, a 3d line is drawn at the right of the offset gutter
    property DrawGutter3D: boolean read FDrawGutter3D write SetDrawGutter3D default True;
    // if set to True, a ruler is shown above the first row
    property ShowRuler: boolean read FShowRuler write SetShowRuler default False;
  public
    { Public-Deklarationen }
    //@exclude()
    constructor Create(aOwner: TComponent); override;
    //@exclude()
    destructor Destroy; override;
    // has data been load from/saved to a file (or is the filename valid)
    property HasFile: boolean read FHasFile write FHasFile;
    (* each call to UndoBeginUpdate increments an internal counter that prevents using
       undo storage and also disables undo functionality (see also @link(UndoEndUpdate))
    *)
    procedure UndoBeginUpdate;
    (* each call to UndoEndUpdate decrements an internal counter that prevents using
       undo storage and also disables undo functionality. the return value is the value
       of this counter. if the counter is reset to zero, undo creation is permitted again
       (see also @link(UndoBeginUpdate))
    *)
    function UndoEndUpdate: integer;
    // remove selection state from all data
    procedure ResetSelection(const aDraw: boolean);
    // see @link(GetSelectionAsHex) and @link(SetSelectionAsHex)
    property SelectionAsHex: string read GetSelectionAsHex write SetSelectionAsHex;
    // see @link(GetSelectionAsText) and @link(SetSelectionAsText)
    property SelectionAsText: string read GetSelectionAsText write SetSelectionAsText;
    (* returns the given position as it would be drawn in the offset gutter,
      see also @link(OffsetFormat)
    *)
    function GetOffsetString(const Position: cardinal): string; virtual;
    (* returns the given position as it would be drawn in the offset gutter, exception:
      if @link(OffsetFormat) is set to an empty string, returns the hexadecimal representation
      of the Position value (see also @link(GetOffsetString))
    *)
    function GetAnyOffsetString(const Position: integer): string; virtual;
    // returns the height of one row in pixels
    function RowHeight: integer;
    // free the undo storage (discard all possible undo steps)
    procedure ResetUndo;
    // set the current position (like TStream.Seek)
    function Seek(const aOffset, aOrigin: integer): integer;
    (* searches for text or data in the data buffer, returns the find position (-1, if data have not been found):<br><br>
       - aBuffer: data to search for<br>
       - aCount: size of data in aBuffer<br>
       - aStart: start search at this position<br>
       - aEnd: searches up to this position<br>
       - IgnoreCase: if True, lowercase and uppercase characters are treated as if they were equal<br>
       - SearchText: if True, the current @link(Translation) is taken into account when searching textual data
    *)
    function Find(aBuffer: PChar; const aCount, aStart, aEnd: integer;
      const IgnoreCase, SearchText: boolean): integer;
    // delete the currently selected data
    procedure DeleteSelection(const UndoDesc: string = '');
    // load the contents of a stream into the data buffer
    procedure LoadFromStream(Strm: TStream);
    // load the contents of a file into the data buffer
    procedure LoadFromFile(const Filename: string);
    // save the contents of the data buffer into a stream
    procedure SaveToStream(Strm: TStream);
    // save the contents of the data buffer to a file
    procedure SaveToFile(const Filename: string; const aUnModify: boolean = True);
    // undo the last modification, multiple undos are possible
    function Undo: boolean;
    // discard the last undo action (only one single redo is possible)
    function Redo: boolean;
    // empty the data buffer and set the filename (e.g. "Untitled")
    procedure CreateEmptyFile(const TempName: string);
    (* returns a buffer containing parts of the data buffer's contents. the buffer is allocated
       in this routine and must be freed by the caller
    *)
    function BufferFromFile(const aPos: integer; var aCount: integer): PChar;
    // insert some data at the specified position into the data buffer
    procedure InsertBuffer(aBuffer: PChar; const aSize, aPos: integer;
      const UndoDesc: string = '');
    // append some data at the end of the data buffer
    procedure AppendBuffer(aBuffer: PChar; const aSize: integer;
      const UndoDesc: string = '');
    // replace the currently selected data with some other data
    procedure ReplaceSelection(aBuffer: PChar; aSize: integer;
      const UndoDesc: string = '');
    // get the current data position (depending on the cursor/caret)
    function GetCursorPos: integer;
    // delete 4 bits (=half byte = nibble) from the data buffer (see also @link(InsertNibble))
    function DeleteNibble(const aPos: integer; const HighNibble: boolean;
      const UndoDesc: string = ''): boolean;
    // insert 4 bits (0000) into the data buffer (see also @link(DeleteNibble))
    function InsertNibble(const aPos: integer; const HighNibble: boolean;
      const UndoDesc: string = ''): boolean;
    // convert a part of the data buffer's content from one character table to a different one
    procedure ConvertRange(const aFrom, aTo: integer; const aTransFrom,
      aTransTo: TMPHTranslationKind; const UndoDesc: string = '');
    (* returns the data position of the top left cell and also whether the caret is in the
       character pane, see also @link(SetTopLeftPosition)
    *)
    function GetTopLeftPosition(var oInCharField: boolean): integer;
    (* set top left cell to the given data position and also whether the caret is in the
       character pane (see also @link(GetTopLeftPosition))
    *)
    procedure SetTopLeftPosition(const aPosition: integer; const aInCharField: boolean);
    (* show a drop position marker on the cell at the given mouse cursor position
      (see also @link(HideDragCell))
    *)
    function ShowDragCell(const X, Y: integer): integer;
    // hide the drop position marker (see also @link(ShowDragCell))
    procedure HideDragCell;
    // combine two or more changes, so @link(Undo) will discard the at once
    function CombineUndo(const aCount: integer; const sDesc: string = ''): boolean;
    (* translate a byte from the current @link(Translation) to the Windows Codepage
      (see also @link(TranslateFromAnsiChar))
    *)
    function TranslateToAnsiChar(const aByte: byte): char;
    (* translate a byte from Windows Codepage to the current @link(Translation)
      (see also @link(TranslateToAnsiChar))
    *)
    function TranslateFromAnsiChar(const aByte: byte): char;
    // retrieve or set the selection start
    property SelStart: integer read GetSelStart write SetSelStart;
    // retrieve or set the selection end
    property SelEnd: integer read GetSelEnd write SetSelEnd;
    // retrieve the size of the selected data
    property SelCount: integer read GetSelCount;
    // is @link(Undo) possible?
    property CanUndo: boolean read GetCanUndo;
    // is @link(Redo) possible?
    property CanRedo: boolean read GetCanRedo;
    // is the caret in the character or the hex pane ?
    property InCharField: boolean read GetInCharField write SetInCharField;
    // description of the next @link(Undo) action
    property UndoDescription: string read GetUndoDescription;
    // if True, the currently loaded file cannot be overwritten
    property ReadOnlyFile: boolean read FIsFileReadonly write SetReadOnlyFile;
    // if True, changes have been made to the data buffer content
    property Modified: boolean read GetModified write SetModified;
    // retrieves the amount of data in the data buffer
    property DataSize: integer read GetDataSize;
    // array to the data buffer's content
    property Data[Index: integer]: char read GetMemory write SetMemory;
    // retrieve or set the data as string
    property AsText: string read GetAsText write SetAsText;
    // retrieve or set the data as hex formatted string (00 01 02 03...)
    property AsHex: string read GetAsHex write SetAsHex;
    // name of the file that has been loaded into the data buffer
    property Filename: string read FFileName;
    // retrieve or set bookmarks programmatically (see also @link(TMPHBookmark))
    property Bookmark[Index: byte]: TMPHBookmark read GetBookmark write SetBookmark;
    // has the byte at the given position been modified ? (only in overwrite mode)
    property ByteChanged[index: integer]: boolean read HasChanged write SetChanged;
    // retrieves the number of columns (grid columns)
    property ColCountRO: integer read GetPropColCount;
    // retrieves the number of rows (grid rows)
    property RowCountRO: integer read GetPropRowCount;
    // returns True if the mouse cursor is positionned over selected data
    property MouseOverSelection: boolean read GetMouseOverSelection;
    // get the data value at the current caret position, returns -1 if an error occured
    property CurrentValue: integer read GetCurrentValue;
    // pointer to the whole data buffer's contents
    property DataPointer: Pointer read GetDataPointer;
    // select all data
    procedure SelectAll;
    // retrieves the number of visible columns
    property VisibleColCount;
    // retrieves the number of visible rows
    property VisibleRowCount;
    // the control's canvas
    property Canvas;
    // current column (grid column)
    property Col;
    // first visible column
    property LeftCol;
    // current row (grid row)
    property Row;
    // @exclude(tab stops)
    property TabStops;
    // first visible row (grid row)
    property TopRow;
  end;

  // published hex editor component
  TMPHexEditor = class(TCustomMPHexEditor)
  published
    // @exclude()
    property Align;
    // @exclude()
    property BorderStyle;
    // @exclude()
    property Ctl3D;
    // @exclude()
    property DragCursor;
    // @exclude()
    property DragMode;
    // @exclude()
    property Enabled;
    // @exclude()
    property Font;
    // @exclude()
    property ParentCtl3D;
    // @exclude()
    property ParentShowHint;
    // @exclude()
    property PopupMenu;
    // @exclude()
    property ScrollBars;
    // @exclude()
    property ShowHint;
    // @exclude()
    property TabOrder;
    // @exclude()
    property TabStop;
    // @exclude()
    property Visible;
    // @exclude()
    property OnClick;
    // @exclude()
    property OnDblClick;
    // @exclude()
    property OnDragDrop;
    // @exclude()
    property OnDragOver;
    // @exclude()
    property OnEndDrag;
    // @exclude()
    property OnEnter;
    // @exclude()
    property OnExit;
    // @exclude()
    property OnKeyDown;
    // @exclude()
    property OnKeyPress;
    // @exclude()
    property OnKeyUp;
    // @exclude()
    property OnMouseDown;
    // @exclude()
    property OnMouseMove;
    // @exclude()
    property OnMouseUp;
    // @exclude()
    property OnStartDrag;
    // @exclude()
    property Anchors;
    // @exclude()
    property BiDiMode;
    // @exclude()
    property Constraints;
    // @exclude()
    property DragKind;
    // @exclude()
    property ParentBiDiMode;
    // @exclude()
    property OnEndDock;
    // @exclude()
    property OnMouseWheel;
    // @exclude()
    property OnMouseWheelDown;
    // @exclude()
    property OnMouseWheelUp;
    // @exclude()
    property OnStartDock;
    // see inherited @inherited
    property BytesPerRow;
    // see inherited @inherited
    property BytesPerColumn;
    // see inherited @inherited
    property Translation;
    // see inherited @inherited
    property OffsetFormat;
    // see inherited @inherited
    property CaretKind;
    // see inherited @inherited
    property Colors;
    // see inherited @inherited
    property FocusFrame;
    // see inherited @inherited
    property SwapNibbles;
    // see inherited @inherited
    property MaskChar;
    // see inherited @inherited
    property NoSizeChange;
    // see inherited @inherited
    property AllowInsertMode;
    // see inherited @inherited
    property DrawGridLines;
    // see inherited @inherited
    property WantTabs;
    // see inherited @inherited
    property ReadOnlyView;
    // see inherited @inherited
    property HideSelection;
    // see inherited @inherited
    property GraySelectionIfNotFocused;
    // see inherited @inherited
    property GutterWidth;
    // see inherited @inherited
    property BookmarkBitmap;
    // see inherited @inherited
    property Version;
    // see inherited @inherited
    property MaxUndo;
    // see inherited @inherited
    property InsertMode;
    // see inherited @inherited
    property HexLowerCase;
    // see inherited @inherited
    property OnLoadSaveProgress;
    // see inherited @inherited
    property OnInvalidKey;
    // see inherited @inherited
    property OnTopLeftChanged;
    // see inherited @inherited
    property OnChange;
    // see inherited @inherited
    property DrawGutter3D;
    // see inherited @inherited
    property ShowRuler;
  end;

  // @exclude(undo storage record)
  PMPHUndoRec = ^TMPHUndoRec;
  // @exclude(undo storage record)
  TMPHUndoRec = packed record
    DataLen: integer;
    Flags: TMPHUndoFlags;
    CurPos: integer;
    Pos, Count, ReplCount: cardinal;
    Translation: TMPHTranslationKind;
    Buffer: byte;
  end;

  // @exclude(implements undo/redo)
  TMPHUndoStorage = class(TMPHMemoryStream)
  private
    FCount,
    FUpdateCount: integer;
    FEditor: TCustomMPHexEditor;
    FDescription: string;
    FRedoPointer,
    FLastUndo: PMPHUndoRec;
    FLastUndoSize: integer;
    FLastUndoDesc: string;
    procedure SetCount(const Value: integer);
    procedure ResetRedo;
    procedure CreateRedo(const Rec: TMPHUndoRec);
    function GetUndoKind(const Flags: TMPHUndoFlags): TMPHUndoFlag;
  public
    constructor Create(AEditor: TCustomMPHexEditor);
    destructor Destroy; override;
    procedure SetSize(NewSize: longint); override;
    procedure CreateUndo(aKind: TMPHUndoFlag; APosition, ACount, AReplaceCount: integer;
      const SDescription: string = '');
    function CanUndo: boolean;
    function CanRedo: boolean;
    function Redo: boolean;
    function Undo: boolean;
    function BeginUpdate: integer;
    function EndUpdate: integer;
    procedure Reset(AResetRedo: boolean = True);
    property Count: integer read FCount write SetCount;
    property UpdateCount: integer read FUpdateCount;
    property Description: string read FDescription;
  end;

resourcestring
  // long descriptive names of character translations
  // tkAsIs
  MPTH_TK_ASIS = 'Windows';
  // tkDos8
  MPTH_TK_DOS8 = 'Dos 8 Bit';
  // tkASCII
  MPTH_TK_ASCII7 = 'ASCII 7 Bit';
  // tkMac
  MPTH_TK_MAC = 'Macintosh';
  // tkBCD
  MPTH_TK_BCD38 = 'EBCDIC Codepage 38';
  // tkCustom
  MPTH_TK_CUSTOM = 'Custom Translation';

  // short names (e.g. for status bars) of character translations
  // tkAsIs
  MPTH_TK_ASIS_S = 'WIN';
  // tkDos8
  MPTH_TK_DOS8_S = 'DOS';
  // tkASCII
  MPTH_TK_ASCII7_S = 'ASC';
  // tkMac
  MPTH_TK_MAC_S = 'MAC';
  // tkBCD
  MPTH_TK_BCD38_S = 'BCD';
  // tkCustom
  MPTH_TK_CUSTOM_S = 'Cust';

const
  // long descriptions of the different translations (e.g. for menues)
  MPHTranslationDesc: array[TMPHTranslationKind] of
  string = (MPTH_TK_ASIS, MPTH_TK_DOS8, MPTH_TK_ASCII7, MPTH_TK_MAC,
    MPTH_TK_BCD38, MPTH_TK_CUSTOM);

  // short descriptions of the different translations (e.g. for status bars)
  MPHTranslationDescShort: array[TMPHTranslationKind] of
  string = (MPTH_TK_ASIS_S, MPTH_TK_DOS8_S, MPTH_TK_ASCII7_S, MPTH_TK_MAC_S,
    MPTH_TK_BCD38_S, MPTH_TK_CUSTOM_S);


  // public utility functions

(* translate a hexadecimal data representation ("a000 cc45 d3 42"...) to binary data
   (see @link(SwapNibbles) for the meaning of the SwapNibbles value)
*)
function ConvertHexToBin(aFrom, aTo: PChar; const aCount: integer;
  const SwapNibbles: boolean; var BytesTranslated: integer): PChar;

(* translate binary data to its hex representation (see @link(ConvertHexToBin)),
   (see @link(SwapNibbles) for the meaning of the SwapNibbles value)
*)
function ConvertBinToHex(aFrom, aTo: PChar; const aCount: integer;
  const SwapNibbles: boolean): PChar;

  // convert X and Y into a TGridCoord record
function GridCoord(aX, aY: longint): TGridCoord;
  // check whether the given key (VK_...) is currently down
function IsKeyDown(aKey: integer): boolean;
  // get a unique filename in the temporary directory
function GetTempName: string;

(* translate an integer to a radix (base) coded string, e.g.<br>
  - IntToRadix(100,16) converts into a hexadecimal (number) string<br>
  - IntToRadix(100,2) converts into a string consisting only of 0 and 1<br>
  - IntToRadix(100,8) means IntToOctal<br>
  <br>
  hint: Radix must be in the range of 2..16*)
function IntToRadix(Value: integer; Radix: byte): string;
  // translate an integer to a radix coded string and left fill with 0 (see also @link(IntToRadix))
function IntToRadixLen(Value: integer; Radix, Len: byte): string;
  // translate an integer to an octal string (see also @link(IntToRadix))
function IntToOctal(const Value: integer): string;

(* translate a radix coded number string into an integer, e.g.<br>
  - RadixToInt('0f', 16) => 15<br>
  - RadixToInt('755', 8) => 493
*)
function RadixToInt(Value: string; Radix: byte): integer;

(* try to find the correct radix (based on prefix/suffix) and return the number, known
   prefixes/suffixes are:<br>
   0x&lt;number&gt;, 0X&lt;number&gt;, $&lt;number&gt;, &lt;number&gt;h, &lt;number&gt;H: radix 16<br>
   o&lt;number&gt;, O&lt;number&gt;, 0&lt;number&gt;, &lt;number&gt;o, &lt;number&gt;O: radix 8<br>
   %&lt;number&gt;, &lt;number&gt;%: radix 2<br>
   otherwise: radix 10
*)
function CheckRadixToInt(Value: string): integer;

  // translate an number string built on radix 8 into an integer (see also @link(RadixToInt))
function OctalToInt(const Value: string): integer;

  // @exclude(fade a color to a gray value)
function FadeToGray(aColor: TColor): TColor;

(* translate data from Ansi to a different character set (see also @link(TMPHTranslationKind))<br>
  - TType: translate to this character set<br>
  - aBuffer: pointer to source data<br>
  - bBuffer: pointer to target data, must be allocated (may equal to aBuffer)<br>
  - aCount: number of bytes to translate
*)
procedure TranslateBufferFromAnsi(const TType: TMPHTranslationKind; aBuffer,
  bBuffer: PChar; const aCount: integer);
  // translate data from a different character set to Ansi (see also @link(TranslateBufferFromAnsi))
procedure TranslateBufferToAnsi(const TType: TMPHTranslationKind; aBuffer,
  bBuffer: PChar; const aCount: integer);

  // compatibility
  {$IFNDEF DELPHI6UP}
procedure RaiseLastOSError;
  {$ENDIF}

  // returns the lower of the two numbers
function Min(a1, a2: integer): integer;
  // returns the higer of the two numbers
function Max(a1, a2: integer): integer;

var
  (* translation tables for tkCustom *)

  // this table is used in translations from tkAsIs to tkCustom (see @link(TMPHTranslationKind))
  MPHCustTransFieldFrom: array[byte] of char;
  // this table is used in translations from tkCustom to tkAsIs (see @link(TMPHTranslationKind))
  MPHCustTransFieldTo: array[byte] of char;

const
  (* standard offset formats *)

  // standard offset format: hex, auto min width, prefixed by 0x
  MPHOffsetHex = '-!10:0x|';
  // standard offset format: decimal
  MPHOffsetDec = 'a:|';
  // standard offset format: octal, prefixed by 0 /except of 0 pos
  MPHOffsetOct = '0!8:0|';

implementation

uses
  Consts, {$IFDEF DELPHI6UP}RTLConsts, {$ENDIF}ImgList, StdCtrls;

const

  MPH_VERSION = 'October 25, 2002';

resourcestring

  // undo descriptions
  UNDO_BYTECHANGED = 'Change Byte';
  UNDO_REMOVED = 'Remove Data';
  UNDO_INSERT = 'Insert Buffer';
  UNDO_REPLACESEL = 'Replace Selection';
  UNDO_APPEND = 'Append Buffer';
  UNDO_INSNIBBLE = 'Insert Nibble';
  UNDO_DELNIBBLE = 'Delete Nibble';
  UNDO_CONVERT = 'Convert';
  UNDO_COMBINED = 'Multiple Modification';
  UNDO_NOUNDO = 'No Undo';

  // error messages
  ERR_FILE_OPEN_FAILED = 'Cannot open %s.'#13#10'(%s.)';
  ERR_FILE_READONLY = 'Cannot save readonly file %s.';
  ERR_INVALID_BOOKMARK = 'Invalid bookmark index';
  ERR_INVALID_SELSTART = 'Invalid selection start';
  ERR_INVALID_SELEND = 'Invalid selection end';
  ERR_INVALID_BYTESPERLINE = 'Invalid bytes per line argument';
  ERR_INVALID_MEMORY_INDEX = 'Invalid memory index';
  ERR_INVALID_BUFFERFROMFILE = 'Invalid buffer from file argument';
  ERR_INVALID_BYTESPERCOL = 'Invalid bytes per column argument';
  ERR_INVALID_BOOKMARKBMP = 'Invalid bookmark bitmap (must be 10 x 200 px)';
  ERR_CANCELLED = 'Operation Cancelled';
  ERR_MISSING_FORMATCHAR = 'Missing char in offset format: %s';
  ERR_INVALID_FORMATRADIX = 'Invalid radix in offset format (%xh), allowed: 02h..10h';
  ERR_INVALID_RADIXCHAR = 'Invalid character %s, cannot convert using radix %xh';
  ERR_INVALID_BPU = 'Invalid bytes per unit value %xh, allowed: 01h..BytesPerRow';

  // new, empty file
  UNNAMED_FILE = 'Untitled';

const
  // fixed cols/rows
  GRID_FIXED = 2;

  // available undo descriptions
  STRS_UNDODESC: array[ufKindByteChanged..ufKindCombined] of
  string = (UNDO_BYTECHANGED, UNDO_REMOVED, UNDO_INSERT,
    UNDO_REPLACESEL, UNDO_APPEND, UNDO_INSNIBBLE,
    UNDO_DELNIBBLE, UNDO_CONVERT, UNDO_COMBINED);

  // valid hex characters
  HEX_LOWER = '0123456789abcdef';
  HEX_UPPER = '0123456789ABCDEF';
  HEX_ALLCHARS = HEX_LOWER + HEX_UPPER;

  {$IFNDEF DELPHI6UP}
procedure RaiseLastOSError;
begin
  RaiseLastWin32Error;
end;
{$ENDIF}

// invert the given color

function Invert(Color: TColor): TColor;
begin
  Result := ColorToRGB(Color) xor $00FFFFFF;
end;

// translate the buffer from ANSI to the given translation mode

procedure TranslateBufferFromAnsi(const TType: TMPHTranslationKind; aBuffer,
  bBuffer: PChar; const aCount: integer);
var
  LIntLoop: integer;
  LChrConv: char;
begin
  case TType of
    tkAsIs: CopyMemory(aBuffer, bBuffer, aCount);
    tkDOS8,
    tkASCII: CharToOEMBuff(aBuffer, bBuffer, aCount);
    tkMAC: if aCount > 0 then
        for LIntLoop := 0 to Pred(aCount) do
        begin
          LChrConv := aBuffer[LIntLoop];
          if LChrConv < #128 then
            bBuffer[LIntLoop] := LChrConv
          else
            bBuffer[LIntLoop] := tblMSAnsi2Mac[Ord(LChrConv)];
        end;
    tkBCD: if aCount > 0 then
        for LIntLoop := 0 to Pred(aCount) do
          bBuffer[LIntLoop] := tblMSAnsi2BCD[Ord(aBuffer[LIntLoop])];
    tkCustom: if aCount > 0 then
        for LIntLoop := 0 to Pred(aCount) do
          bBuffer[LIntLoop] := MPHCustTransFieldFrom[Ord(aBuffer[LIntLoop])];
  end;
end;

// translate the buffer to ANSI from the given translation mode

procedure TranslateBufferToAnsi(const TType: TMPHTranslationKind; aBuffer,
  bBuffer: PChar; const aCount: integer);
var
  LIntLoop: integer;
  LChrConv: char;
begin
  case TType of
    tkAsIs: Move(aBuffer^, bBuffer^, aCount);
    tkDOS8,
    tkASCII: OEMToCharBuff(aBuffer, bBuffer, aCount);
    tkMAC: if aCount > 0 then
        for LIntLoop := 0 to Pred(aCount) do
        begin
          LChrConv := aBuffer[LIntLoop];
          if LChrConv < #128 then
            bBuffer[LIntLoop] := LChrConv
          else
            bBuffer[LIntLoop] := tblMac2MSAnsi[Ord(LChrConv)];
        end;
    tkBCD: if aCount > 0 then
        for LIntLoop := 0 to Pred(aCount) do
          bBuffer[LIntLoop] := tblBCD2MSAnsi[Ord(aBuffer[LIntLoop])];
    tkCustom: if aCount > 0 then
        for LIntLoop := 0 to Pred(aCount) do
          bBuffer[LIntLoop] := MPHCustTransFieldTo[Ord(aBuffer[LIntLoop])];
  end;
end;

// ansi to oem

function OEM2Char(aByte: byte): char;
var
  LszBuf: array[0..1] of char;
begin
  LszBuf[0] := char(aByte);
  LszBuf[1] := #0;
  OEMToChar(LSzBuf, LSzBuf);
  Result := LSzBuf[0];
end;

// oem to ansi

function Char2OEM(aByte: byte): char;
var
  LszBuf: array[0..1] of char;
begin
  LszBuf[0] := char(aByte);
  LszBuf[1] := #0;
  CharToOEM(LSzBuf, LSzBuf);
  Result := LSzBuf[0];
end;

(* helper functions *)

// get a temporary file name

function GetTempName: string;
var
  LStrTemp: string;
begin
  SetLength(LStrTemp, MAX_PATH + 1);
  SetLength(LStrTemp, GetTempPath(MAX_PATH, @LStrTemp[1]));
  LStrTemp := Trim(LStrTemp);
  {$IFDEF DELPHI6UP}
  LstrTemp := IncludeTrailingPathDelimiter(LstrTemp);
  {$ELSE}
  if LStrTemp[Length(LStrTemp)] <> '\' then
    LStrTemp := LStrTemp + '\';
  {$ENDIF}
  repeat
    Result := LStrTemp + IntToHex(GetTickCount, 8) + '.MPHT';
  until GetFileAttributes(PChar(Result)) = $FFFFFFFF;
end;

// can the file be opened for reading (evtl. read only) ?

function CanOpenFile(const aName: TFileName; var ReadOnly: boolean): boolean;
var
  LHdlFile: THandle;
begin
  Result := False;
  ReadOnly := True;
  if FileExists(aName) then
  begin
    LHdlFile := FileOpen(aName, fmOpenRead or fmShareDenyNone);
    if LHdlFile <> INVALID_HANDLE_VALUE then
    begin
      FileClose(LHdlFile);
      Result := True;
      LHdlFile := FileOpen(aName, fmOpenReadWrite);
      if LHdlFile <> INVALID_HANDLE_VALUE then
      begin
        FileClose(LHdlFile);
        ReadOnly := False;
      end;
    end;
  end;
end;

// is that key pressed ?

function IsKeyDown(aKey: integer): boolean;
begin
  Result := (GetKeyState(aKey) and (not 1)) <> 0;
end;

// return the lesser value

function Min(a1, a2: integer): integer;
begin
  if a1 < a2 then
    Result := a1
  else
    Result := a2;
end;

// return the bigger value

function Max(a1, a2: integer): integer;
begin
  if a1 > a2 then
    Result := a1
  else
    Result := a2;
end;

// cast x,y to grid coord

function GridCoord(aX, aY: longint): TGridCoord;
begin
  Result.x := aX;
  Result.y := aY;
end;

// convert '00 01 02...' to binary data

function ConvertHexToBin(aFrom, aTo: PChar; const aCount: integer;
  const SwapNibbles: boolean; var BytesTranslated: integer): PChar;
var
  LBoolHi: boolean;
  LIntLoop: integer;
  LBytCurrent: byte;
  LChrCurrent: char;
begin
  Result := aTo;
  BytesTranslated := 0;
  LBoolHi := True;
  LBytCurrent := 0;
  for LIntLoop := 0 to Pred(aCount) do
    if Pos(aFrom[LIntLoop], HEX_ALLCHARS) <> 0 then
    begin
      LChrCurrent := UpCase(aFrom[LIntLoop]);
      if LBoolHi then
        LBytCurrent := ((Pos(LChrCurrent, HEX_UPPER) - 1) * 16)
      else
        LBytCurrent := LBytCurrent or ((Pos(LChrCurrent, HEX_UPPER) - 1));

      LBoolHi := not LBoolHi;
      if LBoolHi then
      begin
        if SwapNibbles then
          aTo[BytesTranslated] := char(((LBytCurrent and 15) * 16) or
            ((LBytCurrent and $F0) shr
            4))
        else
          aTo[BytesTranslated] := char(LBytCurrent);

        Inc(BytesTranslated);
      end;
    end;
end;

// convert binary data to '00 01 02...'

function ConvertBinToHex(aFrom, aTo: PChar; const aCount: integer;
  const SwapNibbles: boolean): PChar;
var
  LIntLoop: integer;
  LByteCurrent: byte;
  LIntLoop2: integer;
begin
  Result := aTo;
  LIntLoop2 := 0;
  for LIntLoop := 0 to Pred(aCount) do
  begin
    LByteCurrent := Ord(aFrom[LIntLoop]);
    if SwapNibbles then
    begin
      aTo[LIntLoop2] := UpCase(HEX_UPPER[(LByteCurrent and 15) + 1]);
      aTo[LIntLoop2 + 1] := UpCase(HEX_UPPER[(LByteCurrent shr 4) + 1])
    end
    else
    begin
      aTo[LIntLoop2 + 1] := UpCase(HEX_UPPER[(LByteCurrent and 15) + 1]);
      aTo[LIntLoop2] := UpCase(HEX_UPPER[(LByteCurrent shr 4) + 1])
    end;

    Inc(LIntLoop2, 2);
  end;
  aTO[LIntLoop2] := #0;
end;


// translate an integer to a radix coded string and left fill with 0
function IntToRadixLen(Value: integer; Radix, Len: byte): string;
var
  LCrdTemp: cardinal absolute Value;
begin
  Result := '';
  repeat
    Result := HEX_UPPER[(LCrdTemp mod Radix) + 1] + Result;
    LCrdTemp := LCrdTemp div Radix;
  until LCrdTemp = 0;
  while Length(Result) < Len do
    Result := '0' + Result;
end;

// translate an integer to a radix coded string
function IntToRadix(Value: integer; Radix: byte): string;
var
  LCrdTemp: cardinal absolute Value;
begin
  Result := '';
  repeat
    Result := HEX_UPPER[(LCrdTemp mod Radix) + 1] + Result;
    LCrdTemp := LCrdTemp div Radix;
  until LCrdTemp = 0;
end;

// translate an integer value to an octal string
function IntToOctal(const Value: integer): string;
begin
  Result := IntToRadix(Value, 8);
end;

// translate a radix coded string into an integer
function RadixToInt(Value: string; Radix: byte): integer;
var
  LCrdTemp: cardinal absolute Result;
begin
  LCrdTemp := 0;
  Value := UpperCase(Value);
  while Value <> '' do
  begin
    if not (Pos(Value[1], HEX_UPPER) in [1..Radix]) then
      raise EMPHException.CreateFmt(ERR_INVALID_RADIXCHAR, [Value[1], Radix]);
    LCrdTemp := LCrdTemp * Radix + cardinal(Pos(Value[1], HEX_UPPER) - 1);
    Delete(Value, 1,1);
  end;
end;

(* try to find the correct radix (based on prefix/suffix) and return the number, known
   prefixes/suffixes are:<br>
   0x<number>, 0X<number>, $<number>, <number>h, <number>H: radix 16<br>
   o<number>, O<number>, 0<number>, <number>o, <number>O: radix 8<br>
   %<number>, <number>%: radix 2<br>
   otherwise: radix 10
*)
function CheckRadixToInt(Value: string): integer;
type
  TCharset = set of char;

  function AllCharsIn(const Args: TCharSet): boolean;
  var
    LIntLoop: integer;
  begin
    Result := True;
    for LIntLoop := 1 to Length(Value) do
      if not (Value[LIntLoop] in Args) then
      begin
        Result := False;
        Break;
      end;
  end;
begin
  // hex
  if UpperCase(Copy(Value, 1,2)) = '0X' then
    Result := RadixToInt(Copy(Value, 3,MaxInt), 16)
  else if Copy(Value, 1,1) = '$' then
    Result := RadixToInt(Copy(Value, 2,MaxInt), 16)
  else if UpperCase(Copy(Value, Length(Value), 1)) = 'H' then
    Result := RadixToInt(Copy(Value, 1,Length(Value) - 1), 16)
  else // octal
  if UpperCase(Copy(Value, Length(Value), 1)) = 'O' then
    Result := RadixToInt(Copy(Value, 1,Length(Value) - 1), 8)
  else if UpperCase(Copy(Value, 1,1)) = 'O' then
    Result := RadixToInt(Copy(Value, 2,MaxInt), 8)
  else if (Copy(Value, 1,1) = '0') and (AllCharsIn(['0'..'7'])) then
    Result := RadixToInt(Value, 8)
  else // binary
  if UpperCase(Copy(Value, Length(Value), 1)) = '%' then
    Result := RadixToInt(Copy(Value, 1,Length(Value) - 1), 2)
  else if UpperCase(Copy(Value, 1,1)) = '%' then
    Result := RadixToInt(Copy(Value, 2,MaxInt), 2)
  else
    // decimal
    Result := RadixToInt(Value, 10);
end;

// translate an octal to an integer
function OctalToInt(const Value: string): integer;
begin
  Result := RadixToInt(Value, 8);
end;

// fade a color to a gray value
function FadeToGray(aColor: TColor): TColor;
var
  LBytGray: byte;
begin
  aColor := ColorToRGB(aColor);
  LBytGray := HiByte(GetRValue(aColor) * 74 + GetGValue(aColor) * 146 +
    GetBValue(aColor) * 36);
  Result := RGB(LBytGray, LBytGray, LBytGray);
end;

(* TCustomMPHexEditor *)

constructor TCustomMPHexEditor.Create(aOwner: TComponent);
var
  LIntLoop: integer;
begin
  inherited Create(aOwner);
  FShowRuler := False;
  FDrawGutter3D := True;
  FHexLowerCase := True;
  SetHexLowerCase(False);
  FSaveCellExtents := False;
  DoubleBuffered := True;
  FBookmarkBitmap := TBitmap.Create;
  FCursorList := nil;
  FHasCustomBMP := False;
  FStreamFileName := '';
  FHasFile := False;
  FMaxUndo := 1024 * 1024;

  FGutterWidth := -1;
  GenerateOffsetFormat(MPHOffsetHex);
  FSelectionPossible := True;
  FBookmarkImageList := TImageList.Create(self);
  FBookmarkImageList.DrawingStyle := dsTransparent;
  FBookmarkImageList.BkColor := clBlack;
  FBookmarkImageList.Width := 10;
  FBookmarkImageList.Height := 10;

  Options := [goThumbTracking];
  DesignOptionsBoost := [];
  DefaultDrawing := False;

  FColors := TMPHColors.Create(Self);
  FDrawGridLines := False;

  ParentColor := False;
  FDataStorage := TMPHMemoryStream.Create;
  FUndoStorage := TMPHUndoStorage.Create(self);

  Color := FColors.Background;

  FCharWidth := -1;
  FOffSetDisplayWidth := -1;
  FBytesPerRow := 16;
  FCaretKind := ckAuto;
  FFocusFrame := True;
  FSwapNibbles := 0;
  FFileName := '---';

  Font.Name := 'Courier New';
  Font.Size := 11;
  BorderStyle := bsSingle;
  FBytesPerCol := 4;
  CTL3D := False;
  Cursor := crIBeam;
  FModifiedBytes := TBits.Create;
  for LIntLoop := Low(FBookmarks) to High(FBookmarks) do
    FBookmarks[LIntLoop].mPosition := -1;
  SetSelection(-1, - 1, - 1);
  FIsSelecting := False;
  ResetUndo;
  DefaultColWidth := 0;
  DefaultRowHeight := 0;
  RowHeights[0] := 0;
  RowHeights[1] := 0;
  ColCount := CalcColCount;
  RowCount := GRID_FIXED + 1;
  FTranslation := tkAsIs;
  FModified := False;
  FIsFileReadonly := True;
  FDataSize := -1;
  FBytesPerRowDup := 2 * FBytesPerRow;
  FLastKeyWasMenuKey := False;
  FReplaceUnprintableCharsBy := '.';
  FCaretBitmap := TBitmap.Create;
  FDisallowSizeChange := False;
  FAllowInsertMode := True;
  FInsertModeOn := False;
  FWantTabs := True;
  FReadOnlyView := False;
  FHideSelection := False;
  FGraySelOnLostFocus := False;
  FOnFileProgress := nil;
  FShowDrag := False;
  FSelBeginPosition := -1;
  FBookmarkBitmap.OnChange := BookmarkBitmapChanged;
  FBookmarkBitmap.LoadFromResourceName(HINSTANCE, 'BOOKMARKICONS');
end;

destructor TCustomMPHexEditor.Destroy;
begin
  FCursorList := nil;
  FBookmarkBitmap.OnChange := nil;
  FreeStorage;
  FreeStorage(True);
  FUndoStorage.Free;
  FDataStorage.Free;
  FModifiedBytes.Free;
  FColors.Free;
  FCaretBitmap.Free;
  FBookmarkImageList.Free;
  FBookmarkBitmap.Free;
  inherited Destroy;
end;

procedure TCustomMPHexEditor.AdjustMetrics;
var
  LIntLoop: integer;
  LIntChWidth: integer;
begin
  Canvas.Font.Assign(Font);
  FCharWidth := Canvas.TextWidth('w');

  SetOffsetDisplayWidth;
  ColWidths[1] := 6;

  LIntChWidth := FCharWidth;

  for LIntLoop := 0 to FBytesPerRowDup do
    if (((LIntLoop + 2) mod FBytesPerCol) = 1) then
      ColWidths[LIntLoop + GRID_FIXED] := LIntChWidth * 2
  else
    ColWidths[LIntLoop + GRID_FIXED] := LIntChWidth;

  for LIntLoop := FBytesPerRowDup + 1 to (FBytesPerRow * 3) - 1 do
    ColWidths[LIntLoop + GRID_FIXED] := FCharWidth;
  ColWidths[GetLastCharCol] := FCharWidth * 2;

  FCharHeight := Canvas.TextHeight('yY') + 2;
  DefaultRowHeight := FCharHeight;
  RowHeights[1] := 0;
  if FShowRuler then
    RowHeights[0] := DefaultRowHeight + 3
  else
    RowHeights[0] := 0;
end;

function TCustomMPHexEditor.GetDataSize: integer;
begin
  Result := FDataSize;
  if (FDataSize = -1) then
  begin
    Result := FDataStorage.Size;
    FDataSize := Result
  end
end;

procedure TCustomMPHexEditor.CreateEmptyFile;
begin
  FreeStorage;
  if TempName = '' then
    FFileName := UNNAMED_FILE
  else
    FFileName := TempName;
  ResetUndo;
  ResetSelection(False);
  FModifiedBytes.Size := 0;
  CalcSizes;
  FModified := False;
  FIsFileReadonly := True;
  FHasFile := False;
  MoveColRow(GRID_FIXED, GRID_FIXED, True, True);
  Changed;
end;

procedure TCustomMPHexEditor.SaveToStream(Strm: TStream);
begin
  WaitCursor;
  try
    FDataStorage.Position := 0;
    Strm.Size := FDataStorage.Size;
    Strm.Position := 0;
    Stream2Stream(FDataStorage, Strm, pkSave);
  finally
    Invalidate;
    OldCursor;
  end;
end;

procedure TCustomMPHexEditor.CopyToStream(strTo: TStream;
  const Operation: TMPHProgressKind; const FileName: string);
begin
  WaitCursor;
  try
    FDataStorage.Position := 0;
    strTo.Size := FDataStorage.Size;
    strTo.Position := 0;
    FStreamFileName := FileName;
    Stream2Stream(FDataStorage, strTo, Operation);
  finally
    FStreamFileName := '';
    Invalidate;
    OldCursor;
  end;
end;


procedure TCustomMPHexEditor.SaveToFile(const Filename: string;
  const aUnModify: boolean = True);
var
  LfstFile: TFileStream;
begin
  if (FFileName = FileName) then
    PrepareOverwriteDiskFile;

  LfstFile := TFileStream.Create(FileName, fmCreate);
  try
    FStreamFileName := FileName;
    SaveToStream(LfstFile);
    FHasFile := True;
    if aUnModify then
    begin
      FModifiedBytes.Size := 0;
      FModified := False;
      FIsFileReadonly := False;
      FFileName := Filename;
      FDataStorage.Position := 0;
      ResetUndo;
    end;
  finally
    FStreamFileName := '';
    LfstFile.Free;
  end;
end;

procedure TCustomMPHexEditor.LoadFromStream(Strm: TStream);
begin
  FreeStorage;
  WaitCursor;
  try
    try
      Strm.Position := 0;
      FDataStorage.Size := Strm.Size;
      FDataStorage.Position := 0;

      Stream2Stream(Strm, FDataStorage, pkLoad);

      FDataStorage.Position := 0;
    finally
      with FUndoStorage do
        if UpdateCount < 1 then
          Reset;
      FModifiedBytes.Size := 0;
      CalcSizes;
      FModified := False;
      FIsSelecting := False;
      MoveColRow(GRID_FIXED, GRID_FIXED, True, True);
      Changed;
    end;
  finally
    OldCursor;
  end;
end;

procedure TCustomMPHexEditor.LoadFromFile(const Filename: string);
var
  LfstFile: TFileStream;
begin
  if CanOpenFile(FileName, FIsFileReadonly) then
  begin
    LfstFile := TFileStream.Create(FileName, fmOpenRead or fmShareDenyNone);
    try
      FStreamFileName := FileName;
      try
        LoadFromStream(LfstFile);
      except
        FHasFile := False;
        raise;
      end;
      FFileName := FileName;
      FHasFile := True;
    finally
      FStreamFileName := '';
      LfstFile.Free;
    end;
  end
  else
    raise EFOpenError.CreateFmt(ERR_FILE_OPEN_FAILED, [FileName,
      SysErrorMessage(GetLastError)]);
end;

procedure TCustomMPHexEditor.CalcSizes;
var
  LIntRows: integer;
begin
  FDataSize := -1;

  if FModifiedBytes.Size > DataSize then
    FModifiedBytes.Size := DataSize;

  if DataSize < 1 then
  begin
    RowCount := GRID_FIXED + 1;
    ColCount := CalcColCount;
    FixedCols := GRID_FIXED;
  end
  else
  begin
    LIntRows := (DataSize + (FBytesPerRow - 1)) div FBytesPerRow;
    if ((DataSize mod FBytesPerRow) = 0) and InsertMode then
      INC(LIntRows);
    RowCount := LIntRows + GRID_FIXED;

    ColCount := CalcColCount;
    FixedCols := GRID_FIXED;
  end;
  FixedRows := GRID_FIXED;
  FDataSize := -1;
  AdjustMetrics;
end;

function TCustomMPHexEditor.TranslateFromAnsiChar(const aByte: byte): char;
begin
  case FTranslation of
    tkAsIs:
      begin
        if aByte < 32 then
          Result := #0
        else
          Result := char(aByte);
      end;
    tkDos8,
    tkASCII:
      begin
        if ((FTranslation = tkDos8) or (aByte < 128)) and (aByte > 31) then
          Result := Char2Oem(aByte)
        else
          Result := #0;
      end;
    tkMac:
      begin
        if aByte < 32 then
          Result := #0
        else if aByte < 128 then
          Result := char(aByte)
        else
          Result := tblMSAnsi2Mac[aByte];
      end;
    tkBCD:
      begin
        Result := tblMSAnsi2BCD[aByte];
        if Result < #32 then
          Result := #0;
      end;
    tkCustom:
      begin
        Result := MPHCustTransFieldFrom[aByte];
        if Result < #32 then
          Result := #0;
      end;
    else
      Result := #0;
  end;
end;

function TCustomMPHexEditor.TranslateToAnsiChar(const aByte: byte): char;
begin
  case FTranslation of
    tkAsIs: Result := char(aByte);
    tkDos8,
    tkASCII:
      begin
        Result := Oem2Char(aByte);
        if ((FTranslation = tkASCII) and (aByte > 127)) then
          Result := FReplaceUnprintableCharsBy;
      end;
    tkMac:
      begin
        if aByte < 128 then
          Result := char(aByte)
        else
          Result := tblMac2MSAnsi[aByte];
      end;
    tkBCD:
      begin
        Result := tblBCD2MSAnsi[aByte];
        if Result < #32 then
          Result := FReplaceUnprintableCharsBy;
      end;
    tkCustom:
      begin
        Result := MPHCustTransFieldTo[aByte];
        if Result < #32 then
          Result := #0;
      end;
    else
      Result := FReplaceUnprintableCharsBy;
  end;

  if (FReplaceUnprintableCharsBy <> #0) and (Result < #32) then
    Result := FReplaceUnprintableCharsBy;
end;


// get the position of the drag marker
function TCustomMPHexEditor.DropPosition: integer;
var
  LBoolInCharField: boolean;
begin
  Result := -1;
  LBoolInCharField := FPosInCharField;
  try
    if FShowDrag then
    begin
      Result := GetPosAtCursor(FShowDragCol, FShowDragRow);
    end;
  finally
    FPosInCharField := LBoolInCharField;
  end;
end;

procedure TCustomMPHexEditor.Stream2Stream(strFrom, strTo: TStream;
  const Operation: TMPHProgressKind);
var
  LBytProgress, LBytLastProgress: byte;
  LIntRemain, LIntRead, LIntCount: integer;
  LBoolCancel: boolean;
  LStrFile: string;

  LBytBuffer: array[0..MPTH_FILEIO_BLOCKSIZE - 1] of byte;
begin
  LIntCount := strFrom.Size - strFrom.Position;

  LIntRemain := LIntCount;
  LBoolCancel := False;
  LBytLastProgress := 255;
  LStrFile := FStreamFileName;
  if LStrFile = '' then
    LStrFile := FFileName;

  while LIntRemain > 0 do
  begin
    LBytProgress := Round(((LIntCount - LIntRemain) / LIntCount) * 100);
    if (LBytProgress <> LBytLastProgress) or (LIntRemain <= MPTH_FILEIO_BLOCKSIZE) then
    begin
      if LIntRemain <= MPTH_FILEIO_BLOCKSIZE then
        LBytLastProgress := 100
      else
        LBytLastProgress := LBytProgress;
      if Assigned(FOnFileProgress) then
      begin
        FOnFileProgress(self, Operation, LStrFile, LBytLastProgress, LBoolCancel);
        if LBoolCancel then
          raise EMPHException.Create(ERR_CANCELLED);
      end
    end;

    LIntRead := Min(LIntRemain, MPTH_FILEIO_BLOCKSIZE);
    strFrom.ReadBuffer(LBytBuffer, LIntRead);
    strTo.WriteBuffer(LBytBuffer, LIntRead);
    Dec(LIntRemain, LIntRead);
  end;
end;

function TCustomMPHexEditor.SelectCell(ACol, ARow: longint): boolean;
var
  LIntCurRow: integer;
  LRctCellRect: TRect;
  LBoolDummy: boolean;
  LIntOtherFieldCol: integer;
  LIntNewPosition, LIntPrevPosition, LIntSaveSel: integer;
begin
  LIntCurRow := Row;
  if DataSize > 0 then
    Result := CheckSelectCell(aCol, aRow)
  else
  begin
    if not ((aCol = GRID_FIXED) or (aCol =
      Max(GetOtherFieldCol(GRID_FIXED, LBoolDummy), GRID_FIXED)) and
      (aRow = GRID_FIXED)) then
      Result := False
    else
    begin
      Result := True;
      Exit;
    end;
  end;

  if Result then
  begin
    //cursor in anderem feld lschen
    LIntOtherFieldCol := GetOtherFieldCol(Col, LBoolDummy);
    LRctCellRect := CellRect(LIntOtherFieldCol, LIntCurRow);
    InvalidateRect(Handle, @LRctCellRect, False);
    LRctCellRect := CellRect(0, LIntCurRow);
    InvalidateRect(Handle, @LRctCellRect, False);

    // cursor in anderem feld setzen
    LIntOtherFieldCol := GetOtherFieldCol(aCol, LBoolDummy);
    LRctCellRect := CellRect(LIntOtherFieldCol, aRow);
    InvalidateRect(Handle, @LRctCellRect, False);
    LRctCellRect := CellRect(0, aRow);
    InvalidateRect(Handle, @LRctCellRect, False);
    if FShowRuler then
    begin
      LRctCellRect := BoxRect(0, 0, GetLastCharCol, 1);
      InvalidateRect(Handle, @LRctCellRect, False);
    end;

    if FIsSelecting then
    begin
      if not InsertMode then
        Select(Col, Row, aCol, aRow)
      else
      begin
        LIntNewPosition := GetPosAtCursor(aCol, aRow);
        LBoolDummy := FPosInCharField;
        LIntPrevPosition := GetPosAtCursor(Col, Row);
        if FSelBeginPosition = -1 then
          FSelBeginPosition := LIntPrevPosition;

        if (LIntNewPosition >= FSelBeginPosition) and (not InCharField) and
          ((aCol mod 2) = 1) then
          Inc(LIntNewPosition, 1);

        if FSelBeginPosition = LIntNewPosition then
        begin
          ResetSelection(True);
          FSelBeginPosition := LIntNewPosition;
          FIsSelecting := True;
        end
        else
        begin
          if FSelBeginPosition < LIntNewPosition then
          begin
            LIntPrevPosition := FSelBeginPosition;
            Dec(LIntNewPosition, 1);
          end
          else
          begin
            LIntPrevPosition := FSelBeginPosition - 1;
          end;
          LIntSaveSel := FSelBeginPosition;
          try
            NewSelection(LIntPrevPosition, LIntNewPosition);
          finally
            FSelBeginPosition := LIntSaveSel;
          end;
          FIsSelecting := True;
        end;
      end
    end
    else
      ResetSelection(True);

    // caret neu setzen
    LRctCellRect := CellRect(aCol, aRow);
    if LRctCellRect.Left + LRctCellRect.Bottom = 0 then
      IntSetCaretPos(-50, - 50)
    else
      IntSetCaretPos(LRctCellRect.Left, LRctCellRect.Top);
  end;
end;

// Obtient la position dans le fichier  partir de la position du curseur

function TCustomMPHexEditor.GetPosAtCursor(const aCol, aRow: integer): integer;
begin
  FPosInCharField := aCol > (GRID_FIXED + FBytesPerRowDup);
  Result := (aRow - GRID_FIXED) * FBytesPerRow;
  if FPosInCharField then
    Result := Result + (aCol - ((GRID_FIXED + 1) + FBytesPerRowDup))
  else
    Result := Result + ((aCol - GRID_FIXED) div 2);

  if Result < 0 then
    Result := 0;
end;

function TCustomMPHexEditor.GetRow(const DataPos: integer): integer;
begin
  Result := (DataPos div FBytesPerRow) + GRID_FIXED;
end;

function TCustomMPHexEditor.GetCursorAtPos(const aPos: integer;
  const aChars: boolean): TGridCoord;
var
  LIntCol: integer;
begin
  if aPos < 0 then
  begin
    Result.y := GRID_FIXED;
    Result.x := GRID_FIXED;
    Exit;
  end;

  Result.y := GetRow(aPos);
  LIntCol := aPos mod FBytesPerRow;

  if aChars then
    Result.x := LIntCol + (GRID_FIXED + 1 + FBytesPerRowDup)
  else
    Result.x := (LIntCol * 2) + GRID_FIXED;
end;

function TCustomMPHexEditor.GetOtherFieldCol(const aCol: integer;
  var Chars: boolean): integer;
var
  LIntCol: integer;
begin
  Chars := aCol > (GRID_FIXED + FBytesPerRowDup);
  if Chars then
  begin
    LIntCol := (aCol - (GRID_FIXED + 1 + FBytesPerRowDup));
    Result := (LIntCol * 2) + GRID_FIXED;
  end
  else
  begin
    LIntCol := ((aCol - GRID_FIXED) div 2);
    Result := LIntCol + (GRID_FIXED + 1 + FBytesPerRowDup);
  end;
end;

function TCustomMPHexEditor.CheckSelectCell(aCol, aRow: integer): boolean;
var
  LgrcEndCoords: TGridCoord;
  LIntPos: integer;
begin
  Result := inherited SelectCell(aCol, aRow);

  if not FSelectionPossible then
    Exit;

  try
    FSelectionPossible := False;

    if Result then
    begin
      // berprfen, ob linke maustaste oder shift gedrckt, sonst selection zurcksetzen
      if not (IsKeyDown(VK_SHIFT) or IsKeyDown(VK_LBUTTON)) then
        ResetSelection(True);

      // berprfen, ob auerhalb der DateiGre
      LIntPos := GetPosAtCursor(aCol, aRow);
      if (LIntPos >= DataSize) and not (InsertMode and (LIntPos = DataSize) and
        (FPosInCharField or ((aCol mod 2) = 0))) then
      begin
        if (not InsertMode) then
          LgrcEndCoords := GetCursorAtPos(DataSize - 1, InCharField)
        else
          LgrcEndCoords := GetCursorAtPos(DataSize, InCharField);

        MoveColRow(LgrcEndCoords.x, LgrcEndCoords.y, True, True);
        Result := False;
      end
      else if aCol = (GRID_FIXED + FBytesPerRowDup) then
      begin
        Result := False;
        if IsKeyDown(VK_LBUTTON) then
        begin
          aCol := aCol - 1;
          aCol := Max(GRID_FIXED, aCol);
          MoveColRow(aCol, aRow, True, True);
          Exit;
        end;
      end;
    end;

  finally
    FSelectionPossible := True;
  end;
end;

procedure TCustomMPHexEditor.WMChar(var Msg: TWMChar);
var
  LIntPos: integer;
  LChrChar: char;
  LBytOldData, LBytNewData: byte;
  LgrcPosition: TGridCoord;
begin
  LChrChar := char(Msg.CharCode);

  if Assigned(OnKeyPress) then
    OnKeyPress(Self, LChrChar);

  if FReadOnlyView or (LChrChar < #32) then
    Exit;

  LIntPos := GetPosAtCursor(Col, Row);
  if (LIntPos >= DataSize) and not InsertMode then
    Exit;

  if not FPosInCharField then
  begin
    // hex-eingabe, nur 0..9 , a..f erlaubt
    if Pos(LChrChar, HEX_ALLCHARS) <> 0 then
    begin
      LChrChar := UpCase(LChrChar);

      if not InsertMode then
        ResetSelection(True);

      LgrcPosition := GetCursorAtPos(LIntPos, FPosInCharField);
      // Obtient la valeur du byte dans le fichier (OldByte)
      if DataSize > LIntPos then
        LBytOldData := byte(GetMemory(LIntPos))
      else
        LBytOldData := 0;

      if (LgrcPosition.x = (Col - FSwapNibbles)) or (SelCount <> 0) then
        LBytNewData := LBytOldData and 15 + ((Pos(LChrChar, HEX_UPPER) - 1) * 16)
      else
        LBytNewData := (LBytOldData and $F0) + (Pos(LChrChar, HEX_UPPER) - 1);

      if InsertMode and ((LgrcPosition.x = Col) or (SelCount > 0)) then
      begin
        if FSwapNibbles = 0 then
          LBytNewData := LBytNewData and $F0
        else
          LBytNewData := LBytNewData and $0F;

        if DataSize = 0 then
          AppendBuffer(@LBytNewData, 1)
        else if SelCount = 0 then
        begin
          InsertBuffer(@LBytNewData, 1, LIntPos);
          FIsSelecting := False;
        end
        else
          ReplaceSelection(@LBytNewData, 1);
      end
      else
      begin
        IntChangeByte(LBytOldData, LBytNewData, LIntPos, Col, Row);
      end;

      ParseKeyDown([], char(VK_RIGHT));
    end
    else
      WrongKey
  end
  else
  begin
    // zeichen-eingabe, alle zeichen erlaubt
    if not FLastKeyWasMenuKey      {// if the key has been entered via ALT + NUMPAD (0..9), make no translation (except oem to ansi)}
      then
      LChrChar := TranslateFromAnsiChar(Ord(LChrChar))
    else
      LChrChar := Char2OEM(Ord(LChrChar));
    // this doesn't work with all chars, but i don't know how to solve it

    if (LChrChar < #32) and (not FLastKeyWasMenuKey) then
    begin
      WrongKey;
      Exit;
    end;

    FLastKeyWasMenuKey := False;

    if not InsertMode then
      ResetSelection(True);

    LgrcPosition := GetCursorAtPos(LIntPos, FPosInCharField);

    if (DataSize = 0) or (DataSize = LIntPos) then
      LBytOldData := 0
    else
      LBytOldData := byte(GetMemory(LIntPos));

    if InsertMode then
    begin
      if SelCount > 0 then
        ReplaceSelection(@LChrChar, 1)
      else
      begin
        if LIntPos = DataSize then
          AppendBuffer(@LChrChar, 1)
        else
          InsertBuffer(@LChrChar, 1, LIntPos);
        FIsSelecting := False;
      end;
    end
    else
      IntChangeByte(LBytOldData, Ord(LChrChar), LIntPos, Col, Row);

    ParseKeyDown([], char(VK_RIGHT));
  end;
end;

procedure TCustomMPHexEditor.GetMemAtPos(aBuffer: PByteArray;
  const aPos, aCount: integer);
begin
  CopyMemory(aBuffer, Pointer(longint(FDataStorage.Memory) + aPos), aCount);
end;

procedure TCustomMPHexEditor.SetMemAtPos(aBuffer: PByteArray;
  const aPos, aCount: integer);
begin
  CopyMemory(Pointer(longint(FDataStorage.Memory) + aPos), aBuffer, aCount);
end;

{-------------------------------------------------------------------------------}
// *** procedure TCustomMPHexEditor.IntChangeByte***
// Change la valeur du byte
// Renseigne la structure Undo
{-------------------------------------------------------------------------------}

procedure TCustomMPHexEditor.IntChangeByte(const aOldByte, aNewByte: byte; aPos, aCol,
  aRow: integer; const UndoDesc: string = '');
var
  LRctBoxRect: TRect;
  LBoolDummy: boolean;
  LIntOtherFieldCol: integer;
begin
  if aOldByte = aNewByte then
    Exit;

  if not CreateUndo(ufKindByteChanged, aPos, 1, 0, UndoDesc) then
    Exit;

  // Ecrit dans le fichier
  SetMemory(aPos, char(aNewByte));

  if not InsertMode then
    FModifiedBytes.Bits[aPos] := True;

  aCol := GetCursorAtPos(aPos, False).X;
  LIntOtherFieldCol := GetOtherFieldCol(aCol, LBoolDummy);
  LRctBoxRect := BoxRect(aCol, aRow, aCol + 1, aRow);
  InvalidateRect(Handle, @LRctBoxRect, False);
  LRctBoxRect := BoxRect(LIntOtherFieldCol, aRow, LIntOtherFieldCol, aRow);
  InvalidateRect(Handle, @LRctBoxRect, False);
  Changed;
end;

function TCustomMPHexEditor.ParseKeyDown(aShift: TShiftState; aChar: char): boolean;
var
  LIntCol: integer;
  LgrcPosition: TGridCoord;
  LIntRow: integer;
begin
  Result := False;

  // reset selection if no shift key is pressed (except of SHIFT-Key)
  if not ((aShift <> []) or (aChar = char(VK_SHIFT))) then
    if not InsertMode then
      ResetSelection(True);


  case aChar of

    char(VK_PRIOR):
      begin
        if ssCtrl in aShift then
        begin
          // go to the first visible line
          LIntRow := TopRow;
          LIntCol := Col;
          if LIntRow > -1 then
          begin
            MoveColRow(LIntCol, LIntRow, True, True);
          end;
        end
        else
        begin
          // scroll up one page
          LIntRow := Max(GRID_FIXED, Row - VisibleRowCount + 1);
          TopRow := Max(GRID_FIXED, TopRow - VisibleRowCount + 1);
          LIntCol := Col;
          if LIntRow > -1 then
          begin
            MoveColRow(LIntCol, LIntRow, True, True);
          end;
        end;
        Result := True;
      end;

    char(VK_NEXT):
      begin
        if ssCtrl in aShift then
        begin
          // go to the Last visible line
          LIntRow := Min(RowCount - GRID_FIXED, TopRow + VisibleRowCount - 1);
          LIntCol := Col;
          if LIntRow > 0 then
          begin
            MoveColRow(LIntCol, LIntRow, True, True);
          end;
        end
        else
        begin
          // scroll down one page
          LIntRow := Min(RowCount - GRID_FIXED, Row + VisibleRowCount - 1);
          TopRow := Min(Max(GRID_FIXED, RowCount - VisibleRowCount),
            TopRow + VisibleRowCount - 1);
          LIntCol := Col;
          if LIntRow > 0 then
          begin
            MoveColRow(LIntCol, LIntRow, True, True);
          end;
        end;
        Result := True;
      end;

    char(VK_HOME):
      begin
        InCharField;
        if (ssCtrl in aShift) then
        begin // strg+pos1
          if not FPosInCharField then
            MoveColRow(GRID_FIXED, GRID_FIXED, True, True)
          else
            MoveColRow(Max(GRID_FIXED, GetOtherFieldCol(GRID_FIXED,
              FPosInCharField)), GRID_FIXED, True, True);
        end
        else
        begin // normaler zeilenstart
          if not FPosInCharField then
            MoveColRow(GRID_FIXED, Row, True, True)
          else
            MoveColRow(Max(GRID_FIXED, GetOtherFieldCol(GRID_FIXED,
              FPosInCharField)), Row, True, True);
        end;
        Result := True;
      end;

    char(VK_END):
      begin
        InCharField;
        if (ssCtrl in aShift) then
        begin // strg+end
          if (not InsertMode) then
            LgrcPosition := GetCursorAtPos(DataSize - 1, FPosInCharField)
          else
            LgrcPosition := GetCursorAtPos(DataSize, FPosInCharField);
          MoveColRow(LgrcPosition.x, LgrcPosition.y, True, True)
        end
        else
        begin // normales zeilenende
          if not FPosInCharField then
          begin
            LIntCol := GetPosAtCursor(GRID_FIXED, Row + 1) - 1;
            TruncMaxPosition(LIntCol);
            LgrcPosition := GetCursorAtPos(LIntCol, FPosInCharField);
            MoveColRow(LgrcPosition.x + 1, LgrcPosition.y, True, True)
          end
          else
          begin
            LIntCol := GetPosAtCursor(GRID_FIXED, Row + 1) - 1;
            TruncMaxPosition(LIntCol);
            LgrcPosition := GetCursorAtPos(LIntCol, True);
            MoveColRow(LgrcPosition.x, LgrcPosition.y, True, True);
          end
        end;
        Result := True;
      end;

    char(VK_LEFT): if (not (ssCTRL in aShift)) then
      begin
        LIntCol := GetPosAtCursor(Col, Row) - 1;
        if FPosInCharField then
        begin
          if LIntCol < 0 then
            LIntCol := 0;
          LgrcPosition := GetCursorAtPos(LIntCol, FPosInCharField);
          MoveColRow(LgrcPosition.x, LgrcPosition.y, True, True);
        end
        else
        begin
          LIntCol := LIntCol + 1;
          LgrcPosition := GetCursorAtPos(LIntCol, False);
          if LgrcPosition.x < Col then
            MoveColRow(Col - 1, Row, True, True)
          else
          begin
            LIntCol := LIntCol - 1;
            if LIntCol >= 0 then
            begin
              LgrcPosition := GetCursorAtPos(LIntCol, FPosInCharField);
              MoveColRow(LgrcPosition.x + 1, LgrcPosition.y, True, True);
            end;
          end
        end;
        Result := True;
      end;

    char(VK_RIGHT):
      begin
        if (not (ssCTRL in aShift)) then
        begin
          LIntCol := GetPosAtCursor(Col, Row) + 1;
          if FPosInCharField then
          begin
            TruncMaxPosition(LIntCol);
            LgrcPosition := GetCursorAtPos(LIntCol, FPosInCharField);
            MoveColRow(LgrcPosition.x, LgrcPosition.y, True, True);
          end
          else
          begin
            LIntCol := LIntCol - 1;
            LgrcPosition := GetCursorAtPos(LIntCol, False);
            if (LgrcPosition.x = Col) and not (LIntCol = DataSize) then
              MoveColRow(Col + 1, Row, True, True)
            else
            begin
              LIntCol := LIntCol + 1;
              if (LIntCol < DataSize) or ((LIntCol = DataSize) and InsertMode) then
              begin
                LgrcPosition := GetCursorAtPos(LIntCol, FPosInCharField);
                MoveColRow(LgrcPosition.x, LgrcPosition.y, True, True);
              end;
            end
          end;
          Result := True;
        end
        else
        begin
          LIntCol := GetLastCharCol;
          MoveColRow(LIntCol, Row, True, True);
          Result := True;
        end;
      end;

    char(VK_DOWN):
      begin
        Result := True;
        if (not (ssCTRL in aShift)) then
        begin
          LIntRow := Row + 1;

          LIntCol := Col;
          if LIntRow < RowCount then
          begin
            MoveColRow(LIntCol, LIntRow, True, True);
          end;
        end;
      end;

    char(VK_UP):
      begin
        Result := True;
        if (not (ssCTRL in aShift)) then
        begin
          LIntRow := Row - 1;
          LIntCol := Col;
          if LIntRow > 1 then
          begin
            MoveColRow(LIntCol, LIntRow, True, True);
          end;
        end;
      end;

    'T': if (ssCtrl in aShift) then
      begin
        Col := Max(GRID_FIXED, GetOtherFieldCol(Col, FPosInCharField));
        Result := True;
      end;

    char(VK_TAB): if ((aShift = []) or (aShift = [ssShift])) then
      begin // tab-taste
        Col := Max(GRID_FIXED, GetOtherFieldCol(Col, FPosInCharField));
        Result := True;
      end;

    '0'..'9': if ssCtrl in aShift then
      begin
        if ssShift in aShift then
        begin
          LIntRow := GetPosAtCursor(Col, Row);
          SetBookmarkVals(Ord(aChar) - Ord('0'), LIntRow, FPosInCharField);
          Result := True;
        end
        else
        begin
          if FBookmarks[Ord(aChar) - Ord('0')].mPosition > -1 then
          begin
            ResetSelection(True);
            LIntRow := FBookmarks[Ord(aChar) - Ord('0')].mPosition;
            if (LIntRow < DataSize) or ((LIntRow = DataSize) and InsertMode) then
            begin
              LgrcPosition := GetCursorAtPos(LIntRow, FBookmarks[Ord(aChar) -
                Ord('0')].mInCharField);
              MoveColRow(LgrcPosition.x, LgrcPosition.y, True, True);
            end
            else
              SetBookmarkVals(Ord(aChar) - Ord('0'), - 1, False);
            Result := True;
          end
        end;
      end;

    char(VK_SHIFT): if (aShift = [ssShift]) or (aShift = [ssShift, ssCtrl]) then
      begin // selektion starten
        FIsSelecting := True;
        Result := True;
      end;
  end;
end;

procedure TCustomMPHexEditor.KeyUp(var Key: word; Shift: TShiftState);
begin
  FLastKeyWasMenuKey := Key = VK_MENU;
  // to check if the key in char field has been entered via ALT+NUMPAD (0..9)
  inherited KeyUp(Key, Shift);
end;

procedure TCustomMPHexEditor.KeyDown(var Key: word; Shift: TShiftState);
var
  LChrKey: char;
begin
  if Key = VK_INSERT then
  begin
    InsertMode := not InsertMode;
    Key := 0;
    Exit;
  end;

  LChrKey := char(Key);

  if Key = 8 then
  begin //BACKSP
    if (InsertMode and (not FReadOnlyView)) then
    begin
      Key := 0;
      LChrKey := #0;
      if SelCount > 0 then
        DeleteSelection;
      InternalErase(True)
    end
    else
    begin
      LChrKey := char(VK_Left);
      Key := VK_LEFT;
    end
  end
  else if ((Key = VK_DELETE) and (not FReadOnlyView)) then
  begin
    Key := 0;
    LChrKey := #0;
    if (Shift = [ssCtrl]) or ((SelCount > 0) and InsertMode) then
      DeleteSelection
    else if InsertMode then
      InternalErase(False);
  end;

  if ParseKeyDown(Shift, LChrKey) then
    Key := 0
  else
    inherited KeyDown(Key, Shift);
end;

function TCustomMPHexEditor.HasChanged(aPos: integer): boolean;
begin
  Result := False;
  if InsertMode then
    Exit;

  if FModifiedBytes.Size > aPos then
    Result := FModifiedBytes.Bits[aPos];
end;

function TCustomMPHexEditor.IsSelected(const aPos: integer): boolean;
begin
  Result := False;
  if (FSelPosition <> -1) and (aPos >= FSelStart) and (aPos <= FSelEnd) then
  begin
    Result := True
  end;
end;

procedure TCustomMPHexEditor.NewSelection(const SelFrom, SelTo: integer);
var
  LIntSelStart, LIntSelEnd, LIntSelPos: integer;
  LIntOldStart, LIntNewStart, LIntOldEnd, LIntNewEnd: integer;
begin
  LIntSelEnd := FSelEnd;
  LIntSelStart := FSelStart;
  LIntSelPos := FSelPosition;

  SetSelection(SelFrom, Min(SelFrom, SelTo), Max(SelFrom, SelTo));

  if (LIntSelPos = -1) then
    RedrawPos(Min(FSelStart, FSelEnd), Max(FSelStart, FSelEnd))
  else
  begin
    // den bereich neu zeichnen, der neu selektiert ist, sowie den, der nicht mehr selektiert ist
    // hinzugekommene selektion berechnen
    LIntNewStart := Min(SelFrom, SelTo);
    LIntOldStart := Min(LIntSelEnd, LIntSelStart);
    LIntNewEnd := Max(SelFrom, SelTo);
    LIntOldEnd := Max(LIntSelEnd, LIntSelStart);
    RedrawPos(Min(LIntNewStart, LIntOldStart), Max(LIntNewStart, LIntOldStart));
    RedrawPos(Min(LIntOldEnd, LIntNewEnd), Max(LIntOldEnd, LIntNewEnd));
  end;
end;

function TCustomMPHexEditor.GetOffsetFormat: string;
begin
  Result := FOffsetFormat.Format;
end;

procedure TCustomMPHexEditor.SetOffsetFormat(const Value: string);
begin
  if Value <> FOffsetFormat.Format then
    try
      GenerateOffsetFormat(Value);
      SetOffsetDisplayWidth;
      Invalidate;
    except
      GenerateOffsetFormat(FOffsetFormat.Format);
      raise;
    end;
end;

procedure TCustomMPHexEditor.SetHexLowerCase(const Value: boolean);
begin
  if FHexLowerCase <> Value then
  begin
    FHexLowerCase := Value;
    if Value then
      Move(HEX_LOWER[1], FHexChars, sizeof(FHexChars))
    else
      Move(HEX_UPPER[1], FHexChars, sizeof(FHexChars));
    Invalidate;
  end;
end;



procedure TCustomMPHexEditor.GenerateOffsetFormat(Value: string);
var
  LIntTemp: integer;
  LStrTemp: string;
begin
  with FOffsetFormat do
  begin
    Flags := [];
    LStrTemp := Value;
    // aufbau: [r|c|<HEXNUM>%][-|<HEXNUM>!]<HEXNUM>:[Prefix]|[Suffix]
    if LStrTemp <> '' then
    begin
      // bytes per unit
      if UpperCase(Copy(LStrTemp, 1,2)) = 'R%' then
      begin
        Flags := Flags + [offCalcRow];
        Delete(LStrTemp, 1,2);
        BytesPerUnit := BytesPerRow;
      end
      else if UpperCase(Copy(LStrTemp, 1,2)) = 'C%' then
      begin
        Flags := Flags + [offCalcColumn];
        Delete(LStrTemp, 1,2);
        BytesPerUnit := BytesPerColumn;
      end
      else
      begin
        LIntTemp := 1;
        while (LIntTemp <= Length(LStrTemp)) and
          (LStrTemp[LIntTemp] in ['0'..'9', 'A'..'F', 'a'..'f']) do
          Inc(LIntTemp);
        if Copy(LStrTemp, LIntTemp, 1) = '%' then
        begin
          // width field
          if LIntTemp = 1 then
          begin
            BytesPerUnit := 1;
            Delete(LStrTemp, 1,1)
          end
          else
          begin
            BytesPerUnit := RadixToInt(Copy(LStrTemp, 1, LIntTemp - 1), 16);
            //  StrToInt('$'+Copy(LStrTemp, 1, LIntTemp-1));
            Delete(LStrTemp, 1, LIntTemp);
          end;
        end
        else
          BytesPerUnit := 1;
      end;
      if BytesPerUnit < 1 then
        raise EMPHException.CreateFmt(ERR_INVALID_BPU, [BytesPerUnit]);
      // auto calc width
      if Copy(LStrTemp, 1,2) = '-!' then
      begin
        Flags := Flags + [offCalcWidth];
        Delete(LStrTemp, 1,2);
        MinWidth := 1;
      end
      else
      begin
        // width ?
        LIntTemp := 1;
        while (LIntTemp <= Length(LStrTemp)) and
          (LStrTemp[LIntTemp] in ['0'..'9', 'A'..'F', 'a'..'f']) do
          Inc(LIntTemp);
        if Copy(LStrTemp, LIntTemp, 1) = '!' then
        begin
          // width field
          if LIntTemp = 1 then
          begin
            MinWidth := 1;
            Delete(LStrTemp, 1,1)
          end
          else
          begin
            MinWidth := RadixToInt(Copy(LStrTemp, 1, LIntTemp - 1), 16);
            //  StrToInt('$'+Copy(LStrTemp, 1, LIntTemp-1));
            Delete(LStrTemp, 1, LIntTemp);
          end;
        end
        else
          MinWidth := 1;
      end;

      // radix
      LIntTemp := 1;
      while (LIntTemp <= Length(LStrTemp)) and (LStrTemp[LIntTemp] in ['0'..'9',
        'A'..'F', 'a'..'f']) do
        Inc(LIntTemp);

      if LIntTemp = 1 then
        raise EMPHException.CreateFmt(ERR_MISSING_FORMATCHAR, ['number radix']);

      if Copy(LStrTemp, LIntTemp, 1) <> ':' then
        raise EMPHException.CreateFmt(ERR_MISSING_FORMATCHAR, [':']);

      Radix := RadixToInt(Copy(LStrTemp, 1, LIntTemp - 1), 16);
      if not (Radix in [2..16]) then
        raise EMPHException.CreateFmt(ERR_INVALID_FORMATRADIX, [Radix]);

      Delete(LStrTemp, 1,LIntTemp);

      // prefix, suffix
      LIntTemp := Pos('|', LStrTemp);
      if LIntTemp = 0 then
        raise EMPHException.CreateFmt(ERR_MISSING_FORMATCHAR, ['|']);

      Prefix := Copy(LStrTemp, 1,LIntTemp - 1);
      Suffix := Copy(LStrTemp, LIntTemp + 1,MaxInt);
    end;
    Format := Value;
  end;
end;

procedure TCustomMPHexEditor.Select(const aCurCol, aCurRow, aNewCol, aNewRow: integer);
var
  LIntOldStart, LIntOldEnd, LIntNewStart, LIntNewEnd: integer;
begin
  LIntOldEnd := FSelEnd;
  LIntOldStart := FSelStart;
  LIntNewStart := GetPosAtCursor(aNewCol, aNewRow);
  if FSelPosition = -1 then
  begin
    LIntOldStart := LIntNewStart;
    LIntOldEnd := LIntNewStart;
    LIntNewEnd := GetPosAtCursor(aCurCol, aCurRow);
    SetSelection(LIntNewEnd, Min(LIntOldStart, LIntNewEnd), Max(LIntNewEnd, LIntOldEnd));
    RedrawPos(FSelStart, FSelEnd)
  end
  else
  begin
    // testen, ob neue selection  /\ liegt als fSelPO
    // wenn ja, dann start = sel, ende = selpo
    if LIntNewStart < FSelPosition then
    begin
      SetSelection(FSelPosition, LIntNewStart, FSelPosition);
      RedrawPos(Min(FSelStart, LIntOldStart), Max(FSelStart, LIntOldStart));
      RedrawPos(Min(FSelEnd, LIntOldEnd), Max(FSelEnd, LIntOldEnd));
    end
    else
    begin
      SetSelection(FSelPosition, FSelPosition, LIntNewStart);
      RedrawPos(Min(FSelStart, LIntOldStart), Max(FSelStart, LIntOldStart));
      RedrawPos(Min(FSelEnd, LIntOldEnd), Max(FSelEnd, LIntOldEnd));
    end;
  end;
end;

procedure TCustomMPHexEditor.RedrawPos(aFrom, aTo: integer);
var
  LRctBox: TRect;
begin
  aFrom := GetRow(aFrom);
  aTo := GetRow(aTo);
  LRctBox := BoxRect(GRID_FIXED, aFrom, GetLastCharCol, aTo);
  InvalidateRect(Handle, @LRctBox, False);
end;

procedure TCustomMPHexEditor.ResetSelection(const aDraw: boolean);
var
  LIntOldStart, LIntOldEnd: integer;
begin
  FIsSelecting := False;
  LIntOldStart := FSelStart;
  LIntOldEnd := FSelEnd;
  SetSelection(-1, - 1, - 1);
  FSelBeginPosition := -1;

  if aDraw then
    RedrawPos(LIntOldStart, LIntOldEnd);
end;

procedure TCustomMPHexEditor.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: integer);
var
  LgrcDummy: TGridCoord;
begin
  FIsSelecting := False;
  FMouseUpCanResetSel := False;

  if Button = mbLeft then
    LgrcDummy := CheckMouseCoord(X, Y);

  if not MouseOverSelection then
    inherited MouseDown(Button, Shift, x, y);

  if (GetParentForm(self) <> nil) then
    if (GetParentForm(self).ActiveControl = self) then
      if GetParentForm(self) <> Screen.ActiveForm then
        if HandleAllocated then
          Windows.SetFocus(self.Handle);

  if (Button = mbLeft) and (not MouseOverSelection) and
    (LgrcDummy.X >= GRID_FIXED) and (LgrcDummy.Y >= GRID_FIXED) then
  begin
    ResetSelection(True);
    if not (ssDouble in Shift) then
      FIsSelecting := True;
  end;

  if (Button = mbLeft) and MouseOverSelection then
  begin
    FMouseDownCol := x;
    FMouseDownRow := y;
    FMouseUpCanResetSel := True;
  end;
end;

procedure TCustomMPHexEditor.InternalGetCurSel(var StartPos, EndPos, ACol, ARow: integer);
begin
  if FSelPosition = -1 then
  begin
    StartPos := GetPosAtCursor(Col, Row);
    EndPos := StartPos + 1;
    aCol := Col;
    aRow := Row;
  end
  else
  begin
    StartPos := FSelStart;
    EndPos := FSelEnd + 1;
    with GetCursorAtPos(FSelStart, InCharField) do
    begin
      aCOL := X;
      aROW := Y;
    end;
  end;

  if FModifiedBytes.Size > StartPos then
    FModifiedBytes.Size := StartPos;
end;

function TCustomMPHexEditor.CreateShift4BitStream(const StartPos: integer;
  var FName: TFileName): TFileStream;
var
  LByt1, LByt2: byte;
  LBytBuffer: array[0..511] of byte;
  LIntLoop: integer;
begin
  Result := nil;
  if StartPos >= DataSize then
    Exit;

  FName := GetTempName;
  Result := TFileStream.Create(FName, fmCreate);
  Result.Position := 0;
  FDataStorage.Position := StartPos;
  LByt1 := 0;
  while FDataStorage.Position < DataSize do
  begin
    FillChar(LBytBuffer[0], 512, 0);
    FDataStorage.Read(LBytBuffer[0], 512);
    for LIntLoop := 0 to 511 do
    begin
      LByt2 := LBytBuffer[LIntLoop] and 15;
      LBytBuffer[LIntLoop] := (LBytBuffer[LIntLoop] shr 4) or (LByt1 shl 4);
      LByt1 := LByt2;
    end;
    Result.Write(LBytBuffer[0], 512);
  end;
  Result.Position := 0;
end;

function TCustomMPHexEditor.InternalInsertNibble(const Pos: integer;
  const HighNibble: boolean): boolean;
var
  LfstNibbleStream: TFileStream;
  LStrFName: TFileName;
  LIntOldSize: integer;
  LBytWork: byte;
begin
  Result := False;

  if DataSize = 0 then
    Exit;

  LIntOldSize := FDataStorage.Size;

  WaitCursor;
  try
    // nun zuerst alle restlichen bits verschieben
    FDataStorage.Position := Pos;
    FDataStorage.Read(LBytWork, 1);

    LfstNibbleStream := CreateShift4BitStream(Pos, LStrFName);
    with LfstNibbleStream do
      try
        FDataStorage.Position := Pos;
        FDataStorage.CopyFrom(LfstNibbleStream, LfstNibbleStream.Size);
      finally
        Free;
        DeleteFile(LStrFName);
      end;

    FDataStorage.Position := Pos;
    if HighNibble then
      LBytWork := LBytWork shr 4
    else
      LBytWork := LBytWork and 240;
    FDataStorage.Write(LBytWork, 1);
    Result := True;
    FDataStorage.Size := LIntOldSize + 1;
    FDataSize := -1;
  finally
    OldCursor;
  end;
end;

function TCustomMPHexEditor.InsertNibble(const aPos: integer;
  const HighNibble: boolean; const UndoDesc: string = ''): boolean;
const
  L_BytAppend: byte = 0;
begin
  Result := False;

  if DataSize < 1 then
  begin
    ResetSelection(False);
    AppendBuffer(@L_BytAppend, 1);
    Result := True;
    Exit;
  end;

  if (aPos >= DataSize) or (aPos < 0) then
    Exit;

  if not CreateUndo(ufKindNibbleInsert, aPos, 0, 0, UndoDesc) then
    Exit;

  ResetSelection(False);
  Result := InternalInsertNibble(aPos, HighNibble);

  if Result and (FModifiedBytes.Size >= (aPos)) then
    FModifiedBytes.Size := aPos;

  FDataSize := -1;
  CalcSizes;
  Changed;
end;

function TCustomMPHexEditor.InternalDeleteNibble(const Pos: integer;
  const HighNibble: boolean): boolean;
var
  LfstNibbleStream: TFileStream;
  LStrFName: TFileName;
  LIntOldSize: integer;
  LByt1, LByt2: byte;
begin
  Result := False;
  if DataSize = 0 then
    Exit;

  LIntOldSize := FDataStorage.Size;
  WaitCursor;
  try
    // nun zuerst alle restlichen bits verschieben
    FDataStorage.Position := Pos;
    FDataStorage.Read(LByt1, 1);

    LfstNibbleStream := CreateShift4BitStream(Pos, LStrFName);
    with LfstNibbleStream do
      try
        FDataStorage.Position := Pos;
        Position := 1;
        FDataStorage.CopyFrom(LfstNibbleStream, LfstNibbleStream.Size - 1);
      finally
        Free;
        DeleteFile(LStrFName);
      end;

    FDataStorage.Position := Pos;
    if not HighNibble then
    begin
      FDataStorage.Read(LByt2, 1);
      FDataStorage.Seek(-1, soFromCurrent);
      LByt1 := (LByt1 and 240) or (LByt2 and 15);
      FDataStorage.Write(LByt1, 1);
    end;

    Result := True;
    FDataStorage.Size := LIntOldSize;
    FDataSize := -1;
  finally
    OldCursor;
  end;
end;

function TCustomMPHexEditor.DeleteNibble(const aPos: integer;
  const HighNibble: boolean; const UndoDesc: string = ''): boolean;
begin
  Result := False;

  if (aPos >= DataSize) or (aPos < 0) then
    Exit;

  if not CreateUndo(ufKindNibbleDelete, aPos, 0, 0, UndoDesc) then
    Exit;

  ResetSelection(False);
  Result := InternalDeleteNibble(aPos, HighNibble);

  if Result and (FModifiedBytes.Size >= (aPos)) then
    FModifiedBytes.Size := aPos;

  FDataSize := -1;
  CalcSizes;
  Changed;
end;

procedure TCustomMPHexEditor.InternalConvertRange(const aFrom, aTo: integer;
  const aTransFrom, aTransTo: TMPHTranslationKind);
var
  LIntSize: integer;
  LPtrData: Pointer;
begin
  LPtrData := Pointer(longint(FDataStorage.Memory) + aFrom);
  LIntSize := (aTo - aFrom) + 1;
  WaitCursor;
  try
    TranslateBufferToAnsi(aTransFrom, LPtrData, LPtrData, LIntSize);
    TranslateBufferFromAnsi(aTransTo, LPtrData, LPtrData, LIntSize);
  finally
    OldCursor;
  end;
end;

procedure TCustomMPHexEditor.ConvertRange(const aFrom, aTo: integer;
  const aTransFrom, aTransTo: TMPHTranslationKind; const UndoDesc: string = '');
begin
  if aFrom > aTo then
    Exit;

  if aTransFrom = aTransTo then
    Exit;

  if (aTo >= DataSize) or (aFrom < 0) then
    Exit;

  if not CreateUndo(ufKindConvert, aFrom, (aTo - aFrom) + 1, 0, UndoDesc) then
    Exit;

  InternalConvertRange(aFrom, aTo, aTransFrom, aTransTo);

  FDataSize := -1;
  Invalidate;
  Changed;
end;

procedure TCustomMPHexEditor.InternalDelete(StartPos, EndPos, ACol, ARow: integer);
var
  LgrdEndPos: TGridCoord;
  LIntNewCol: integer;
  LBoolDummy: boolean;
begin
  if EndPos <= (DataSize - 1) then
    MoveFileMem(EndPos, StartPos, DataSize - EndPos);

  FDataStorage.Size := DataSize - (EndPos - StartPos);
  FDataSize := -1;
  EndPos := GetPosAtCursor(aCol, aRow);

  if DataSize < 1 then
  begin
    LIntNewCol := GRID_FIXED;
    if FPosInCharField then
      LIntNewCol := Max(GRID_FIXED, GetOtherFieldCol(LIntNewCol, LBoolDummy));
    MoveColRow(LIntNewCol, GRID_FIXED, True, True)
  end
  else if EndPos >= DataSize then
  begin
    if InsertMode then
      LgrdEndPos := GetCursorAtPos(DataSize, FPosInCharField)
    else
      LgrdEndPos := GetCursorAtPos(DataSize - 1, FPosInCharField);
    MoveColRow(LgrdEndPos.x, LgrdEndPos.y, True, True);
  end
  else if ACol > -1 then
    MoveColRow(aCol, aRow, True, True);

  CalcSizes;
  ResetSelection(False);

  Invalidate;
end;

procedure TCustomMPHexEditor.DeleteSelection(const UndoDesc: string = '');
var
  LIntSelStart, LIntSelEnd: integer;
  LIntCol, LIntRow: integer;
begin
  InternalGetCurSel(LIntSelStart, LIntSelEnd, LIntCol, LIntRow);
  if not CreateUndo(ufKindByteRemoved, LIntSelStart, LIntSelEnd - LIntSelStart,
    0, UndoDesc) then
    Exit;

  InternalDelete(LIntSelStart, LIntSelEnd, LIntCol, LIntRow);
  Changed;
end;

function TCustomMPHexEditor.CreateUndo(const aKind: TMPHUndoFlag; const aPos, aCount,
  aReplCount: integer; const sDesc: string = ''): boolean;
begin
  Result := False;
  if DataSize > 0 then
    Result := True;

  if not Result then
    if (aKind = ufKindInsertBuffer) or (aKind = ufKindAppendBuffer) then
      Result := True;

  // check for NoSizeChange
  if FDisallowSizeChange and Result then
    if (aKind in [ufKindByteRemoved, ufKindInsertBuffer, ufKindAppendBuffer,
      ufKindNibbleInsert,
      ufKindNibbleDelete]) or
      ((aKind = ufKindReplaceSelection) and (aCount <> aReplCount)) then
      Result := False;

  if (not Result) and ((aKind = ufKindCombined) and (FUndoStorage.Count >= aCount)) then
    Result := True;

  if Result then
  begin
    if FUndoStorage.UpdateCount = 0 then
      FUndoStorage.CreateUndo(aKind, aPos, aCount, aReplCount, sDesc);
    FModified := True;
    //Changed;
  end;
end;

procedure TCustomMPHexEditor.ResetUndo;
begin
  FUndoStorage.Reset;
end;

function TCustomMPHexEditor.GetCanUndo: boolean;
begin
  Result := FUndoStorage.CanUndo;
end;

function TCustomMPHexEditor.GetCanRedo: boolean;
begin
  Result := FUndoStorage.CanRedo;
end;

function TCustomMPHexEditor.GetUndoDescription: string;
begin
  with FUndoStorage do
    if CanUndo then
      Result := Description
  else
    Result := UNDO_NOUNDO;
end;

function TCustomMPHexEditor.GetSelStart: integer;
begin
  if FSelPosition = -1 then
  begin
    Result := GetPosAtCursor(Col, Row);
  end
  else
    Result := FSelPosition;
end;

function TCustomMPHexEditor.GetSelEnd: integer;
begin
  if FSelPosition = -1 then
    Result := GetPosAtCursor(Col, Row)
  else
  begin
    Result := FSelEnd;
    if FSelPosition = FSelEnd then
      Result := FSelStart;
  end;
end;

procedure TCustomMPHexEditor.SetSelStart(aValue: integer);
begin
  if (aValue < 0) or (aValue >= DataSize) then
    raise EMPHException.Create(ERR_INVALID_SELSTART)
  else
  begin
    ResetSelection(True);
    with GetCursorAtPos(aValue, InCharField) do
      MoveColRow(X, Y, True, True);
  end;
end;

procedure TCustomMPHexEditor.SetSelEnd(aValue: integer);
begin
  if (aValue < -1) or (aValue >= DataSize) then
    raise EMPHException.Create(ERR_INVALID_SELEND)
  else
  begin
    ResetSelection(True);
    if aValue > -1 then
    begin
      with GetCursorAtPos(aValue, InCharField) do
        Select(Col, Row, X, Y);
    end;
  end;
end;

procedure TCustomMPHexEditor.SetInCharField(const Value: boolean);
begin
  if (DataSize < 1) then
    Exit;

  if InCharField <> Value then
    MoveColRow(GetOtherFieldCol(Col, FPosInCharField), Row, True, True);
end;

function TCustomMPHexEditor.GetInCharField: boolean;
begin
  Result := False;
  if DataSize < 1 then
    Exit;

  GetPosAtCursor(Col, Row);
  Result := FPosInCharField;
end;

procedure TCustomMPHexEditor.Loaded;
begin
  inherited;
  CreateEmptyFile(UNNAMED_FILE);
end;

procedure TCustomMPHexEditor.CreateWnd;
begin
  inherited;
  if (csDesigning in ComponentState) or (FFileName = '---') then
    CreateEmptyFile(UNNAMED_FILE);
end;

procedure TCustomMPHexEditor.WMSetFocus(var Msg: TWMSetFocus);
begin
  inherited;
  CreateColoredCaret;
  with CellRect(Col, Row) do
  begin
    if Left + Bottom = 0 then
      IntSetCaretPos(-50, - 50)
    else
      IntSetCaretPos(Left, Top);

    Invalidate;
  end;
end;

procedure TCustomMPHexEditor.WMKillFocus(var Msg: TWMKillFocus);
begin
  inherited;
  HideCaret(Handle);
  DestroyCaret();
  FIsSelecting := False;
  Invalidate;
end;

procedure TCustomMPHexEditor.WMINTUPDATECARET(var Msg: TMessage);
begin
  if Msg.WParam = 7 then
  begin
    with CellRect(Col, Row) do
    begin
      if Left + Bottom = 0 then
        IntSetCaretPos(-50, - 50)
      else
        IntSetCaretPos(Left, Top);
    end;
  end;
end;

procedure TCustomMPHexEditor.SetTranslation(const Value: TMPHTranslationKind);
begin
  if FTranslation <> Value then
  begin
    FTranslation := Value;
    Invalidate;
  end;
end;

procedure TCustomMPHexEditor.SetModified(const Value: boolean);
begin
  FModified := Value;
  if not Value then
  begin
    ResetUndo;
    FModifiedBytes.Size := 0;
    Invalidate;
  end;
end;

procedure TCustomMPHexEditor.SetBytesPerRow(const Value: integer);
var
  LIntPos, LIntSelPos, LIntSelStart, LIntSelEnd: integer;
  LBoolInCharField: boolean;
  LBool2ndCol: boolean;
begin
  if (Value < 1) or (Value > 256) then
    raise EMPHException.Create(ERR_INVALID_BYTESPERLINE)
  else if FBytesPerRow <> Value then
  begin
    with FOffsetFormat do
      if offCalcRow in Flags then
        BytesPerUnit := Value;
    LIntSelPos := FSelPosition;
    LIntSelStart := FSelStart;
    LIntSelEnd := FSelEnd;
    LIntPos := GetPosAtCursor(Col, Row);
    LBoolInCharField := FPosInCharField;
    LBool2ndCol := GetCursorAtPos(LIntPos, LBoolInCharField).x <> Col;
    FBytesPerRow := Value;
    FBytesPerRowDup := Value * 2;
    CalcSizes;
    if (LIntPos >= DataSize) or (InsertMode and (LIntPos > DataSize)) then
      LIntPos := DataSize - 1;

    with GetCursorAtPos(LIntPos, LBoolInCharField) do
    begin
      if LBool2ndCol then
        Inc(x);

      MoveColRow(x, y, True, True);
    end;

    SetSelection(LIntSelPos, LIntSelStart, LIntSelEnd);
  end;
end;

procedure TCustomMPHexEditor.InternalAppendBuffer(Buffer: PChar; const Size: integer);
var
  LIntSize: integer;
begin
  if DataSize = 0 then
  begin
    FDataStorage.Position := 0;
    FModifiedBytes.Size := 0;
  end;

  LIntSize := DataSize;
  FDataStorage.Size := LIntSize + Size;
  FDataSize := -1;
  SetMemAtPos(PByteArray(Buffer), LIntSize, Size);
  CalcSizes;
end;

procedure TCustomMPHexEditor.InternalInsertBuffer(Buffer: PChar;
  const Size, Position: integer);
var
  LIntSize: integer;
begin
  if DataSize = 0 then
  begin
    FDataStorage.Position := 0;
    FModifiedBytes.Size := 0;
  end;

  LIntSize := DataSize;
  FDataStorage.Size := LIntSize + Size;
  FDataSize := -1;
  if Position < LIntSize then // nur, wenn nicht hinter streamende, dann platz schaffen
    MoveFileMem(Position, Position + Size, DataSize - Position - Size); //+ 1);

  SetMemAtPos(PByteArray(Buffer), Position, Size);
  CalcSizes;
end;

procedure TCustomMPHexEditor.InsertBuffer(aBuffer: PChar;
  const aSize, aPos: integer; const UndoDesc: string = '');
begin
  if not CreateUndo(ufKindInsertBuffer, aPos, aSize, 0, UndoDesc) then
    Exit;

  InternalInsertBuffer(aBuffer, aSize, aPos);

  if FModifiedBytes.Size >= (aPos) then
    FModifiedBytes.Size := aPos;

  if Enabled then
  begin
    SetSelection(aPos, aPos, aPos + aSize - 1);
    with GetCursorAtPos(FSelEnd, InCharField) do
      MoveColRow(x, y, True, True);
    SetSelection(aPos, aPos, aPos + aSize - 1);
    Invalidate;
  end;
  Changed;
end;

procedure TCustomMPHexEditor.AppendBuffer(aBuffer: PChar; const aSize: integer;
  const UndoDesc: string = '');
var
  LIntSize: integer;
begin
  if (not Assigned(aBuffer)) or (aSize = 0) then
    Exit;

  if not CreateUndo(ufKindAppendBuffer, DataSize, aSize, 0, UndoDesc) then
    Exit;

  if FModifiedBytes.Size >= (DataSize) then
    FModifiedBytes.Size := DataSize;

  LIntSize := DataSize;
  InternalAppendBuffer(aBuffer, aSize);

  with GetCursorAtPos(LIntSize, InCharField) do
    MoveColRow(x, y, True, True);
  SetSelection(LIntSize, LIntSize, LIntSize + aSize - 1);
  Invalidate;
  Changed;
end;

procedure TCustomMPHexEditor.ReplaceSelection(aBuffer: PChar; aSize: integer;
  const UndoDesc: string = '');
var
  LIntStart, LIntEnd, LIntCol, LIntRow: integer;
  LBoolInCharField: boolean;
begin
  // auswahl berechnen
  LBoolInCharField := GetInCharField;
  if FSelPosition = -1 then
    InsertBuffer(aBuffer, aSize, SelStart, UndoDesc)
  else
  begin
    if FDisallowSizeChange then
    begin
      if aSize > SelCount then
        aSize := SelCount
      else if SelCount > aSize then
      begin
        SelStart := Min(SelStart, SelEnd);
        SelEnd := SelStart + aSize - 1;
      end;
    end;

    if not CreateUndo(ufKindReplaceSelection, FSelStart, aSize, SelCount, UndoDesc) then
      Exit;

    // zuerst aktuelle auswahl lschen
    InternalGetCurSel(LIntStart, LIntEnd, LIntCol, LIntRow);
    InternalDelete(LIntStart, LIntEnd, LIntCol, LIntRow);
    InternalInsertBuffer(aBuffer, aSize, LIntStart);
    if FModifiedBytes.Size >= LIntStart then
      FModifiedBytes.Size := Max(0, LIntStart);

    with GetCursorAtPos(LIntStart + aSize - 1, LBoolInCharField) do
      MoveColRow(x, y, True, True);
    SetSelection(LIntStart + aSize - 1, LIntStart, LIntStart + aSize - 1);
    Invalidate;
    Changed;
  end;
end;

procedure TCustomMPHexEditor.SetChanged(DataPos: integer; const Value: boolean);
begin
  if InsertMode then
    FModifiedBytes.Size := 0;

  if not Value then
    if FModifiedBytes.Size <= DataPos then
      Exit;

  FModifiedBytes[DataPos] := Value;
end;

procedure TCustomMPHexEditor.MoveFileMem(const aFrom, aTo, aCount: integer);
begin
  MoveMemory(Pointer(longint(FDataStorage.Memory) + aTo),
    Pointer(longint(FDataStorage.Memory) + aFrom), aCount);
end;

function TCustomMPHexEditor.GetCursorPos: integer;
begin
  Result := GetPosAtCursor(Col, Row);
  if Result < 0 then
    Result := 0;

  if Result > Max(0, DataSize - 1) then
    Result := Max(0, DataSize - 1)
end;

function TCustomMPHexEditor.GetSelCount: integer;
begin
  if FSelPosition = -1 then
    Result := 0
  else
    Result := Max(FSelStart, FSelEnd) - Min(FSelStart, FSelEnd) + 1;
end;

function TCustomMPHexEditor.GetMemory(aIndex: integer): char;
begin
  if (aIndex < 0) or (aIndex >= DataSize) then
    raise EMPHException.Create(ERR_INVALID_MEMORY_INDEX)
  else
  begin
    CopyMemory(@Result, Pointer(longint(FDataStorage.Memory) + aIndex),
      SizeOf(char));
  end;
end;

procedure TCustomMPHexEditor.SetMemory(aIndex: integer; const aChar: char);
begin
  if (aIndex < 0) or (aIndex >= DataSize) then
    raise EMPHException.Create(ERR_INVALID_MEMORY_INDEX)
  else
  begin
    CopyMemory(Pointer(longint(FDataStorage.Memory) + aIndex), @aChar,
      SizeOf(char));
    FDataSize := -1;
  end;
end;

procedure TCustomMPHexEditor.SetReadOnlyFile(const Value: boolean);
begin
  if Value and (not FIsFileReadonly) then
  begin
    FIsFileReadonly := True;
  end;
end;

function TCustomMPHexEditor.BufferFromFile(const aPos: integer;
  var aCount: integer): PChar;
begin
  if (aPos < 0) or (aPos >= DataSize) then
    raise EMPHException.Create(ERR_INVALID_BUFFERFROMFILE)
  else
  begin
    if (aPos + aCount) > DataSize then
      aCount := (DataSize - aPos) + 1;

    GetMem(Result, aCount);
    try
      CopyMemory(Result, Pointer(longint(FDataStorage.Memory) + aPos), aCount);
    except
      FreeMem(Result, aCount);
      Result := nil;
      aCount := 0;
    end;
  end;
end;

procedure TCustomMPHexEditor.WMVScroll(var Msg: TWMVScroll);
begin
  inherited;
  with CellRect(Col, Row) do
  begin
    if Left + Bottom = 0 then
      IntSetCaretPos(-50, - 50)
    else
      IntSetCaretPos(Left, Top);
  end;
end;

procedure TCustomMPHexEditor.WMHScroll(var Msg: TWMHScroll);
begin
  inherited;
  with CellRect(Col, Row) do
  begin
    if Left + Bottom = 0 then
      IntSetCaretPos(-50, - 50)
    else
      IntSetCaretPos(Left, Top);
  end;
end;

procedure TCustomMPHexEditor.CreateColoredCaret;
begin
  DestroyCaret();
  FCaretBitmap.Width := FCharWidth;
  FCaretBitmap.Height := FCharHeight - 2;
  FCaretBitmap.Canvas.Brush.Color := clBlack;
  FCaretBitmap.Canvas.FillRect(Rect(0, 0, FCharWidth, FCharHeight - 2));
  FCaretBitmap.Canvas.Brush.Color := clWhite;
  case FCaretKind of
    ckFull:
      FCaretBitmap.Canvas.FillRect(Rect(0, 0, FCharWidth, FCharHeight - 2));
    ckLeft:
      FCaretBitmap.Canvas.FillRect(Rect(0, 0, 2, FCharHeight - 2));
    ckBottom:
      FCaretBitmap.Canvas.FillRect(Rect(0, FCharHeight - 4, FCharWidth,
        FCharHeight - 2));
    ckAuto:
      begin
        if FInsertModeOn then
          FCaretBitmap.Canvas.FillRect(Rect(0, 0, 2, FCharHeight - 2))
        else
          FCaretBitmap.Canvas.FillRect(Rect(0, 0, FCharWidth, FCharHeight - 2));
      end;
  end;
  CreateCaret(Handle, FCaretBitmap.Handle, 0, 0);
  ShowCaret(Handle);
end;

procedure TCustomMPHexEditor.SetBytesPerColumn(const Value: integer);
begin
  if (Value < 1) or (Value > 256) then
    raise EMPHException.Create(ERR_INVALID_BYTESPERCOL)
  else if FBytesPerCol <> (Value * 2) then
  begin
    with FOffsetFormat do
      if offCalcColumn in Flags then
        BytesPerUnit := Value;
    FBytesPerCol := Value * 2;
    AdjustMetrics;
    Invalidate;
  end;
end;

function TCustomMPHexEditor.GetBytesPerColumn: integer;
begin
  Result := FBytesPerCol div 2;
end;

function TCustomMPHexEditor.Find(aBuffer: PChar; const aCount, aStart, aEnd: integer;
  const IgnoreCase, SearchText: boolean): integer;
  // find something in the current file and return the position, -1 if not found
var
  LChrCurrent: char;
  LIntCurPos, LIntLoop, LIntFound, LIntEnd: integer;
  LPchTemp: PChar;
begin
  Result := -1;
  LIntEnd := aEnd;
  if LIntEnd >= DataSize then
    LIntEnd := DataSize - 1;

  if aCount < 1 then
    Exit;

  if aStart + aCount > (LIntEnd + 1) then
    Exit; // will never be found, if search-part is smaller than searched data

  WaitCursor;
  GetMem(LPchTemp, aCount);
  try
    Move(aBuffer^, LPChTemp^, aCount);
    if IgnoreCase then
      CharLowerBuff(LPchTemp, aCount);

    if SearchText and (FTranslation <> tkAsIs) then
      TranslateBufferFromAnsi(FTranslation, LPchTemp, LPchTemp, aCount);

    LIntCurPos := aStart;
    LIntLoop := 0;
    LIntFound := LIntCurPos + 1;

    repeat
      if LIntCurPos > LIntEnd then
        Exit;

      LChrCurrent := char(byte(GetMemory(LIntCurPos)));
      if IgnoreCase then
      begin
        if FTranslation <> tkAsIs then
        begin
          TranslateBufferToAnsi(FTranslation, @LChrCurrent, @LChrCurrent, 1);
          CharLowerBuff(@LChrCurrent, 1);
          TranslateBufferFromAnsi(FTranslation, @LChrCurrent, @LChrCurrent, 1);
        end
        else
          CharLowerBuff(@LChrCurrent, 1);
      end;

      if (LChrCurrent = LPchTemp[LIntLoop]) then
      begin
        if LIntLoop = (aCount - 1) then
        begin
          Result := LIntCurPos - aCount + 1;
          Exit;
        end
        else
        begin
          if LIntLoop = 0 then
            LIntFound := LIntCurPos + 1;
          Inc(LIntCurPos);
          Inc(LIntLoop);
        end;
      end
      else
      begin
        LIntCurPos := LIntFound;
        LIntLoop := 0;
        LIntFound := LIntCurPos + 1;
      end;
    until False;

  finally
    OldCursor;
    FreeMem(LPchTemp);
  end;
end;

procedure TCustomMPHexEditor.SetOffsetDisplayWidth;
begin
  with FOffsetFormat do
    if offCalcWidth in Flags then
      MinWidth := Length(IntToRadix(((RowCount - 3) * FBytesPerRow) div BytesPerUnit, Radix));

  FOffSetDisplayWidth := Length(GetOffsetString((RowCount - 3) * FBytesPerRow)) + 1;

  if FGutterWidth = -1 then
    ColWidths[0] := FOffSetDisplayWidth * FCharWidth + 20
  else
    ColWidths[0] := FGutterWidth;
end;

function TCustomMPHexEditor.Seek(const aOffset, aOrigin: integer): integer;
var
  LIntPos: integer;
begin
  Result := -1;
  LIntPos := GetCursorPos;
  case aOrigin of
    soFromBeginning:
      LIntPos := aOffset;
    soFromCurrent:
      LIntPos := GetCursorPos + aOffset;
    soFromEnd:
      LIntPos := DataSize + aOffset - 1;
  end;

  if DataSize < 1 then
    Exit;

  LIntPos := Min(Max(0, LIntPos), DataSize - 1);

  SelStart := LIntPos;
  Result := LIntPos;
end;

procedure TCustomMPHexEditor.SetSwapNibbles(const Value: boolean);
begin
  if integer(Value) <> FSwapNibbles then
  begin
    FSwapNibbles := integer(Value);
    Invalidate;
  end;
end;

function TCustomMPHexEditor.GetSwapNibbles: boolean;
begin
  Result := boolean(FSwapNibbles);
end;

procedure TCustomMPHexEditor.SetColors(const Value: TMPHColors);
begin
  FColors.Assign(Value);
end;


procedure TCustomMPHexEditor.SetCaretKind(const Value: TMPHCaretKind);
begin
  if FCaretKind <> Value then
  begin
    FCaretKind := Value;
    if Focused then
    begin
      CreateColoredCaret;
      IntSetCaretPos(-50, - 50);
      Invalidate;
    end;
  end;
end;

procedure TCustomMPHexEditor.SetFocusFrame(const Value: boolean);
begin
  if FFocusFrame <> Value then
  begin
    FFocusFrame := Value;
    Invalidate;
  end;
end;

procedure TCustomMPHexEditor.SetMaskChar(const Value: char);
begin
  if FReplaceUnprintableCharsBy <> Value then
  begin
    FReplaceUnprintableCharsBy := Value;
    Invalidate;
  end;
end;

procedure TCustomMPHexEditor.SetAsText(const Value: string);
var
  LpszBuffer: PChar;
begin
  if DataSize > 0 then
  begin
    // alles selektieren
    SelStart := 0;
    SelEnd := DataSize - 1;
  end;
  // do translation (thanks to philippe chessa)  dec 17 98
  GetMem(LpszBuffer, Length(Value));
  try
    Move(Value[1], LpszBuffer^, Length(Value));
    TranslateBufferFromANSI(FTranslation, @Value[1], LpszBuffer, Length(Value));
    ReplaceSelection(LpszBuffer, Length(Value));
  finally
    FreeMem(LpszBuffer);
  end;
end;

procedure TCustomMPHexEditor.SetAsHex(const Value: string);
var
  LpszBuffer: PChar;
  LIntAmount: integer;
begin
  if DataSize > 0 then
  begin
    // alles selektieren
    SelStart := 0;
    SelEnd := DataSize - 1;
  end;

  GetMem(LpszBuffer, Length(Value));
  try
    ConvertHexToBin(@Value[1], LpszBuffer, Length(Value), SwapNibbles, LIntAmount);
    ReplaceSelection(LpszBuffer, LIntAmount);
  finally
    FreeMem(LpszBuffer);
  end;
end;

function TCustomMPHexEditor.GetAsText: string;
begin
  if DataSize < 1 then
    Result := ''
  else
  begin
    SetLength(Result, DataSize);
    GetMemAtPos(@Result[1], 0, DataSize);
  end;
end;

function TCustomMPHexEditor.GetAsHex: string;
begin
  if DataSize < 1 then
    Result := ''
  else
  begin
    SetLength(Result, DataSize * 2);
    ConvertBinToHex(FDataStorage.Memory, @Result[1], DataSize, SwapNibbles);
  end;
end;

function TCustomMPHexEditor.GetSelectionAsHex: string;
var
  LPtrData: Pointer;
begin
  if (DataSize < 1) or (SelCount < 1) then
    Result := ''
  else
  begin
    SetLength(Result, SelCount * 2);
    LPtrData := Pointer(longint(FDataStorage.Memory) + Min(SelStart, SelEnd));
    ConvertBinToHex(LPtrData, @Result[1], SelCount, SwapNibbles);
  end;
end;

function TCustomMPHexEditor.GetInsertMode: boolean;
begin
  Result := FInsertModeOn and (not FDisallowSizeChange) and FAllowInsertMode and (not
    FReadOnlyView);
end;

procedure TCustomMPHexEditor.SetAllowInsertMode(const Value: boolean);
begin
  if FDisallowSizeChange or FReadOnlyView then
    FAllowInsertMode := False
  else
  begin
    if not Value then
    begin
      if FInsertModeOn then
        InsertMode := False;
    end;
    FAllowInsertMode := Value;
  end;
end;

procedure TCustomMPHexEditor.SetNoSizeChange(const Value: boolean);
begin
  if Value <> FDisAllowSizeChange then
  begin
    FDisallowSizeChange := Value;
    InsertMode := False;
  end;
end;

procedure TCustomMPHexEditor.InternalErase(const KeyWasBackspace: boolean;
  const UndoDesc: string = '');
var
  LIntPos: integer;
  LIntSavePos: integer;
begin
  LIntPos := GetCursorPos;
  LIntSavePos := LIntPos;
  if KeyWasBackspace then
  begin // Delete previous byte
    if InsertMode and (SelCount = 0) then
      LIntPos := GetPosAtCursor(Col, Row);

    if LIntPos = 0 then
      Exit; // Can't delete at offset -1

    if not CreateUndo(ufKindByteRemoved, LIntPos - 1, 1, 0, UndoDesc) then
      Exit;

    InternalDelete(LIntPos - 1, LIntPos, Col, Row);
    if LIntSavePos = LIntPos then
      Seek(LIntPos - 1, soFromBeginning) // Move caret
    else
    begin
      if (Col + 1) <= GetLastCharCol then
        Col := Col + 1;
    end;
    Changed;
  end
  else
  begin // Delete next byte
    if LIntPos = DataSize then
      Exit; // Cant delete at EOF
    if CreateUndo(ufKindByteRemoved, LIntPos, 1, 0, UndoDesc) then
    begin
      InternalDelete(LIntPos, LIntPos + 1, Col, Row);
      Changed;
    end;
  end;
end;

procedure TCustomMPHexEditor.WMGetDlgCode(var Msg: TWMGetDlgCode);
begin
  inherited;
  Msg.Result := Msg.Result or DLGC_WANTARROWS or DLGC_WANTCHARS or
    DLGC_WANTALLKEYS;
  if FWantTabs then
    Msg.Result := Msg.Result or DLGC_WANTTAB
  else
    Msg.Result := Msg.Result and not DLGC_WANTTAB;
end;

procedure TCustomMPHexEditor.CMFontChanged(var Message: TMessage);
begin
  inherited;
  if HandleAllocated then
  begin
    AdjustMetrics;
    if Focused then
    begin
      CreateColoredCaret;
    end;
  end;
end;

procedure TCustomMPHexEditor.SetWantTabs(const Value: boolean);
begin
  FWantTabs := Value;
end;

procedure TCustomMPHexEditor.SetReadOnlyView(const Value: boolean);
begin
  FReadOnlyView := Value;
end;

procedure TCustomMPHexEditor.SetHideSelection(const Value: boolean);
begin
  if FHideSelection <> Value then
  begin
    FHideSelection := Value;
    if (not Focused) and (GetSelCount > 0) then
      Invalidate;
  end;
end;

procedure TCustomMPHexEditor.SetGraySelectionIfNotFocused(const Value: boolean);
begin
  if FGraySelOnLostFocus <> Value then
  begin
    FGraySelOnLostFocus := Value;
    if (not Focused) and (GetSelCount > 0) and (not FHideSelection) then
      Invalidate;
  end;
end;

function TCustomMPHexEditor.CalcColCount: integer;
begin
  Result := FBytesPerRow * 3 + 1 + GRID_FIXED;
end;

function TCustomMPHexEditor.GetLastCharCol: integer;
begin
  Result := ColCount - 1;
end;

function TCustomMPHexEditor.GetTopLeftPosition(var oInCharField: boolean): integer;
begin
  Result := GetPosAtCursor(Max(LeftCol, GRID_FIXED), TopRow);
  oInCharField := InCharField;
end;

procedure TCustomMPHexEditor.SetTopLeftPosition(const aPosition: integer;
  const aInCharField: boolean);
begin
  with GetCursorAtPos(aPosition, aInCharField) do
  begin
    TopRow := y;
    LeftCol := x;
  end;
end;

function TCustomMPHexEditor.GetPropColCount: integer;
begin
  Result := inherited ColCount;
end;

function TCustomMPHexEditor.GetPropRowCount: integer;
begin
  Result := inherited RowCount;
end;

function TCustomMPHexEditor.ShowDragCell(const X, Y: integer): integer;
var
  LRctCell: TRect;
  LIntDragPos, LIntMouseX, LIntMouseY: integer;
begin
  with MouseCoord(X, Y) do
  begin
    LIntMouseX := X;
    LIntMouseY := Y;
    if X < GRID_FIXED then
      X := GRID_FIXED;
    if Y >= RowCount then
      Y := RowCount - 1;
    if Y < GRID_FIXED then
      Y := GRID_FIXED;
    LIntDragPos := GetPosAtCursor(X, Y)
  end;

  if LIntDragPos < 0 then
    LIntDragPos := 0;
  if LIntDragPos > DataSize then
    LIntDragPos := DataSize;
  if IsSelected(LIntDragPos) then
    LIntDragPos := Min(SelStart, SelEnd);
  Result := LIntDragPos;
  FShowDrag := True;

  if (LIntMouseY <= TopRow) and (LIntMouseY > GRID_FIXED) then
  begin
    // nach oben scrollen
    TopRow := TopRow - 1;
  end
  else if (LIntMouseY >= (TopRow + VisibleRowCount - 1)) and (LIntMouseY < Pred(RowCount)) then
  begin
    // nach unten scrollen
    TopRow := TopRow + 1;
  end;

  if (LIntMouseX <= LeftCol) and (LIntMouseX > GRID_FIXED) then
  begin
    // nach links scrollen
    LeftCol := LeftCol - 1;
  end
  else if (LIntMouseX >= (LeftCol + VisibleColCount - 1)) and
    (LIntMouseX < GetLastCharCol) then
  begin
    // nach unten scrollen
    LeftCol := LeftCol + 1;
  end;

  with GetCursorAtPos(LIntDragPos, FPosInCharField) do
  begin
    if (x = FShowDragCol) and (y = FShowDragRow) then
      Exit;
    LRctCell := CellRect(FShowDragCol, FShowDragRow);
    FShowDragCol := x;
    FShowDragRow := y;
    InvalidateRect(Handle, @LRctCell, True);
    LRctCell := CellRect(X, Y);
    InvalidateRect(Handle, @LRctCell, True);
  end;
end;

procedure TCustomMPHexEditor.HideDragCell;
begin
  FShowDrag := False;
  Invalidate;
end;

function TCustomMPHexEditor.CombineUndo(const aCount: integer;
  const sDesc: string = ''): boolean;
begin
  Result := CreateUndo(ufKindCombined, 0, aCount, 0, sDesc);
end;

function TCustomMPHexEditor.GetMouseOverSelection: boolean;
var
  LPntMouse: TPoint;
begin
  Windows.GetCursorPos(LPntMouse);
  LPntMouse := ScreenToClient(LPntMouse);
  Result := CursorOverSelection(LPntMouse.x, LPntMouse.y);
end;

function TCustomMPHexEditor.CursorOverSelection(const X, Y: integer): boolean;
var
  LIntPos: integer;
  LBoolInCharField: boolean;
begin
  Result := False;
  if SelCount * DataSize = 0 then
    Exit;

  LBoolInCharField := FPosInCharField;
  with MouseCoord(x, y) do
  begin
    if x < GRID_FIXED then
      Exit;

    LIntPos := GetPosAtCursor(X, Y);
    FPosInCharField := LBoolInCharField;
    if (LIntPos < 0) or (LIntPos >= DataSize) then
      Exit;
  end;

  Result := IsSelected(LIntPos);
end;

function TCustomMPHexEditor.MouseOverFixed(const X, Y: integer): boolean;
begin
  with MouseCoord(x, y) do
    Result := (x = 0) or (y = 0);
end;

procedure TCustomMPHexEditor.MouseMove(Shift: TShiftState; X, Y: integer);
var
  LgrcCoords: TGridCoord;
begin
  if Shift = [ssLeft] then
    LgrcCoords := CheckMouseCoord(X, Y);

  inherited MouseMove(Shift, x, y);

  if FMouseUpCanResetSel then
  begin
    FMouseUpCanResetSel := (LgrcCoords.x = FMouseDownCol) and
      (LgrcCoords.y = FMouseDownRow);
  end;

  if (Shift = []) and (CursorOverSelection(X, Y) or MouseOverFixed(X, Y)) then
    Cursor := crArrow
  else
    Cursor := crIBeam;
end;

procedure TCustomMPHexEditor.WMTimer(var Msg: TWMTimer);
var
  LPtMouse: TPoint;
  LgrcCoord: TGridCoord;
begin
  if FGridState <> gsSelecting then Exit;
  Windows.GetCursorPos(LPtMouse);
  LPtMouse := ScreenToClient(LPtMouse);
  LgrcCoord := CheckMouseCoord(LPtMouse.X, LPtMouse.Y);
  if (LGrcCoord.X <> -1) and (LGrcCoord.Y <> -1) then
    inherited;
end;

function TCustomMPHexEditor.CheckMouseCoord(var X, Y: integer): TGridCoord;
var
  LRctCell: TRect;
begin
  Result := MouseCoord(X, Y);
  if FInsertModeOn and (Result.X = GetLastCharCol) then
  begin
    LRctCell := CellRect(Result.X, Result.Y);
    if (X - LRctCell.Left) > FCharWidth then
    begin
      Y := Y + RowHeight;
      Result.Y := Result.Y + 1;
      Dec(Result.X, FBytesPerRow);
      Dec(X, FCharWidth * FBytesPerRow);
    end;
  end;
end;

procedure TCustomMPHexEditor.MouseUP(Button: TMouseButton; Shift: TShiftState;
  X, Y: integer);
begin
  CheckMouseCoord(X, Y);
  inherited;
  if FMouseUpCanResetSel then
  begin
    FMouseUpCanResetSel := False;
    ResetSelection(True);
    with MouseCoord(x, y) do
      MoveColRow(x, y, True, True);
  end;
  if FShowDrag then
    HideDragCell;
end;

procedure TCustomMPHexEditor.AdjustBookmarks(const From, Offset: integer);
var
  LIntLoop: integer;
begin
  if From >= 0 then
    for LIntLoop := 0 to 9 do
      with FBookmarks[LIntLoop] do
        if mPosition >= From then
        begin
          Inc(mPosition, Offset);
          if mPosition > DataSize then
            mPosition := -1;
        end;
end;

procedure TCustomMPHexEditor.IntSetCaretPos(const X, Y: integer);
begin
  if Focused then
    SetCaretPos(X, Y);
end;

procedure TCustomMPHexEditor.TruncMaxPosition(var DataPos: integer);
begin
  if DataPos >= DataSize then
  begin
    DataPos := DataSize - 1;
    if InsertMode then
      DataPos := DataSize;
  end;
end;


function TCustomMPHexEditor.GetCurrentValue: integer;
var
  LIntPos: integer;
begin
  Result := -1;
  LIntPos := GetPosAtCursor(Col, Row);
  if (LIntPos >= DataSize) or (LIntPos < 0) then
    Exit;
  Result := byte(GetMemory(LIntPos))
end;

procedure TCustomMPHexEditor.SetInsertMode(const Value: boolean);
var
  LIntPos: integer;
begin
  if Value = FInsertModeOn then
    Exit;
  if FAllowInsertMode and (not FReadOnlyView) and (not FDisallowSizeChange) then
  begin
    FInsertModeOn := Value;
    if (FCaretKind = ckAuto) and Focused then
      CreateColoredCaret;
    if DataSize < 1 then
      Exit;
    if not FInsertModeOn then
    begin
      if ((DataSize mod FBytesPerRow) = 0) and (DataSize > 0) then
        RowCount := RowCount - 1;
      LIntPos := GetPosAtCursor(Col, Row);
      if LIntPos = DataSize then
        SelStart := DataSize - 1;
    end
    else
    begin
      if ((DataSize mod FBytesPerRow) = 0) and (DataSize > 0) then
        RowCount := RowCount + 1;
    end;
    FModifiedBytes.Size := 0;
    Invalidate;
  end;
end;

function TCustomMPHexEditor.GetModified: boolean;
begin
  Result := FModified and ((DataSize > 0) or FileExists(FileName));
end;

function TCustomMPHexEditor.GetDataPointer: Pointer;
begin
  if DataSize < 1 then
    Result := nil
  else
    Result := FDataStorage.Memory;
end;

procedure TCustomMPHexEditor.SetSelection(const DataPos, StartPos, EndPos: integer);
begin
  FSelEnd := Max(-1, Min(EndPos, DataSize - 1));
  FSelPosition := Max(-1, Min(DataPos, DataSize - 1));
  FSelStart := Max(-1, Min(StartPos, DataSize - 1));
end;

procedure TCustomMPHexEditor.Resize;
begin
  PostMessage(Handle, WM_INTUPDATECARET, 7, 7);
  inherited;
end;

procedure TCustomMPHexEditor.WrongKey;
begin
  if Assigned(FOnInvalidKey) then
    FOnInvalidKey(self);
end;

procedure TCustomMPHexEditor.TopLeftChanged;
begin
  //Invalidate;
  if Assigned(FOnTopLeftChanged) then
    FOnTopLeftChanged(self);
end;

function TCustomMPHexEditor.GetOffsetString(const Position: cardinal): string;
begin
  Result := '';
  with FOffsetFormat do
  begin
    if Format <> '' then
    begin
      if (MinWidth <> 0) or (Position <> 0) then
      begin
        if FHexLowercase then
          Result := LowerCase(IntToRadixLen(Position div BytesPerUnit, Radix, MinWidth))
        else
          Result := Uppercase(IntToRadixLen(Position div BytesPerUnit, Radix, MinWidth));
      end;
      Result := Prefix + Result + Suffix;
    end;
  end;
end;

function TCustomMPHexEditor.GetAnyOffsetString(const Position: integer): string;
begin
  if FOffsetFormat.Format = '' then
    Result := IntToRadix(Position, 16)
  else
    Result := GetOffsetString(Position);
end;

function TCustomMPHexEditor.RowHeight: integer;
begin
  Result := DefaultRowHeight;
end;

function TCustomMPHexEditor.GetBookmark(Index: byte): TMPHBookmark;
begin
  if Index > 9 then
    raise EMPHException.Create(ERR_INVALID_BOOKMARK);

  Result := FBookmarks[Index];
end;

procedure TCustomMPHexEditor.SetBookmark(Index: byte;
  const Value: TMPHBookmark);
begin
  SetBookmarkVals(Index, Value.mPosition, Value.mInCharField);
end;

procedure TCustomMPHexEditor.SetBookmarkVals(const Index: byte;
  const Position: integer; const InCharField: boolean);
begin
  if Index > 9 then
    raise EMPHException.Create(ERR_INVALID_BOOKMARK);

  if (FBookmarks[Index].mPosition <> Position) or
    (FBookmarks[Index].mInCharField <> InCharField) then
  begin
    FBookmarks[Index].mPosition := Position;
    FBookmarks[Index].mInCharField := InCharField;
    Invalidate;
  end
  else
  begin
    FBookmarks[Index].mPosition := -1;
    FBookmarks[Index].mInCharField := InCharField;
    Invalidate;
  end;
end;

procedure TCustomMPHexEditor.Paint;
type
  TKindOfCell = (kocData, kocRuler, kocOffset, kocEmpty);
var
  DrawInfo: TGridDrawInfo;
  LIntCurCol, LIntCurRow: longint;
  LRctWhere: TRect;
  LRct2: TRect;
  LBoolDummy: boolean;
  LBoolOddCol: boolean;
  LBoolChanged: boolean;
  LIntDataPos: integer;
  LStrOutput: string;
  LColTextColor, LColTextBackColor, LColBackColor: TColor;
  LIntPenWidthSave: integer;

  // render a data/fixed cell
  procedure _TextOut;
  begin
    with Canvas, LRctWhere do
    begin
      Brush.Color := LColBackColor;
      FillRect(LRctWhere);
      LRct2 := Rect(Left, Top, Left + FCharWidth, Bottom);
      SetTextColor(Handle, ColorToRGB(LColTextColor));
      SetBKColor(Handle, ColorToRGB(LColTextBackColor));
      if LIntCurCol = 0 then
        ExtTextOut(Handle, Right - TextWidth(LStrOutput) - 4, Top,
          ETO_CLIPPED or ETO_OPAQUE, @LRctWhere, PChar(LStrOutput),
          Length(LStrOutput), nil)
      else
        ExtTextOut(Handle, Left, Top,
          ETO_CLIPPED or ETO_OPAQUE, @LRct2, PChar(LStrOutput),
          Length(LStrOutput), nil);
      if FShowDrag and (LIntCurCol = FShowDragCol) and (LIntCurRow = FShowDragRow) then
      begin
        LIntPenWidthSave := Pen.Width;
        try
          Pen.Width := 2;
          Pen.Color := LColTextColor;
          MoveTo(Left + 1, Top + 1);
          LineTo(Left + 1, Bottom - 1);
        finally
          Pen.Width := LIntPenWidthSave;
        end;
      end
    end;
  end;

  // draw an offset cell
  procedure DrawOffsetCell;
  var
    LIntLoop: integer;
  begin
    if (LIntCurRow = Row) then
    begin
      LColBackColor := FColors.CurrentOffsetBackground;
      LColTextColor := FColors.CurrentOffset;
    end
    else
    begin
      LColBackColor := FColors.OffsetBackground;
      LColTextColor := Colors.Offset;
    end;
    LColTextBackColor := lcolBackColor;

    (* text ausgeben *)
    LStrOutput := GetOffsetString((LIntCurRow - GRID_FIXED) * FBytesPerRow);
    _TextOut;

    (* auf bookmark prfen *)
    for LIntLoop := 0 to 9 do
      with FBookmarks[lIntLoop] do
        if (mPosition > -1) and ((mPosition div FBytesPerRow) = (LIntCurRow - GRID_FIXED)) then
          with LRctWhere do
            FBookmarkImageList.Draw(Canvas, Left + 3, ((Bottom - Top - 10) div 2) + Top,
              lIntLoop + (10 * integer(mInCharField)));
  end;

  // draw a ruler cell
  procedure DrawRulerCell;
  begin
    if LIntCurCol <> (GRID_FIXED + FBytesPerRowDup) then
    begin
      if LIntCurCol > (GRID_FIXED + FBytesPerRowDup) then
        LIntDataPos := (LIntCurCol - (GRID_FIXED + 1))
      else
      begin
        LIntDataPos := ((LIntCurCol - GRID_FIXED) div 2);
        if (LIntCurCol mod 2) = 0 then
          LIntDataPos := LIntDataPos div 16
        else
          LIntDataPos := LIntDataPos mod 16;
      end;
      LStrOutput := FHexChars[LIntDataPos and 15]
    end
    else
      LStrOutput := '  ';
    LColBackColor := FColors.OffsetBackGround;
    if Col = LIntCurCol then
    begin
      LColTextBackColor := FColors.CurrentOffsetBackGround;
      LColTextColor := FColors.CurrentOffset;
    end
    else
    begin
      LColTextBackColor := FColors.OffsetBackGround;
      LColTextColor := FColors.Offset;
    end;
    _TextOut;
  end;

  // draw a hex/char cell
  procedure DrawDataCell(const bIsCharCell: boolean);
  begin
    // caret setzen
    if (LIntCurRow = Row) and (LIntCurCol = Col) and Focused then
      IntSetCaretPos(LRctWhere.Left, LRctWhere.Top);

    LIntDataPos := GetPosAtCursor(LIntCurCol, LIntCurRow);
    LColBackColor := FColors.Background;

    // nicht zeichnen, falls keine daten
    if (LIntDataPos < DataSize) then
    begin
      if not bIsCharCell then
      begin // partie hexadecimale
        if ((LIntCurCol - GRID_FIXED) mod 2) = FSwapNibbles then
          LStrOutput := FHexChars[byte(GetMemory(LIntDataPos)) shr 4]
        else
          LStrOutput := FHexChars[byte(GetMemory(LIntDataPos)) and 15]
      end
      else
        LStrOutput := TranslateToAnsiChar(byte(GetMemory(LIntDataPos)));

      // testen ob byte gendert
      LBoolChanged := (HasChanged(LIntDataPos));
      LBoolOddCol := (((LIntCurCol - GRID_FIXED) div FBytesPerCol) mod 2) = 0;

      if LBoolChanged then
      begin
        LColTextColor := FColors.ChangedText;
        LColTextBackColor := FColors.ChangedBackground;
      end
      else
      begin
        LColTextBackColor := FColors.Background;
        LColTextColor := Font.Color;

        if not FPosInCharField then
          if LBoolOddCol then
            LColTextColor := Colors.OddColumn
          else
            LColTextColor := Colors.EvenColumn;
      end;

      if (FSelPosition <> -1) and IsSelected(LIntDataPos) then
      begin
        if (not FHideSelection) or Focused then
        begin
          if (LIntCurCol < GetLastCharCol) and
            (LIntCurCol <> (GRID_FIXED + FBytesPerRowDup - 1)) and
            (LIntDataPos <> Max(FSelStart, FSelEnd)) then
            LColBackColor := Invert(LColBackColor);
          LColTextBackColor := Invert(LColTextBackColor);
          LColTextColor := Invert(LColTextColor);

          if (not Focused) and FGraySelOnLostFocus then
          begin
            LColTextBackColor := FadeToGray(LColTextBackColor);
            LColTextColor := FadeToGray(LColTextColor);
          end;
        end;
      end;

      _TextOut;
    end;

    // fuocus frame auf der anderen seite
    if (LIntCurRow = Row) and Focused and (GetOtherFieldCol(Col, LBoolDummy) = LIntCurCol) then
    begin
      with LRctWhere do
        if FFocusFrame then
          Canvas.DrawFocusRect(Rect(Left, Top, Left + FCharWidth, Bottom - 1))
      else
      begin
        Canvas.Pen.Color := FColors.CursorFrame;
        Canvas.Brush.Style := bsClear;
        Canvas.Rectangle(Left, Top, Left + FCharWidth, Bottom - 1);
      end;
    end;

    if FDrawGridLines and (LIntCurCol = GetLastCharCol) then
    begin
      with Canvas, LRctWhere do
      begin
        Pen.Color := FColors.FGrid;
        MoveTo(Right - 1, Top);
        LineTo(Right - 1, Bottom - 1);
      end;
    end;
  end;

  // draw cells
  procedure DrawCells(ACol, ARow: longint; StartX, StartY, StopX, StopY: integer;
    Kind: TKindOfCell);
  begin
    LIntCurRow := ARow;
    LRctWhere.Top := StartY;
    while (LRctWhere.Top < StopY) and (LIntCurRow < RowCount) do
    begin
      LIntCurCol := ACol;
      LRctWhere.Left := StartX;
      LRctWhere.Bottom := LRctWhere.Top + RowHeights[LIntCurRow];
      while (LRctWhere.Left < StopX) and (LIntCurCol <= GetLastCharCol) do
      begin
        LRctWhere.Right := LRctWhere.Left + ColWidths[LIntCurCol];
        if (LRctWhere.Right > LRctWhere.Left) and RectVisible(Canvas.Handle, LRctWhere) then
        begin
          case Kind of
            kocData:
              begin
                if LIntCurCol < (GRID_FIXED + FBytesPerRowDup) then
                  DrawDataCell(False)
                else if LIntCurCol > (GRID_FIXED + FBytesPerRowDup) then
                  DrawDataCell(True)
                else if FDrawGridLines then
                  with Canvas do
                  begin
                    Pen.Color := FColors.FGrid;
                    MoveTo(LRctWhere.Left, LRctWhere.Top);
                    LineTo(LRctWhere.Left, LRctWhere.Bottom - 1);
                  end;

                if FDrawGridLines then
                  with Canvas do
                  begin
                    Pen.Color := FColors.FGrid;
                    MoveTo(LRctWhere.Left, LRctWhere.Bottom - 1);
                    LineTo(LRctWhere.Right, LRctWhere.Bottom - 1);
                  end;
              end;
            kocEmpty:
              begin
                Canvas.Brush.Color := FColors.OffsetBackGround;
                Canvas.FillRect(LRctWhere);
              end;
            kocRuler: DrawRulerCell;
            kocOffset:
              begin
                if LIntCurCol = 1 then
                begin
                  if FDrawGridLines then
                    with Canvas do
                    begin
                      Pen.Color := FColors.FGrid;
                      MoveTo(LRctWhere.Left, LRctWhere.Bottom - 1);
                      LineTo(LRctWhere.Right, LRctWhere.Bottom - 1);
                    end;
                end
                else
                  DrawOffsetCell;
              end;
          end;
        end;
        LRctWhere.Left := LRctWhere.Right;
        Inc(LIntCurCol);
      end;
      LRctWhere.Top := LRctWhere.Bottom;
      Inc(LIntCurRow);
    end;
  end;
var
  LIntTop: integer;
begin
  {$IFDEF DELPHI6UP}
  if UseRightToLeftAlignment then
    ChangeGridOrientation(True);
  {$ENDIF}

  CalcDrawInfo(DrawInfo);
  with DrawInfo do
  begin
    if FShowRuler then
    begin
      // oben links, fixed
      DrawCells(0, 0, 0, 0, Horz.FixedBoundary, Vert.FixedBoundary, kocEmpty);
      // oben, fixed
      DrawCells(LeftCol, 0, Horz.FixedBoundary, 0, Horz.GridBoundary,
        Vert.FixedBoundary, kocRuler);
    end;
    // links, fixed
    DrawCells(0, TopRow, 0, Vert.FixedBoundary, Horz.FixedBoundary,
      Vert.GridBoundary, kocOffset);
    // daten
    DrawCells(LeftCol, TopRow, Horz.FixedBoundary,
      Vert.FixedBoundary, Horz.GridBoundary, Vert.GridBoundary, kocData);

    // paint unoccupied space on the right
    if Horz.GridBoundary < Horz.GridExtent then
    begin
      Canvas.Brush.Color := Color;
      Canvas.FillRect(Rect(Horz.GridBoundary, 0, Horz.GridExtent,
        Vert.GridBoundary));

      // fixed (ruler)
      Canvas.Brush.Color := FColors.OffsetBackGround;
      Canvas.FillRect(Rect(Horz.GridBoundary, 0, Horz.GridExtent,
        RowHeights[0] + RowHeights[1]));
    end;

    // paint unoccupied space on bottom
    if Vert.GridBoundary < Vert.GridExtent then
    begin
      // hex + chars
      Canvas.Brush.Color := Color;
      Canvas.FillRect(Rect(ColWidths[0] + 1, Vert.GridBoundary, Horz.GridExtent,
        Vert.GridExtent));

      // fixed (position gutter)
      Canvas.Brush.Color := FColors.OffsetBackGround;
      Canvas.FillRect(Rect(0, Vert.GridBoundary, ColWidths[0],
        Vert.GridExtent));
    end;

    LIntTop := RowHeights[0] + RowHeights[1];

    // draw bevel on the right of the offset gutter
    if (ColWidths[0] <> 0) then
    begin
      if FDrawGutter3D then
      begin
        Canvas.MoveTo(ColWidths[0], LIntTop);
        Canvas.Pen.Color := clBtnShadow;
        Canvas.LineTo(ColWidths[0], Vert.GridExtent);
        Canvas.MoveTo(ColWidths[0] - 1, LIntTop);
        Canvas.Pen.Color := clBtnHighlight;
        Canvas.LineTo(ColWidths[0] - 1, Vert.GridExtent);
      end
      else if FDrawGridLines then
      begin
        Canvas.MoveTo(ColWidths[0] - 1, LIntTop);
        Canvas.Pen.Color := FColors.Grid;
        Canvas.LineTo(ColWidths[0] - 1, Vert.GridExtent);
      end;
    end;

    if (FShowRuler) then
    begin
      if FDrawGutter3D then
      begin
        Canvas.MoveTo(ColWidths[0] - 1, LIntTop - 1);
        Canvas.Pen.Color := clBtnShadow;
        Canvas.LineTo(Horz.GridExtent, LIntTop - 1);
        Canvas.MoveTo(ColWidths[0] - 1, LIntTop - 2);
        Canvas.Pen.Color := clBtnHighlight;
        Canvas.LineTo(Horz.GridExtent, LIntTop - 2);
      end
      else if FDrawGridLines then
      begin
        Canvas.MoveTo(ColWidths[0] - 1, LIntTop - 1);
        Canvas.Pen.Color := FColors.Grid;
        Canvas.LineTo(Horz.GridExtent, LIntTop - 1);
      end;
    end;
  end;

  {$IFDEF DELPHI6UP}
  if UseRightToLeftAlignment then
    ChangeGridOrientation(False);
  {$ENDIF}
end;

procedure TCustomMPHexEditor.SetSelectionAsHex(const s: string);
var
  LStrData: string;
  LIntAmount: integer;
begin
  if s <> '' then
  begin
    SetLength(LStrData, Length(s));
    ConvertHexToBin(@s[1], @LStrData[1], Length(s), SwapNibbles, LIntAmount);
    SetLength(LStrData, LIntAmount);
    SetSelectionAsText(LStrData);
  end;
end;

function TCustomMPHexEditor.GetSelectionAsText: string;
var
  LPtrData: Pointer;
begin
  if (DataSize < 1) or (SelCount < 1) then
    Result := ''
  else
  begin
    SetLength(Result, SelCount);
    LPtrData := Pointer(longint(FDataStorage.Memory) + Min(SelStart, SelEnd));
    Move(LPtrData^, Result[1], SelCount);
  end;
end;

procedure TCustomMPHexEditor.SetSelectionAsText(const s: string);
begin
  if s <> '' then
    ReplaceSelection(@s[1], Length(s));
end;

procedure TCustomMPHexEditor.SetDrawGridLines(const Value: boolean);
begin
  if Value <> FDrawGridLines then
  begin
    FDrawGridLines := Value;
    Invalidate;
  end;
end;

procedure TCustomMPHexEditor.UndoBeginUpdate;
begin
  FUndoStorage.BeginUpdate;
end;

function TCustomMPHexEditor.UndoEndUpdate: integer;
begin
  Result := FUndoStorage.EndUpdate;
end;

function TCustomMPHexEditor.Undo: boolean;
begin
  Result := FUndoStorage.Undo;
end;

function TCustomMPHexEditor.Redo: boolean;
begin
  Result := FUndoStorage.Redo;
end;

procedure TCustomMPHexEditor.SetGutterWidth(const Value: integer);
begin
  if FGutterWidth <> Value then
  begin
    FGutterWidth := Value;
    SetOffsetDisplayWidth;
    Invalidate;
  end;
end;

procedure TCustomMPHexEditor.BookmarkBitmapChanged(Sender: TObject);
var
  LRctBox: TRect;
begin
  // spalte 1 invalidieren
  FBookmarkImageList.Clear;
  FBookmarkImageList.AddMasked(FBookmarkBitmap, FBookmarkBitmap.Canvas.Pixels[0,0]);
  if HandleAllocated then
  begin
    LRctBox := BoxRect(0, TopRow, 0, TopRow + VisibleRowCount);
    InvalidateRect(Handle, @LRctBox, False);
  end;
end;



procedure TCustomMPHexEditor.SetBookmarkBitmap(const Value: TBitmap);
begin
  if Value = nil then
    FBookmarkBitmap.LoadFromResourceName(HINSTANCE, 'BOOKMARKICONS')
  else
  begin
    if (Value.Width <> 200) or (Value.Height <> 10) then
      raise EMPHException.Create(ERR_INVALID_BOOKMARKBMP);
    FBookmarkBitmap.Assign(Value);
  end;
  FHasCustomBMP := Value <> nil;
end;


procedure TCustomMPHexEditor.SelectAll;
var
  LgrcPosition: TGridCoord;
begin
  if DataSize > 0 then
  begin
    // position auf ende stzen
    if (not InsertMode) then
      LgrcPosition := GetCursorAtPos(DataSize - 1, InCharField)
    else
      LgrcPosition := GetCursorAtPos(DataSize, InCharField);
    MoveColRow(LgrcPosition.x, LgrcPosition.y, True, True);

    // alles whlen
    NewSelection(0,Pred(DataSize));
  end;
end;

function TCustomMPHexEditor.GetVersion: string;
begin
  Result := MPH_VERSION;
end;

procedure TCustomMPHexEditor.SetVersion(const Value: string);
begin
  // readonly property
end;

procedure TCustomMPHexEditor.FreeStorage(FreeUndo: boolean = False);
begin
  if not FreeUndo then
    FDataStorage.Size := 0
  else
    FUndoStorage.Size := 0;
end;

procedure TCustomMPHexEditor.OldCursor;
begin
  if Length(FCursorList) > 0 then
  begin
    Cursor := FCursorList[Pred(Length(FCursorList))];
    SetLength(FCursorList, PRed(Length(FCursorList)));
  end;
end;

procedure TCustomMPHexEditor.WaitCursor;
begin
  SetLength(FCursorList, Succ(Length(FCursorList)));
  FCursorList[Pred(Length(FCursorList))] := Cursor;
  Cursor := crHourGlass;
end;

function TCustomMPHexEditor.HasCustomBookmarkBitmap: boolean;
begin
  Result := FHasCustomBMP;
end;

procedure TCustomMPHexEditor.PrepareOverwriteDiskFile;
begin
  if FIsFileReadonly then
    raise EFOpenError.CreateFmt(ERR_FILE_READONLY, [FileName]);
end;

procedure TCustomMPHexEditor.Changed;
begin
  if Assigned(FOnChange) then
    FOnChange(self);
end;

procedure TCustomMPHexEditor.SetDrawGutter3D(const Value: boolean);
begin
  if FDrawGutter3D <> Value then
  begin
    FDrawGutter3D := Value;
    Repaint;
  end;
end;

procedure TCustomMPHexEditor.SetShowRuler(const Value: boolean);
begin
  if (FShowRuler <> Value) or (csLoading in ComponentState) then
  begin
    FShowRuler := Value;
    AdjustMetrics;
  end;
end;

{ TColors }

procedure TMPHColors.Assign(Source: TPersistent);
begin
  if Source is TMPHColors then
  begin
    Background := TMPHColors(Source).Background;
    ChangedText := TMPHColors(Source).ChangedText;
    CursorFrame := TMPHColors(Source).CursorFrame;
    Offset := TMPHColors(Source).Offset;
    OddColumn := TMPHColors(Source).OddColumn;
    EvenColumn := TMPHColors(Source).EvenColumn;
    ChangedBackground := TMPHColors(Source).ChangedBackground;
    CurrentOffsetBackground := TMPHColors(Source).CurrentOffsetBackground;
    CurrentOffset := TMPHColors(Source).CurrentOffset;
    OffsetBackground := TMPHColors(Source).OffsetBackground;
    Grid := TMPHColors(Source).Grid;
  end;
end;

constructor TMPHColors.Create(Parent: TControl);
begin
  inherited Create;
  FBackground := clWindow;
  FChangedText := clMaroon;
  FCursorFrame := clNavy;
  FOffset := clBlack;
  FOddColumn := clBlue;
  FEvenColumn := clNavy;
  FChangedBackground := $00A8FFFF;
  FCurrentOffsetBackground := clBtnShadow;
  FCurrentOffset := clBtnHighLight;
  FOffsetBackground := clBtnFace;
  FGrid := clBtnFace;
  FParent := Parent;
end;

procedure TMPHColors.SetBackground(const Value: TColor);
begin
  if FBackground <> Value then
  begin
    FBackground := Value;
    if Assigned(fParent) then
    begin
      TCustomMPHexEditor(FParent).Color := Value;
      fParent.Invalidate;
    end;
  end;
end;

procedure TMPHColors.SetChangedBackground(const Value: TColor);
begin
  if FChangedBackground <> Value then
  begin
    FChangedBackground := Value;
    if Assigned(fParent) then
      fParent.Invalidate;
  end;
end;

procedure TMPHColors.SetCurrentOffsetBackground(const Value: TColor);
begin
  if FCurrentOffsetBackground <> Value then
  begin
    FCurrentOffsetBackground := Value;
    if Assigned(fParent) then
      fParent.Invalidate;
  end;
end;

procedure TMPHColors.SetChangedText(const Value: TColor);
begin
  if FChangedText <> Value then
  begin
    FChangedText := Value;
    if Assigned(fParent) then
      fParent.Invalidate;
  end;
end;

procedure TMPHColors.SetCursorFrame(const Value: TColor);
begin
  if FCursorFrame <> Value then
  begin
    FCursorFrame := Value;
    if Assigned(fParent) then
      fParent.Invalidate;
  end;
end;

procedure TMPHColors.SetEvenColumn(const Value: TColor);
begin
  if FEvenColumn <> Value then
  begin
    FEvenColumn := Value;
    if Assigned(fParent) then
      fParent.Invalidate;
  end;
end;

procedure TMPHColors.SetOddColumn(const Value: TColor);
begin
  if FOddColumn <> Value then
  begin
    FOddColumn := Value;
    if Assigned(fParent) then
      fParent.Invalidate;
  end;
end;

procedure TMPHColors.SetOffset(const Value: TColor);
begin
  if FOffset <> Value then
  begin
    FOffset := Value;
    if Assigned(fParent) then
      fParent.Invalidate;
  end;
end;

procedure TMPHColors.SetOffsetBackGround(const Value: TColor);
begin
  if FOffsetBackGround <> Value then
  begin
    FOffsetBackGround := Value;
    if Assigned(fParent) then
      fParent.Invalidate;
  end;
end;

procedure TMPHColors.SetCurrentOffset(const Value: TColor);
begin
  if FCurrentOffset <> Value then
  begin
    FCurrentOffset := Value;
    if Assigned(fParent) then
      fParent.Invalidate;
  end;
end;

procedure TMPHColors.SetParent(const Value: TControl);
begin
  FParent := Value;
  Assign(self);
end;

procedure TMPHColors.SetGrid(const Value: TColor);
begin
  if FGrid <> Value then
  begin
    FGrid := Value;
    if Assigned(fParent) then
      fParent.Invalidate;
  end;
end;


{ TMPHUndoStorage }

type

  // undo storage

  PUndoSelRec = ^TUndoSelRec;
  TUndoSelRec = packed record
    SelStart,
    SelEnd,
    SelPos: integer;
  end;



constructor TMPHUndoStorage.Create(AEditor: TCustomMPHexEditor);
begin
  inherited Create;
  FEditor := AEditor;
  FRedoPointer := nil;
  FLastUndo := nil;
  FLastUndoSize := 0;
  Reset;
end;


destructor TMPHUndoStorage.Destroy;
begin
  Reset;
  inherited;
end;


function TMPHUndoStorage.BeginUpdate: integer;
begin
  Inc(FUpdateCount);
  Result := FUpdateCount;
end;

function TMPHUndoStorage.CanUndo: boolean;
begin
  Result := (FCount > 0) and (FUpdateCount < 1) and (Size > 0);
end;

procedure TMPHUndoStorage.CreateUndo(aKind: TMPHUndoFlag; APosition, ACount,
  AReplaceCount: integer; const SDescription: string);
var
  LPurUndoRec: PMPHUndoRec;

  procedure FillBuffer(var aBuffer: TMPHUndoRec);
  begin
    FillChar(aBuffer, SizeOf(TMPHUndoRec), 0);
    with aBuffer do 
    begin
      Flags := [aKind];
      CurPos := FEditor.GetPosAtCursor(FEditor.Col, FEditor.Row);
      if not FEditor.FPosInCharField then
        with FEditor.GetCursorAtPos(CurPos, FEditor.FPosInCharField) do
          if (FEditor.Col - x) <> 0 then
            Include(Flags, ufFlag2ndByteCol);
      if FEditor.FPosInCharField then
        Include(Flags, ufFlagInCharField);
      if FEditor.FInsertModeOn then
        Include(Flags, ufFlagInsertMode);
      Pos := aPosition;
      Count := aCount;
      ReplCount := aReplaceCount;
      Translation := FEditor.FTranslation;
      if FEditor.FModified then
        Include(Flags, ufFlagModified);
      if FEditor.FSelPosition > -1 then
        Include(Flags, ufFlagHasSelection);
    end;
  end;

  procedure DeleteOldestUndoRec;
  var
    LintRecSize: integer;
  begin
    begin
      if Size < 4 then
      begin
        Size := 0;
        FCount := 0;
      end
      else
      begin
        Seek(0, soFromBeginning);
        Read(LIntRecSize, sizeof(integer));
        if LIntRecSize < sizeof(TMPHUndoRec) then
        begin
          Size := 0;
          FCount := 0;
        end
        else
        begin
          Move(PChar(Memory)[LIntRecSize], Memory^, Size - LIntRecSize);
          Size := Size - LIntRecSize;
          Dec(FCount);
        end;
      end;
    end;
  end;

  procedure WriteUndoRecord(Length: integer = 0);
  var
    LRecSelection: TUndoSelRec;
  begin
    if ufFlagHasSelection in LPurUndoRec^.Flags then
      LPurUndoRec^.DataLen := sizeof(LRecSelection) + SizeOf(TMPHUndoRec) + Length + 4
    else
      LPurUndoRec^.DataLen := SizeOf(TMPHUndoRec) + Length + 4;

    Write(LPurUndoRec^, SizeOf(TMPHUndoRec) + Length);
    if ufFlagHasSelection in LPurUndoRec^.Flags then
    begin
      with LRecSelection do
      begin
        SelStart := FEditor.FSelStart;
        SelEnd := FEditor.FSelEnd;
        SelPos := FEditor.FSelPosition;
      end;
      Write(LRecSelection, sizeof(LRecSelection));
      Length := Length + sizeof(LRecSelection);
    end;
    Length := SizeOf(TMPHUndoRec) + 4 + Length;
    Write(Length, 4);
  end;
var
  LPtrBytes: PByteArray;
  LSStDesc: shortstring;
begin
  if FUpdateCount < 1 then
  begin
    ResetRedo;

    if sDescription <> '' then
      FDescription := sDescription
    else
      FDescription := STRS_UNDODESC[aKind];

    while (FEditor.FMaxUndo > 0) and (FCount > 0) and (Size > FEditor.FMaxUndo) do
      DeleteOldestUndoRec;

    Position := Size;

    Inc(FCount);

    case aKind of
      ufKindByteChanged:
        begin
          GetMem(LPurUndoRec, SizeOf(TMPHUndoRec));
          try
            FillBuffer(LPurUndoRec^);
            LPurUndoRec.Buffer := byte(FEditor.GetMemory(aPosition));
            if FEditor.HasChanged(aPosition) then
              Include(LPurUndoRec.Flags, ufFlagByteChanged);
            WriteUndoRecord;
          finally
            FreeMem(LPurUndoRec);
          end;
        end;
      ufKindByteRemoved:
        begin
          GetMem(LPurUndoRec, SizeOf(TMPHUndoRec) + aCount - 1);
          try
            FillBuffer(LPurUndoRec^);
            LPtrBytes := @LPurUndoRec.Buffer;
            FEditor.GetMemAtPos(LPtrBytes, aPosition, aCount);
            FEditor.AdjustBookmarks(aPosition + aCount, - aCount);
            WriteUndoRecord(aCount - 1);
          finally
            FreeMem(LPurUndoRec);
            FEditor.FDataSize := -1;
          end;
        end;
      ufKindInsertBuffer:
        begin
          GetMem(LPurUndoRec, SizeOf(TMPHUndoRec));
          try
            FillBuffer(LPurUndoRec^);
            FEditor.AdjustBookmarks(aPosition, aCount);
            WriteUndoRecord;
          finally
            FreeMem(LPurUndoRec);
            FEditor.FDataSize := -1;
          end;
        end;
      ufKindReplaceSelection:
        begin
          GetMem(LPurUndoRec, SizeOf(TMPHUndoRec) + aReplaceCount - 1);
          try
            FillBuffer(LPurUndoRec^);
            LPtrBytes := @LPurUndoRec.Buffer;
            FEditor.GetMemAtPos(LPtrBytes, aPosition, aReplaceCount);
            FEditor.AdjustBookmarks(aPosition + aCount, aCount - aReplaceCount);
            WriteUndoRecord(aReplaceCount - 1);
          finally
            FreeMem(LPurUndoRec);
            FEditor.FDataSize := -1;
          end;
        end;
      ufKindAppendBuffer:
        begin
          GetMem(LPurUndoRec, SizeOf(TMPHUndoRec));
          try
            FillBuffer(LPurUndoRec^);
            WriteUndoRecord;
          finally
            FreeMem(LPurUndoRec);
            FEditor.FDataSize := -1;
          end;
        end;
      ufKindNibbleInsert:
        begin
          GetMem(LPurUndoRec, SizeOf(TMPHUndoRec));
          try
            FillBuffer(LPurUndoRec^);
            LPurUndoRec.Buffer := byte(FEditor.GetMemory(aPosition));
            if FEditor.HasChanged(aPosition) then
              Include(LPurUndoRec.Flags, ufFlagByteChanged);
            WriteUndoRecord;
          finally
            FreeMem(LPurUndoRec);
          end;
        end;
      ufKindNibbleDelete:
        begin
          GetMem(LPurUndoRec, SizeOf(TMPHUndoRec));
          try
            FillBuffer(LPurUndoRec^);
            LPurUndoRec.Buffer := byte(FEditor.GetMemory(aPosition));
            if FEditor.HasChanged(aPosition) then
              Include(LPurUndoRec.Flags, ufFlagByteChanged);
            WriteUndoRecord;
          finally
            FreeMem(LPurUndoRec);
          end;
        end;
      ufKindConvert:
        begin
          GetMem(LPurUndoRec, SizeOf(TMPHUndoRec) + aCount - 1);
          try
            FillBuffer(LPurUndoRec^);
            LPtrBytes := @LPurUndoRec.Buffer;
            FEditor.GetMemAtPos(LPtrBytes, aPosition, aCount);
            WriteUndoRecord(aCount - 1);
          finally
            FreeMem(LPurUndoRec);
            FEditor.FDataSize := -1;
          end;
        end;
      ufKindCombined:
        begin
          LSStDesc := sDescription;
          GetMem(LPurUndoRec, SizeOf(TMPHUndoRec) + Length(LSStDesc));
          try
            FillBuffer(LPurUndoRec^);
            LPurUndoRec.Buffer := aCount;
            if FEditor.HasChanged(aPosition) then
              Include(LPurUndoRec.Flags, ufFlagByteChanged);
            Move(LSStDesc[0], LPurUndoRec^.Buffer, Length(LSStDesc) + 1);
            WriteUndoRecord(Length(LSStDesc));
          finally
            FreeMem(LPurUndoRec);
          end;
        end;
    end;
  end
end;

function TMPHUndoStorage.EndUpdate: integer;
begin
  Dec(FUpdateCount);
  if FUpdateCount < 0 then
    FUpdateCount := 0;
  Result := FUpdateCount;
end;

function TMPHUndoStorage.Undo: boolean;

  procedure PopulateUndo(const aBuffer: TMPHUndoRec);
  var
    LRecSel: TUndoSelRec;
  begin
    with FEditor.GetCursorAtPos(aBuffer.CurPos, ufFlagInCharField in aBuffer.Flags) do
    begin
      if not (ufFlagInCharField in aBuffer.Flags) then
        if FEditor.DataSize > 0 then
          if ufFlag2ndByteCol in aBuffer.Flags then
            x := x + 1;

      FEditor.MoveColRow(x, y, True, True);
    end;
    FEditor.FModified := ufFlagModified in aBuffer.Flags;
    FEditor.InsertMode := (ufFlagInsertMode in aBuffer.Flags);
    if ufFlagHasSelection in aBuffer.Flags then
    begin
      Position := Size - 4 - sizeof(LRecSel);
      Read(LRecSel, sizeof(LRecSel));
      with LRecSel do
        FEditor.SetSelection(SelPos, SelStart, SelEnd);
    end;
    FEditor.Translation := aBuffer.Translation;
    FEditor.Changed;
  end;

  function ReadUndoRecord(var aUR: TMPHUndoRec): TMPHUndoFlag;
  var
    LIntRecOffs: integer;
  begin
    Position := Size - 4;
    Read(LIntRecOffs, 4);
    Seek(-LIntRecOffs, soFromCurrent);
    Read(aUR, SizeOf(TMPHUndoRec));
    Result := GetUndoKind(aUr.Flags);
  end;

  procedure ReleaseLastUndoRecord;
  var
    LRecUndo: TMPHUndoRec;
    LSStDesc: shortstring;
    LIntRecOffs: integer;
  begin
    FEditor.FDataSize := -1;
    if Size < sizeof(TMPHUndoRec) then
      Reset(False)
    else
    begin
      Position := Size - 4;
      Read(LIntRecOffs, 4);
      // restore record in case of a redo
      Seek(-LIntRecOffs, soFromCurrent);
      ReAllocMem(FLastUndo, LIntRecOffs);
      Read(FLastUndo^, LIntRecOffs);
      FLastUndoSize := LIntRecOffs;
      FLastUndoDesc := FDescription;

      // delete last undo record
      SetSize(Max(0, Size - LIntRecOffs));
      Dec(FCount);
      if Size < sizeof(TMPHUndoRec) then
      begin
        Reset(False);
      end
      else
      begin
        if ReadUndoRecord(LRecUndo) <> ufKindCombined then
          FDescription := STRS_UNDODESC[GetUndoKind(LRecUndo.Flags)]
        else
        begin
          if LRecUndo.Buffer = 0 then
            LSStDesc := ''
          else
          begin
            Read(LSStDesc[1], LRecUndo.Buffer);
            LSStDesc[0] := char(LRecUndo.Buffer);
          end;
          if LSStDesc = '' then
            FDescription := STRS_UNDODESC[GetUndoKind(LRecUndo.Flags)]
          else
            FDescription := LSStDesc;
        end;
      end;
    end;
  end;
var
  LEnumUndo: TMPHUndoFlag;
  LRecUndo: TMPHUndoRec;
  LIntLoop: integer;
begin
  Result := False;
  if not CanUndo then
  begin
    Reset(False);
    Exit;
  end;

  if Size >= sizeof(TMPHUndoRec) then
  begin
    // letzten eintrag lesen
    LEnumUndo := ReadUndoRecord(LRecUndo);
    // redo erstellen
    CreateRedo(LRecUndo);
    case LEnumUndo of
      ufKindByteChanged:
        begin
          FEditor.SetMemory(LRecUndo.Pos, char(LRecUndo.Buffer));
          FEditor.SetChanged(LRecUndo.Pos, ufFlagByteChanged in LRecUndo.Flags);
          PopulateUndo(LRecUndo);
          FEditor.RedrawPos(LRecUndo.Pos, LRecUndo.Pos);
          ReleaseLastUndoRecord;
        end;
      ufKindByteRemoved:
        begin
          FEditor.FDataSize := -1;
          FEditor.InternalInsertBuffer(Pointer(integer(Memory) +
            Position - 1), LRecUndo.Count, LRecUndo.Pos);
          PopulateUndo(LRecUndo);
          FEditor.AdjustBookmarks(LRecUndo.Pos - LRecUndo.Count, LRecUndo.Count);
          if DWORD(FEditor.FModifiedBytes.Size) >= (LRecUndo.Pos) then
            FEditor.FModifiedBytes.Size := LRecUndo.Pos;
          FEditor.Invalidate;
          ReleaseLastUndoRecord;
        end;
      ufKindInsertBuffer:
        begin
          FEditor.FDataSize := -1;
          FEditor.InternalDelete(LRecUndo.Pos, LRecUndo.Pos + LRecUndo.Count, - 1, 0);
          PopulateUndo(LRecUndo);
          FEditor.AdjustBookmarks(LRecUndo.Pos, - LRecUndo.Count);
          if DWORD(FEditor.FModifiedBytes.Size) >= (LRecUndo.Pos) then
            FEditor.FModifiedBytes.Size := LRecUndo.Pos;
          FEditor.Invalidate;
          ReleaseLastUndoRecord;
        end;
      ufKindReplaceSelection:
        begin
          FEditor.FDataSize := -1;
          FEditor.InternalDelete(LRecUndo.Pos, LRecUndo.Pos + LRecUndo.Count, - 1, 0);
          FEditor.InternalInsertBuffer(Pointer(integer(Memory) +
            Position - 1), LRecUndo.ReplCount, LRecUndo.Pos);
          PopulateUndo(LRecUndo);
          FEditor.AdjustBookmarks(LRecUndo.Pos + LRecUndo.ReplCount,
            LRecUndo.ReplCount - LRecUndo.Count);
          if DWORD(FEditor.FModifiedBytes.Size) >= (LRecUndo.Pos) then
            FEditor.FModifiedBytes.Size := Max(0, LRecUndo.Pos - 1);
          FEditor.Invalidate;
          ReleaseLastUndoRecord;
        end;
      ufKindAppendBuffer:
        begin
          FEditor.FDataSize := -1;
          FEditor.Col := GRID_FIXED;
          FEditor.FDataStorage.Size := LRecUndo.Pos;
          FEditor.CalcSizes;
          if DWORD(FEditor.FModifiedBytes.Size) >= (LRecUndo.Pos) then
            FEditor.FModifiedBytes.Size := LRecUndo.Pos;
          PopulateUndo(LRecUndo);
          FEditor.Invalidate;
          ReleaseLastUndoRecord;
        end;
      ufKindNibbleInsert:
        begin
          FEditor.FDataSize := -1;
          FEditor.InternalDeleteNibble(LRecUndo.Pos, False);
          FEditor.SetMemory(LRecUndo.Pos, char(LRecUndo.Buffer));
          FEditor.SetChanged(LRecUndo.Pos, ufFlagByteChanged in LRecUndo.Flags);
          PopulateUndo(LRecUndo);
          if DWORD(FEditor.FModifiedBytes.Size) >= (LRecUndo.Pos) then
            FEditor.FModifiedBytes.Size := LRecUndo.Pos;
          FEditor.FDataStorage.Size := FEditor.FDataStorage.Size - 1;
          FEditor.CalcSizes;
          FEditor.Invalidate;
          ReleaseLastUndoRecord;
        end;
      ufKindNibbleDelete:
        begin
          FEditor.FDataSize := -1;
          FEditor.InternalInsertNibble(LRecUndo.Pos, False);
          FEditor.SetMemory(LRecUndo.Pos, char(LRecUndo.Buffer));
          FEditor.SetChanged(LRecUndo.Pos, ufFlagByteChanged in LRecUndo.Flags);
          PopulateUndo(LRecUndo);
          if DWORD(FEditor.FModifiedBytes.Size) >= (LRecUndo.Pos) then
            FEditor.FModifiedBytes.Size := LRecUndo.Pos;
          FEditor.FDataStorage.Size := FEditor.FDataStorage.Size - 1;
          FEditor.CalcSizes;
          FEditor.Invalidate;
          ReleaseLastUndoRecord;
        end;
      ufKindConvert:
        begin
          FEditor.FDataSize := -1;
          FEditor.SetMemAtPos(Pointer(integer(Memory) + Position - 1),
            LRecUndo.Pos, LRecUndo.Count);
          PopulateUndo(LRecUndo);
          if DWORD(FEditor.FModifiedBytes.Size) >= (LRecUndo.Pos) then
            FEditor.FModifiedBytes.Size := LRecUndo.Pos;
          FEditor.Invalidate;
          ReleaseLastUndoRecord;
        end;
      ufKindCombined:
        begin
          LIntLoop := LRecUndo.Count;
          ReleaseLastUndoRecord;
          for LIntLoop := 1 to LIntLoop do
            Undo;
          ResetRedo;
        end;
    end;
  end
  else
    Reset;
end;

procedure TMPHUndoStorage.SetSize(NewSize: integer);
begin
  inherited;
  if NewSize < sizeof(TMPHUndoRec) then
    FCount := 0;
end;

procedure TMPHUndoStorage.Reset(AResetRedo: boolean = True);
begin
  Size := 0;
  FCount := 0;
  FUpdateCount := 0;
  FDescription := '';
  if AResetRedo then
    ResetRedo;
end;

procedure TMPHUndoStorage.SetCount(const Value: integer);
begin
  FCount := Value;
  if FCount < 1 then
    Reset(False);
end;

function TMPHUndoStorage.CanRedo: boolean;
begin
  Result := Assigned(FRedoPointer);
end;

function TMPHUndoStorage.Redo: boolean;

  procedure SetEditorStateFromRedoRec;
  begin
    with FRedoPointer^ do
    begin
      Move(PChar(FRedoPointer)[FRedoPointer^.DataLen], FEditor.FBookmarks,
        sizeof(TMPHBookmarks));

      with FEditor.GetCursorAtPos(CurPos, ufFlagInCharField in Flags) do
      begin
        if not (ufFlagInCharField in Flags) then
          if FEditor.DataSize > 0 then
            if ufFlag2ndByteCol in Flags then
              x := x + 1;

        FEditor.MoveColRow(x, y, True, True);
      end;
      FEditor.FModified := ufFlagModified in Flags;
      FEditor.InsertMode := (ufFlagInsertMode in Flags);

      with PUndoSelRec(@(PChar(FRedoPointer)[FRedoPointer^.DataLen + sizeof(TMPHBookmarks)]))^ do
        FEditor.SetSelection(SelPos, SelStart, SelEnd);

      FEditor.Translation := Translation;

      FEditor.InCharField := ufFlagInCharField in Flags;

      FEditor.SetChanged(Pos, ufFlagByteChanged in Flags);

      // restore last undo record
      if Assigned(FLastUndo) then
      begin
        Seek(0, soFromEnd);
        Write(FLastUndo^, FLastUndoSize);
        Inc(FCount);
        FreeMem(FLastUndo);
        FLastUndo := nil;
        FLastUndoSize := 0;
      end;
      FDescription := FLastUndoDesc;

      FEditor.Invalidate;
    end;
  end;
begin
  Result := CanRedo;
  if Result then
  begin
    case GetUndoKind(FRedoPointer^.Flags) of
      ufKindByteChanged:
        begin
          FEditor.SetMemory(FRedoPointer^.Pos, char(FRedoPointer^.Buffer));
          SetEditorStateFromRedoRec;
        end;
      ufKindByteRemoved:
        begin
          FEditor.InternalDelete(FRedoPointer^.Pos,
            FRedoPointer^.Pos + FRedoPointer^.Count, - 1, 0);
          SetEditorStateFromRedoRec;
        end;
      ufKindInsertBuffer:
        begin
          FEditor.InternalInsertBuffer(PChar(@(FRedoPointer^.Buffer)),
            FRedoPointer^.Count, FRedoPointer^.Pos);
          SetEditorStateFromRedoRec;
        end;
      ufKindReplaceSelection:
        begin
          FEditor.InternalDelete(FRedoPointer^.Pos,
            FRedoPointer^.Pos + FRedoPointer^.ReplCount, - 1, 0);
          FEditor.InternalInsertBuffer(PChar(@(FRedoPointer^.Buffer)),
            FRedoPointer^.Count, FRedoPointer^.Pos);
          SetEditorStateFromRedoRec;
        end;
      ufKindConvert:
        begin
          FEditor.InternalDelete(FRedoPointer^.Pos,
            FRedoPointer^.Pos + FRedoPointer^.Count, - 1, 0);
          FEditor.InternalInsertBuffer(PChar(@(FRedoPointer^.Buffer)),
            FRedoPointer^.Count, FRedoPointer^.Pos);
          SetEditorStateFromRedoRec;
        end;
      ufKindAppendBuffer:
        begin
          FEditor.InternalAppendBuffer(PChar(@(FRedoPointer^.Buffer)), FRedoPointer^.Count);
          SetEditorStateFromRedoRec;
        end;
      ufKindNibbleInsert,
      ufKindNibbleDelete:
        begin
          FEditor.FDataStorage.Size := FRedoPointer^.Count;
          Move(FRedoPointer^.Buffer, FEditor.FDataStorage.Memory^, FRedoPointer^.Count);
          FEditor.CalcSizes;
          SetEditorStateFromRedoRec;
        end;
    end;
    ResetRedo;
    FEditor.Changed;
  end;
end;

procedure TMPHUndoStorage.ResetRedo;
begin
  if Assigned(FRedoPointer) then
    FreeMem(FRedoPointer);
  FRedoPointer := nil;
  if Assigned(FLastUndo) then
    FreeMem(FLastUndo);
  FLastUndo := nil;
  FLastUndoSize := 0;
  FLastUndoDesc := '';
end;

procedure TMPHUndoStorage.CreateRedo(const Rec: TMPHUndoRec);
var
  LIntDataSize: integer;

  procedure AllocRedoPointer;
  begin
    GetMem(FRedoPointer, sizeof(TMPHUndoRec) + sizeof(TMPHBookMarks) +
      sizeof(TUndoSelRec) + LIntDataSize);
    FRedoPointer^.Flags := [GetUndoKind(Rec.Flags)];
    FRedoPointer^.DataLen := sizeof(TMPHUndoRec) + LIntDataSize;
  end;

  procedure FinishRedoPointer;
  begin
    with FRedoPointer^ do
    begin
      CurPos := FEditor.GetPosAtCursor(FEditor.Col, FEditor.Row);
      if not FEditor.FPosInCharField then
        with FEditor.GetCursorAtPos(CurPos, FEditor.FPosInCharField) do
          if (FEditor.Col - x) <> 0 then
            Include(Flags, ufFlag2ndByteCol);
      if FEditor.FPosInCharField then
        Include(Flags, ufFlagInCharField);
      if FEditor.FInsertModeOn then
        Include(Flags, ufFlagInsertMode);
      Pos := Rec.pos;
      Count := Rec.Count;
      ReplCount := Rec.ReplCount;
      Translation := FEditor.FTranslation;
      if FEditor.FModified then
        Include(Flags, ufFlagModified);
    end;
    Move(FEditor.FBookmarks, PChar(FRedoPointer)[FRedoPointer^.DataLen],
      sizeof(TMPHBookmarks));
    with PUndoSelRec(@(PChar(FRedoPointer)[FRedoPointer^.DataLen + sizeof(TMPHBookmarks)]))^ do
    begin
      SelStart := FEditor.FSelStart;
      SelPos := FEditor.FSelPosition;
      SelEnd := FEditor.FSelEnd;
    end;
  end;
begin
  ResetRedo;
  // simple redo, store bookmarks, selection, insertmode, col, row, charfield...
  // and bytes to save

  case GetUndoKind(Rec.Flags) of
    ufKindByteChanged:
      begin
        LIntDataSize := 0;
        AllocRedoPointer;
        if FEditor.HasChanged(Rec.Pos) then
          Include(FRedoPointer^.Flags, ufFlagByteChanged);
        FEditor.GetMemAtPos(@(FRedoPointer^.Buffer), Rec.Pos, 1);
        FinishRedoPointer;
      end;
    ufKindByteRemoved:
      begin
        LIntDataSize := 0;
        AllocRedoPointer;
        FinishRedoPointer;
      end;
    ufKindInsertBuffer,
    ufKindReplaceSelection,
    ufKindConvert:
      begin
        LIntDataSize := Rec.Count;
        AllocRedoPointer;
        FEditor.GetMemAtPos(@(FRedoPointer^.Buffer), Rec.Pos, Rec.Count);
        FinishRedoPointer;
      end;
    ufKindAppendBuffer:
      begin
        LIntDataSize := FEditor.DataSize - integer(Rec.Pos);
        AllocRedoPointer;
        FEditor.GetMemAtPos(@(FRedoPointer^.Buffer), Rec.Pos,
          FEditor.DataSize - integer(Rec.Pos));
        FinishRedoPointer;
      end;
    ufKindNibbleInsert,
    ufKindNibbleDelete:
      begin
        LIntDataSize := FEditor.DataSize;
        AllocRedoPointer;
        FEditor.GetMemAtPos(@(FRedoPointer^.Buffer), 0, FEditor.DataSize);
        FinishRedoPointer;
        FRedoPointer^.Count := LIntDataSize;
      end;
  end;
  //FEditor.Changed;
end;

function TMPHUndoStorage.GetUndoKind(const Flags: TMPHUndoFlags): TMPHUndoFlag;
begin
  for Result := ufKindByteChanged to ufKindCombined do
    if Result in Flags then
      Break;
end;

// initialize tkCustom translation tables
procedure InitializeCustomTables;
var
  LBytLoop: byte;
begin
  for LBytLoop := 0 to 255 do
  begin
    MPHCustTransFieldTo[LBytLoop] := char(LBytLoop);
    MPHCustTransFieldFrom[LBytLoop] := char(LBytLoop);
  end;
end;

initialization
  // initialize custom tables
  InitializeCustomTables;
end.
