unit SwitchModules;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  menus, comctrls, buttons, ActnList ;

type
  TModuleSwitcher = class ;
  TModuleCollection = class ;

  TMSSearchMode = (smByClassname,smByFormcaption) ;

  TOnValues = procedure (Sender : TObject ; Values : TStringList) of object ;
  TOnCommand = procedure (Sender : TObject ; AValues : TStringList) of object ;

  TModuleItem = class (TCollectionItem)
  private
    FCaption: string;
    FHint: string;
    FClassName: string;
    FFileName: string;
    FMenuItem: TMenuItem;
    FSpeedButton: TSpeedButton;
    FActionList: TActionList ;
    FAction: TAction;
    FImageList : TImageList ;
    FShowCaption: boolean;
    FimgIndexSpeedButton : integer ;
    FimgIndexMenuItem : integer ;
    FIcon: TIcon;
    FPID : dword ;
    FHandle : THandle ;
    FFormCaption: string;
    FSearchMode: TMSSearchMode;
    FCommand: string;
    FValues: TStringList;
    FOnValues: TOnValues;
    FCollection: TModuleCollection ;
    FOnCommand: TOnCommand;
    FFreeOnClose: boolean;
    FMultipleInstances: boolean;
    procedure ExtractIcon;
    procedure SetCommand(const Value: string);
    procedure SetValues(const Value: TStringList);
    procedure SetOnValues(const Value: TOnValues);
    function GetCommandText: string;
    procedure SetOnCommand(const Value: TOnCommand);
  protected
    procedure DefineProperties (Filer : TFiler) ; override ;
    function GetDisplayName : string ; override ;
  public
    constructor Create (Collection : TCollection) ; override ;
    destructor Destroy ; override ;
    property CommandText : string read GetCommandText ;
    procedure Add ;
    procedure Execute(Sender: TObject);
  procedure Assign (Source : TPersistent) ; override ;
  published
    { Hier werden deine eigene Collection Properties definiert }
    property FileName : string  read FFileName write FFileName;
    property ClassName : string  read FClassName write FClassName;
    property FormCaption : string read FFormCaption write FFormCaption ;
    property Caption : string  read FCaption write FCaption;
    property Hint : string  read FHint write FHint;
    property SpeedButton : TSpeedButton  read FSpeedButton write FSpeedButton;
    property ShowCaption : boolean  read FShowCaption write FShowCaption ;
    property MenuItem : TMenuItem  read FMenuItem write FMenuItem;
    property ImageList : TImageList read FImageList write FImageList ;
    property SearchMode : TMSSearchMode read FSearchMode write FSearchMode ;
    property Command : string  read FCommand write SetCommand;
    property Values : TStringList  read FValues write SetValues;
    property FreeOnClose : boolean read FFreeOnClose write FFreeOnClose ;
    property MultipleInstances : boolean read FMultipleInstances write FMultipleInstances ;

    property OnValues : TOnValues  read FOnValues write SetOnValues;
  end ;

  TModuleCollection = class (TCollection)
  private
    FOwner : TModuleSwitcher ; { Benutze hier den Typ deiner Komponente }
    function GetItem(Index: integer): TModuleItem;
    procedure SetItem(Index: integer; const Value: TModuleItem);
    procedure SetOwner(const Value: TModuleSwitcher);
  protected
    function GetOwner : TPersistent ; override ;
    procedure Update (Item : TCollectionItem) ; override ;
  public
    constructor Create (AOwner : TModuleSwitcher) ;
    function Add : TModuleItem ;
    property ModuleSwitcher : TModuleSwitcher read FOwner ;
    property Owner : TModuleSwitcher  read FOwner write SetOwner;
    property Items[Index : integer]: TModuleItem read GetItem write SetItem ; default ;
  end ;

  TModuleSwitcher = class(TComponent)
  private
    { Private-Deklarationen }
    FLoaded: boolean;
    FMessagename: string;
    FItems: TModuleCollection;
    procedure Click (Sender : TObject) ;
    procedure SetMessagename(const Value: string);
    procedure SetItems(const Value: TModuleCollection);
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    constructor Create (Aowner : TComponent) ; override ;
    destructor Destroy ; override ;
    procedure Run ;
  published
    { Published-Deklarationen }
    property Items : TModuleCollection  read FItems write SetItems;
    property Messagename : string  read FMessagename write SetMessagename;
  end;




  TCommandReceiver = class ; { Den Typen deiner Komponente muss als }
  { forward deklariert sein, da er selbst }
  { in der TCommandCollection }
  { benutzt wird }

TCommandItem = class (TCollectionItem)
  private
    FCommand: string;
    FOnCommand: TOnCommand;
    procedure SetCommand(const Value: string);
    procedure SetOnCommand(const Value: TOnCommand);
  protected
    procedure DefineProperties (Filer : TFiler) ; override ;
    function GetDisplayName : string ; override ;
  public
    constructor Create (Collection : TCollection) ; override ;
    destructor Destroy ; override ;
  procedure Assign (Source : TPersistent) ; override ;
  published
  { Hier werden deine eigene Collection Properties definiert }
  { Als Bsp. ist lediglich Prop definiert worden }
    property Command : string  read FCommand write SetCommand;
    property OnCommand : TOnCommand  read FOnCommand write SetOnCommand;
  end ;


  TCommandCollection = class (TCollection)
  private
    FOwner : TCommandReceiver ; { Benutze hier den Typ deiner Komponente }
    function GetItem(Index: integer): TCommandItem;
    procedure SetItem(Index: integer; const Value: TCommandItem);
  protected
    function GetOwner : TPersistent ; override ;
    procedure Update (Item : TCollectionItem) ; override ;
  public
    constructor Create (AOwner : TCommandReceiver) ;
    function Add : TCommandItem ;
    property YourComponent : TCommandReceiver read FOwner ;
    property Items[Index : integer]: TCommandItem read GetItem write
           SetItem ; default ;
  end ;

  TCommandReceiver = class (TComponent)
  private
    FItems: TCommandCollection;
    FMessageName: string;
    procedure SetItems(const Value: TCommandCollection);
    procedure ForwardText(Text: string);
    procedure SetMessageName(const Value: string);
  public
    constructor Create (AOwner : TComponent) ; override ;
    procedure ForwardMessage (var Msg: TWMCopyData) ; overload ;
    procedure ForwardMessage (Paramstr : string) ; overload ;
    procedure Run ;
    procedure ShowStringList (AList : TStrings) ;
  published
    property Items : TCommandCollection read FItems write SetItems;
    property Messagename : string  read FMessageName write SetMessageName;
  end ;

function ForceForegroundWindow(hwnd: THandle; Delay : Integer): Boolean;

procedure Register;

implementation
uses shellApi, extctrls, tlhelp32 ;

function ForceForegroundWindow(hwnd: THandle; Delay : Integer): Boolean;
const
  SPI_GETFOREGROUNDLOCKTIMEOUT = $2000;
  SPI_SETFOREGROUNDLOCKTIMEOUT = $2001; 
var 
  ForegroundThreadID: DWORD; 
  ThisThreadID: DWORD; 
  timeout: DWORD; 
begin
  if delay <> 0 then
    sleep(delay);

  if IsIconic(hwnd) then ShowWindow(hwnd, SW_RESTORE);

  if GetForegroundWindow = hwnd then Result := True 
  else  
  begin
    if ((Win32Platform = VER_PLATFORM_WIN32_NT) and (Win32MajorVersion > 4)) or
      ((Win32Platform = VER_PLATFORM_WIN32_WINDOWS) and 
      ((Win32MajorVersion > 4) or ((Win32MajorVersion = 4) and 
      (Win32MinorVersion > 0)))) then 
    begin 
      Result       := False; 
      ForegroundThreadID := GetWindowThreadProcessID(GetForegroundWindow, nil);
      ThisThreadID := GetWindowThreadPRocessId(hwnd, nil); 
      if AttachThreadInput(ThisThreadID, ForegroundThreadID, True) then 
      begin 
        BringWindowToTop(hwnd);
        SetForegroundWindow(hwnd); 
        AttachThreadInput(ThisThreadID, ForegroundThreadID, False); 
        Result := (GetForegroundWindow = hwnd); 
      end; 
      if not Result then  
      begin 
        SystemParametersInfo(SPI_GETFOREGROUNDLOCKTIMEOUT, 0, @timeout, 0); 
        SystemParametersInfo(SPI_SETFOREGROUNDLOCKTIMEOUT, 0, TObject(0), 
          SPIF_SENDCHANGE); 
        BringWindowToTop(hwnd); 
        SetForegroundWindow(hWnd); 
        SystemParametersInfo(SPI_SETFOREGROUNDLOCKTIMEOUT, 0, 
          TObject(timeout), SPIF_SENDCHANGE); 
      end; 
    end 
    else  
    begin 
      BringWindowToTop(hwnd);
      SetForegroundWindow(hwnd); 
    end;
    Result := (GetForegroundWindow = hwnd); 
  end; 
end;

procedure Register;
begin
  RegisterComponents('Tom', [TModuleSwitcher]);
  RegisterComponents('Tom', [TCommandReceiver]);
end;


procedure TModuleSwitcher.Click(Sender: TObject);
begin
end;

constructor TModuleSwitcher.Create(Aowner: TComponent);
begin
     inherited Create (AOwner) ;
     FLoaded := false ;
     FItems := TModuleCollection.create (Self) ;
     MessageName := 'MODULE' ;
end;


procedure TModuleSwitcher.Run;
var
 i : integer ;
begin
     if not (FLoaded) then  begin
        for i := Items.count-1 downto 0 do
          Items[i].Add ;
        FLoaded := true ;
     end ;
end;



{ TModuleItem }

procedure TModuleItem.ExtractIcon ;
var
  FileInfo: TSHFileInfo;
  ImageListHandle: THandle;
  image1 : TImage ;
  imgSmall : TImage ;
  i : integer ;
  NewWidth, NewHeight : integer ;
  ch : char ;
  CN : string ;
begin
  // Speicher lschen
  FillChar(FileInfo, SizeOf(FileInfo), #0);
  // Handle der Image Liste der ausgewhlten Datei ermitteln
  ImageListHandle := SHGetFileInfo(
    PChar(FileName), 0, FileInfo, SizeOf(FileInfo),
    // groes Icon verlangen
    SHGFI_ICON or SHGFI_LARGEICON
  );
  try
    // TIcon Objekt erstellen
    //FIcon := TIcon.Create;
    try
      // Icon Handle zuweisen
      FIcon.Handle := FileInfo.hIcon;
      // Transparent darstellen
      FIcon.Transparent := True;
      image1 := TImage.create (nil) ;
      with Image1 do begin
         // Paintbox auf die entsprechende Gre bringen
         Width := FIcon.Width;
         Height := FIcon.Height;
         Application.ProcessMessages;
         // Paintbox lschen
         Canvas.Rectangle(-1, -1, Succ(Width), Succ(Height));
         // Icon darstellen
         Canvas.Draw(0, 0, FIcon);
      end;
    finally
      // TIcon Objekt freigeben
      //FIcon.free ;
      image1.free ;
    end;
  finally
    // Icon der Shell wieder freigeben
    //DestroyIcon(FileInfo.hIcon);
    // Icon Liste der Shell wieder freigeben
    {ImageList_Destroy(ImageListHandle);}
  end;
end;

procedure TModuleItem.Execute (Sender : TObject) ;
var
  StartupInfo : TStartupInfo;
  ProcessInfo : TProcessInformation;
  EC : longword ;
  aCopyData: TCopyDataStruct;
  p: PChar;
  StartName : string ;
begin
     if assigned (OnValues) then OnValues (Self,FValues) ;

     if MultipleInstances then FHandle := 0
     else begin
             if SearchMode = smByClassname
             then FHandle := FindWindow (PChar(ClassName),nil)
             else FHandle := FindWindow (nil,PChar(FormCaption)) ;
          end ;

     if FHandle = 0 then begin
        FillChar(StartupInfo, SizeOf(StartupInfo), #0);
        StartupInfo.cb          := SizeOf(StartupInfo);
        StartupInfo.dwFlags     := STARTF_USESHOWWINDOW or STARTF_FORCEONFEEDBACK;
        StartupInfo.wShowWindow := SW_SHOWNORMAL ;
        if Command <> ''
        then StartName := format ('%s "%s"',[FFilename,CommandText])
        else StartName := FFilename ;
        if CreateProcess(nil,@StartName[1],nil,nil,false,CREATE_NEW_CONSOLE or NORMAL_PRIORITY_CLASS,nil,nil,StartupInfo,ProcessInfo) then begin
            FPID := Processinfo.dwProcessID ;
        end else begin
            Showmessage ('konnte Programm nicht starten') ;
        end ;
     end else begin
        if Command <> '' then begin
            p := PChar (CommandText) ;
            with aCopyData do begin
              dwData := 0;
              cbData := StrLen(p) + 1;
              lpData := p;
            end;
            sendMessage(FHandle, WM_COPYDATA, Longint(FHandle),Longint(@aCopyData));
        end ;

        ForceForegroundWindow (FHandle,0) ;
     end ;

end ;

procedure TModuleItem.Add;
var
 TB : TToolButton ;
 bmp : TBitmap ;
begin
     FAction.Caption := Caption ;
     FAction.Hint := Hint ;
     ExtractIcon ;

     if assigned (SpeedButton) then begin
        { zu ImageList hinzufgen und SpeedButton zuordnen }
        if assigned (ImageList) then begin
           FimgIndexSpeedButton := FImageList.AddIcon(FIcon) ;
           FAction.ImageIndex := FimgIndexSpeedButton ;
           bmp := TBitmap.create ;
           FImageList.GetBitmap (FimgIndexSpeedButton,bmp) ;
           SpeedButton.Glyph.Assign (bmp) ;
           bmp.free ;
        end else begin
           FimgIndexSpeedButton := -1 ;
        end ;


        { SpeedButton Properties setzen }
        SpeedButton.Action := nil ;
        SpeedButton.Action := FAction ;
        SpeedButton.Action := nil ;

        if ShowCaption
        then SpeedButton.caption := caption
        else SpeedButton.caption := '' ;
        SpeedButton.Hint := Hint ;
     end ;

     if assigned (MenuItem) then begin
        if assigned (MenuItem.GetParentMenu.Images) then begin
           FimgIndexMenuItem := MenuItem.GetParentMenu.Images.AddIcon (FIcon) ;
        end else begin
           FimgIndexMenuItem := -1 ;
        end ;
        MenuItem.ImageIndex := FimgIndexMenuItem ;
        MenuItem.caption := caption ;
        MenuItem.Hint := Hint ;
        MenuItem.OnClick := Execute ;
     end ;

end;

procedure TModuleItem.Assign(Source: TPersistent);
begin
     inherited Assign (Source) ;
end;

constructor TModuleItem.Create(Collection: TCollection);
begin
     inherited Create (Collection) ;
     FCollection := Collection as TModuleCollection ;
     FActionList := TActionList.Create (nil) ;
     if assigned (FImageList)
     then FActionList.Images := FImageList ;
     FAction := TAction.Create (FActionList)  ;
     FAction.ActionList := FActionList ;
     FAction.OnExecute := Execute ;
     FIcon := TIcon.Create ;
     FPID := 0 ;
     FHandle := 0 ;
     FSearchMode := smByClassname ;
     FValues := TStringList.create ;
     FFreeOnClose := true ;
     FMultipleInstances := false ;
end;

procedure TModuleItem.DefineProperties(Filer: TFiler);
begin
     inherited DefineProperties (Filer) ;
end;

destructor TModuleItem.Destroy;
begin

     inherited Destroy ;
end;

function TModuleItem.GetDisplayName: string;
begin
     if (FCommand = '') and (FCaption = '')
     then GetDisplayName := inherited GetDisplayName
     else GetDisplayName := Format ('%s [%s]',[Command,Caption]) ;
end;



procedure TModuleItem.SetCommand(const Value: string);
begin
  FCommand := uppercase (Value);
end;

procedure TModuleItem.SetValues(const Value: TStringList);
begin
  FValues.assign ( Value ) ;
end;

procedure TModuleItem.SetOnValues(const Value: TOnValues);
begin
  FOnValues := Value;
end;

function TModuleItem.GetCommandText: string;
var
 i : integer ;
begin
     Result := FCommand ;
     i := 0 ;
     if Values.Count <> 0 then begin
        while i <= Values.count-1 do begin
           Result := Result + '|' + values[i] ;
           i := i + 1 ;
        end ;
     end ;
     Result := FCollection.Owner.Messagename + Result ;
end;

procedure TModuleItem.SetOnCommand(const Value: TOnCommand);
begin
  FOnCommand := Value;
end;

{ TModuleCollection }

function TModuleCollection.Add: TModuleItem;
begin
     Result := TModuleItem(inherited Add) ;
end;

constructor TModuleCollection.Create(AOwner: TModuleSwitcher);
begin
     inherited Create (TModuleItem) ;
     FOwner := AOwner ;
end;

function TModuleCollection.GetItem(Index: integer): TModuleItem;
begin
     Result := TModuleItem(inherited GetItem(index)) ;
end;

function TModuleCollection.GetOwner: TPersistent;
begin
     Result := FOwner ;
end;

procedure TModuleCollection.SetItem(Index: integer;
  const Value: TModuleItem);
begin
     inherited SetItem (Index,Value) ;
end;

procedure TModuleCollection.SetOwner(const Value: TModuleSwitcher);
begin
  FOwner := Value;
end;

procedure TModuleCollection.Update(Item: TCollectionItem);
begin
     //
end;


procedure TModuleSwitcher.SetMessagename(const Value: string);
begin
  FMessagename := uppercase (Value) ;

  if FMessagename[length(FMessageName)] <> '='
  then FMessageName := FMessageName + '=' ;
end;


destructor TModuleSwitcher.Destroy;
var
 i : integer ;
begin
     for i := 0 to Items.count-1 do with Items[i] do begin
        if FreeOnClose then begin
            if SearchMode = smByClassname
            then FHandle := FindWindow (PChar(ClassName),nil)
            else FHandle := FindWindow (nil,PChar(FormCaption)) ;
            if (FHandle <> 0) and (FHandle <> FindWindow(nil,PChar (application.MainForm.caption)))
            then SendMessage (FHandle,WM_CLOSE,0,0) ;
        end ;
     end ;
     inherited Destroy ;
end;

procedure TModuleSwitcher.SetItems(const Value: TModuleCollection);
begin
  FItems := Value;
end;






procedure TCommandItem.Assign(Source: TPersistent);
begin
  inherited Assign (Source) ;
end;

constructor TCommandItem.Create(Collection: TCollection);
begin
  inherited Create (Collection) ;
end;

procedure TCommandItem.DefineProperties(Filer: TFiler);
begin
  inherited DefineProperties (Filer) ;
end;

destructor TCommandItem.Destroy;
begin
  inherited Destroy ;
end;

function TCommandItem.GetDisplayName: string;
begin
  if (Command = '')
  then GetDisplayName := inherited GetDisplayName
  else GetDisplayName := Command ;

end;

{ TCommandCollection }

function TCommandCollection.Add: TCommandItem;
begin
  Result := TCommandItem(inherited Add) ;
end;

constructor TCommandCollection.Create(AOwner: TCommandReceiver);
begin
  inherited Create (TCommandItem) ;
  FOwner := AOwner ;
end;

function TCommandCollection.GetItem(Index: integer): TCommandItem;
begin
  Result := TCommandItem(inherited GetItem(index)) ;
end;

function TCommandCollection.GetOwner: TPersistent;
begin
  Result := FOwner ;
end;

procedure TCommandCollection.SetItem(Index: integer;
  const Value: TCommandItem);
begin
  inherited SetItem (Index,Value) ;
end;

procedure TCommandCollection.Update(Item: TCollectionItem);
begin
  //
end;


{ TCommandReceiver }

constructor TCommandReceiver.Create(AOwner: TComponent);
begin
  inherited Create (AOwner) ;
  FItems := TCommandCollection.create (Self) ;
  MessageName := 'MODULE' ;
end;

procedure TCommandReceiver.SetItems(const Value: TCommandCollection);
begin
  FItems := Value;
end;


procedure TCommandReceiver.ForwardMessage(Paramstr: string);
begin
     ForwardText (ParamStr) ;
end;


procedure TCommandReceiver.ForwardMessage(var Msg: TWMCopyData);
var
 Text : string ;
begin
     text := copy (String(Msg.CopyDataStruct.lpdata),1,Msg.CopyDataStruct.cbData-1) ;
     ForwardText (Text) ;
end;


procedure TCommandReceiver.ForwardText (Text : string) ;
var
 i, p : integer ;
 _Values, _Command : string ;
 SL : TStringList ;
begin
     p := pos ('=',Text) ;
     if copy (text,1,p) = MessageName then begin
         text := copy (text,p+1,length(text)) ;
         p := pos ('|',text) ;
         if p <> 0
         then begin
                _Command := copy (text,1,p-1) ;
                _Values := copy (text,p+1,length(Text)) ;
              end
         else begin
                _Command := text ;
                _Values := '' ;
              end ;

         i := 0 ;
         while i <= Items.count-1 do begin
            // showmessage (format ('"%s"' + #10#13 + '"%s"',[Items[i].Command,_Command])) ;
            if Items[i].Command = _Command then begin
                if assigned (Items[i].OnCommand) then begin
                   SL := TStringList.create ;
                   p := pos ('|',_Values) ;
                   while p <> 0 do begin
                      SL.Add (copy (_values,1,p-1)) ;
                      _values := copy (_values,p+1,length(_values)) ;
                      p := pos ('|',_Values) ;
                   end ;
                   SL.Add (_values) ;
                   Items[i].OnCommand (Items[i],SL) ;
                end ;
            end ;
            i := i + 1 ;
         end ;
     end ;
end;

procedure TCommandReceiver.Run;
var
 i : integer ;
begin
       if ParamCount > 0
       then for i := 1 to ParamCount do ForwardText (paramstr(i)) ;
end;

procedure TCommandReceiver.ShowStringList(AList: TStrings);
var
 S : string ;
 i : integer ;
begin
      S := '' ;
      for i :=0 to AList.count-1 do begin
         S := S + Format ('---> %d <---   %s',[i+1,AList[i]]) ;
         if i < AList.count-1
         then S := S + #10#13 ;
      end ;
      MessageDlg (format('%s',[S]),mtInformation,[mbOK],0) ;
end;

procedure TCommandReceiver.SetMessageName(const Value: string);
begin
     FMessagename := uppercase (Value) ;

  if FMessagename[length(FMessageName)] <> '='
  then FMessageName := FMessageName + '=' ;
end;

procedure TCommandItem.SetCommand(const Value: string);
begin
     FCommand := uppercase (Value);
end;

procedure TCommandItem.SetOnCommand(const Value: TOnCommand);
begin
  FOnCommand := Value;
end;

end.

