unit IPathEditorForm;

interface

//*****************************************************************************
//
// Written by Clinton R. Johnson
//
// This program is open source, and maybe used, re-used or modifed as you see
// fit.  The original author assumes no responsibility or liability for any
// damages or loss of profits resulting from the use or misuse of this code.
//
// Beta 1 - Released August 18, 1998
//
// Beta 2 - Released August 24, 1998
//
//  Fixed :
//           - Control alignment causing directories to not be visible if the
//             directory was too full.
//           - Added a XDF link in the enhancement, linking back to
//             http://www.poboxes.com/xepol
//
// Open Source Release 1 - February 26, 2000
//
//  Fixed :
//           - Bug in the editor causing the DELETE button to become
//             unavailable.
//           - Exception when a directory is selected from the creation list
//             that does not exist.
//           - Added "Remove Invalid paths" option.
//
// Delphi 6 update by Rick Hollerich - November 6, 2001
//        email: rholleri@prairie.lakes.com
//
//  Fixed :
//           - Added support for Delphi 6
//
//*****************************************************************************

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, CheckLst, ExtCtrls,Registry, Buttons, FileCtrl, ComCtrls,ShellAPI;

const
{$IFDEF VER140}
  {$DEFINE VER130_UP}
  DELPHI_3_ROOT                = '\Software\Borland\Delphi\6.0';
    DELPHI_3_SECTION                 = '6.0';
{$ENDIF}
{$IFDEF VER130}
  {$DEFINE VER130_UP}
  DELPHI_3_ROOT                = '\Software\Borland\Delphi\5.0';
    DELPHI_3_SECTION             = '5.0';
{$ENDIF}
{$IFDEF VER120}
  DELPHI_3_ROOT                = '\Software\Borland\Delphi\4.0';
    DELPHI_3_SECTION             = '4.0';
{$ENDIF}
    DELPHI_3_LIBRARY             = 'Library';
      LIB_SEARCHPATH               = 'SearchPath';
      LIB_FULLPATH                 = 'FullPath';
      LIB_LASTTAB                  = 'LastTab';
    DELPHI_3_KNOWNPACKAGES       = 'Known Packages';
    DELPHI_3_EXTRALIBRARYPATHS   = 'Extra Library Paths';
    DELPHI_3_EXTRALIBRARYPATHSOps= 'Extra Library Paths Options';
  DELPHI_3_ROOT_HKLM           = '\Software\Borland\Delphi';
      DELPHI_3_ROOTDIR             = 'RootDir';

Const
  RootDirReplaceMarker = '$(DELPHI)';

type
  TPathEditorAddon = class(TForm)
    SidePanel: TPanel;
    Dirs: TDirectoryListBox;
    Panel1: TPanel;
    Sort: TBitBtn;
    Button1: TBitBtn;
    Panel2: TPanel;
    DriveComboBox1: TDriveComboBox;
    CleanList: TBitBtn;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DirsChange(Sender: TObject);
    procedure CreationListClick(Sender: TObject);
    procedure SortClick(Sender: TObject);
    procedure CleanListClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    AddButton           : TButton;
    Bevel1              : TBevel;
    CancelButton        : TButton;
    CLOnClick           : TNotifyEvent;
    CreationList        : TListBox;
    DeleteButton        : TButton;
{$IFDEF VER140}
    DeleteInvalidBtn    : TButton;
{$ENDIF}
    DownButton          : TBitBtn;
    ElementEdit         : TEdit;
    HelpButton          : TButton;
    Label1              : TLabel;
    OKButton            : TButton;
    OrderedListEditDlg  : TCustomForm;
    ReplaceButton       : TButton;
    BrowseButton        : TButton;
    Root                : String;
    UpButton            : TBitBtn;
  end;

var
  PathEditorAddon: TPathEditorAddon;

Function AddBackSlash (InStr : String) : String;

implementation

{$R *.DFM}

Uses IPathSyncOptions;

Function AddBackSlash (InStr : String) : String;

Begin
  Result := Instr;
  If (Copy(Result,Length(Result),1)<>'\') Then
    Result := Result+'\';
End;

procedure TPathEditorAddon.Button1Click(Sender: TObject);
Var
  RegFile: TRegINIFile;
  Pkgs: TStringList;
  Loop : Integer;
  At : Integer;
  Work : String;
  IPathSyncOptionsForm : TIPathSyncOptionsForm;

Procedure AddItem(Item : String; NoWinDir : Boolean; NoSysDir : Boolean; NoSubSysDir : Boolean);
Var
  Dir : String;
Begin
  While (Copy(Item,Length(Item)-1,2)='\\') Do
    Delete(Item,Length(Item),1);

  SetLength(Dir,Max_Path);
  GetWindowsDirectory(PChar(Dir),max_Path);
  SetLength(Dir,StrLen(PChar(Dir)));

  Dir := AddBackSlash(AnsiUpperCase(Dir));
  If NoWinDir And (AnsiCompareText(Dir,AddbackSlash(Item))=0) Then
  Begin
    Exit;
  End;

  SetLength(Dir,Max_Path);
  GetSystemDirectory(pChar(Dir),Max_Path);
  SetLength(Dir,StrLen(PChar(Dir)));
  Dir := AddBackSlash(AnsiUpperCase(Dir));

  If (AnsiCompareText(Dir,AddbackSlash(Item))=0) Then
  Begin
    If NoSysDir Then
    Begin
      Exit;
    End;
  End
  Else
  Begin
    If NoSubSysDir And (Pos(Dir,AnsiUpperCase(AddbackSlash(Item)))=1) Then
    Begin
      Exit;
    End;
  End;

  If (CreationList.Items.IndexOf(Item)=-1) Then
    CreationList.Items.Add(Item);
End;

begin
  RegFile := TRegINIFile.Create(DELPHI_3_ROOT);
  Pkgs := TStringList.Create;
  Try
    RegFile.ReadSection(DELPHI_3_KNOWNPACKAGES,Pkgs);
    For Loop := 0 To Pkgs.Count-1 Do
    Begin
      Work := Pkgs[Loop];
      Work := AddBackSlash(ExtractFilePath(work));
      Pkgs[Loop] := Work;
    End;

    For Loop := Pkgs.Count-1 DownTo 0 Do
    Begin
      Work := Pkgs[Loop];
      At := Pkgs.IndexOf(Work);
      If (At<>Loop) Then
      Begin
        Pkgs.Delete(Loop);
      End;
    End;

    IPathSyncOptionsForm := TIPathSyncOptionsForm.Create(Self);
    Try
      If (IPathSyncOptionsForm.ShowModal=mrOk) Then
      Begin
        CreationList.Clear;
        With IPathSyncOptionsForm Do
        Begin
          For Loop := 0 To Dirs.Items.Count-1 Do
            AddItem(Dirs.Items[Loop],WinDir.Checked,SysDir.Checked,SubSysDir.Checked);
          For Loop := 0 To Pkgs.Count-1 Do
            AddItem(Pkgs[Loop],WinDir.Checked,SysDir.Checked,SubSysDir.Checked);
        End;
      End;
    Finally
      IPathSyncOptionsForm.Free;
    End;
  Finally
    Pkgs.Free;
    RegFile.Free;
  End;
end;

procedure TPathEditorAddon.FormCreate(Sender: TObject);

Var
  RegFile : TRegINIFile;
  CTop : integer;
  Min : integer;
  Adjust: integer;
begin
  RegFile := TRegINIFile.Create(DELPHI_3_ROOT);
  Try
    RegFile.CloseKey;
    RegFile.RootKey := HKEY_LOCAL_MACHINE;
    RegFile.OpenKey(DELPHI_3_ROOT_HKLM,False);
    Root := AddbackSlash(RegFile.ReadString(DELPHI_3_SECTION,DELPHI_3_ROOTDIR,''));
    Delete(Root,Length(Root),1);
  Finally
    RegFile.Free;
  End;

  OrderedListEditDlg := Owner As TCustomForm;
  CreationList := OrderedListEditDlg.FindComponent('CreationList') as  TListBox;
  ElementEdit := OrderedListEditDlg.FindComponent('ElementEdit') as  TEdit;
{$IFDEF VER130_UP}
  Min := 340;
  {$IFDEF VER140}
  Min := 410;
  {$ENDIF}
  if OrderedListEditDlg.Width < (Min + SidePanel.Width) then
{$ENDIF}
  OrderedListEditDlg.ClientWidth := OrderedListEditDlg.ClientWidth+SidePanel.Width;
  OrderedListEditDlg.Left := (Screen.Width-OrderedListEditDlg.Width) Div 2;
{$IFDEF VER130_UP}
  OrderedListEditDlg.Constraints.MinWidth := Min + SidePanel.Width;
  Bevel1 := OrderedListEditDlg.FindComponent('Bevel1') as  TBevel;
  AddButton := OrderedListEditDlg.FindComponent('AddButton') as TButton;
  CancelButton := OrderedListEditDlg.FindComponent('CancelButton') as  TButton;
  DeleteButton := OrderedListEditDlg.FindComponent('DeleteButton') as  TButton;
  DownButton := OrderedListEditDlg.FindComponent('DownButton') as  TBitBtn;
  HelpButton := OrderedListEditDlg.FindComponent('HelpButton') as  TButton;
  Label1 := OrderedListEditDlg.FindComponent('Label1') as  TLabel;
  OKButton := OrderedListEditDlg.FindComponent('OkButton') as  TButton;
  ReplaceButton := OrderedListEditDlg.FindComponent('ReplaceButton') as  TButton;
  UpButton := OrderedListEditDlg.FindComponent('UpButton') as  TBitBtn;
  BrowseButton := OrderedListEditDlg.FindComponent('BrowseButton') as  TButton;
  CTop := CreationList.Top + CreationList.Height + 7;
  DeleteButton.Top := CTop + 32;
  ReplaceButton.Top := CTop + 32;
  AddButton.Top := CTop + 32;
  ElementEdit.Top := CTop;
  BrowseButton.Top := CTop;
  CancelButton.Left := CancelButton.Left-SidePanel.Width;
  OkButton.Left := OkButton.Left-SidePanel.Width;
  HelpButton.Left := HelpButton.Left-SidePanel.Width;
  DownButton.Left := DownButton.Left-SidePanel.Width;
  UpButton.Left := UpButton.Left-SidePanel.Width;
  Bevel1.Width := Bevel1.Width-SidePanel.Width;
  ElementEdit.Anchors := [akLeft, akRight, akBottom];
  BrowseButton.Anchors := [akRight,akBottom];
  DeleteButton.Anchors := [akRight,akBottom];
  ReplaceButton.Anchors := [akRight,akBottom];
  AddButton.Anchors := [akRight,akBottom];
  Adjust := Bevel1.Left + Bevel1.Width - 10;
{$IFDEF VER140}
  DeleteInvalidBtn := OrderedListEditDlg.FindComponent('DeleteInvalidBtn') as  TButton;
  CleanList.Visible := false;
  DeleteInvalidBtn.Top := CTop + 32;
  DeleteInvalidBtn.Left := Adjust - DeleteInvalidBtn.Width;
  Adjust :=  Adjust - DeleteInvalidBtn.Width - 10;
{$ENDIF}
  with CreationList do
    begin
      Width := Width-SidePanel.Width;
      ElementEdit.Width := Width - BrowseButton.Width - 10;
      BrowseButton.Left := (Left + Width) - BrowseButton.Width;
      DeleteButton.Left := Adjust - DeleteButton.Width;
      AddButton.Left := DeleteButton.Left - AddButton.Width - 10;
      ReplaceButton.Left := AddButton.Left - ReplaceButton.Width - 10;
    end;
{$ENDIF}

  SidePanel.Parent := OrderedListEditDlg;
  CLOnClick := CreationList.OnClick;
  CreationList.OnClick := CreationListClick;
  CreationListClick(Self);
end;

procedure TPathEditorAddon.DirsChange(Sender: TObject);

Var
  At : Integer;
  aDir : String;

begin
  aDir := Dirs.Directory;

  If (Pos(AnsiUpperCase(Root),AnsiUpperCase(ADir))=1) Then
  Begin
    Delete(ADir,1,Length(Root));
    ADir := RootDirReplaceMarker+ADir;
  End;

  ElementEdit.Text := ADir;
  At := CreationList.Items.IndexOf(ADir);

  If (CreationList.ItemIndex<>At) And (At<>-1) Then
    CreationList.ItemIndex := At;
end;

procedure TPathEditorAddon.CreationListClick(Sender: TObject);

Var
  ADir : String;

begin
  If (CreationList.ItemIndex=-1) Then
  Begin
    ADir := RootDirReplaceMarker;
  End
  Else
  Begin
    ADir := CreationList.Items[CreationList.ItemIndex];
  End;

  If (Pos(AnsiUpperCase(RootDirReplaceMarker),AnsiUpperCase(ADir))=1) Then
  Begin
    Delete(ADir,1,Length(RootDirReplaceMarker));
    ADir := Root+ADir;
  End;

  If AnsiCompareText(Dirs.Directory,aDir)<>0 Then
  Begin
    Dirs.OnChange := Nil;
    Try
      Dirs.Directory := aDir;
    Except
      Try
        Dirs.Directory := Root;
      Except
      End;
    End;
    Dirs.OnChange := DirsChange;
  End;

  If (Sender<>Self) And Assigned(CLOnClick) Then
  Begin
    CLOnClick(Sender);
  End;
end;

procedure TPathEditorAddon.SortClick(Sender: TObject);

Var
  Paths : TStringList;

Begin
  Paths := TStringList.Create;
  Try
    Paths.Assign(CreationList.Items);
    Paths.Sort;
    CreationList.Items.Assign(Paths);
  Finally
    Paths.Free;
  End;
End;

procedure TPathEditorAddon.CleanListClick(Sender: TObject);

Function DirExists(DirName: string): Boolean;

Var
  Code : Integer;

begin
  Code := GetFileAttributes(PChar(DirName));
  Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
end;

Var
  Paths : TStringList;
  Loop : Integer;
  aPath : String;
  At: Integer;

Begin
  Paths := TStringList.Create;
  Try
    Paths.Assign(CreationList.Items);
    For Loop := Paths.Count-1 DownTo 0 Do
    Begin
      aPath := Paths[Loop];
      At := Pos(RootDirReplaceMarker,AnsiUpperCase(aPath));
      If (At=1) Then
      Begin
        Delete(aPAth,At,Length(RootDirReplaceMarker));
        aPath := Root+aPath;
      End;

      If Not DirExists(aPath) Then
      Begin
        Paths.Delete(Loop);
      End;
    End;
    CreationList.Items.Assign(Paths);
  Finally
    Paths.Free;
  End;
End;

end.
