unit debugging;

interface

{$WeakPackageUnit}
// You must compile with packages for this to work.
Uses Windows,SysUtils,ToolsApi;

Procedure Debug; Overload;
Procedure Debug(text : String); Overload;
Procedure Debug(Text : String; Const Args : Array of Const); Overload;

implementation

Procedure Debug;

Begin
  Debug('');
End;

Procedure Debug(text : String);

Begin
  If Assigned(BorlandIDEServices) Then
  Begin
    (BorlandIDEServices As IOTADebuggerServices).LogString(text);
  End
  Else
  Begin
    OutputDebugString(PChar(Text));
  End;
End;

Procedure Debug(Text : String; Const Args : Array of Const);

Begin
  Debug(Format(Text,Args));
End;

end.
