Unit IPathEditorReg;

Interface

//*****************************************************************************
//
// Written by Clinton R. Johnson
//
// This program is open source, and maybe used, re-used or modifed as you see
// fit.  The original author assumes no responsibility or liability for any
// damages or loss of profits resulting from the use or misuse of this code.
//
// Beta 1 - Released August 18, 1998
//
// Beta 2 - Released August 24, 1998
//
//  Fixed :
//           - Control alignment causing directories to not be visible if the
//             directory was too full. (IPathEditorForm)
//           - Bug causing stack overflow if an exception or error occured
//             during enhancment of TOrderedListEditDlg (IPathEditorReg)
//
//           - Removed enhancements from Conditionals and Unit Alises dialogs,
//             as a directory browser has no meaning for them. (IPathEditorReg)
//           - Added a XDF link in the enhancement, linking back to
//             http://www.poboxes.com/xepol  (IPathEditorForm)
//           - Added a WeakPackageUnit to Debugging.pas to prevent future colissions.
//
// Open Source Release 1 - February 26, 2000
//
//  Fixed :
//           - Added a conflict resolution to destruction.
//           - Bug in the editor causing the DELETE button to become
//             unavailable.
//           - Exception when a directory is selected from the creation list
//             that does not exist.
//           - Added "Remove Invalid paths" option.
//
//*****************************************************************************


Uses Windows,Classes,SysUtils,Forms,Dialogs,Controls,StdCtrls,Graphics,Menus,ToolsAPI;

{$M+}

Type
  TPathEditor=Class(TInterfacedObject,IOTANotifier,IOTAWizard)
    Procedure ScreenHook(Sender : TObject);
    Procedure FormDestroy(Sender : TObject);
  Public
    Constructor Create; Virtual;
    Destructor Destroy; Override;
//*******************************************************************
// IOTANotifier - Not Called for wizards, but must be included.
//*******************************************************************
    procedure AfterSave;
    procedure BeforeSave;
    procedure Destroyed;
    procedure Modified;
//*******************************************************************
// IOTAWizard
//*******************************************************************
    function GetIDString: string;
    function GetName: string;
    function GetState: TWizardState;
    procedure Execute;
//*******************************************************************
// Added features.
//*******************************************************************
  Public
    OldScreenHook       : TNotifyEvent;
    ImActive            : Boolean;
    AvoidForms          : TStringList;
  End;

Var
  PathEditor : TPathEditor;

Procedure Register;


Implementation

Uses IPathEditorForm,Debugging;

Const
  WizardState           : TWizardState = [wsEnabled];

ResourceString
  WizardName            = 'SII PathEditor';
  WizardIDString        = 'SII Path Editor';

Constructor TPathEditor.Create;

Begin
  Inherited Create;
  AvoidForms := TStringList.Create;
  AvoidForms.Add('Conditionals');
  AvoidForms.Add('Unit Aliases');
  Execute;
  Debug(StringOfChar('-',80));
  Debug('SII Path Editor - Open Source Release 1 (Feb 2000)');
  Debug('Written by Clinton R. Johnson (xepol@poboxes.com)');
  Debug('http://www.poboxes.com/xepol');
  Debug('All feedback appreciated.');
  Debug;
  Debug(StringOfChar('-',80));
End;

Destructor TPathEditor.Destroy;

Var
  X : TNotifyEvent;
  Y : TNotifyEvent;
  Xp : Array [0..1] Of Pointer Absolute X;
  Yp : Array [0..1] Of Pointer Absolute Y;
  O : TObject;
  ClassName : String;
  ClassMethod : String;

Begin
  X := Screen.OnActiveFormChange;
  Y := ScreenHook;
  If (Xp[0]=Yp[0]) Then
  Begin
    Screen.OnActiveFormChange := OldScreenHook;
  End Else If (Xp[0]=Nil) Then
  Begin
    // Do nothing, someone else has de-activated us improperly.
  End Else
  Begin
    O := TObject(Xp[1]);
    Try
      ClassName := O.Classname;
    Except
      Classname := 'Unknown';
    End;
    Try
      ClassMethod := O.MethodName(Xp[0]);
    Except
      ClassMethod := 'Unknown';
    End;

    Screen.OnActiveFormChange := Nil;
    Application.MessageBox(PChar('A conflict has been detected between SII Path Editor,'#13+
                                 'and an object in another expert.'#13+
                                 'The object is '+Classname+#13+
                                 'The method is '+ClassMethod+#13+
                                 'The other expert has been disabled.'#13+
                                 'You should restart Delphi to re-enable the other expert.'),
                                  'SII PATH EDITOR CONFLICT',
                                  mb_ok or mb_IconStop);
  End;
  AvoidForms.Free;
  AvoidForms := Nil;
  Inherited Destroy;
End;

//*******************************************************************
// IOTANotifier
//*******************************************************************
procedure TPathEditor.AfterSave; // Not called for wizards

Begin
End;

procedure TPathEditor.BeforeSave; // Not called for wizards

Begin
End;

procedure TPathEditor.Destroyed; // Not called for wizards

Begin
End;

procedure TPathEditor.Modified; // Not called for wizards

Begin
End;

//*******************************************************************
// IOTAWizard
//*******************************************************************
function TPathEditor.GetIDString: string;

Begin
  Result := WizardIDString;
End;

function TPathEditor.GetName: string;

Begin
  Result := WizardName;
End;

function TPathEditor.GetState: TWizardState;

Begin
  Result := WizardState;
End;

procedure TPathEditor.Execute;

Begin
  ImActive := FAlse;
  OldScreenHook := Screen.OnActiveFormChange;
  Screen.OnActiveFormChange := ScreenHook;
End;

//*******************************************************************
// Added features.
//*******************************************************************

Procedure TPathEditor.ScreenHook(Sender : TObject);

Var
  OrderedListEditDlg    : TCustomForm;
  Form                  : TPathEditorAddon;

Begin
  If (Not ImActive) And Assigned (AvoidForms) Then
  Begin
    OrderedListEditDlg := TForm(Application.FindComponent('OrderedListEditDlg'));
    If Assigned(OrderedListEditDlg) Then
    Begin
      If (AvoidForms.IndexOf(OrderedListEditDlg.Caption)=-1) Then // Make sure its not in the list.
      Begin
        ImActive := True;
        Form := TPathEditorAddon.Create(OrderedListEditDlg);
        Form.OnDestroy := FormDestroy;
      End;
    End;
  End;
  If Assigned(OldScreenHook) then OldScreenHook(Sender);
End;

Procedure TPathEditor.FormDestroy(Sender : TObject);

Begin
  ImActive := False;
End;

Procedure Register;

Begin
  PathEditor := TPathEditor.Create;
  RegisterPackageWizard(PathEditor As IOTAWizard);
End;


End.
