{*******************************************************}
{                                                       }
{       For use with component TProgramTracker          }
{                                                       }
{       Copyright (c) 2001 Fredrik hman                }
{                                                       }
{*******************************************************}


unit StringsEditorForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, ExtCtrls;

type
  TStringsEditor = class(TForm)
    Panel1: TPanel;
    btnOk: TButton;
    btnCancel: TButton;
    Panel2: TPanel;
    stgParams: TStringGrid;
    procedure btnOkClick(Sender: TObject);
    procedure stgParamsKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
    FStrings: TStringList;
    procedure SetValues(Values: TStrings);
    function GetValues: TStrings;
    procedure SetStringValues;
  public
    procedure ClearGrid;
    constructor Create(AOwner: TComponent; BorderText, ColumnOneText, ColumnTwoText: string); reintroduce;
    destructor Destroy; override;
    property Values: TStrings read GetValues write SetValues;
  end;

function EditTStrings(FormCaption, ColumnOneCaption, ColumnTwoCaption: string; Values: TStrings; ValuesDelimiter: string = '='): Boolean;

implementation

{$R *.DFM}

{ TStringsEditor }

procedure TStringsEditor.ClearGrid;
var i: Integer;
begin
  for i:=1 to stgParams.RowCount-1 do
  begin
    stgParams.Cells[0, i] := '';
    stgParams.Cells[1, i] := '';
  end;
  stgParams.RowCount := 9;
end;

constructor TStringsEditor.Create(AOwner: TComponent; BorderText,
  ColumnOneText, ColumnTwoText: string);
begin
  inherited Create(AOwner);
  FStrings := TStringList.Create;
  Caption := BorderText;
  stgParams.Cells[0, 0] := ColumnOneText;
  stgParams.Cells[1, 0] := ColumnTwoText;
end;

destructor TStringsEditor.Destroy;
begin
  FStrings.Free;
  inherited;
end;

procedure TStringsEditor.SetValues(Values: TStrings);
var i: Integer;
begin
  ClearGrid;
  if Values <> nil then
  begin
    if Values.Count > 0 then
    begin
      stgParams.RowCount := Values.Count + 1;
      for i:=0 to Values.Count-1 do
      begin
        if Values[i] <> '' then
        begin
          if Pos('=', Values[i]) = 0 then
          begin
            stgParams.Cells[0, i+1] := '';
            stgParams.Cells[1, i+1] := Values[i];
          end
          else
          begin
            stgParams.Cells[0, i+1] := Copy(Values[i], 1, Pos('=', Values[i])-1);
            stgParams.Cells[1, i+1] := Copy(Values[i], Pos('=', Values[i])+1, Length(Values[i]));
          end;
        end;
      end;
    end;
    SetStringValues;
  end;
end;

procedure TStringsEditor.btnOkClick(Sender: TObject);
begin
  SetStringValues;
  ModalResult := mrOk;
end;

procedure TStringsEditor.SetStringValues;
var i: Integer;
begin
  FStrings.Clear;
  for i:=1 to stgParams.RowCount-1 do
  begin
    if ((stgParams.Cells[1, i] <> '') or (stgParams.Cells[0, i] <> '')) then
      FStrings.Add(stgParams.Cells[0, i] + '=' + stgParams.Cells[1, i]);
  end;
end;

//EditTStrings makes a stringlist of param "Values" with strings of format:
//TValuesFormat=vfIniFile 'key=Value' (default).
//TValuesFormat=vfSpaceDelimited 'key Value'.
function EditTStrings(FormCaption, ColumnOneCaption, ColumnTwoCaption: string; Values: TStrings; ValuesDelimiter: string = '='): Boolean;
var EditForm: TStringsEditor;
    i: Integer;
begin
  Result := false;
  if Values <> nil then
  begin
    EditForm := TStringsEditor.Create(Application, FormCaption, ColumnOneCaption, ColumnTwoCaption);
    if Values.Count > 0 then
    begin
      //Prepare Values with '=', since EditForm.Values works with TStrings
      //of form 'Key=Value'
      for i:=0 to Values.Count-1 do
        Values[i] := StringReplace(Values[i], ValuesDelimiter, '=', []);
      EditForm.Values := Values;
    end;
    if EditForm.ShowModal = mrOk then
    begin
      Values.Clear;
      //Replace '=' with ValuesDelimiter.
      for i:=0 to EditForm.Values.Count - 1 do
        Values.Add(StringReplace(EditForm.Values[i], '=', ValuesDelimiter, []));
      Result := true;
    end;
    EditForm.Release;
  end;
end;

function TStringsEditor.GetValues: TStrings;
begin
  Result := FStrings;
end;

procedure TStringsEditor.stgParamsKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if ((Key = VK_DOWN) and (stgParams.Row = (stgParams.RowCount-1))) then
    stgParams.RowCount := stgParams.RowCount + 1;
end;

end.





