unit ProgramTrackerEditors;

interface

uses
  DsgnIntf, StringsEditorForm, Classes;

type
  TStringsEditorProperty = class(TClassProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  TExecuteProgramWayProperty = class(TSetProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
  end;


implementation

{ TStringsEditorProperty }

procedure TStringsEditorProperty.Edit;
var TmpValues: TStrings;
begin
  TmpValues := TStrings(GetOrdValue);
  EditTStrings('Parameter editor', 'Switch', 'Command', TmpValues, ' ');
end;

function TStringsEditorProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

{ END TStringsEditorProperty }

{ TExecuteProgramWayProperty }

function TExecuteProgramWayProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes;
end;

{ END TExecuteProgramWayProperty }

end.
