{$I PIETOOLS.INC}
{ Autor: Ingolf Pietschmann.
  Dieser Quelltext ist Freeware. Die Verwendung und Weitergabe dieser Sourcen zu
  privaten nicht kommerziellen Zwecken ist ausdrcklich erwnscht.
  Die Verwendung zu kommerziellen Zwecken ist nur mit Erlaubnis des Autors
  gestattet. Den Autor knnen Sie unter "support@Pie-Tools.de" erreichen.
  http://www.Pie-Tools.de

  These sources are freeware. The usage and distribution of these sources for
  private, not commercial purposes is explicit desired.
  The usage for commercial purposes is only permitted in agreement of the author.
  The author can be reached by "support@Pie-Tools.de".
}
{  Diese Unit enthlt ein von TEdit abgeleitetes Dialogelement
  welches verschiedene Eingabefilter anbietet.
  Bentigt die Unit Validate.Pas.

  Filtertypen:

  etString  : Normales Eingabefeld
  etLongint : Ganzzahlige Werte
  etDouble  : Festkommazahlen
  etExponent: Exponentialschreibweise
  etHex     : Hexadezimal
  etBin     : Binaer
  etFilter  : Ganzzahliger WerteFilter

  Hinweis: Dieses Eingabefeld lt leider noch eine Leereingabe zu.
           Solche Fehler mssen dann der Methode zum Schlieen
           des Dialogs abgefangen werden.}

unit Pievaled;

{Copyright 1997 by I. Pietschmann}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls,
  DB, DBCtrls,
  PieHERK;

TYPE TCharSet = Set Of Char;

{ TFilterValidator }

  TValEditTyp = (etBin,etDouble,etExponent,etFilter,etHex,etLongInt,etString);

  TFilterValidator = class
   PRIVATE
     ValidChars: TCharSet;
     ValEditTyp: TValEditTyp;
   PUBLIC
    function IsValid(const S: string): Boolean; virtual;
    function IsValidInput(var S: string): Boolean; virtual;
    PROCEDURE SetValidChars(AValidChars: TCharSet); VIRTUAL;
    PROCEDURE SetValEditTyp(AValEditTyp: TValEditTyp); VIRTUAL;
    function Valid(const S: string): Boolean; VIRTUAL;
  end;

  TPieValidateEdit = class;

  TPieValidateEditErrorAction = (pveaEnglish, pveaGerman, pveaNothing);
  TPieValidateEditErrorEvent = procedure(Sender: TPieValidateEdit; ErrorIndex: Integer; var ErrorAction: TPieValidateEditErrorAction) of object;

  TPieValidateEdit = class(TCustomPanel)
  private
   FVersion    : string;
   FEdit       : TCustomEdit;
   FComboBox   : TCustomComboBox;
   PValidator  : TFilterValidator;
   FValEditTyp : TValEditTyp; { Validatortyp     }
   FNK         : INTEGER;     { Nachkommastellen }
   FMinWert    : Double;      {kleinster gltiger Wert}
   FMaxWert    : Double;      {grter gltiger Wert}
   FFilter     : TStringList; {gltige Eingabestrings}
   FPruefen    : Boolean;     {zum Ausschalten des Gltigkeitsbereiches}
   FValMeldung : Boolean;     {zum Ausschalten der Validierungs-Fehlermeldung}
   FOnValidExit: TNotifyEvent;{Ereignis, wenn Fokuswechsel und gltige Eingabe}
   FOnChange   : TNotifyEvent;
   FOnKeyDown  : TKeyEvent;
   FOnKeyPress : TKeyPressEvent;
   FOnKeyUp    : TKeyEvent;
   FOnValidateError: TPieValidateEditErrorEvent;
   FDataField  : string;
   FWMSize_erlaubt: Boolean;
   PROCEDURE SetValEditTyp(Value : TValEditTyp);
   PROCEDURE SetNK(Value : INTEGER);
   PROCEDURE SetAutoSelect(Value: Boolean);
   PROCEDURE SetAutoSize(Value: Boolean);
   PROCEDURE SetCharCase(Value: TEditCharCase);
   PROCEDURE SetCursor(Value: TCursor);
   PROCEDURE SetDragCursor(Value: TCursor);
   PROCEDURE SetEditColor(Value: TColor);
   PROCEDURE SetFEnabled(Value: Boolean);
   PROCEDURE SetFilterIndex(Value: Integer);
   PROCEDURE SetHideSelection(Value: Boolean);
   PROCEDURE SetMaxLength(Value: Integer);
   PROCEDURE SetOEMConvert(Value: Boolean);
   PROCEDURE SetPasswordChar(Value: Char);
   PROCEDURE SetReadOnly(Value: Boolean);
   procedure SetSelLength(Value: Integer);
   procedure SetSelStart(Value: Integer);
   procedure SetSelText(const Value: string);
   PROCEDURE SetTabStop(Value: Boolean);
   PROCEDURE SetText(Value: TCaption);
   FUNCTION GetAutoSelect: Boolean;
   FUNCTION GetAutoSize: Boolean;
   FUNCTION GetCharCase: TEditCharCase;
   FUNCTION GetCursor: TCursor;
   FUNCTION GetDragCursor: TCursor;
   FUNCTION GetDragMode: TDragMode;
   FUNCTION GetEditColor: TColor;
   FUNCTION GetFEnabled: Boolean;
   FUNCTION GetFilterIndex: Integer;
   FUNCTION GetHideSelection: Boolean;
   FUNCTION GetMaxLength: Integer;
   FUNCTION GetOEMConvert: Boolean;
   FUNCTION GetPasswordChar: Char;
   FUNCTION GetReadOnly: Boolean;
   function GetSelLength: Integer;
   function GetSelStart: Integer;
   function GetSelText: string;
   FUNCTION GetTabStop: Boolean;
   FUNCTION GetText: TCaption;
   PROCEDURE FilterChange(Sender: TObject);
   PROCEDURE EditChange(Sender: TObject);
   PROCEDURE EditClick(Sender: TObject); dynamic;
   PROCEDURE EditDblClick(Sender: TObject);
   PROCEDURE EditDragDrop(Sender, Source: TObject; X, Y: Integer);
   PROCEDURE EditDragOver(Sender, Source: TObject; X, Y: Integer;
                          State: TDragState; var Accept: Boolean);
   PROCEDURE EditEndDrag(Sender, Target: TObject; X, Y: Integer);
   PROCEDURE EditEnter(Sender: TObject);
   PROCEDURE EditExit(Sender: TObject);
   PROCEDURE EditKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
   PROCEDURE EditKeyPress(Sender: TObject; var Key: Char); dynamic;
   PROCEDURE EditKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
   PROCEDURE EditMouseDown(Sender: TObject; Button: TMouseButton;
                           Shift: TShiftState; X, Y: Integer);
   PROCEDURE EditMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
   PROCEDURE EditMouseUp(Sender: TObject; Button: TMouseButton;
                         Shift: TShiftState; X, Y: Integer);
   PROCEDURE EditStartDrag(Sender: TObject; var DragObject: TDragObject);
   {$IFDEF D4_OR_HIGHER}
   PROCEDURE EditEndDock(Sender, Target: TObject; X, Y: Integer);
   PROCEDURE EditStartDock(Sender: TObject; var DragObject: TDragDockObject);
   {$ENDIF}
   procedure WMSize(var Message: TWMSize); message WM_SIZE;
   PROCEDURE Berechne_Groesse; virtual;
  protected
   procedure Loaded; override;
   procedure SetFilter(Value: TStringList);
  public         {TPieValidateEdit}
   Constructor Create(AOwner : TComponent); override;
   Destructor  Destroy; override;
   PROCEDURE Error(Art: Byte);{0: ungltiges Zeichen, 1: ungltige Zahl}
   FUNCTION IsValid : BOOLEAN; VIRTUAL;
   FUNCTION GetDouble  : Double;  VIRTUAL;
   FUNCTION GetExponent: Double;  VIRTUAL;
   FUNCTION GetLongInt : LongInt; VIRTUAL;
   FUNCTION GetHex : LongInt; VIRTUAL;
   FUNCTION GetBin : LongInt; VIRTUAL;
   PROCEDURE SetDragMode(Value: TDragMode); override;
   PROCEDURE SetDouble(Value : Double); VIRTUAL;
   PROCEDURE SetExponent(Value : Double); VIRTUAL;
   PROCEDURE SetLongInt(Value : LongInt); VIRTUAL;
   PROCEDURE SetHex(Value : LongInt); VIRTUAL;
   PROCEDURE SetBin(Value : LongInt); VIRTUAL;
   PROCEDURE SetFocus; Override;
   PROCEDURE ClearSelection;
   PROCEDURE SelectAll;
   PROCEDURE DoExit; override;
  published
   {zustzliche propertys}
   property ValEditTyp : TValEditTyp read FValEditTyp write SetValEditTyp default etString;
   property DecimalPlaces : INTEGER read FNK write SetNK default 2;
   property MinValue: Double read FMinWert write FMinWert;
   property MaxValue: Double read FMaxWert write FMaxWert;
   property Validate: Boolean read FPruefen write FPruefen default TRUE;
   property Filter: TStringList read FFilter write SetFilter;
   property FilterIndex: integer read GetFilterIndex write SetFilterIndex;
   property ValidateMessage: Boolean read FValMeldung write FValMeldung default TRUE;
   {unvernderte Panel-propertys}
   property Align;
   property BorderStyle;
   property Color;
   property Ctl3D;
   property Font;
   property ParentColor;
   property ParentCtl3D;
   property ParentFont;
   property ParentShowHint;
   property PopupMenu;
   property ShowHint;
   property TabOrder;
   property Visible;
   property OnClick;
   property OnDblClick;
   property OnDragDrop;
   property OnDragOver;
   property OnEndDrag;
   property OnEnter;
   property OnExit;
   property OnMouseDown;
   property OnMouseMove;
   property OnMouseUp;
   property OnResize;
   property OnStartDrag;
   {$IFDEF D4_OR_HIGHER}
   property OnEndDock;
   property OnStartDock;
   {$ENDIF}
   {$IFDEF D5_OR_HIGHER}
   property Anchors;
   property Constraints;
   {$ENDIF}
   {vernderte Panel-Propertys}
   property AutoSelect: Boolean read GetAutoSelect write SetAutoSelect default TRUE;
   property AutoSize: Boolean read GetAutoSize write SetAutoSize default TRUE;
   property CharCase: TEditCharCase read GetCharCase write SetCharCase default ecNormal;
   property Cursor: TCursor read GetCursor write SetCursor default crDefault;
   property DragCursor: TCursor read GetDragCursor write SetDragCursor default crDrag;
   property DragMode: TDragMode read GetDragMode write SetDragMode default dmManual;
   property EditColor: TColor read GetEditColor write SetEditColor default clWindow;
   property Enabled: Boolean read GetFEnabled write SetFEnabled default TRUE;
   property HideSelection: Boolean read GetHideSelection write SetHideSelection default TRUE;
   property MaxLength: Integer read GetMaxLength write SetMaxLength default 0;
   property PasswordChar: Char read GetPasswordChar write SetPasswordChar default #0;
   property ReadOnly: Boolean read GetReadOnly write SetReadOnly default FALSE;
   property SelLength: Integer read GetSelLength write SetSelLength;
   property SelStart: Integer read GetSelStart write SetSelStart;
   property SelText: string read GetSelText write SetSelText;
   property TabStop: Boolean read GetTabStop write SetTabStop default TRUE;
   property Text: TCaption read GetText write SetText;
   property OnValidExit: TNotifyEvent read FOnValidExit write FOnValidExit;
   property OnChange: TNotifyEvent read FOnChange write FOnChange;
   property OnKeyDown: TKeyEvent read FOnKeyDown write FOnKeyDown;
   property OnKeyPress: TKeyPressEvent read FOnKeyPress write FOnKeyPress;
   property OnKeyUp: TKeyEvent read FOnKeyUp write FOnKeyUp;
   property OnValidateError: TPieValidateEditErrorEvent read FOnValidateError write FOnValidateError;
   property Version: string read FVersion write FVersion;
   {$IFDEF D4_OR_HIGHER}
   property OEMConvert: Boolean read GetOEMConvert write SetOEMConvert default FALSE;
   {$ENDIF}
  end;

TPieExtValEdit = class(TPieValidateEdit)
  private
    FEinheit: string;
    FHeader: string;
    FHeader2Hint: Boolean;     {um lange Headertexte autonatisch als Hint darzustellen}
    FEinheitsbreite: Integer;
    FPictures: Boolean;
    FEditHeight: Integer;
    FBevelInner: TPanelBevel;
    FBevelOuter: TPanelBevel;
    FEinheitsBevelInner: TPanelBevel;
    FEinheitsBevelOuter: TPanelBevel;
    FHeaderFont: TFont;
    FEinheitsFont: TFont;
    FEinheitsPanelColor: TColor;
    Clabel: TLabel;
    Elabel: TPanel;
    GImage: TImage;
    Erlaubt_zeigen: Boolean;
    FPictureHeader : TPicture;
    FPictureRange  : TPicture;
    FWMSize_erlaubt: Boolean;
    PROCEDURE SetHeader(Value: string);
    PROCEDURE SetHeader2Hint(Value: Boolean);
    PROCEDURE SetEinheit(Value: string);
    PROCEDURE SetEinheitsbreite(Value: Integer);
    PROCEDURE SetPictures(Value: Boolean);
    PROCEDURE SetEditHeight(Value: Integer);
    PROCEDURE SetEinheitsBevelInner(Value: TPanelBevel);
    PROCEDURE SetEinheitsBevelOuter(Value: TPanelBevel);
    PROCEDURE SetHeaderFont(Value: TFont);
    PROCEDURE HeaderFontChange(Sender: TObject);
    PROCEDURE SetEinheitsFont(Value: TFont);
    PROCEDURE EinheitsFontChange(Sender: TObject);
    PROCEDURE SetEinheitsPanelColor(Value: TColor);
    PROCEDURE SetPictureHeader(Value: TPicture);
    PROCEDURE SetPictureRange(Value: TPicture);
    PROCEDURE SetFEnabled(Value: Boolean);
    PROCEDURE ImageMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    PROCEDURE PictureChange(Sender: TObject); dynamic;
    PROCEDURE Berechne_Groesse; override;
  protected
   procedure Loaded; override;
  public             {TPieExtValEdit}
    Constructor Create(AOwner : TComponent); override;
    Destructor  Destroy; override;
    PROCEDURE DoExit; override;
    PROCEDURE Wertebereich_zeigen;
  published
    property Header2Hint: Boolean read FHeader2Hint write SetHeader2Hint default TRUE;
    property Header: string read FHeader write SetHeader;
    property UnitValue: string read FEinheit write SetEinheit;
    property UnitWidth: Integer read FEinheitsbreite write SetEinheitsbreite default 20;
    property Pictures: Boolean read FPictures write SetPictures default TRUE;
    property EditHeight: Integer read FEditHeight write SetEditHeight default 21;
    property UnitBevelInner: TPanelBevel read FEinheitsBevelInner write SetEinheitsBevelInner default bvRaised;
    property UnitBevelOuter: TPanelBevel read FEinheitsBevelOuter write SetEinheitsBevelOuter default bvLowered;
    property HeaderFont: TFont read FHeaderFont write SetHeaderFont;
    property UnitFont: TFont read FEinheitsFont write SetEinheitsFont;
    property UnitPanelColor: TColor read FEinheitsPanelColor write SetEinheitsPanelColor default clBtnFace;
    property Enabled: Boolean read GetFEnabled write SetFEnabled default TRUE;
    property PictureHeader: TPicture read FPictureHeader write SetPictureHeader;
    property PictureRange: TPicture read FPictureRange write SetPictureRange;
    property Validate: Boolean read FPruefen write FPruefen default TRUE;
END;

{TDBEdit}

TPieDBExtValEdit = class(TPieExtValEdit)
  private
    function GetDataSource: TDataSource;
    function GetField: TField;
    procedure SetDataField(const Value: string);
    procedure SetDataSource(Value: TDataSource);
  protected
  public             {TPieDBExtValEdit}
    property Field: TField read GetField;
  published
    property DataField: string read FDataField write SetDataField;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
END;


implementation

{$R PieValEd.RES}

(*************************************************)
(******TFilterValidator***************************)
(*************************************************)
PROCEDURE TFilterValidator.SetValidChars(AValidChars: TCharSet);
BEGIN
  ValidChars := AValidChars;
END;

PROCEDURE TFilterValidator.SetValEditTyp(AValEditTyp: TValEditTyp);
BEGIN
  ValEditTyp := AValEditTyp;
END;

function TFilterValidator.Valid(const S: string): Boolean;
begin
  Valid := False;
  if not IsValid(S) then begin
   Exit;
  end;
  Valid := True;
end;

function TFilterValidator.IsValid(const S: string): Boolean;
var I: Integer;
begin
 TRY
   I := Length(S);
   IF I > 0 THEN BEGIN
     while (I>0) AND (S[I] in ValidChars) do Dec(I);
     IsValid := (I=0) and (Length(S)>0);
   END ELSE Result := TRUE;
 EXCEPT
   on EAccessViolation DO Result := FALSE;
 END;
end;

function TFilterValidator.IsValidInput(var S: string): Boolean;
var i, PCount : INTEGER;
    Fehler: Boolean;
begin
 Fehler := FALSE;
 PCount := 0;
 i := Length(S);
 Result:=True;
 WHILE i > 0 DO BEGIN
  {****** Zeichen in ValidChars? *********}
  IF NOT(S[i] IN ValidChars) THEN BEGIN
   Delete(S,i,1);
   Fehler := TRUE;
   Result := FALSE;
  END
  {****** Punktprfung fr Zahlen *********}
  ELSE IF NOT(ValEditTyp IN [etString, etFilter]) THEN BEGIN
    IF S[i] = ',' THEN S[i] := '.';
    IF NOT(Fehler) AND (S[i] = '.') THEN BEGIN
      Inc(PCount);
      IF PCount > 1 THEN BEGIN
        Delete(S,i,1);
        Fehler := TRUE;
      END;
    END;
    IF NOT(Fehler) AND (S[i] IN ['-','+']) AND ((I > 1) AND NOT(S[i-1] IN ['e','E'])) THEN Delete(S,i,1);
  END;
  dec(i);
 END;
END;
(*************************************************)
(******TPieValidateEdit***************************)
(*************************************************)
FUNCTION TPieValidateEdit.GetDouble : Double;
VAR Code : INTEGER;
    Value : Double;
BEGIN
 IF FValEditTyp = etDouble THEN BEGIN
  VAL(FEdit.Text,Value,Code);
  IF Code = 0 THEN GetDouble := Value ELSE GetDouble := 0;
 END ELSE GetDouble := 0;
END;

FUNCTION TPieValidateEdit.GetExponent : Double;
VAR Code : INTEGER;
    Value : Double;
BEGIN
 IF FValEditTyp = etExponent THEN BEGIN
  VAL(FEdit.Text,Value,Code);
  IF Code = 0 THEN GetExponent := Value ELSE GetExponent := 0;
 END ELSE GetExponent := 0;
END;

FUNCTION TPieValidateEdit.GetLongInt : LongInt;
VAR Code : INTEGER;
    Value : LongInt;
BEGIN
 IF FValEditTyp = etLongInt THEN BEGIN
  VAL(FEdit.Text,Value,Code);
  IF Code = 0 THEN GetLongInt := Value ELSE GetLongInt := 0;
 END ELSE GetLongInt := 0;
END;

FUNCTION TPieValidateEdit.GetHex : LongInt;
VAR
  S: string;
  Ziffer: Byte;
  I: Integer;
  W: Integer;
BEGIN
  IF FValEditTyp = etHex THEN BEGIN
    S := Leftpad(UpperCase(FEdit.Text), 8);  {String mit 8 Zeichen}
    W := 0;
    FOR I:=1 TO length(S) DO BEGIN
      IF S[I] = ' ' THEN S[I] := '0';   {Blanks in Nullen wandeln}
      Ziffer := 0;
      IF S[I] IN ['0' .. '9'] THEN Ziffer := ord(S[I])-$30;
      IF S[I] IN ['A' .. 'F'] THEN Ziffer := ord(S[I])-$37;
      W := W SHL 4 + Ziffer;
    END;
    GetHex := W;
  END ELSE GetHex := 0;
END;

FUNCTION TPieValidateEdit.GetBin : LongInt;
VAR
  S: string;
  Z: LongInt;
  Ziffer, I: Byte;
  Stellenwert: LongInt;
BEGIN
  IF FValEditTyp = etBin THEN BEGIN
    S := UpperCase(FEdit.Text);
    Z := 0;
    FOR I:=1 TO length(S) DO IF S[I] IN ['0'..'1'] THEN BEGIN
      Ziffer := ord(S[I]) - $30;
      Stellenwert := 1;
      Stellenwert := Stellenwert SHL (length(S)-I);
      Z := Z + Ziffer * Stellenwert;
    END;
    GetBin := Z;
  END ELSE GetBin := 0;
END;

PROCEDURE TPieValidateEdit.SetDouble(Value : Double);
VAR S : STRING;
BEGIN
 Str(Value:1:FNK, S);
 FEdit.Text := S;
END;

PROCEDURE TPieValidateEdit.SetExponent(Value : Double);
VAR F : STRING;
    I : Integer;
BEGIN
 F := '0.'; FOR I:=1 TO FNK DO F := F + '0'; F := F + 'E+00';
 FEdit.Text := FormatFloat(F, Value);
END;

PROCEDURE TPieValidateEdit.SetLongInt(Value : LongInt);
VAR HlpStr : STRING;
BEGIN
 STR(Value,HlpStr);
 FEdit.Text := HlpStr;
END;

PROCEDURE TPieValidateEdit.SetHex(Value : LongInt);
CONST
  Stellen = 8;
  HS : array[0..15] of char =
    ('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F');
VAR
  S: string;
  Z: Integer;
  I: Integer;
BEGIN
  S := '';
  Z := Value;
  FOR I:=1 TO Stellen DO BEGIN
    S := HS[Lo(Z) MOD 16] + S;
    Z := Z SHR 4;
  END;
  FEdit.Text := NoNull(S);
END;

PROCEDURE TPieValidateEdit.SetBin(Value : LongInt);
VAR
  S: STRING;
  Z: LongInt;
  Ziffer: Byte;
  Stellenwert: LongInt;
  Zahl_begonnen : Boolean;
  Stelle: Integer;
BEGIN
  S := '';
  Z := Value;
  Zahl_begonnen := FALSE;
  Stelle := 40; {max. 40 Stellen angenommen}
  WHILE Stelle >= 0 DO BEGIN
    Stellenwert := 1;
    Stellenwert := Stellenwert SHL Stelle;
    IF NOT(Zahl_begonnen) THEN Zahl_begonnen := Z > Stellenwert;
    IF Zahl_begonnen THEN BEGIN
      Ziffer := trunc(Z / Stellenwert);
      Z := Z - Ziffer*Stellenwert;
      S := S + chr(Ziffer + $30);
    END;
    dec(Stelle);
  END;
  FEdit.Text     := S;
END;

Constructor TPieValidateEdit.Create(AOwner : TComponent);
BEGIN
  FWMSize_erlaubt := FALSE;
  inherited Create(AOwner);
  Parent := AOwner as TWinControl;
  PValidator  := TFilterValidator.Create;
  PValidator.SetValidChars([#0..#255]);
  PValidator.SetValEditTyp(etString);
  IF ClassType = TPieDBExtValEdit THEN BEGIN
    FComboBox := TDBComboBox.Create(Self);
    FEdit := TDBEdit.Create(Self);
    (FEdit as TDBEdit).OnChange   := EditChange;
    (FEdit as TDBEdit).OnClick    := EditClick;
    (FEdit as TDBEdit).OnDblClick := EditDblClick;
    (FEdit as TDBEdit).OnDragDrop := EditDragDrop;
    (FEdit as TDBEdit).OnDragOver := EditDragOver;
    (FEdit as TDBEdit).OnEndDrag  := EditEndDrag;
    (FEdit as TDBEdit).OnEnter    := EditEnter;
    (FEdit as TDBEdit).OnExit     := EditExit;
    (FEdit as TDBEdit).OnKeyDown  := EditKeyDown;
    (FEdit as TDBEdit).OnKeyPress := EditKeyPress;
    (FEdit as TDBEdit).OnKeyUp    := EditKeyUp;
    (FEdit as TDBEdit).OnMouseDown:= EditMouseDown;
    (FEdit as TDBEdit).OnMouseMove:= EditMouseMove;
    (FEdit as TDBEdit).OnMouseUp  := EditMouseUp;
    (FEdit as TDBEdit).OnStartDrag:= EditStartDrag;
    (FComboBox as TDBComboBox).OnChange   := EditChange;
    (FComboBox as TDBComboBox).OnClick    := EditClick;
    (FComboBox as TDBComboBox).OnDblClick := EditDblClick;
    (FComboBox as TDBComboBox).OnDragDrop := EditDragDrop;
    (FComboBox as TDBComboBox).OnDragOver := EditDragOver;
    (FComboBox as TDBComboBox).OnEndDrag  := EditEndDrag;
    (FComboBox as TDBComboBox).OnEnter    := EditEnter;
    (FComboBox as TDBComboBox).OnExit     := EditExit;
    (FComboBox as TDBComboBox).OnKeyDown  := EditKeyDown;
    (FComboBox as TDBComboBox).OnKeyPress := EditKeyPress;
    (FComboBox as TDBComboBox).OnKeyUp    := EditKeyUp;
    (FComboBox as TDBComboBox).OnStartDrag:= EditStartDrag;
    {$IFDEF D4_OR_HIGHER}
    (FEdit as TDBEdit).OnEndDock  := EditEndDock;
    (FEdit as TDBEdit).OnStartDock:= EditStartDock;
    (FComboBox as TDBComboBox).OnEndDock  := EditEndDock;
    (FComboBox as TDBComboBox).OnStartDock:= EditStartDock;
    {$ENDIF}
  END
  ELSE BEGIN
    FComboBox := TComboBox.Create(Self);
    FEdit := TEdit.Create(Self);
    (FEdit as TEdit).OnChange   := EditChange;
    (FEdit as TEdit).OnClick    := EditClick;
    (FEdit as TEdit).OnDblClick := EditDblClick;
    (FEdit as TEdit).OnDragDrop := EditDragDrop;
    (FEdit as TEdit).OnDragOver := EditDragOver;
    (FEdit as TEdit).OnEndDrag  := EditEndDrag;
    (FEdit as TEdit).OnEnter    := EditEnter;
    (FEdit as TEdit).OnExit     := EditExit;
    (FEdit as TEdit).OnKeyDown  := EditKeyDown;
    (FEdit as TEdit).OnKeyPress := EditKeyPress;
    (FEdit as TEdit).OnKeyUp    := EditKeyUp;
    (FEdit as TEdit).OnMouseDown:= EditMouseDown;
    (FEdit as TEdit).OnMouseMove:= EditMouseMove;
    (FEdit as TEdit).OnMouseUp  := EditMouseUp;
    (FEdit as TEdit).OnStartDrag:= EditStartDrag;
    (FComboBox as TComboBox).OnChange   := EditChange;
    (FComboBox as TComboBox).OnClick    := EditClick;
    (FComboBox as TComboBox).OnDblClick := EditDblClick;
    (FComboBox as TComboBox).OnDragDrop := EditDragDrop;
    (FComboBox as TComboBox).OnDragOver := EditDragOver;
    (FComboBox as TComboBox).OnEndDrag  := EditEndDrag;
    (FComboBox as TComboBox).OnEnter    := EditEnter;
    (FComboBox as TComboBox).OnExit     := EditExit;
    (FComboBox as TComboBox).OnKeyDown  := EditKeyDown;
    (FComboBox as TComboBox).OnKeyPress := EditKeyPress;
    (FComboBox as TComboBox).OnKeyUp    := EditKeyUp;
    (FComboBox as TComboBox).OnStartDrag:= EditStartDrag;
    {$IFDEF D4_OR_HIGHER}
    (FEdit as TEdit).OnEndDock  := EditEndDock;
    (FEdit as TEdit).OnStartDock:= EditStartDock;
    (FComboBox as TComboBox).OnEndDock  := EditEndDock;
    (FComboBox as TComboBox).OnStartDock:= EditStartDock;
    {$ENDIF}
  END;
 { Parent := AOwner as TWinControl;}
  FDataField := '';
  FComboBox.Parent := Self;
  FComboBox.Visible := FALSE;
  FComboBox.Align := alClient;
  FEdit.Parent := Self;
  FEdit.Align := alClient;
  FFilter := TStringList.Create;
  FFilter.Sorted := TRUE;
  FFilter.OnChange := FilterChange;
  Width := 121;
  Height := 21;
  BevelInner := bvNone;
  BevelOuter := bvNone;
  EditColor := clWindow;
  Enabled := TRUE;
  FValEditTyp := etString;
  FNK := 2;
  FMinWert := 0;
  FMaxWert := 1;
  FPruefen := TRUE;
  FValMeldung := TRUE;
  FWMSize_erlaubt := TRUE;
  FVersion := '1.1';
  Berechne_Groesse;
END;

DESTRUCTOR TPieValidateEdit.Destroy;
BEGIN
{ PValidator.Free;}
 FFilter.Free;
 FEdit.Free;
 FComboBox.Free;
 inherited Destroy;
END;

procedure TPieValidateEdit.SetFilter(Value: TStringList);
begin
  FFilter.Assign(Value);
end;

PROCEDURE TPieValidateEdit.SetNK(Value : INTEGER);
BEGIN
 IF (FNK <> Value) AND (Value >= 0) THEN FNK := Value;
END;

PROCEDURE TPieValidateEdit.SetValEditTyp(Value : TValEditTyp);
BEGIN
 IF FValEditTyp <> Value THEN BEGIN
  FValEditTyp := Value;
  PValidator.SetValEditTyp(Value);
  CASE FValEditTyp OF
   etBin      : PValidator.SetValidChars(['0','1']);
   etDouble   : PValidator.SetValidChars(['0'..'9','+','-','.',',']);
   etExponent : PValidator.SetValidChars(['0'..'9','+','-','.','e','E']);
   etFilter   : PValidator.SetValidChars([#0..#$FF]);
   etHex      : PValidator.SetValidChars(['0'..'9','A'..'F','a'..'f']);
   etLongInt  : PValidator.SetValidChars(['0'..'9','+','-']);
   etString   : PValidator.SetValidChars([#0..#$FF]);
  END;
  IF NOT(IsValid) THEN FEdit.Text := '0';
  FComboBox.Visible := FValEditTyp = etFilter;
  FEdit.Visible := NOT(FComboBox.Visible);
  IF ClassType = TPieDBExtValEdit THEN BEGIN
    IF FEdit.Visible THEN (FEdit as TDBEdit).DataField := FDataField;
    IF FComboBox.Visible THEN (FComboBox as TDBComboBox).DataField := FDataField;
  END;
 END;
END;

PROCEDURE TPieValidateEdit.SetFocus;
BEGIN
  IF FValEditTyp = etFilter THEN FComboBox.SetFocus ELSE FEdit.SetFocus;
END;

PROCEDURE TPieValidateEdit.SelectAll;
BEGIN
  IF FValEditTyp = etFilter THEN FComboBox.SelectAll ELSE FEdit.SelectAll;
END;

PROCEDURE TPieValidateEdit.ClearSelection;
BEGIN
  FEdit.ClearSelection;
END;

PROCEDURE TPieValidateEdit.SetTabStop(Value: Boolean);
BEGIN
  FComboBox.TabStop := Value;
  FEdit.TabStop := Value;
END;

FUNCTION TPieValidateEdit.GetTabStop: Boolean;
BEGIN
  Result := FEdit.TabStop;
END;

PROCEDURE TPieValidateEdit.SetAutoSelect(Value: Boolean);
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  (FEdit as TDBEdit).AutoSelect := Value
 END
 ELSE BEGIN
  (FEdit as TEdit).AutoSelect := Value
 END;
END;

FUNCTION TPieValidateEdit.GetAutoSelect: Boolean;
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  Result := (FEdit as TDBEdit).AutoSelect;
 END
 ELSE BEGIN
  Result := (FEdit as TEdit).AutoSelect;
 END; 
END;

PROCEDURE TPieValidateEdit.SetAutoSize(Value: Boolean);
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  (FEdit as TDBEdit).AutoSize := Value;
 END
 ELSE BEGIN
  (FEdit as TEdit).AutoSize := Value;
 END;
END;

FUNCTION TPieValidateEdit.GetAutoSize: Boolean;
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  Result := (FEdit as TDBEdit).AutoSize;
 END
 ELSE BEGIN
  Result := (FEdit as TEdit).AutoSize;
 END; 
END;

PROCEDURE TPieValidateEdit.SetCharCase(Value: TEditCharCase);
BEGIN
  FComboBox.CharCase := Value;
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  (FEdit as TDBEdit).CharCase := Value;
 END
 ELSE BEGIN
  (FEdit as TEdit).CharCase := Value;
 END;
END;

FUNCTION TPieValidateEdit.GetCharCase: TEditCharCase;
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  Result := (FEdit as TDBEdit).CharCase;
 END
 ELSE BEGIN
  Result := (FEdit as TEdit).CharCase;
 END; 
END;

PROCEDURE TPieValidateEdit.SetCursor(Value: TCursor);
BEGIN
  FComboBox.Cursor := Value;
  FEdit.Cursor := Value;
END;

FUNCTION TPieValidateEdit.GetCursor: TCursor;
BEGIN
  Result := FEdit.Cursor;
END;

PROCEDURE TPieValidateEdit.SetDragCursor(Value: TCursor);
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  (FComboBox as TDBComboBox).DragCursor := Value;
  (FEdit as TDBEdit).DragCursor := Value;
 END
 ELSE BEGIN
  (FComboBox as TComboBox).DragCursor := Value;
  (FEdit as TEdit).DragCursor := Value;
 END;
END;

FUNCTION TPieValidateEdit.GetDragCursor: TCursor;
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  Result := (FEdit as TDBEdit).DragCursor;
 END
 ELSE BEGIN
  Result := (FEdit as TEdit).DragCursor;
 END; 
END;

PROCEDURE TPieValidateEdit.SetDragMode(Value: TDragMode);
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  (FComboBox as TDBComboBox).DragMode := Value;
  (FEdit as TDBEdit).DragMode := Value;
 END
 ELSE BEGIN
  (FComboBox as TComboBox).DragMode := Value;
  (FEdit as TEdit).DragMode := Value;
 END;
END;

FUNCTION TPieValidateEdit.GetDragMode: TDragMode;
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  Result := (FEdit as TDBEdit).DragMode;
 END
 ELSE BEGIN
  Result := (FEdit as TEdit).DragMode;
 END; 
END;

PROCEDURE TPieValidateEdit.SetFEnabled(Value: Boolean);
BEGIN
  FComboBox.Enabled := Value;
  FEdit.Enabled := Value;
END;

FUNCTION TPieValidateEdit.GetFEnabled: Boolean;
BEGIN
  Result := FEdit.Enabled;
END;

PROCEDURE TPieValidateEdit.SetFilterIndex(Value: Integer);
BEGIN
  FComboBox.ItemIndex := Value;
END;

FUNCTION TPieValidateEdit.GetFilterIndex: Integer;
BEGIN
  Result := FComboBox.ItemIndex;
END;

PROCEDURE TPieValidateEdit.SetEditColor(Value: TColor);
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  (FComboBox as TDBComboBox).Color := Value;
  (FEdit as TDBEdit).Color := Value;
 END
 ELSE BEGIN
  (FComboBox as TComboBox).Color := Value;
  (FEdit as TEdit).Color := Value;
 END; 
END;

FUNCTION TPieValidateEdit.GetEditColor: TColor;
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  Result := (FEdit as TDBEdit).Color;
 END
 ELSE BEGIN
  Result := (FEdit as TEdit).Color;
 END;
END;

PROCEDURE TPieValidateEdit.SetHideSelection(Value: Boolean);
BEGIN
  IF ClassType = TPieDBExtValEdit
    THEN {nothing}
    ELSE (FEdit as TEdit).HideSelection := Value;
END;

FUNCTION TPieValidateEdit.GetHideSelection: Boolean;
BEGIN
  IF ClassType = TPieDBExtValEdit
    THEN Result := FALSE
    ELSE Result := (FEdit as TEdit).HideSelection;
END;

PROCEDURE TPieValidateEdit.SetMaxLength(Value: Integer);
BEGIN
  IF ClassType = TPieDBExtValEdit THEN BEGIN
    (FEdit as TDBEdit).MaxLength := Value;
  END
  ELSE BEGIN
    (FComboBox as TComboBox).MaxLength := Value;
    (FEdit as TEdit).MaxLength := Value;
  END;
END;

FUNCTION TPieValidateEdit.GetMaxLength: Integer;
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
   Result := (FEdit as TDBEdit).MaxLength;
 END
 ELSE BEGIN
   Result := (FEdit as TEdit).MaxLength;
 END;
END;

PROCEDURE TPieValidateEdit.SetOEMConvert(Value: Boolean);
BEGIN
  IF ClassType = TPieDBExtValEdit THEN BEGIN
    ShowMessage('TPieDBExtValEdit untersttzt kein OEMConvert');
  END
  ELSE BEGIN
    (FEdit as TEdit).OEMConvert := Value;
  END;
END;

FUNCTION TPieValidateEdit.GetOEMConvert: Boolean;
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
   Result := FALSE;
 END
 ELSE BEGIN
   Result := (FEdit as TEdit).OEMConvert;
 END;
END;

PROCEDURE TPieValidateEdit.SetPasswordChar(Value: Char);
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  (FEdit as TDBEdit).PasswordChar := Value;
 END
 ELSE BEGIN
  (FEdit as TEdit).PasswordChar := Value;
 END;
END;

FUNCTION TPieValidateEdit.GetPasswordChar: Char;
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
   Result := (FEdit as TDBEdit).PasswordChar;
 END
 ELSE BEGIN
   Result := (FEdit as TEdit).PasswordChar;
 END;
END;

PROCEDURE TPieValidateEdit.SetReadOnly(Value: Boolean);
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  IF Value THEN (FComboBox as TDBComboBox).Style := csDropDownList
           ELSE (FComboBox as TDBComboBox).Style := csDropDown;
  (FEdit as TDBEdit).ReadOnly := Value;
 END
 ELSE BEGIN
  IF Value THEN (FComboBox as TComboBox).Style := csDropDownList
           ELSE (FComboBox as TComboBox).Style := csDropDown;
  (FEdit as TEdit).ReadOnly := Value;
 END;
END;

FUNCTION TPieValidateEdit.GetReadOnly: Boolean;
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  Result := (FEdit as TDBEdit).ReadOnly;
 END
 ELSE BEGIN
  Result := (FEdit as TEdit).ReadOnly;
 END; 
END;

function TPieValidateEdit.GetSelStart: Integer;
begin
  IF FValEditTyp = etFilter THEN Result := FComboBox.SelStart ELSE Result := FEdit.SelStart;
end;

procedure TPieValidateEdit.SetSelStart(Value: Integer);
begin
  FComboBox.SelStart := Value;
  FEdit.SelStart := Value;
end;

function TPieValidateEdit.GetSelLength: Integer;
begin
  Result := FEdit.SelLength;
end;

procedure TPieValidateEdit.SetSelLength(Value: Integer);
begin
  FComboBox.SelLength := Value;
  FEdit.SelLength := Value;
end;

function TPieValidateEdit.GetSelText: String;
begin
  IF FValEditTyp = etFilter THEN Result := FComboBox.SelText ELSE Result := FEdit.SelText;
end;

procedure TPieValidateEdit.SetSelText(Const Value: String);
begin
  FComboBox.SelText := Value;
  FEdit.SelText := Value;
end;

PROCEDURE TPieValidateEdit.SetText(Value: TCaption);
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  (FComboBox as TDBComboBox).Text := Value;
 END
 ELSE BEGIN
  (FComboBox as TComboBox).Text := Value;
 END;
  FEdit.Text := Value;
END;

FUNCTION TPieValidateEdit.GetText: TCaption;
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  IF FValEditTyp = etFilter
    THEN Result := (FComboBox as TDBComboBox).Text
    ELSE Result := FEdit.Text;
 END
 ELSE BEGIN
  IF FValEditTyp = etFilter
    THEN Result := (FComboBox as TComboBox).Text
    ELSE Result := FEdit.Text;
 END;
END;

PROCEDURE TPieValidateEdit.EditClick(Sender: TObject);
BEGIN
  IF assigned(OnClick) THEN OnClick(Self);
END;

PROCEDURE TPieValidateEdit.EditDblClick(Sender: TObject);
BEGIN
  IF assigned(OnDblClick) THEN OnDblClick(Self);
END;

PROCEDURE TPieValidateEdit.EditDragDrop(Sender, Source: TObject; X, Y: Integer);
BEGIN
  IF assigned(OnDragDrop) THEN OnDragDrop(Self, Source, X, Y);
END;

PROCEDURE TPieValidateEdit.EditDragOver(Sender, Source: TObject; X, Y: Integer;
          State: TDragState; var Accept: Boolean);
BEGIN
  IF assigned(OnDragOver) THEN OnDragOver(Self, Source, X, Y, State, Accept);
END;

{$IFDEF D4_OR_HIGHER}
PROCEDURE TPieValidateEdit.EditEndDock(Sender, Target: TObject; X, Y: Integer);
BEGIN
  IF assigned(OnEndDock) THEN OnEndDock(Self, Target, X, Y);
END;
{$ENDIF}

PROCEDURE TPieValidateEdit.EditEndDrag(Sender, Target: TObject; X, Y: Integer);
BEGIN
  IF assigned(OnEndDrag) THEN OnEndDrag(Self, Target, X, Y);
END;

PROCEDURE TPieValidateEdit.EditEnter(Sender: TObject);
BEGIN
  IF assigned(OnEnter) THEN OnEnter(Self);
END;

PROCEDURE TPieValidateEdit.EditExit(Sender: TObject);
BEGIN
  IF assigned(OnExit) THEN OnExit(Self);
END;

PROCEDURE TPieValidateEdit.EditKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
BEGIN
  IF assigned(OnKeyDown) THEN OnKeyDown(Self, Key, Shift);
END;

PROCEDURE TPieValidateEdit.EditKeyPress(Sender: TObject; var Key: Char);
BEGIN
  IF assigned(OnKeyPress) THEN OnKeyPress(Self, Key);
END;

PROCEDURE TPieValidateEdit.EditKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
BEGIN
  IF assigned(OnKeyUp) THEN OnKeyUp(Self, Key, Shift);
END;

PROCEDURE TPieValidateEdit.EditMouseDown(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer);
BEGIN
  IF assigned(OnMouseDown) THEN OnMouseDown(Self, Button, Shift, X, Y);
END;

PROCEDURE TPieValidateEdit.EditMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
BEGIN
  IF assigned(OnMouseMove) THEN OnMouseMove(Self, Shift, X, Y);
END;

PROCEDURE TPieValidateEdit.EditMouseUp(Sender: TObject; Button: TMouseButton;
                                       Shift: TShiftState; X, Y: Integer);
BEGIN
  IF assigned(OnMouseUp) THEN OnMouseUp(Self, Button, Shift, X, Y);
END;

{$IFDEF D4_OR_HIGHER}
PROCEDURE TPieValidateEdit.EditStartDock(Sender: TObject; var DragObject: TDragDockObject);
BEGIN
  IF assigned(OnStartDock) THEN OnStartDock(Self, DragObject);
END;
{$ENDIF}

PROCEDURE TPieValidateEdit.EditStartDrag(Sender: TObject; var DragObject: TDragObject);
BEGIN
  IF assigned(OnStartDrag) THEN OnStartDrag(Self, DragObject);
END;

PROCEDURE TPieValidateEdit.Error(Art: Byte);
VAR
  S: string;
  I: Word;
  Action: TPieValidateEditErrorAction;
BEGIN
  Action := pveaGerman;
  IF assigned(FOnValidateError) THEN FOnValidateError(Self, Art, Action);
  IF Action = pveaGerman THEN BEGIN
    CASE Art OF
    0: S := 'Ungltige Zeicheneingabe!';
    1: BEGIN
       CASE FValEditTyp OF
       etLongInt : S := 'Ungltige Ganzzahl! Erwartet: ' +
                        Str_Number(round(FMinWert)) + ' ... ' +
                        Str_Number(round(FMaxWert));
       etDouble,
       etExponent: S := 'Ungltige Dezimalzahl! Erwartet: ' +
                        S_N(FMinWert,5,2) + ' ... ' +
                        S_N(FMaxWert,5,2);
       etHex     : S := 'Ungltige Hexadezimalzahl! Erwartet: ' +
                        IntToHex(round(FMinWert),10) + ' ... ' +
                        IntToHex(round(FMaxWert),10);
       etBin     : S := 'Ungltige Binrzahl! Erwartet: ' +
                        Str_Number(round(FMinWert)) + ' ... ' +
                        Str_Number(round(FMaxWert));
       etFilter  : BEGIN
                   S := 'Ungltige Zeichenkombination! Erwartet: ';
                   IF FFilter.Count > 0 THEN BEGIN
                     FOR I:=1 TO FFilter.Count DO
                     S := S + FFilter.Strings[I-1] + ', ';
                     Delete(S, length(S)-1, 2); {letztes Komma lschen}
                   END ELSE S := S + '???';
                   END;
       END;
       END;
    END;
    MessageDlg('Eingabefehler! ' + S, mtWarning, [mbOK], 0);
  END;
  IF Action = pveaEnglish THEN BEGIN
    CASE Art OF
    0: S := 'Invalid character!';
    1: BEGIN
       CASE FValEditTyp OF
       etLongInt : S := 'Invalid number! Expects: ' +
                        Str_Number(round(FMinWert)) + ' ... ' +
                        Str_Number(round(FMaxWert));
       etDouble,
       etExponent: S := 'Invalid decimal number! Expects: ' +
                        S_N(FMinWert,5,2) + ' ... ' +
                        S_N(FMaxWert,5,2);
       etHex     : S := 'Invalid hexadecimal number! Expects: ' +
                        IntToHex(round(FMinWert),10) + ' ... ' +
                        IntToHex(round(FMaxWert),10);
       etBin     : S := 'Invalid binary number! Expects: ' +
                        Str_Number(round(FMinWert)) + ' ... ' +
                        Str_Number(round(FMaxWert));
       etFilter  : BEGIN
                   S := 'Invalid entry! Expects: ';
                   IF FFilter.Count > 0 THEN BEGIN
                     FOR I:=1 TO FFilter.Count DO
                     S := S + FFilter.Strings[I-1] + ', ';
                     Delete(S, length(S)-1, 2); {letztes Komma lschen}
                   END ELSE S := S + '???';
                   END;
       END;
       END;
    END;
    MessageDlg('Input-mistakes! ' + S, mtWarning, [mbOK], 0);
  END;
END;

FUNCTION TPieValidateEdit.IsValid : BOOLEAN;
VAR
  Gueltig: Boolean;
BEGIN
 IF ClassType = TPieDBExtValEdit THEN BEGIN
  IF FValEditTyp = etFilter THEN Gueltig := PValidator.IsValid((FComboBox as TDBComboBox).Text)
                            ELSE Gueltig := PValidator.IsValid(FEdit.Text);
 END
 ELSE BEGIN
  IF FValEditTyp = etFilter THEN Gueltig := PValidator.IsValid((FComboBox as TComboBox).Text)
                            ELSE Gueltig := PValidator.IsValid(FEdit.Text);
 END;
  IsValid := Gueltig;
END;


{ Ruft Error auf, wenn der Focus gewechselt wird, leider auch, wenn der
  Cancelbutton gedrckt wird }
procedure TPieValidateEdit.DoExit;
VAR
  gueltig: Boolean;
  Z: Double;
begin
  {normale Zeichenberprfung}
  Gueltig := IsValid;
  IF NOT(Gueltig) AND FValMeldung AND
    NOT(csDesigning IN ComponentState) THEN Error(0)
  {Min-Max-berprfung}
  ELSE IF FPruefen THEN BEGIN
    Z := 0;
    CASE FValEditTyp OF
      etLongInt  : Z := GetLongInt;
      etDouble   : Z := GetDouble;
      etExponent : Z := GetExponent;
      etHex      : Z := GetHex;
      etBin      : Z := GetBin;
    END;
    CASE FValEditTyp OF
    etString: Gueltig := TRUE;
    etFilter: BEGIN
                IF ClassType = TPieDBExtValEdit THEN BEGIN
                  Gueltig := FFilter.IndexOf((FComboBox as TDBComboBox).Text) >= 0;
                END
                ELSE BEGIN
                  Gueltig := FFilter.IndexOf((FComboBox as TComboBox).Text) >= 0;
                END;
              END;
    ELSE BEGIN
      Gueltig := (Z>=FMinWert) AND (Z<=FMaxWert);
      IF Trim(FEdit.Text) = '' THEN FEdit.Text := '0';
    END;
    END;
    IF NOT(Gueltig) THEN Error(1);
  END;
  IF Gueltig AND Assigned(OnValidExit) THEN OnValidExit(Self);
  IF Gueltig THEN inherited DoExit ELSE SetFocus;
END;

{ Reagiert auf nderungen im Filter }
PROCEDURE TPieValidateEdit.FilterChange(Sender: TObject);
VAR
  OldText : string;
BEGIN
  OldText := Text;
  FComboBox.Items.Assign(FFilter);
  FComboBox.ItemIndex := FComboBox.Items.IndexOf(OldText);
  IF (FComboBox.ItemIndex < 0) AND (FComboBox.Items.Count > 0)
    THEN FComboBox.ItemIndex := 0;
END;

{ Unterdrckt Fehleingaben, auch durch Einfgen aus der Zwischenablage }
PROCEDURE TPieValidateEdit.EditChange(Sender: TObject);
VAR OldText : String;
    OldSel  : INTEGER;
BEGIN
  inherited;
  OldSel := SelStart;
  Oldtext:=Text;
  IF NOT(PValidator.IsValidInput(OldText)) AND FValMeldung AND
  NOT(csDesigning IN ComponentState) THEN Error(0);
  Text:=OldText;
  IF (OldSel <= Length(Text)) THEN Selstart := Oldsel
                              ELSE SelStart := Length(Text);
  IF assigned(OnChange) THEN OnChange(Sender);
END;

procedure TPieValidateEdit.WMSize(var Message: TWMSize);
begin
  inherited;
  IF FWMSize_erlaubt THEN Berechne_Groesse;
end;

procedure TPieValidateEdit.Loaded;
begin
  inherited Loaded;
  Caption := '';
end;

PROCEDURE TPieValidateEdit.Berechne_Groesse;
BEGIN
  FComboBox.SetBounds(0,0,Width,Height);
  FEdit.SetBounds(0,0,Width,Height);
{  IF (csDesigning IN ComponentState) THEN Text := Name;}
  Caption := '';
END;
(*************************************************)
(******TPieExtValEdit*****************************)
(*************************************************)
Constructor TPieExtValEdit.Create(AOwner : TComponent);
BEGIN
  FWMSize_erlaubt := FALSE;
  inherited Create(AOwner);
  FEdit.Align := alNone;
  FComboBox.Align := alNone;
  CLabel := TLabel.Create(Self);
  ELabel := TPanel.Create(Self);
  GImage := TImage.Create(Self);
  FHeaderFont := TFont.Create;
  FEinheitsFont := TFont.Create;
  FPictureHeader := TPicture.Create;
  FPictureRange := TPicture.Create;
  FPictureHeader.OnChange := PictureChange;
  FPictureRange.OnChange := PictureChange;
  ELabel.Parent := Self;
  CLabel.Parent := Self;
  GImage.Parent := Self;
  Width := 144;
  Height := 40;
  GImage.OnMouseDown := ImageMouseDown;
  GImage.Cursor := crHandPoint;
  GImage.Stretch := TRUE;
  Erlaubt_zeigen := FALSE;
  BevelOuter := bvLowered;
  BevelInner := bvRaised;
  ELabel.BevelOuter := bvLowered;
  ELabel.BevelInner := bvRaised;
  CLabel.Transparent := TRUE;
  CLabel.FocusControl := FEdit;
  CLabel.AutoSize := FALSE;
  CLabel.WordWrap := TRUE;
  FHeader2Hint := TRUE;
  FHeader := '';
  FEinheit := '';
  FEinheitsbreite := 20;
  FEditHeight := 21;
  FBevelInner := bvRaised;
  FBevelOuter := bvLowered;
  FEinheitsBevelInner := bvRaised;
  FEinheitsBevelOuter := bvLowered;
  FHeaderFont.Assign(CLabel.Font);
  FHeaderFont.OnChange := HeaderFontChange;
  FEinheitsFont.Assign(ELabel.Font);
  FEinheitsFont.OnChange := EinheitsFontChange;
  FEinheitsPanelColor := ELabel.Color;
  FPictures := TRUE;
  FWMSize_erlaubt := TRUE;
  Berechne_Groesse;
  FPictureHeader.Bitmap.LoadFromResourceName(HInstance, 'PieExtValEdit1');
  FPictureRange.Bitmap.LoadFromResourceName(HInstance, 'PieExtValEdit2');
  GImage.Picture.Bitmap.Assign(FPictureHeader.Bitmap);
END;

DESTRUCTOR TPieExtValEdit.Destroy;
BEGIN
  TRY
    FHeaderFont.Free;
    FEinheitsFont.Free;
    FPictureHeader.Free;
    FPictureRange.Free;
(*  GImage.Free;    {nicht ntig, da dies selbst entfernt wird}
  ELabel.Free;
  CLabel.Free;*)
    inherited Destroy;
  EXCEPT
  END;
END;

PROCEDURE TPieExtValEdit.SetHeader(Value: string);
BEGIN
  IF Trim(Value) <> FHeader THEN BEGIN
    FHeader := Trim(Value);
    IF FHeader2Hint THEN Hint := FHeader;
    Berechne_Groesse;
  END;
END;

PROCEDURE TPieExtValEdit.SetHeader2Hint(Value: Boolean);
BEGIN
  IF Value <> FHeader2Hint THEN BEGIN
    FHeader2Hint := Value;
    IF FHeader2Hint THEN Hint := FHeader;
  END;
END;

PROCEDURE TPieExtValEdit.SetEinheit(Value: string);
BEGIN
  IF Trim(Value) <> FEinheit THEN BEGIN
    FEinheit := Trim(Value);
    Berechne_Groesse;
  END;
END;

PROCEDURE TPieExtValEdit.SetEinheitsbreite(Value: Integer);
BEGIN
  IF Value <> FEinheitsbreite THEN BEGIN
    FEinheitsbreite := Value;
    Berechne_Groesse;
  END;
END;

PROCEDURE TPieExtValEdit.SetPictures(Value: Boolean);
BEGIN
  IF Value <> FPictures THEN BEGIN
    FPictures := Value;
    Berechne_Groesse;
  END;
END;

PROCEDURE TPieExtValEdit.SetEditHeight(Value: Integer);
BEGIN
  IF Value <> FEditHeight THEN BEGIN
    FEditHeight := Value;
    Berechne_Groesse;
  END;
END;

PROCEDURE TPieExtValEdit.SetEinheitsBevelInner(Value: TPanelBevel);
BEGIN
  IF Value <> FEinheitsBevelInner THEN BEGIN
    FEinheitsBevelInner := Value;
    ELabel.BevelInner := FEinheitsBevelInner;
  END;
END;

PROCEDURE TPieExtValEdit.SetEinheitsBevelOuter(Value: TPanelBevel);
BEGIN
  IF Value <> FEinheitsBevelOuter THEN BEGIN
    FEinheitsBevelOuter := Value;
    ELabel.BevelOuter := FEinheitsBevelOuter;
  END;
END;

PROCEDURE TPieExtValEdit.SetHeaderFont(Value: TFont);
BEGIN
  FHeaderFont.Assign(Value);
  CLabel.Font.Assign(FHeaderFont);
END;

PROCEDURE TPieExtValEdit.HeaderFontChange(Sender: TObject);
BEGIN
  CLabel.Font.Assign(FHeaderFont);
END;

PROCEDURE TPieExtValEdit.SetEinheitsFont(Value: TFont);
BEGIN
  FEinheitsFont.Assign(Value);
  ELabel.Font.Assign(FEinheitsFont);
END;

PROCEDURE TPieExtValEdit.EinheitsFontChange(Sender: TObject);
BEGIN
  ELabel.Font.Assign(FEinheitsFont);
END;

PROCEDURE TPieExtValEdit.SetEinheitsPanelColor(Value: TColor);
BEGIN
  IF FEinheitsPanelColor <> Value THEN BEGIN
    FEinheitsPanelColor := Value;
    ELabel.Color := FEinheitsPanelColor;
  END;
END;

procedure TPieExtValEdit.SetPictureHeader(Value: TPicture);
begin
  FPictureHeader.Assign(Value);
  IF NOT(Erlaubt_zeigen) THEN GImage.Picture.Assign(FPictureHeader);
  GImage.Invalidate;
end;

procedure TPieExtValEdit.SetPictureRange(Value: TPicture);
begin
  FPictureRange.Assign(Value);
  IF Erlaubt_zeigen THEN GImage.Picture.Assign(FPictureRange);
  GImage.Invalidate;
end;

PROCEDURE TPieExtValEdit.PictureChange(Sender: TObject);
BEGIN
  IF Erlaubt_zeigen THEN GImage.Picture.Assign(FPictureRange)
                    ELSE GImage.Picture.Assign(FPictureHeader);
END;

PROCEDURE TPieExtValEdit.ImageMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
VAR
  S: string;
  I: Integer;
BEGIN
  Erlaubt_zeigen := NOT(Erlaubt_zeigen);
  IF Erlaubt_zeigen THEN BEGIN
    CASE FValEditTyp OF
    etLongInt : S := Str_Number(round(FMinWert)) + ' ... ' +
                     Str_Number(round(FMaxWert)) + ' ' + FEinheit;
    etDouble,
    etExponent: S := S_N(FMinWert,5,2) + ' ... ' +
                     S_N(FMaxWert,5,2) + ' ' + FEinheit;
    etHex     : S := IntToHex(round(FMinWert),10) + ' ... ' +
                     IntToHex(round(FMaxWert),10) + ' ' + FEinheit;
    etBin     : S := Str_Number(round(FMinWert)) + ' ... ' +
                     Str_Number(round(FMaxWert)) + ' ' + FEinheit;
    etFilter  : BEGIN
                  S := '';
                  IF FFilter.Count > 0 THEN BEGIN
                    FOR I:=1 TO FFilter.Count DO
                      S := S + FFilter.Strings[I-1] + ', ';
                    Delete(S, length(S)-1, 2); {letztes Komma lschen}
                  END ELSE S := S + '???';
                  S := S + ' ' + FEinheit;
                END;
    END;
    CLabel.Caption := S;
    GImage.Picture.Assign(FPictureRange);
  END
  ELSE BEGIN
    CLabel.Caption := FHeader;
    GImage.Picture.Assign(FPictureHeader);
  END;
  SetFocus;
END;

PROCEDURE TPieExtValEdit.DoExit;
BEGIN
  inherited DoExit;
  IF Erlaubt_zeigen THEN BEGIN
    Erlaubt_zeigen := FALSE;
    CLabel.Caption := FHeader;
    GImage.Picture.Assign(FPictureHeader);
  END;
END;

PROCEDURE TPieExtValEdit.SetFEnabled(Value: Boolean);
BEGIN
  inherited SetFEnabled(Value);
  GImage.Enabled := Value;
END;

PROCEDURE TPieExtValEdit.Wertebereich_zeigen;
BEGIN      {aktuelle Min-Max-Grenzen zeigen}
  DoExit;
  ImageMouseDown(Self, mbLeft, [ssLeft], 0, 0);
END;

procedure TPieExtValEdit.Loaded;
begin
  inherited Loaded;
  IF Erlaubt_zeigen THEN GImage.Picture.Assign(FPictureRange)
                    ELSE GImage.Picture.Assign(FPictureHeader);
end;

PROCEDURE TPieExtValEdit.Berechne_Groesse;
VAR
  Rand, H, Headerhoehe: Integer;
BEGIN
  IF FWMSize_erlaubt THEN BEGIN
  Rand := BorderWidth + BevelWidth;
  IF BorderStyle = bsSingle THEN Rand := Rand+1;

  FComboBox.SetBounds (Rand+1,
                   Height-FEditHeight-Rand-1,
                   Width-FEinheitsbreite-2*Rand-2,
                   FEditHeight);
  FEdit.SetBounds (Rand+1,
                   Height-FEditHeight-Rand-1,
                   Width-FEinheitsbreite-2*Rand-2,
                   FEditHeight);
  {Header-Label}
  CLabel.Caption := FHeader;
  HeaderHoehe := Height-FEditHeight-2*Rand-2;
  CLabel.SetBounds(Rand+3,
                   Rand+1,
                   Width-2*Rand - 3 {links Luft}- 3{rechts Luft},
                   HeaderHoehe);
  IF FPictures THEN CLabel.Width := CLabel.Width - HeaderHoehe;
  {Einheits-Panel}
  ELabel.Caption := FEinheit;
  ELabel.Visible := FEinheitsbreite > 0;
  ELabel.SetBounds(Width-Rand-FEinheitsbreite-1,
                   Height-FEditHeight-Rand-1,
                   FEinheitsbreite,
                   FEditHeight);
  {Bcher-Bild}
  GImage.Visible := FPictures;
  H := HeaderHoehe-1;
  GImage.SetBounds(Width-Rand-H-3, Rand+2, H, H);
  IF (csDesigning IN ComponentState) AND NOT(GImage.Visible) THEN GImage.SetBounds(0,0,0,0);
  Caption := '';
  END;
END;

(*************************************************)
(******TPieDBExtValEdit***************************)
(*************************************************)
function TPieDBExtValEdit.GetDataSource: TDataSource;
begin
  Result := (FEdit as TDBEdit).DataSource;
end;

procedure TPieDBExtValEdit.SetDataSource(Value: TDataSource);
begin
  (FEdit as TDBEdit).DataSource := Value;
  (FComboBox as TDBComboBox).DataSource := Value;
end;

procedure TPieDBExtValEdit.SetDataField(const Value: string);
begin
  IF Value <> FDataField THEN BEGIN
    FDataField := Value;
    IF FEdit.Visible THEN (FEdit as TDBEdit).DataField := Value
                     ELSE (FEdit as TDBEdit).DataField := '';
    IF FComboBox.Visible THEN (FComboBox as TDBComboBox).DataField := Value
                         ELSE (FComboBox as TDBComboBox).DataField := '';
  END;
end;

function TPieDBExtValEdit.GetField: TField;
begin
  IF FEdit.Visible THEN Result := (FEdit as TDBEdit).Field
                   ELSE Result := (FComboBox as TDBComboBox).Field;
end;



{ ************************************************* }
end.

