{$I PIETOOLS.INC}
{ Autor: Ingolf Pietschmann.
  Dieser Quelltext ist Freeware. Die Verwendung und Weitergabe dieser Sourcen zu
  privaten nicht kommerziellen Zwecken ist ausdrcklich erwnscht.
  Die Verwendung zu kommerziellen Zwecken ist nur mit Erlaubnis des Autors
  gestattet. Den Autor knnen Sie unter "Support@Pie-Tools.de" erreichen.

  These sources are freeware. The usage and distribution of these sources for
  private, not commercial purposes is explicit desired.
  The usage for commercial purposes is only permitted in agreement of the author.
  The author can be reached by "Support@Pie-Tools.de".
}
unit Piezln1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, PieZln2, StdCtrls;

type
  TPieZeilenDialog = class(TComponent)
  private
    FEditMask, FLabeltext, FZeilentext, FUeberschrift,
    FOktext, FAbbrechentext: string;
    FZeilenlaenge: Word;
    FPasswordChar: char;
    FCharCase: TEditCharCase;
    FKommazuPunkt: Boolean;
  public
    Constructor Create(AOwner: TComponent); override;
    function Execute: Boolean;
  published
    property Editmask: string read FEditMask write FEditMask;
    property PasswordChar: char read FPasswordChar write FPasswordChar;
    property Labeltext: string read FLabeltext write FLabeltext;
    property Ueberschrift: string read FUeberschrift write FUeberschrift;
    property Zeilenlaenge: word read FZeilenlaenge write FZeilenlaenge default 0;
    property Zeilentext: string read FZeilentext write FZeilentext;
    property Oktext: string read FOktext write FOktext;
    property Abbrechentext: string read FAbbrechentext write FAbbrechentext;
    property CharCase: TEditCharCase read FCharCase write FCharCase default ecNormal;
    property KommazuPunkt: Boolean read FKommazuPunkt write FKommazuPunkt default TRUE;
  end;



implementation

Constructor TPieZeilenDialog.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  OkText := '##&Ok';
  Abbrechentext := '##&Abbrechen';
END;

function TPieZeilenDialog.Execute: Boolean;
begin
     { Create dialog in memory }
     Zeilendialog := TZeilendialog.Create(Application);
     { Set dialog strings }
     Zeilendialog.BitBtn1.Caption := FOktext;
     Zeilendialog.BitBtn2.Caption := FAbbrechentext;
     Zeilendialog.Label1.Caption := FLabeltext;
     Zeilendialog.MaskEdit1.Text := FZeilentext;
     Zeilendialog.MaskEdit1.MaxLength := FZeilenlaenge;
     Zeilendialog.MaskEdit1.EditMask := FEditMask;
     Zeilendialog.MaskEdit1.PasswordChar := FPasswordChar;
     Zeilendialog.MaskEdit1.CharCase := FCharCase;
     Zeilendialog.Caption := FUeberschrift;
     Zeilendialog.KommazuPunkt := FKommazuPunkt;
     {Dialog ausfhren}
     try
       Result := (Zeilendialog.ShowModal = IDOK);
       FZeilentext := Zeilendialog.MaskEdit1.Text;
     finally
       Zeilendialog.Free;
     end;
end;

end.
