{$I PIETOOLS.INC}
{ Autor: Ingolf Pietschmann.
  Dieser Quelltext ist Freeware. Die Verwendung und Weitergabe dieser Sourcen zu
  privaten nicht kommerziellen Zwecken ist ausdrcklich erwnscht.
  Die Verwendung zu kommerziellen Zwecken ist nur mit Erlaubnis des Autors
  gestattet. Den Autor knnen Sie unter "Support@Pie-Tools.de" erreichen.
  Homepage unter: http://www.Pie-Tools.de/

  These sources are freeware. The usage and distribution of these sources for
  private, not commercial purposes is explicit desired.
  The usage for commercial purposes is only permitted in agreement of the author.
  The author can be reached by "Support@Pie-Tools.de".
  Homepage: http://www.Pie-Tools.de/
}
unit PieTransparentControls;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, PieHerk;

type
  TPieDummyControl = class(TWinControl)
  private
  protected
  public
    property OnEnter;
    property OnExit;
  published
  end;

  TPieFocusStyle = (pfsNormal, pfsLine, pfsFill);

  TPieTransparentControl = class(TCustomLabel)
  private
    { Private-Deklarationen }
    FBackground     : TPicture;
    FDummyControl   : TPieDummyControl;
    FFocusColor     : TColor;
    FFocused        : Boolean;
    FFocusStyle     : TPieFocusStyle;
    FShowBackground : Boolean;
    FTabOrder       : Integer;
    FOnEnter        : TNotifyEvent;
    function GetTabOrder: Integer;
    function GetTabStop: Boolean;
    procedure BackGroundChange(Sender: TObject);
    procedure CMDialogChar(var Message: TCMDialogChar); message CM_DIALOGCHAR;
    procedure DummyControlEnter(Sender: TObject);
    procedure DummyControlExit(Sender: TObject);
    procedure DummyProc(VAR Message: TMessage); virtual;
    procedure PaintBackground(ACanvas: TCanvas; ARect: TRect);
    procedure SetBackground(Value: TPicture);
    procedure SetFocusColor(Value: TColor);
    procedure SetFocusStyle(Value: TPieFocusStyle);
    procedure SetShowBackground(Value: Boolean);
    procedure SetTabOrder(Value: Integer);
    procedure SetTabStop(Value: Boolean);
  protected
    { Protected-Deklarationen }
    procedure Click; override;
    procedure Loaded; override;
    procedure WndProc(VAR Message: TMessage); override;
    procedure SetName(const NewName: TComponentName); override;
    property Background: TPicture read FBackground write SetBackground;
    property ShowBackground: Boolean read FShowBackground write SetShowBackground default FALSE;
  public
    { Public-Deklarationen }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published-Deklarationen }
    property FocusColor: TColor read FFocusColor write SetFocusColor default clBlack;
    property FocusStyle: TPieFocusStyle read FFocusStyle write SetFocusStyle default pfsNormal;
    property TabOrder: Integer read GetTabOrder write SetTabOrder;
    property TabStop: Boolean read GetTabStop write SetTabStop default TRUE;
    property OnEnter: TNotifyEvent read FOnEnter write FOnEnter;
    property Align;
    property Alignment;
    property Anchors;
    property BiDiMode;
    property Caption;
    property Color;
    property Constraints;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property Font;
    property ParentBiDiMode;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowAccelChar;
    property ShowHint;
    property Transparent;
    property Layout;
    property Visible;
    property WordWrap;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;
  end;

  TPieButtonEffect = (pbeNone, pbeRaised, pbeSunken, pbeBump, pbeEtched);
  TPieCheckBoxPosition = (pcbpLeftTop, pcbpLeftCenter,
    pcbpLeftBottom, pcbpRightTop, pcbpRightCenter,
    pcbpRightBottom, pcbpCenterTop, pcbpCenterBottom);

  TPieCheckBox = class(TPieTransparentControl)
  private
    { Private-Deklarationen }
    FButtonEffect: TPieButtonEffect;
    FChecked: Boolean;
    FCheckBoxPosition: TPieCheckBoxPosition;
    FCheckBoxSize: TPieCheckBoxSize;
    FCheckBoxStyle: TPieCheckBoxStyle;
    FCheckBoxTransparent: Boolean;
    FHookStyle: TPieHookStyle;
    FHookColor: TColor;
    procedure DummyProc(VAR Message: TMessage); override;
    procedure SetButtonEffect(Value: TPieButtonEffect);
    procedure SetChecked(Value: Boolean);
    procedure SetCheckBoxPosition(Value: TPieCheckBoxPosition);
    procedure SetCheckBoxSize(Value: TPieCheckBoxSize);
    procedure SetCheckBoxStyle(Value: TPieCheckBoxStyle);
    procedure SetCheckBoxTransparent(Value: Boolean);
    procedure SetHookStyle(Value: TPieHookStyle);
    procedure SetHookColor(Value: TColor);
  protected
    { Protected-Deklarationen }
    procedure Paint; override;
    procedure Click; override;
  public
    { Public-Deklarationen }
    constructor Create(AOwner: TComponent); override;
  published
    { Published-Deklarationen }
    property ButtonEffect: TPieButtonEffect read FButtonEffect write SetButtonEffect default pbeNone;
    property Checked: Boolean read FChecked write SetChecked default FALSE;
    property CheckBoxPosition: TPieCheckBoxPosition read FCheckBoxPosition write SetCheckBoxPosition default pcbpLeftTop;
    property CheckBoxSize: TPieCheckBoxSize read FCheckBoxSize write SetCheckBoxSize default pcbsNormal;
    property CheckBoxStyle: TPieCheckBoxStyle read FCheckBoxStyle write SetCheckBoxStyle default pcbsSunken;
    property CheckBoxTransparent: Boolean read FCheckBoxTransparent write SetCheckBoxTransparent default FALSE;
    property HookStyle: TPieHookStyle read FHookStyle write SetHookStyle default phsHook;
    property HookColor: TColor read FHookColor write SetHookColor default clBtnText;
  end;

  TPieButton = class(TPieTransparentControl)
  private
    { Private-Deklarationen }
    FButtonLayout: TButtonLayout;
    FGlyph      : TPicture;
    FDown       : Boolean;
    FMargin     : Integer;
    FSpacing    : Integer;
    FModalResult: TModalResult;
    procedure DummyProc(VAR Message: TMessage); override;
    PROCEDURE SetButtonLayout(Value: TButtonLayout);
    PROCEDURE SetGlyph(Value: TPicture);
    PROCEDURE SetMargin(Value: Integer);
    PROCEDURE SetSpacing(Value: Integer);
    PROCEDURE GlyphChange(Sender: TObject);
  protected
    { Protected-Deklarationen }
    procedure Click; override;
    procedure Paint; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
  public
    { Public-Deklarationen }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published-Deklarationen }
    property ButtonLayout: TButtonLayout read FButtonLayout write SetButtonLayout default blGlyphLeft;
    property Glyph: TPicture read FGlyph write SetGlyph;
    property Margin: Integer read FMargin write SetMargin default 2;
    property ModalResult: TModalResult read FModalResult write FModalResult default 0;
    property Spacing: Integer read FSpacing write SetSpacing default 2;
    property Alignment default taCenter;
    property Background;
    property Layout default tlCenter;
    property ShowBackground;
  end;


implementation

//*********** TPieTransparentControl ********************
constructor TPieTransparentControl.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  AutoSize := FALSE;
  FFocusColor := clBlack;
  FFocusStyle := pfsNormal;
  FFocused := FALSE;
  FTabOrder := 0;
  FDummyControl := TPieDummyControl.Create(Self);
  FDummyControl.Parent := AOwner as TWinControl;
  FDummyControl.TabStop := TRUE;
  FDummyControl.OnEnter := DummyControlEnter;
  FDummyControl.OnExit := DummyControlExit;
  FDummyControl.WindowProc := DummyProc;
  FBackground := TPicture.Create;
  FBackground.OnChange := BackgroundChange;
  FShowBackground := FALSE;
  FOnEnter := NIL;
end;

destructor TPieTransparentControl.Destroy;
begin
  FBackground.Free;
  FDummyControl.OnEnter := NIL;
  FDummyControl.OnExit := NIl;
  inherited Destroy;
end;

procedure TPieTransparentControl.Loaded;
BEGIN
  inherited;
  FDummyControl.Name := Name + 'Focus';
  FDummyControl.Parent := Parent;
  FDummyControl.TabOrder := FTabOrder;
END;

procedure TPieTransparentControl.SetName(const NewName: TComponentName);
BEGIN
  inherited SetName(NewName);
  FDummyControl.Name := Name + 'Focus';
END;

procedure TPieTransparentControl.DummyControlEnter(Sender: TObject);
BEGIN
  FFocused := TRUE;
  IF assigned(FOnEnter) THEN FOnEnter(Self);
  Invalidate;
END;

procedure TPieTransparentControl.DummyControlExit(Sender: TObject);
BEGIN
  FFocused := FALSE;
  Invalidate;
END;

procedure TPieTransparentControl.WndProc(VAR Message: TMessage);
BEGIN
  inherited WndProc(Message);
END;

procedure TPieTransparentControl.DummyProc(VAR Message: TMessage);
BEGIN
  FDummyControl.WndProc(Message);
END;

procedure TPieTransparentControl.CMDialogChar(var Message: TCMDialogChar);
begin
  IF Enabled and ShowAccelChar and
    IsAccel(Message.CharCode, Caption) then
    with FDummyControl do
      if CanFocus then begin
        SetFocus;
        Message.Result := 1;
      end;
end;

function TPieTransparentControl.GetTabOrder: Integer;
BEGIN
  Result := FDummyControl.TabOrder;
END;

procedure TPieTransparentControl.SetTabOrder(Value: Integer);
BEGIN
  FTabOrder := Value;
  FDummyControl.TabOrder := Value;
END;

function TPieTransparentControl.GetTabStop: Boolean;
BEGIN
  Result := FDummyControl.TabStop;
END;

procedure TPieTransparentControl.SetTabStop(Value: Boolean);
BEGIN
  FDummyControl.TabStop := Value;
END;

procedure TPieTransparentControl.Click;
begin
  FDummyControl.SetFocus;
  Invalidate;
  inherited Click;
end;

procedure TPieTransparentControl.SetBackground(Value: TPicture);
BEGIN
  FBackground.Assign(Value);
  IF FShowBackground THEN Repaint;
END;

procedure TPieTransparentControl.BackgroundChange(Sender: TObject);
BEGIN
  IF FShowBackground THEN Repaint;
END;

procedure TPieTransparentControl.SetFocusStyle(Value: TPieFocusStyle);
BEGIN
  IF Value <> FFocusStyle THEN FFocusStyle := Value;
  IF FFocused THEN Invalidate;
END;

procedure TPieTransparentControl.SetFocusColor(Value: TColor);
BEGIN
  IF Value <> FFocusColor THEN FFocusColor := Value;
  IF FFocused THEN Invalidate;
END;

procedure TPieTransparentControl.SetShowBackground(Value: Boolean);
BEGIN
  IF FShowBackground <> Value THEN BEGIN
    FShowBackground := Value;
    Invalidate;
  END;
END;

procedure TPieTransparentControl.PaintBackground(ACanvas: TCanvas; ARect: TRect);
VAR
  CR, R: TRect;
  B, H, I, J: Integer;
  P : TPicture;
  Pos1: TRect; {Position des gesamten Pattern im Canvas}
  Pos2: TRect; {Position des darzustellenden Teilpattern im Pattern}
  Malen: Boolean;
BEGIN
  IF Assigned(FBackGround)  AND Assigned(FBackGround.Graphic) THEN BEGIN
    P := TPicture.Create;
    TRY
      P.Assign(FBackGround);
      CR := ARect;
      R.Left := 0;
      R.Top := 0;
      R.Right := ARect.Right - ARect.Left;
      R.Bottom := ARect.Bottom - ARect.Top;
      H := P.Graphic.Height;
      B := P.Graphic.Width;
      IF (H>0) AND (B>0) THEN BEGIN

        FOR I := 0 TO ((CR.Right - CR.Left) DIV B) DO
        FOR J := 0 TO ((CR.Bottom - CR.Top) DIV H) DO BEGIN
          Pos1 := Rect(I*B, J*H, (I+1)*B, (J+1)*H);
          Malen := (Pos1.Left < R.Right) AND (Pos1.Right > R.Left) AND
                   (Pos1.Top < R.Bottom) AND (Pos1.Bottom > R.Top);

          IF Malen THEN BEGIN
            Pos2 := Rect(R.Left-I*B, R.Top-J*H, R.Right-I*B, R.Bottom-J*H);
            IF Pos2.Left   < 0 THEN Pos2.Left   := 0;
            IF Pos2.Top    < 0 THEN Pos2.Top    := 0;
            IF Pos2.Right  > B THEN Pos2.Right  := B;
            IF Pos2.Bottom > H THEN Pos2.Bottom := H;

            IF (Pos2.Left > 0) OR (Pos2.Top > 0) THEN
            BitBlt(P.Bitmap.Canvas.Handle, 0, 0,
                  (Pos2.Right-Pos2.Left),
                  (Pos2.Bottom-Pos2.Top),
                   P.Bitmap.Canvas.Handle, Pos2.Left, Pos2.Top,
                   srcCopy);

            P.Graphic.Width := Pos2.Right-Pos2.Left;
            P.Graphic.Height := Pos2.Bottom-Pos2.Top;
            ACanvas.Draw(Pos1.Left + Pos2.Left + ARect.Left,
                         Pos1.Top  + Pos2.Top  + ARect.Top,
                         P.Graphic);
            P.Assign(FBackGround);
          END;
        END;

      END;  {IF (H>0) AND ...}
    FINALLY
      P.Free;
    END;
  END;
END;

//*********** TPieCheckBox ********************
constructor TPieCheckBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width := 97;
  Height := 25;
  FButtonEffect := pbeNone;
  FChecked := FALSE;
  FCheckBoxPosition := pcbpLeftTop;
  FCheckBoxSize := pcbsNormal;
  FCheckBoxStyle := pcbsSunken;
  FCheckBoxTransparent := FALSE;
  FHookStyle := phsHook;
  FHookColor := clBtnText;
end;

procedure TPieCheckBox.DummyProc(VAR Message: TMessage);
BEGIN
  IF (Message.Msg = WM_Char) AND (Message.wParam = ord(' ')) THEN BEGIN
    FChecked := NOT(FChecked);
    Invalidate;
    inherited Click;
  END ELSE inherited DummyProc(Message);
END;

procedure TPieCheckBox.Click;
begin
  FChecked := NOT(FChecked);
  inherited Click;
end;

procedure TPieCheckBox.SetButtonEffect(Value: TPieButtonEffect);
BEGIN
  IF Value <> FButtonEffect THEN BEGIN
    FButtonEffect := Value;
    Invalidate;
  END;
END;

procedure TPieCheckBox.SetChecked(Value: Boolean);
BEGIN
  IF Value <> FChecked THEN BEGIN
    FChecked := Value;
    Invalidate;
  END;
END;

procedure TPieCheckBox.SetCheckBoxPosition(Value: TPieCheckBoxPosition);
BEGIN
  IF Value <> FCheckBoxPosition THEN BEGIN
    FCheckBoxPosition := Value;
    Invalidate;
  END;
END;

procedure TPieCheckBox.SetCheckBoxSize(Value: TPieCheckBoxSize);
BEGIN
  IF Value <> FCheckBoxSize THEN BEGIN
    FCheckBoxSize := Value;
    Invalidate;
  END;
END;

procedure TPieCheckBox.SetCheckBoxStyle(Value: TPieCheckBoxStyle);
BEGIN
  IF Value <> FCheckBoxStyle THEN BEGIN
    FCheckBoxStyle := Value;
    Invalidate;
  END;
END;

procedure TPieCheckBox.SetCheckBoxTransparent(Value: Boolean);
BEGIN
  IF Value <> FCheckBoxTransparent THEN BEGIN
    FCheckBoxTransparent := Value;
    Invalidate;
  END;
END;

procedure TPieCheckBox.SetHookStyle(Value: TPieHookStyle);
BEGIN
  IF Value <> FHookStyle THEN BEGIN
    FHookStyle := Value;
    Invalidate;
  END;
END;

procedure TPieCheckBox.SetHookColor(Value: TColor);
BEGIN
  IF Value <> FHookColor THEN BEGIN
    FHookColor := Value;
    Invalidate;
  END;
END;

procedure TPieCheckBox.Paint;
const
  Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
  WordWraps: array[Boolean] of Word = (0, DT_WORDBREAK);
var
  CR, LabelRect, CalcRect, BoxRect, FR: TRect;
  DrawStyle: Integer;
  I, B: Integer;
  LeftTop: TPoint;
begin
  with Canvas do begin
    CR := ClientRect;
    {*********** Hintergrund malen *************}
    if not Transparent then begin
      Brush.Color := Self.Color;
      Brush.Style := bsSolid;
      FillRect(CR);
    end;
    {*********** Button-Layout malen *************}
    if FButtonEffect <> pbeNone then begin
      CASE FButtonEffect OF
      pbeRaised: DrawEdge(Handle, CR, EDGE_RAISED, BF_RECT);
      pbeSunken: DrawEdge(Handle, CR, EDGE_SUNKEN, BF_RECT);
      pbeBump  : DrawEdge(Handle, CR, EDGE_BUMP,   BF_RECT);
      pbeEtched: DrawEdge(Handle, CR, EDGE_ETCHED, BF_RECT);
      END;
      InflateRect(CR, -4, -4);
    end;
    {*********** Kstchen malen ************}
    CASE FCheckBoxSize OF {Breite der Box}
    pcbsSmall:   B := 11;
    pcbsNormal:  B := 13;
    pcbsLarge:   B := 15;
    pcbsLargest: B := 17;
    ELSE B := 13;
    END;
    CASE FCheckBoxPosition OF
    pcbpLeftTop:       LeftTop := Point(CR.Left, CR.Top + 2);
    pcbpLeftCenter:    LeftTop := Point(CR.Left, CR.Top + (CR.Bottom - CR.Top - B) DIV 2);
    pcbpLeftBottom:    LeftTop := Point(CR.Left, CR.Bottom - B - 2);
    pcbpRightTop:      LeftTop := Point(CR.Right - B - 2, CR.Top + 2);
    pcbpRightCenter:   LeftTop := Point(CR.Right - B - 2, CR.Top + (CR.Bottom - CR.Top - B) DIV 2);
    pcbpRightBottom:   LeftTop := Point(CR.Right - B - 2, CR.Bottom - B - 2);
    pcbpCenterTop:     LeftTop := Point((CR.Right - CR.Left - B) DIV 2, CR.Top + 2);
    pcbpCenterBottom:  LeftTop := Point((CR.Right - CR.Left - B) DIV 2, CR.Bottom - B - 2);
    END;
    BoxRect := Rect(LeftTop.X, LeftTop.Y, LeftTop.X + B, LeftTop.Y + B);
    IF Enabled
      THEN Brush.Color := clWindow
      ELSE Brush.Color := clInActiveBorder;
    IF NOT(FCheckBoxTransparent) THEN FillRect(BoxRect);
    CASE FCheckBoxStyle OF
    pcbsSunken: DrawEdge(Handle, BoxRect, EDGE_SUNKEN, BF_RECT);
    pcbsRaised: DrawEdge(Handle, BoxRect, EDGE_RAISED, BF_RECT);
    pcbsBump: DrawEdge(Handle, BoxRect, EDGE_BUMP, BF_RECT);
    pcbsEtched: DrawEdge(Handle, BoxRect, EDGE_ETCHED, BF_RECT);
    END;
    {*********** Hkchen malen ************}
    IF FChecked THEN BEGIN
      IF Enabled
        THEN Pen.Color := FHookColor
        ELSE Pen.Color := clGrayText;
      IF Enabled
        THEN Brush.Color := FHookColor
        ELSE Brush.Color := clGrayText;
      Pen.Width := 1;
      CASE FHookStyle OF
      phsHook:      FOR I:=0 TO 2 DO BEGIN
                    MoveTo(BoxRect.Left + 3,         BoxRect.Top - I + 7);
                    LineTo(BoxRect.Left + B DIV 2-1, BoxRect.Top - I + (B DIV 2) + 3);
                    LineTo(BoxRect.Right - 3,        BoxRect.Top - I + 4);
                    END;
      phsCross:     FOR I:=0 TO 0 DO BEGIN
                    MoveTo(BoxRect.Left + 3,     BoxRect.Top - I + 3);
                    LineTo(BoxRect.Left + B - 3, BoxRect.Top - I + B - 3);
                    MoveTo(BoxRect.Left + 3,     BoxRect.Top - I + B - 4);
                    LineTo(BoxRect.Left + B - 3, BoxRect.Top - I + 2);
                    END;
      phsFill:      FillRect(Rect(BoxRect.Left + 2, BoxRect.Top + 2, BoxRect.Right - 2, BoxRect.Bottom - 2));
      END; {CASE FHookStyle ...}
    END;

    {*********** LabelAbmessungen ermitteln *************}
    LabelRect := ClientRect;
    IF FButtonEffect <> pbeNone THEN InflateRect(LabelRect, -4, -4);
    {LabelPosition ermitteln}
    IF FCheckBoxPosition IN [pcbpLeftTop, pcbpLeftCenter, pcbpLeftBottom]
      THEN LabelRect.Left := BoxRect.Right + 1;
    IF FCheckBoxPosition IN [pcbpRightTop, pcbpRightCenter, pcbpRightBottom]
      THEN LabelRect.Right := BoxRect.Left - 1;
    IF FCheckBoxPosition IN [pcbpCenterTop]
      THEN LabelRect.Top := BoxRect.Bottom + 1;
    IF FCheckBoxPosition IN [pcbpCenterBottom]
      THEN LabelRect.Bottom := BoxRect.Top - 1;
    {*********** Focus malen *************}
    IF FFocused THEN BEGIN
      FR := LabelRect;
      Pen.Color := FFocusColor;
      Brush.Color := FFocusColor;
      CASE FFocusStyle OF
      pfsNormal: BEGIN
                   Brush.Color := clWhite;   {mu gesetzt werden!}
                   DrawFocusRect(FR);
                 END;
      pfsLine:   BEGIN
                   MoveTo(FR.Left, FR.Bottom);
                   LineTo(FR.Right, FR.Bottom);
                 END;
      pfsFill:   BEGIN
                   FillRect(FR);
                 END;
      END;
      Pen.Style := psSolid;
    END;
    {*********** Text malen ************}
    Brush.Style := bsClear;
    { DoDrawText takes care of BiDi alignments }
    DrawStyle := DT_EXPANDTABS or WordWraps[WordWrap] or Alignments[Alignment];
    { Calculate vertical layout }
    CalcRect := LabelRect;
    DoDrawText(CalcRect, DrawStyle or DT_CALCRECT);
    CASE Layout OF
    tlBottom: LabelRect.Top := LabelRect.Bottom - (CalcRect.Bottom - CalcRect.Top);
    tlCenter: LabelRect.Top := LabelRect.Top + (LabelRect.Bottom - CalcRect.Bottom) DIV 2;
    tlTop:    OffsetRect(LabelRect, 1, 2);
    END;
    {10 Pixel freihalten}
    DoDrawText(LabelRect, DrawStyle);
  end;
end;

//*********** TPieButton ********************
constructor TPieButton.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width := 75;
  Height := 25;
  FGlyph := TPicture.Create;
  FGlyph.OnChange := GlyphChange;
  FDown := FALSE;
  FButtonLayout := blGlyphLeft;
  FMargin := 2;
  FSpacing := 2;
  Alignment := taCenter;
  Layout := tlCenter;
end;

destructor TPieButton.Destroy;
begin
  FGlyph.Free;
  inherited Destroy;
end;

procedure TPieButton.DummyProc(VAR Message: TMessage);
BEGIN
  CASE Message.Msg OF
  WM_KeyDown: IF (Message.wParam = vk_Space) THEN BEGIN
              FDown := TRUE;
              Invalidate;
              END;
  WM_KeyUp: IF (Message.wParam = vk_Space) THEN BEGIN
              FDown := FALSE;
              Invalidate;
            END;
  END;
  inherited DummyProc(Message);
END;

procedure TPieButton.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  IF Button = mbLeft THEN BEGIN
    FDown := TRUE;
    FDummyControl.SetFocus;
    Invalidate;
  END;
  inherited MouseDown(Button, Shift, X, Y);
end;

procedure TPieButton.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  IF Button = mbLeft THEN BEGIN
    FDown := FALSE;
    Invalidate;
  END;
  inherited MouseUp(Button, Shift, X, Y);
end;

procedure TPieButton.Click;
var
  Form: TCustomForm;
begin
  Form := GetParentForm(Self);
  if Form <> nil then Form.ModalResult := ModalResult;
  inherited Click;
end;

procedure TPieButton.SetGlyph(Value: TPicture);
begin
  FGlyph.Assign(Value);
  Invalidate;
end;

procedure TPieButton.SetButtonLayout(Value: TButtonLayout);
begin
  IF FButtonLayout <> Value THEN BEGIN
    FButtonLayout := Value;
    Invalidate;
  END;
end;

procedure TPieButton.SetMargin(Value: Integer);
begin
  IF FMargin <> Value THEN BEGIN
    FMargin := Value;
    Invalidate;
  END;
end;

procedure TPieButton.SetSpacing(Value: Integer);
begin
  IF FSpacing <> Value THEN BEGIN
    FSpacing := Value;
    Invalidate;
  END;
end;

PROCEDURE TPieButton.GlyphChange(Sender: TObject);
BEGIN
  Invalidate;
END;

procedure TPieButton.Paint;
const
  Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
  WordWraps: array[Boolean] of Word = (0, DT_WORDBREAK);
var
  CR, LabelRect, CalcRect, BoxRect, FR: TRect;
  DrawStyle: Integer;
  B, H: Integer;
  LeftTop: TPoint;
begin
  with Canvas do begin
    CR := ClientRect;
    {*********** Hintergrund malen *************}
    if not Transparent then begin
      Brush.Color := Self.Color;
      Brush.Style := bsSolid;
      FillRect(CR);
    end;
    IF FShowBackground THEN BEGIN
      IF FDown THEN InflateRect(CR, -1, -1);
      PaintBackground(Canvas, CR);
      IF FDown THEN CR := ClientRect;
    END;
    {*********** Umrandung malen ************}
    IF FDown
      THEN DrawEdge(Handle, CR, EDGE_SUNKEN, BF_RECT)
      ELSE DrawEdge(Handle, CR, EDGE_RAISED, BF_RECT);
    {*********** Glyph malen ************}
    IF Assigned(FGlyph)  AND Assigned(FGlyph.Graphic) THEN BEGIN
      B := FGlyph.Width;
      H := FGlyph.Height;
      CASE FButtonLayout OF
      blGlyphLeft:       LeftTop := Point(FMargin+2, (CR.Bottom - CR.Top - H) DIV 2);
      blGlyphRight:      LeftTop := Point(CR.Right - B - FMargin-2, (CR.Bottom - CR.Top - H) DIV 2);
      blGlyphTop:        LeftTop := Point((CR.Right - CR.Left - B) DIV 2, FMargin+2);
      blGlyphBottom:     LeftTop := Point((CR.Right - CR.Left - B) DIV 2, CR.Bottom - H - FMargin-2);
      END;
      BoxRect := Rect(LeftTop.X, LeftTop.Y, LeftTop.X + B, LeftTop.Y + H);
      IF FDown THEN OffsetRect(BoxRect, 1, 1);
      Draw(BoxRect.Left, BoxRect.Top, FGlyph.Graphic);
    END;
    {*********** LabelAbmessungen ermitteln *************}
    LabelRect := ClientRect;
    IF FDown THEN OffsetRect(BoxRect, -1, -1);
    {LabelPosition ermitteln}
    IF Assigned(FGlyph)  AND Assigned(FGlyph.Graphic) THEN BEGIN
      CASE FButtonLayout OF
      blGlyphLeft:  LabelRect.Left := BoxRect.Right + FSpacing;
      blGlyphRight: LabelRect.Right := BoxRect.Left - FSpacing;
      blGlyphTop:   LabelRect.Top := BoxRect.Bottom + FSpacing;
      blGlyphBottom:LabelRect.Bottom := BoxRect.Top - FSpacing;
      END;
    END;
    {*********** Focus malen *************}
    InflateRect(LabelRect, -4, -4);
    IF FFocused THEN BEGIN
      FR := LabelRect;
      Pen.Color := FFocusColor;
      Brush.Color := FFocusColor;
      CASE FFocusStyle OF
      pfsNormal: BEGIN
                   Brush.Color := clWhite;   {mu gesetzt werden!}
                   DrawFocusRect(FR);
                 END;
      pfsLine:   BEGIN
                   MoveTo(FR.Left, FR.Bottom);
                   LineTo(FR.Right, FR.Bottom);
                 END;
      pfsFill:   BEGIN
                   FillRect(FR);
                 END;
      END;
      Pen.Style := psSolid;
    END;
    {*********** Text malen ************}
    Brush.Style := bsClear;
    InflateRect(LabelRect, -2, -2);
    IF FDown THEN OffsetRect(LabelRect, 1, 1);
    { DoDrawText takes care of BiDi alignments }
    DrawStyle := DT_EXPANDTABS or WordWraps[WordWrap] or Alignments[Alignment];
    { Calculate vertical layout }
    CalcRect := LabelRect;
    DoDrawText(CalcRect, DrawStyle or DT_CALCRECT);
    CASE Layout OF
    tlBottom: LabelRect.Top := LabelRect.Bottom - (CalcRect.Bottom - CalcRect.Top);
    tlCenter: LabelRect.Top := LabelRect.Top + (LabelRect.Bottom - CalcRect.Bottom) DIV 2;
    END;
    {10 Pixel freihalten}
    DoDrawText(LabelRect, DrawStyle);
  end;
end;



end.
