{$I PIETOOLS.INC}
unit PieToolsRegD6;

interface
uses PropertyCategories, DesignIntf, VCLEditors, DesignEditors;

procedure Register;

implementation

uses
  Classes, graphics, PieHerk,
  PieZln1, PieMemoDialog1, PieList,
  PieStat, PieImage, PieJahresKalender,
  PieTransparentControls, PiePageControl,
  PiePrinter, PieRahmen, PieLED, PiePfeil,
  PieValEd, PieTaschenrechner, PieDataGrid, {PieSchiebefix,}
  PieTacho, PieComboBox, PieGrid, PieProgressBar,
  PieEffekt, PieDigit, PieRegistry, PieVersionInfo,
  PieMainMenu, PieToolsEditors;
{ ************************************************* }
procedure MyRegisterPropertiesInCategory(AComponentClass: TClass; const AFilters: array of String);
begin
  RegisterPropertiesInCategory('PieTools', AComponentClass, AFilters);
end;
{ ************************************************* }
procedure Register;
begin
{ ************************************************* }
 RegisterComponents('PieTools',
   [TPieValidateEdit, TPieExtValEdit, TPieDBExtValEdit,
    TPieComboBox, TPieCheckBox, TPieButton, TPiePageControl, TPieList,
    TPieMainMenu, TPiePrinter, TPieFrame,
    TPieImage, TPieStringGrid, TPieScrollText, TPieDigit,
    TPieHistogram, TPieTacho, TPieProgressBar, TPieLED, TPieLEDLabel,
    TPieArrow, TPieEffect, TPieZeilenDialog, TPieMemoDialog,
    TPieYearCalendar, TPieVersionInfo,
    TPieDataGrid, TPieDBDataGrid,
    TPieCalculator]);
{ ************************************************* }
  RegisterComponentEditor(TPieEffect, TPieEffectEditor);
  RegisterComponentEditor(TPieList, TPieListEditor);
  RegisterComponentEditor(TPieDigit, TPieDigitEditor);
  RegisterComponentEditor(TPieComboBox, TPieComboBoxEditor);
{ ************************************************* }
  RegisterPropertyEditor(TypeInfo(TFont), TPiePrinter,
                         '', TFontProperty );
  RegisterPropertyEditor(TypeInfo(TPen), TPiePrinter,
                         '', TClassProperty );
{ ************************************************* }
  MyRegisterPropertiesInCategory(
  TPieCheckBox,
    ['CheckBoxPosition', 'CheckBoxStyle', 'CheckBoxSize', 'CheckBoxTransparent',
     'FocusStyle', 'HookStyle', 'Transparent', 'WordWrap', 'Layout',
     'FocusColor', 'HookColor', 'ButtonEffect']);
  MyRegisterPropertiesInCategory(
  TPieButton,
    ['Alignment', 'ButtonLayout', 'Glyph', 'Layout', 'Margin', 'ModalResult',
     'FocusStyle', 'Spacing', 'Transparent', 'WordWrap', 'FocusColor',
     'Background', 'ShowBackground']);
  MyRegisterPropertiesInCategory(
  TPieMainMenu,
    ['Background', 'MenuHeight', 'MenuStyle', 'SelectImage',
     'SelectStyle', 'SelectColor', 'Font']);
  MyRegisterPropertiesInCategory(
  TPieList,
    ['Alignment', 'AnyColors', 'AnyFonts', 'Background', 'BackgroundStyle', 'BitmapStyle',
     'HorzScrollBar', 'Items', 'ItemHeightStyle', 'SelectedStyle',
     'HeaderFont', 'HeaderImages', 'HeaderSections', 'HeaderStyle',
     'LineByTabStops', 'HorzExtent', 'ShowHeader', 'HeaderSections',
     'CheckBoxStyle', 'HookStyle', 'HookColor', 'CheckBoxes', 'SortColumn',
     'Sorted', 'SortUp', 'CheckBoxSize', 'Version',
     'OnSectionClick', 'OnColumnSort', 'OnSortProgress', 'OnPopup']);
  MyRegisterPropertiesInCategory(
  TPieComboBox,
    ['Alignment', 'AnyColors', 'AnyFonts', 'Background', 'BackgroundStyle', 'BitmapStyle',
     'ItemHeightStyle', 'BoldStyle', 'ShowHeader',
     'HeaderFont', 'HeaderImages', 'HeaderSections', 'HeaderStyle',
     'LineByTabStops', 'Version']);
  MyRegisterPropertiesInCategory(
  TPieDigit,
    ['Decimals', 'DigitBitmap', 'DigitCount', 'DigitScrolling',
     'DigitStyle', 'Value']);
  MyRegisterPropertiesInCategory(
  TPieValidateEdit,
    ['DecimalPlaces', 'Filter', 'FilterIndex', 'MaxValue', 'MinValue',
     'ValEditTyp', 'Validate', 'ValidateMessage',
     'OnChange', 'OnEnter', 'OnExit', 'OnValidateError', 'OnValidExit']);
  MyRegisterPropertiesInCategory(
  TPieExtValEdit,
    ['Header', 'PictureHeader', 'PictureRange', 'Pictures',
     'UnitBevelInner', 'UnitBevelOuter', 'UnitValue', 'UnitWidth',
     'HeaderFont', 'UnitFont', 'UnitPanelColor', 'Filter']);
  MyRegisterPropertiesInCategory(
  TPieImage,
    ['FileName', 'Frame', 'FrameWidth', 'ImageType',
     'FrameColor', 'Picture']);
  MyRegisterPropertiesInCategory(
  TPieProgressBar,
    ['Decimals', 'Max', 'Min', 'NumSegment', 'Orientation', 'Position',
     'ShowText', 'Smooth', 'Step', 'TextUnit', 'OnChange',
     'BackColor', 'BarColor', 'BevelWidth', 'BorderColor',
     'BorderInner', 'BorderOuter', 'BorderWidth']);
  MyRegisterPropertiesInCategory(
  TPiePrinter,
    ['AutoPaging', 'DokumentStatus', 'FontHeight_Promille',
     'Orientation', 'Printermode', 'TabWriteRect', 'TextBase',
     'Title', 'YPosition', 'Tab', 'FooterFont', 'HeaderFont',
     'PageNumberFont', 'Pen', 'Font', 'Brush', 'Alignment',
     'Image', 'ColumnLines']);
  MyRegisterPropertiesInCategory(
  TPieHistogram,
    ['NumberOfHorizontalIntervals', 'NumberOfVerticalIntervals',
     'NameXAxis', 'NameYAxis', 'HistogramType', 'HorizontalGrid',
     'VerticalGrid', 'MaxXValue', 'MaxYValue', 'MinXValue', 'MinYValue',
     'ScaleType', 'DigitCount', 'Transparent', 'XAxisPosition',
     'YAxisPosition', 'ShowHorizontalLabels', 'ShowVerticalLabels',
     'BarColor', 'ErrorColor', 'GridColor']);
  MyRegisterPropertiesInCategory(
  TPieTacho,
    ['NumberOfIntervals', 'LabelPosition', 'MaxValue', 'MinValue',
     'PinRadius', 'Position', 'Scale', 'ScaleDecimals', 'Transparent',
     'PointerWidth', 'PointerType', 'PinColor', 'ScaleColor',
     'PointerColor']);
  MyRegisterPropertiesInCategory(
  TPieEffect,
    ['EffectHeight', 'EffectStyle', 'EffectWidth', 'Shadow',
     'ShadowWidth', 'ValidComponents', 'BorderColor', 'BorderStyle',
     'BorderWidth', 'EffectColor1', 'EffectColor2', 'ShadowColor']);
  MyRegisterPropertiesInCategory(
  TPieYearCalendar,
    ['Day', 'Month', 'Year', 'StartOfWeek', 'LongMonths',
     'UseCurrentDate', 'GridLineWidth', 'OnChange', 'OnEnter',
     'OnExit']);
  MyRegisterPropertiesInCategory(
  TPieArrow,
    ['ArrowWidth', 'ArrowType', 'StartX', 'StartY',
     'TargetX', 'TargetY', 'Transparent']);
  MyRegisterPropertiesInCategory(
  TPiePageControl,
    ['Background', 'BackgroundForRest']);
  MyRegisterPropertiesInCategory(
  TPieLEDLabel,
    ['CharHeight', 'CharWidth', 'CharSpace', 'ActiveLEDColor',
     'InActiveLEDColor', 'LEDStyle', 'SegmentSpace', 'SegmentWidth',
     'ShowInActiveSegments', 'Transparent']);
(*  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieSchiebefixSpiel,
    ['Active', 'Dimension', 'SFStyle', 'Text10x10',
     'Text4x4', 'Text5x5', 'Text6x6', 'Text7x7',
     'Text8x8', 'Text9x9', 'HoleColor', 'OnChange', 'OnWin']);*)
  MyRegisterPropertiesInCategory(
  TPieScrollText,
    ['Interval', 'Items', 'ScrollPixelX', 'ScrollPixelY', 'Start',
     'Transparent', 'LineSpacing']);
  MyRegisterPropertiesInCategory(
  TPieVersionInfo,
    ['VersionInfoAvailable', 'MainVersion', 'SubVersion', 'Release', 'Built',
     'StringFileInfo', 'CompanyName', 'FileDescription', 'FileVersion',
     'InternalName', 'LegalCopyright', 'LegalTrademarks', 'OriginalFilename',
     'ProductName', 'ProductVersion', 'Comments', 'FileDate', 'FileName']);
  MyRegisterPropertiesInCategory(
  TDGColumn,
    ['Alignment', 'CheckBoxSize', 'CheckBoxStyle', 'ColStyle',
     'DisplayMask', 'DropDownRows', 'EditMask', 'Format', 'HookColor',
     'HookStyle', 'LimitToList', 'PickList', 'Title']);
  MyRegisterPropertiesInCategory(
  TDBDGColumn,
    ['DataField']);
  MyRegisterPropertiesInCategory(
  TPieDataGrid,
    ['Background', 'Columns', 'DataGridOptions', 'EditorColor',
     'RowCountMin', 'SelectedCellColor', 'SelectedCellFontColor', 'SortColumn', 'Sorted', 'SortUp',
     'Version',
     'OnBeforeDelete', 'OnBeforeInsert', 'OnEditButtonClick', 'OnChange', 'OnExitCell',
     'OnFixedCellClick', 'OnSortProgress', 'OnColumnSort', 'OnGetEditMask']);
  MyRegisterPropertiesInCategory(
  TPieDBDataGrid,
    ['Background', 'Columns', 'DataGridOptions', 'DataSource', 'EditorColor',
     'RowCountMin', 'SelectedCellColor', 'SelectedCellFontColor', 'Version',
     'OnBeforeDelete', 'OnBeforeInsert', 'OnEditButtonClick', 'OnChange', 'OnExitCell',
     'OnFixedCellClick', 'OnGetEditMask']);
end;

end.
