{$I PIETOOLS.INC}
unit PieToolsReg;

interface
{Dsgnintf.pas-Versions:}
{D4: the file is in the folder "C:\Programme\Borland\Delphi4\Lib"}
{D5: use the file from the folder "C:\Programme\Borland\Delphi5\Source\Toolsapi"}
{    or rename the file "DsgnIntf5.pas" to "DsgnIntf.pas"}
{CB5: use the file from the folder "C:\Programme\Borland\CBuilder5\Source\Toolsapi"}
{    or rename the file "DsgnIntf5.pas" to "DsgnIntf.pas"}

{$IFDEF D6_OR_HIGHER}
  USES PropertyCategories,DesignIntf,VCLEditors;
{$ELSE}
  USES DsgnIntf;
{$ENDIF}

{$IFDEF D5_OR_HIGHER}
TYPE
  TPieToolsCategory = class(TPropertyCategory)
  public
    class function Name: string; override;
    class function Description: string; override;
  end;
{$ENDIF}

procedure Register;

implementation

uses
  Classes, graphics, pieHerk,
  PieValEd, PieZln1, PieMemoDialog1, PieList,
  PieStat, PieImage, PieJahresKalender,
  PieTransparentControls, PiePageControl,
  PiePrinter, PieRahmen, PieLED, PiePfeil,
  PieTaschenrechner, {PieSchiebefix,}
  PieTacho, PieComboBox, PieGrid, PieProgressBar,
  PieEffekt, PieDigit, PieRegistry, PieVersionInfo,
  PieDataGrid,  PieMainMenu, PieToolsEditors;
{ ************************************************* }
{$IFDEF D5_OR_HIGHER}
class function TPieToolsCategory.Name: string;
BEGIN
  Result := 'PieTools';
END;
class function TPieToolsCategory.Description: string;
BEGIN
  Result := 'Extended properties from PieTools';
END;
{$ENDIF}
{ ************************************************* }
function MyRegisterPropertiesInCategory(ACategoryClass: TPropertyCategoryClass; AComponentClass: TClass; const AFilters: array of String): TPropertyCategory;
begin
  {$IFDEF D5_OR_HIGHER}
    {$IFDEF D6_OR_HIGHER}
      Result := RegisterPropertiesInCategory(ACategoryClass.Name, AComponentClass, AFilters);
    {$ELSE}
      Result := RegisterPropertiesInCategory(ACategoryClass, AComponentClass, AFilters);
    {$ENDIF}
  {$ENDIF}
end;
{ ************************************************* }
procedure Register;
begin
{ ************************************************* }
 RegisterComponents('PieTools',
   [TPieValidateEdit, TPieExtValEdit, TPieDBExtValEdit, TPieList,
    TPieComboBox, TPieCheckBox, TPieButton, TPiePageControl,
    TPieMainMenu, TPiePrinter, TPieFrame,
    TPieImage, TPieStringGrid, TPieScrollText, TPieDigit,
    TPieHistogram, TPieTacho, TPieProgressBar, TPieLED, TPieLEDLabel,
    TPieArrow, TPieEffect, TPieZeilenDialog, TPieMemoDialog,
    TPieYearCalendar, TPieVersionInfo,
    TPieDataGrid, TPieDBDataGrid,
    TPieCalculator{, TPieSchiebefixSpiel}]);
{ ************************************************* }
  RegisterComponentEditor(TPieEffect, TPieEffectEditor);
  RegisterComponentEditor(TPieList, TPieListEditor);
  RegisterComponentEditor(TPieDigit, TPieDigitEditor);
  RegisterComponentEditor(TPieComboBox, TPieComboBoxEditor);
{ ************************************************* }
  RegisterPropertyEditor(TypeInfo(TFont), TPiePrinter,
                         '', TFontProperty );
  RegisterPropertyEditor(TypeInfo(TPen), TPiePrinter,
                         '', TClassProperty );
{ ************************************************* }
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieCheckBox,
    ['CheckBoxPosition', 'CheckBoxStyle', 'CheckBoxSize', 'CheckBoxTransparent',
     'FocusStyle', 'HookStyle', 'Transparent', 'WordWrap', 'Layout',
     'FocusColor', 'HookColor', 'ButtonEffect']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieButton,
    ['Alignment', 'ButtonLayout', 'Glyph', 'Layout', 'Margin', 'ModalResult',
     'FocusStyle', 'Spacing', 'Transparent', 'WordWrap', 'FocusColor',
     'Background', 'ShowBackground']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieMainMenu,
    ['Background', 'MenuHeight', 'MenuStyle', 'SelectImage',
     'SelectStyle', 'SelectColor', 'Font']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieList,
    ['Alignment', 'AnyColors', 'AnyFonts', 'Background', 'BackgroundStyle', 'BitmapStyle',
     'HorzScrollBar', 'Items', 'ItemHeightStyle', 'SelectedStyle',
     'HeaderFont', 'HeaderImages', 'HeaderSections', 'HeaderStyle',
     'LineByTabStops', 'HorzExtent', 'ShowHeader', 'HeaderSections',
     'CheckBoxStyle', 'HookStyle', 'HookColor', 'CheckBoxes', 'SortColumn',
     'Sorted', 'SortUp', 'CheckBoxSize', 'Version',
     'OnSectionClick', 'OnColumnSort', 'OnSortProgress', 'OnPopup']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieComboBox,
    ['Alignment', 'AnyColors', 'AnyFonts', 'Background', 'BackgroundStyle', 'BitmapStyle',
     'ItemHeightStyle', 'BoldStyle', 'ShowHeader',
     'HeaderFont', 'HeaderImages', 'HeaderSections', 'HeaderStyle',
     'LineByTabStops', 'Version']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieDigit,
    ['Decimals', 'DigitBitmap', 'DigitCount', 'DigitScrolling',
     'DigitStyle', 'Value']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieValidateEdit,
    ['DecimalPlaces', 'Filter', 'FilterIndex', 'MaxValue', 'MinValue',
     'ValEditTyp', 'Validate', 'ValidateMessage',
     'OnChange', 'OnEnter', 'OnExit', 'OnValidateError', 'OnValidExit']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieExtValEdit,
    ['Header', 'PictureHeader', 'PictureRange', 'Pictures',
     'UnitBevelInner', 'UnitBevelOuter', 'UnitValue', 'UnitWidth',
     'HeaderFont', 'UnitFont', 'UnitPanelColor', 'Filter']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieImage,
    ['FileName', 'Frame', 'FrameWidth', 'ImageType',
     'FrameColor', 'Picture']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieProgressBar,
    ['Decimals', 'Max', 'Min', 'NumSegment', 'Orientation', 'Position',
     'ShowText', 'Smooth', 'Step', 'TextUnit', 'OnChange',
     'BackColor', 'BarColor', 'BevelWidth', 'BorderColor',
     'BorderInner', 'BorderOuter', 'BorderWidth']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPiePrinter,
    ['AutoPaging', 'DokumentStatus', 'FontHeight_Promille',
     'Orientation', 'Printermode', 'TabWriteRect', 'TextBase',
     'Title', 'YPosition', 'Tab', 'FooterFont', 'HeaderFont',
     'PageNumberFont', 'Pen', 'Font', 'Brush', 'Alignment',
     'Image', 'ColumnLines']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieHistogram,
    ['NumberOfHorizontalIntervals', 'NumberOfVerticalIntervals',
     'NameXAxis', 'NameYAxis', 'HistogramType', 'HorizontalGrid',
     'VerticalGrid', 'MaxXValue', 'MaxYValue', 'MinXValue', 'MinYValue',
     'ScaleType', 'DigitCount', 'Transparent', 'XAxisPosition',
     'YAxisPosition', 'ShowHorizontalLabels', 'ShowVerticalLabels',
     'BarColor', 'ErrorColor', 'GridColor']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieTacho,
    ['NumberOfIntervals', 'LabelPosition', 'MaxValue', 'MinValue',
     'PinRadius', 'Position', 'Scale', 'ScaleDecimals', 'Transparent',
     'PointerWidth', 'PointerType', 'PinColor', 'ScaleColor',
     'PointerColor']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieEffect,
    ['EffectHeight', 'EffectStyle', 'EffectWidth', 'Shadow',
     'ShadowWidth', 'ValidComponents', 'BorderColor', 'BorderStyle',
     'BorderWidth', 'EffectColor1', 'EffectColor2', 'ShadowColor']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieYearCalendar,
    ['Day', 'Month', 'Year', 'StartOfWeek', 'LongMonths',
     'UseCurrentDate', 'GridLineWidth', 'OnChange', 'OnEnter',
     'OnExit']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieArrow,
    ['ArrowWidth', 'ArrowType', 'StartX', 'StartY',
     'TargetX', 'TargetY', 'Transparent']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPiePageControl,
    ['Background', 'BackgroundForRest']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieLEDLabel,
    ['CharHeight', 'CharWidth', 'CharSpace', 'ActiveLEDColor',
     'InActiveLEDColor', 'LEDStyle', 'SegmentSpace', 'SegmentWidth',
     'ShowInActiveSegments', 'Transparent']);
(*  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieSchiebefixSpiel,
    ['Active', 'Dimension', 'SFStyle', 'Text10x10',
     'Text4x4', 'Text5x5', 'Text6x6', 'Text7x7',
     'Text8x8', 'Text9x9', 'HoleColor', 'OnChange', 'OnWin']);*)
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieScrollText,
    ['Interval', 'Items', 'ScrollPixelX', 'ScrollPixelY', 'Start',
     'Transparent', 'LineSpacing']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieVersionInfo,
    ['VersionInfoAvailable', 'MainVersion', 'SubVersion', 'Release', 'Built',
     'StringFileInfo', 'CompanyName', 'FileDescription', 'FileVersion',
     'InternalName', 'LegalCopyright', 'LegalTrademarks', 'OriginalFilename',
     'ProductName', 'ProductVersion', 'Comments', 'FileDate', 'FileName']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TDGColumn,
    ['Alignment', 'CheckBoxSize', 'CheckBoxStyle', 'ColStyle',
     'DisplayMask', 'DropDownRows', 'EditMask', 'Format', 'HookColor',
     'HookStyle', 'LimitToList', 'PickList', 'Title']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TDBDGColumn,
    ['DataField']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieDataGrid,
    ['Background', 'Columns', 'DataGridOptions', 'EditorColor',
     'RowCountMin', 'SelectedCellColor', 'SelectedCellFontColor', 'SortColumn', 'Sorted', 'SortUp',
     'Version',
     'OnBeforeDelete', 'OnBeforeInsert', 'OnEditButtonClick', 'OnChange', 'OnExitCell',
     'OnFixedCellClick', 'OnSortProgress', 'OnColumnSort', 'OnGetEditMask']);
  MyRegisterPropertiesInCategory(TPieToolsCategory,
  TPieDBDataGrid,
    ['Background', 'Columns', 'DataGridOptions', 'DataSource', 'EditorColor',
     'RowCountMin', 'SelectedCellColor', 'SelectedCellFontColor', 'Version',
     'OnBeforeDelete', 'OnBeforeInsert', 'OnEditButtonClick', 'OnChange', 'OnExitCell',
     'OnFixedCellClick', 'OnGetEditMask']);
end;

end.
