{$I PIETOOLS.INC}
unit PieToolsEditors;

interface

uses
  {$IFDEF D6_OR_HIGHER}
  DesignEditors;
  {$ELSE}
  DsgnIntf;
  {$ENDIF}

type
  TPieComboBoxEditor = class(TComponentEditor)
    function GetVerbCount: Integer; override;
    function GetVerb(Index: Integer): string; override;
    procedure ExecuteVerb(Index: Integer); override;
  end;

  TPieDigitEditor = class(TComponentEditor)
    function GetVerbCount: Integer; override;
    function GetVerb(Index: Integer): string; override;
    procedure ExecuteVerb(Index: Integer); override;
  end;

  TPieEffectEditor = class(TComponentEditor)
    function GetVerbCount: Integer; override;
    function GetVerb(Index: Integer): string; override;
    procedure ExecuteVerb(Index: Integer); override;
  end;

  TPieListEditor = class(TComponentEditor)
    function GetVerbCount: Integer; override;
    function GetVerb(Index: Integer): string; override;
    procedure ExecuteVerb(Index: Integer); override;
  end;

implementation
uses Controls, Forms,
     PieComboBox, PieDigit, PieEffekt, PieList;
{******************************************************}
{******************************************************}
{******************************************************}

function TPieComboBoxEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

function TPieComboBoxEditor.GetVerb(Index: Integer): string;
begin
  CASE Index OF
  0: Result := '&Edit PieComboBox';
  END;
end;

procedure TPieComboBoxEditor.ExecuteVerb(Index: Integer);
var
  D : TPieComboBoxItemsfenster;
begin
  CASE Index OF
  0: BEGIN
     D := TPieComboBoxItemsfenster.Create(Application);
     try
       D.Caption := Component.Owner.Name + '.' +
                    Component.Name + ' - ' + D.Caption;

       D.ComboBox.CopyProp(D.ComboBox, Component as TPieComboBox);
       if D.ShowModal = mrOK then
         D.ComboBox.CopyProp(Component as TPieComboBox, D.ComboBox);
     finally
       D.Free;
     end;
     END;
  END;
end;

{******************************************************}
{******************************************************}
{******************************************************}

function TPieDigitEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

function TPieDigitEditor.GetVerb(Index: Integer): string;
begin
  CASE Index OF
  0: Result := '&Edit PieDigit';
  END;
end;

procedure TPieDigitEditor.ExecuteVerb(Index: Integer);
var
  D : TPieDigitfenster;
procedure CopyProp(Dest, Source: TPieDigit);
BEGIN
  Dest.DigitBitmap.Assign(Source.DigitBitmap);
  Dest.DigitCount      := Source.DigitCount;
  Dest.Decimals        := Source.Decimals;
  Dest.Value           := Source.Value;
  Dest.DigitStyle      := Source.DigitStyle;
  Dest.DigitScrolling  := Source.DigitScrolling;
END;
begin
  CASE Index OF
  0: BEGIN
     D := TPieDigitfenster.Create(Application);
     try
        D.Caption := Component.Owner.Name + '.' +
                     Component.Name + ' - ' + D.Caption;

        CopyProp(D.Digit, Component as TPieDigit);

        if D.ShowModal = mrOK then
          CopyProp(Component as TPieDigit, D.Digit);
      finally
        D.Free;
      end;
      END;
  END;
end;

{******************************************************}
{******************************************************}
{******************************************************}

function TPieEffectEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

function TPieEffectEditor.GetVerb(Index: Integer): string;
begin
  CASE Index OF
  0: Result := 'Edit &Effect';
  END;
end;

procedure TPieEffectEditor.ExecuteVerb(Index: Integer);
VAR
  D: TPieEffectEditorDialog;
procedure CopyProp(Dest, Source: TPieEffect);
BEGIN
  Dest.Picture      := Source.Picture;
  Dest.EffectColor1 := Source.EffectColor1;
  Dest.EffectColor2 := Source.EffectColor2;
  Dest.ShadowColor  := Source.ShadowColor;
  Dest.EffectHeight := Source.EffectHeight;
  Dest.EffectWidth  := Source.EffectWidth;
  Dest.Shadow       := Source.Shadow;
  Dest.ShadowWidth  := Source.ShadowWidth;
  Dest.BorderWidth  := Source.BorderWidth;
  Dest.EffectStyle  := Source.EffectStyle;
  Dest.BorderStyle  := Source.BorderStyle;
END;
begin
  CASE Index OF
  0: BEGIN
     D := TPieEffectEditorDialog.Create(Application);
     TRY
       CopyProp(D.PE1, Component as TPieEffect);
       D.Caption := Component.Owner.Name + '.' + Component.Name + D.Caption;
       D.InitSettings;
       IF D.ShowModal = mrOK THEN BEGIN
         CopyProp(Component as TPieEffect, D.PE1);
       END;
     FINALLY
       D.Free;
     END;
     END;
  END;
end;

{******************************************************}
{******************************************************}
{******************************************************}

function TPieListEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

function TPieListEditor.GetVerb(Index: Integer): string;
begin
  CASE Index OF
  0: Result := '&Edit PieList';
  END;
end;

procedure TPieListEditor.ExecuteVerb(Index: Integer);
var
  D : TPieItemsfenster;
begin
  CASE Index OF
  0: BEGIN
     D := TPieItemsfenster.Create(Application);
     try
        D.Caption := Component.Owner.Name + '.' +
                     Component.Name + ' - ' + D.Caption;

        D.Liste.Assign(Component as TPieList);

        if D.ShowModal = mrOK then
          (Component as TPieList).Assign(D.Liste);
      finally
        D.Free;
      end;
      END;
  END;
end;

end.
