{$I PIETOOLS.INC}
unit PieTaschenrechner1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Pievaled, Buttons, Math;

CONST
  Max_Werte = 10;

type
  TTaschenrechner = class(TForm)
    Anzeigepanel: TPanel;
    Zifferntastenpanel: TPanel;
    Funktionstastenpanel: TPanel;
    Anzeige: TPieValidateEdit;
    ZPanel1: TPanel;
    PlusMinusPanel: TPanel;
    sieben: TSpeedButton;
    acht: TSpeedButton;
    neun: TSpeedButton;
    vier: TSpeedButton;
    fuenf: TSpeedButton;
    sechs: TSpeedButton;
    eins: TSpeedButton;
    zwei: TSpeedButton;
    drei: TSpeedButton;
    null: TSpeedButton;
    Komma: TSpeedButton;
    exponent: TSpeedButton;
    clear: TSpeedButton;
    clear_all: TSpeedButton;
    mal: TSpeedButton;
    durch: TSpeedButton;
    plus: TSpeedButton;
    minus: TSpeedButton;
    gleich: TSpeedButton;
    Mplus: TSpeedButton;
    FP1: TPanel;
    EXpAnzeige: TPieValidateEdit;
    ExpVZAnzeige: TLabel;
    VZAnzeige: TLabel;
    M_In: TSpeedButton;
    MR: TSpeedButton;
    MRLabel: TLabel;
    FP3: TPanel;
    wurzel: TSpeedButton;
    quadrat: TSpeedButton;
    log: TSpeedButton;
    lnat: TSpeedButton;
    xhochy: TSpeedButton;
    Errorlabel: TLabel;
    FP2: TPanel;
    Sinus: TSpeedButton;
    CoSinus: TSpeedButton;
    Tangens: TSpeedButton;
    DRG: TLabel;
    Pie: TSpeedButton;
    Mode: TSpeedButton;
    Shift: TSpeedButton;
    ShiftLabel: TLabel;
    Hyp: TSpeedButton;
    HypLabel: TLabel;
    ModeLabel: TImage;
    Legende: TImage;
    HexLabel: TLabel;
    Back: TSpeedButton;
    VZ: TSpeedButton;
    einsdx: TSpeedButton;
    Logo: TLabel;
    Typ: TLabel;
    NEGLabel: TLabel;
    NOTLabel: TLabel;
    ANDLabel: TLabel;
    ORLabel: TLabel;
    XORLabel: TLabel;
    XNORLabel: TLabel;
    AHEXLabel: TLabel;
    BHEXLabel: TLabel;
    CHEXLabel: TLabel;
    DHEXLabel: TLabel;
    EHEXLabel: TLabel;
    FHEXLabel: TLabel;
    Exitlabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure clear_allClick(Sender: TObject);
    procedure nullClick(Sender: TObject);
    procedure clearClick(Sender: TObject);
    procedure KommaClick(Sender: TObject);
    procedure VZClick(Sender: TObject);
    procedure malClick(Sender: TObject);
    procedure exponentClick(Sender: TObject);
    procedure MplusClick(Sender: TObject);
    procedure MRClick(Sender: TObject);
    procedure einsdxClick(Sender: TObject);
    procedure BackClick(Sender: TObject);
    procedure PieClick(Sender: TObject);
    procedure ModeClick(Sender: TObject);
    procedure ShiftClick(Sender: TObject);
    procedure HypClick(Sender: TObject);
    procedure LogoDblClick(Sender: TObject);
    procedure TypDblClick(Sender: TObject);
    procedure ExitlabelClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Komma_da,            {True, wenn Komma schon vergeben}
    Zahl_gueltig,        {True, wenn Zahl eingegeben wurde, False: neue Zahl beginnt!}
    Speicher_gueltig,    {True, wenn Speicherzahl dargestellt wird --> kann fr Operationen verwendet werden!}
    Minus_da,            {True, wenn Minus fr normale Zahl da}
    Exponent_da,         {True, wenn Exponent bearbeitet wird}
    ExpMinus_da: Boolean;{True, wenn Minus fr Exponenten da}
    Anzahl_Werte: Byte;  {Anzahl der gltigen Werte im Zwischenspeicher}
    Operator : array[1..Max_Werte] of TObject; {z.B.: Plus, Minus, Mal, Durch ...}
    Wert     : array[1..Max_Werte] of Double;
    ShiftOp  : array[1..Max_Werte] of Boolean; {Shiftstatus der zugehrigen Operatoren}
    MRWert: Double;      {Wert im Zwischenspeicher}
    FUNCTION Zahl_lesen: Double;
    PROCEDURE Zahl_setzen(W: Double);
    FUNCTION Wertigkeit_ermitteln(Sender: TObject): Byte;
    PROCEDURE Rechnen(Sender: TObject);
    PROCEDURE Unaer_Rechnen(W: Double; Sender: TObject);
    PROCEDURE HexBehandlung(Sender: TObject);
  public
    { Public-Deklarationen }
  end;

var
  Taschenrechner: TTaschenrechner;

implementation
{$R *.DFM}

USES PieHerk;

procedure TTaschenrechner.FormCreate(Sender: TObject);
begin
  Clear_AllClick(Sender);
  MRWert := 0;
  DRG.Caption := 'D'; {Altgrad}
end;

procedure TTaschenrechner.clearClick(Sender: TObject);
begin
  Anzeige.Text := '0';
  Anzeige.DecimalPlaces := 0;
  VZAnzeige.Caption := '';
  ExpVZAnzeige.Caption := '';
  ExpAnzeige.Text := '';
  ExpAnzeige.Visible := FALSE;
  Komma_Da := FALSE;
  Minus_Da := FALSE;
  Exponent_da := FALSE;
  ExpMinus_Da := FALSE;
  ModeLabel.Visible := FALSE;
  ShiftLabel.Visible := FALSE;
  HypLabel.Visible := FALSE;
end;

procedure TTaschenrechner.clear_allClick(Sender: TObject);
begin
  Errorlabel.Visible := FALSE;
  Clear_all.Font.Color := clWindowText;
  Anzeige.Visible := TRUE;
  ClearClick(Sender);
  Anzahl_Werte := 0;
  Zahl_gueltig := FALSE;
  Speicher_gueltig := FALSE;
end;

FUNCTION TTaschenrechner.Zahl_lesen: Double;
VAR
  Z: LongInt;
  W: Double;
begin
  IF HexLabel.Visible THEN W := Anzeige.GetHex
                      ELSE W := Anzeige.GetDouble;
  IF Minus_Da THEN W := - W;
  IF Exponent_Da THEN BEGIN
    Z := ExpAnzeige.GetLongInt;
    IF ExpMinus_Da THEN Z := - Z;
    W := W * (Exp(Z*ln(10)));
  END;
  Result := W;
end;

PROCEDURE TTaschenrechner.Zahl_setzen(W: Double);
VAR
  S: String;
begin
  IF HexLabel.Visible THEN Anzeige.SetHex(trunc(W))
  ELSE BEGIN
    IF ((W < 1e8) AND (W > 1e-3)) OR ((W > -1e8) AND (W < -1e-3)) OR (W = 0)
      THEN Str(W:10:10, S) ELSE Str(W:15, S);
    S := NoNull(Trim(S));
    {Exponent rausfiltern}
    IF (length(S) > 6) AND (S[length(S)-5] = 'E') THEN BEGIN
      Exponent_Da := TRUE;
      ExpAnzeige.Visible := TRUE;
      ExpAnzeige.Text := copy(S, length(S)-1, 2);
      IF S[length(S)-4] = '-' THEN BEGIN
        ExpMinus_Da := TRUE;
        ExpVZAnzeige.Caption := '-';
      END;
      S := copy(S, 1, length(S)-6);
    END;
    IF S[1] = '-' THEN BEGIN
      Minus_Da := TRUE;
      VZAnzeige.Caption := '-';
    END;
    IF S[1] IN ['-','+'] THEN S := copy(S, 2, length(S)-1);
    S := NoNull(S);
    Anzeige.DecimalPlaces := length(S) - pos('.', S);
    Anzeige.Text := S;
  END;
end;

FUNCTION TTaschenrechner.Wertigkeit_ermitteln(Sender: TObject): Byte;
VAR
  W: Byte;
begin {1(+,-), 2(x,/), 3(Potenz)}
  W := 0;
  IF Sender = Plus   THEN W := 1;
  IF Sender = Minus  THEN W := 1;
  IF Sender = Mal    THEN W := 2;
  IF Sender = Durch  THEN W := 2;
  IF HexLabel.Visible THEN BEGIN
    IF Sender = Quadrat THEN W := 2; {AND}
    IF Sender = log     THEN W := 1; {OR}
    IF Sender = lnat    THEN W := 1; {XOR}
    IF Sender = XHochY  THEN W := 2; {XNOR}
  END
  ELSE BEGIN
    IF Sender = XHochY THEN W := 3;
  END;
  Result := W;
end;

PROCEDURE TTaschenrechner.Rechnen(Sender: TObject);
VAR
  I: Integer;
  R: Double;
  S: String;
  Wertigkeit1, Wertigkeit2: Byte; {1(+,-), 2(x,/), 3(Potenz)}
begin
  IF Anzahl_Werte > 1 THEN FOR I:=Anzahl_Werte DOWNTO 2 DO BEGIN
    Wertigkeit1 := Wertigkeit_ermitteln(Operator[I-1]);
    Wertigkeit2 := Wertigkeit_ermitteln(Operator[I]);
    IF NOT(Wertigkeit1 < Wertigkeit2) THEN BEGIN
      ClearClick(Sender);
      R := 0;
      S := '';
      TRY
        IF Operator[I-1] = Plus   THEN R := Wert[I-1] + Wert[I];
        IF Operator[I-1] = Minus  THEN R := Wert[I-1] - Wert[I];
        IF Operator[I-1] = Mal    THEN R := Wert[I-1] * Wert[I];
        IF Operator[I-1] = Durch  THEN R := Wert[I-1] / Wert[I];
        IF HexLabel.Visible THEN BEGIN
          IF Operator[I-1] = Quadrat THEN R := round(Wert[I-1]) AND round(Wert[I]); {AND}
          IF Operator[I-1] = Log     THEN R := round(Wert[I-1])  OR round(Wert[I]); {OR}
          IF Operator[I-1] = lnat    THEN R := round(Wert[I-1]) XOR round(Wert[I]); {XOR}
          IF Operator[I-1] = XHochY  THEN R := NOT(round(Wert[I-1]) XOR round(Wert[I])); {XNOR}
        END
        ELSE BEGIN
          IF Operator[I-1] = XHochY THEN IF ShiftOp[I-1]
            THEN R := Power(Wert[I-1],1/Wert[I])
            ELSE R := Power(Wert[I-1],Wert[I]);
        END;
      EXCEPT
        on EZeroDivide do S := 'Error - Div durch 0';
        on EOverflow   do S := 'Error - berlauf   ';
        on EUnderflow  do S := 'Error - Unterlauf  ';
        on EMathError  do S := 'Error';
        on EIntError   do S := 'Error';
      END;
      IF S <> '' THEN BEGIN
        Anzeige.Visible := FALSE;
        Errorlabel.Caption := S;
        Errorlabel.Visible := TRUE;
        Clear_all.Font.Color := clRed;
      END
      ELSE BEGIN
        Wert[I-1] := R;
        Operator[I-1] := Operator[I];
        ShiftOp[I-1] := ShiftOp[I];
        Zahl_Setzen(R);
        dec(Anzahl_Werte);
      END;
    END;
  END;
  IF (Anzahl_Werte = 1) AND (Operator[1] = Gleich) THEN Anzahl_Werte := 0;
end;

PROCEDURE TTaschenrechner.Unaer_Rechnen(W: Double; Sender: TObject);
VAR
  R : Double;
  W1: Double;
  S : String;
  SHIFT_da: Boolean;
  Hyp_da: Boolean;
begin
  SHIFT_da := SHIFTLabel.Visible;
  Hyp_da := HypLabel.Visible;
  ClearClick(Sender);
  R := 0;
  S := '';
  TRY
    IF Sender = einsdx  THEN R := 1/W;
    IF Sender = Wurzel  THEN R := SQRT(W);
    IF Sender = Quadrat THEN R := SQR(W);
    IF Sender = Log     THEN IF Shift_da THEN R := Power(10,W) ELSE R := Log10(W);
    IF Sender = LNat    THEN IF Shift_da THEN R := Exp(W)      ELSE R := Ln(W);
    {----- trigonometrische Funktionen ---------------}
    IF(Sender = Sinus) OR (Sender = CoSinus) OR (Sender = Tangens) THEN BEGIN
      IF SHIFT_da THEN BEGIN
        IF HYP_da THEN BEGIN
          IF Sender = Sinus   THEN R := ArcSinH(W);
          IF Sender = CoSinus THEN R := ArcCosH(W);
          IF Sender = Tangens THEN R := ArcTanH(W);
        END
        ELSE BEGIN
          IF Sender = Sinus   THEN R := ArcSin(W);
          IF Sender = CoSinus THEN R := ArcCos(W);
          IF Sender = Tangens THEN R := ArcTan(W);
        END;
        IF DRG.Caption = 'D' THEN R := 360*R/2/Pi; {Bogenma --> Altgrad}
        IF DRG.Caption = 'G' THEN R := 400*R/2/Pi; {Bogenma --> Neugrad}
      END
      ELSE BEGIN
        W1 := 0;
        IF DRG.Caption = 'D' THEN W1 := 2*Pi*W/360; {Altgrad --> Bogenma}
        IF DRG.Caption = 'R' THEN W1 := W;          {Bogenma --> Bogenma}
        IF DRG.Caption = 'G' THEN W1 := 2*Pi*W/400; {Neugrad --> Bogenma}
        IF HYP_da THEN BEGIN
          IF Sender = Sinus   THEN R := SinH(W1);
          IF Sender = CoSinus THEN R := CosH(W1);
          IF Sender = Tangens THEN R := TanH(W1);
        END
        ELSE BEGIN
          IF Sender = Sinus   THEN R := Sin(W1);
          IF Sender = CoSinus THEN R := Cos(W1);
          IF Sender = Tangens THEN R := Tan(W1);
        END;
      END;
      IF (R < 1e-10) AND (R > -1e-10) THEN R := 0;
      IF (R > 1e11)  THEN S := 'Error - Unendlich';
      IF (R < -1e11) THEN S := 'Error - -Unendlich';
    END;
    {----- Ende trigonometrische Funktionen ---------------}
  EXCEPT
    on EZeroDivide do S := 'Error - Div durch 0';
    on EOverflow   do S := 'Error - berlauf   ';
    on EUnderflow  do S := 'Error - Unterlauf  ';
    on EMathError  do S := 'Error';
    on EIntError   do S := 'Error';
  END;
  IF S <> '' THEN BEGIN
    Anzeige.Visible := FALSE;
    Errorlabel.Caption := S;
    Errorlabel.Visible := TRUE;
    Clear_all.Font.Color := clRed;
  END
  ELSE Zahl_Setzen(R);
end;

PROCEDURE TTaschenrechner.HexBehandlung(Sender: TObject);
VAR
  W, R: LongInt;
BEGIN
  {Buchstabentaste (A ... F) behandeln}
  IF (Sender = EinsdX)  OR (Sender = Pie)     OR
     (Sender = Hyp)     OR (Sender = Sinus)   OR
     (Sender = CoSinus) OR (Sender = Tangens) THEN BEGIN
    IF NOT(Zahl_gueltig) THEN clearclick(Sender);
    Zahl_gueltig := TRUE;
    IF Length(Anzeige.Text) < 8 THEN BEGIN
      IF Sender = Einsdx  THEN Anzeige.Text := Anzeige.Text + 'A';
      IF Sender = Pie     THEN Anzeige.Text := Anzeige.Text + 'B';
      IF Sender = Hyp     THEN Anzeige.Text := Anzeige.Text + 'C';
      IF Sender = Sinus   THEN Anzeige.Text := Anzeige.Text + 'D';
      IF Sender = CoSinus THEN Anzeige.Text := Anzeige.Text + 'E';
      IF Sender = Tangens THEN Anzeige.Text := Anzeige.Text + 'F';
    END;
    WITH Anzeige DO SetHex(GetHex);
  END
  {logische Funktionen (NEG, NOT) behandeln}
  ELSE BEGIN
    W := trunc(Zahl_lesen);
    R := 0;
    IF Sender = VZ     THEN R := -W;      {NEG}
    IF Sender = Wurzel THEN R := NOT(W);  {NOT}
    Zahl_setzen(R);
  END;
END;

procedure TTaschenrechner.nullClick(Sender: TObject);
VAR
  S: String;
  W: Double;
begin      {fr Ziffern (0..9)}
  IF NOT(Errorlabel.Visible) THEN BEGIN
    IF ModeLabel.Visible THEN BEGIN
      IF (Sender = Null) AND HexLabel.Visible THEN BEGIN
        W := Zahl_lesen;
        clearClick(Sender);
        HexLabel.Visible := FALSE;
        Anzeige.ValEditTyp := etDouble;
        Zahl_setzen(W);
        Zahl_gueltig := FALSE;
        Speicher_gueltig := TRUE;
      END;
      IF (Sender = Eins) AND NOT(HexLabel.Visible) THEN BEGIN
        W := Zahl_lesen;
        clearClick(Sender);
        HexLabel.Visible := TRUE;
        Anzeige.ValEditTyp := etHex;
        Zahl_setzen(trunc(W));
        Zahl_gueltig := FALSE;
        Speicher_gueltig := TRUE;
      END;
      IF Sender = Vier   THEN DRG.Caption := 'D';
      IF Sender = Fuenf  THEN DRG.Caption := 'R';
      IF Sender = Sechs  THEN DRG.Caption := 'G';
      ModeLabel.Visible := FALSE;
    END
    ELSE BEGIN
      IF NOT(Zahl_gueltig) THEN clearclick(Sender);
      Zahl_gueltig := TRUE;
      IF Exponent_da THEN BEGIN
        S := ExpAnzeige.Text;
        S[1] := S[2];
        IF Sender = Null   THEN S[2] := '0';
        IF Sender = Eins   THEN S[2] := '1';
        IF Sender = Zwei   THEN S[2] := '2';
        IF Sender = Drei   THEN S[2] := '3';
        IF Sender = Vier   THEN S[2] := '4';
        IF Sender = Fuenf  THEN S[2] := '5';
        IF Sender = Sechs  THEN S[2] := '6';
        IF Sender = Sieben THEN S[2] := '7';
        IF Sender = Acht   THEN S[2] := '8';
        IF Sender = Neun   THEN S[2] := '9';
        ExpAnzeige.Text := S;
      END
      ELSE BEGIN
        IF Length(Anzeige.Text) < 10 THEN BEGIN
          IF Sender = Null   THEN Anzeige.Text := Anzeige.Text + '0';
          IF Sender = Eins   THEN Anzeige.Text := Anzeige.Text + '1';
          IF Sender = Zwei   THEN Anzeige.Text := Anzeige.Text + '2';
          IF Sender = Drei   THEN Anzeige.Text := Anzeige.Text + '3';
          IF Sender = Vier   THEN Anzeige.Text := Anzeige.Text + '4';
          IF Sender = Fuenf  THEN Anzeige.Text := Anzeige.Text + '5';
          IF Sender = Sechs  THEN Anzeige.Text := Anzeige.Text + '6';
          IF Sender = Sieben THEN Anzeige.Text := Anzeige.Text + '7';
          IF Sender = Acht   THEN Anzeige.Text := Anzeige.Text + '8';
          IF Sender = Neun   THEN Anzeige.Text := Anzeige.Text + '9';
          {Werte formatieren}
          IF HexLabel.Visible THEN WITH Anzeige DO SetHex(GetHex)
          ELSE BEGIN
            IF Komma_Da THEN Anzeige.DecimalPlaces := Anzeige.DecimalPlaces + 1;
            WITH Anzeige DO SetDouble(GetDouble);
          END;
        END;
      END;
    END; {IF Mode_da THEN BEGIN}
  END; {IF NOT(Errorlabel.Visible) ...}
end;

procedure TTaschenrechner.KommaClick(Sender: TObject);
begin
  IF NOT(Errorlabel.Visible) AND NOT(HexLabel.Visible) THEN BEGIN
    IF NOT(Komma_Da) THEN BEGIN
      Komma_Da := TRUE;
      Anzeige.Text := Anzeige.Text + '.';
    END;
  END; {IF NOT(Errorlabel.Visible) ...}
end;

procedure TTaschenrechner.VZClick(Sender: TObject);
begin
  IF NOT(Errorlabel.Visible) THEN BEGIN
    IF HexLabel.Visible THEN HexBehandlung(Sender)
    ELSE BEGIN
      IF Exponent_da THEN BEGIN
        ExpMinus_Da := NOT(ExpMinus_Da);
        IF ExpMinus_Da THEN ExpVZAnzeige.Caption := '-' ELSE ExpVZAnzeige.Caption := '';
      END
      ELSE BEGIN
        Minus_Da := NOT(Minus_Da);
        IF Minus_Da THEN VZAnzeige.Caption := '-' ELSE VZAnzeige.Caption := '';
      END;
    END; {IF HexLabel.Visible}
  END; {IF NOT(Errorlabel.Visible) ...}
end;

procedure TTaschenrechner.exponentClick(Sender: TObject);
begin
  IF NOT(Errorlabel.Visible) AND NOT(HexLabel.Visible) THEN BEGIN
    IF NOT(Exponent_da) THEN BEGIN
      Exponent_da := TRUE;
      ExpAnzeige.Visible := TRUE;
      ExpAnzeige.Text := '00';
    END;
  END; {IF NOT(Errorlabel.Visible) ...}
end;

procedure TTaschenrechner.malClick(Sender: TObject);
begin  {fr Binre Operatoren (+,-,*,/,=,Hoch,AND,OR,XOR,XNOR)}
  IF NOT(Errorlabel.Visible) THEN BEGIN
    IF Zahl_gueltig OR Speicher_gueltig THEN BEGIN
      inc(Anzahl_Werte);
      Wert[Anzahl_Werte] := Zahl_lesen;
    END;
    IF Anzahl_Werte > 0 THEN BEGIN
      Operator[Anzahl_Werte] := Sender;
      ShiftOp[Anzahl_Werte] := ShiftLabel.Visible;
      Rechnen(Sender);
    END;
    Zahl_gueltig := FALSE;
    Speicher_gueltig := Sender = Gleich;
  END; {IF NOT(Errorlabel.Visible) ...}
end;

procedure TTaschenrechner.MplusClick(Sender: TObject);
VAR
  W: Double;
begin  {fr Speicheroperationen (M+,Min)}
  IF NOT(Errorlabel.Visible) THEN BEGIN
    W := Zahl_lesen;
    IF Sender = M_In THEN MRWert := W;
    IF Sender = Mplus THEN IF ShiftLabel.Visible
      THEN MRWert := MRWert - W ELSE MRWert := MRWert + W;
    MRLabel.Visible := MRWert <> 0;
    ShiftLabel.Visible := FALSE;
    Zahl_gueltig := FALSE;
    Speicher_gueltig := TRUE;
  END; {IF NOT(Errorlabel.Visible) ...}
end;

procedure TTaschenrechner.MRClick(Sender: TObject);
begin  {fr Speicheroperationen (MR)}
  IF NOT(Errorlabel.Visible) THEN BEGIN
    ClearClick(Sender);
    Zahl_Setzen(MRWert);
    Speicher_gueltig := TRUE;
  END; {IF NOT(Errorlabel.Visible) ...}
end;

procedure TTaschenrechner.einsdxClick(Sender: TObject);
VAR
  W: Double;
begin  {fr Unre Operatoren (1/x,Wurzel,x,log,ln,sin,cos,tan)}
  IF NOT(Errorlabel.Visible) THEN BEGIN
    IF HexLabel.Visible THEN BEGIN
      IF Sender = Einsdx  THEN HexBehandlung(Sender); {A}
      IF Sender = Wurzel  THEN HexBehandlung(Sender); {NOT}
      IF Sender = Sinus   THEN HexBehandlung(Sender); {D}
      IF Sender = CoSinus THEN HexBehandlung(Sender); {E}
      IF Sender = Tangens THEN HexBehandlung(Sender); {F}
      IF (Sender = Quadrat) OR (Sender = log) OR
         (Sender = lnat)    THEN malClick(Sender);   {AND, OR, XOR}
    END
    ELSE BEGIN
      IF Zahl_gueltig OR Speicher_gueltig THEN BEGIN
        W := Zahl_lesen;
        Unaer_Rechnen(W, Sender);
        Zahl_gueltig := FALSE;
        Speicher_gueltig := TRUE;
      END;
    END; {IF HexLabel.Visible ...}
  END; {IF NOT(Errorlabel.Visible) ...}
end;

procedure TTaschenrechner.BackClick(Sender: TObject);
VAR
  S: string;
begin  {fr Zeichenlschungen (Backspace)}
  IF NOT(Errorlabel.Visible) AND Zahl_gueltig THEN BEGIN
    IF Exponent_da THEN BEGIN
      S := ExpAnzeige.Text;
      IF S = '00' THEN BEGIN
        Exponent_da := FALSE;
        ExpAnzeige.Visible := FALSE;
      END
      ELSE BEGIN
        S[2] := S[1];
        S[1] := '0';
        ExpAnzeige.Text := S;
      END;
    END
    ELSE BEGIN
      IF length(Anzeige.Text) > 1
        THEN Anzeige.Text := copy(Anzeige.Text, 1, length(Anzeige.Text)-1)
        ELSE Anzeige.Text := '0';
    END;
  END; {IF NOT(Errorlabel.Visible) ...}
end;

procedure TTaschenrechner.PieClick(Sender: TObject);
begin  {Konstante Pi darstellen (3,14..)}
  IF NOT(Errorlabel.Visible) THEN BEGIN
    IF HexLabel.Visible THEN HexBehandlung(Sender)
    ELSE BEGIN
      ClearClick(Sender);
      Zahl_Setzen(Pi);
      Speicher_gueltig := TRUE;
    END; {IF HexLabel.Visible ...}
  END; {IF NOT(Errorlabel.Visible) ...}
end;

procedure TTaschenrechner.ModeClick(Sender: TObject);
begin
  IF NOT(Errorlabel.Visible) THEN BEGIN
    ModeLabel.Visible := NOT(ModeLabel.Visible);
  END; {IF NOT(Errorlabel.Visible) ...}
end;

procedure TTaschenrechner.ShiftClick(Sender: TObject);
begin
  IF NOT(Errorlabel.Visible) THEN BEGIN
    ShiftLabel.Visible := NOT(ShiftLabel.Visible);
  END; {IF NOT(Errorlabel.Visible) ...}
end;

procedure TTaschenrechner.HypClick(Sender: TObject);
begin
  IF NOT(Errorlabel.Visible) THEN BEGIN
    IF HexLabel.Visible THEN HexBehandlung(Sender)
    ELSE HypLabel.Visible := NOT(HypLabel.Visible);
  END; {IF NOT(Errorlabel.Visible) ...}
end;

procedure TTaschenrechner.LogoDblClick(Sender: TObject);
begin
  MessageDlg('(c) copyright by I. Pietschmann', mtInformation, [mbOk], 0);
end;

procedure TTaschenrechner.TypDblClick(Sender: TObject);
begin
  MessageDlg('my birthday 15.04.(1970)', mtInformation, [mbOk], 0);
end;

procedure TTaschenrechner.ExitlabelClick(Sender: TObject);
begin
  Close;
end;

end.
 