{$I PIETOOLS.INC}
unit PieTaschenrechner;

interface

uses
  SysUtils, Windows, Messages, Classes,
  Controls, Forms, Graphics,
  PieTaschenrechner1;

type
  TPieCalculator = class(TComponent)
  private
    FBorderStyle: TFormBorderStyle;
    FFormStyle: TFormStyle;
    FHelpContext: THelpContext;
    FCalculatorLeft: Integer;
    FCalculatorTop: Integer;
    FCaption: String;
    FUNCTION Ausfuehren(Art: Byte): Boolean;
  public
    constructor Create(AOwner: TComponent); override;
    function Execute: Boolean;
    procedure Show;
  published
    property BorderStyle: TFormBorderStyle read FBorderStyle write FBorderStyle default bsSingle;
    property Caption: String read FCaption write FCaption;
    property FormStyle: TFormStyle read FFormStyle write FFormStyle default fsStayOnTop;
    property HelpContext: THelpContext read FHelpContext write FHelpContext;
    property CalculatorLeft: Integer read FCalculatorLeft write FCalculatorLeft default 10;
    property CalculatorTop: Integer read FCalculatorTop write FCalculatorTop default 10;
  end;



implementation

function TPieCalculator.Ausfuehren(Art: Byte): Boolean;
begin
  Result := TRUE;
  Taschenrechner := TTaschenrechner.Create(Application);
  Taschenrechner.BorderStyle := FBorderStyle;
  Taschenrechner.FormStyle := FFormStyle;
  Taschenrechner.Left := FCalculatorLeft;
  Taschenrechner.Top := FCalculatorTop;
  Taschenrechner.Caption := FCaption;
  Taschenrechner.HelpContext := FHelpContext;
  CASE Art OF
    1:
    try
      Result := (Taschenrechner.ShowModal = IDOK);
    finally
      Taschenrechner.Free;
    end;
    2: Taschenrechner.Show;
  END;
end;

function TPieCalculator.Execute: Boolean;
begin
  Result := Ausfuehren(1);
end;

procedure TPieCalculator.Show;
begin
  Ausfuehren(2);
end;

constructor TPieCalculator.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FBorderStyle := bsSingle;
  FFormStyle := fsStayOnTop;
  FCalculatorLeft := 10;
  FCalculatorTop := 10;
  FCaption := 'Calculator';
  FHelpContext := 0;
end;

end.
