{$I PIETOOLS.INC}
unit PieSchiebefix;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  ExtCtrls, StdCtrls, Buttons;

type
  TDimension = (dm4x4, dm5x5, dm6x6, dm7x7, dm8x8, dm9x9, dm10x10);
  TSFStyle = (SfZahlen, SfText);

  TPieSchiebefixspiel = class(TWinControl)
  protected
    procedure SteinClick(Sender: TObject);
    procedure GlyphChange(Sender: TObject);
  private
    { Private-Deklarationen }
    Spielfeld: TPanel;
    Stein: array[1..SQR(10)-1] of TBitBtn;
    AnzahlS : Integer;
    FActive: Boolean;
    FDimension: TDimension;
    FGlyph: TBitmap;
    FLayout: TButtonLayout;
    FHoleColor: TColor;
    FNumGlyphs: TNumGlyphs;
    FSFStyle: TSFStyle;
    FxText: array[4..10] of string;
    FTurnNumber: Integer;
    FOnChange: TNotifyEvent;
    FOnWin: TNotifyEvent;
    function GetxText(Index: Integer): string;
    procedure Steine_beschriften;
    PROCEDURE Steine_positionieren;
    PROCEDURE Sieg_pruefen;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure SetDimension(Value: TDimension);
    procedure SetActive(Value: Boolean);
    procedure SetGlyph(Value: TBitmap);
    procedure SetLayout(Value: TButtonLayout);
    procedure SetHoleColor(Value: TColor);
    procedure SetNumGlyphs(Value: TNumGlyphs);
    procedure SetSFStyle(Value: TSFStyle);
    procedure SetxText(Index: Integer; Value: string);
  public      {PieSchiebefix}
    { Public-Deklarationen }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    PROCEDURE NewGame;
  published
    property Active: Boolean read FActive write SetActive default TRUE;
    property Align;
    property Cursor;
    property Dimension: TDimension read FDimension write SetDimension default dm4x4;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property Glyph: TBitmap read FGlyph write SetGlyph;
    property HoleColor: TColor read FHoleColor write SetHoleColor default clBtnFace;
    property Layout: TButtonLayout read FLayout write SetLayOut default blGlyphLeft;
    property NumGlyphs: TNumGlyphs read FNumGlyphs write SetNumGlyphs default 1;
    property ParentShowHint;
    property PopupMenu;
    property SFStyle: TSFStyle read FSFStyle write SetSFStyle default SfZahlen;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Text4x4:   string index 4  read GetxText write SetxText;
    property Text5x5:   string index 5  read GetxText write SetxText;
    property Text6x6:   string index 6  read GetxText write SetxText;
    property Text7x7:   string index 7  read GetxText write SetxText;
    property Text8x8:   string index 8  read GetxText write SetxText;
    property Text9x9:   string index 9  read GetxText write SetxText;
    property Text10x10: string index 10 read GetxText write SetxText;
    property Visible;
    property TurnNumber: Integer read FTurnNumber;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    property OnEnter;
    property OnExit;
    property OnWin: TNotifyEvent read FOnWin write FOnWin;
  end;

(* Spielfeldaufteilung
   1   2   3   4
   5   6   7   8
   9   10  11  12
   13  14  15  16
 *)

implementation

USES PieHerk;

{**********************************************************************}
{**************** NewGame *********************************************}
{**********************************************************************}
PROCEDURE TPieSchiebefixspiel.NewGame;
VAR
  I, J: Integer;
  Freifeld, Steinfeld: Integer;
  FX, FY: Integer;
BEGIN
  {Steinpositionen verteilen (1..15}
  FOR I:=1 TO (SQR(AnzahlS) - 1) DO Stein[I].Tag := I;
  Freifeld :=  SQR(AnzahlS);
  FOR J:=1 TO SQR(AnzahlS) * 30 DO BEGIN
    FX := (FreiFeld-1) MOD AnzahlS;
    FY := (FreiFeld-1) DIV AnzahlS;
    Steinfeld := 0;
    CASE Random(4) OF
    0: IF FX > 0         THEN Steinfeld := Freifeld-1       ELSE Steinfeld := Freifeld+1; {Links nach Rechts}
    1: IF FX < AnzahlS-1 THEN Steinfeld := Freifeld+1       ELSE Steinfeld := Freifeld-1; {Rechts nach Links}
    2: IF FY > 0         THEN Steinfeld := Freifeld-AnzahlS ELSE Steinfeld := Freifeld+AnzahlS; {Oben nach Unten}
    3: IF FY < AnzahlS-1 THEN Steinfeld := Freifeld+AnzahlS ELSE Steinfeld := Freifeld-AnzahlS; {Unten nach Oben}
    END;
    IF Steinfeld > 0 THEN BEGIN
     {wenn Stein Nachbar von freiem Platz ist, dann verschieben}
      I := 0;
      REPEAT
        inc(I);
      UNTIL Stein[I].Tag = Steinfeld;
      Stein[I].Tag := FreiFeld;
      Freifeld := Steinfeld;
    END;
  END;
  FTurnNumber := 0;
  Steine_positionieren;
END;
{**********************************************************************}
{**************** Steine_beschriften **********************************}
{**********************************************************************}
PROCEDURE TPieSchiebefixspiel.Steine_beschriften;
VAR
  I: Integer;
  T: string;
BEGIN
  {Steine positionieren}
  T := GetxText(Integer(FDimension)+4);
  FOR I:=1 TO (SQR(AnzahlS) - 1) DO WITH Stein[I] DO BEGIN
    CASE FSFStyle OF
    SfZahlen: Caption := Str_Number(I);
    SfText: Caption := T[I];
    END;
  END;
END;
{**********************************************************************}
{**************** Steine_positionieren ********************************}
{**********************************************************************}
PROCEDURE TPieSchiebefixspiel.Steine_positionieren;
VAR
  I: Integer;
BEGIN
  Spielfeld.Width := Width;
  Spielfeld.Height := Height;
  {Steine positionieren}
  FOR I:=1 TO (SQR(AnzahlS) - 1) DO WITH Stein[I] DO BEGIN
    Width := Spielfeld.Width DIV AnzahlS;
    Height := Spielfeld.Height DIV AnzahlS;
    Top  := ((Tag-1) DIV AnzahlS) * Height;
    Left := ((Tag-1) MOD AnzahlS) * Width;
  END;
END;
{**********************************************************************}
{**************** Sieg_pruefen ****************************************}
{**********************************************************************}
PROCEDURE TPieSchiebefixspiel.Sieg_pruefen;
VAR
  Prueffeld: Integer;
  Fertig: Boolean;
  T: string;
BEGIN
  T := GetxText(Integer(FDimension)+4);
  {berprfen, ob alle Steine richtig sitzen}
  PruefFeld := 0;
  REPEAT
    inc(PruefFeld);
    CASE FSFStyle OF
    SfZahlen: Fertig := Stein[Prueffeld].Tag = Prueffeld;
    SfText:   Fertig := Stein[Prueffeld].Caption = T[Stein[Prueffeld].Tag];
    ELSE Fertig := FALSE;
    END;
  UNTIL NOT(Fertig) OR (PruefFeld = SQR(AnzahlS) - 1);
  IF Fertig AND assigned(FOnWin) THEN FOnWin(Self);
END;

constructor TPieSchiebefixspiel.Create(AOwner: TComponent);
CONST
  T = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
VAR
  I: Integer;
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle - [csAcceptsControls, csSetCaption] +
    [csFramed, csOpaque];
  Parent := AOwner as TWinControl;
  AnzahlS := 0;
  FActive := TRUE;
  FSFStyle := SfZahlen;
  FOR I:=4 TO 10 DO FxText[I] := Rightpad(T, I*I-1);
  Randomize;
  FDimension := dm5x5;
  SetDimension(dm4x4); {Steine erzeugen}
  Width := 120;
  Height := 120;
  FHoleColor := clBtnFace;
  FGlyph := TBitmap.Create;
  FGlyph.Assign(Stein[1].Glyph);
  FGlyph.OnChange := GlyphChange;
  FNumGlyphs := 1;
  FLayout := blGlyphLeft;
  FTurnNumber := 0;
end;

destructor TPieSchiebefixspiel.Destroy;
begin
  Spielfeld.Free;
  FGlyph.Free;
  inherited Destroy;
end;

procedure TPieSchiebefixspiel.SteinClick(Sender: TObject);
VAR
  FreiFeld, Steinfeld, I: Integer;
  Besetzt : Boolean;
  FX, FY, SX, SY: Integer;
begin
  Steinfeld := (Sender as TBitBtn).Tag;
  {freien Platz ermitteln}
  FreiFeld := 0;
  REPEAT
    inc(FreiFeld);
    Besetzt := FALSE;
    FOR I:=1 TO SQR(AnzahlS) - 1 DO IF Stein[I].Tag = FreiFeld THEN Besetzt := TRUE;
  UNTIL NOT(Besetzt) OR (FreiFeld = SQR(AnzahlS));
  {wenn Stein Nachbar von freiem Platz ist, dann verschieben}
  FX := (FreiFeld-1)  MOD AnzahlS;
  FY := (FreiFeld-1)  DIV AnzahlS;
  SX := (SteinFeld-1) MOD AnzahlS;
  SY := (SteinFeld-1) DIV AnzahlS;
  IF {X-Nachbarn}(((FX + 1 = SX) OR (FX - 1 = SX)) AND (FY = SY)) OR
     {Y-Nachbarn}(((FY + 1 = SY) OR (FY - 1 = SY)) AND (FX = SX)) THEN BEGIN
    (Sender as TBitBtn).Tag := FreiFeld;
    inc(FTurnNumber);
    Steine_positionieren;
    Sieg_pruefen;
    IF assigned(FOnChange) THEN FOnChange(Self);
  END;
end;

procedure TPieSchiebefixspiel.WMSize(var Message: TWMSize);
begin
  inherited;
  {mind. 4 Pixel!!!}
  if Height < SQR(AnzahlS) then Height := SQR(AnzahlS);
  if Width  < SQR(AnzahlS) then Width  := SQR(AnzahlS);
  inherited SetBounds(Left, Top, Width, Height);
  IF AnzahlS > 0 THEN Steine_positionieren;
end;

procedure TPieSchiebefixspiel.SetDimension(Value: TDimension);
VAR
  I: Integer;
begin
  IF Value <> FDimension THEN BEGIN
    FDimension := Value;
    IF assigned(Spielfeld) THEN Spielfeld.Free;
    CASE FDimension OF
    dm4x4: AnzahlS := 4;
    dm5x5: AnzahlS := 5;
    dm6x6: AnzahlS := 6;
    dm7x7: AnzahlS := 7;
    dm8x8: AnzahlS := 8;
    dm9x9: AnzahlS := 9;
    dm10x10: AnzahlS := 10;
    END;
    Spielfeld := TPanel.Create(Self);
    Spielfeld.Left := 1;
    Spielfeld.Top := 1;
    Spielfeld.Parent := Self;
    FOR I:=1 TO (SQR(AnzahlS) - 1) DO BEGIN
      Stein[I] := TBitbtn.Create(Spielfeld);
      Stein[I].Glyph.Assign(FGlyph);
      Stein[I].NumGlyphs := FNumGlyphs;
      Stein[I].Layout := FLayout;
      Stein[I].Parent := Spielfeld;
      Stein[I].Enabled := FActive;
      Stein[I].OnClick := SteinClick;
      Stein[I].Tag := I;
    END;
    Steine_beschriften;
    Steine_positionieren;
  END;
end;

procedure TPieSchiebefixspiel.SetHoleColor(Value: TColor);
begin
  IF Value <> FHoleColor THEN BEGIN
    FHoleColor := Value;
    Spielfeld.Color := FHoleColor;
  END;
end;

procedure TPieSchiebefixspiel.SetGlyph(Value: TBitmap);
VAR
  I: Integer;
begin
  FGlyph.Assign(Value);
  IF AnzahlS > 0 THEN FOR I:=1 TO (SQR(AnzahlS) - 1) DO IF assigned(Stein[I])
     THEN Stein[I].Glyph.Assign(FGlyph);
end;

procedure TPieSchiebefixspiel.SetNumGlyphs(Value: TNumGlyphs);
VAR
  I: Integer;
begin
  IF Value <> FNumGlyphs THEN BEGIN
    FNumGlyphs := Value;
    IF AnzahlS > 0 THEN FOR I:=1 TO (SQR(AnzahlS) - 1) DO IF assigned(Stein[I])
       THEN Stein[I].NumGlyphs := FNumGlyphs;
  END;
end;

procedure TPieSchiebefixspiel.SetLayout(Value: TButtonLayout);
VAR
  I: Integer;
begin
  IF Value <> FLayout THEN BEGIN
    FLayout := Value;
    IF AnzahlS > 0 THEN FOR I:=1 TO (SQR(AnzahlS) - 1) DO IF assigned(Stein[I])
       THEN Stein[I].Layout := FLayout;
  END;
end;

procedure TPieSchiebefixspiel.SetSFStyle(Value: TSFStyle);
begin
  IF Value <> FSFStyle THEN BEGIN
    FSFStyle := Value;
    Steine_beschriften;
  END;
end;

function TPieSchiebefixspiel.GetxText(Index: Integer): string;
begin
  Result := FxText[Index];
end;

procedure TPieSchiebefixspiel.SetxText(Index: Integer; Value: string);
begin
  IF Value <> FxText[Index] THEN BEGIN
    FxText[Index] := Rightpad(Value, Index*Index-1);
    IF Integer(FDimension) = Index THEN Steine_beschriften;
  END;
end;

procedure TPieSchiebefixspiel.GlyphChange(Sender: TObject);
VAR
  I: Integer;
begin
  IF AnzahlS > 0 THEN FOR I:=1 TO (SQR(AnzahlS) - 1) DO IF assigned(Stein[I])
     THEN Stein[I].Glyph.Assign(FGlyph);
end;

procedure TPieSchiebefixspiel.SetActive(Value: Boolean);
VAR
  I: Integer;
begin
  IF Value <> FActive THEN BEGIN
    FActive := Value;
    Enabled := FActive;
    IF AnzahlS > 0 THEN FOR I:=1 TO (SQR(AnzahlS) - 1) DO IF assigned(Stein[I])
       THEN Stein[I].Enabled := FActive;
  END;
end;


end.
