{$I PIETOOLS.INC}
unit PiePfeil;

interface

uses
  Windows, Controls, Classes, Graphics, Messages;

TYPE
  TPieArrowTyp = (ptNormal, ptArc, ptAntiArc);
  TPieArrow = class(TGraphicControl)
  private
    FPen: TPen;
    FBrush: TBrush;
    FPfeilTyp: TPieArrowTyp;
    FPfeilBreite: Integer;
    FStart: TPoint;
    FZiel: TPoint;
    FAltPos: TPoint; {Alte Position des Controls (beim Verschieben)}
    FTransparent: Boolean;
    AnpassenProc: Boolean;
    procedure WMWindowPosChanged(var Message: TWMWindowPosChanged); message WM_WINDOWPOSCHANGED;
    procedure Anpassen;
    procedure SetBrush(Value: TBrush);
    procedure SetPen(Value: TPen);
    procedure SetPfeiltyp(Value: TPieArrowTyp);
    procedure SetPfeilBreite(Value: Integer);
    procedure SetStartX(Value: Integer);
    procedure SetStartY(Value: Integer);
    procedure SetZielX(Value: Integer);
    procedure SetZielY(Value: Integer);
    procedure SetTransparent(Value: Boolean);
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    procedure StyleChanged(Sender: TObject);
    property Align;
    property Brush: TBrush read FBrush write SetBrush;
    property DragCursor;
    property DragMode;
    property Enabled;
    property ParentShowHint;
    property Pen: TPen read FPen write SetPen;
    property ArrowType: TPieArrowTyp read FPfeiltyp write SetPfeilTyp default ptNormal;
    property ArrowWidth: Integer read FPfeilBreite write SetPfeilBreite;
    property Transparent: Boolean read FTransparent write SetTransparent;
    property StartX: Integer read FStart.X write SetStartX;
    property StartY: Integer read FStart.Y write SetStartY;
    property TargetX: Integer read FZiel.X write SetZielX;
    property TargetY: Integer read FZiel.Y write SetZielY;
    property ShowHint;
    property Visible;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
  end;

implementation

{ TPieArrow }

constructor TPieArrow.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csReplicatable];
  AnpassenProc := FALSE;
  FAltPos := Point(Left, Top);
  FStart := Point(10, 10);
  FZiel := Point(60, 60);
  FPen := TPen.Create;
  FPen.OnChange := StyleChanged;
  FBrush := TBrush.Create;
  FBrush.OnChange := StyleChanged;
  FPfeilBreite := 10; {Pixel}
  FPen.Width := 2;
  FTransparent := FALSE;
end;

destructor TPieArrow.Destroy;
begin
  FPen.Free;
  FBrush.Free;
  inherited Destroy;
end;

procedure TPieArrow.WMWindowPosChanged(var Message: TWMWindowPosChanged);
begin
  inherited;
  IF NOT(AnpassenProc) THEN BEGIN
    FStart.X := FStart.X - FAltPos.X + Left;
    FStart.Y := FStart.Y - FAltPos.Y + Top;
    FZiel.X := FZiel.X - FAltPos.X + Left;
    FZiel.Y := FZiel.Y - FAltPos.Y + Top;
    FAltPos := Point(Left, Top);
    Anpassen;
  END;
end;

procedure TPieArrow.Anpassen;
VAR
  D: Integer;
begin
  AnpassenProc := TRUE;
  IF FStart.X < FZiel.X THEN Left := FStart.X ELSE Left := FZiel.X;
  IF FStart.Y < FZiel.Y THEN Top := FStart.Y ELSE Top := FZiel.Y;
  CASE FPfeilTyp OF
  ptNormal: BEGIN
            Left := Left - FPfeilbreite-1;
            Top := Top - FPfeilbreite-1;
            Width := Abs(FStart.X - FZiel.X)+2*FPfeilbreite+2;
            Height := Abs(FStart.Y - FZiel.Y)+2*FPfeilbreite+2;
            END;
  ptArc, ptAntiArc: BEGIN
            {max. Durchmesser ermitteln}
            D := round(SQRT(SQR(FStart.Y-FZiel.Y) + SQR(FStart.X-FZiel.X))) + FPfeilbreite;
            {Radius ermitteln}
            D := D DIV 2;
            Left := Abs(FZiel.X-FStart.X) DIV 2 + Left - D;
            Top := Abs(FZiel.Y-FStart.Y) DIV 2 + Top - D;
            Width := 2*D;
            Height := 2*D;
            END;
  END;
  AnpassenProc := FALSE;
end;

procedure TPieArrow.Paint;
CONST
  Gamma = Pi/180*20;
var
  X1, Y1, X2, Y2, B, Bx, By, Spx, Spy: Integer;
  Alpha, Beta, C, R, SinW, CosW: Extended;
  RR, Mx, My, X5, Y5, X6, Y6, X7, Y7, X8, Y8, XF, YF: Integer;
begin
  with Canvas do begin
    Pen := FPen;
    Brush := FBrush;
    B := FPfeilbreite DIV 2;
    X1 := FStart.X-Left;
    Y1 := FStart.Y-Top;
    X2 := FZiel.X -Left;
    Y2 := FZiel.Y -Top;
    Beta := 0; Alpha := 0; C := 1;
    IF (Y2=Y1) OR (X2=X1) THEN BEGIN
      IF X2=X1 THEN BEGIN {vertikal}
        Alpha := 0;
        Beta := Pi/2;
        C := Y2-Y1;
      END;
      IF Y2=Y1 THEN BEGIN {horiz.al}
        Alpha := Pi/2;
        Beta := 0;
        C := X2-X1;
      END;
    END
    ELSE BEGIN
      Alpha := arctan((X2-X1)/(Y2-Y1));
      Beta := arctan((Y2-Y1)/(X2-X1));
      C := (X2-X1)/sin(Alpha);
    END;
    CASE FPfeilTyp OF
    ptNormal: BEGIN
              Bx := round(B * sin(Beta));
              By := round(B * sin(Alpha));
              Spx := round(C/10 * sin(Alpha));
              Spy := round(C/10 * sin(Beta));
              IF Alpha >= 0 THEN BEGIN
                MoveTo(X1+Bx, Y1-By);
                LineTo(X1-Bx, Y1+By);
                LineTo(X2-SpX-Bx, Y2-SpY+By);
                LineTo(X2-SpX-2*Bx, Y2-SpY+2*By);
                LineTo(X2, Y2);
                LineTo(X2-SpX+2*Bx, Y2-SpY-2*By);
                LineTo(X2-SpX+Bx, Y2-SpY-By);
                LineTo(X1+Bx, Y1-By);
              END
              ELSE BEGIN
                MoveTo(X1+Bx, Y1+By);
                LineTo(X1-Bx, Y1-By);
                LineTo(X2-SpX-Bx, Y2+SpY-By);
                LineTo(X2-SpX-2*Bx, Y2+SpY-2*By);
                LineTo(X2, Y2);
                LineTo(X2-SpX+2*Bx, Y2+SpY+2*By);
                LineTo(X2-SpX+Bx, Y2+SpY+By);
                LineTo(X1+Bx, Y1+By);
              END;
              IF NOT(FTransparent) THEN
                FloodFill(Width DIV 2, Height DIV 2,Pen.Color,fsBorder);
              END; {ptNormal}
    ptArc, ptAntiArc:
              BEGIN
              R := C/2; {Radius}
              Mx := (X2-X1) DIV 2;
              My := (Y2-Y1) DIV 2;
              IF Beta >= 0 THEN BEGIN
                Bx := round(B * cos(Beta));
                By := round(B * sin(Beta));
                IF FPfeiltyp = ptArc THEN BEGIN
                  SinW := sin(Beta+Gamma);
                  CosW := Cos(Beta+Gamma);
                END
                ELSE BEGIN
                  SinW := sin(Beta-Gamma);
                  CosW := Cos(Beta-Gamma);
                END;
              END
              ELSE BEGIN
                Bx := round(B * -cos(Beta));
                By := round(B * -sin(Beta));
                IF FPfeiltyp = ptArc THEN BEGIN
                  SinW := -sin(Beta+Gamma);
                  CosW := -Cos(Beta+Gamma);
                END
                ELSE BEGIN
                  SinW := -sin(Beta-Gamma);
                  CosW := -Cos(Beta-Gamma);
                END;
              END;

              X5 := round((R+B) * cosW) + Mx;
              Y5 := round((R+B) * sinW) + My;
              X6 := round((R-B) * cosW) + Mx;
              Y6 := round((R-B) * sinW) + My;
              X7 := round((R+2*B) * cosW) + Mx;
              Y7 := round((R+2*B) * sinW) + My;
              X8 := round((R-2*B) * cosW) + Mx;
              Y8 := round((R-2*B) * sinW) + My;
              XF := round(R * cosW) + Mx;
              YF := round(R * sinW) + My;

              RR:= round(R)-B;
              IF FPfeiltyp = ptArc
                THEN Arc(X1+Mx-RR, Y1+My-RR, X1+Mx+RR, Y1+My+RR, X1+Bx, Y1+By, X1+X6, Y1+Y6)
                ELSE Arc(X1+Mx-RR, Y1+My-RR, X1+Mx+RR, Y1+My+RR, X1+X6, Y1+Y6, X1+Bx, Y1+By);
              RR:= round(R)+B;
              IF FPfeiltyp = ptArc
                THEN Arc(X1+Mx-RR, Y1+My-RR, X1+Mx+RR, Y1+My+RR, X1-Bx, Y1-By, X1+X5, Y1+Y5)
                ELSE Arc(X1+Mx-RR, Y1+My-RR, X1+Mx+RR, Y1+My+RR, X1+X5, Y1+Y5, X1-Bx, Y1-By);
              MoveTo(X1-Bx, Y1-By);
              LineTo(X1+Bx, Y1+By);
              MoveTo(X1+X6, Y1+Y6);
              LineTo(X1+X8, Y1+Y8);
              LineTo(X2, Y2);
              LineTo(X1+X7, Y1+Y7);
              LineTo(X1+X5, Y1+Y5);
              IF NOT(FTransparent) THEN
                FloodFill(X1+XF,Y1+YF,Pen.Color,fsBorder);
              END; {ptArc, ptAntiArc}
    END; {CASE FPfeiltyp ...}
  end;
end;

procedure TPieArrow.StyleChanged(Sender: TObject);
begin
  Invalidate;
end;

procedure TPieArrow.SetBrush(Value: TBrush);
begin
  FBrush.Assign(Value);
end;

procedure TPieArrow.SetPen(Value: TPen);
begin
  FPen.Assign(Value);
end;

procedure TPieArrow.SetPfeilTyp(Value: TPieArrowTyp);
begin
  if FPfeilTyp <> Value then begin
    FPfeilTyp := Value;
    Anpassen;
    Invalidate;
  end;
end;

procedure TPieArrow.SetPfeilBreite(Value: Integer);
begin
  if FPfeilBreite <> Value then begin
    FPfeilBreite := Value;
    Anpassen;
    Invalidate;
  end;
end;

procedure TPieArrow.SetTransparent(Value: Boolean);
begin
  if FTransparent <> Value then begin
    FTransparent := Value;
    Invalidate;
  end;
end;

procedure TPieArrow.SetStartX(Value: Integer);
begin
  if FStart.X <> Value then begin
    FStart.X := Value;
    Anpassen;
    Invalidate;
  end;
end;

procedure TPieArrow.SetStartY(Value: Integer);
begin
  if FStart.Y <> Value then begin
    FStart.Y := Value;
    Anpassen;
    Invalidate;
  end;
end;

procedure TPieArrow.SetZielX(Value: Integer);
begin
  if FZiel.X <> Value then begin
    FZiel.X := Value;
    Anpassen;
    Invalidate;
  end;
end;

procedure TPieArrow.SetZielY(Value: Integer);
begin
  if FZiel.Y <> Value then begin
    FZiel.Y := Value;
    Anpassen;
    Invalidate;
  end;
end;


end.

