{$I PIETOOLS.INC}
unit PiePageControl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls;

type

  TPiePageControl = class(TPageControl)
  private
    { Private-Deklarationen }
    FBackground: TPicture;
    FBackgroundForRest: Boolean;
    procedure SetBackground(Value: TPicture);
    procedure SetBackgroundForRest(Value: Boolean);
    procedure BackGroundChange(Sender: TObject);
    procedure PaintBackground(ACanvas: TCanvas; ARect: TRect);
  protected
    { Protected-Deklarationen }
    procedure DrawTab(TabIndex: Integer; const Rect: TRect; Active: Boolean); override;
  public
    { Public-Deklarationen }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published-Deklarationen }
    property Background: TPicture read FBackground write SetBackground;
    property BackgroundForRest: Boolean read FBackgroundForRest write SetBackgroundForRest default TRUE;
  end;


implementation

//*********** TPiePageControl ********************
constructor TPiePageControl.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle - [csOpaque];
  FBackground := TPicture.Create;
  FBackground.OnChange := BackgroundChange;
  FBackgroundForRest := TRUE;
end;

destructor TPiePageControl.Destroy;
begin
  FBackground.Free;
  inherited Destroy;
end;

procedure TPiePageControl.SetBackground(Value: TPicture);
BEGIN
  FBackground.Assign(Value);
  Repaint;
END;

procedure TPiePageControl.BackgroundChange(Sender: TObject);
BEGIN
  Repaint;
END;

procedure TPiePageControl.SetBackgroundForRest(Value: Boolean);
BEGIN
  IF FBackgroundForRest <> Value THEN BEGIN
    FBackgroundForRest := Value;
    Repaint;
  END;
END;

procedure TPiePageControl.DrawTab(TabIndex: Integer; const Rect: TRect; Active: Boolean);
VAR
  CR, R, RestRect: TRect;
  TS: TTabSheet;
BEGIN
  TS := Pages[TabIndex];
  CR := GetClientRect;
  R := Rect;
  WITH Canvas DO BEGIN
    {******* Hintergund - RestMen malen ***********}
    IF FBackgroundForRest AND (TabIndex = PageCount - 1) THEN BEGIN
      RestRect := classes.Rect(R.Right, CR.Top, CR.Right+3, R.Bottom);
      IF Active THEN RestRect.Bottom := RestRect.Bottom-4;
      PaintBackground(Canvas, RestRect);
    END;
    {******* Hintergund - Item malen ***********}
    IF Active THEN R.Bottom := R.Bottom - 4;
    PaintBackground(Canvas, R);
    {******* unteren Bereich des selektierten Items normal malen *********}
    IF Active THEN BEGIN
      RestRect := Rect;
      RestRect.Top := R.Bottom;
      Brush.Color := clBtnFace;
      FillRect(RestRect);
    END;
    {******* Text zeichnen ******************}
    Brush.Style := bsClear;
{    IF Active THEN Font.Style := Font.Style + [fsBold]
              ELSE Font.Style := Font.Style - [fsBold];}
    TextOut(Rect.Left+2, Rect.Top+2, TS.Caption);
  END;
END;

procedure TPiePageControl.PaintBackground(ACanvas: TCanvas; ARect: TRect);
VAR
  CR, R: TRect;
  B, H, I, J: Integer;
  P : TPicture;
  Pos1: TRect; {Position des gesamten Pattern im Canvas}
  Pos2: TRect; {Position des darzustellenden Teilpattern im Pattern}
  Malen: Boolean;
BEGIN
  IF Assigned(FBackGround) AND Assigned(FBackGround.Graphic) THEN BEGIN
    P := TPicture.Create;
    TRY
      P.Assign(FBackGround);
      CR := ARect;
      R.Left := 0;
      R.Top := 0;
      R.Right := ARect.Right - ARect.Left;
      R.Bottom := ARect.Bottom - ARect.Top;
      H := P.Graphic.Height;
      B := P.Graphic.Width;
      IF (H>0) AND (B>0) THEN BEGIN

        FOR I := 0 TO ((CR.Right - CR.Left) DIV B) DO
        FOR J := 0 TO ((CR.Bottom - CR.Top) DIV H) DO BEGIN
          Pos1 := Rect(I*B, J*H, (I+1)*B, (J+1)*H);
          Malen := (Pos1.Left < R.Right) AND (Pos1.Right > R.Left) AND
                   (Pos1.Top < R.Bottom) AND (Pos1.Bottom > R.Top);

          IF Malen THEN BEGIN
            Pos2 := Rect(R.Left-I*B, R.Top-J*H, R.Right-I*B, R.Bottom-J*H);
            IF Pos2.Left   < 0 THEN Pos2.Left   := 0;
            IF Pos2.Top    < 0 THEN Pos2.Top    := 0;
            IF Pos2.Right  > B THEN Pos2.Right  := B;
            IF Pos2.Bottom > H THEN Pos2.Bottom := H;

            IF (Pos2.Left > 0) OR (Pos2.Top > 0) THEN
            BitBlt(P.Bitmap.Canvas.Handle, 0, 0,
                  (Pos2.Right-Pos2.Left),
                  (Pos2.Bottom-Pos2.Top),
                   P.Bitmap.Canvas.Handle, Pos2.Left, Pos2.Top,
                   srcCopy);

            P.Graphic.Width := Pos2.Right-Pos2.Left;
            P.Graphic.Height := Pos2.Bottom-Pos2.Top;
            ACanvas.Draw(Pos1.Left + Pos2.Left + ARect.Left,
                         Pos1.Top  + Pos2.Top  + ARect.Top,
                         P.Graphic);
            P.Assign(FBackGround);
          END;
        END;

      END;  {IF (H>0) AND ...}
    FINALLY
      P.Free;
    END;
  END;
END;


end.
