{$I PIETOOLS.INC}
unit PieMemoDialog1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, PieMemoDialog2, StdCtrls;

type
  TPieMemoDialog = class(TComponent)
  private
    FMemoCaption, FCaption, FCBCaption,
    FMemoText, FOkButtonCaption, FCancelButtonCaption: string;
    FMaxLength: Word;
    FScrollBars: TScrollStyle;
    FCBChecked, FCBVisible, FWantTabs, FWantReturns, FWordWrap, FOnlyOkButton, FReadOnly: Boolean;
    FLeft, FTop: Integer;
    FPosition: TPosition;
    FColor, FMemoColor: TColor;
  function GetFont: TFont;
  procedure SetFont(Value: TFont);
  public
    Constructor Create(AOwner: TComponent); override;
    Destructor Destroy; override;
    function Execute: Boolean;
  published
    property CancelButtonCaption: string read FCancelButtonCaption write FCancelButtonCaption;
    property Caption: string read FCaption write FCaption;
    property CheckBoxCaption: string read FCBCaption write FCBCaption;
    property CheckBoxChecked: Boolean read FCBChecked write FCBChecked default FALSE;
    property CheckBoxVisible: Boolean read FCBVisible write FCBVisible default FALSE;
    property Color: TColor read FColor write FColor default clBtnFace;
    property Font: TFont read GetFont write SetFont;
    property DialogLeft: Integer read FLeft write FLeft;
    property DialogTop: Integer read FTop write FTop;
    property MaxLength: Word read FMaxLength write FMaxLength default 0;
    property MemoCaption: string read FMemoCaption write FMemoCaption;
    property MemoColor: TColor read FMemoColor write FMemoColor default clWindow;
    property MemoText: string read FMemotext write FMemotext;
    property OkButtonCaption: string read FOkButtonCaption write FOkButtonCaption;
    property OnlyOkButton: Boolean read FOnlyOkButton write FOnlyOkButton default FALSE;
    property Position: TPosition read FPosition write FPosition default poDesigned;
    property ReadOnly: Boolean read FReadOnly write FReadOnly default FALSE;
    property ScrollBars: TScrollStyle read FScrollBars write FScrollBars default ssNone;
    property WantTabs: Boolean read FWantTabs write FWantTabs default TRUE;
    property WantReturns: Boolean read FWantReturns write FWantReturns default TRUE;
    property WordWrap: Boolean read FWordWrap write FWordWrap default TRUE;
  end;



implementation

Constructor TPieMemoDialog.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FOkButtonCaption := '&Ok';
  FCancelButtonCaption := '&Abbrechen';
  FMemoCaption := '';
  FCaption := '';
  FCBCaption := '';
  FScrollBars := ssNone;
  FCBVisible := FALSE;
  FCBChecked := FALSE;
  FWordWrap := TRUE;
  FWantTabs := TRUE;
  FWantReturns := TRUE;
  FOnlyOkButton := FALSE;
  FReadOnly := FALSE;
  FLeft := 100;
  FTop := 100;
  FPosition := poDesigned;
  FColor := clBtnFace;
  FMemoColor := clWindow;
  MemoDialog := TMemoDialog.Create(Self);
END;

Destructor TPieMemoDialog.Destroy;
begin
  MemoDialog.Free;
  inherited;
end;

function TPieMemoDialog.GetFont: TFont;
begin
  Result := MemoDialog.Font;
end;

procedure TPieMemoDialog.SetFont(Value: TFont);
begin
  MemoDialog.Font.Assign(Value);
end;

function TPieMemoDialog.Execute: Boolean;
begin
   { Create dialog in memory }
   WITH MemoDialog DO BEGIN
     { Set dialog strings }
     Left := FLeft;
     Top := FTop;
     Position := FPosition;
     Color := FColor;
     BitBtn1.Caption := FOkButtonCaption;
     BitBtn2.Caption := FCancelButtonCaption;
     Label1.Caption := FMemoCaption;
     Caption := FCaption;
     CheckBox1.Caption := FCBCaption;
     CheckBox1.Checked := FCBChecked;
     CheckBox1.Visible := FCBVisible;
     Memo1.Color := FMemoColor;
     Memo1.Text := FMemoText;
     Memo1.MaxLength := FMaxLength;
     Memo1.ScrollBars := FScrollBars;
     Memo1.WantTabs := FWantTabs;
     Memo1.WantReturns := FWantReturns;
     Memo1.WordWrap := FWordWrap;
     Memo1.ReadOnly := FReadOnly;
     If FOnlyOkButton THEN BEGIN
       BitBtn2.Visible := FALSE;
       BitBtn1.Left := BitBtn2.Left;
     END;
     IF NOT FCBVisible THEN Height := Height - 20;
   END;
   {Dialog ausfhren}
   Result := (MemoDialog.ShowModal = IDOK);
   IF Result THEN BEGIN
     FMemotext    := MemoDialog.Memo1.Text;
     FCBChecked   := MemoDialog.CheckBox1.Checked;
   END;  
end;

end.
