{$I PIETOOLS.INC}
{ Autor: Ingolf Pietschmann.
  Dieser Quelltext ist Freeware. Die Verwendung und Weitergabe dieser Sourcen zu
  privaten nicht kommerziellen Zwecken ist ausdrcklich erwnscht.
  Die Verwendung zu kommerziellen Zwecken ist nur mit Erlaubnis des Autors
  gestattet. Den Autor knnen Sie unter "Support@Pie-Tools.de" erreichen.

  http://www.Pie-Tools.de

  These sources are freeware. The usage and distribution of these sources for
  private, not commercial purposes is explicit desired.
  The usage for commercial purposes is only permitted in agreement of the author.
  The author can be reached by "Support@Pie-Tools.de".
}
unit PieMainMenu;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus;

type
  TPieMenuStyle = (pmsStandard, pmsSolid, pmsBitmap);
  TPieMenuSelectStyle = (pmssBox, pmssLine, pmssEllipse, pmssArc);
  TPieMainMenu = class(TMainMenu)
  private
    { Private-Deklarationen }
    FVersion: string;
    FFont: TFont;
    FMenuStyle: TPieMenuStyle;
    FColor: TColor;
    FSelectColor: TColor;
    FSelectStyle: TPieMenuSelectStyle;
    FSelectImage: TPicture;
    FBackground: TPicture;
    FMenuHeight: Integer;
    FNoPaint   : Boolean;
    FEnabled   : Boolean;
    OriginalHeight: Integer;
    function GetMenuHeight: Integer;
    function GetMenuSize: TRect;
    procedure ItemMeasureItem(Sender: TObject; ACanvas: TCanvas; var Width, Height: Integer);
    procedure ItemDrawItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
    procedure FontChange(Sender: TObject);
    procedure Zuweisen(It: TMenuItem);
    procedure SetFont(Value: TFont);
    procedure SetMenuHeight(Value: Integer);
    procedure SetMenuStyle(Value: TPieMenuStyle);
    procedure SetColor(Value: TColor);
    procedure SetEnabled(Value: Boolean);
    procedure SetBackground(Value: TPicture);
    procedure BackGroundChange(Sender: TObject);
    procedure SetSelectImage(Value: TPicture);
    procedure PaintBackground(ACanvas: TCanvas; ARect: TRect; ASelected: Boolean);
  protected
    { Protected-Deklarationen }
    procedure Loaded; override;
    procedure DoDrawText(M: TMenuItem; ACanvas: TCanvas; const ACaption: string;
      var Rect: TRect; Selected: Boolean; Flags: Longint);
  public
    { Public-Deklarationen }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    PROCEDURE RestoreMenuHeight;
    procedure Repaint;
  published
    { Published-Deklarationen }
    property Background: TPicture read FBackground write SetBackground;
    property Color: TColor read FColor write SetColor default clBtnFace;
    property Enabled: Boolean read FEnabled write SetEnabled default TRUE;
    property Font: TFont read FFont write SetFont;
    property MenuHeight: Integer read FMenuHeight write SetMenuHeight default 18;
    property MenuStyle: TPieMenuStyle read FMenuStyle write SetMenuStyle default pmsStandard;
    property SelectColor: TColor read FSelectColor write FSelectColor default clHighlight;
    property SelectImage: TPicture read FSelectImage write SetSelectImage;
    property SelectStyle: TPieMenuSelectStyle read FSelectStyle write FSelectStyle default pmssBox;
    property Version: string read FVersion write FVersion;
  end;

implementation

constructor TPieMainMenu.Create(AOwner: TComponent);
BEGIN
  inherited Create(AOwner);
  FFont := TFont.Create;
  FFont.OnChange := FontChange;
  FFont.Name := 'MS Sans Serif';
  FFont.Style := [fsBold];
  FMenuStyle := pmsStandard;
  FColor := clBtnFace;
  FBackground := TPicture.Create;
  FBackground.OnChange := BackgroundChange;
  FSelectImage := TPicture.Create;
  FSelectColor := clHighlight;
  FSelectStyle := pmssBox;
  FMenuHeight := 18;
  FNoPaint := FALSE;
  FEnabled := TRUE;
  FVersion := '1.1';
  OriginalHeight := GetMenuHeight;
  Application.ProcessMessages;
END;

destructor TPieMainMenu.Destroy;
BEGIN
  FNoPaint := TRUE;
  Application.ProcessMessages;
  FFont.Free;
  FSelectImage.Free;
  FBackground.Free;
  inherited Destroy;
END;

PROCEDURE TPieMainMenu.RestoreMenuHeight;
BEGIN
  MenuHeight := OriginalHeight;
END;

PROCEDURE TPieMainMenu.Zuweisen(It: TMenuItem);
VAR
  I: Integer;
  S: string;
BEGIN
  S := It.Caption;
  It.Caption := '?';
  It.OnMeasureItem := ItemMeasureItem;
  It.OnDrawItem := ItemDrawItem;
  It.Caption := S;
  FOR I:=0 TO It.Count-1 DO Zuweisen(It.Items[I]);
END;

procedure TPieMainMenu.Repaint;
BEGIN
  Zuweisen(Items);
{  DrawMenuBar(WindowHandle);}
END;

PROCEDURE TPieMainMenu.Loaded;
BEGIN
  inherited Loaded;
  Repaint;
END;

procedure TPieMainMenu.FontChange(Sender: TObject);
BEGIN
  Repaint;
END;

PROCEDURE TPieMainMenu.SetFont(Value: TFont);
BEGIN
  FFont.Assign(Value);
END;

PROCEDURE TPieMainMenu.SetMenuStyle(Value: TPieMenuStyle);
BEGIN
  IF Value <> FMenuStyle THEN BEGIN
    FMenuStyle := Value;
    IF NOT(csDesigning IN ComponentState) THEN OwnerDraw := FMenuStyle <> pmsStandard;
    Repaint;
  END;
END;

PROCEDURE TPieMainMenu.SetColor(Value: TColor);
BEGIN
  IF Value <> FColor THEN BEGIN
    FColor := Value;
    IF NOT (FMenuStyle IN [pmsStandard, pmsBitmap]) THEN Repaint;
  END;
END;

PROCEDURE TPieMainMenu.SetEnabled(Value: Boolean);
VAR
  I: Integer;
BEGIN
  IF Value <> FEnabled THEN BEGIN
    FEnabled := Value;
    FOR I:=0 TO Items.Count-1 DO Items.Items[I].Enabled := FEnabled;
  END;
END;

procedure TPieMainMenu.SetSelectImage(Value: TPicture);
BEGIN
  FSelectImage.Assign(Value);
END;

procedure TPieMainMenu.SetBackground(Value: TPicture);
BEGIN
  FBackground.Assign(Value);
  IF FMenuStyle = pmsBitmap THEN Repaint;
END;

procedure TPieMainMenu.BackgroundChange(Sender: TObject);
BEGIN
  IF FMenuStyle = pmsBitmap THEN Repaint;
END;

procedure TPieMainMenu.DoDrawText(M: TMenuItem; ACanvas: TCanvas; const ACaption: string;
  var Rect: TRect; Selected: Boolean; Flags: Longint);
var
  Text: string;
  R: TRect;
  ParentMenu: TMenu;
begin
  ParentMenu := M.GetParentMenu;
  {******* Text-Ausrichtung Links/Rechts ndern ***********}
  if (ParentMenu <> nil) and (ParentMenu.IsRightToLeft) then begin
    if Flags and DT_LEFT = DT_LEFT then
      Flags := Flags and (not DT_LEFT) or DT_RIGHT
    else if Flags and DT_RIGHT = DT_RIGHT then
      Flags := Flags and (not DT_RIGHT) or DT_LEFT;
    Flags := Flags or DT_RTLREADING;
  end;
  {******* Text sei mindestens ein Space ***********}
  Text := ACaption;
  if (Flags and DT_CALCRECT <> 0) and ((Text = '') or
    (Text[1] = '&') and (Text[2] = #0)) then Text := Text + ' ';

  with ACanvas do begin
  {******* Separator malen ***********}
    if Text = '-' then begin
      if Flags and DT_CALCRECT = 0 then begin
        R := Rect;
        Inc(R.Top, 4);
        DrawEdge(Handle, R, EDGE_ETCHED, BF_TOP);
      end;
    end
  {******* Text zeichnen ***********}
    else begin
      Brush.Style := bsClear;
      if M.Default then Font.Style := Font.Style + [fsBold];
      if not M.Enabled then begin
        if not Selected then begin
          OffsetRect(Rect, 1, 1);
          Font.Color := clBtnHighlight;
          DrawText(Handle, PChar(Text), Length(Text), Rect, Flags);
          OffsetRect(Rect, -1, -1);
        end;
        if Selected and (ColorToRGB(clHighlight) = ColorToRGB(clBtnShadow)) then
          Font.Color := clBtnHighlight else
          Font.Color := clBtnShadow;
      end;
      DrawText(Handle, PChar(Text), Length(Text), Rect, Flags);
    end;
  end;
end;

function TPieMainMenu.GetMenuHeight: Integer;
var
  NonClientMetrics: TNonClientMetrics;
begin
  Result := FMenuHeight;
  IF NOT(csDesigning IN ComponentState) THEN BEGIN
    NonClientMetrics.cbSize := sizeof(NonClientMetrics);
    if SystemParametersInfo(SPI_GETNONCLIENTMETRICS, 0, @NonClientMetrics, 0) then
      Result := NonClientMetrics.iMenuHeight;
  END;
end;

procedure TPieMainMenu.SetMenuHeight(Value: Integer);
var
  NonClientMetrics: TNonClientMetrics;
begin
  IF Value < 1 THEN exit;
  FMenuHeight := Value;
  IF NOT(csDesigning IN ComponentState) THEN BEGIN
    NonClientMetrics.cbSize := sizeof(NonClientMetrics);
    if SystemParametersInfo(SPI_GETNONCLIENTMETRICS, 0, @NonClientMetrics, 0) then BEGIN
      NonClientMetrics.iMenuHeight := Value;
      SystemParametersInfo(SPI_SETNONCLIENTMETRICS, 0, @NonClientMetrics, 0);
    END;
  END;
end;

function TPieMainMenu.GetMenuSize: TRect;
var
  NonClientMetrics: TNonClientMetrics;
begin
  FillChar(Result, SizeOf(Result), 0);
  NonClientMetrics.cbSize := sizeof(NonClientMetrics);
  if SystemParametersInfo(SPI_GETNONCLIENTMETRICS, 0, @NonClientMetrics, 0) then
  begin
    Result.Right := NonClientMetrics.iMenuWidth;
    Result.Bottom := NonClientMetrics.iMenuHeight;
  end;
end;

procedure TPieMainMenu.ItemMeasureItem(Sender: TObject; ACanvas: TCanvas; var Width, Height: Integer);
const
  Alignments: array[TPopupAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
var
  Alignment: TPopupAlignment;
  ImageList: TImageList;
  ParentMenu: TMenu;
  DrawGlyph: Boolean;
  TopLevel: Boolean;
  DrawStyle: Integer;
  Text: string;
  R: TRect;
  M: TMenuItem;

begin
  M := Sender as TMenuItem;
  {******* Hauptmeneintrag? ***********}
  TopLevel := M.GetParentComponent is TMainMenu;
  {******* Ja --> Hhe ermitteln ***********}
  Width := GetMenuSize.Right;
  Height := GetMenuSize.Bottom;

  ParentMenu := M.GetParentMenu;
  ImageList := ParentMenu.Images as TImageList;
  {******* Separator ohne Glyph ***********}
  if M.Caption = '-' then begin
    Height := 5;
    Width := -2;
    DrawGlyph := False;
  end
  {******* Eintrag mit Glyph ? ***********}
  else if Assigned(ImageList) and ((M.ImageIndex > -1) or
  not TopLevel) then begin
    Width := ImageList.Width;
    if not(TopLevel) AND (ImageList.Height > Height)
      THEN Height := ImageList.Height;
    DrawGlyph := True;
  end
  else if Assigned(M.Bitmap) and not M.Bitmap.Empty then begin
    Width := M.Bitmap.Width;
    if not(TopLevel) AND (M.Bitmap.Height > Height)
      THEN Height := M.Bitmap.Height;
    DrawGlyph := True;
  end
  {******* normaler Eintrag ohne Glyph ***********}
  else begin
    Width := -7;
    DrawGlyph := False;
  end;
  {******* Dimensionen anpassen ***********}
  if DrawGlyph and not TopLevel then Inc(Width, 15);
  if not TopLevel then Inc(Height, 3);
  FillChar(R, SizeOf(R), 0);
  {******* Textausrichtung festlegen ***********}
  if ParentMenu is TMenu then Alignment := paLeft
  else if ParentMenu is TPopupMenu then Alignment := TPopupMenu(ParentMenu).Alignment
  else Alignment := paLeft;
  {******* Text-Dimensionen kalkulieren ***********}
  if M.ShortCut <> 0 then
    Text := Concat(M.Caption, ShortCutToText(M.ShortCut)) else
    Text := M.Caption;
  DrawStyle := Alignments[Alignment] or DT_EXPANDTABS or DT_SINGLELINE or
    DT_NOCLIP or DT_CALCRECT;

  {********* Eigene Erweiterungen ************}
{  IF M.Count > 0 THEN inc(Width, 1); {Platz fr Pfeil auf Untermens}
  ACanvas.Font.Assign(FFont);

  DoDrawText(M, ACanvas, Text, R, False, DrawStyle);
  Inc(Width, R.Right - R.Left + 7);
END;

procedure TPieMainMenu.ItemDrawItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
const
  Alignments: array[TPopupAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
  EdgeStyle: array[Boolean] of Longint = (BDR_RAISEDINNER, BDR_SUNKENOUTER);
var
  TopLevel: Boolean;
  ImageList: TImageList;
  ParentMenu: TMenu;
  Alignment: TPopupAlignment;
  DrawImage, DrawGlyph: Boolean;
  GlyphRect, SaveRect: TRect;
  DrawStyle: Longint;
  Glyph: TBitmap;
  OldBrushColor: TColor;
  M, LastVisibleItem: TMenuItem;
  CR, RestRect: TRect;
  I: Integer;
begin
  IF FNoPaint THEN Exit;
  M := Sender as TMenuItem;
  ParentMenu := M.GetParentMenu;
  TopLevel := M.GetParentComponent is TMainMenu;
  with ACanvas do begin
    ImageList := ParentMenu.Images as TImageList;
    if not Selected then FillRect(ARect);
    {******* Hintergund - RestMen malen ***********}
    IF TopLevel THEN BEGIN
      LastVisibleItem := NIL;
      FOR I:=0 TO ParentMenu.Items.Count-1 DO
        IF ParentMenu.Items[I].Visible THEN LastVisibleItem := ParentMenu.Items[I];
      IF (LastVisibleItem = M) THEN BEGIN
        GetClientRect(WindowHandle, CR);
        RestRect := Rect(ARect.Right, ARect.Top, CR.Right+3, ARect.Bottom);
        CASE FMenuStyle OF
        pmsBitmap: PaintBackground(ACanvas, RestRect, FALSE);
        pmsSolid:  BEGIN
                   Brush.Color := FColor;
                   FillRect(RestRect);
                   END;
        END;
      END;
    END;   {IF TopLevel}
    {******* Hintergund - Item malen ***********}
    CASE FMenuStyle OF
    pmsBitmap: PaintBackground(ACanvas, ARect, FALSE);
    pmsSolid:  BEGIN
               Brush.Color := FColor;
               FillRect(ARect);
               END;
    END;

    {*********** Textausrichtung ************}
    if ParentMenu is TMenu then
      Alignment := paLeft
    else if ParentMenu is TPopupMenu then
      Alignment := TPopupMenu(ParentMenu).Alignment
    else
      Alignment := paLeft;
    GlyphRect.Left := ARect.Left + 1;
    GlyphRect.Top := ARect.Top + 1;

    {******* Separator ***********}
    if M.Caption = '-' then begin
      FillRect(ARect);
      CASE FMenuStyle OF
      pmsBitmap: PaintBackground(ACanvas, ARect, FALSE);
      pmsSolid:  BEGIN
                 Brush.Color := FColor;
                 FillRect(ARect);
                 END;
      END;
      GlyphRect.Left := 0;
      GlyphRect.Right := -4;
      DrawGlyph := False;
    end
    else begin
    {******* Image malen? ***********}
      DrawImage := (ImageList <> nil) and ((M.ImageIndex > -1) and
        (M.ImageIndex < ImageList.Count) or M.Checked and ((M.Bitmap = nil) or
        M.Bitmap.Empty));

    {******* Image malen! ***********}
      if DrawImage or Assigned(M.Bitmap) and not M.Bitmap.Empty then begin
        DrawGlyph := True;

        if DrawImage then begin
          GlyphRect.Top := (ARect.Bottom - ARect.Top - ImageList.Height) DIV 2 + ARect.Top;
          GlyphRect.Right := GlyphRect.Left + ImageList.Width;
          GlyphRect.Bottom := GlyphRect.Top + ImageList.Height;
        end
        else begin
          { Need to add BitmapWidth/Height properties for TMenuItem if we're to
            support them.  Right now let's hardcode them to 16x16. }
          GlyphRect.Top := (ARect.Bottom - ARect.Top - M.Bitmap.Height) DIV 2 + ARect.Top;
          GlyphRect.Right := GlyphRect.Left + M.Bitmap.Width;
          GlyphRect.Bottom := GlyphRect.Top + M.Bitmap.Height;
        end;

        { Draw background pattern brush if selected }
        if M.Checked then begin
          Inc(GlyphRect.Right);
          Inc(GlyphRect.Bottom);
          OldBrushColor := Brush.Color;
          IF FMenuStyle = pmsSolid
            THEN Brush.Color := FColor
            ELSE Brush.Color := clBtnFace;
          FillRect(GlyphRect);
          Brush.Color := OldBrushColor;
          Inc(GlyphRect.Left);
          Inc(GlyphRect.Top);
        end;

    {******* Image malen ***********}
        if DrawImage then begin
          if (M.ImageIndex > -1) and (M.ImageIndex < ImageList.Count) then
            ImageList.Draw(ACanvas, GlyphRect.Left, GlyphRect.Top, M.ImageIndex,
              M.Enabled)
          else begin
            { Draw a menu check }
            Glyph := TBitmap.Create;
            try
              Glyph.Transparent := True;
              Glyph.Handle := LoadBitmap(0, PChar(OBM_CHECK));
              OldBrushColor := Font.Color;
              Font.Color := clBtnText;
              Draw(GlyphRect.Left + (GlyphRect.Right - GlyphRect.Left - Glyph.Width) div 2 + 1,
                GlyphRect.Top + (GlyphRect.Bottom - GlyphRect.Top - Glyph.Height) div 2 + 1, Glyph);
              Font.Color := OldBrushColor;
            finally
              Glyph.Free;
            end;
          end;
        end    {IF DrawImage THEN BEGIN ...}
        else begin
          SaveRect := GlyphRect;
          { Make sure image is within glyph bounds }
          if M.Bitmap.Width < GlyphRect.Right - GlyphRect.Left then
            with GlyphRect do begin
              Left := Left + ((Right - Left) - M.Bitmap.Width) div 2 + 1;
              Right := Left + M.Bitmap.Width;
            end;
          if M.Bitmap.Height < GlyphRect.Bottom - GlyphRect.Top then
            with GlyphRect do begin
              Top := Top + ((Bottom - Top) - M.Bitmap.Height) div 2 + 1;
              Bottom := Top + M.Bitmap.Height;
            end;
          StretchDraw(GlyphRect, M.Bitmap);
          GlyphRect := SaveRect;
        end;  {ELSE von IF DrawImage ...}

        if M.Checked then begin
          Dec(GlyphRect.Right);
          Dec(GlyphRect.Bottom);
        end;
      end      {IF DrawImage OR Assigned(M.Bitmap) ...}
      else begin
        if (ImageList <> nil) and not TopLevel then begin
          GlyphRect.Right := GlyphRect.Left + ImageList.Width;
          GlyphRect.Bottom := GlyphRect.Top + ImageList.Height;
        end
        else begin
          GlyphRect.Right := GlyphRect.Left;
          GlyphRect.Bottom := GlyphRect.Top;
        end;
        DrawGlyph := False;
      end;
    end;   {ELSE von IF M.Caption = '-'}

    {******* Glyph-Hintergrund gedrckt malen ***********}
    with GlyphRect do begin
      Dec(Left);
      Dec(Top);
      Inc(Right, 1);
      Inc(Bottom, 1);
    end;

    if M.Checked or Selected and DrawGlyph then
      DrawEdge(Handle, GlyphRect, EdgeStyle[M.Checked], BF_RECT);

    {******* Eintrag selektiert malen ***********}
    if Selected then begin
      if DrawGlyph then ARect.Left := GlyphRect.Right + 1;
      {wenn SelectedImage vorhanden, dann darstellen!}
      PaintBackground(ACanvas, ARect, TRUE);
      Brush.Color := FSelectColor;
      Pen.Color := FSelectColor;
      CASE FSelectStyle OF
      pmssBox:       FrameRect(ARect);
      pmssLine:      BEGIN MoveTo(ARect.Left, ARect.Bottom-1); LineTo(ARect.Right, ARect.Bottom-1); END;
      pmssEllipse:   Ellipse(ARect.Left, ARect.Top, ARect.Right, ARect.Bottom);
      pmssArc:       Arc(ARect.Left, ARect.Top, ARect.Right, ARect.Bottom, ARect.Right-1, ARect.Top, ARect.Right, ARect.Top);
      END;
    end;

    {********* Eigene Erweiterungen ************}
    ACanvas.Font.Assign(FFont);

    {******* Caption-Text zeichnen ***********}
    if not Selected or not DrawGlyph then
      ARect.Left := GlyphRect.Right + 1;
    Inc(ARect.Left, 2);
    Dec(ARect.Right, 1);
    DrawStyle := DT_EXPANDTABS or DT_SINGLELINE or Alignments[Alignment];
    { Calculate vertical layout }
    SaveRect := ARect;
    DoDrawText(M, ACanvas, M.Caption, ARect, Selected, DrawStyle or DT_CALCRECT or DT_NOCLIP);
    OffsetRect(ARect, 0, ((SaveRect.Bottom - SaveRect.Top) - (ARect.Bottom - ARect.Top)) div 2);
    DoDrawText(M, ACanvas, M.Caption, ARect, Selected, DrawStyle);
    {******* ShortCut-Text zeichnen ***********}
    if (M.ShortCut <> 0) and not TopLevel then begin
      ARect.Left := ARect.Right;
      ARect.Right := SaveRect.Right - 10;
      DoDrawText(M, ACanvas, ShortCutToText(M.ShortCut), ARect, Selected, DT_RIGHT);
    end;
  end;
END;

procedure TPieMainMenu.PaintBackground(ACanvas: TCanvas; ARect: TRect; ASelected: Boolean);
VAR
  CR, R: TRect;
  B, H, I, J: Integer;
  P : TPicture;
  Pos1: TRect; {Position des gesamten Pattern im Canvas}
  Pos2: TRect; {Position des darzustellenden Teilpattern im Pattern}
  Malen: Boolean;
BEGIN
  IF (NOT(ASelected) AND Assigned(FBackGround)  AND Assigned(FBackGround.Graphic)) OR
     (    ASelected  AND Assigned(FSelectImage) AND Assigned(FSelectImage.Graphic)) THEN BEGIN
    P := TPicture.Create;
    TRY
      IF ASelected THEN P.Assign(SelectImage) ELSE P.Assign(FBackGround);
      CR := ARect;
      R.Left := 0;
      R.Top := 0;
      R.Right := ARect.Right - ARect.Left;
      R.Bottom := ARect.Bottom - ARect.Top;
      H := P.Graphic.Height;
      B := P.Graphic.Width;
      IF (H>0) AND (B>0) THEN BEGIN

        FOR I := 0 TO ((CR.Right - CR.Left) DIV B) DO
        FOR J := 0 TO ((CR.Bottom - CR.Top) DIV H) DO BEGIN
          Pos1 := Rect(I*B, J*H, (I+1)*B, (J+1)*H);
          Malen := (Pos1.Left < R.Right) AND (Pos1.Right > R.Left) AND
                   (Pos1.Top < R.Bottom) AND (Pos1.Bottom > R.Top);

          IF Malen THEN BEGIN
            Pos2 := Rect(R.Left-I*B, R.Top-J*H, R.Right-I*B, R.Bottom-J*H);
            IF Pos2.Left   < 0 THEN Pos2.Left   := 0;
            IF Pos2.Top    < 0 THEN Pos2.Top    := 0;
            IF Pos2.Right  > B THEN Pos2.Right  := B;
            IF Pos2.Bottom > H THEN Pos2.Bottom := H;

            IF (Pos2.Left > 0) OR (Pos2.Top > 0) THEN
            BitBlt(P.Bitmap.Canvas.Handle, 0, 0,
                  (Pos2.Right-Pos2.Left),
                  (Pos2.Bottom-Pos2.Top),
                   P.Bitmap.Canvas.Handle, Pos2.Left, Pos2.Top,
                   srcCopy);

            P.Graphic.Width := Pos2.Right-Pos2.Left;
            P.Graphic.Height := Pos2.Bottom-Pos2.Top;
            ACanvas.Draw(Pos1.Left + Pos2.Left + ARect.Left,
                         Pos1.Top  + Pos2.Top  + ARect.Top,
                         P.Graphic);
            IF ASelected THEN P.Assign(SelectImage) ELSE P.Assign(FBackGround);
          END;
        END;

      END;  {IF (H>0) AND ...}
    FINALLY
      P.Free;
    END;
  END;
END;

end.
