{$I PIETOOLS.INC}
{ Autor: Ingolf Pietschmann.
  Dieser Quelltext ist Freeware. Die Verwendung und Weitergabe dieser Sourcen zu
  privaten nicht kommerziellen Zwecken ist ausdrcklich erwnscht.
  Die Verwendung zu kommerziellen Zwecken ist nur mit Erlaubnis des Autors
  gestattet. Den Autor knnen Sie unter "Support@Pie-Tools.de" erreichen.

  These sources are freeware. The usage and distribution of these sources for
  private, not commercial purposes is explicit desired.
  The usage for commercial purposes is only permitted in agreement of the author.
  The author can be reached by "Webmaster@Pie-Tools.de".
}
unit PieList;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, CommCtrl,
  Piezln1, ExtDlgs, imglist, PieHerk;

type
  {PieListStrings}
  TPieListEintrag = class(TPersistent)
  public
    FBitmap: TBitmap;
    FColor: TColor;
    FFont: TFont;
    FHelpContext: THelpContext;
    FHint: string;
    FChecked: Boolean;
    FEnabled: Boolean;
    FSelected: Boolean; {nur Zwischenspeicher beim Sortieren von Multiselect-Listen}
    procedure Assign(Source: TPersistent); override;
    destructor Destroy; override;
  END;

  PPieListItem = ^TPieListItem;
  TPieListItem = RECORD
    FString: string;
    FPieListEintrag: TPieListEintrag;
    FObject: TObject;
  END;

  PPieListListe = ^TPieListListe;
  TPieListListe = array[0..MaxListSize] of TPieListItem;

  TPieList = class;

  TPieListStrings = class(TStrings)
  private
    FList: PPieListListe;
    FListBox: TPieList;
    FCount: Integer;
    FCapacity: Integer;
    FSorted: Boolean;
    FDuplicates: TDuplicates;
    FOnChange: TNotifyEvent;
    FOnChanging: TNotifyEvent;
    procedure ExchangeItems(Index1, Index2: Integer);
    procedure Grow;
    procedure QuickSort(L, R: Integer);
    procedure InsertItem(Index: Integer; const S: string);
    procedure SetSorted(Value: Boolean);
    procedure ReadBitmapData(Stream: TStream);
    procedure ReadData(Reader: TReader);
    procedure WriteBitmapData(Stream: TStream);
    procedure WriteData(Writer: TWriter);
  protected
    procedure DefineProperties(Filer: TFiler); override;
    procedure Changed; virtual;
    procedure Changing; virtual;
    function Get(Index: Integer): string; override;
    function GetObject(Index: Integer): TObject; override;
    function GetCapacity: Integer; override;
    function GetCount: Integer; override;
    function GetBitmap(Index: Integer): TBitmap; virtual;
    function GetColor(Index: Integer): TColor; virtual;
    function GetFont(Index: Integer): TFont; virtual;
    function GetHelpContext(Index: Integer): THelpContext; virtual;
    function GetHint(Index: Integer): string; virtual;
    function GetEnabled(Index: Integer): Boolean; virtual;
    function GetChecked(Index: Integer): Boolean; virtual;
    procedure Put(Index: Integer; const S: string); override;
    procedure PutObject(Index: Integer; AObject: TObject); override;
    procedure SetBitmap(Index: Integer; ABitmap: TBitmap); virtual;
    procedure SetColor(Index: Integer; AColor: TColor); virtual;
    procedure SetFont(Index: Integer; AFont: TFont); virtual;
    procedure SetHelpContext(Index: Integer; AHelpContext: THelpContext); virtual;
    procedure SetHint(Index: Integer; AHint: string); virtual;
    procedure SetEnabled(Index: Integer; AEnabled: Boolean); virtual;
    procedure SetChecked(Index: Integer; AChecked: Boolean); virtual;
    procedure SetCapacity(NewCapacity: Integer); override;
    procedure SetUpdateState(Updating: Boolean); override;
  public       {PieListStrings}
    constructor Create(AOwner: TPieList);
    destructor Destroy; override;
    function Add(const S: string): Integer; override;
    procedure AddItems(ItemsNeu: TPieListStrings); virtual;
    procedure Assign(Source: TPersistent); override;
    procedure Clear; override;
    procedure Delete(Index: Integer); override;
    procedure Exchange(Index1, Index2: Integer); override;
    function Find(const S: string; var Index: Integer): Boolean; virtual;
    function IndexOf(const S: string): Integer; override;
    procedure Insert(Index: Integer; const S: string); override;
    procedure InsertObjectIntern(Index: Integer; const S: string; AObject: TObject; APieListEintrag: TPieListEintrag);
    procedure Move(CurIndex, NewIndex: Integer); override;
    procedure Sort; virtual;
    property Colors[Index: Integer]: TColor read GetColor write SetColor;
    property Hints[Index: Integer]: string read GetHint write SetHint;
    property Enabled[Index: Integer]: Boolean read GetEnabled write SetEnabled;
    property Checked[Index: Integer]: Boolean read GetChecked write SetChecked;
    property HelpContexts[Index: Integer]: THelpContext read GetHelpContext write SetHelpContext;
    property Fonts[Index: Integer]: TFont read GetFont write SetFont;
    property Bitmaps[Index: Integer]: TBitmap read GetBitmap write SetBitmap;
  published
    property Duplicates: TDuplicates read FDuplicates write FDuplicates;
    property Sorted: Boolean read FSorted write SetSorted;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    property OnChanging: TNotifyEvent read FOnChanging write FOnChanging;
  end;

  {PieList}
  TSelectedStyle = (psStandard, psBoldText, psOwnerDraw);
  TBitmapStyle = (bsLeft, bsRight, bsCenter, bsStretch, bsPattern);
  TItemHeightStyle = (ihFix, ihFont, ihBitmap, ihFontBitmap);
  TBackGroundStyle = (bgsNone, bgsCenter, bgsStretch, bgsPattern);
  TColumnSortEvent = procedure(ListControl: TCustomListBox; Section: THeaderSection; Column: Integer; ColumnUp: Boolean; VAR DefaultSort: Boolean) of object;
  TSortProgressEvent = procedure (Sender: TObject; Stage: TProgressStage; PercentDone: Byte) of object;
  TPopupSourceState = (pssKey, pssMouse);
  TPopupEvent = procedure(Sender: TControl; Point: TPoint; State: TPopupSourceState) of object;

  EInvalidTabStop = exception;

  TPieList = class(TCustomListBox)
  private
    { Private declarations }
    FVersion: string;
    FSelectedStyle: TSelectedStyle;
    FBitmapStyle: TBitmapStyle;
    FItemHeightStyle: TItemHeightStyle;
    FOnChange : TNotifyEvent;
    FOnSectionClick: TSectionNotifyEvent;
    FOnColumnSort: TColumnSortEvent;
    FOnScrollH: TScrollEvent;
    FOnScrollV: TScrollEvent;
    FOnSortProgress: TSortProgressEvent;
    FOnPopup: TPopupEvent;
    FLastSel : integer;
    FLineByTabStops: Boolean;
    FAlignment: TAlignment;
    FAnyColors: Boolean;
    FAnyFonts: Boolean;
    FHorzExtent: Integer;
    FHorzExtentIntern: Integer;
    FHScrollPos : Word;
    FHorzScrollBar: Boolean;
    FBackground: TPicture;
    FBackGroundStyle: TBackGroundStyle;
    FItems: TPieListStrings;
    FPanel: TPanel;
    FHeader: THeaderControl;
    FCheckBoxSize: TPieCheckBoxSize;
    FCheckBoxStyle: TPieCheckBoxStyle;
    FHookStyle: TPieHookStyle;
    FHookColor: TColor;
    FCheckBoxes: Boolean;
    FShowHeader: Boolean;
    FSortColumn: Integer;
    FSortUp: Boolean;
    FSorted: Boolean;
    FMaskedImageList: TImageList;
    FAllowCheckDisabledItems: Boolean;
    procedure SetHorzExtent(Value: Integer);
    procedure SetHorzScrollBar(Value: Boolean);
    procedure SetItems(Value: TPieListStrings);
    procedure SetLineByTabStops(Value: Boolean);
    procedure SetSelectedStyle(AStyle: TSelectedStyle);
    procedure SetBitmapStyle(AStyle: TBitmapStyle);
    procedure SetItemHeightStyle(AStyle: TItemHeightStyle);
    procedure SetAlignment(Value: TAlignment);
    procedure SetAnyColors(Value: Boolean);
    procedure SetAnyFonts(Value: Boolean);
    procedure SetBackground(Value: TPicture);
    procedure SetBackGroundStyle(Value: TBackGroundStyle);
    procedure WMEraseBkgnd(var Message: TWmEraseBkgnd); message WM_ERASEBKGND;
    procedure WMPaint(var Message: TWmPaint); message WM_Paint;
    procedure WMMove(var Message: TWMMove); message WM_MOVE;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure WMHScroll(var Message: TWMScroll); message WM_HSCROLL;
    procedure WMVScroll(var Message: TWMScroll); message WM_VSCROLL;
    procedure CMVisibleChanged(var Message: TMessage); message CM_VISIBLECHANGED;
    procedure GetScrollPixel(Art: Byte; VAR ScrollX, ScrollY: Integer);
    function GetCheckBoxSize: Integer;
    procedure PaintBackground(R: TRect);
    procedure BackGroundChange(Sender: TObject);
    procedure SetHCVisible(Value: Boolean);
    function GetHCS: THeaderSections;
    procedure SetHCS(Value: THeaderSections);
    {$IFDEF D5_OR_HIGHER}
    function GetHCImages: TCustomImageList;
    procedure SetHCImages(Value: TCustomImageList);
    {$ENDIF}
    function GetHCStyle: THeaderStyle;
    procedure SetHCStyle(Value: THeaderStyle);
    function GetHCFont: TFont;
    procedure SetHCFont(Value: TFont);
    function GetBottomIndex: Integer;
    procedure SetBottomIndex(Value: Integer);
    procedure SetCheckBoxSize(Value: TPieCheckBoxSize);
    procedure SetCheckBoxStyle(Value: TPieCheckBoxStyle);
    procedure SetHookStyle(Value: TPieHookStyle);
    procedure SetHookColor(Value: TColor);
    procedure SetCheckBoxes(Value: Boolean);
    procedure SetSorted(Value: Boolean);
    procedure SetSortColumn(Value: Integer);
    procedure SetSortUp(Value: Boolean);
    procedure HeaderSectionResize(HeaderControl: THeaderControl; Section: THeaderSection);
    procedure HeaderDrawSection(HeaderControl: THeaderControl; Section: THeaderSection; const Rect: TRect; Pressed: Boolean);
    procedure HeaderSectionClick(HeaderControl: THeaderControl; Section: THeaderSection);
    procedure PasseHorzExtentAn(HeaderResize: Boolean);
    procedure ListeSortieren;
    {$IFDEF D5_OR_HIGHER}
    function DisableGlyph(Original: TBitmap; NumGlyphs: Integer): Integer;
    {$ENDIF}
  protected
    { Protected declarations }
    procedure CreateWnd; override;
    procedure Loaded; override;
    procedure Click; override;
    procedure DblClick; override;
    procedure RequestAlign; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure DrawBoldStyle(Index: integer; ARect: TRect; State: TOwnerDrawState; Art: Byte);
    procedure MeasureItem(Index: Integer; var Height: Integer); override;
    function DrawItemBitmap(Index: integer; ARect: TRect): TRect;
    procedure DrawItem(Index: integer; ARect: TRect; State: TOwnerDrawState); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
  public  {TPieList}
    { Public declarations }
    procedure Edit_aufrufen;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
    procedure CalculateItemHeight;
    procedure CalculateHorzScrollbar;
    procedure SelectAll;
    procedure ClearSelection;
    procedure Clear;
    function ItemAtPos(Pos: TPoint; Existing: Boolean): Integer;
    procedure SortList;
    function ItemsChecked(AllowDisabled: Boolean): Integer;
    property BottomIndex: Integer read GetBottomIndex write SetBottomIndex;
  published
    { Published declarations }
    property Align;
    property Anchors;
    property BorderStyle;
    property Color;
    property Columns;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property Enabled;
    property ExtendedSelect;
    property Font;
    property IntegralHeight;
    property ItemHeight;
    property Items: TPieListStrings read FItems write SetItems;
    property MultiSelect;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnDrawItem;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMeasureItem;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    {custom extensions}
    property Alignment: TAlignment read FAlignment write SetAlignment default taLeftJustify;
    property AllowCheckDisabledItems: Boolean read FAllowCheckDisabledItems write FAllowCheckDisabledItems default FALSE;
    property AnyColors: boolean read FAnyColors write SetAnyColors default TRUE;
    property AnyFonts: boolean read FAnyFonts write SetAnyFonts default TRUE;
    property Background: TPicture read FBackground write SetBackground;
    property BackGroundStyle: TBackGroundStyle read FBackGroundStyle write SetBackGroundStyle;
    property BitmapStyle: TBitmapStyle read FBitmapStyle write SetBitmapStyle default bsLeft;
    property CheckBoxes: Boolean read FCheckBoxes write SetCheckBoxes default FALSE;
    property CheckBoxSize: TPieCheckBoxSize read FCheckBoxSize write SetCheckBoxSize default pcbsNormal;
    property CheckBoxStyle: TPieCheckBoxStyle read FCheckBoxStyle write SetCheckBoxStyle default pcbsSunken;
    property HeaderFont: TFont read GetHCFont write SetHCFont;
    {$IFDEF D5_OR_HIGHER}
    property HeaderImages: TCustomImageList read GetHCImages write SetHCImages;
    {$ENDIF}
    property HeaderSections: THeaderSections read GetHCS write SetHCS;
    property HeaderStyle: THeaderStyle read GetHCStyle write SetHCStyle default hsButtons;
    property HookColor: TColor read FHookColor write SetHookColor default clBtnText;
    property HookStyle: TPieHookStyle read FHookStyle write SetHookStyle default phsHook;
    property HorzExtent: Integer read FHorzExtent write SetHorzExtent default 0;
    property HorzScrollBar: Boolean read FHorzScrollBar write SetHorzScrollBar default False;
    property ItemHeightStyle: TItemHeightStyle read FItemHeightStyle write SetItemHeightStyle default ihFix;
    property LineByTabStops: boolean read FLineByTabStops write SetLineByTabStops default FALSE;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    property OnSectionClick: TSectionNotifyEvent read FOnSectionClick write FOnSectionClick;
    property OnColumnSort: TColumnSortEvent read FOnColumnSort write FOnColumnSort;
    property OnScrollH: TScrollEvent read FOnScrollH write FOnScrollH;
    property OnScrollV: TScrollEvent read FOnScrollV write FOnScrollV;
    property OnSortProgress: TSortProgressEvent read FOnSortProgress write FOnSortProgress;
    property OnPopup: TPopupEvent read FOnPopup write FOnPopup;
    property SelectedStyle: TSelectedStyle read FSelectedStyle write SetSelectedStyle default psStandard;
    property ShowHeader: Boolean read FShowHeader write SetHCVisible default FALSE;
    property Sorted: Boolean read FSorted write SetSorted default FALSE;
    property SortColumn: Integer read FSortColumn write SetSortColumn default 0;
    property SortUp: Boolean read FSortUp write SetSortUp default TRUE;
    property Version: string read FVersion write FVersion;
  end;

  {PieItemsPropertyEditor}
  TPieItemsfenster = class(TForm)
    Rechtspanel: TPanel;
    EditPanel: TPanel;
    ObenPanel: TPanel;
    ColorDialog: TColorDialog;
    Edit: TMemo;
    FontDialog: TFontDialog;
    ObenPanel3: TPanel;
    InsertBtn: TBitBtn;
    DeleteBtn: TBitBtn;
    ChangeBtn: TBitBtn;
    UntenPanel: TPanel;
    LoeschBtn: TBitBtn;
    OkButton: TBitBtn;
    AbbruchButton: TBitBtn;
    OpenPicDialog: TOpenPictureDialog;
    ListenPanel: TPanel;
    HintDialog: TPieZeilenDialog;
    GroupBox1: TGroupBox;
    Bevel1: TBevel;
    ColorShape: TShape;
    ZeilenLabel1: TLabel;
    Gesamtzeilenlabel1: TLabel;
    ZeilenLabel2: TLabel;
    Gesamtzeilenlabel2: TLabel;
    Helplabel: TLabel;
    BitmapVorschau: TImage;
    ColorBtn: TBitBtn;
    FontBtn: TBitBtn;
    HintBtn: TBitBtn;
    BitmapBtn: TBitBtn;
    BitmapDeleteBtn1: TBitBtn;
    GroupBox2: TGroupBox;
    HELabel: TLabel;
    HS: TCheckBox;
    CBStyle: TRadioGroup;
    AnyColors: TCheckBox;
    AnyFonts: TCheckBox;
    MS: TCheckBox;
    IHStyle: TRadioGroup;
    BStyle: TRadioGroup;
    BGButton: TBitBtn;
    BGStyle: TRadioGroup;
    HESB: TScrollBar;
    GroupBox3: TGroupBox;
    UT: TCheckBox;
    LBTS: TCheckBox;
    HSGroup: TRadioGroup;
    HFButton: TBitBtn;
    CheckBoxes: TCheckBox;
    Sorted: TCheckBox;
    HelpContext: TEdit;
    procedure InsertBtnClick(Sender: TObject);
    procedure DeleteBtnClick(Sender: TObject);
    procedure ChangeBtnClick(Sender: TObject);
    procedure ColorBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure EditEnter(Sender: TObject);
    procedure EditChange(Sender: TObject);
    procedure FontBtnClick(Sender: TObject);
    procedure HintBtnClick(Sender: TObject);
    procedure LoeschBtnClick(Sender: TObject);
    procedure CBStyleClick(Sender: TObject);
    procedure UTClick(Sender: TObject);
    procedure HESBChange(Sender: TObject);
    procedure HSClick(Sender: TObject);
    procedure AnyColorsClick(Sender: TObject);
    procedure AnyFontsClick(Sender: TObject);
    procedure MSClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BitmapBtnClick(Sender: TObject);
    procedure IHStyleClick(Sender: TObject);
    procedure BStyleClick(Sender: TObject);
    procedure BitmapDeleteBtn1Click(Sender: TObject);
    procedure BGButtonClick(Sender: TObject);
    procedure BGStyleClick(Sender: TObject);
    procedure LBTSClick(Sender: TObject);
    procedure HSGroupClick(Sender: TObject);
    procedure HFButtonClick(Sender: TObject);
    procedure CheckBoxesClick(Sender: TObject);
    procedure SortedClick(Sender: TObject);
    procedure HelpContextExit(Sender: TObject);
    procedure HelpContextChange(Sender: TObject);
  private
    { Private-Deklarationen }
    Zeile: Integer;
    Zieh_Item: Integer;
    procedure ListeClick(Sender: TObject);
    procedure ListeMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ListeDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure ListeDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure Prop_zeigen;
  public
    { Public-Deklarationen }
    Liste: TPieList;
  end;

implementation

{$R *.DFM}
USES Consts
{$IFDEF D6_OR_HIGHER}
, RTLConsts;
{$ELSE}
;
{$ENDIF}

{ TPieListEintrag }
destructor TPieListEintrag.Destroy;
begin
  FBitmap.Free;
  FFont.Free;
  inherited Destroy;
END;

procedure TPieListEintrag.Assign(Source: TPersistent);
VAR
  PLE: TPieListEintrag;
begin
  if Source is TPieListEintrag then begin
    PLE := Source as TPieListEintrag;

    IF assigned(PLE.FBitmap) THEN BEGIN
      IF NOT assigned(FBitmap) THEN FBitmap := TBitmap.Create;
      FBitmap.Assign(PLE.FBitmap);
    END
    ELSE BEGIN
      IF assigned(FBitmap) THEN BEGIN
        FBitmap.Free;
        FBitmap := NIL;
      END;
    END;
    IF assigned(PLE.FFont) THEN BEGIN
      IF NOT assigned(FFont) THEN FFont := TFont.Create;
      FFont.Assign(PLE.FFont);
    END
    ELSE BEGIN
      IF assigned(FFont) THEN BEGIN
        FFont.Free;
        FFont := NIL;
      END;
    END;
    FColor := PLE.FColor;
    FHelpContext := PLE.FHelpContext;
    FHint := PLE.FHint;
    FChecked := PLE.FChecked;
    FEnabled := PLE.FEnabled;
    FSelected := PLE.FSelected;
  end;
end;

{ TPieListStrings }
constructor TPieListStrings.Create(AOwner: TPieList);
begin
  inherited Create;
  FListBox := AOwner;
  FList := NIL;
  FOnChange := nil;
  FOnChanging := nil;
  FCount := 0;
  SetCapacity(0);
end;

destructor TPieListStrings.Destroy;
VAR
  Index: Integer;
begin
  FOnChange := nil;
  FOnChanging := nil;
  FOR Index:=0 TO FCount-1 DO BEGIN
    FList^[Index].FPieListEintrag.Free;
    FList^[Index].FPieListEintrag := NIL;
  END;
  if FCount <> 0 then Finalize(FList^[0], FCount);
  FListBox := NIL;
  inherited Destroy;
  FCount := 0;
  SetCapacity(0);
end;

function TPieListStrings.Add(const S: string): Integer;
begin
  if not Sorted then
    Result := FCount
  else
    if Find(S, Result) then
      case Duplicates of
        dupIgnore: Exit;
        dupError: Error(SDuplicateString, 0);
      end;
  InsertItem(Result, S);
end;

procedure TPieListStrings.AddItems(ItemsNeu: TPieListStrings);
var
  I: Integer;
begin
  BeginUpdate;
  try
    for I := 0 to ItemsNeu.Count - 1 do begin
      Add(ItemsNeu.Strings[I]);
      Bitmaps[I] := ItemsNeu.Bitmaps[I];
      Colors[I] := ItemsNeu.Colors[I];
      Fonts[I] := ItemsNeu.Fonts[I];
      HelpContexts[I] := ItemsNeu.HelpContexts[I];
      Hints[I] := ItemsNeu.Hints[I];
      Checked[I] := ItemsNeu.Checked[I];
      Enabled[I] := ItemsNeu.Enabled[I];
    end;
  finally
    {Es kann sich die Hhe der Eintrge ndern}
    IF Assigned(FListBox) THEN FListBox.CalculateItemHeight;
    EndUpdate;
  end;
end;

procedure TPieListStrings.Assign(Source: TPersistent);
begin
  if Source is TPieListStrings then begin
    BeginUpdate;
    try
      Clear;
      AddItems(TPieListStrings(Source));
    finally
      EndUpdate;
    end;
    Exit;
  end;
  inherited Assign(Source);
end;

procedure TPieListStrings.Changed;
begin
  if Assigned(FOnChange) then FOnChange(Self);
  IF Assigned(FListBox) AND Assigned(FListBox.OnChange) then FListBox.OnChange(FListBox);
end;

procedure TPieListStrings.Changing;
begin
  if Assigned(FOnChanging) then FOnChanging(Self);
end;

procedure TPieListStrings.Clear;
VAR
  I: Integer;
begin
  if FCount <> 0 then begin
    Changing;
    FOR I:=0 TO FCount-1 DO BEGIN
      FList^[I].FPieListEintrag.Free;
      FList^[I].FPieListEintrag := NIL;
    END;
    Finalize(FList^[0], FCount);
    FCount := 0;
    SetCapacity(0);
    IF Assigned(FListBox) THEN SendMessage(FListBox.Handle, LB_RESETCONTENT, 0, 0);
    Changed;
    IF Assigned(FListBox) THEN FListBox.PasseHorzExtentAn(FALSE);
  end;
end;

procedure TPieListStrings.DefineProperties(Filer: TFiler);

  function DoWrite: Boolean;
  begin
    if Filer.Ancestor <> nil then begin
      Result := True;
      if Filer.Ancestor is TPieListStrings then
        Result := not Equals(TPieListStrings(Filer.Ancestor))
    end
    else Result := Count > 0;
  end;

  function DoBitmapWrite: Boolean;
  begin
    if Filer.Ancestor <> nil then begin
      Result := True;
      if Filer.Ancestor is TPieListStrings then
        Result := TRUE;
    end
    else Result := Count > 0;
  end;

begin
  Filer.DefineProperty('PieListStrings', ReadData, WriteData, DoWrite);
  Filer.DefineBinaryProperty('PieListBitmaps', ReadBitmapData, WriteBitmapData, DoBitmapWrite);
end;

procedure TPieListStrings.Delete(Index: Integer);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;
  FList^[Index].FPieListEintrag.Free;
  FList^[Index].FPieListEintrag := NIL;
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Finalize(FList^[Index]);
  Dec(FCount);
  if Index < FCount then
    System.Move(FList^[Index + 1], FList^[Index],
      (FCount - Index) * SizeOf(TPieListItem));
  IF Assigned(FListBox) THEN SendMessage(FListBox.Handle, LB_DELETESTRING, Index, 0);
  Changed;
end;

procedure TPieListStrings.Exchange(Index1, Index2: Integer);
begin
  if (Index1 < 0) or (Index1 >= FCount) then Error(SListIndexError, Index1);
  if (Index2 < 0) or (Index2 >= FCount) then Error(SListIndexError, Index2);
  Changing;
  ExchangeItems(Index1, Index2);
  Changed;
end;

procedure TPieListStrings.ExchangeItems(Index1, Index2: Integer);
var
  Temp: Integer;
  Item1, Item2: PPieListItem;
begin
  Item1 := @FList^[Index1];
  Item2 := @FList^[Index2];
  Temp := Integer(Item1^.FString);
  Integer(Item1^.FString) := Integer(Item2^.FString);
  Integer(Item2^.FString) := Temp;
  Temp := Integer(Item1^.FPieListEintrag);
  Integer(Item1^.FPieListEintrag) := Integer(Item2^.FPieListEintrag);
  Integer(Item2^.FPieListEintrag) := Temp;
  Temp := Integer(Item1^.FObject);
  Integer(Item1^.FObject) := Integer(Item2^.FObject);
  Integer(Item2^.FObject) := Temp;
end;

function TPieListStrings.Find(const S: string; var Index: Integer): Boolean;
var
  L, H, I, C: Integer;
begin
  Result := False;
  L := 0;
  H := FCount - 1;
  while L <= H do
  begin
    I := (L + H) shr 1;
    C := AnsiCompareText(FList^[I].FString, S);
    if C < 0 then L := I + 1 else
    begin
      H := I - 1;
      if C = 0 then
      begin
        Result := True;
        if Duplicates <> dupAccept then L := I;
      end;
    end;
  end;
  Index := L;
end;

function TPieListStrings.Get(Index: Integer): string;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Result := FList^[Index].FString;
end;

function TPieListStrings.GetObject(Index: Integer): TObject;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Result := FList^[Index].FObject;
end;

function TPieListStrings.GetCapacity: Integer;
begin
  Result := FCapacity;
end;

function TPieListStrings.GetCount: Integer;
begin
  Result := FCount;
end;

function TPieListStrings.GetBitmap(Index: Integer): TBitmap;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  IF Assigned(FList^[Index].FPieListEintrag)
    THEN Result := FList^[Index].FPieListEintrag.FBitmap
    ELSE Result := NIL;
end;

function TPieListStrings.GetColor(Index: Integer): TColor;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  IF Assigned(FList^[Index].FPieListEintrag)
    THEN Result := FList^[Index].FPieListEintrag.FColor
    ELSE Result := clWindow;
end;

function TPieListStrings.GetFont(Index: Integer): TFont;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  IF Assigned(FList^[Index].FPieListEintrag)
    THEN Result := FList^[Index].FPieListEintrag.FFont
    ELSE Result := NIL;
end;

function TPieListStrings.GetHelpContext(Index: Integer): THelpContext;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  IF Assigned(FList^[Index].FPieListEintrag)
    THEN Result := FList^[Index].FPieListEintrag.FHelpContext
    ELSE Result := 0;
end;

function TPieListStrings.GetHint(Index: Integer): string;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  IF Assigned(FList^[Index].FPieListEintrag)
    THEN Result := FList^[Index].FPieListEintrag.FHint
    ELSE Result := '';
end;

function TPieListStrings.GetEnabled(Index: Integer): Boolean;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Result := FList^[Index].FPieListEintrag.FEnabled;
end;

function TPieListStrings.GetChecked(Index: Integer): Boolean;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Result := FList^[Index].FPieListEintrag.FChecked;
end;

procedure TPieListStrings.Grow;
var
  Delta: Integer;
begin
  if FCapacity > 64 then Delta := FCapacity div 4 else
    if FCapacity > 8 then Delta := 16 else
      Delta := 4;
  SetCapacity(FCapacity + Delta);
end;

function TPieListStrings.IndexOf(const S: string): Integer;
begin
  if not Sorted then Result := inherited IndexOf(S) else
    if not Find(S, Result) then Result := -1;
end;

procedure TPieListStrings.Insert(Index: Integer; const S: string);
begin
  if Sorted then Error(SSortedListError, 0);
  if (Index < 0) or (Index > FCount) then Error(SListIndexError, Index);
  InsertItem(Index, S);
end;

procedure TPieListStrings.Move(CurIndex, NewIndex: Integer);
var
  TempObject: TObject;
  TempPieListEintrag: TPieListEintrag;
  TempString: string;
begin
  if CurIndex <> NewIndex then begin
    BeginUpdate;
    try
      TempString := Get(CurIndex);
      TempObject := GetObject(CurIndex);
      TempPieListEintrag := TPieListEintrag.Create;
      TRY
        TempPieListEintrag.Assign(FList[CurIndex].FPieListEintrag);
        Delete(CurIndex);
        InsertObjectIntern(NewIndex, TempString, TempObject, TempPieListEintrag);
      FINALLY
        TempPieListEintrag.Free;
      END;
    finally
      EndUpdate;
    end;
  end;
end;

procedure TPieListStrings.InsertItem(Index: Integer; const S: string);
VAR
  I: Integer;
begin
  Changing;
  IF Assigned(FListBox) THEN I := FListBox.ItemIndex ELSE I := 0;
  if FCount = FCapacity then Grow;
  if Index < FCount then System.Move(FList^[Index],
    FList^[Index+1], (FCount-Index)*SizeOf(TPieListItem));
 {!!!} Initialize(FList^[Index]);
  with FList^[Index] do begin
    FString := S;
    FPieListEintrag := TPieListEintrag.Create;
    FPieListEintrag.FBitmap := NIL;
    FPieListEintrag.FFont := NIL;
    FPieListEintrag.FColor := clWindow;
    FPieListEintrag.FHelpContext := 0;
    FPieListEintrag.FHint := '';
    FPieListEintrag.FChecked := FALSE;
    FPieListEintrag.FEnabled := TRUE;
    FPieListEintrag.FSelected := FALSE;
    FObject := NIL;
  end;
  Inc(FCount);
  IF Assigned(FListBox) AND
    (SendMessage(FListBox.Handle, LB_INSERTSTRING, Index, Longint(PChar(S))) < 0) then
    raise EOutOfResources.Create(SInsertLineError);
  IF I<0 THEN I:=0;
  IF Assigned(FListBox) THEN FListBox.ItemIndex := I;
  {Es kann sich die Hhe der Eintrge ndern}
  IF Assigned(FListBox) THEN FListBox.CalculateItemHeight;
  Changed;
end;

procedure TPieListStrings.InsertObjectIntern(Index: Integer; const S: string; AObject: TObject; APieListEintrag: TPieListEintrag);
begin
  inherited InsertObject(Index, S, AObject);
  FList^[Index].FPieListEintrag.Assign(APieListEintrag);
end;

procedure TPieListStrings.Put(Index: Integer; const S: string);
var
  I: Integer;
begin
  if Sorted then Error(SSortedListError, 0);
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;
  IF Assigned(FListBox) THEN I := FListBox.ItemIndex ELSE I := 0;
  FList^[Index].FString := S;
  IF Assigned(FListBox) THEN BEGIN
    SendMessage(FListBox.Handle, LB_DELETESTRING, Index, 0);
    SendMessage(FListBox.Handle, LB_INSERTSTRING, Index, Longint(PChar(S)));
    FListBox.ItemIndex := I;
  END;
  Changed;
end;

procedure TPieListStrings.PutObject(Index: Integer; AObject: TObject);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;
  FList^[Index].FObject := AObject;
  Changed;
end;

procedure TPieListStrings.QuickSort(L, R: Integer);
var
  I, J: Integer;
  P: string;
begin
  repeat
    I := L;
    J := R;
    P := FList^[(L + R) shr 1].FString;
    repeat
      while AnsiCompareText(FList^[I].FString, P) < 0 do Inc(I);
      while AnsiCompareText(FList^[J].FString, P) > 0 do Dec(J);
      if I <= J then
      begin
        ExchangeItems(I, J);
        Inc(I);
        Dec(J);
      end;
    until I > J;
    if L < J then QuickSort(L, J);
    L := I;
  until I >= R;
end;

procedure TPieListStrings.ReadBitmapData(Stream: TStream);
VAR
  I: Integer;
  Buffer: char;
  Bmp: TBitmap;
begin
  BeginUpdate;
  try
    for I := 0 to Count - 1 do begin
      Stream.ReadBuffer(Buffer, 1);
      IF Buffer = 'Y' THEN BEGIN
        Bmp := TBitmap.Create;
        TRY
          Bmp.LoadFromStream(Stream);
          IF NOT Assigned(FList[I].FPieListEintrag.FBitmap) THEN FList[I].FPieListEintrag.FBitmap := TBitmap.Create;
          FList[I].FPieListEintrag.FBitmap.Assign(Bmp);
        FINALLY
          Bmp.Free;
        END;
      END;
    end;
  finally
    {Es kann sich die Hhe der Eintrge ndern}
    IF Assigned(FListBox) THEN FListBox.CalculateItemHeight;
    EndUpdate;
  end;
end;

procedure TPieListStrings.ReadData(Reader: TReader);
VAR
  E: TPieListEintrag;
  I: Integer;
begin
  Reader.ReadListBegin;
  BeginUpdate;
  try
    Clear;
    while not Reader.EndOfList do begin
      I := Add(Reader.ReadString);
      E := TPieListEintrag.Create;
      TRY
        E.FBitmap := NIL;
        E.FFont := NIL;
        E.FColor := Reader.ReadInteger;
        E.FHelpContext := Reader.ReadInteger;
        E.FHint := Reader.ReadString;
        E.FEnabled := Reader.ReadBoolean;
        E.FChecked := Reader.ReadBoolean;
        E.FSelected := FALSE;
        IF Reader.ReadBoolean THEN BEGIN {Spezial-Font?}
          E.FFont := TFont.Create;
          E.FFont.Name := Reader.ReadString;
          E.FFont.CharSet := Reader.ReadInteger;
          E.FFont.Color := Reader.ReadInteger;
          E.FFont.Height := Reader.ReadInteger;
          E.FFont.Pitch := TFontPitch(Reader.ReadInteger);
          E.FFont.Style := [];
          IF Reader.ReadBoolean THEN E.FFont.Style := E.FFont.Style + [fsBold];
          IF Reader.ReadBoolean THEN E.FFont.Style := E.FFont.Style + [fsItalic];
          IF Reader.ReadBoolean THEN E.FFont.Style := E.FFont.Style + [fsUnderline];
          IF Reader.ReadBoolean THEN E.FFont.Style := E.FFont.Style + [fsStrikeOut];
        END ELSE E.FFont := NIL;
        FList[I].FPieListEintrag.Assign(E);
      FINALLY
        E.Free;
      END;
    END;
  finally
    {Es kann sich die Hhe der Eintrge ndern}
    IF Assigned(FListBox) THEN FListBox.CalculateItemHeight;
    EndUpdate;
  end;
  Reader.ReadListEnd;
end;

procedure TPieListStrings.WriteBitmapData(Stream: TStream);
var
  I: Integer;
  E: TPieListEintrag;
  Buffer: char;
begin
  for I := 0 to Count - 1 do begin
    E := FList[I].FPieListEintrag;
    IF Assigned(E.FBitmap) AND NOT(E.FBitmap.Empty) THEN Buffer := 'Y' ELSE Buffer := 'N';
    Stream.WriteBuffer(Buffer, 1);
    IF Assigned(E.FBitmap) AND NOT(E.FBitmap.Empty) THEN E.FBitmap.SaveToStream(Stream);
  end;
end;

procedure TPieListStrings.WriteData(Writer: TWriter);
var
  I: Integer;
  E: TPieListEintrag;
begin
  Writer.WriteListBegin;
  for I := 0 to Count - 1 do begin
    Writer.WriteString(Get(I));
    E := FList[I].FPieListEintrag;
    Writer.WriteInteger(E.FColor);
    Writer.WriteInteger(E.FHelpContext);
    Writer.WriteString(E.FHint);
    Writer.WriteBoolean(E.FEnabled);
    Writer.WriteBoolean(E.FChecked);
    Writer.WriteBoolean(Assigned(E.FFont));
    {nderung!}
    IF Assigned(E.FFont) THEN BEGIN
      Writer.WriteString(E.FFont.Name);
      Writer.WriteInteger(E.FFont.CharSet);
      Writer.WriteInteger(E.FFont.Color);
      Writer.WriteInteger(E.FFont.Height);
      Writer.WriteInteger(Integer(E.FFont.Pitch));
      Writer.WriteBoolean(fsBold IN E.FFont.Style);
      Writer.WriteBoolean(fsItalic IN E.FFont.Style);
      Writer.WriteBoolean(fsUnderline IN E.FFont.Style);
      Writer.WriteBoolean(fsStrikeOut IN E.FFont.Style);
    END;
    {nderung!}
  end;
  Writer.WriteListEnd;
end;

procedure TPieListStrings.SetCapacity(NewCapacity: Integer);
begin
  ReallocMem(FList, NewCapacity * SizeOf(TPieListItem));
  FCapacity := NewCapacity;
end;

procedure TPieListStrings.SetBitmap(Index: Integer; ABitmap: TBitmap);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;

  IF Assigned(ABitmap) THEN BEGIN
    IF NOT Assigned(FList^[Index].FPieListEintrag.FBitmap)
      THEN FList^[Index].FPieListEintrag.FBitmap := TBitmap.Create;
    FList^[Index].FPieListEintrag.FBitmap.Assign(ABitmap);
  END
  ELSE IF Assigned(FList^[Index].FPieListEintrag.FBitmap) THEN BEGIN
    FList^[Index].FPieListEintrag.FBitmap.Free;
    FList^[Index].FPieListEintrag.FBitmap := NIL;
  END;

  {Es kann sich die Hhe der Eintrge ndern}
  IF Assigned(FListBox) THEN FListBox.CalculateItemHeight;
  Changed;
end;

procedure TPieListStrings.SetColor(Index: Integer; AColor: TColor);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;
  FList^[Index].FPieListEintrag.FColor := AColor;
  IF Assigned(FListBox) THEN FListBox.Invalidate;
  Changed;
end;

procedure TPieListStrings.SetFont(Index: Integer; AFont: TFont);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;

  IF Assigned(AFont) THEN BEGIN
    IF NOT Assigned(FList^[Index].FPieListEintrag.FFont)
      THEN FList^[Index].FPieListEintrag.FFont := TFont.Create;
    FList^[Index].FPieListEintrag.FFont.Assign(AFont);
  END
  ELSE IF Assigned(FList^[Index].FPieListEintrag.FFont) THEN BEGIN
    FList^[Index].FPieListEintrag.FFont.Free;
    FList^[Index].FPieListEintrag.FFont := NIL;
  END;

  {Es kann sich die Hhe der Eintrge ndern}
  IF Assigned(FListBox) THEN FListBox.CalculateItemHeight;
  Changed;
end;

procedure TPieListStrings.SetHelpContext(Index: Integer; AHelpContext: THelpContext);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;
  FList^[Index].FPieListEintrag.FHelpContext := AHelpContext;
  Changed;
end;

procedure TPieListStrings.SetHint(Index: Integer; AHint: string);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;
  FList^[Index].FPieListEintrag.FHint := AHint;
  Changed;
end;

procedure TPieListStrings.SetEnabled(Index: Integer; AEnabled: Boolean);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;
  FList^[Index].FPieListEintrag.FEnabled := AEnabled;
  IF Assigned(FListBox) THEN FListBox.Invalidate;
  Changed;
end;

procedure TPieListStrings.SetChecked(Index: Integer; AChecked: Boolean);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;
  FList^[Index].FPieListEintrag.FChecked := AChecked;
  IF Assigned(FListBox) THEN FListBox.Invalidate;
  Changed;
end;

procedure TPieListStrings.SetSorted(Value: Boolean);
begin
  if FSorted <> Value then
  begin
    if Value then Sort;
    FSorted := Value;
  end;
end;

procedure TPieListStrings.SetUpdateState(Updating: Boolean);
begin
  if Updating then Changing else Changed;
end;

procedure TPieListStrings.Sort;
begin
  if not Sorted and (FCount > 1) then
  begin
    Changing;
    QuickSort(0, FCount - 1);
    Changed;
  end;
end;

{******************************************************}
{******************************************************}
{******************************************************}

procedure TPieList.Edit_aufrufen;
var
  D : TPieItemsfenster;
begin
  D := TPieItemsfenster.Create(Application);
  try
    D.Liste.Assign(Self);
    if D.ShowModal = mrOK then begin
      Assign(D.Liste);
    end;
  finally
    D.Free;
  end;
end;

constructor TPieList.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FItems := TPieListStrings.Create(Self);
  FBackground := TPicture.Create;
  FBackground.OnChange := BackgroundChange;
  FBackGroundStyle := bgsNone;
  FPanel := TPanel.Create(Self);
  FPanel.Align := alNone;
  FPanel.Visible := FALSE;
  FPanel.Width := 0; {lt Panel auch zur Designtime verschwinden}
  FHeader := THeaderControl.Create(Self);
  FHeader.Visible := TRUE;
  FHeader.Align := alNone;
  FHeader.OnSectionResize := HeaderSectionResize;
  FHeader.OnDrawSection := HeaderDrawSection;
  FHeader.OnSectionClick := HeaderSectionClick;
  FShowHeader := FALSE;
  FLastSel := -1;
  FSelectedStyle := psStandard;
  FBitmapStyle := bsLeft;
  FItemHeightStyle := ihFix;
  FAlignment := taLeftJustify;
  FAnyColors := TRUE;
  FAnyFonts := TRUE;
  FLineByTabStops := FALSE;
  FHScrollPos := 0;
  FCheckBoxSize := pcbsNormal;
  FCheckBoxStyle := pcbsSunken;
  FHookStyle := phsHook;
  FHookColor := clBtnText;
  FCheckBoxes := FALSE;
  FSorted := FALSE;
  FSortColumn := 0;
  FSortUp := TRUE;
  FAllowCheckDisabledItems := FALSE;
  FMaskedImageList := TImageList.Create(Self);
  FVersion := '1.3';
end;

destructor TPieList.Destroy;
begin
  {FHC.Free; {Nicht aufrufen! wird bereits vom Parent gemacht!}
  FMaskedImageList.Free;
  FItems.Free;
  FBackground.Free;
  inherited Destroy;
end;

procedure TPieList.Clear;
begin
  FItems.Clear;
end;

procedure TPieList.Assign(Source: TPersistent);
VAR
  S: TPieList;
begin
  if Source is TPieList THEN BEGIN
//    inherited Assign(Source);
    S := Source as TPieList;

    Items.Assign(S.Items);
    Font.Assign(S.Font);
    HeaderSections.Assign(S.HeaderSections);
    HeaderFont.Assign(S.HeaderFont);
    BackGround.Assign(S.BackGround);
    BackGroundStyle := S.BackGroundStyle;
    LineByTabStops  := S.LineByTabStops;
    SelectedStyle   := S.SelectedStyle;
    BitmapStyle     := S.BitmapStyle;
    ItemHeightStyle := S.ItemHeightStyle;
    HorzScrollbar   := S.HorzScrollbar;
    HorzExtent      := S.HorzExtent;
    Alignment       := S.Alignment;
    AnyColors       := S.AnyColors;
    AnyFonts        := S.AnyFonts;
    MultiSelect     := S.MultiSelect;
    Color           := S.Color;
    HelpContext     := S.HelpContext;
    Hint            := S.Hint;
    ShowHeader      := S.ShowHeader;
    HeaderStyle     := S.HeaderStyle;
    CheckBoxes      := S.CheckBoxes;
    SortColumn      := S.SortColumn;
    CheckBoxSize    := S.CheckBoxSize;
    CheckBoxStyle   := S.CheckBoxStyle;
    HookStyle       := S.HookStyle;
    HookColor       := S.HookColor;
    SortUp          := S.SortUp;
    Sorted          := S.Sorted;
  END;
end;

procedure TPieList.CreateWnd;
begin
  inherited CreateWnd;                        { Don't Forget to Call inherited }
  IF FPanel.Parent = NIL THEN BEGIN
    FPanel.Parent := Parent;
    FPanel.Name := Name + 'FPanel';
    FPanel.Caption := '';
  END;
  IF FHeader.Parent = NIL THEN BEGIN
    FHeader.Parent := FPanel;
    FHeader.Name := Name + 'FHeader';
  END;
  ShowScrollBar(Handle, sb_Horz, FHorzScrollBar);
  PasseHorzExtentAn(FALSE);
  //SendMessage(Handle, lb_SetHorizontalExtent, FHorzExtent, 0);
end;

PROCEDURE TPieList.Loaded;
VAR
  I: Integer;
BEGIN
  inherited Loaded;
  FOR I:=0 TO FHeader.Sections.Count-1 DO FHeader.Sections[I].Style := hsOwnerDraw;
  PasseHorzExtentAn(FALSE);
  {Auch bei Default-Werten sortieren!}
  IF FSorted AND FSortUp AND (FSortColumn = 0) THEN SortList;
END;

procedure TPieList.WMMove(var Message: TWMMove);
begin
  inherited;
  IF Assigned(FPanel) AND FPanel.Visible THEN FPanel.SetBounds(Left,
    Top-FHeader.Height-FPanel.BevelWidth, Width, FHeader.Height+FPanel.BevelWidth);
end;

procedure TPieList.WMSize(var Message: TWMSize);
begin
  inherited;
  IF Assigned(FPanel) AND FPanel.Visible THEN BEGIN
    FPanel.SetBounds(Left, Top-FHeader.Height-FPanel.BevelWidth, Width, FHeader.Height+FPanel.BevelWidth);
  END;
end;

procedure TPieList.WMHScroll(var Message: TWMScroll);
VAR
  Pos: Integer;
begin
  inherited;
  {TScrollEvent}
  Pos := Message.Pos;
  IF Pos = 0 THEN Pos := GetScrollPos(Handle, SB_HORZ);
  IF assigned(FOnScrollH) THEN FOnScrollH(Self, TScrollCode(Message.ScrollCode), Pos);
  {Header scrollen}
  FHScrollPos := GetScrollPos(Handle, SB_HORZ);
  IF FShowHeader THEN FHeader.Left := - FHScrollPos;
  Invalidate;
end;

procedure TPieList.WMVScroll(var Message: TWMScroll);
VAR
  Pos: Integer;
begin
  inherited;
  {TScrollEvent}
  Pos := Message.Pos;
  IF Pos = 0 THEN Pos := GetScrollPos(Handle, SB_VERT);
  IF assigned(FOnScrollV) THEN FOnScrollV(Self, TScrollCode(Message.ScrollCode), Pos);
end;

procedure TPieList.CMVisibleChanged(var Message: TMessage);
begin
  inherited;
  IF FShowHeader THEN FPanel.Visible := Visible
                 ELSE FPanel.Visible := FALSE;
end;

procedure TPieList.WMEraseBkgnd(var Message: TWmEraseBkgnd);
VAR
  R: TRect;
BEGIN
  inherited;
  IF (FBackGroundStyle <> bgsNone) AND
  Assigned(FBackGround) AND
  Assigned(FBackGround.Graphic) THEN BEGIN
    GetClipBox(Message.DC, R);
    PaintBackground(R);
  END;
END;

procedure TPieList.WMPaint(var Message: TWmPaint);
BEGIN
  inherited;
  IF (FBackGroundStyle <> bgsNone) AND
  Assigned(FBackGround) AND
  Assigned(FBackGround.Graphic) AND
  (Items.Count = 0) THEN PaintBackground(ClientRect);
END;

procedure TPieList.CalculateItemHeight;
begin
  {Es kann sich die Hhe der Eintrge ndern}
  Style := lbOwnerDrawFixed;
  Style := lbOwnerDrawVariable;
end;

procedure TPieList.GetScrollPixel(Art: Byte; VAR ScrollX, ScrollY: Integer);
VAR
  HScroll, VScroll, K, ScrollH, ScrollIndex, Min, Max, Summe: Integer;
  Passt_nicht_mehr: Boolean;
begin
  HScroll := 0; VScroll := 0;
  {Art = 0: Aktuelle Scrollposition ermitteln}
  IF Art = 0 THEN BEGIN
    HScroll := GetScrollPos(Handle, SB_HORZ);
    ScrollIndex := GetScrollPos(Handle, SB_VERT);
    VScroll := 0;
    FOR K:=0 TO ScrollIndex-1 DO BEGIN
      MeasureItem(K, ScrollH);
      VScroll := VScroll + ScrollH;
    END;
  END;
  {Art = 1: Maximalen Scrollbereich ermitteln}
  IF Art = 1 THEN BEGIN
    GetScrollRange(Handle, SB_Horz, Min, Max);
    HScroll := Max;
    GetScrollRange(Handle, SB_VERT, Min, Max);
    IF (Items.Count > 0) AND (Items.Count > Max) THEN BEGIN
      {zuerst die Eintrge ermitteln, die nicht mehr gescrollt werden}
      Summe := 0;
      K := Max;
      REPEAT
        MeasureItem(K, ScrollH);
        Summe := Summe + ScrollH;
        Passt_nicht_mehr := Summe > ClientRect.Bottom-ClientRect.Top;
        dec(K);
      UNTIL Passt_nicht_mehr OR (K < 0);
      {dann die restlichen scrollbaren Eintrge ermitteln}
      IF Passt_nicht_mehr THEN BEGIN
        ScrollIndex := K+1;
        VScroll := 0;
        FOR K:=0 TO ScrollIndex DO BEGIN
          MeasureItem(K, ScrollH);
          VScroll := VScroll + ScrollH;
        END;
      END;
      VScroll := VScroll + (ClientRect.Bottom-ClientRect.Top);
    END;
    IF HScroll = 0 THEN HScroll := ClientRect.Right - ClientRect.Left;
    IF VScroll = 0 THEN VScroll := ClientRect.Bottom - ClientRect.Top;
  END;
  ScrollX := HScroll;
  ScrollY := VScroll;
end;

procedure TPieList.PaintBackground(R: TRect);
VAR
  CR: TRect;
  B, H, I, J: Integer;
  P : TPicture;
  Pos1: TRect; {Position des gesamten Pattern im Canvas}
  Pos2: TRect; {Position des darzustellenden Teilpattern im Pattern}
  Malen: Boolean;
  HScroll, VScroll, HClient, VClient: Integer;
BEGIN     {TCanvas, Pattern}
  IF Assigned(FBackGround) AND Assigned(FBackGround.Graphic) THEN BEGIN
    P := TPicture.Create;
    TRY
      P.Assign(FBackGround);
      CR := ClientRect;
      H := P.Graphic.Height;
      B := P.Graphic.Width;
      IF (H>0) AND (B>0) THEN BEGIN
        GetScrollPixel(0, HScroll, VScroll);
        CASE FBackGroundStyle OF
{------------------------------------------------------}
        bgsCenter:
          BEGIN
            GetScrollPixel(1, HClient, VClient);
            Pos1 := Rect((HClient-B) DIV 2 - HScroll,
                         (VClient-H) DIV 2 - VScroll,
                         (HClient+B) DIV 2 - HScroll,
                         (VClient+H) DIV 2 - VScroll);

            Malen := (Pos1.Left < R.Right) AND (Pos1.Right > R.Left) AND
                     (Pos1.Top < R.Bottom) AND (Pos1.Bottom > R.Top);

            IF Malen THEN BEGIN
              Pos2 := Rect(R.Left-Pos1.Left, R.Top-Pos1.Top, R.Right-Pos1.Left, R.Bottom-Pos1.Top);
              IF Pos2.Left   < 0 THEN Pos2.Left   := 0;
              IF Pos2.Top    < 0 THEN Pos2.Top    := 0;
              IF Pos2.Right  > B THEN Pos2.Right  := B;
              IF Pos2.Bottom > H THEN Pos2.Bottom := H;

              IF (Pos2.Left > 0) OR (Pos2.Top > 0) THEN
              BitBlt(P.Bitmap.Canvas.Handle, 0, 0,
                    (Pos2.Right-Pos2.Left),
                    (Pos2.Bottom-Pos2.Top),
                     P.Bitmap.Canvas.Handle, Pos2.Left, Pos2.Top,
                     srcCopy);

              P.Graphic.Width := Pos2.Right-Pos2.Left;
              P.Graphic.Height := Pos2.Bottom-Pos2.Top;
              Canvas.Draw(Pos1.Left + Pos2.Left, Pos1.Top  + Pos2.Top, P.Graphic);
            END;
          END;
{------------------------------------------------------}
        bgsStretch:
          BEGIN
            GetScrollPixel(1, HClient, VClient);
            Pos1 := Rect(-HScroll, -VScroll, HClient-HScroll, VClient-VScroll);

            Pos2 := Rect((R.Left  + HScroll) * B DIV (HClient),
                         (R.Top   + VScroll) * H DIV (VClient),
                         (R.Right + HScroll) * B DIV (HClient),
                         (R.Bottom+ VScroll) * H DIV (VClient));

            IF (Pos2.Left > 0) OR (Pos2.Top > 0) THEN
            BitBlt(P.Bitmap.Canvas.Handle, 0, 0,
                  (Pos2.Right-Pos2.Left),
                  (Pos2.Bottom-Pos2.Top),
                   P.Bitmap.Canvas.Handle, Pos2.Left, Pos2.Top,
                   srcCopy);

            P.Graphic.Width := Pos2.Right-Pos2.Left;
            P.Graphic.Height := Pos2.Bottom-Pos2.Top;
            Canvas.StretchDraw(R, P.Graphic);
          END;
{------------------------------------------------------}
        bgsPattern:
          BEGIN
            FOR I := 0 TO ((CR.Right - CR.Left + HScroll) DIV B) DO
            FOR J := 0 TO ((CR.Bottom - CR.Top + VScroll) DIV H) DO BEGIN
              Pos1 := Rect(I*B-HScroll, J*H-VScroll, (I+1)*B-HScroll, (J+1)*H-VScroll);
              Malen := (Pos1.Left < R.Right) AND (Pos1.Right > R.Left) AND
                       (Pos1.Top < R.Bottom) AND (Pos1.Bottom > R.Top);

              IF Malen THEN BEGIN
                Pos2 := Rect(R.Left-Pos1.Left, R.Top-Pos1.Top, R.Right-Pos1.Left, R.Bottom-Pos1.Top);
                IF Pos2.Left   < 0 THEN Pos2.Left   := 0;
                IF Pos2.Top    < 0 THEN Pos2.Top    := 0;
                IF Pos2.Right  > B THEN Pos2.Right  := B;
                IF Pos2.Bottom > H THEN Pos2.Bottom := H;

                IF (Pos2.Left > 0) OR (Pos2.Top > 0) THEN
                BitBlt(P.Bitmap.Canvas.Handle, 0, 0,
                      (Pos2.Right-Pos2.Left),
                      (Pos2.Bottom-Pos2.Top),
                       P.Bitmap.Canvas.Handle, Pos2.Left, Pos2.Top,
                       srcCopy);

                P.Graphic.Width := Pos2.Right-Pos2.Left;
                P.Graphic.Height := Pos2.Bottom-Pos2.Top;
                Canvas.Draw(Pos1.Left + Pos2.Left, Pos1.Top  + Pos2.Top, P.Graphic);
                P.Assign(FBackGround);
              END;
            END;
          END;
{------------------------------------------------------}
        END;  {CASE FBackGroundStyle OF ...}
      END;
    FINALLY
      P.Free;
    END;
  END;
END;

procedure TPieList.RequestAlign;
begin
  IF Assigned(FPanel) AND FShowHeader THEN BEGIN
    IF Align IN [alLeft, alRight, alTop, alClient] THEN BEGIN
      FPanel.Align := alTop;
    END
    ELSE IF Align = alBottom THEN BEGIN
      FPanel.Align := alBottom;
    END
    ELSE BEGIN
      FPanel.Align := alNone;
      FPanel.SetBounds(Left, Top-FHeader.Height-FPanel.BevelWidth, Width, FHeader.Height+FPanel.BevelWidth);
    END;
  END;
  inherited RequestAlign;
{  IF Assigned(FPanel) AND FShowHeader THEN BEGIN  
    IF Align IN [alLeft, alRight, alClient] THEN BEGIN
      Align := alNone;
    END;
  END;}
end;

procedure TPieList.SetHorzExtent(Value: Integer);
begin
  if Value <> FHorzExtent then
  begin
    FHorzExtent := Value;
    IF NOT(FShowHeader) THEN Perform(lb_SetHorizontalExtent, FHorzExtent, 0);
  end;
end;

procedure TPieList.SetSortColumn(Value: Integer);
begin
  IF Value <> FSortColumn THEN BEGIN
    FSortColumn := Value;
    FHeader.Repaint;
    SortList;
  end;
end;

procedure TPieList.SetSortUp(Value: Boolean);
begin
  IF Value <> FSortUp THEN BEGIN
    FSortUp := Value;
    FHeader.Repaint;
    SortList;
  end;
end;

procedure TPieList.SetBackground(Value: TPicture);
BEGIN
  FBackground.Assign(Value);
  Invalidate;
END;

procedure TPieList.BackgroundChange(Sender: TObject);
BEGIN
  Invalidate;
END;

procedure TPieList.SetBackGroundStyle(Value: TBackGroundStyle);
BEGIN
  IF Value <> FBackGroundStyle THEN BEGIN
    FBackGroundStyle := Value;
    Invalidate;
  END;
END;

procedure TPieList.SetLineByTabStops(Value: Boolean);
begin
  if FLineByTabStops <> Value then begin
    FLineByTabStops := Value;
    Invalidate;
  end;
end;

procedure TPieList.CalculateHorzScrollbar;
begin
  PasseHorzExtentAn(FALSE);
end;

procedure TPieList.PasseHorzExtentAn(HeaderResize: Boolean);
VAR
  I, Diff: Integer;
begin
  IF FShowHeader THEN BEGIN
    FHorzExtentIntern := -3;
    FOR I:=0 TO FHeader.Sections.Count-1 DO FHorzExtentIntern := FHorzExtentIntern + FHeader.Sections[I].Width;
    FHeader.Width := FHorzExtentIntern + 3;
    Perform(lb_SetHorizontalExtent, FHorzExtentIntern, 0);

    FHScrollPos := GetScrollPos(Handle, SB_HORZ);
    IF HeaderResize THEN BEGIN
      {evt. Maus-Cursor "festpinnen", damit das OnResize-Ereignis nicht rekursiv ausgelst wird.}
      Diff := - FHeader.Left - FHScrollPos;
      if Diff > 0 THEN SetCursorPos(Mouse.CursorPos.x + Diff, Mouse.CursorPos.y);
    END;
    FHeader.Left := - FHScrollPos;
  END
  ELSE BEGIN
    IF FHorzScrollBar THEN Perform(lb_SetHorizontalExtent, FHorzExtent, 0)
                      ELSE Perform(lb_SetHorizontalExtent, 0, 0);
  END;
end;

procedure TPieList.SetHCVisible(Value: Boolean);
begin
  IF Value <> FShowHeader THEN BEGIN
    FShowHeader := Value;
    IF FShowHeader THEN FPanel.Visible := Visible
                   ELSE FPanel.Visible := FALSE;

    IF FShowHeader THEN BEGIN
      {zeigt HeaderPanel zur Designzeit wieder an}
      FPanel.SetBounds(Left, Top-FHeader.Height-FPanel.BevelWidth, Width, FHeader.Height+FPanel.BevelWidth);
    END
    ELSE FPanel.Width := 0; {lt Panel auch zur Designzeit verschwinden}
    PasseHorzExtentAn(FALSE);
    Invalidate;
  END;
end;

function TPieList.GetHCS: THeaderSections;
begin
  Result := FHeader.Sections;
end;

procedure TPieList.SetHCS(Value: THeaderSections);
begin
  FHeader.Sections := Value;
end;

{$IFDEF D5_OR_HIGHER}
function TPieList.GetHCImages: TCustomImageList;
begin
  Result := FHeader.Images;
end;

procedure TPieList.SetHCImages(Value: TCustomImageList);
begin
  FHeader.Images := Value;
end;
{$ENDIF}

function TPieList.GetHCStyle: THeaderStyle;
begin
  Result := FHeader.Style;
end;

procedure TPieList.SetHCStyle(Value: THeaderStyle);
begin
  FHeader.Style := Value;
end;

function TPieList.GetHCFont: TFont;
begin
  Result := FHeader.Font;
end;

procedure TPieList.SetHCFont(Value: TFont);
begin
  FHeader.Font := Value;
end;

procedure TPieList.HeaderSectionResize(HeaderControl: THeaderControl; Section: THeaderSection);
begin
  PasseHorzExtentAn(TRUE);
  Invalidate;
end;

procedure TPieList.HeaderSectionClick(HeaderControl: THeaderControl; Section: THeaderSection);
begin
  IF (FSortColumn = Section.Index) THEN FSortUp := NOT FSortUp ELSE FSortUp := TRUE;
  FSortColumn := Section.Index;
  FHeader.Repaint;
  SortList;
  If assigned(FOnSectionClick) THEN FOnSectionClick(HeaderControl, Section);
end;

procedure TPieList.SortList;
VAR
  DefaultSort: Boolean;
  HorzScrollPos: Integer;
  IndexString: string;
  I: Integer;
begin
  IF Items.Count = 0 THEN exit;
  IF assigned(FOnSortProgress) THEN FOnSortProgress(self, psStarting, 0);
  IF ItemIndex >= 0 THEN IndexString := FItems.Strings[ItemIndex] ELSE IndexString := '';
  IF MultiSelect THEN FOR I:=0 TO FItems.Count-1 DO FItems.FList[I].FPieListEintrag.FSelected := Selected[I];
  HorzScrollPos := GetScrollPos(Handle, SB_HORZ);
  DefaultSort := TRUE;
  If assigned(FOnColumnSort)
    THEN FOnColumnSort(Self, FHeader.Sections[FSortColumn], FSortColumn, FSortUp, DefaultSort);
  IF DefaultSort THEN ListeSortieren;
  {gescrollte Listen nach dem Sortieren wieder auf Ausgangspos. scrollen}
  IF HorzScrollPos > 0 THEN BEGIN
    PasseHorzExtentAn(FALSE);
    Perform(WM_HSCROLL, SB_THUMBPOSITION + (HorzScrollPos SHL 16), 0);
  END;
  IF IndexString <> '' THEN ItemIndex := FItems.IndexOf(IndexString);
  IF MultiSelect THEN FOR I:=0 TO FItems.Count-1 DO Selected[I] := FItems.FList[I].FPieListEintrag.FSelected;
  IF assigned(FOnSortProgress) THEN FOnSortProgress(self, psEnding, 0);
end;

function TPieList.ItemsChecked(AllowDisabled: Boolean): Integer;
VAR
  I: Integer;
begin
  Result := 0;
  FOR I:=0 TO FItems.Count-1 DO
    IF FItems.Checked[I] AND (AllowDisabled OR FItems.Enabled[I]) THEN inc(Result);
end;

{$IFDEF D5_OR_HIGHER}
function TPieList.DisableGlyph(Original: TBitmap; NumGlyphs: Integer): Integer;
const
  ROP_DSPDxax = $00E20746;
var
  TmpImage, DDB, MonoBmp: TBitmap;
  IWidth, IHeight: Integer;
  IRect, ORect: TRect;
  DestDC: HDC;
begin
  Result := -1;
  IF (Original = NIL) OR ((Original.Width or Original.Height) = 0) THEN Exit;
  IWidth := Original.Width;
  IF NumGlyphs > 0 THEN IWidth := IWidth div NumGlyphs;
  IHeight := Original.Height;
  TmpImage := TBitmap.Create;
  try
    TmpImage.Width := IWidth;
    TmpImage.Height := IHeight;
    IRect := Rect(0, 0, IWidth, IHeight);
    TmpImage.Canvas.Brush.Color := clBtnFace;
    TmpImage.Palette := CopyPalette(Original.Palette);


    MonoBmp := nil;
    DDB := nil;
    try
      MonoBmp := TBitmap.Create;
      DDB := TBitmap.Create;
      DDB.Assign(Original);
      DDB.HandleType := bmDDB;
      if NumGlyphs > 1 then with TmpImage.Canvas do begin
        { Change white & gray to clBtnHighlight and clBtnShadow }
        ORect := Rect(2 * IWidth, 0, (2 + 1) * IWidth, IHeight);
        CopyRect(IRect, DDB.Canvas, ORect);
        MonoBmp.Monochrome := True;
        MonoBmp.Width := IWidth;
        MonoBmp.Height := IHeight;

        { Convert white to clBtnHighlight }
        DDB.Canvas.Brush.Color := clWhite;
        MonoBmp.Canvas.CopyRect(IRect, DDB.Canvas, ORect);
        Brush.Color := clBtnHighlight;
        DestDC := Handle;
        SetTextColor(DestDC, clBlack);
        SetBkColor(DestDC, clWhite);
        BitBlt(DestDC, 0, 0, IWidth, IHeight, MonoBmp.Canvas.Handle, 0, 0, ROP_DSPDxax);

        { Convert gray to clBtnShadow }
        DDB.Canvas.Brush.Color := clGray;
        MonoBmp.Canvas.CopyRect(IRect, DDB.Canvas, ORect);
        Brush.Color := clBtnShadow;
        DestDC := Handle;
        SetTextColor(DestDC, clBlack);
        SetBkColor(DestDC, clWhite);
        BitBlt(DestDC, 0, 0, IWidth, IHeight, MonoBmp.Canvas.Handle, 0, 0, ROP_DSPDxax);

        { Convert transparent color to clBtnFace }
        DDB.Canvas.Brush.Color := ColorToRGB(Original.TransparentColor);
        MonoBmp.Canvas.CopyRect(IRect, DDB.Canvas, ORect);
        Brush.Color := clBtnFace;
        DestDC := Handle;
        SetTextColor(DestDC, clBlack);
        SetBkColor(DestDC, clWhite);
        BitBlt(DestDC, 0, 0, IWidth, IHeight, MonoBmp.Canvas.Handle, 0, 0, ROP_DSPDxax);
      end
      else begin
        { Create a disabled version }
        with MonoBmp do begin
          Assign(Original);
          HandleType := bmDDB;
          Canvas.Brush.Color := clBlack;
          Width := IWidth;
          if Monochrome then begin
            Canvas.Font.Color := clWhite;
            Monochrome := False;
            Canvas.Brush.Color := clWhite;
          end;
          Monochrome := True;
        end;
        with TmpImage.Canvas do begin
          Brush.Color := clBtnFace;
          FillRect(IRect);
          Brush.Color := clBtnHighlight;
          SetTextColor(Handle, clBlack);
          SetBkColor(Handle, clWhite);
          BitBlt(Handle, 1, 1, IWidth, IHeight, MonoBmp.Canvas.Handle, 0, 0, ROP_DSPDxax);
          Brush.Color := clBtnShadow;
          SetTextColor(Handle, clBlack);
          SetBkColor(Handle, clWhite);
          BitBlt(Handle, 0, 0, IWidth, IHeight, MonoBmp.Canvas.Handle, 0, 0, ROP_DSPDxax);
        end;
      end;
    finally
      DDB.Free;
      MonoBmp.Free;
    end;
    Result := FMaskedImageList.AddMasked(TmpImage, clDefault);
  finally
    TmpImage.Free;
  end;
  Original.Dormant;
end;
{$ENDIF}

procedure TPieList.HeaderDrawSection(HeaderControl: THeaderControl; Section: THeaderSection; const Rect: TRect; Pressed: Boolean);
VAR
  XPos, YPos, ZeichenBreite, Breite, Bitmapbreite: Integer;
  R: TRect;
  Points: array[0..3] of TPoint;
  {$IFDEF D5_OR_HIGHER}
  DisIndex: Integer;
  Bitmap: TBitmap;
  {$ENDIF}
begin
  {normale Einstellungen}
  XPos := Rect.Left + FHeader.Canvas.Font.Size;
  YPos := Rect.Top + 2;
  ZeichenBreite := FHeader.Canvas.TextWidth('x');
  R.Top := Rect.Top; R.Bottom := Rect.Bottom;
  FHeader.Canvas.Brush.Color := clBtnFace;

  {Besonderheiten, wenn gedrckt}
  IF Pressed THEN BEGIN
    inc(XPos);
    inc(YPos);
  END;

  {Besonderheiten, wenn Sortierspalte}
  IF FSorted AND (Section.Index = FSortColumn) THEN XPos := XPos + 8;

  {Besonderheiten, wenn Images}
  Bitmapbreite := 0;
  {$IFDEF D5_OR_HIGHER}
  IF Assigned(FHeader.Images) AND (Section.ImageIndex >= 0) AND
                                  (Section.ImageIndex < FHeader.Images.Count) THEN BEGIN
    Bitmap := TBitmap.Create;
    TRY
      FHeader.Images.GetBitmap(Section.ImageIndex, Bitmap);
      Bitmap.Transparent := TRUE;
      IF NOT FHeader.Enabled THEN BEGIN
        DisIndex := DisableGlyph(Bitmap, 0);
        ImageList_DrawEx(FMaskedImageList.Handle, DisIndex, FHeader.Canvas.Handle, XPos, R.Top, 0, 0,
          ColorToRGB(clBtnFace), clNone, ILD_Normal);
      END
      ELSE FHeader.Canvas.StretchDraw(Classes.Rect(XPos, R.Top, XPos+Bitmap.Width, R.Bottom), Bitmap);
      Bitmapbreite := Bitmap.Width + 2;{2 Pixel Abstand zwischen Bitmap und Text}
    FINALLY
      Bitmap.Free;
    END;
    XPos := XPos + Bitmapbreite;
  END;
  {$ENDIF}

  {Text zeichnen}
  Breite := FHeader.Canvas.TextWidth(Section.Text);
  IF NOT FHeader.Enabled THEN FHeader.Canvas.Font.Color := clGrayText;
  IF (Breite < (Rect.Right-XPos-2)) THEN BEGIN
    R.Left := XPos;
    R.Right := Rect.Right-1;
    FHeader.Canvas.TextRect(R, R.Left, YPos, Section.Text);
  END
  ELSE BEGIN
    R.Left := XPos;
    R.Right := Rect.Right-1-3*ZeichenBreite;
    IF (R.Right > R.Left) THEN FHeader.Canvas.TextRect(R, R.Left, YPos, Section.Text);
    R.Left := R.Right+2;
    R.Right := Rect.Right-1;
    IF (R.Left > Rect.Left)
      THEN FHeader.Canvas.TextRect(R, R.Left, YPos, '...')
      {wenn nicht mal mehr Punkte hinpassen --> grau ausfllen}
      ELSE FHeader.Canvas.FillRect(Rect);
  END;

  {Besonderheiten, wenn Sortierspalte}
  {blaues Dreieck malen}
  IF FSorted AND (Section.Index = FSortColumn) AND (Rect.Right - Rect.Left > Bitmapbreite) THEN BEGIN
    XPos := Rect.Left + 5;
    YPos := 6;

    {Besonderheiten, wenn gedrckt}
    IF Pressed THEN BEGIN
      inc(XPos);
      inc(YPos);
    END;

    IF FSortUp THEN BEGIN
      Points[0] := Point(XPos,YPos);
      Points[1] := Point(XPos+7,YPos);
      Points[2] := Point(XPos+3,YPos+7);
      Points[3] := Point(XPos,YPos);
    END
    ELSE BEGIN
      Points[0] := Point(XPos,YPos+7);
      Points[1] := Point(XPos+7,YPos+7);
      Points[2] := Point(XPos+3,YPos);
      Points[3] := Point(XPos,YPos+7);
    END;

    FHeader.Canvas.Polygon(Points);
    FHeader.Canvas.Brush.Color := clBlue;
    FHeader.Canvas.FloodFill(XPos+3, YPos+5, clBlack, fsBorder);
  END;
end;

procedure TPieList.ListeSortieren;
VAR
  TestListe: TStringList;
  T, Teil: string;
  Index, I, J, Position: Integer;
  Vis: Boolean;
begin
  {Liste sortieren nur zur Laufzeit! (sonst geht allerhand schief)}
  IF csDesigning IN ComponentState THEN exit;
  IF NOT Sorted THEN exit;

  Vis := Visible;
  If Vis THEN Hide;
  TestListe := TStringList.Create;

  TestListe.Duplicates := dupAccept;
  TestListe.Sorted := TRUE;

  FOR I:=0 TO Items.Count-1 DO BEGIN
    IF assigned(FOnSortProgress) THEN FOnSortProgress(self, psRunning, round((I+1)*100/Items.Count));

    {Teilstring ermitteln}
    T := Items.Strings[I];
    IF FShowHeader THEN FOR J:=0 TO FSortColumn DO BEGIN
      Position := Pos(#9, T);
      if Position > 0 THEN BEGIN
        Teil := copy(T, 1, Position-1);
        T := copy(T, Position+1, length(T) - Position);
      END
      ELSE BEGIN
        Teil := T;
        T := '';
      END;
    END
    ELSE Teil := T;

    Index := TestListe.Add(Teil);
    IF NOT FSortUp THEN Index := TestListe.Count - 1 - Index;
    Items.Move(I, Index);
  END;

  {Testliste lschen}
  TestListe.Free;
  {Es kann sich die Hhe der Eintrge ndern}
  CalculateItemHeight;
  IF Vis THEN Show;
end;

procedure TPieList.SetSelectedStyle(AStyle: TSelectedStyle);
begin
  if FSelectedStyle <> AStyle then begin
    FSelectedStyle := AStyle;
    Invalidate;
  end;
end;

procedure TPieList.SetBitmapStyle(AStyle: TBitmapStyle);
begin
  if FBitmapStyle <> AStyle then begin
    FBitmapStyle := AStyle;
    Invalidate;
  end;
end;

procedure TPieList.SetItemHeightStyle(AStyle: TItemHeightStyle);
begin
  if FItemHeightStyle <> AStyle then begin
    FItemHeightStyle := AStyle;
    {Es kann sich die Hhe der Eintrge ndern}
    CalculateItemHeight;
    Invalidate;
  end;
end;

function TPieList.ItemAtPos(Pos: TPoint; Existing: Boolean): Integer;
var
  Count: Integer;
  ItemRect: TRect;
begin
  if PtInRect(ClientRect, Pos) then
  begin
    Result := TopIndex;
    Count := FItems.Count;
    while Result < Count do begin
      Perform(LB_GETITEMRECT, Result, Longint(@ItemRect));
      if PtInRect(ItemRect, Pos) then Exit;
      Inc(Result);
    end;
    if not Existing then Exit;
  end;
  Result := -1;
end;

function TPieList.GetBottomIndex: Integer;
VAR
  Index, Hoehe, ItemHoehe, Summe: Integer;
begin
  Index := TopIndex-1;
  Hoehe := ClientRect.Bottom-ClientRect.Top;
  Summe := 0;
  REPEAT
    inc(Index);
    MeasureItem(Index, ItemHoehe);
    Summe := Summe + ItemHoehe;
  UNTIL (Summe > Hoehe) OR (Index > Items.Count-2);
  IF (Summe > Hoehe) THEN dec(Index);
  Result := Index;
end;

procedure TPieList.SetBottomIndex(Value: Integer);
VAR
  Index, Hoehe, ItemHoehe, Summe: Integer;
begin
  IF (Value > -1) AND (Value < Items.Count) AND (Value <> GetBottomIndex) THEN BEGIN
    Index := Value+1;
    Hoehe := ClientRect.Bottom-ClientRect.Top;
    Summe := 0;
    REPEAT
      dec(Index);
      MeasureItem(Index, ItemHoehe);
      Summe := Summe + ItemHoehe;
    UNTIL (Summe > Hoehe) OR (Index < 1);
    IF (Summe > Hoehe) THEN inc(Index);
    TopIndex := Index;
  END;
end;

procedure TPieList.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do Style := Style or LBS_USETABSTOPS;
end;

procedure TPieList.SelectAll;
begin
  if MultiSelect or ExtendedSelect then
    SendMessage(Handle, LB_SETSEL, 1, -1);
end;

procedure TPieList.ClearSelection;
begin
  if MultiSelect or ExtendedSelect then
    SendMessage(Handle, LB_SETSEL, 0, -1);
end;

procedure TPieList.Click;
begin
  inherited;
  Invalidate;
end;

procedure TPieList.DblClick;
begin
  IF FCheckBoxes AND (Items.Enabled[ItemIndex] OR FAllowCheckDisabledItems) THEN BEGIN
    Items.Checked[ItemIndex] := NOT Items.Checked[ItemIndex];
    inherited;
    Invalidate;
  END ELSE inherited;
end;

procedure TPieList.KeyDown(var Key: Word; Shift: TShiftState);
VAR
  R: TRect;
  Pt: TPoint;
begin
  IF (Key = VK_SPACE) AND (ItemIndex >= 0) AND
    FCheckBoxes AND (Items.Enabled[ItemIndex] OR FAllowCheckDisabledItems) THEN BEGIN
    Items.Checked[ItemIndex] := NOT Items.Checked[ItemIndex];
    Invalidate;
  END;
  {bei drcken von SHIFT + F10-Taste Popup-Men anzeigen}
  IF (Key = VK_F10) AND (ssShift IN Shift) THEN BEGIN
    R := ItemRect(ItemIndex);
    Pt := Point(R.Left,R.Bottom-1);
    IF assigned(FOnPopup) THEN FOnPopup(Self, Pt, pssKey)
    ELSE IF (PopupMenu <> NIL) AND PopupMenu.AutoPopup THEN BEGIN
      Pt := ClientToScreen(Pt);
      PopupMenu.Popup(Pt.x, Pt.y);
    END;
    Key := 0;
  END;
  inherited;
end;

procedure TPieList.MeasureItem(Index: Integer; var Height: Integer);
var
  Metrics: TTextMetric;
  H, B: Integer;
begin
  inherited MeasureItem(Index, Height);
  IF SelectedStyle <> psOwnerDraw THEN WITH Canvas do begin
    {Standard-hhe}
    Canvas.Font := Self.Font;
    GetTextMetrics(Canvas.Handle, Metrics);
    IF Metrics.tmHeight > Height THEN Height := Metrics.tmHeight;
    {abweichende Hhe}
    CASE FItemHeightStyle OF
    ihFix   : Height := ItemHeight;
    ihFont  : BEGIN
              IF FAnyFonts AND Assigned(Items.Fonts[Index])
                THEN Canvas.Font := Items.Fonts[Index]
                ELSE Canvas.Font := Self.Font;
              GetTextMetrics(Canvas.Handle, Metrics);
              Height := Metrics.tmHeight;
              END;
    ihBitmap: BEGIN
              Height := ItemHeight;
              IF Assigned(Items.Bitmaps[Index]) AND NOT(Items.Bitmaps[Index].Empty) THEN BEGIN
                H := Items.Bitmaps[Index].Height;
                B := Items.Bitmaps[Index].Width;
                IF Width / B < 1 THEN H := round(Width / B * H);
                H := H+2; {oben und unten 1 Pixel Abstand lassen}
                Height := H;
              END;
              END;
    ihFontBitmap: BEGIN
              IF FAnyFonts AND Assigned(Items.Fonts[Index])
                THEN Canvas.Font := Items.Fonts[Index]
                ELSE Canvas.Font := Self.Font;
              GetTextMetrics(Canvas.Handle, Metrics);
              Height := Metrics.tmHeight;
              IF Assigned(Items.Bitmaps[Index]) AND NOT(Items.Bitmaps[Index].Empty) THEN BEGIN
                H := Items.Bitmaps[Index].Height;
                B := Items.Bitmaps[Index].Width;
                IF Width / B < 1 THEN H := round(Width / B * H);
                H := H+2; {oben und unten 1 Pixel Abstand lassen}
                IF H > Height THEN Height := H;
              END;
              END;
    END;
  END;
end;

procedure TPieList.DrawItem(Index: integer; ARect: TRect; State:
  TOwnerDrawState);
VAR
  FC, PC, BC: TColor;
begin
  FC := Canvas.Font.Color;
  PC := Canvas.Pen.Color;
  BC := Canvas.Brush.Color;
  case FSelectedStyle of
    psStandard: DrawBoldStyle(Index, ARect, State, 0);
    psBoldText: DrawBoldStyle(Index, ARect, State, 1);
    psOwnerDraw: inherited DrawItem(Index, ARect, State);
  end;
  Canvas.Font.Color := FC;
  Canvas.Pen.Color := PC;
  Canvas.Brush.Color := BC;
  //Enabled-Eigenschaft an HeaderControl weitergeben
  IF FHeader.Enabled <> Enabled THEN BEGIN
    FHeader.Enabled := Enabled;
    FHeader.Invalidate;
  END;
end;

function TPieList.DrawItemBitmap(Index: integer; ARect: TRect): TRect;
VAR
  R: TRect;
  H, B, M, I, J: Integer;
  Fak1: Double;
  Bitmap: TBitmap;
begin
  Bitmap := Items.Bitmaps[Index];
  IF Assigned(Bitmap) THEN BEGIN
    R := ARect;
    dec(R.Bottom);
    inc(R.Top);
    H := Bitmap.Height;
    B := Bitmap.Width;
    IF (H>0) AND (B>0) THEN BEGIN
      IF FBitmapStyle = bsPattern THEN BEGIN
        IF H > (ARect.Bottom - ARect.Top) THEN H := (ARect.Bottom - ARect.Top);
        FOR I := 0 TO ((ARect.Right - ARect.Left) DIV B) DO
        FOR J := 0 TO ((ARect.Bottom - ARect.Top) DIV H)-1 DO BEGIN
          R := Rect(I*B+ARect.Left, J*H+ARect.Top,
                (I+1)*B+ARect.Left, (J+1)*H+ARect.Top);
          Canvas.StretchDraw(R, Bitmap);
        END;
      END
      ELSE BEGIN
        Fak1 := (R.Bottom-R.Top);
        Fak1 := Fak1 / H;
        IF FBitmapStyle = bsLeft THEN BEGIN
          R.Bottom  := R.Top + round(H*Fak1);
          R.Right   := R.Left + round(B*Fak1);
        END;
        IF FBitmapStyle = bsRight THEN BEGIN
          R.Bottom  := R.Top + round(H*Fak1);
          R.Left    := R.Right - round(B*Fak1);
        END;
        IF FBitmapStyle = bsCenter THEN BEGIN
          R.Bottom  := R.Top + round(H*Fak1);
          M         := (R.Right-R.Left) DIV 2;
          R.Left    := M - round(B*Fak1) DIV 2;
          R.Right   := M + round(B*Fak1) DIV 2;
        END;
        IF FBitmapStyle = bsStretch THEN BEGIN
        END;
        Canvas.StretchDraw(R, Bitmap);
      END;
    END ELSE R := Rect(R.Left,R.Top,R.Left,R.Top);
  END ELSE R := Rect(R.Left,R.Top,R.Left,R.Top);
  Result := R;
end;

procedure TPieList.DrawBoldStyle(Index: integer; ARect: TRect;
  State: TOwnerDrawState; Art: Byte);
var  {Art = 0: Standard, 1: BoldStyle, 2: CheckBoxStyle}
  I: integer;
  BitmapRect: TRect;
  YPos, Breite, Zeichenbreite, TabLinks, TabRechts, Position, B: Integer;
  T, Teil: string;
  R, BoxRect: TRect;
  TM: TextMetric;
begin
{************** Einstellungen vornehmen *******************}
  with Canvas do begin
    {manually set these colors to override the color change when
    the item is focused}
    IF FAnyColors
      THEN Brush.Color := Items.Colors[Index]
      ELSE Brush.Color := Color;
    IF FAnyFonts AND Assigned(Items.Fonts[Index])
      THEN Pen.Color := Items.Fonts[Index].Color
      ELSE Pen.Color := Self.Font.Color;
    IF FAnyFonts AND Assigned(Items.Fonts[Index])
      THEN Font := Items.Fonts[Index]
      ELSE Font := Self.Font;
    IF (FBackGroundStyle = bgsNone) OR
       (FAnyColors AND (Brush.Color <> Color))
       THEN FillRect(ARect)
       ELSE {IF (Index = ItemIndex) THEN PaintBackground(ARect)};

{*********** CheckBox-Gre vorgeben ***********************}
    B := GetCheckBoxSize;

{*********** Besonderheiten fr selektierte Items **********************************}
    IF (odSelected in State) THEN BEGIN
      CASE Art OF
      0: BEGIN
         IF Enabled THEN Brush.Color := clHighlight
                    ELSE Brush.Color := clBtnFace;
         Font.Color := clHighlightText;
         IF B>0 THEN FillRect(Rect(ARect.Left+B+4, ARect.Top, ARect.Right, ARect.Bottom))
                ELSE FillRect(ARect);
         END;
      1: IF fsBold IN Font.Style
           THEN Font.Style := Font.Style - [fsBold]
           ELSE Font.Style := Font.Style + [fsBold];
      END;
    END;
    IF NOT Items.Enabled[Index] OR NOT Enabled THEN Font.Color := clGrayText;
  END;

{*********** Bitmap malen **********************************}
  BitmapRect := DrawItemBitmap(Index, ARect);

{************** Text ausgeben ***************************}
  Canvas.Brush.Style := bsClear;
  YPos := ARect.Top + (ARect.Bottom-ARect.Top-Canvas.TextHeight('Gg')) DIV 2;
  IF FShowHeader THEN BEGIN
    ZeichenBreite := Canvas.TextWidth('x');
    T := Items.Strings[Index];
    R.Top := ARect.Top; R.Bottom := ARect.Bottom;
    TabRechts := B;

    FOR I:=0 TO FHeader.Sections.Count-1 DO BEGIN

      {Tab-Positionen in Pixel ermittlen}
      TabLinks := TabRechts + 2; IF FCheckBoxes THEN TabLinks := TabLinks+2;
      TabRechts := TabRechts + FHeader.Sections[I].Width;
      IF I=0 THEN TabRechts := TabRechts - B - 3; {verschobenen FHeader ausgleichen (3 Pixel)}

      {Teilstring ermitteln}
      Position := Pos(#9, T);
      if Position > 0 THEN BEGIN
        Teil := copy(T, 1, Position-1);
        T := copy(T, Position+1, length(T) - Position);
      END
      ELSE BEGIN
        Teil := T;
        T := '';
      END;

      {Teilstring ausgeben}
      GetTextMetrics(Canvas.Handle, TM); {fr Ermittlung des berhanges bei kursiver Schrift}
      Breite := Canvas.TextWidth(Teil) + TM.tmOverhang;
      IF Breite < (TabRechts-2-TabLinks) THEN BEGIN
        CASE FHeader.Sections[I].Alignment OF
        taLeftJustify: R.Left := TabLinks;
        taRightJustify: R.Left := TabRechts-Breite-2;
        taCenter: R.Left := TabLinks + (TabRechts-2-Breite-TabLinks)DIV 2;
        END;
        R.Right := TabRechts-2;
        Canvas.TextRect(R, R.Left, YPos, Teil);
      END
      ELSE BEGIN
        R.Left := TabLinks;
        R.Right := TabRechts-2-3*ZeichenBreite;
        IF R.Right > R.Left THEN Canvas.TextRect(R, R.Left, YPos, Teil);
        R.Left := R.Right+2;
        R.Right := TabRechts-2;
        IF R.Left > TabLinks THEN Canvas.TextRect(R, R.Left, YPos, '...');
      END;

      {Tabellenlinien ausgeben}
      IF FLineByTabStops THEN BEGIN
        Canvas.MoveTo(TabRechts, ARect.Top);
        IF Index = Items.Count-1
          THEN Canvas.LineTo(TabRechts, Height)
          ELSE Canvas.LineTo(TabRechts, ARect.Bottom);
      END;
    END;
  END  {IF FShowHeader ...}
  ELSE BEGIN
    GetTextMetrics(Canvas.Handle, TM); {fr Ermittlung des berhanges bei kursiver Schrift}
    Breite := Canvas.TextWidth(Items.Strings[Index]) + TM.tmOverhang;
    R.Top := ARect.Top; R.Bottom := ARect.Bottom; R.Left := B+2; R.Right := ARect.Right;
    CASE FAlignment OF
    taLeftJustify: IF FCheckBoxes THEN R.Left := R.Left+2;
    taRightJustify: R.Left := R.Right-Breite-2;
    taCenter: R.Left := R.Left + (R.Right-2-Breite-R.Left)DIV 2;
    END;
    Canvas.TextRect(R, R.Left, YPos, Items.Strings[Index]);
  END; {IF FShowHeader ...}
  Canvas.Brush.Style := bsSolid;

{*********** Checkbox malen **********************************}
  with Canvas do begin
    IF FCheckBoxes THEN BEGIN
      BoxRect := Rect(ARect.Left+2, ARect.Top + (ARect.Bottom-ARect.Top-B) DIV 2,
                      ARect.Left+B+2, ARect.Top + (ARect.Bottom-ARect.Top-B) DIV 2 + B);
      Brush.Color := clWindow;
      CASE FCheckBoxStyle OF
      pcbsSunken: DrawEdge(Handle, BoxRect, EDGE_SUNKEN, BF_RECT);
      pcbsRaised: DrawEdge(Handle, BoxRect, EDGE_RAISED, BF_RECT);
      pcbsBump: DrawEdge(Handle, BoxRect, EDGE_BUMP, BF_RECT);
      pcbsEtched: DrawEdge(Handle, BoxRect, EDGE_ETCHED, BF_RECT);
      END;
      IF Items.Checked[Index] THEN BEGIN
        IF Items.Enabled[Index] AND Enabled
          THEN Pen.Color := FHookColor
          ELSE Pen.Color := clGrayText;
        Brush.Color := Pen.Color; {fr phsFill}
        Pen.Width := 1;
        CASE FHookStyle OF
        phsHook:      FOR I:=0 TO 2 DO BEGIN
                      MoveTo(BoxRect.Left + 3,         BoxRect.Top - I + 7);
                      LineTo(BoxRect.Left + B DIV 2-1, BoxRect.Top - I + (B DIV 2) + 3);
                      LineTo(BoxRect.Right - 3,        BoxRect.Top - I + 4);
                      END;
        phsCross:     FOR I:=0 TO 0 DO BEGIN
                      MoveTo(BoxRect.Left + 3,     BoxRect.Top - I + 3);
                      LineTo(BoxRect.Left + B - 3, BoxRect.Top - I + B - 3);
                      MoveTo(BoxRect.Left + 3,     BoxRect.Top - I + B - 4);
                      LineTo(BoxRect.Left + B - 3, BoxRect.Top - I + 2);
                      END;
        phsFill:      FillRect(Rect(BoxRect.Left + 2, BoxRect.Top + 2, BoxRect.Right - 2, BoxRect.Bottom - 2));
        END; {CASE FHookStyle ...}
      END;
    END;
  END;
end;

function TPieList.GetCheckBoxSize: Integer;
begin
  Result := 0;
  IF FCheckBoxes THEN CASE FCheckBoxSize OF {Breite der Box}
    pcbsSmall:   Result := 11;
    pcbsNormal:  Result := 13;
    pcbsLarge:   Result := 15;
    pcbsLargest: Result := 17;
    ELSE Result := 13;
  END;
end;

procedure TPieList.MouseMove(Shift: TShiftState; X, Y: Integer);
begin
  inherited MouseMove(Shift, X, Y);
  IF ItematPos(Point(X, Y), True) > -1 THEN BEGIN
    IF HelpContext <> Items.HelpContexts[ItematPos(Point(X, Y), True)] THEN
      HelpContext := Items.HelpContexts[ItematPos(Point(X, Y), True)];
    IF Hint <> Items.Hints[ItematPos(Point(X, Y), True)] THEN BEGIN
      Hint := Items.Hints[ItematPos(Point(X, Y), True)];
      {Mauszeiger auf Eltern simulieren --> damit wird der Hint wieder aktualisiert}
      SendMessage(Parent.Handle, wm_MouseMove, 0, 0);
      SendMessage(Parent.Handle, wm_MouseMove, 0, X + (Y SHL 16));
    END;
  END;
end;

procedure TPieList.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
VAR
  Index, B: Integer;
begin
  IF (Button = mbRight) AND assigned(FOnPopup) THEN FOnPopup(Self, Point(X, Y), pssMouse);
  IF (Button = mbLeft) AND FCheckBoxes THEN BEGIN
    Index := ItemAtPos(Point(X, Y), TRUE);
    B := GetCheckBoxSize;
    IF (Index >= 0) AND (X > 2) AND (X < B+2) AND
       (Items.Enabled[Index] OR FAllowCheckDisabledItems) THEN
      Items.Checked[Index] := NOT Items.Checked[Index];
  END;
  inherited;
  Invalidate;
end;

procedure TPieList.SetHorzScrollBar(Value: Boolean);
begin
  if Value <> FHorzScrollBar then
  begin
    FHorzScrollBar := Value;
    ShowScrollBar(Handle, sb_Horz, FHorzScrollBar);
  end;
end;

procedure TPieList.SetItems(Value: TPieListStrings);
begin
  Items.Assign(Value);
end;

procedure TPieList.SetAlignment(Value: TAlignment);
begin
  IF Value <> FAlignment THEN BEGIN
    FAlignment := Value;
    IF NOT FShowHeader THEN Invalidate;
  END;
end;

procedure TPieList.SetAnyColors(Value: Boolean);
begin
  IF Value <> FAnyColors THEN BEGIN
    FAnyColors := Value;
    Repaint;
  END;
end;

procedure TPieList.SetSorted(Value: Boolean);
BEGIN
  IF Value <> FSorted THEN BEGIN
    FSorted := Value;
    IF FShowHeader THEN FHeader.Repaint;
    IF FSorted THEN SortList;
  END;
END;

procedure TPieList.SetAnyFonts(Value: Boolean);
begin
  IF Value <> FAnyFonts THEN BEGIN
    FAnyFonts := Value;
    {Es kann sich die Hhe der Eintrge ndern}
    CalculateItemHeight;
    Repaint;
  END;
end;

procedure TPieList.SetCheckBoxSize(Value: TPieCheckBoxSize);
BEGIN
  IF Value <> FCheckBoxSize THEN BEGIN
    FCheckBoxSize := Value;
    IF FCheckBoxes THEN Invalidate;
  END;
END;

procedure TPieList.SetCheckBoxStyle(Value: TPieCheckBoxStyle);
BEGIN
  IF Value <> FCheckBoxStyle THEN BEGIN
    FCheckBoxStyle := Value;
    IF FCheckBoxes THEN Invalidate;
  END;
END;

procedure TPieList.SetHookStyle(Value: TPieHookStyle);
BEGIN
  IF Value <> FHookStyle THEN BEGIN
    FHookStyle := Value;
    IF FCheckBoxes THEN Invalidate;
  END;
END;

procedure TPieList.SetHookColor(Value: TColor);
BEGIN
  IF Value <> FHookColor THEN BEGIN
    FHookColor := Value;
    IF FCheckBoxes THEN Invalidate;
  END;
END;

procedure TPieList.SetCheckBoxes(Value: Boolean);
BEGIN
  IF Value <> FCheckBoxes THEN BEGIN
    FCheckBoxes := Value;
    Invalidate;
  END;
END;
{******************************************************}
{******************************************************}
{******************************************************}
procedure TPieItemsfenster.Prop_zeigen;
begin
  Zeile := Liste.ItemIndex;

  Zeilenlabel2.Caption := IntToStr(Zeile);
  Gesamtzeilenlabel2.Caption := IntToStr(Liste.Items.Count);

  IF Zeile > -1 THEN BEGIN
    TRY
      IF Assigned(Liste.Items.Bitmaps[Zeile]) AND NOT(Liste.Items.Bitmaps[Zeile].Empty)
        THEN BitmapVorschau.Picture.Assign(Liste.Items.Bitmaps[Zeile])
        ELSE BitmapVorschau.Picture.Assign(NIL);
      ColorShape.Brush.Color := Liste.Items.Colors[Zeile];
      Edit.Color := Liste.Items.Colors[Zeile];
      IF Assigned(Liste.Items.Fonts[Zeile]) THEN BEGIN
        FontBtn.Font := Liste.Items.Fonts[Zeile];
        Edit.Font := Liste.Items.Fonts[Zeile];
      END
      ELSE BEGIN
        FontBtn.ParentFont := TRUE;
        Edit.ParentFont := TRUE;
      END;
      Edit.Font.Height := -11;
      HelpContext.Text := IntToStr(Liste.Items.HelpContexts[Zeile]);
    EXCEPT
      ON EAccessViolation DO;
    END;
  END;
end;

procedure TPieItemsfenster.ListeClick(Sender: TObject);
begin
  Edit.Text := Liste.Items.Strings[Liste.ItemIndex];
  Prop_zeigen;
end;

procedure TPieItemsfenster.ListeMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  IF (Button = mbLeft) THEN WITH Liste DO BEGIN
    IF (ItematPos(Point(X,Y), TRUE) >= 0) AND
       (ItematPos(Point(X,Y), TRUE) < Items.Count) THEN BEGIN
      Zieh_Item := ItematPos(Point(X,Y), TRUE);
      BeginDrag(FALSE);
    END;
  END;
end;

procedure TPieItemsfenster.ListeDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := ((Source = Liste) AND   {Befehl verschieben}
             (Liste.ItemAtPos(Point(X,Y), TRUE) >= 0) AND
             (Liste.ItemAtPos(Point(X,Y), TRUE) <> Zieh_Item)
            );
end;

procedure TPieItemsfenster.ListeDragDrop(Sender, Source: TObject; X, Y: Integer);
VAR
  Dropposition: Integer;
begin
  IF (Source = Liste) THEN BEGIN
    Dropposition := Liste.ItemAtPos(Point(X,Y), TRUE);
    Liste.Items.Move(Dropposition, Zieh_Item);
  END;
end;

procedure TPieItemsfenster.InsertBtnClick(Sender: TObject);
CONST
  CRLF = #$0D+#$0A;
VAR
  S: string;
  I: Integer;
begin
  S := Edit.Text;
  IF (length(S) > 1) AND (copy(S, length(S)-2, 2) = CRLF) THEN
    S := copy(S, length(S)-2, 2);
  I := Liste.ItemIndex;
  IF I<0 THEN I:=0;
  Liste.Items.Insert(I, S);
  Prop_zeigen;
end;

procedure TPieItemsfenster.DeleteBtnClick(Sender: TObject);
begin
  IF Liste.ItemIndex >= 0 THEN BEGIN
    Liste.Items.Delete(Liste.ItemIndex);
    Prop_zeigen;
  END;  
end;

procedure TPieItemsfenster.ChangeBtnClick(Sender: TObject);
CONST
  CRLF = #$0D+#$0A;
VAR
  S: string;
begin
  S := Edit.Text;
  IF (length(S) > 1) AND (copy(S, length(S)-2, 2) = CRLF) THEN
    S := copy(S, length(S)-2, 2);
  Liste.Items.Strings[Liste.ItemIndex] := S;
  Prop_zeigen;
end;

procedure TPieItemsfenster.ColorBtnClick(Sender: TObject);
begin
  ColorDialog.Color := Liste.Items.Colors[Zeile];
  IF ColorDialog.Execute THEN BEGIN
    Liste.Items.Colors[Zeile] := ColorDialog.Color;
    Liste.Repaint;
    Prop_zeigen;
  END;
end;

procedure TPieItemsfenster.FormShow(Sender: TObject);
begin
  CASE Liste.SelectedStyle OF
  psStandard   : CBStyle.ItemIndex := 0;
  psBoldText   : CBStyle.ItemIndex := 1;
  psOwnerDraw  : CBStyle.ItemIndex := 2;
  END;
  CASE Liste.ItemHeightStyle OF
  ihFix        : IHStyle.ItemIndex := 0;
  ihFont       : IHStyle.ItemIndex := 1;
  ihBitmap     : IHStyle.ItemIndex := 2;
  ihFontBitmap : IHStyle.ItemIndex := 3;
  END;
  CASE Liste.BitmapStyle OF
  bsLeft       : BStyle.ItemIndex := 0;
  bsRight      : BStyle.ItemIndex := 1;
  bsCenter     : BStyle.ItemIndex := 2;
  bsStretch    : BStyle.ItemIndex := 3;
  bsPattern    : BStyle.ItemIndex := 4;
  END;
  CASE Liste.BackGroundStyle OF
  bgsNone      : BGStyle.ItemIndex := 0;
  bgsCenter    : BGStyle.ItemIndex := 1;
  bgsStretch   : BGStyle.ItemIndex := 2;
  bgsPattern   : BGStyle.ItemIndex := 3;
  END;
  UT.Checked := Liste.ShowHeader;
  UTClick(UT);
  LBTS.Checked := Liste.LineByTabStops;
  HESB.Position := Liste.HorzExtent;
  HS.Checked := Liste.HorzScrollbar;
  HSGroup.ItemIndex := Integer(Liste.FHeader.Style);
  CheckBoxes.Checked := Liste.CheckBoxes;
  Sorted.Checked := Liste.Sorted;
  AnyColors.Checked := Liste.AnyColors;
  AnyFonts.Checked := Liste.AnyFonts;
  MS.Checked := Liste.MultiSelect;
  Edit.Clear;
  Liste.ItemIndex := Liste.Items.Count-1;
  IF Liste.ItemIndex > -1 THEN BEGIN
    Edit.Text := Liste.Items.Strings[Liste.ItemIndex];
    Prop_zeigen;
  END;
end;

procedure TPieItemsfenster.EditEnter(Sender: TObject);
begin
  Edit.SelectAll;
end;

procedure TPieItemsfenster.EditChange(Sender: TObject);
begin
  Prop_zeigen;
end;

procedure TPieItemsfenster.FontBtnClick(Sender: TObject);
begin
  FontDialog.Font := FontBtn.Font;
  IF FontDialog.Execute THEN BEGIN
    Liste.Items.Fonts[Zeile] := FontDialog.Font;
    Liste.Repaint;
    Prop_zeigen;
  END;
end;

procedure TPieItemsfenster.HintBtnClick(Sender: TObject);
begin
  HintDialog.Zeilentext := Liste.Items.Hints[Zeile];
  IF HintDialog.Execute THEN BEGIN
    Liste.Items.Hints[Zeile] := HintDialog.Zeilentext;
  END;
end;

procedure TPieItemsfenster.LoeschBtnClick(Sender: TObject);
begin
  Liste.Clear;
end;

procedure TPieItemsfenster.CBStyleClick(Sender: TObject);
begin
  CASE CBStyle.ItemIndex OF
  0: Liste.SelectedStyle := psStandard;
  1: Liste.SelectedStyle := psBoldText;
  2: Liste.SelectedStyle := psOwnerDraw;
  END;
end;

procedure TPieItemsfenster.UTClick(Sender: TObject);
begin
  Liste.ShowHeader := UT.Checked;
  HSGroup.Enabled := UT.Checked;
  LBTS.Enabled := UT.Checked;
  HFButton.Enabled := UT.Checked;
end;

procedure TPieItemsfenster.HESBChange(Sender: TObject);
begin
  Liste.HorzExtent := HESB.Position;
end;

procedure TPieItemsfenster.HSClick(Sender: TObject);
begin
  Liste.HorzScrollbar := HS.Checked;
  HESB.Enabled := HS.Checked;
end;

procedure TPieItemsfenster.AnyColorsClick(Sender: TObject);
begin
  Liste.AnyColors := AnyColors.Checked;
end;

procedure TPieItemsfenster.AnyFontsClick(Sender: TObject);
begin
  Liste.AnyFonts := AnyFonts.Checked;
end;

procedure TPieItemsfenster.MSClick(Sender: TObject);
begin
  Liste.MultiSelect := MS.Checked;
end;

procedure TPieItemsfenster.FormCreate(Sender: TObject);
begin
  Liste := TPieList.Create(Self);
  Liste.Parent := ListenPanel;
  Liste.FPanel.Align := alTop;
  Liste.Align := alClient;
  Liste.OnClick := ListeClick;
  Liste.OnMouseDown := ListeMouseDown;
  Liste.OnDragOver := ListeDragOver;
  Liste.OnDragDrop := ListeDragDrop;
end;

procedure TPieItemsfenster.FormDestroy(Sender: TObject);
begin
  Liste.Free;
end;

procedure TPieItemsfenster.BitmapBtnClick(Sender: TObject);
VAR
  B: TBitmap;
begin
  IF OpenPicDialog.Execute AND FileExists(OpenPicDialog.FileName) THEN BEGIN
    B := TBitmap.Create;
    TRY
      B.LoadFromFile(OpenPicDialog.FileName);
      Liste.Items.Bitmaps[Zeile] := B;
    FINALLY
      B.Destroy;
    END;
    Liste.Repaint;
    Prop_zeigen;
  END;
end;

procedure TPieItemsfenster.IHStyleClick(Sender: TObject);
begin
  CASE IHStyle.ItemIndex OF
  0: Liste.ItemHeightStyle := ihFix;
  1: Liste.ItemHeightStyle := ihFont;
  2: Liste.ItemHeightStyle := ihBitmap;
  3: Liste.ItemHeightStyle := ihFontBitmap;
  END;
end;

procedure TPieItemsfenster.BStyleClick(Sender: TObject);
begin
  CASE BStyle.ItemIndex OF
  0: Liste.BitmapStyle := bsLeft;
  1: Liste.BitmapStyle := bsRight;
  2: Liste.BitmapStyle := bsCenter;
  3: Liste.BitmapStyle := bsStretch;
  4: Liste.BitmapStyle := bsPattern;
  END;
end;

procedure TPieItemsfenster.BitmapDeleteBtn1Click(Sender: TObject);
VAR
  B: TBitmap;
begin
  B := TBitmap.Create;
  TRY
    Liste.Items.Bitmaps[Zeile] := B;
  FINALLY
    B.Destroy;
  END;
  Liste.Repaint;
  Prop_zeigen;
end;

procedure TPieItemsfenster.BGButtonClick(Sender: TObject);
begin
  IF OpenPicDialog.Execute THEN
    Liste.BackGround.LoadFromFile(OpenPicDialog.FileName);
end;

procedure TPieItemsfenster.BGStyleClick(Sender: TObject);
begin
  CASE BGStyle.ItemIndex OF
  0: Liste.BackGroundStyle := bgsNone;
  1: Liste.BackGroundStyle := bgsCenter;
  2: Liste.BackGroundStyle := bgsStretch;
  3: Liste.BackGroundStyle := bgsPattern;
  END;
end;

procedure TPieItemsfenster.LBTSClick(Sender: TObject);
begin
  Liste.LineByTabStops := LBTS.Checked;
end;

procedure TPieItemsfenster.HSGroupClick(Sender: TObject);
begin
  Liste.HeaderStyle := THeaderStyle(HSGroup.ItemIndex);
end;

procedure TPieItemsfenster.HFButtonClick(Sender: TObject);
begin
  FontDialog.Font := Liste.HeaderFont;
  IF FontDialog.Execute THEN
    Liste.HeaderFont := FontDialog.Font;
end;

procedure TPieItemsfenster.CheckBoxesClick(Sender: TObject);
begin
  Liste.CheckBoxes := CheckBoxes.Checked;
end;

procedure TPieItemsfenster.SortedClick(Sender: TObject);
begin
  Liste.Sorted := Sorted.Checked;
end;

procedure TPieItemsfenster.HelpContextExit(Sender: TObject);
VAR
  S: string;
begin
  S := Trim(HelpContext.Text);
  IF S = '' THEN S := '0';
  IF Zeile >= 0 THEN Liste.Items.HelpContexts[Zeile] := StrToInt(S);
end;

procedure TPieItemsfenster.HelpContextChange(Sender: TObject);
VAR
  Z: Integer;
  S: String;
begin
  S := Trim(HelpContext.Text);
  IF S = '' THEN exit;
  try
    Z := StrToInt(S);
    HelpContext.Tag := Z;
  except
    on EConvertError do ShowMessage('Please edit a number. Invalid input!');
  end;
end;

end.
