{$I PIETOOLS.INC}
{ Autor: Ingolf Pietschmann.
  Dieser Quelltext ist Freeware. Die Verwendung und Weitergabe dieser Sourcen zu
  privaten nicht kommerziellen Zwecken ist ausdrcklich erwnscht.
  Die Verwendung zu kommerziellen Zwecken ist nur mit Erlaubnis des Autors
  gestattet. Den Autor knnen Sie unter "Support@Pie-Tools.de" erreichen.

  These sources are freeware. The usage and distribution of these sources for
  private, not commercial purposes is explicit desired.
  The usage for commercial purposes is only permitted in agreement of the author.
  The author can be reached by "Support@Pie-Tools.de".
}
unit PieImage;

interface

uses
  {$IFDEF WIN32}
  Windows,
  {$ELSE}
  WinTypes,
  WinProcs,
  {$ENDIF}
  Classes,
  Controls,
  Graphics,
  Menus,
  ExtCtrls,
  StdCtrls,
  Forms,
  Messages;

CONST
  Max_Zeilen = 100;
type
  TPieImageTyp = (btNormal,
                 btCenter,
                 btOptimal,
                 btCenterOptimal,
                 btPattern,
                 btPatternOptimal,
                 btPatternStretch,
                 btStretch);

  { TPieImage : Bild-Komponente }
  TPieImage = class(TGraphicControl)
  private
    FPicture: TPicture;
    FDateiname: string;
    FBildTyp: TPieImageTyp;
    FRahmen: Boolean;
    FRahmenfarbe: TColor;
    FRahmenstaerke: Word;
    procedure SetDateiname(Value: string);
    procedure SetBildTyp(Value: TPieImageTyp);
    procedure SetPicture(Value: TPicture);
    procedure SetRahmen(Value: Boolean);
    procedure SetRahmenfarbe(Value: TColor);
    procedure SetRahmenstaerke(Value: Word);
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Align;
    property Filename: string read FDateiname write SetDateiname;
    property ImageType: TPieImageTyp read FBildTyp write SetBildTyp default btNormal;
    property Picture: TPicture read FPicture write SetPicture;
    property Frame: Boolean read FRahmen write SetRahmen default TRUE;
    property FrameColor: TColor read FRahmenfarbe write SetRahmenfarbe default clWindowText;
    property FrameWidth: Word read FRahmenstaerke write SetRahmenstaerke default 2;
    property DragCursor;
    property DragMode;
    property Enabled;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

  { TPieScrollText : Durchsichtige PaintBox-Komponente mit scrollendem Text}
  TPieScrollText = class(TPaintBox)
  private
    FIntervall:Integer;
    FStrList:TStringList;
    FScrollPixelX: Integer;
    FScrollPixelY: Integer;
    FStart: Boolean;
    FTransparenz: Boolean;
    FZeilenabstand: Word;
    ScrollBreite: Integer;
    ScrollHoehe : Integer;
    Max_Breite: Integer;
    Timer: TTimer;
    procedure TimerScroll(Sender: TObject);
    procedure StrListChange(Sender: TObject);
    procedure Initialisiere;
    PROCEDURE Ausgeben(H: Integer; T: string);
    function GetList:TStrings;
    PROCEDURE SetIntervall(Value: Integer);
    PROCEDURE SetList(Value: TStrings);
    PROCEDURE SetScrollPixelX(Value: Integer);
    PROCEDURE SetScrollPixelY(Value: Integer);
    PROCEDURE SetStart(Value: Boolean);
    PROCEDURE SetTransparenz(Value: Boolean);
    PROCEDURE SetZeilenabstand(Value: Word);
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Interval: Integer read FIntervall write SetIntervall default 100;
    property Items: TStrings read GetList write SetList;
    property ScrollPixelX: Integer read FScrollPixelX write SetScrollPixelX default -1;
    property ScrollPixelY: Integer read FScrollPixelY write SetScrollPixelY default 0;
    property Start: Boolean read FStart write SetStart default FALSE;
    property Transparent: Boolean read FTransparenz write SetTransparenz default FALSE;
    property LineSpacing: Word read FZeilenabstand write SetZeilenabstand default 20;
  end;





(*procedure Register;*)

implementation

uses
  Dialogs, SysUtils;

{ TPieImage }

procedure TPieImage.SetPicture(Value: TPicture);
begin
  FPicture.Assign(Value);
  FDateiname := '';
  Invalidate;
end;

procedure TPieImage.SetDateiname(Value: string);
begin
  if FileExists(Value) then begin
    if Value <> FDateiname then begin
      FDateiname := Value;
      IF UpperCase(ExtractFileExt(FDateiname)) = '.PIE' THEN BEGIN
        {Versteckte BMP-Datei --> Umbenennen}
        RenameFile(FDateiname, ChangeFileExt(FDateiname, '.BMP'));
        TRY
          {Umbenannte Datei laden}
          FPicture.LoadFromFile(ChangeFileExt(FDateiname, '.BMP'));
        FINALLY
          {Versteckte BMP-Datei --> Zurck-Umbenennen}
          RenameFile(ChangeFileExt(FDateiname, '.BMP'), FDateiname);
        END;  
      END
      ELSE FPicture.LoadFromFile(FDateiname);
      Invalidate;
    END;
  end
  ELSE BEGIN
    IF Value = '' THEN BEGIN
      FDateiname := '';
      FPicture.Assign(NIL);
      Invalidate;
    END
    ELSE MessageDlg('Bild nicht gefunden!', mtError, [mbOk], 0);
  END;
end;

procedure TPieImage.SetBildTyp(Value: TPieImageTyp);
begin
  if Value <> FBildTyp then begin
    FBildTyp := Value;
    Invalidate;
  END;
end;

procedure TPieImage.SetRahmen(Value: Boolean);
begin
  if Value <> FRahmen then begin
    FRahmen := Value;
    Invalidate;
  END;
end;

procedure TPieImage.SetRahmenfarbe(Value: TColor);
begin
  if Value <> FRahmenfarbe then begin
    FRahmenfarbe := Value;
    Invalidate;
  END;
end;

procedure TPieImage.SetRahmenstaerke(Value: Word);
VAR
  V: Word;
begin
  V := Value;
  IF (V > Width DIV 2) THEN V := Width DIV 2;
  IF (V > Height DIV 2) THEN V := Height DIV 2;
  IF (V < 1) THEN V := 1;
  if V <> FRahmenstaerke then begin
    FRahmenstaerke := V;
    Invalidate;
  END;
end;

procedure TPieImage.Paint;
var
  Rect  : TRect;
  Anz   : TPoint;
  X, Y  : Word;
  kgVx  : Double;
  kgVy  : Double;
  R     : TRect;
  Delta : Integer;
  A, B  : Word;
  I     : Integer;
begin
  Rect := GetClientRect;
  with Canvas do begin
    IF FRahmen THEN BEGIN
      inc(Rect.Left,   FRahmenstaerke-1);
      inc(Rect.Top,    FRahmenstaerke-1);
      dec(Rect.Right,  FRahmenstaerke-1);
      dec(Rect.Bottom, FRahmenstaerke-1);
    END;
    {Bild zeichnen}
    IF NOT(FPicture.Graphic=NIL) AND
       NOT(FPicture.Graphic.Empty) THEN
       CASE FBildTyp OF
    btNormal: Draw(Rect.Left,Rect.Top,FPicture.Graphic);
    btCenter: Draw((Width-FPicture.Graphic.Width) DIV 2,
                   (Height-FPicture.Graphic.Height) DIV 2,
                   FPicture.Graphic);
    btStretch: StretchDraw(Rect,FPicture.Graphic);
    btOptimal: BEGIN
               {kgV ermitteln (kleinstes gemeinsames Vielfaches)}
               kgVx := (Rect.Right-Rect.Left) / FPicture.Graphic.Width;
               kgVy := (Rect.Bottom-Rect.Top) / FPicture.Graphic.Height;
               {Bild zeichnen}
               IF kgVx < kgVy THEN Rect.Bottom := round(kgVx * FPicture.Graphic.Height)
                              ELSE Rect.Right  := round(kgVy * FPicture.Graphic.Width);
               StretchDraw(Rect,FPicture.Graphic);
               END;
    btCenterOptimal: BEGIN
               {kgV ermitteln (kleinstes gemeinsames Vielfaches)}
               kgVx := (Rect.Right-Rect.Left) / FPicture.Graphic.Width;
               kgVy := (Rect.Bottom-Rect.Top) / FPicture.Graphic.Height;
               {Bild zeichnen}
               R := Rect;
               IF kgVx < kgVy THEN BEGIN  {Zoom = kgVx}
                 R.Bottom := round(kgVx * FPicture.Graphic.Height);
                 Delta := (Rect.Bottom-Rect.Top) - (R.Bottom-R.Top);
                 R.Top := R.Top + Delta DIV 2;
                 R.Bottom := R.Bottom + Delta DIV 2;
               END
               ELSE BEGIN   {Zoom = kgVy}
                 R.Right  := round(kgVy * FPicture.Graphic.Width);
                 Delta := (Rect.Right-Rect.Left) - (R.Right-R.Left);
                 R.Left := R.Left + Delta DIV 2;
                 R.Right := R.Right + Delta DIV 2;
               END;
               StretchDraw(R,FPicture.Graphic);
               END;
    btPatternOptimal: BEGIN
               {kgV ermitteln (kleinstes gemeinsames Vielfaches)}
               kgVx := (Rect.Right-Rect.Left) / FPicture.Graphic.Width;
               kgVy := (Rect.Bottom-Rect.Top) / FPicture.Graphic.Height;
               {Bild zeichnen}
               IF kgVx < kgVy THEN BEGIN {Zoom = kgVx}
                 Delta := (Rect.Bottom - Rect.Top) - round(trunc(kgVy / kgVx) * kgVx * FPicture.Graphic.Height);
                 FOR I:=1 TO trunc(kgVy / kgVx) DO BEGIN
                   R := Rect;
                   R.Bottom := I * round(kgVx * FPicture.Graphic.Height) + Delta DIV 2;
                   R.Top := R.Bottom - round(kgVx * FPicture.Graphic.Height);
                   StretchDraw(R,FPicture.Graphic);
                 END;
               END
               ELSE BEGIN  {Zoom = kgVy}
                 Delta := (Rect.Right - Rect.Left) - round(trunc(kgVx / kgVy) * kgVy * FPicture.Graphic.Width);
                 FOR I:=1 TO trunc(kgVx / kgVy) DO BEGIN
                   R := Rect;
                   R.Right := I * round(kgVy * FPicture.Graphic.Width) + Delta DIV 2;
                   R.Left := R.Right - round(kgVy * FPicture.Graphic.Width);
                   StretchDraw(R,FPicture.Graphic);
                 END;
               END;
               END;
    btPatternStretch: BEGIN
               {kgV ermitteln (kleinstes gemeinsames Vielfaches)}
               kgVx := (Rect.Right-Rect.Left) / FPicture.Graphic.Width;
               kgVy := (Rect.Bottom-Rect.Top) / FPicture.Graphic.Height;
               {Bild zeichnen}
               IF kgVx < kgVy THEN BEGIN {Zoom = kgVx}
                 FOR I:=0 TO trunc(kgVy / kgVx) DO BEGIN
                   R := Rect;
                   R.Top := I * round(kgVx * FPicture.Graphic.Height);
                   R.Bottom := (I+1) * round(kgVx * FPicture.Graphic.Height);
                   StretchDraw(R,FPicture.Graphic);
                 END;
               END
               ELSE BEGIN  {Zoom = kgVy}
                 FOR I:=0 TO trunc(kgVx / kgVy) DO BEGIN
                   R := Rect;
                   R.Left := I * round(kgVy * FPicture.Graphic.Width);
                   R.Right := (I+1) * round(kgVy * FPicture.Graphic.Width);
                   StretchDraw(R,FPicture.Graphic);
                 END;
               END;
               END;
    btPattern: BEGIN
               {Anzahl der Bilder in der Breite & Hhe ermitteln}
               Anz := Point((Rect.Right-Rect.Left) DIV FPicture.Graphic.Width + 1,
                            (Rect.Bottom-Rect.Top) DIV FPicture.Graphic.Height + 1);
               {Bilder zeichnen}
               FOR X:=1 TO Anz.X DO FOR Y:=1 TO Anz.Y DO
                 Draw((X-1)*FPicture.Graphic.Width+Rect.Left,
                      (Y-1)*FPicture.Graphic.Height+Rect.Top,
                      FPicture.Graphic);
               END;
    END;
    IF FRahmen AND (FRahmenstaerke > 0) THEN BEGIN
      {Rahmen zeichnen}
      Pen.Color := FRahmenfarbe;
      Pen.Width := FRahmenstaerke;
      A := FRahmenstaerke DIV 2;
      IF abs(FRahmenstaerke / 2 - FRahmenstaerke DIV 2) < 1e-5
        THEN B := A ELSE B := A+1;
      MoveTo(A,A);
      LineTo(Width-B, A);
      LineTo(Width-B, Height-B);
      LineTo(A, Height-B);
      LineTo(A, A);
      Pen.Color := clWindowText;
      Pen.Width := 1;
    END;
  end;  {WITH Canvas DO ...}
end;

constructor TPieImage.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width := 30;
  Height := 30;
  FDateiname := '';
  FPicture := TPicture.Create;
  FBildTyp := btNormal;
  FRahmen := TRUE;
  FRahmenfarbe := clWindowText;
  FRahmenstaerke := 1;
end;

destructor TPieImage.Destroy;
begin
  FPicture.Free;
  inherited Destroy;
end;




{TPieScrollText}
constructor TPieScrollText.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Parent := AOwner as TWinControl;
  Font.Color := clWhite;
  Timer := TTimer.Create(Self);
  Timer.Interval := 55;
  Timer.Enabled := FALSE;
  Timer.OnTimer := TimerScroll;
  FStrList:=TStringList.Create;
  FStrList.OnChange := StrListChange;
  FStart := FALSE;
  FTransparenz := FALSE;
  FZeilenabstand := 20;
  FScrollPixelX := -1;
  FScrollPixelY := 0;
  FIntervall := 100;
  Initialisiere;
end;

destructor TPieScrollText.Destroy;
begin
  Timer.Free;
  FStrList.Free;
  inherited Destroy;
end;

function TPieScrollText.GetList:TStrings;
begin
  result:=FStrList;
end;

procedure TPieScrollText.SetList(Value: TStrings);
begin
  FStrlIst.Assign(Value);
  Initialisiere;
end;

procedure TPieScrollText.SetIntervall(Value: Integer);
begin
  IF FIntervall <>  Value THEN BEGIN
    FIntervall := Value;
    Timer.Interval := FIntervall;
  END;
end;

procedure TPieScrollText.SetScrollPixelX(Value: Integer);
begin
  if Value <> FScrollPixelX then begin
    IF abs(Value) < Width THEN BEGIN
      FScrollPixelX := Value;
      Initialisiere;
    END;
  END;
end;

procedure TPieScrollText.SetScrollPixelY(Value: Integer);
begin
  if Value <> FScrollPixelY then begin
    IF abs(Value) < Height THEN BEGIN
      FScrollPixelY := Value;
      Initialisiere;
    END;
  END;
end;

procedure TPieScrollText.SetStart(Value: Boolean);
begin
  if Value <> FStart then begin
    FStart := Value;
    Timer.Enabled := Value;
  END;
end;

procedure TPieScrollText.SetTransparenz(Value: Boolean);
begin
  if Value <> FTransparenz then begin
    FTransparenz := Value;
    Invalidate;
  END;
end;

procedure TPieScrollText.SetZeilenabstand(Value: Word);
begin
  if Value <> FZeilenabstand then begin
    FZeilenabstand := Value;
  END;
end;

procedure TPieScrollText.Initialisiere;
VAR
  Breite, I: Integer;
begin
  Canvas.Font := Font;
  Max_Breite := 1;
  FOR I:=0 TO FStrList.Count-1 DO BEGIN
    Breite := Canvas.TextWidth(FStrList.Strings[I]);
    IF Breite > Max_Breite THEN Max_Breite := Breite;
  END;
  IF FScrollPixelX < 0 THEN ScrollBreite := Width
                       ELSE ScrollBreite := - Max_Breite;
  IF FScrollPixelY < 0 THEN ScrollHoehe := Height
                       ELSE ScrollHoehe := - FStrList.Count*FZeilenabstand;
  IF FScrollPixelX = 0 THEN BEGIN
    ScrollBreite := 0;
    Max_Breite := Width;
  END;
  IF FScrollPixelY = 0 THEN
    ScrollHoehe := (Height - (FStrList.Count * FZeilenabstand)) DIV 2;

  Invalidate;
end;

procedure TPieScrollText.Paint;
VAR
  I: Integer;
begin
  inherited Paint;
    Canvas.Font := Font;
    IF FTransparenz THEN SetBKMode(Canvas.Handle, Windows.TRANSPARENT)
                    ELSE SetBkMode(Canvas.Handle, OPAQUE);
    {Text neu schreiben}
    FOR I:=0 TO FStrList.Count-1 DO BEGIN
        Ausgeben(ScrollHoehe + I*FZeilenabstand, FStrList.Strings[I]);
    END;
end;

PROCEDURE TPieScrollText.Ausgeben(H: Integer; T: string);
VAR
  R: TRect;
  TextBreite, TextHoehe: Integer;
  Rand: Integer;
  MinRand: Integer;
BEGIN
  TextBreite := Canvas.TextWidth(T);
  TextHoehe := Canvas.TextHeight(T);
  Rand := (Width-TextBreite)DIV 2;
  MinRand := (Width-Max_Breite)DIV 2;
  R := Rect(Rand, H, Rand+TextBreite, H+TextHoehe);
{  DrawTextEx(Canvas.Handle, PChar(T), length(T),
             R, DT_Bottom OR DT_Center, Nil);}
  Canvas.TextOut(ScrollBreite + Rand - MinRand, H, T)
END;

procedure TPieScrollText.TimerScroll(Sender: TObject);
begin
  IF FStrList.Count > 0 THEN BEGIN
    ScrollHoehe := Scrollhoehe + FScrollPixelY;
    {wenn aller Text abgelaufen --> dann wieder beginnen}
    IF (FScrollPixelY < 0) THEN BEGIN
      IF ((ScrollHoehe + FStrList.Count*FZeilenabstand) < 0)
         THEN ScrollHoehe := Height;
    END
    ELSE BEGIN
      IF ScrollHoehe > Height
        THEN ScrollHoehe := - FStrList.Count*FZeilenabstand;
    END;

    ScrollBreite := ScrollBreite + FScrollPixelX;
    {wenn aller Text abgelaufen --> dann wieder beginnen}
    IF (FScrollPixelX < 0) THEN BEGIN
      IF ScrollBreite + Max_Breite < 0 THEN ScrollBreite := Width;
    END
    ELSE BEGIN
      IF ScrollBreite > Width THEN ScrollBreite := - Max_Breite;
    END;

    Invalidate;
  END;
end;

procedure TPieScrollText.StrListChange(Sender: TObject);
begin  {Wenn nderungen in der Stringliste vorgenommen werden --> neu berechnen}
  Initialisiere;
end;


{ Register }

(*procedure Register;

begin
  RegisterComponents('Standard', [TPieImage]);
end;*)

end.
