{$I PIETOOLS.INC}
{ Autor: Ingolf Pietschmann.
  Dieser Quelltext ist Freeware. Die Verwendung und Weitergabe dieser Sourcen zu
  privaten nicht kommerziellen Zwecken ist ausdrcklich erwnscht.
  Die Verwendung zu kommerziellen Zwecken ist nur mit Erlaubnis des Autors
  gestattet. Den Autor knnen Sie unter "Support@Pie-Tools.de" erreichen.

  These sources are freeware. The usage and distribution of these sources for
  private, not commercial purposes is explicit desired.
  The usage for commercial purposes is only permitted in agreement of the author.
  The author can be reached by "Support@Pie-Tools.de".
}
UNIT Pieherk;

INTERFACE

USES
  SysUtils, windows
  {$IFDEF WIN32}
  , Math
  {$ENDIF}
  ;

TYPE
  TPieCheckBoxSize = (pcbsSmall, pcbsNormal, pcbsLarge, pcbsLargest);
  TPieCheckBoxStyle = (pcbsSunken, pcbsRaised, pcbsBump, pcbsEtched);
  TPieHookStyle = (phsHook, phsCross, phsFill);

  PROCEDURE Zeit_ermitteln(VAR Datum, Uhrzeit : String);
  FUNCTION Rightpad(Quelle : string; Laenge:  Byte): string;
  FUNCTION Leftpad(Quelle : string; Laenge:  Byte): string;
  FUNCTION NoNull(Quelle : string): string;
  FUNCTION Str_Number(Zahl : LongInt) : string;
  FUNCTION S_N(Zahl : Real; VK, NK: Word): string;
  {$IFDEF WIN32}
  FUNCTION Optimal_S_N(Wert : Double; S: Word) : string;
  {$ENDIF}
  FUNCTION Val_Number(Kette : string) : LongInt;
  FUNCTION V_N(Kette : string): Real;
  FUNCTION PointInRect(P: TPoint; R: TRect): Boolean;

IMPLEMENTATION
USES Dialogs;
{**********************************************************************}
{****************** Zeit_ermitteln ************************************}
{**********************************************************************}
PROCEDURE Zeit_ermitteln(VAR Datum, Uhrzeit : String);
VAR
  Zeit: TDateTime;
BEGIN
  Zeit := Time;
  Datum := DateToStr(Zeit);
  Uhrzeit := TimeToStr(Zeit);
END;
{**********************************************************************}
{****************** Rigthpad ******************************************}
{**********************************************************************}
FUNCTION Rightpad(Quelle : string; Laenge:  Byte): string;
VAR
  Laenge_alt : Integer;
  Anzahl : Integer;
  I : Byte;
  Neu : string;
Begin
  Neu := Quelle;
  Laenge_alt := length(Quelle);
  Anzahl := Laenge - Laenge_alt;
  IF Anzahl > 0 THEN FOR I:=1 TO Anzahl DO Neu := Neu + ' '
  ELSE Neu := copy(Quelle,1,Laenge);
  Rightpad := Neu;
END;
{**********************************************************************}
{****************** Leftpad *******************************************}
{**********************************************************************}
FUNCTION Leftpad(Quelle : string; Laenge:  Byte): string;
VAR
  Laenge_alt : Integer;
  Anzahl : Integer;
  I : Byte;
  Neu : string;
Begin
  Neu := Quelle;
  Laenge_alt := length(Quelle);
  Anzahl := Laenge - Laenge_alt;
  IF Anzahl > 0 THEN FOR I:=1 TO Anzahl DO Neu := ' '+ Neu
  ELSE Neu := copy(Quelle,1,Laenge);
  Leftpad := Neu;
END;
{**********************************************************************}
{****************** NoNull ********************************************}
{**********************************************************************}
FUNCTION NoNull(Quelle : string): string;
VAR
  Anzahl : Integer;
  Zeichen : string[1];
  I : Byte;
  Neu : string;
Begin     {dient zum Entfernen fhrender bzw. hinterer Nullen bei allen Arten von Zahlenstrings}
  Anzahl := length(Quelle);
  I := 1;
  Zeichen := copy(Quelle,1,1);
  WHILE (Zeichen = '0') AND (I <= Anzahl) DO BEGIN
    inc(I);
    Zeichen := copy(Quelle,I,1);
  END;
  Neu := UpperCase(copy(Quelle,I,Anzahl + 1 - I));
  IF (length(Neu) > 0) AND (Neu[1] = '.') THEN Neu := '0' + Neu;
  {hintere Nullen nur entfernen, wenn ein Pkt vorhanden ist und kein E (Exp)!}
  IF (Pos('.', Neu) > 0) AND (Pos('E', Neu) = 0) THEN BEGIN
    Anzahl := length(Neu);
    I := 0;
    Zeichen := copy(Neu,Anzahl-I,1);
    WHILE (Zeichen = '0') AND (I <= Anzahl) DO BEGIN
      inc(I);
      Zeichen := copy(Neu,Anzahl - I,1);
    END;
    Neu := copy(Neu,1,Anzahl - I);
    IF (length(Neu) > 0) AND (Neu[length(Neu)] = '.') THEN Neu := copy(Neu, 1, length(Neu)-1);
  END;
  {Wenn Urzahl: 0 --> 0 restaurieren!}
  IF Neu = '' THEN Neu := '0';
  NoNull := Neu;
END;
{**********************************************************************}
{****************** Str_Number ****************************************}
{**********************************************************************}
FUNCTION Str_Number(Zahl : LongInt) : string;
VAR
  Kette : string;
BEGIN
  Str(Zahl,Kette);
  Str_Number := Kette;
END;
{**********************************************************************}
{****************** S_N ***********************************************}
{**********************************************************************}
FUNCTION S_N(Zahl : Real; VK, NK: Word) : string;
VAR
  Kette : string;
BEGIN
  IF NK=100 THEN BEGIN
    IF VK=100 THEN Str(Zahl, Kette) ELSE Str(Zahl:Vk, Kette);
  END
  ELSE Str(Zahl:VK:NK, Kette);
  S_N := Kette;
END;
{$IFDEF WIN32}
{**********************************************************************}
{****************** Optimal_S_N ***************************************}
{**********************************************************************}
FUNCTION Optimal_S_N(Wert : Double; S: Word) : string;
VAR
  Z : string;
  Stellen: Word;
BEGIN
  Stellen := S;
  IF Wert = 0 THEN Z := '0'
  ELSE IF Wert < 1 THEN Z := S_N(Wert, Stellen, Stellen-1)
  ELSE IF trunc(log10(abs(Wert))) < Stellen-2 THEN
    Z := S_N(Wert, Stellen, Stellen-2-trunc(log10(abs(Wert))))
  ELSE Z := S_N(Wert, Stellen, 0);
  Optimal_S_N := Z;
END;
{$ENDIF}
{**********************************************************************}
{****************** Val_Number ****************************************}
{**********************************************************************}
FUNCTION Val_Number(Kette : string) : LongInt;
VAR
  Code : Integer;
  Zahl : LongInt;
BEGIN
  Val(Kette,Zahl,Code);
  Val_Number := Zahl;
END;
{**********************************************************************}
{****************** V_N ***********************************************}
{**********************************************************************}
FUNCTION V_N(Kette : string): Real;
VAR
  Code : Integer;
  Zahl : Real;
BEGIN
  Val(Kette,Zahl,Code);
  V_N := Zahl;
END;
{****************************************************************************}
(*FUNCTION TstBit(A: Word; Nr: Byte): Boolean;   {Bit Nr in A gesetzt?}
BEGIN
  TstBit := (A AND (1 SHL Nr)) <> 0;
END;
{****************************************************************************}
PROCEDURE SetBit(VAR A: Word; Nr: Byte);       {Bit Nr in A setzen}
BEGIN
  A := A OR (1 SHL Nr);
END;
{****************************************************************************}
PROCEDURE ClrBit(VAR A: Word; Nr: Byte);       {Bit Nr in A rcksetzen}
BEGIN
  A := A AND NOT (1 SHL Nr);
END;
{****************************************************************************}
PROCEDURE InvertBit(VAR A: Word; Nr: Byte);    {Bit Nr in A invertieren}
BEGIN
  A := A XOR (1 SHL Nr);
END;*)
{****************************************************************************}
FUNCTION PointInRect(P: TPoint; R: TRect): Boolean;
BEGIN
  Result := (P.X >= R.Left) AND (P.X <= R.Right) AND
            (P.Y >= R.Top)  AND (P.Y <= R.Bottom);
END;







INITIALIZATION
{  MessageDlg('Used unregistered Pie tools', mtInformation, [mbOk], 0);}
END.
