{$I PIETOOLS.INC}
unit PieGrid;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Dialogs, Buttons, ExtCtrls, StdCtrls,
  Grids, ComCtrls;

type
  TPieGridData = RECORD
                 Alignment : TAlignment;
                 Mark      : Boolean;
                 END;
  TPieStringGrid = class(TStringGrid)
  private
    FAlignment: TAlignment;
    FAlignmentCell: Boolean;
    FMarkColor: TColor;
    FRightClickSelect: Boolean;
    FDataCells: array of array of TPieGridData;
    function GetAlignmentCells(ACol,ARow: integer):TAlignment;
    procedure SetAlignmentCells(ACol,ARow: integer; const Value: TAlignment);
    procedure SetAlignmentCell(Value: Boolean);
    procedure SetAlignment(Value: TAlignment);
    procedure SetMarkColor(Value: TColor);
    function GetMarkCells(ACol,ARow: integer):Boolean;
    procedure SetMarkCells(ACol,ARow: integer; const Value: Boolean);
    procedure MyWriteText(Text: string; Bereich: TRect; AState: TGridDrawState; AAlignment: TAlignment);
    procedure WMRButtonDown(var Info: TWMRButtonDown); message WM_RBUTTONDOWN;
  protected
    procedure DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState); override;
  public
    Constructor Create(AOwner: TComponent); override;
    property AlignmentCells[ACol,ARow:integer]: TAlignment read GetAlignmentCells write SetAlignmentCells;
    property MarkCells[ACol,ARow:integer]: Boolean read GetMarkCells write SetMarkCells;
  published
    property Alignment: TAlignment read FAlignment write SetAlignment;
    property AlignmentCell: Boolean read FAlignmentCell write SetAlignmentCell;
    property RightClickSelect: Boolean read FRightClickSelect write FRightClickSelect;
    property MarkColor: TColor read FMarkColor write SetMarkColor;
  end;

implementation

{PieGrid-Komponente}
constructor TPieStringGrid.Create(AOwner: TComponent);
BEGIN
  inherited Create(AOwner);
  FAlignment := taLeftJustify;
  FAlignmentCell := FALSE;
  FMarkColor := clLime;
  FRightClickSelect := FALSE;
  SetLength(FDataCells, ColCount, RowCount);
END;

procedure TPieStringGrid.SetAlignment(Value: TAlignment);
BEGIN
  IF Value <> FAlignment THEN BEGIN
    FAlignment := Value;
    Invalidate;
  END;
END;

procedure TPieStringGrid.SetMarkColor(Value: TColor);
BEGIN
  IF Value <> FMarkColor THEN BEGIN
    FMarkColor := Value;
    Invalidate;
  END;
END;

procedure TPieStringGrid.SetAlignmentCell(Value: Boolean);
BEGIN
  IF Value <> FAlignmentCell THEN BEGIN
    FAlignmentCell := Value;
    Invalidate;
  END;
END;

function TPieStringGrid.GetMarkCells(ACol,ARow:Integer):Boolean;
begin
  SetLength(FDataCells, ColCount, RowCount);
  Result := FDataCells[ACol, ARow].Mark;
end;

procedure TPieStringGrid.SetMarkCells(ACol,ARow:Integer; const Value:Boolean);
begin
  SetLength(FDataCells, ColCount, RowCount);
  IF FDataCells[ACol, ARow].Mark <> Value THEN BEGIN
    FDataCells[ACol, ARow].Mark := Value;
    Invalidate;
  END;
end;

function TPieStringGrid.GetAlignmentCells(ACol,ARow:Integer):TAlignment;
begin
  SetLength(FDataCells, ColCount, RowCount);
  Result := FDataCells[ACol, ARow].Alignment;
end;

procedure TPieStringGrid.SetAlignmentCells(ACol,ARow:Integer; const Value:TAlignment);
begin
  SetLength(FDataCells, ColCount, RowCount);
  IF FDataCells[ACol, ARow].Alignment <> Value THEN BEGIN
    FDataCells[ACol, ARow].Alignment := Value;
    Invalidate;
  END;
end;

procedure TPieStringGrid.DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState);
begin
  TRY
    IF MarkCells[ACol, ARow] THEN Canvas.Brush.Color := FMarkColor;
    IF FAlignmentCell THEN
      MyWriteText(Cells[ACol, ARow], ARect, AState, AlignmentCells[ACol, ARow])
    ELSE
      MyWriteText(Cells[ACol, ARow], ARect, AState, FAlignment);
  EXCEPT
    inherited DrawCell(ACol, ARow, ARect, AState);
  END;
end;

procedure TPieStringGrid.MyWriteText(Text: string; Bereich: TRect; AState: TGridDrawState; AAlignment: TAlignment);
var FontHeight: Integer;
    R: TRect;
    T: array[0..1000] of Char;
    H, HF: Integer;
begin
  Canvas.FillRect(Bereich);
  FontHeight := Canvas.TextHeight(Text);
  IF FontHeight > 0 THEN BEGIN
    R := Bereich;
    dec(R.Right, 2);
    H := R.Bottom - R.Top;
    HF := (H DIV FontHeight)*FontHeight;
    R.Top := R.Top + (H-HF) DIV 2;
    R.Bottom := R.Top + HF;
    StrPCopy(T, Text);
    CASE AAlignment OF
    taLeftJustify : DrawText(Canvas.Handle, T, -1, R, DT_WORDBREAK OR DT_Left);
    taRightJustify: DrawText(Canvas.Handle, T, -1, R, DT_WORDBREAK OR DT_Right);
    taCenter      : DrawText(Canvas.Handle, T, -1, R, DT_WORDBREAK OR DT_Center);
    END;
  END;
end;

procedure TPieStringGrid.WMRButtonDown(var Info: TWMRButtonDown);
var
  ACol, ARow: Longint;
begin
  MouseToCell(Info.XPos, Info.YPos, ACol, ARow);
  if (FRightClickSelect) and (ARow >= FixedRows) and (ACol >= FixedCols) then
    MarkCells[ACol, ARow] := NOT MarkCells[ACol, ARow];
end;


end.
