{$I PIETOOLS.INC}
{ Autor: Ingolf Pietschmann.
  Dieser Quelltext ist Freeware. Die Verwendung und Weitergabe dieser Sourcen zu
  privaten nicht kommerziellen Zwecken ist ausdrcklich erwnscht.
  Die Verwendung zu kommerziellen Zwecken ist nur mit Erlaubnis des Autors
  gestattet. Den Autor knnen Sie unter "Support@Pie-Tools.de" erreichen.

  These sources are freeware. The usage and distribution of these sources for
  private, not commercial purposes is explicit desired.
  The usage for commercial purposes is only permitted in agreement of the author.
  The author can be reached by "Support@Pie-Tools.de".
}
unit PieEffekt;

interface

uses windows,Classes,Forms,Graphics,SysUtils,Dialogs,Controls,
  StdCtrls, ExtCtrls, Buttons, ExtDlgs, ComCtrls;

type
  TEffectStyle = (esNone, es2ColorsVertical, es2ColorsHorizontal,
                  es2ColorsDiagonal1, es2ColorsDiagonal2,
                  es3ColorsVertical, es3ColorsHorizontal,
                  esPictureStretch, esPictureTile);

  TPieEffect = class(TComponent)
  private
    { Private-Deklarationen }
    FValidComponents : TStringList;
    FValidComponentsOld : TStringList;
    FEffectStyle : TEffectStyle;
    FForm : TForm;
    FBorderWidth : integer;
    FBorderStyle : TBorderStyle;
    FBorderColor : TColor;
    FShadowColor : TColor;
    FShadowWidth : integer;
    FShadow : boolean;
    FEffectHeight : integer;
    FEffectWidth : integer;
    FEffectColor1 : TColor;
    FEffectColor2 : TColor;
    FOldFormPaint: TNotifyEvent;
    FPicture: TPicture;
    FBitmap : TBitmap;
    procedure FillBitmap;
    procedure FormPaint(Sender: TObject);
    procedure ValidComponentsChange(Sender: TObject);
    procedure ValidComponentsChanging(Sender: TObject);
    procedure DrawEffect(Control : TControl);
    PROCEDURE PictureChange(Sender: TObject); dynamic;
    procedure SetBorderColor(value : TColor);
    procedure SetBorderStyle(value : TBorderStyle);
    procedure SetBorderWidth(value : integer);
    procedure SetEffectStyle(value : TEffectStyle);
    procedure SetEffectColor1(value : TColor);
    procedure SetEffectColor2(value : TColor);
    procedure SetEffectWidth(value : integer);
    procedure SetEffectHeight(value : integer);
    PROCEDURE SetPicture(Value: TPicture);
    procedure SetShadow(value : boolean);
    procedure SetShadowColor(value : TColor);
    procedure SetShadowWidth(value : integer);
    procedure SetValidComponents(value : TStringList);
  protected
    procedure Notification(AComponent: TComponent;
      Operation: TOperation); override;
  public
    { Public-Deklarationen }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure PaintEffect;
    procedure Execute;
  published
    property BorderColor : TColor read FBorderColor write SetBorderColor;
    property BorderStyle : TBorderStyle read FBorderStyle write SetBorderStyle;
    property BorderWidth : integer read FBorderWidth write SetBorderWidth;
    property EffectStyle : TEffectStyle read FEffectStyle write SetEffectStyle;
    property EffectWidth : integer read FEffectWidth write SetEffectWidth;
    property EffectHeight : integer read FEffectHeight write SetEffectHeight;
    property EffectColor1 : TColor read FEffectColor1 write SetEffectColor1;
    property EffectColor2 : TColor read FEffectColor2 write SetEffectColor2;
    property Picture: TPicture read FPicture write SetPicture;
    property Shadow : boolean read FShadow write SetShadow;
    property ShadowColor : TColor read FShadowColor write SetShadowColor;
    property ShadowWidth : integer read FShadowWidth write SetShadowWidth;
    property ValidComponents : TStringList read FValidComponents write SetValidComponents;
  end;

  TPieEffectEditorDialog = class(TForm)
    PropBox: TGroupBox;
    ColorShape1: TShape;
    ColorButton1: TButton;
    ColorShape2: TShape;
    ColorButton2: TButton;
    Label6: TLabel;
    Label2: TLabel;
    ColorShape3: TShape;
    ColorButton3: TButton;
    ShadowBox: TCheckBox;
    Label3: TLabel;
    Label4: TLabel;
    EffectBox: TRadioGroup;
    BorderBox: TRadioGroup;
    PImage: TImage;
    PictureButton: TButton;
    GroupBox1: TGroupBox;
    Button1: TButton;
    Edit1: TEdit;
    ListBox1: TListBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    CD1: TColorDialog;
    OPD1: TOpenPictureDialog;
    ProgressBar1: TProgressBar;
    EffH: TScrollBar;
    EffW: TScrollBar;
    BorderW: TScrollBar;
    ShadW: TScrollBar;
    procedure ColorButton1Click(Sender: TObject);
    procedure ColorButton2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure EffHChange(Sender: TObject);
    procedure EffWChange(Sender: TObject);
    procedure ColorButton3Click(Sender: TObject);
    procedure ShadowBoxClick(Sender: TObject);
    procedure ShadWChange(Sender: TObject);
    procedure BorderWChange(Sender: TObject);
    procedure EffectBoxClick(Sender: TObject);
    procedure BorderBoxClick(Sender: TObject);
    procedure PictureButtonClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    PE1: TPieEffect;
    procedure InitSettings;
  end;

implementation

{$R *.DFM}

type
  TConvertColor = record
    case boolean of
     true : (C : TColor);
     false : (R : byte; B : byte; G : byte; dummy : byte);
  end;

function GetColorDiff(Color1,Color2 : TColor; Position,Step : integer) : TColor;
var C : TConvertColor;
begin
  C.R:=((TConvertColor(Color1).R*(Step-Position)
    +TConvertColor(Color2).R*Position) div Step);
  C.B:=((TConvertColor(Color1).B*(Step-Position)
    +TConvertColor(Color2).B*Position) div Step);
  C.G:=((TConvertColor(Color1).G*(Step-Position)
    +TConvertColor(Color2).G*Position) div Step);
  C.dummy:=((TConvertColor(Color1).dummy*(Step-Position)
    +TConvertColor(Color2).dummy*Position) div Step);
  Result:=C.C;
end;

constructor TPieEffect.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  FValidComponents:=TStringList.Create;
  FValidComponents.OnChange := ValidComponentsChange;
  FValidComponents.OnChanging := ValidComponentsChanging;
  FValidComponentsOld:=TStringList.Create;
  FForm:=nil;
  FOldFormPaint := NIL;
  IF AOwner is TForm THEN BEGIN
    FForm := AOwner as TForm;
    FOldFormPaint := FForm.OnPaint;
    FForm.OnPaint := FormPaint;
  END
  ELSE ShowMessage('This component cant work correctly!');
  FEffectStyle:=es2ColorsVertical;
  FBitmap:=TBitmap.Create;
  FBorderColor:=clBlack;
  FBorderStyle:=bsSingle;
  FBorderWidth:=1;
  FEffectColor2:=clGreen;
  FEffectColor1:=clWhite;
  FEffectHeight:=5;
  FEffectWidth:=5;
  FShadowWidth:=4;
  FShadow:=true;
  FShadowColor:=clGray;
  FPicture := TPicture.Create;
  FPicture.OnChange := PictureChange;
  FillBitmap;
end;

destructor TPieEffect.Destroy;
begin
  FValidComponents.Free;
  FValidComponentsOld.Free;
  FPicture.Free;
  FBitmap.Free;
  inherited Destroy;
end;

procedure TPieEffect.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation=opRemove) then
    begin
      if (FForm<>nil) and (AComponent=FForm) then FForm:=nil;
    end;
end;

procedure TPieEffect.SetValidComponents(value : TStringList);
begin
  if FValidComponents<>value then
    begin
      FValidComponents.Assign(value);
      PaintEffect;
    end;
end;

procedure TPieEffect.SetBorderColor(value : TColor);
begin
  if value<>FBorderColor then
    begin
      FBorderColor:=value;
      PaintEffect;
    end;
end;

procedure TPieEffect.SetBorderStyle(value : TBorderStyle);
begin
  if value<>FBorderStyle then
    begin
      FBorderStyle:=value;
      PaintEffect;
    end;
end;

procedure TPieEffect.SetBorderWidth(value : integer);
begin
  if value<>FBorderWidth then
    begin
      FBorderWidth:=value;
      PaintEffect;
    end;
end;

procedure TPieEffect.SetEffectStyle(value : TEffectStyle);
begin
  if value<>FEffectStyle then
    begin
      FEffectStyle:=value;
      FillBitmap;
      PaintEffect;
    end;
end;

procedure TPieEffect.SetEffectWidth(value : integer);
begin
  if value<>FEffectWidth then
    begin
      FEffectWidth:=value;
      PaintEffect;
    end;
end;

procedure TPieEffect.SetEffectHeight(value : integer);
begin
  if value<>FEffectHeight then
    begin
      FEffectHeight:=value;
      PaintEffect;
    end;
end;

procedure TPieEffect.SetEffectColor1(value : TColor);
begin
  if value<>FEffectColor1 then
    begin
      FEffectColor1:=value;
      FillBitmap;
      PaintEffect;
    end;
end;

procedure TPieEffect.SetEffectColor2(value : TColor);
begin
  if value<>FEffectColor2 then
    begin
      FEffectColor2:=value;
      FillBitmap;
      PaintEffect;
    end;
end;

procedure TPieEffect.SetPicture(Value: TPicture);
begin
  FPicture.Assign(Value);
  PaintEffect;
end;

procedure TPieEffect.SetShadow(value : boolean);
begin
  if value<>FShadow then
    begin
      FShadow:=value;
      PaintEffect;
    end;
end;

procedure TPieEffect.SetShadowColor(value : TColor);
begin
  if value<>FShadowColor then
    begin
      FShadowColor:=value;
      PaintEffect;
    end;
end;

procedure TPieEffect.SetShadowWidth(value : integer);
begin
  if value<>FShadowWidth then
    begin
      FShadowWidth:=value;
      PaintEffect;
    end;
end;

PROCEDURE TPieEffect.PictureChange(Sender: TObject);
BEGIN
  PaintEffect;
END;

procedure TPieEffect.FormPaint(Sender: TObject);
BEGIN
  IF assigned(FOldFormPaint) THEN FOldFormPaint(Sender);
  PaintEffect;
END;

procedure TPieEffect.ValidComponentsChanging(Sender: TObject);
begin
  FValidComponentsOld.Assign(FValidComponents);
END;

procedure TPieEffect.ValidComponentsChange(Sender: TObject);
PROCEDURE Scannen(C: TWinControl);
var
  ti,tj : integer;
  R: TRect;
  T: TControl;
BEGIN
  for ti:=0 to C.ComponentCount-1 do begin
     for tj:=0 to FValidComponentsOld.Count-1 do
     if (uppercase(C.Components[ti].Name)=uppercase(FValidComponentsOld[tj])) AND
       (C.Components[ti] is TControl) then begin
       T := C.Components[ti] as TControl;
       R := Rect(T.Left-EffectWidth-BorderWidth,
                 T.Top-EffectHeight-BorderWidth,
                 T.Left+T.Width+EffectWidth+BorderWidth+ShadowWidth+1,
                 T.Top+T.Height+EffectHeight+BorderWidth+ShadowWidth+1);
       InvalidateRect(T.Parent.Handle, @R, True);
     end;
     IF C.Components[ti] is TWinControl THEN Scannen(C.Components[ti] as TWinControl);
  end;
END;
begin
  if FForm=nil then exit;
  if (csDesigning in ComponentState) then exit;

  Scannen(FForm);
  PaintEffect;
END;

procedure TPieEffect.FillBitmap;
VAR
  I, J: Integer;
BEGIN
    CASE EffectStyle OF
    esNone:
      begin
        FBitmap.Height:=1;
        FBitmap.Width:=1;
        FBitmap.Canvas.Pixels[0,0]:=clBtnFace; {FForm.Color; Control.Parent.Color;}
      end;
    es2ColorsVertical:
      begin
        FBitmap.Height:=256;
        FBitmap.Width:=1;
        for j:=0 to 255 do {Bitmap mit Farbnuancen fllen}
          FBitmap.Canvas.Pixels[0,j]:=GetColorDiff(
            EffectColor1,EffectColor2,Succ(j),256);
      end;
    es2ColorsHorizontal:
      begin
        FBitmap.Height:=1;
        FBitmap.Width:=256;
        for j:=0 to 255 do {Bitmap mit Farbnuancen fllen}
          FBitmap.Canvas.Pixels[j,0]:=GetColorDiff(
            EffectColor1,EffectColor2,Succ(j),256);
      end;
    es3ColorsVertical:
      begin
        FBitmap.Height:=512;
        FBitmap.Width:=1;
        for j:=0 to 255 do {Bitmap mit Farbnuancen fllen}
          FBitmap.Canvas.Pixels[0,j]:=GetColorDiff(
            EffectColor1,EffectColor2,Succ(j),256);
        for j:=256 to 511 do {Bitmap mit Farbnuancen fllen}
          FBitmap.Canvas.Pixels[0,j]:=GetColorDiff(
            EffectColor1,EffectColor2,Succ(511-j),256);
      end;
    es3ColorsHorizontal:
      begin
        FBitmap.Height:=1;
        FBitmap.Width:=512;
        for j:=0 to 255 do {Bitmap mit Farbnuancen fllen}
          FBitmap.Canvas.Pixels[j,0]:=GetColorDiff(
            EffectColor1,EffectColor2,Succ(j),256);
        for j:=256 to 511 do {Bitmap mit Farbnuancen fllen}
          FBitmap.Canvas.Pixels[j,0]:=GetColorDiff(
            EffectColor1,EffectColor2,Succ(511-j),256);
      end;
    es2ColorsDiagonal1:
      begin
        FBitmap.Height:=256;
        FBitmap.Width:=256;
        for i := 0 TO 255 DO FOR j:=0 to 255 do {Bitmap mit Farbnuancen fllen}
          FBitmap.Canvas.Pixels[I,J]:=GetColorDiff(
            EffectColor1,EffectColor2,Succ((I+J)DIV 2),256);
      end;
    es2ColorsDiagonal2:
      begin
        FBitmap.Height:=256;
        FBitmap.Width:=256;
        for i := 0 TO 255 DO FOR j:=0 to 255 do {Bitmap mit Farbnuancen fllen}
          FBitmap.Canvas.Pixels[255-I,J]:=GetColorDiff(
            EffectColor1,EffectColor2,Succ((I+J)DIV 2),256);
      end;
    esPictureStretch:
      begin
      end;
    esPictureTile:
      begin
      end;
    END;
END;

procedure TPieEffect.DrawEffect(Control : TControl);
var
  ATop,ALeft,AWidth,AHeight,bw : integer;
  DC: TCanvas;
  Image: TImage;
  PenColor, BrushColor : TColor;
  I, J, W, H: Integer;
begin
  ATop:=Control.Top-EffectHeight;
  ALeft:=Control.Left-EffectWidth;
  AHeight:=Control.Height+2*EffectHeight;
  AWidth:=Control.Width+2*EffectWidth;
{  DC := FForm.Canvas;}
  Control.Parent.Update;   {Erst bergeordnetes Panel o.. malen}
  DC := TCanvas.Create;
  DC.Handle := GetDC(Control.Parent.Handle);
  {Merken und spter rcksetzen}
  PenColor:=DC.Pen.Color;
  BrushColor := DC.Brush.Color;
  TRY

    {Umrandung zeichnen}
    if BorderStyle=bsSingle then
      begin
        DC.Pen.Color:=BorderColor;
        for j:=1 to BorderWidth do
          begin
            DC.MoveTo(ALeft-j,ATop-j);
            DC.LineTo(ALeft+AWidth+j-1,ATop-j);
            DC.LineTo(ALeft+AWidth+j-1,ATop+AHeight+j-1);
            DC.LineTo(ALeft-j,ATop+AHeight+j-1);
            DC.LineTo(ALeft-j,ATop-j);
          end;
      end;

    CASE EffectStyle OF
    esNone:
      begin
        {Bitmap auf Canvas "stretchen"}
        DC.StretchDraw(
          Bounds(ALeft,ATop,AWidth,AHeight),FBitmap);
      end;
    es2ColorsVertical, es2ColorsHorizontal,
    es3ColorsVertical, es3ColorsHorizontal,
    es2ColorsDiagonal1, es2ColorsDiagonal2:
      begin
        {Bitmap auf Canvas "stretchen"}
        DC.StretchDraw(
          Bounds(ALeft,ATop,AWidth,AHeight),FBitmap);
      end;
    esPictureStretch:
      begin
        {Bitmap auf Canvas "stretchen"}
        DC.StretchDraw(
          Bounds(ALeft,ATop,AWidth,AHeight), FPicture.Graphic);
      end;
    esPictureTile:
      begin
        Image := TImage.Create(Self);
        IF Assigned(FPicture.Graphic) THEN
        TRY
          FBitmap.Height:=AHeight;
          FBitmap.Width:=AWidth;
          Image.Canvas.Draw(0,0,FPicture.Graphic);
          FOR J:=0 TO AHeight DIV FPicture.Bitmap.Height DO
          FOR I:=0 TO AWidth  DIV FPicture.Bitmap.Width  DO BEGIN
            W := FPicture.Bitmap.Width;
            H := FPicture.Bitmap.Height;
            IF Succ(I)*W > AWidth  THEN W:=AWidth  - I*W;
            IF Succ(J)*H > AHeight THEN H:=AHeight - J*H;
            Bitblt(DC.Handle,
                   ALeft+I*FPicture.Bitmap.Width,
                   ATop +J*FPicture.Bitmap.Height,
                   W, H, Image.Canvas.Handle, 0, 0, SrcCopy);
          END;
        FINALLY
          Image.Free;
        END;
      end;
    END;

    {Schatten zeichen nach unten rechts}
    if Shadow then begin
      if BorderStyle=bsSingle then bw:=BorderWidth else bw:=0;
      DC.Pen.Color:=ShadowColor;
      for j:=0 to ShadowWidth do begin
        DC.MoveTo(ALeft-bw+j+1,ATop+bw+AHeight+j);
        DC.LineTo(ALeft+bw+AWidth+j,ATop+bw+AHeight+j);
        DC.MoveTo(ALeft+bw+AWidth+j,ATop-bw+j);
        DC.LineTo(ALeft+bw+AWidth+j,ATop+bw+AHeight+j+1);
      end;
    end;
  FINALLY
    DC.Pen.Color:=PenColor;
    DC.Brush.Color := BrushColor;
    ReleaseDC(Control.Parent.Handle, DC.Handle);
    DC.Free;
  END;
end;

procedure TPieEffect.PaintEffect;
PROCEDURE Scannen(C: TWinControl);
var
  ti,tj : integer;
BEGIN
  for ti:=0 to C.ComponentCount-1 do begin
    if not (ValidComponents.Count=0) then begin
       for tj:=0 to ValidComponents.Count-1 do
       if uppercase(C.Components[ti].Name)=uppercase(ValidComponents[tj]) then
         DrawEffect(TControl(C.Components[ti]));
       IF C.Components[ti] is TWinControl THEN Scannen(C.Components[ti] as TWinControl);
    end;
  end;
END;
begin
  if FForm=nil then exit;
  if (csDesigning in ComponentState) then exit;

  Scannen(FForm);

 { for ti:=0 to FForm.ComponentCount-1 do begin
    if not (ValidComponents.Count=0) then begin
       for tj:=0 to ValidComponents.Count-1 do
       if uppercase(FForm.Components[ti].Name)=uppercase(ValidComponents[tj]) then
         DrawEffect(TControl(FForm.Components[ti]));
    end;
  end;}
end;

procedure TPieEffect.Execute;
VAR
  D: TPieEffectEditorDialog;
procedure CopyProp(Dest, Source: TPieEffect);
BEGIN
  Dest.Picture      := Source.Picture;
  Dest.EffectColor1 := Source.EffectColor1;
  Dest.EffectColor2 := Source.EffectColor2;
  Dest.ShadowColor  := Source.ShadowColor;
  Dest.EffectHeight := Source.EffectHeight;
  Dest.EffectWidth  := Source.EffectWidth;
  Dest.Shadow       := Source.Shadow;
  Dest.ShadowWidth  := Source.ShadowWidth;
  Dest.BorderWidth  := Source.BorderWidth;
  Dest.EffectStyle  := Source.EffectStyle;
  Dest.BorderStyle  := Source.BorderStyle;
END;
begin
     D := TPieEffectEditorDialog.Create(Application);
     TRY
       CopyProp(D.PE1, Self);
       D.Caption := Self.Name + D.Caption;
       D.InitSettings;
       IF D.ShowModal = mrOK THEN BEGIN
         CopyProp(Self, D.PE1);
       END;
     FINALLY
       D.Free;
     END;
end;

{******************************************************}
{******************************************************}
{******************************************************}

procedure TPieEffectEditorDialog.InitSettings;
BEGIN
  ColorShape1.Brush.Color := PE1.EffectColor1;
  ColorShape2.Brush.Color := PE1.EffectColor2;
  ColorShape3.Brush.Color := PE1.ShadowColor;
  ShadowBox.Checked := PE1.Shadow;
  EffH.Position := PE1.EffectHeight;
  EffW.Position := PE1.EffectWidth;
  ShadW.Position := PE1.ShadowWidth;
  BorderW.Position := PE1.BorderWidth;
  CASE PE1.EffectStyle OF
  esNone             : EffectBox.ItemIndex := 0;
  es2ColorsVertical  : EffectBox.ItemIndex := 1;
  es2ColorsHorizontal: EffectBox.ItemIndex := 2;
  es3ColorsVertical  : EffectBox.ItemIndex := 3;
  es3ColorsHorizontal: EffectBox.ItemIndex := 4;
  es2ColorsDiagonal1 : EffectBox.ItemIndex := 5;
  es2ColorsDiagonal2 : EffectBox.ItemIndex := 6;
  esPictureStretch   : EffectBox.ItemIndex := 7;
  esPictureTile      : EffectBox.ItemIndex := 8;
  END;
  CASE PE1.BorderStyle OF
  bsNone             : BorderBox.ItemIndex := 0;
  bsSingle           : BorderBox.ItemIndex := 1;
  END;
  PImage.Picture := PE1.Picture;
END;

procedure TPieEffectEditorDialog.ColorButton1Click(Sender: TObject);
begin
  CD1.Color := PE1.EffectColor1;
  IF CD1.Execute
  THEN PE1.EffectColor1 := CD1.Color;
  ColorShape1.Brush.Color := PE1.EffectColor1;
end;

procedure TPieEffectEditorDialog.ColorButton2Click(Sender: TObject);
begin
  CD1.Color := PE1.EffectColor2;
  IF CD1.Execute
  THEN PE1.EffectColor2 := CD1.Color;
  ColorShape2.Brush.Color := PE1.EffectColor2;
end;

procedure TPieEffectEditorDialog.FormCreate(Sender: TObject);
begin
  PE1 := TPieEffect.Create(Self);
  WITH PE1.ValidComponents DO BEGIN
    Clear;
    Add('Button1');
    Add('Edit1');
    Add('ListBox1');
    Add('ProgressBar1');
  END;
end;

procedure TPieEffectEditorDialog.FormDestroy(Sender: TObject);
begin
  PE1.Free;
end;

procedure TPieEffectEditorDialog.EffHChange(Sender: TObject);
begin
  GroupBox1.Invalidate;
  PE1.EffectHeight := EffH.Position;
end;

procedure TPieEffectEditorDialog.EffWChange(Sender: TObject);
begin
  GroupBox1.Invalidate;
  PE1.EffectWidth := EffW.Position;
end;

procedure TPieEffectEditorDialog.ColorButton3Click(Sender: TObject);
begin
  CD1.Color := PE1.ShadowColor;
  IF CD1.Execute
  THEN PE1.ShadowColor := CD1.Color;
  ColorShape3.Brush.Color := PE1.ShadowColor;
end;

procedure TPieEffectEditorDialog.ShadowBoxClick(Sender: TObject);
begin
  GroupBox1.Invalidate;
  PE1.Shadow := ShadowBox.Checked;
end;

procedure TPieEffectEditorDialog.ShadWChange(Sender: TObject);
begin
  GroupBox1.Invalidate;
  PE1.ShadowWidth := ShadW.Position;
end;

procedure TPieEffectEditorDialog.BorderWChange(Sender: TObject);
begin
  GroupBox1.Invalidate;
  PE1.BorderWidth := BorderW.Position;
end;

procedure TPieEffectEditorDialog.EffectBoxClick(Sender: TObject);
begin
  CASE EffectBox.ItemIndex OF
  0: PE1.EffectStyle := esNone;
  1: PE1.EffectStyle := es2ColorsVertical;
  2: PE1.EffectStyle := es2ColorsHorizontal;
  3: PE1.EffectStyle := es3ColorsVertical;
  4: PE1.EffectStyle := es3ColorsHorizontal;
  5: PE1.EffectStyle := es2ColorsDiagonal1;
  6: PE1.EffectStyle := es2ColorsDiagonal2;
  7: PE1.EffectStyle := esPictureStretch;
  8: PE1.EffectStyle := esPictureTile;
  END;
end;

procedure TPieEffectEditorDialog.BorderBoxClick(Sender: TObject);
begin
  GroupBox1.Invalidate;
  CASE BorderBox.ItemIndex OF
  0: PE1.BorderStyle := bsNone;
  1: PE1.BorderStyle := bsSingle;
  END;
end;

procedure TPieEffectEditorDialog.PictureButtonClick(Sender: TObject);
begin
  GroupBox1.Invalidate;
  IF OPD1.Execute
  THEN PE1.Picture.LoadFromFile(OPD1.FileName);
  PImage.Picture := PE1.Picture;
end;



end.
