{$I PIETOOLS.INC}
unit PieDigit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons, PieList
  {$IFDEF D6_OR_HIGHER}
  , Variants;
  {$ELSE}
  ;
  {$ENDIF}

CONST
  max_Digits = 20;
type
  TDigitStyle = (dsInteger, dsDouble, dsDate, dsTime);

  TDigitZustand = RECORD
                  OldChar: Char;
                  NewChar: Char;
                  Scrolling: Boolean;
                  ScrollDown: Boolean;
                  ScrollPos: Integer;
                  END;

  TPieDigit = class(TGraphicControl)
  private
    { Private-Deklarationen }
    FDigitBitmap: TPicture;
    FValue: Variant;
    FBitmapWidth: Integer;
    FDigitCount: Byte;
    FDigitScrolling: Boolean;
    FDecimals: Byte;
    FDigitStyle: TDigitStyle;
    Digitzustand: array[1..max_Digits] of TDigitZustand;
    ScrollTimer: TTimer;
    procedure SetDigitBitmap(Value: TPicture);
    procedure DigitBitmapChange(Sender: TObject);
    procedure SetValue(Value: Variant);
    procedure SetDigitCount(Value: Byte);
    procedure SetDecimals(Value: Byte);
    procedure SetDigitStyle(Value: TDigitStyle);
    procedure ScrollTimerTimer(Sender: TObject);
  protected
    { Protected-Deklarationen }
    procedure Paint; override;
  public
    { Public-Deklarationen }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Edit_aufrufen;
  published
    { Published-Deklarationen }
    property DigitBitmap: TPicture read FDigitBitmap write SetDigitBitmap;
    property Value: Variant read FValue write SetValue;
    property DigitCount: Byte read FDigitCount write SetDigitCount;
    property DigitScrolling: Boolean read FDigitScrolling write FDigitScrolling;
    property Decimals: Byte read FDecimals write SetDecimals;
    property DigitStyle: TDigitStyle read FDigitStyle write SetDigitStyle;
  end;

  TPieDigitFenster = class(TForm)
    DigitPanel: TPanel;
    Panel1: TPanel;
    DigitStyle: TRadioGroup;
    Label1: TLabel;
    Timer1: TTimer;
    OkButton: TBitBtn;
    AbbruchButton: TBitBtn;
    DBListe: TPieList;
    Label2: TLabel;
    Label3: TLabel;
    DigitScrolling: TCheckBox;
    DigitCount: TScrollBar;
    Decimals: TScrollBar;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure DigitStyleClick(Sender: TObject);
    procedure DigitCountChange(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure DecimalsChange(Sender: TObject);
    procedure DBListeClick(Sender: TObject);
    procedure DigitScrollingClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Value: Variant;
  public
    { Public-Deklarationen }
    Digit: TPieDigit;
  end;

var
  PieDigitFenster: TPieDigitFenster;

implementation

{$R *.DFM}
{$R PieDigit.RES}

USES PieHerk;

constructor TPieDigit.Create(AOwner: TComponent);
VAR
  I: Integer;
BEGIN
  inherited Create(AOwner);
  FOR I:=1 TO max_Digits DO WITH DigitZustand[I] DO BEGIN
    OldChar := #$20;
    NewChar := #$20;
    Scrolling := FALSE;
    ScrollDown := FALSE;
    ScrollPos := 0;
  END;
  ScrollTimer := TTimer.Create(Self);
  ScrollTimer.Enabled := FALSE;
  ScrollTimer.Interval := 50;
  ScrollTimer.OnTimer := ScrollTimerTimer;
  FDigitBitmap := TPicture.Create;
  FDigitBitmap.OnChange := DigitBitmapChange;
  FValue := 0;
  FDigitStyle := dsInteger;
  FDigitScrolling := FALSE;
  FDigitCount := 5;
  FDecimals := 2;
  FDigitBitmap.Bitmap.LoadFromResourceName(HInstance, 'PieDigitBitmap1');
  FBitmapWidth := FDigitBitmap.Graphic.Width DIV 16;
  Height := 20;
  Width := FDigitCount*FBitmapWidth;
END;

destructor TPieDigit.Destroy;
BEGIN
  ScrollTimer.Free;
  FDigitBitmap.Free;
  inherited Destroy;
END;

procedure TPieDigit.SetDigitBitmap(Value: TPicture);
BEGIN
  FDigitBitmap.Assign(Value);
  Invalidate;
END;

procedure TPieDigit.DigitBitmapChange(Sender: TObject);
BEGIN
  Invalidate;
END;

procedure TPieDigit.SetValue(Value: Variant);
VAR
  VT: Integer;
BEGIN
  VT := VarType(Value) AND varTypeMask;
  IF (VT = VarSmallInt) OR (VT = VarInteger) OR
     (VT = VarSingle) OR (VT = VarDouble) OR
     (VT = VarDate) OR (VT = VarByte) THEN BEGIN
    IF (VT = VarDate) AND
      NOT((FDigitStyle = dsDate) OR (FDigitStyle = dsTime)) THEN FDigitStyle := dsDate;
    IF (VT = VarSingle) OR (VT = VarDouble) AND
      NOT(FDigitStyle = dsDouble) THEN FDigitStyle := dsDouble;
    IF (VT = VarByte) OR (VT = VarSmallInt) OR (VT = VarInteger) AND
      NOT(FDigitStyle = dsInteger) THEN FDigitStyle := dsInteger;
    FValue := Value;
    Invalidate;
  END;
END;

procedure TPieDigit.SetDigitCount(Value: Byte);
BEGIN
  FDigitCount := Value;
  Width := FDigitCount * FBitmapWidth;
  Invalidate;
END;

procedure TPieDigit.SetDecimals(Value: Byte);
BEGIN
  FDecimals := Value;
  IF FDigitStyle = dsDouble THEN Invalidate;
END;

procedure TPieDigit.SetDigitStyle(Value: TDigitStyle);
BEGIN
  FDigitStyle := Value;
  Invalidate;
END;

procedure TPieDigit.ScrollTimerTimer(Sender: TObject);
BEGIN
  Invalidate;
END;

procedure TPieDigit.Paint;
CONST
  ValidChars = ['0', '1', '2', '3', '4', '5',
                '6', '7', '8', '9', '0', ' ',
                ',', '.', '+', '-', ':', '/'];
  ValidCharsString = '0123456789 ,.+-:/';
VAR
  I: Integer;
  S: String;
  C: Char;
BEGIN
  IF Assigned(FDigitBitmap) AND
    Assigned(FDigitBitmap.Graphic) AND
    (FDigitCount > 0) THEN WITH Canvas DO BEGIN
    {Anzuzeigende Zeichen ermitteln}
    CASE FDigitStyle OF
    dsInteger: S := Str_Number(FValue);
    dsDouble: S := S_N(FValue, FDigitCount, FDecimals);
    dsDate: S := FormatDateTime('dd.mm.yyyy', Value);
    dsTime: S := FormatDateTime('hh:nn:ss', Value);
    END;
    {Zustand prfen/fllen}
    ScrollTimer.Enabled := FALSE;
    FOR I:=1 TO max_Digits DO WITH DigitZustand[I] DO BEGIN
      IF I > length(S) THEN C := ' ' ELSE C := S[length(S)+1-I];
      IF NOT(C IN ValidChars) THEN C := ' ';
      IF NewChar <> C THEN BEGIN
        NewChar := C;
        ScrollDown := FALSE;
        IF FDigitScrolling THEN BEGIN
          ScrollPos := Height;
          IF csDesigning IN ComponentState
            THEN ScrollPos := 0
            ELSE Scrolling := TRUE;
        END
        ELSE BEGIN
          ScrollPos := 0;
          Scrolling := FALSE;
          OldChar := NewChar;
        END;
      END;
      IF Scrolling THEN ScrollTimer.Enabled := TRUE;
    END;
    {Zeichen darstellen}
    FOR I:=1 TO FDigitCount DO WITH DigitZustand[I] DO BEGIN
      IF Scrolling THEN BEGIN
        dec(ScrollPos, 2);
        Scrolling := ScrollPos > 0;
      END;
      IF Scrolling THEN
        BitBlt(Handle, Width-I*FBitmapWidth, ScrollPos-20, FBitmapWidth, 20,
          FDigitBitmap.Bitmap.Canvas.Handle,
          (pos(OldChar, ValidCharsString)-1)*FBitmapWidth, 0, srcCopy);

      BitBlt(Handle, Width-I*FBitmapWidth, ScrollPos, FBitmapWidth, 20,
        FDigitBitmap.Bitmap.Canvas.Handle,
        (pos(NewChar, ValidCharsString)-1)*FBitmapWidth, 0, srcCopy);
    END;
  END;
END;

{******************************************************}
{******************************************************}
{******************************************************}

procedure TPieDigit.Edit_aufrufen;
var
  D : TPieDigitfenster;
procedure CopyProp(Dest, Source: TPieDigit);
BEGIN
  Dest.DigitBitmap.Assign(Source.DigitBitmap);
  Dest.DigitCount      := Source.DigitCount;
  Dest.Decimals        := Source.Decimals;
  Dest.Value           := Source.Value;
  Dest.DigitStyle      := Source.DigitStyle;
  Dest.DigitScrolling  := Source.DigitScrolling;
END;
begin
  D := TPieDigitfenster.Create(Application);
  try
    CopyProp(D.Digit, Self);
    if D.ShowModal = mrOK then CopyProp(Self, D.Digit);
  finally
    D.Free;
  end;
end;


procedure TPieDigitFenster.FormCreate(Sender: TObject);
VAR
  I: Integer;
begin
  Digit := TPieDigit.Create(Self);
  Digit.Parent := DigitPanel;
  Digit.Top := 10;
  Digit.Left := 10;
  DBListe.Items.Clear;
  FOR I:=1 TO 4 DO BEGIN
    DBListe.Items.Add('Standard ' + Str_Number(I));
    DBListe.Items.Bitmaps[DBListe.Items.IndexOf('Standard ' + Str_Number(I))].LoadFromResourceName(HInstance, 'PieDigitBitmap'+Str_Number(I));
  END;  
end;

procedure TPieDigitFenster.FormDestroy(Sender: TObject);
begin
  Digit.Free;
end;

procedure TPieDigitFenster.FormShow(Sender: TObject);
begin
  IF Digit.DigitStyle IN [dsInteger, dsDouble]
    THEN Value := Digit.Value
    ELSE Value := 0;
  CASE Digit.DigitStyle OF
  dsDate : Digit.Value := Date;
  dsTime : Timer1.Enabled := TRUE;
  END;
  CASE Digit.DigitStyle OF
  dsInteger: DigitStyle.ItemIndex := 0;
  dsDouble : DigitStyle.ItemIndex := 1;
  dsDate   : DigitStyle.ItemIndex := 2;
  dsTime   : DigitStyle.ItemIndex := 3;
  END;
  DigitCount.Position := Digit.DigitCount;
  DigitScrolling.Checked := Digit.DigitScrolling;
  Decimals.Position := Digit.Decimals;
  DBListe.Items.Add('Owner');
  DBListe.Items.Bitmaps[DBListe.Items.IndexOf('Owner')] := Digit.DigitBitmap.Bitmap;
  DBListe.ItemIndex := DBListe.Items.IndexOf('Owner');
end;

procedure TPieDigitFenster.DigitStyleClick(Sender: TObject);
begin
  Timer1.Enabled := FALSE;
  Digit.DigitStyle := TDigitStyle(DigitStyle.ItemIndex);
  Digit.Value := Value;
  CASE Digit.DigitStyle OF
  dsDate : Digit.Value := Date;
  dsTime : Timer1.Enabled := TRUE;
  END;
end;

procedure TPieDigitFenster.DigitCountChange(Sender: TObject);
begin
  Digit.DigitCount := DigitCount.Position;
end;

procedure TPieDigitFenster.Timer1Timer(Sender: TObject);
begin
  Digit.Value := Time;
end;

procedure TPieDigitFenster.DecimalsChange(Sender: TObject);
begin
  Digit.Decimals := Decimals.Position;
end;

procedure TPieDigitFenster.DBListeClick(Sender: TObject);
begin
  IF DBListe.Items.IndexOf('Owner') >= 0
    THEN Digit.DigitBitmap.Bitmap := DBListe.Items.Bitmaps[DBListe.ItemIndex];
end;

procedure TPieDigitFenster.DigitScrollingClick(Sender: TObject);
begin
  Digit.DigitScrolling := DigitScrolling.Checked;
end;

end.
