{$I PIETOOLS.INC}
{$R-} {RangeCheck unbedingt ausschalten!}
{ Autor: Ingolf Pietschmann.
  Dieser Quelltext ist Freeware. Die Verwendung und Weitergabe dieser Sourcen zu
  privaten nicht kommerziellen Zwecken ist ausdrcklich erwnscht.
  Die Verwendung zu kommerziellen Zwecken ist nur mit Erlaubnis des Autors
  gestattet. Den Autor knnen Sie unter "Support@Pie-Tools.de" erreichen.

  These sources are freeware. The usage and distribution of these sources for
  private, not commercial purposes is explicit desired.
  The usage for commercial purposes is only permitted in agreement of the author.
  The author can be reached by "Support@Pie-Tools.de".
}
unit PieComboBox;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls,
  Piezln1, ExtDlgs, imgList;

type
  {PieComboBoxStrings}
  TPieComboBoxEintrag = class(TPersistent)
  public
    FBitmap: TBitmap;
    FColor: TColor;
    FFont: TFont;
    FHelpContext: THelpContext;
    FHint: string;
    procedure Assign(Source: TPersistent); override;
    destructor Destroy; override;
  END;

  PPieComboBoxItem = ^TPieComboBoxItem;
  TPieComboBoxItem = RECORD
    FString: string;
    FPieComboBoxEintrag: TPieComboBoxEintrag;
    FObject: TObject;
  END;

  PPieComboBoxListe = ^TPieComboBoxListe;
  TPieComboBoxListe = array[0..MaxListSize] of TPieComboBoxItem;

  TPieComboBox = class;

  TPieComboBoxStrings = class(TStrings)
  private
    FList: PPieComboBoxListe;
    FComboBox: TPieComboBox;
    FCount: Integer;
    FCapacity: Integer;
    FSorted: Boolean;
    FDuplicates: TDuplicates;
    FOnChange: TNotifyEvent;
    FOnChanging: TNotifyEvent;
    procedure ExchangeItems(Index1, Index2: Integer);
    procedure Grow;
    procedure QuickSort(L, R: Integer);
    procedure InsertItem(Index: Integer; const S: string);
    procedure SetSorted(Value: Boolean);
    procedure ReadBitmapData(Stream: TStream);
    procedure ReadData(Reader: TReader);
    procedure WriteBitmapData(Stream: TStream);
    procedure WriteData(Writer: TWriter);
  protected
    procedure DefineProperties(Filer: TFiler); override;
    procedure Changed; virtual;
    procedure Changing; virtual;
    function Get(Index: Integer): string; override;
    function GetObject(Index: Integer): TObject; override;
    function GetCapacity: Integer; override;
    function GetCount: Integer; override;
    function GetBitmap(Index: Integer): TBitmap; virtual;
    function GetColor(Index: Integer): TColor; virtual;
    function GetFont(Index: Integer): TFont; virtual;
    function GetHelpContext(Index: Integer): THelpContext; virtual;
    function GetHint(Index: Integer): string; virtual;
    procedure Put(Index: Integer; const S: string); override;
    procedure PutObject(Index: Integer; AObject: TObject); override;
    procedure SetBitmap(Index: Integer; ABitmap: TBitmap); virtual;
    procedure SetColor(Index: Integer; AColor: TColor); virtual;
    procedure SetFont(Index: Integer; AFont: TFont); virtual;
    procedure SetHelpContext(Index: Integer; AHelpContext: THelpContext); virtual;
    procedure SetHint(Index: Integer; AHint: string); virtual;
    procedure SetCapacity(NewCapacity: Integer); override;
    procedure SetUpdateState(Updating: Boolean); override;
  public       {PieComboBoxStrings}
    constructor Create(AOwner: TPieComboBox);
    destructor Destroy; override;
    function Add(const S: string): Integer; override;
    procedure AddItems(ItemsNeu: TPieComboBoxStrings); virtual;
    procedure Assign(Source: TPersistent); override;
    procedure Clear; override;
    procedure Delete(Index: Integer); override;
    procedure Exchange(Index1, Index2: Integer); override;
    function Find(const S: string; var Index: Integer): Boolean; virtual;
    function IndexOf(const S: string): Integer; override;
    procedure Insert(Index: Integer; const S: string); override;
    procedure Sort; virtual;
    property Colors[Index: Integer]: TColor read GetColor write SetColor;
    property Hints[Index: Integer]: string read GetHint write SetHint;
    property HelpContexts[Index: Integer]: THelpContext read GetHelpContext write SetHelpContext;
    property Fonts[Index: Integer]: TFont read GetFont write SetFont;
    property Bitmaps[Index: Integer]: TBitmap read GetBitmap write SetBitmap;
  published
    property Duplicates: TDuplicates read FDuplicates write FDuplicates;
    property Sorted: Boolean read FSorted write SetSorted;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    property OnChanging: TNotifyEvent read FOnChanging write FOnChanging;
  end;

  {PieComboBox}
  TBitmapStyle = (bscLeft, bscRight, bscCenter, bscStretch, bscPattern);
  TItemHeightStyle = (ihcFix, ihcFont, ihcBitmap, ihcFontBitmap);
  TBackGroundStyle = (bgscNone, bgscCenter, bgscStretch, bgscPattern);

  EInvalidTabStop = exception;

  TPieComboBox = class(TWinControl)
  private
    FItems: TPieComboBoxStrings;
    FCanvas: TCanvas;
    FSorted: Boolean;
    FStyle: TComboBoxStyle;
    FItemHeight: Integer;
    FMaxLength: Integer;
    FDropDownCount: Integer;
    FEditHandle: HWnd;
    FListHandle: HWnd;
    FEditInstance: Pointer;
    FListInstance: Pointer;
    FDefEditProc: Pointer;
    FDefListProc: Pointer;
    FEditFontIntern: TFont;
    FIsFocused: Boolean;
    FFocusChanged: Boolean;
    FSaveItems: TPieComboBoxStrings;
    FOnChange: TNotifyEvent;
    FOnDropDown: TNotifyEvent;
    FOnDrawItem: TDrawItemEvent;
    FOnMeasureItem: TMeasureItemEvent;
    FAlignment: TAlignment;
    FAnyColors: Boolean;
    FAnyFonts: Boolean;
    FBitmapStyle: TBitmapStyle;
    FItemHeightStyle: TItemHeightStyle;
    FLineByTabStops: Boolean;
    FBoldStyle: Boolean;
    FBackground: TPicture;
    FBackGroundStyle: TBackGroundStyle;
    FVersion: string;
    FShowHeader: Boolean;
    procedure AdjustDropDown;
    procedure EditWndProc(var Message: TMessage);
    function DrawItemBitmap(Index: integer; ARect: TRect): TRect;
    function GetDroppedDown: Boolean;
    function GetItemIndex: Integer;
    function GetSelLength: Integer;
    function GetSelStart: Integer;
    function GetSelText: string;
    procedure ListWndProc(var Message: TMessage);
    procedure SetDroppedDown(Value: Boolean);
    procedure SetItems(Value: TPieComboBoxStrings);
    procedure SetItemIndex(Value: Integer);
    procedure SetItemProperties;
    procedure SetSelLength(Value: Integer);
    procedure SetSelStart(Value: Integer);
    procedure SetSelText(const Value: string);
    procedure SetSorted(Value: Boolean);
    function  GetItemHeight: Integer;
    procedure SetItemHeight(Value: Integer);
    procedure SetMaxLength(Value: Integer);
    procedure UpdateHint(Index: Integer);
    procedure WMCreate(var Message: TWMCreate); message WM_CREATE;
    procedure WMEraseBkgnd(var Message: TWMEraseBkgnd); message WM_ERASEBKGND;
    procedure CMCancelMode(var Message: TCMCancelMode); message CM_CANCELMODE;
    procedure CMCtl3DChanged(var Message: TMessage); message CM_CTL3DCHANGED;
    procedure CMParentColorChanged(var Message: TMessage); message CM_PARENTCOLORCHANGED;
    procedure CNCommand(var Message: TWMCommand); message CN_COMMAND;
    procedure CNDrawItem(var Message: TWMDrawItem); message CN_DRAWITEM;
    procedure CNMeasureItem(var Message: TWMMeasureItem); message CN_MEASUREITEM;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure WMDrawItem(var Message: TWMDrawItem); message WM_DRAWITEM;
    procedure WMMeasureItem(var Message: TWMMeasureItem); message WM_MEASUREITEM;
    procedure WMDeleteItem(var Message: TWMDeleteItem); message WM_DELETEITEM;
    procedure WMGetDlgCode(var Message: TWMGetDlgCode); message WM_GETDLGCODE;
    procedure DrawBoldStyle(Index: integer; ARect: TRect; State: TOwnerDrawState);
    procedure SetAlignment(Value: TAlignment);
    procedure SetAnyColors(Value: Boolean);
    procedure SetAnyFonts(Value: Boolean);
    procedure SetBitmapStyle(AStyle: TBitmapStyle);
    procedure SetBoldStyle(AStyle: Boolean);
    procedure SetItemHeightStyle(AStyle: TItemHeightStyle);
    procedure SetBackground(Value: TPicture);
    procedure SetBackGroundStyle(Value: TBackGroundStyle);
    procedure BackGroundChange(Sender: TObject);
    procedure WMMove(var Message: TWMMove); message WM_MOVE;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    procedure WMPaint(var Message: TWmPaint); message WM_Paint;
    procedure PaintBackground(R: TRect; Edit_malen: Boolean);
    procedure SetLineByTabStops(Value: Boolean);
    procedure SetHCVisible(Value: Boolean);
    function GetHCS: THeaderSections;
    procedure SetHCS(Value: THeaderSections);
    {$IFDEF D5_OR_HIGHER}
    function GetHCImages: TCustomImageList;
    procedure SetHCImages(Value: TCustomImageList);
    {$ENDIF}
    function GetHCStyle: THeaderStyle;
    procedure SetHCStyle(Value: THeaderStyle);
    function GetHCFont: TFont;
    procedure SetHCFont(Value: TFont);
    function GetOnSectionClick: TSectionNotifyEvent;
    procedure SetOnSectionClick(Value: TSectionNotifyEvent);
    procedure HeaderSectionResize(HeaderControl: THeaderControl; Section: THeaderSection);
    procedure HeaderDrawSection(HeaderControl: THeaderControl; Section: THeaderSection; const Rect: TRect; Pressed: Boolean);
  protected
    FHeader: THeaderControl;
    procedure ComboWndProc(var Message: TMessage; ComboWnd: HWnd;
      ComboProc: Pointer); virtual;
    procedure WndProc(var Message: TMessage); override;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    procedure DestroyWnd; override;
    procedure Loaded; override;
    procedure DrawItem(Index: Integer; Rect: TRect;
      State: TOwnerDrawState); virtual;
    procedure MeasureItem(Index: Integer; var AHeight: Integer); virtual;
    procedure Change; dynamic;
    procedure DropDown; dynamic;
    procedure SetStyle(Value: TComboBoxStyle); virtual;
    property EditHandle: HWnd read FEditHandle;
    property ListHandle: HWnd read FListHandle;
    property OnDragDrop;
    property OnDragOver;
    property OnMouseDown;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Clear;
    procedure SelectAll;
    procedure Edit_aufrufen;
    function ItemAtPos(Pos: TPoint; Existing: Boolean): Integer;
    procedure CalculateItemHeight;
    property Canvas: TCanvas read FCanvas;
    procedure CopyProp(Dest, Source: TPieComboBox);
    property DroppedDown: Boolean read GetDroppedDown write SetDroppedDown;
    property ItemIndex: Integer read GetItemIndex write SetItemIndex;
    property SelLength: Integer read GetSelLength write SetSelLength;
    property SelStart: Integer read GetSelStart write SetSelStart;
    property SelText: string read GetSelText write SetSelText;
  published
    property Align;
    property Anchors;
    property Color;
    property Ctl3D;
    property DragMode;
    property DragCursor;
    property Enabled;
    property Font;
    property ImeMode;
    property ImeName;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property Text;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnStartDrag;
    property Alignment: TAlignment read FAlignment write SetAlignment default taLeftJustify;
    property AnyColors: boolean read FAnyColors write SetAnyColors default TRUE;
    property AnyFonts: boolean read FAnyFonts write SetAnyFonts default TRUE;
    property Background: TPicture read FBackground write SetBackground;
    property BackGroundStyle: TBackGroundStyle read FBackGroundStyle write SetBackGroundStyle;
    property BitmapStyle: TBitmapStyle read FBitmapStyle write SetBitmapStyle default bscLeft;
    property BoldStyle: Boolean read FBoldStyle write SetBoldStyle default FALSE;
    property DropDownCount: Integer read FDropDownCount write FDropDownCount default 8;
    property HeaderSections: THeaderSections read GetHCS write SetHCS;
    {$IFDEF D5_OR_HIGHER}
    property HeaderImages: TCustomImageList read GetHCImages write SetHCImages;
    {$ENDIF}
    property HeaderStyle: THeaderStyle read GetHCStyle write SetHCStyle default hsButtons;
    property HeaderFont: TFont read GetHCFont write SetHCFont;
    property ItemHeight: Integer read GetItemHeight write SetItemHeight;
    property ItemHeightStyle: TItemHeightStyle read FItemHeightStyle
      write SetItemHeightStyle default ihcFix;
    property Items: TPieComboBoxStrings read FItems write SetItems;
    property LineByTabStops: boolean read FLineByTabStops write SetLineByTabStops default FALSE;
    property MaxLength: Integer read FMaxLength write SetMaxLength default 0;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    property OnDropDown: TNotifyEvent read FOnDropDown write FOnDropDown;
    property OnDrawItem: TDrawItemEvent read FOnDrawItem write FOnDrawItem;
    property OnMeasureItem: TMeasureItemEvent read FOnMeasureItem write FOnMeasureItem;
    property OnSectionClick: TSectionNotifyEvent read GetOnSectionClick write SetOnSectionClick;
    property ParentColor default False;
    property ShowHeader: Boolean read FShowHeader write SetHCVisible default FALSE;
    property Sorted: Boolean read FSorted write SetSorted default False;
    property Style: TComboBoxStyle read FStyle write SetStyle;
    property TabStop default True;
    property Version: string read FVersion write FVersion;
  end;


  {PieItemsPropertyEditor}
  TPieComboBoxItemsfenster = class(TForm)
    Rechtspanel: TPanel;
    EditPanel: TPanel;
    ObenPanel: TPanel;
    ColorBtn: TBitBtn;
    FontBtn: TBitBtn;
    HintBtn: TBitBtn;
    ColorShape: TShape;
    Bevel1: TBevel;
    ZeilenLabel1: TLabel;
    Gesamtzeilenlabel1: TLabel;
    ZeilenLabel2: TLabel;
    Gesamtzeilenlabel2: TLabel;
    ColorDialog: TColorDialog;
    BitmapBtn: TBitBtn;
    Edit: TMemo;
    FontDialog: TFontDialog;
    ObenPanel3: TPanel;
    InsertBtn: TBitBtn;
    DeleteBtn: TBitBtn;
    ChangeBtn: TBitBtn;
    Helplabel: TLabel;
    UT: TCheckBox;
    Bevel2: TBevel;
    AnyColors: TCheckBox;
    AnyFonts: TCheckBox;
    Bevel3: TBevel;
    UntenPanel: TPanel;
    LoeschBtn: TBitBtn;
    OkButton: TBitBtn;
    AbbruchButton: TBitBtn;
    OpenPicDialog: TOpenPictureDialog;
    IHStyle: TRadioGroup;
    BStyle: TRadioGroup;
    BitmapVorschau: TImage;
    BitBtn1: TBitBtn;
    BoldStyle: TCheckBox;
    HSGroup: TRadioGroup;
    LBTS: TCheckBox;
    HFButton: TBitBtn;
    HelpUpDown: TUpDown;
    HelpEdit: TLabel;
    BGButton: TBitBtn;
    BGStyle: TRadioGroup;
    Bevel4: TBevel;
    procedure InsertBtnClick(Sender: TObject);
    procedure DeleteBtnClick(Sender: TObject);
    procedure ChangeBtnClick(Sender: TObject);
    procedure ColorBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure EditEnter(Sender: TObject);
    procedure EditChange(Sender: TObject);
    procedure FontBtnClick(Sender: TObject);
    procedure HintBtnClick(Sender: TObject);
    procedure LoeschBtnClick(Sender: TObject);
    procedure UTClick(Sender: TObject);
    procedure AnyColorsClick(Sender: TObject);
    procedure AnyFontsClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BitmapBtnClick(Sender: TObject);
    procedure IHStyleClick(Sender: TObject);
    procedure BStyleClick(Sender: TObject);
    procedure BoldStyleClick(Sender: TObject);
    procedure LBTSClick(Sender: TObject);
    procedure HSGroupClick(Sender: TObject);
    procedure HFButtonClick(Sender: TObject);
    procedure HelpUpDownChanging(Sender: TObject;
      var AllowChange: Boolean);
    procedure BGButtonClick(Sender: TObject);
    procedure BGStyleClick(Sender: TObject);
  private
    { Private-Deklarationen }
    Zeile: Integer;
    Zieh_Item: Integer;
    HintDialog: TPieZeilenDialog;
    procedure ComboBoxClick(Sender: TObject);
    procedure ComboBoxMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ComboBoxDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure ComboBoxDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure Prop_zeigen;
  public
    { Public-Deklarationen }
    ComboBox: TPieComboBox;
  end;

implementation

{$R *.DFM}
USES PieHERK, Consts
{$IFDEF D6_OR_HIGHER}
, RTLConsts;
{$ELSE}
;
{$ENDIF}

TYPE
  TSelection = record
    StartPos, EndPos: Integer;
  end;

function HasPopup(Control: TControl): Boolean;
begin
  Result := True;
  while Control <> nil do
    if TPieComboBox(Control).PopupMenu <> nil then Exit else Control := Control.Parent;
  Result := False;
end;

{ TPieListEintrag }
destructor TPieComboBoxEintrag.Destroy;
begin
  FBitmap.Free;
  FFont.Free;
  inherited Destroy;
END;

procedure TPieComboBoxEintrag.Assign(Source: TPersistent);
VAR
  PCE: TPieComboBoxEintrag;
begin
  if Source is TPieComboBoxEintrag then begin
    PCE := Source as TPieComboBoxEintrag;

    IF assigned(PCE.FBitmap) THEN BEGIN
      IF NOT assigned(FBitmap) THEN FBitmap := TBitmap.Create;
      FBitmap.Assign(PCE.FBitmap);
    END
    ELSE BEGIN
      IF assigned(FBitmap) THEN BEGIN
        FBitmap.Free;
        FBitmap := NIL;
      END;
    END;
    IF assigned(PCE.FFont) THEN BEGIN
      IF NOT assigned(FFont) THEN FFont := TFont.Create;
      FFont.Assign(PCE.FFont);
    END
    ELSE BEGIN
      IF assigned(FFont) THEN BEGIN
        FFont.Free;
        FFont := NIL;
      END;
    END;
    FColor := PCE.FColor;
    FHelpContext := PCE.FHelpContext;
    FHint := PCE.FHint;
  end;
end;

{ TPieComboBoxStrings }
constructor TPieComboBoxStrings.Create(AOwner: TPieComboBox);
begin
  inherited Create;
  FComboBox := AOwner;
  FList := NIL;
  FOnChange := nil;
  FOnChanging := nil;
  FCount := 0;
  SetCapacity(0);
end;

destructor TPieComboBoxStrings.Destroy;
VAR
  Index: Integer;
begin
  FOnChange := nil;
  FOnChanging := nil;
  FOR Index:=0 TO FCount-1 DO FList^[Index].FPieComboBoxEintrag.Free;
  if FCount <> 0 then Finalize(FList^[0], FCount);
  FComboBox := NIL;
  inherited Destroy;
  FCount := 0;
  SetCapacity(0);
end;

function TPieComboBoxStrings.Add(const S: string): Integer;
begin
  if not Sorted then
    Result := FCount
  else
    if Find(S, Result) then
      case Duplicates of
        dupIgnore: Exit;
        dupError: Error(SDuplicateString, 0);
      end;
  InsertItem(Result, S);
end;

procedure TPieComboBoxStrings.AddItems(ItemsNeu: TPieComboBoxStrings);
var
  I: Integer;
begin
  BeginUpdate;
  try
    for I := 0 to ItemsNeu.Count - 1 do begin
      Add(ItemsNeu.Strings[I]);
      Bitmaps[I] := ItemsNeu.Bitmaps[I];
      Colors[I] := ItemsNeu.Colors[I];
      Fonts[I] := ItemsNeu.Fonts[I];
      HelpContexts[I] := ItemsNeu.HelpContexts[I];
      Hints[I] := ItemsNeu.Hints[I];
    end;
  finally
    {Es kann sich die Hhe der Eintrge ndern}
    IF Assigned(FComboBox) THEN FComboBox.CalculateItemHeight;
    EndUpdate;
  end;
end;

procedure TPieComboBoxStrings.Assign(Source: TPersistent);
begin
  if Source is TPieComboBoxStrings then begin
    BeginUpdate;
    try
      Clear;
      AddItems(TPieComboBoxStrings(Source));
    finally
      EndUpdate;
    end;
    Exit;
  end;
  inherited Assign(Source);
end;

procedure TPieComboBoxStrings.Changed;
begin
  if Assigned(FOnChange) then FOnChange(Self);
end;

procedure TPieComboBoxStrings.Changing;
begin
  if Assigned(FOnChanging) then FOnChanging(Self);
end;

procedure TPieComboBoxStrings.Clear;
begin
  if FCount <> 0 then begin
    Changing;
    Finalize(FList^[0], FCount);
    FCount := 0;
    SetCapacity(0);
    SendMessage(FComboBox.Handle, CB_RESETCONTENT, 0, 0);
    Changed;
  end;
end;

procedure TPieComboBoxStrings.DefineProperties(Filer: TFiler);

  function DoWrite: Boolean;
  begin
    if Filer.Ancestor <> nil then begin
      Result := True;
      if Filer.Ancestor is TPieComboBoxStrings then
        Result := not Equals(TPieComboBoxStrings(Filer.Ancestor))
    end
    else Result := Count > 0;
  end;

  function DoBitmapWrite: Boolean;
  begin
    if Filer.Ancestor <> nil then begin
      Result := True;
      if Filer.Ancestor is TPieComboBoxStrings then
        Result := TRUE;
    end
    else Result := Count > 0;
  end;

begin
  Filer.DefineProperty('PieComboBoxStrings', ReadData, WriteData, DoWrite);
  Filer.DefineBinaryProperty('PieComboBoxBitmaps', ReadBitmapData, WriteBitmapData, DoBitmapWrite);
end;

procedure TPieComboBoxStrings.Delete(Index: Integer);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;
  Finalize(FList^[Index]);
  Dec(FCount);
  if Index < FCount then
    System.Move(FList^[Index + 1], FList^[Index],
      (FCount - Index) * SizeOf(TPieComboBoxItem));
  SendMessage(FComboBox.Handle, CB_DELETESTRING, Index, 0);
  Changed;
end;

procedure TPieComboBoxStrings.Exchange(Index1, Index2: Integer);
begin
  if (Index1 < 0) or (Index1 >= FCount) then Error(SListIndexError, Index1);
  if (Index2 < 0) or (Index2 >= FCount) then Error(SListIndexError, Index2);
  Changing;
  ExchangeItems(Index1, Index2);
  Changed;
end;

procedure TPieComboBoxStrings.ExchangeItems(Index1, Index2: Integer);
var
  Temp: Integer;
  Item1, Item2: PPieComboBoxItem;
begin
  Item1 := @FList^[Index1];
  Item2 := @FList^[Index2];
  Temp := Integer(Item1^.FString);
  Integer(Item1^.FString) := Integer(Item2^.FString);
  Integer(Item2^.FString) := Temp;
  Temp := Integer(Item1^.FPieComboBoxEintrag);
  Integer(Item1^.FPieComboBoxEintrag) := Integer(Item2^.FPieComboBoxEintrag);
  Integer(Item2^.FPieComboBoxEintrag) := Temp;
  Temp := Integer(Item1^.FObject);
  Integer(Item1^.FObject) := Integer(Item2^.FObject);
  Integer(Item2^.FObject) := Temp;
end;

function TPieComboBoxStrings.Find(const S: string; var Index: Integer): Boolean;
var
  L, H, I, C: Integer;
begin
  Result := False;
  L := 0;
  H := FCount - 1;
  while L <= H do
  begin
    I := (L + H) shr 1;
    C := AnsiCompareText(FList^[I].FString, S);
    if C < 0 then L := I + 1 else
    begin
      H := I - 1;
      if C = 0 then
      begin
        Result := True;
        if Duplicates <> dupAccept then L := I;
      end;
    end;
  end;
  Index := L;
end;

function TPieComboBoxStrings.Get(Index: Integer): string;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Result := FList^[Index].FString;
end;

function TPieComboBoxStrings.GetObject(Index: Integer): TObject;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Result := FList^[Index].FObject;
end;

function TPieComboBoxStrings.GetCapacity: Integer;
begin
  Result := FCapacity;
end;

function TPieComboBoxStrings.GetCount: Integer;
begin
  Result := FCount;
end;

function TPieComboBoxStrings.GetBitmap(Index: Integer): TBitmap;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  IF Assigned(FList^[Index].FPieComboBoxEintrag)
    THEN Result := FList^[Index].FPieComboBoxEintrag.FBitmap
    ELSE Result := NIL;
end;

function TPieComboBoxStrings.GetColor(Index: Integer): TColor;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Result := FList^[Index].FPieComboBoxEintrag.FColor;
end;

function TPieComboBoxStrings.GetFont(Index: Integer): TFont;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  IF Assigned(FList^[Index].FPieComboBoxEintrag)
    THEN Result := FList^[Index].FPieComboBoxEintrag.FFont
    ELSE Result := NIL;
end;

function TPieComboBoxStrings.GetHelpContext(Index: Integer): THelpContext;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Result := FList^[Index].FPieComboBoxEintrag.FHelpContext;
end;

function TPieComboBoxStrings.GetHint(Index: Integer): string;
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Result := FList^[Index].FPieComboBoxEintrag.FHint;
end;

procedure TPieComboBoxStrings.Grow;
var
  Delta: Integer;
begin
  if FCapacity > 64 then Delta := FCapacity div 4 else
    if FCapacity > 8 then Delta := 16 else
      Delta := 4;
  SetCapacity(FCapacity + Delta);
end;

function TPieComboBoxStrings.IndexOf(const S: string): Integer;
begin
  if not Sorted then Result := inherited IndexOf(S) else
    if not Find(S, Result) then Result := -1;
end;

procedure TPieComboBoxStrings.Insert(Index: Integer; const S: string);
begin
  if Sorted then Error(SSortedListError, 0);
  if (Index < 0) or (Index > FCount) then Error(SListIndexError, Index);
  InsertItem(Index, S);
end;

procedure TPieComboBoxStrings.InsertItem(Index: Integer; const S: string);
VAR
  I: Integer;
begin
  Changing;
  IF Assigned(FComboBox) THEN I := FComboBox.ItemIndex ELSE I := 0;
  if FCount = FCapacity then Grow;
  if Index < FCount then System.Move(FList^[Index],
    FList^[Index+1], (FCount-Index)*SizeOf(TPieComboBoxItem));
 {!!!} Initialize(FList^[Index]);
  with FList^[Index] do begin
    FString := S;
    FPieComboBoxEintrag := TPieComboBoxEintrag.Create;
    FPieComboBoxEintrag.FBitmap := NIL;
    FPieComboBoxEintrag.FFont := NIL;
    FPieComboBoxEintrag.FColor := clWindow;
    FPieComboBoxEintrag.FHelpContext := 0;
    FPieComboBoxEintrag.FHint := '';
    FObject := NIL;
  end;
  Inc(FCount);
  IF Assigned(FComboBox) AND
     (SendMessage(FComboBox.Handle, CB_INSERTSTRING, Index, Longint(PChar(S))) < 0) then
       raise EOutOfResources.Create(SInsertLineError);
  IF Assigned(FComboBox) THEN FComboBox.ItemIndex := I;
  {Es kann sich die Hhe der Eintrge ndern}
  IF Assigned(FComboBox) THEN FComboBox.CalculateItemHeight;
  Changed;
end;

procedure TPieComboBoxStrings.Put(Index: Integer; const S: string);
var
  I: Integer;
begin
  if Sorted then Error(SSortedListError, 0);
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;
  {!!}I := FComboBox.ItemIndex;
  FList^[Index].FString := S;
  {!!} SendMessage(FComboBox.Handle, CB_DELETESTRING, Index, 0);
  {!!} SendMessage(FComboBox.Handle, CB_INSERTSTRING, Index, Longint(PChar(S)));
  {!!}FComboBox.ItemIndex := I;
  Changed;
end;

procedure TPieComboBoxStrings.PutObject(Index: Integer; AObject: TObject);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;
  FList^[Index].FObject := AObject;
  Changed;
end;

procedure TPieComboBoxStrings.QuickSort(L, R: Integer);
var
  I, J: Integer;
  P: string;
begin
  repeat
    I := L;
    J := R;
    P := FList^[(L + R) shr 1].FString;
    repeat
      while AnsiCompareText(FList^[I].FString, P) < 0 do Inc(I);
      while AnsiCompareText(FList^[J].FString, P) > 0 do Dec(J);
      if I <= J then
      begin
        ExchangeItems(I, J);
        Inc(I);
        Dec(J);
      end;
    until I > J;
    if L < J then QuickSort(L, J);
    L := I;
  until I >= R;
end;

procedure TPieComboBoxStrings.ReadBitmapData(Stream: TStream);
VAR
  I: Integer;
  Buffer: char;
  Bmp: TBitmap;
begin
  BeginUpdate;
  try
    for I := 0 to Count - 1 do begin
      Stream.ReadBuffer(Buffer, 1);
      IF Buffer = 'Y' THEN BEGIN
        Bmp := TBitmap.Create;
        TRY
          Bmp.LoadFromStream(Stream);
          IF NOT Assigned(FList[I].FPieComboBoxEintrag.FBitmap) THEN FList[I].FPieComboBoxEintrag.FBitmap := TBitmap.Create;
          FList[I].FPieComboBoxEintrag.FBitmap.Assign(Bmp);
        FINALLY
          Bmp.Free;
        END;
      END;
    end;
  finally
    {Es kann sich die Hhe der Eintrge ndern}
    IF Assigned(FComboBox) THEN FComboBox.CalculateItemHeight;
    EndUpdate;
  end;
end;

procedure TPieComboBoxStrings.ReadData(Reader: TReader);
VAR
  E: TPieComboBoxEintrag;
  I: Integer;
begin
  Reader.ReadListBegin;
  BeginUpdate;
  try
    Clear;
    while not Reader.EndOfList do begin
      I := Add(Reader.ReadString);
      E := TPieComboBoxEintrag.Create;
      TRY
        E.FBitmap := NIL;
        E.FFont := NIL;
        E.FColor := Reader.ReadInteger;
        E.FHelpContext := Reader.ReadInteger;
        E.FHint := Reader.ReadString;
        IF Reader.ReadBoolean THEN BEGIN {Spezial-Font?}
          E.FFont := TFont.Create;
          E.FFont.Name := Reader.ReadString;
          E.FFont.CharSet := Reader.ReadInteger;
          E.FFont.Color := Reader.ReadInteger;
          E.FFont.Height := Reader.ReadInteger;
          E.FFont.Pitch := TFontPitch(Reader.ReadInteger);
          E.FFont.Style := [];
          IF Reader.ReadBoolean THEN E.FFont.Style := E.FFont.Style + [fsBold];
          IF Reader.ReadBoolean THEN E.FFont.Style := E.FFont.Style + [fsItalic];
          IF Reader.ReadBoolean THEN E.FFont.Style := E.FFont.Style + [fsUnderline];
          IF Reader.ReadBoolean THEN E.FFont.Style := E.FFont.Style + [fsStrikeOut];
        END ELSE E.FFont := NIL;
        FList[I].FPieComboBoxEintrag.Assign(E);
      FINALLY
        E.Free;
      END;
    END;
  finally
    {Es kann sich die Hhe der Eintrge ndern}
    IF Assigned(FComboBox) THEN FComboBox.CalculateItemHeight;
    EndUpdate;
  end;
  Reader.ReadListEnd;
end;

procedure TPieComboBoxStrings.SetCapacity(NewCapacity: Integer);
begin
  ReallocMem(FList, NewCapacity * SizeOf(TPieComboBoxItem));
  FCapacity := NewCapacity;
end;

procedure TPieComboBoxStrings.SetBitmap(Index: Integer; ABitmap: TBitmap);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;

  IF Assigned(ABitmap) THEN BEGIN
    IF NOT Assigned(FList^[Index].FPieComboBoxEintrag.FBitmap)
      THEN FList^[Index].FPieComboBoxEintrag.FBitmap := TBitmap.Create;
    FList^[Index].FPieComboBoxEintrag.FBitmap.Assign(ABitmap);
  END
  ELSE IF Assigned(FList^[Index].FPieComboBoxEintrag.FBitmap) THEN BEGIN
    FList^[Index].FPieComboBoxEintrag.FBitmap.Free;
    FList^[Index].FPieComboBoxEintrag.FBitmap := NIL;
  END;

  {Es kann sich die Hhe der Eintrge ndern}
  IF Assigned(FComboBox) THEN FComboBox.CalculateItemHeight;
  Changed;
end;

procedure TPieComboBoxStrings.SetColor(Index: Integer; AColor: TColor);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;
  FList^[Index].FPieComboBoxEintrag.FColor := AColor;
  FComboBox.Repaint;
  Changed;
end;

procedure TPieComboBoxStrings.SetFont(Index: Integer; AFont: TFont);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;

  IF Assigned(AFont) THEN BEGIN
    IF NOT Assigned(FList^[Index].FPieComboBoxEintrag.FFont)
      THEN FList^[Index].FPieComboBoxEintrag.FFont := TFont.Create;
    FList^[Index].FPieComboBoxEintrag.FFont.Assign(AFont);
  END
  ELSE IF Assigned(FList^[Index].FPieComboBoxEintrag.FFont) THEN BEGIN
    FList^[Index].FPieComboBoxEintrag.FFont.Free;
    FList^[Index].FPieComboBoxEintrag.FFont := NIL;
  END;

  {Es kann sich die Hhe der Eintrge ndern}
  IF Assigned(FComboBox) THEN FComboBox.CalculateItemHeight;
  Changed;
end;

procedure TPieComboBoxStrings.SetHelpContext(Index: Integer; AHelpContext: THelpContext);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;

  FList^[Index].FPieComboBoxEintrag.FHelpContext := AHelpContext;

  Changed;
end;

procedure TPieComboBoxStrings.SetHint(Index: Integer; AHint: string);
begin
  if (Index < 0) or (Index >= FCount) then Error(SListIndexError, Index);
  Changing;

  FList^[Index].FPieComboBoxEintrag.FHint := AHint;

  Changed;
end;

procedure TPieComboBoxStrings.SetSorted(Value: Boolean);
begin
  if FSorted <> Value then
  begin
    if Value then Sort;
    FSorted := Value;
  end;
end;

procedure TPieComboBoxStrings.SetUpdateState(Updating: Boolean);
begin
  if Updating then Changing else Changed;

(*{!!} SendMessage(FComboBox.Handle, WM_SETREDRAW, Ord(not Updating), 0);
{!!} if not Updating then FComboBox.Refresh;*)
end;

procedure TPieComboBoxStrings.Sort;
begin
  if not Sorted and (FCount > 1) then
  begin
    Changing;
    QuickSort(0, FCount - 1);
    Changed;
  end;
end;

procedure TPieComboBoxStrings.WriteBitmapData(Stream: TStream);
var
  I: Integer;
  E: TPieComboBoxEintrag;
  Buffer: char;
begin
  for I := 0 to Count - 1 do begin
    E := FList[I].FPieComboBoxEintrag;
    IF Assigned(E.FBitmap) AND NOT(E.FBitmap.Empty) THEN Buffer := 'Y' ELSE Buffer := 'N';
    Stream.WriteBuffer(Buffer, 1);
    IF Assigned(E.FBitmap) AND NOT(E.FBitmap.Empty) THEN E.FBitmap.SaveToStream(Stream);
  end;
end;

procedure TPieComboBoxStrings.WriteData(Writer: TWriter);
var
  I: Integer;
  E: TPieComboBoxEintrag;
begin
  Writer.WriteListBegin;
  for I := 0 to Count - 1 do begin
    Writer.WriteString(Get(I));
    E := FList[I].FPieComboBoxEintrag;
    Writer.WriteInteger(E.FColor);
    Writer.WriteInteger(E.FHelpContext);
    Writer.WriteString(E.FHint);
    Writer.WriteBoolean(Assigned(E.FFont));
    {nderung!}
    IF Assigned(E.FFont) THEN BEGIN
      Writer.WriteString(E.FFont.Name);
      Writer.WriteInteger(E.FFont.CharSet);
      Writer.WriteInteger(E.FFont.Color);
      Writer.WriteInteger(E.FFont.Height);
      Writer.WriteInteger(Integer(E.FFont.Pitch));
      Writer.WriteBoolean(fsBold IN E.FFont.Style);
      Writer.WriteBoolean(fsItalic IN E.FFont.Style);
      Writer.WriteBoolean(fsUnderline IN E.FFont.Style);
      Writer.WriteBoolean(fsStrikeOut IN E.FFont.Style);
    END;
    {nderung!}
  end;
  Writer.WriteListEnd;
end;

{******************************************************}
{******************************************************}
{******************************************************}

procedure TPieComboBox.Edit_aufrufen;
var
  D : TPieComboBoxItemsfenster;
begin
  D := TPieComboBoxItemsfenster.Create(Application);
  try
    CopyProp(D.ComboBox, self);
    if D.ShowModal = mrOK then
      CopyProp(self, D.ComboBox);
  finally
    D.Free;
  end;
end;

procedure TPieComboBox.CopyProp(Dest, Source: TPieComboBox);
BEGIN
  Dest.Items.Assign(Source.Items);
  Dest.Font.Assign(Source.Font);
  Dest.HeaderSections.Assign(Source.HeaderSections);
  Dest.HeaderFont.Assign(Source.HeaderFont);
  Dest.BackGround.Assign(Source.BackGround);
  Dest.BackGroundStyle := Source.BackGroundStyle;
  Dest.LineByTabStops  := Source.LineByTabStops;
  Dest.BitmapStyle     := Source.BitmapStyle;
  Dest.ItemHeightStyle := Source.ItemHeightStyle;
  Dest.Alignment       := Source.Alignment;
  Dest.AnyColors       := Source.AnyColors;
  Dest.AnyFonts        := Source.AnyFonts;
  Dest.Color           := Source.Color;
  Dest.HelpContext     := Source.HelpContext;
  Dest.Hint            := Source.Hint;
  Dest.ShowHeader      := Source.ShowHeader;
  Dest.HeaderStyle     := Source.HeaderStyle;
  Dest.BoldStyle       := Source.BoldStyle;
END;

{******************************************************}
{******************************************************}
{******************************************************}
{ TPieComboBox }

constructor TPieComboBox.Create(AOwner: TComponent);
const
  ComboBoxStyle = [csCaptureMouse, csSetCaption, csDoubleClicks,
    csFixedHeight, csReflector];
begin
  inherited Create(AOwner);
  if NewStyleControls then
    ControlStyle := ComboBoxStyle else
    ControlStyle := ComboBoxStyle + [csFramed];
  Width := 145;
  Height := 25;
  TabStop := True;
  ParentColor := False;
  FItems := TPieComboBoxStrings.Create(Self);
  FCanvas := TControlCanvas.Create;
  FBackground := TPicture.Create;
  FBackground.OnChange := BackgroundChange;
  FBackGroundStyle := bgscNone;
  FHeader := THeaderControl.Create(Self);
  FHeader.Visible := FALSE;
  FHeader.Align := alNone;
  FHeader.OnSectionResize := HeaderSectionResize;
  FHeader.OnDrawSection := HeaderDrawSection;
  FShowHeader := FALSE;
  FItemHeight := 16;
  FEditInstance := MakeObjectInstance(EditWndProc);
  FListInstance := MakeObjectInstance(ListWndProc);
  FEditFontIntern := TFont.Create;
  FDropDownCount := 8;
  FAlignment := taLeftJustify;
  FAnyColors := TRUE;
  FAnyFonts := TRUE;
  FItemHeightStyle := ihcFix;
  FBitmapStyle := bscLeft;
  FBoldStyle := FALSE;
  FStyle := csSimple;
  FLineByTabStops := FALSE;
  FVersion := '1.1';
end;

destructor TPieComboBox.Destroy;
begin
  if HandleAllocated then DestroyWindowHandle;
  FreeObjectInstance(FListInstance);
  FreeObjectInstance(FEditInstance);
  FEditFontIntern.Free;
  FCanvas.Free;
  FItems.Free;
  FSaveItems.Free;
  FBackground.Free;
  inherited Destroy;
end;

procedure TPieComboBox.Clear;
begin
  SetTextBuf('');
  FItems.Clear;
end;

procedure TPieComboBox.SelectAll;
begin
  SendMessage(Handle, CB_SETEDITSEL, 0, (-1 SHL 16));
end;

function TPieComboBox.GetDroppedDown: Boolean;
begin
  Result := LongBool(SendMessage(Handle, CB_GETDROPPEDSTATE, 0, 0));
end;

procedure TPieComboBox.SetDroppedDown(Value: Boolean);
begin
  SendMessage(Handle, CB_SHOWDROPDOWN, Longint(Value), 0);
end;

function TPieComboBox.GetItemIndex: Integer;
begin
  Result := SendMessage(Handle, CB_GETCURSEL, 0, 0);
end;

procedure TPieComboBox.SetItemIndex(Value: Integer);
begin
  SendMessage(Handle, CB_SETCURSEL, Value, 0);
end;

function TPieComboBox.GetSelStart: Integer;
begin
  SendMessage(Handle, CB_GETEDITSEL, Longint(@Result), 0);
end;

procedure TPieComboBox.SetSelStart(Value: Integer);
var
  Selection: TSelection;
begin
  Selection.StartPos := Value;
  Selection.EndPos := Value;
  SendMessage(Handle, CB_SETEDITSEL, 0, MakeLParam(Selection.StartPos,
    Selection.EndPos));
end;

function TPieComboBox.GetSelLength: Integer;
var
  Selection: TSelection;
begin
  SendMessage(Handle, CB_GETEDITSEL, Longint(@Selection.StartPos),
    Longint(@Selection.EndPos));
  Result := Selection.EndPos - Selection.StartPos;
end;

procedure TPieComboBox.SetSelLength(Value: Integer);
var
  Selection: TSelection;
begin
  SendMessage(Handle, CB_GETEDITSEL, Longint(@Selection.StartPos),
    Longint(@Selection.EndPos));
  Selection.EndPos := Selection.StartPos + Value;
  SendMessage(Handle, CB_SETEDITSEL, 0, MakeLParam(Selection.StartPos,
    Selection.EndPos));
end;

function TPieComboBox.GetSelText: string;
begin
  Result := '';
  if FStyle < csDropDownList then
    Result := Copy(Text, GetSelStart + 1, GetSelLength);
end;

procedure TPieComboBox.SetSelText(const Value: string);
begin
  if FStyle < csDropDownList then
  begin
    HandleNeeded;
    SendMessage(FEditHandle, EM_REPLACESEL, 0, Longint(PChar(Value)));
  end;
end;

procedure TPieComboBox.SetMaxLength(Value: Integer);
begin
  if Value < 0 then Value := 0;
  if FMaxLength <> Value then
  begin
    FMaxLength := Value;
    if HandleAllocated then SendMessage(Handle, CB_LIMITTEXT, Value, 0);
  end;
end;

procedure TPieComboBox.SetSorted(Value: Boolean);
begin
  if FSorted <> Value then
  begin
    FSorted := Value;
    RecreateWnd;
  end;
end;

procedure TPieComboBox.SetStyle(Value: TComboBoxStyle);
VAR
  Index: Integer;
begin
  if FStyle <> Value then
  begin
    FStyle := Value;
    Index := Perform(CB_GETCURSEL, 0, 0);
    if Value = csSimple then
      ControlStyle := ControlStyle - [csFixedHeight] else
      ControlStyle := ControlStyle + [csFixedHeight];
    RecreateWnd;
    Perform(CB_SETCURSEL, Index, 0);
  end;
end;

function TPieComboBox.GetItemHeight: Integer;
begin
  if FStyle in [csOwnerDrawFixed, csOwnerDrawVariable] then
    Result := FItemHeight else
    Result := Perform(CB_GETITEMHEIGHT, -1, 0);
end;

procedure TPieComboBox.SetItemHeight(Value: Integer);
begin
  if Value > 0 then BEGIN
    FItemHeight := Value;
    Perform(CB_SETITEMHEIGHT, -1, FItemHeight);
  END;
end;

procedure TPieComboBox.SetItems(Value: TPieComboBoxStrings);
begin
  Items.Assign(Value);
end;

procedure TPieComboBox.CreateParams(var Params: TCreateParams);
const
  ComboBoxStyles: array[TComboBoxStyle] of Integer = (
    CBS_DROPDOWN or CBS_OWNERDRAWVARIABLE,
    CBS_SIMPLE or CBS_OWNERDRAWVARIABLE,
    CBS_DROPDOWNLIST or CBS_OWNERDRAWVARIABLE,
    CBS_DROPDOWNLIST or CBS_OWNERDRAWFIXED,
    CBS_DROPDOWNLIST or CBS_OWNERDRAWVARIABLE);
  Sorts: array[Boolean] of Integer = (0, CBS_SORT);
begin
  inherited CreateParams(Params);
  CreateSubClass(Params, 'COMBOBOX');
  with Params do
  begin
    Style := Style or (WS_VSCROLL or CBS_HASSTRINGS or CBS_AUTOHSCROLL) or
      word(ComboBoxStyles[FStyle]) or word(Sorts[FSorted]);
    if NewStyleControls and Ctl3D then
      ExStyle := ExStyle or WS_EX_CLIENTEDGE;
    if ShowHeader then Style := Style or LBS_USETABSTOPS;
  end;
end;

procedure TPieComboBox.CreateWnd;
var
  ChildHandle: THandle;
begin
  inherited CreateWnd;
  IF FHeader.Parent = NIL THEN BEGIN
    FHeader.Parent := Parent;
    FHeader.Name := Name + 'Header';
  END;
  SendMessage(Handle, CB_LIMITTEXT, FMaxLength, 0);
  if FSaveItems <> nil then
  begin
    FItems.Assign(FSaveItems);
    FSaveItems.Free;
    FSaveItems := nil;
  end;
  FEditHandle := 0;
  FListHandle := 0;
  if FStyle in [csDropDown, csSimple] then
  begin
    ChildHandle := GetWindow(Handle, GW_CHILD);
    if ChildHandle <> 0 then
    begin
      if FStyle = csSimple then
      begin
        FListHandle := ChildHandle;
        FDefListProc := Pointer(GetWindowLong(FListHandle, GWL_WNDPROC));
        SetWindowLong(FListHandle, GWL_WNDPROC, Longint(FListInstance));
        ChildHandle := GetWindow(ChildHandle, GW_HWNDNEXT);
      end;
      FEditHandle := ChildHandle;
      FDefEditProc := Pointer(GetWindowLong(FEditHandle, GWL_WNDPROC));
      SetWindowLong(FEditHandle, GWL_WNDPROC, Longint(FEditInstance));
    end;
  end;
  if NewStyleControls and (FEditHandle <> 0) then
    SendMessage(FEditHandle, EM_SETMARGINS, EC_LEFTMARGIN or EC_RIGHTMARGIN, 0);
end;

procedure TPieComboBox.DestroyWnd;
begin
  if FItems.Count > 0 then
  begin
    FSaveItems := TPieComboBoxStrings.Create(Self);
    FSaveItems.Assign(FItems);
  end;
  inherited DestroyWnd;
end;

PROCEDURE TPieComboBox.Loaded;
VAR
  I: Integer;
BEGIN
  IF FHeader.Parent = NIL THEN BEGIN
    FHeader.Parent := Parent;
    FHeader.Name := Name+'Header';
  END;
  inherited Loaded;
  FOR I:=0 TO FHeader.Sections.Count-1 DO FHeader.Sections[I].Style := hsOwnerDraw;
END;

procedure TPieComboBox.CalculateItemHeight;
VAR
  Index, AHeight: Integer;
begin
  {Es kann sich die Hhe der Eintrge ndern}
  FOR Index:=0 TO Items.Count-1 DO BEGIN
    MeasureItem(Index, AHeight);
    Perform(CB_SETITEMHEIGHT, Index, AHeight);
  END;
end;

procedure TPieComboBox.SetBackground(Value: TPicture);
BEGIN
  FBackground.Assign(Value);
  Invalidate;
END;

procedure TPieComboBox.BackgroundChange(Sender: TObject);
BEGIN
  Invalidate;
END;

procedure TPieComboBox.SetBackGroundStyle(Value: TBackGroundStyle);
BEGIN
  IF Value <> FBackGroundStyle THEN BEGIN
    FBackGroundStyle := Value;
    Invalidate;
  END;
END;

procedure TPieComboBox.WMMove(var Message: TWMMove);
begin
  inherited;
  IF ShowHeader
    THEN FHeader.SetBounds(Left, Top-FHeader.Height, Width, FHeader.Height);
end;

procedure TPieComboBox.WMSize(var Message: TWMSize);
begin
  inherited;
  IF ShowHeader
    THEN FHeader.SetBounds(Left, Top-FHeader.Height, Width, FHeader.Height);
end;

procedure TPieComboBox.WMCreate(var Message: TWMCreate);
begin
  inherited;
  SetWindowText(Handle, WindowText);
end;

procedure TPieComboBox.WMEraseBkgnd(var Message: TWMEraseBkgnd);
begin
  DefaultHandler(Message);
end;

procedure TPieComboBox.WMPaint(var Message: TWmPaint);
BEGIN
  inherited;
END;

procedure TPieComboBox.PaintBackground(R: TRect; Edit_malen: Boolean);
VAR
  CR: TRect;
  B, H, I, J: Integer;
  P : TPicture;
  Pos1: TRect; {Position des gesamten Pattern im Canvas}
  Pos2: TRect; {Position des darzustellenden Teilpattern im Pattern}
  Malen: Boolean;
  EditDC: HDC;
BEGIN     {TCanvas, Pattern}
  IF Assigned(FBackGround) AND Assigned(FBackGround.Graphic) THEN BEGIN
    P := TPicture.Create;
    TRY
      P.Assign(FBackGround);
      IF Edit_malen
        THEN windows.GetClientRect(FEditHandle, CR)
      ELSE BEGIN
        CR := ClientRect;      {gibt Mae von Edit zurck}
//        CR.Bottom := R.Bottom; {wichtig! Hhe fr Liste anpassen}
      END;
      H := P.Graphic.Height;
      B := P.Graphic.Width;
      IF (H>0) AND (B>0) THEN BEGIN
        CASE FBackGroundStyle OF
{------------------------------------------------------}
        bgscCenter:
          BEGIN
            Pos1 := Rect((CR.Right-CR.Left-B) DIV 2,
                         (CR.Bottom-CR.Top-H) DIV 2,
                         (CR.Right-CR.Left+B) DIV 2,
                         (CR.Bottom-CR.Top+H) DIV 2);

            Malen := (Pos1.Left < R.Right) AND (Pos1.Right > R.Left) AND
                     (Pos1.Top < R.Bottom) AND (Pos1.Bottom > R.Top);

            IF Malen THEN BEGIN
              Pos2 := Rect(R.Left-Pos1.Left, R.Top-Pos1.Top, R.Right-Pos1.Left, R.Bottom-Pos1.Top);
              IF Pos2.Left   < 0 THEN Pos2.Left   := 0;
              IF Pos2.Top    < 0 THEN Pos2.Top    := 0;
              IF Pos2.Right  > B THEN Pos2.Right  := B;
              IF Pos2.Bottom > H THEN Pos2.Bottom := H;

              IF (Pos2.Left > 0) OR (Pos2.Top > 0) THEN
              BitBlt(P.Bitmap.Canvas.Handle, 0, 0,
                    (Pos2.Right-Pos2.Left),
                    (Pos2.Bottom-Pos2.Top),
                     P.Bitmap.Canvas.Handle, Pos2.Left, Pos2.Top,
                     srcCopy);

              P.Graphic.Width := Pos2.Right-Pos2.Left;
              P.Graphic.Height := Pos2.Bottom-Pos2.Top;
              Canvas.Draw(Pos1.Left + Pos2.Left, Pos1.Top  + Pos2.Top, P.Graphic);
            END;
          END;
{------------------------------------------------------}
        bgscStretch:
          BEGIN
            Pos1 := CR;

            Pos2 := Rect(R.Left * B DIV (Pos1.Right-Pos1.Left),
                         R.Top * H DIV (Pos1.Bottom-Pos1.Top),
                         R.Right * B DIV (Pos1.Right-Pos1.Left),
                         R.Bottom * H DIV (Pos1.Bottom-Pos1.Top));

            IF (Pos2.Left > 0) OR (Pos2.Top > 0) THEN
            BitBlt(P.Bitmap.Canvas.Handle, 0, 0,
                  (Pos2.Right-Pos2.Left),
                  (Pos2.Bottom-Pos2.Top),
                   P.Bitmap.Canvas.Handle, Pos2.Left, Pos2.Top,
                   srcCopy);

            P.Graphic.Width := Pos2.Right-Pos2.Left;
            P.Graphic.Height := Pos2.Bottom-Pos2.Top;
            Canvas.StretchDraw(R, P.Graphic);
          END;
{------------------------------------------------------}
        bgscPattern:
          BEGIN
            FOR I := 0 TO ((CR.Right - CR.Left) DIV B) DO
            FOR J := 0 TO ((CR.Bottom - CR.Top) DIV H) DO BEGIN
              Pos1 := Rect(I*B, J*H, (I+1)*B, (J+1)*H);
              Malen := (Pos1.Left < R.Right) AND (Pos1.Right > R.Left) AND
                       (Pos1.Top < R.Bottom) AND (Pos1.Bottom > R.Top);

              IF Malen THEN BEGIN
                Pos2 := Rect(R.Left-I*B, R.Top-J*H, R.Right-I*B, R.Bottom-J*H);
                IF Pos2.Left   < 0 THEN Pos2.Left   := 0;
                IF Pos2.Top    < 0 THEN Pos2.Top    := 0;
                IF Pos2.Right  > B THEN Pos2.Right  := B;
                IF Pos2.Bottom > H THEN Pos2.Bottom := H;

                IF (Pos2.Left > 0) OR (Pos2.Top > 0) THEN
                BitBlt(P.Bitmap.Canvas.Handle, 0, 0,
                      (Pos2.Right-Pos2.Left),
                      (Pos2.Bottom-Pos2.Top),
                       P.Bitmap.Canvas.Handle, Pos2.Left, Pos2.Top,
                       srcCopy);

                P.Graphic.Width := Pos2.Right-Pos2.Left;
                P.Graphic.Height := Pos2.Bottom-Pos2.Top;
                IF Edit_malen THEN BEGIN
                  EditDC := GetDC(EditHandle);
                  TRY
                    BitBlt(EditDC, Pos1.Left + Pos2.Left, Pos1.Top  + Pos2.Top,
                           P.Graphic.Width,
                           P.Graphic.Height,
                           P.Bitmap.Canvas.Handle,
                           0, 0, srcCopy);
                  FINALLY
                    ReleaseDC(EditHandle, EditDC);
                  END;
                END
                ELSE Canvas.Draw(Pos1.Left + Pos2.Left, Pos1.Top  + Pos2.Top, P.Graphic);
                P.Assign(FBackGround);
              END;
            END;
          END;
{------------------------------------------------------}
        END;  {CASE FBackGroundStyle OF ...}
      END;
    FINALLY
      P.Free;
    END;
  END;
END;

procedure TPieComboBox.WMDrawItem(var Message: TWMDrawItem);
begin
  DefaultHandler(Message);
end;

procedure TPieComboBox.WMMeasureItem(var Message: TWMMeasureItem);
begin
  DefaultHandler(Message);
end;

procedure TPieComboBox.WMDeleteItem(var Message: TWMDeleteItem);
begin
  DefaultHandler(Message);
end;

procedure TPieComboBox.WMGetDlgCode(var Message: TWMGetDlgCode);
begin
  inherited;
  if DroppedDown then Message.Result := Message.Result or DLGC_WANTALLKEYS;
end;

procedure TPieComboBox.CMCancelMode(var Message: TCMCancelMode);
begin
  if Message.Sender <> Self then Perform(CB_SHOWDROPDOWN, 0, 0);
end;

procedure TPieComboBox.CMCtl3DChanged(var Message: TMessage);
begin
  if NewStyleControls then RecreateWnd;
  inherited;
end;

procedure TPieComboBox.CMParentColorChanged(var Message: TMessage);
begin
  inherited;
  if not NewStyleControls and (Style < csDropDownList) then Invalidate;
end;

procedure TPieComboBox.EditWndProc(var Message: TMessage);
var
  P: TPoint;
  Form: TCustomForm;
begin
  if Message.Msg = WM_SYSCOMMAND then
  begin
    WndProc(Message);
    Exit;
  end
  else if (Message.Msg >= WM_KEYFIRST) and (Message.Msg <= WM_KEYLAST) then
  begin
    Form := GetParentForm(Self);
    if (Form <> nil) and Form.WantChildKey(Self, Message) then Exit;
  end;
  IF (Message.Msg = wm_SetText) THEN;
  ComboWndProc(Message, FEditHandle, FDefEditProc); {513, 8, wm_Paint}
  case Message.Msg of
    WM_LBUTTONDOWN, WM_LBUTTONDBLCLK:
      begin
        if DragMode = dmAutomatic then
        begin
          GetCursorPos(P);
          P := ScreenToClient(P);
          SendMessage(FEditHandle, WM_LBUTTONUP, 0,Longint(PointToSmallPoint(P)));
          BeginDrag(False);
        end;
      end;
    WM_SETFONT:
      if NewStyleControls then
        SendMessage(FEditHandle, EM_SETMARGINS, EC_LEFTMARGIN or EC_RIGHTMARGIN, 0);
  end;
end;

procedure TPieComboBox.HeaderDrawSection(HeaderControl: THeaderControl; Section: THeaderSection; const Rect: TRect; Pressed: Boolean);
VAR
  XPos, YPos, ZeichenBreite, Breite{, Bitmapbreite}: Integer;
  R: TRect;
(*  Points: array[0..3] of TPoint;
  {$IFDEF D5_OR_HIGHER}
  DisIndex: Integer;
  Bitmap: TBitmap;
  {$ENDIF}*)
begin
  {normale Einstellungen}
  XPos := Rect.Left + FHeader.Canvas.Font.Size;
  YPos := Rect.Top + 2;
  ZeichenBreite := FHeader.Canvas.TextWidth('x');
  R.Top := Rect.Top; R.Bottom := Rect.Bottom;
  FHeader.Canvas.Brush.Color := clBtnFace;

  {Besonderheiten, wenn gedrckt}
  IF Pressed THEN BEGIN
    inc(XPos);
    inc(YPos);
  END;

(*  {Besonderheiten, wenn Sortierspalte}
  IF FSorted AND (Section.Index = FSortColumn) THEN XPos := XPos + 8;

  {Besonderheiten, wenn Images}
  Bitmapbreite := 0;
  {$IFDEF D5_OR_HIGHER}
  IF Assigned(FHeader.Images) AND (Section.ImageIndex >= 0) AND
                                  (Section.ImageIndex < FHeader.Images.Count) THEN BEGIN
    Bitmap := TBitmap.Create;
    TRY
      FHeader.Images.GetBitmap(Section.ImageIndex, Bitmap);
      Bitmap.Transparent := TRUE;
      IF NOT FHeader.Enabled THEN BEGIN
        DisIndex := DisableGlyph(Bitmap, 0);
        ImageList_DrawEx(FMaskedImageList.Handle, DisIndex, FHeader.Canvas.Handle, XPos, R.Top, 0, 0,
          ColorToRGB(clBtnFace), clNone, ILD_Normal);
      END
      ELSE FHeader.Canvas.StretchDraw(Classes.Rect(XPos, R.Top, XPos+Bitmap.Width, R.Bottom), Bitmap);
      Bitmapbreite := Bitmap.Width + 2;{2 Pixel Abstand zwischen Bitmap und Text}
    FINALLY
      Bitmap.Free;
    END;
    XPos := XPos + Bitmapbreite;
  END;
  {$ENDIF}*)

  {Text zeichnen}
  Breite := FHeader.Canvas.TextWidth(Section.Text);
  IF NOT FHeader.Enabled THEN FHeader.Canvas.Font.Color := clGrayText;
  IF (Breite < (Rect.Right-XPos-2)) THEN BEGIN
    R.Left := XPos;
    R.Right := Rect.Right-1;
    FHeader.Canvas.TextRect(R, R.Left, YPos, Section.Text);
  END
  ELSE BEGIN
    R.Left := XPos;
    R.Right := Rect.Right-1-3*ZeichenBreite;
    IF (R.Right > R.Left) THEN FHeader.Canvas.TextRect(R, R.Left, YPos, Section.Text);
    R.Left := R.Right+2;
    R.Right := Rect.Right-1;
    IF (R.Left > Rect.Left)
      THEN FHeader.Canvas.TextRect(R, R.Left, YPos, '...')
      {wenn nicht mal mehr Punkte hinpassen --> grau ausfllen}
      ELSE FHeader.Canvas.FillRect(Rect);
  END;

(*  {Besonderheiten, wenn Sortierspalte}
  {blaues Dreieck malen}
  IF FSorted AND (Section.Index = FSortColumn) AND (Rect.Right - Rect.Left > Bitmapbreite) THEN BEGIN
    XPos := Rect.Left + 5;
    YPos := 6;

    {Besonderheiten, wenn gedrckt}
    IF Pressed THEN BEGIN
      inc(XPos);
      inc(YPos);
    END;

    IF FSortUp THEN BEGIN
      Points[0] := Point(XPos,YPos);
      Points[1] := Point(XPos+7,YPos);
      Points[2] := Point(XPos+3,YPos+7);
      Points[3] := Point(XPos,YPos);
    END
    ELSE BEGIN
      Points[0] := Point(XPos,YPos+7);
      Points[1] := Point(XPos+7,YPos+7);
      Points[2] := Point(XPos+3,YPos);
      Points[3] := Point(XPos,YPos+7);
    END;

    FHeader.Canvas.Polygon(Points);
    FHeader.Canvas.Brush.Color := clBlue;
    FHeader.Canvas.FloodFill(XPos+3, YPos+5, clBlack, fsBorder);
  END;*)
end;

procedure TPieComboBox.ListWndProc(var Message: TMessage);
begin
  ComboWndProc(Message, FListHandle, FDefListProc);
end;

procedure TPieComboBox.ComboWndProc(var Message: TMessage; ComboWnd: HWnd;
  ComboProc: Pointer);
var
  Point: TPoint;
  Form: TCustomForm;
  ST: TShiftState;
begin
  try
    with Message do
    begin
      case Msg of
        WM_SETFOCUS:
          begin
            Form := GetParentForm(Self);
            if (Form <> nil) and not Form.SetFocusedControl(Self) then Exit;
          end;
        WM_KILLFOCUS:
          if csFocusing in ControlState then Exit;
        WM_KEYDOWN, WM_SYSKEYDOWN:
          if (ComboWnd <> FListHandle) and DoKeyDown(TWMKey(Message)) then
            Exit;
        WM_CHAR:
          begin
            if DoKeyPress(TWMKey(Message)) then Exit;
            if ((TWMKey(Message).CharCode = VK_RETURN) or
              (TWMKey(Message).CharCode = VK_ESCAPE)) and DroppedDown then
            begin
              DroppedDown := False;
              Exit;
            end;
          end;
        WM_KEYUP, WM_SYSKEYUP:
          if DoKeyUp(TWMKey(Message)) then Exit;
        WM_MOUSEMOVE: IF NOT(Dragging) THEN UpdateHint(-1);
        WM_LBUTTONUP: IF assigned(OnDragDrop) THEN OnDragDrop(Self, Self, LoWord(LParam), HiWord(LParam));
        WM_LBUTTONDOWN:
          IF assigned(OnMouseDown) THEN BEGIN
            ST := [];
            IF wParam = MK_CONTROL THEN ST := ST + [ssCtrl];
            IF wParam = MK_LBUTTON THEN ST := ST + [ssLeft];
            IF wParam = MK_MBUTTON THEN ST := ST + [ssMiddle];
            IF wParam = MK_RBUTTON THEN ST := ST + [ssRight];
            IF wParam = MK_SHIFT   THEN ST := ST + [ssShift];
            OnMouseDown(self, mbLeft, ST, LoWord(lparam), HiWord(lparam));
          END;
        WM_RBUTTONUP:
          if HasPopup(Self) then
          begin
            with TWMRButtonUp(Message) do
            begin
              Point.X := Pos.X;
              Point.Y := Pos.Y;
              MapWindowPoints(ComboWnd, Handle, Point, 1);
              Pos.X := Point.X;
              Pos.Y := Point.Y;
            end;
            WndProc(Message);
            Exit;
          end;
        WM_GETDLGCODE:
          if DroppedDown then
          begin
            Result := DLGC_WANTALLKEYS;
            Exit;
          end;
        WM_NCHITTEST:
          if csDesigning in ComponentState then
          begin
            Result := HTTRANSPARENT;
            Exit;
          end;
        CN_KEYDOWN, CN_CHAR, CN_SYSKEYDOWN, CN_SYSCHAR:
          begin
            WndProc(Message);
            Exit;
          end;
      end;
      Result := CallWindowProc(ComboProc, ComboWnd, Msg, WParam, LParam);
      if (Msg = WM_LBUTTONDBLCLK) and (csDoubleClicks in ControlStyle) then
        DblClick;
    end;
  except
    Application.HandleException(Self);
  end;
end;

procedure TPieComboBox.WndProc(var Message: TMessage);
begin
    {for auto drag mode, let listbox handle itself, instead of TControl}
  if not (csDesigning in ComponentState) and
     ((Message.Msg = WM_LBUTTONDOWN) or (Message.Msg = WM_LBUTTONDBLCLK)) and
     not Dragging then
  begin
    if DragMode = dmAutomatic then
    begin
      if IsControlMouseMsg(TWMMouse(Message)) then
        Exit;
      ControlState := ControlState + [csLButtonDown];
      Dispatch(Message);  {overrides TControl's BeginDrag}
      Exit;
    end;
  end;
  with Message do
    case Msg of
      WM_CTLCOLORMSGBOX..WM_CTLCOLORSTATIC:
        begin
          SetTextColor(WParam, ColorToRGB(Font.Color));
          SetBkColor(WParam, ColorToRGB(Brush.Color));
          Result := Brush.Handle;{$R+}
          Exit;
        end;
      CN_CTLCOLORMSGBOX..CN_CTLCOLORSTATIC:
        if not NewStyleControls and (Style < csDropDownList) then
        begin
          Result := Parent.Brush.Handle;
          Exit;
        end;
      WM_CHAR:
        begin
          if DoKeyPress(TWMKey(Message)) then Exit;
          if ((TWMKey(Message).CharCode = VK_RETURN) or
            (TWMKey(Message).CharCode = VK_ESCAPE)) and DroppedDown then
          begin
            DroppedDown := False;
            Exit;
          end;
        end;
    end;
  inherited WndProc(Message);
end;

procedure TPieComboBox.AdjustDropDown;
var
  ItemCount: Integer;
begin
  ItemCount := FItems.Count;
  if ItemCount > DropDownCount then ItemCount := DropDownCount;
  if ItemCount < 1 then ItemCount := 1;
  SetWindowPos(Handle, 0, 0, 0, Width, ItemHeight * ItemCount +
    Height + 2, SWP_NOMOVE + SWP_NOZORDER + SWP_NOACTIVATE + SWP_NOREDRAW +
    SWP_HIDEWINDOW);
  SetWindowPos(Handle, 0, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE +
    SWP_NOZORDER + SWP_NOACTIVATE + SWP_NOREDRAW + SWP_SHOWWINDOW);
end;

procedure TPieComboBox.CNCommand(var Message: TWMCommand);
begin
  case Message.NotifyCode of
    CBN_DBLCLK:
      DblClick;
    CBN_EDITCHANGE:
      Change;
    CBN_DROPDOWN:
      begin
        FFocusChanged := False;
        DropDown;
        AdjustDropDown;
        if FFocusChanged then
        begin
          PostMessage(Handle, WM_CANCELMODE, 0, 0);
          if not FIsFocused then PostMessage(Handle, CB_SHOWDROPDOWN, 0, 0);
        end;
      end;
    CBN_SELCHANGE:
      begin
        IF ItemIndex > -1 THEN BEGIN
          Text := Items[ItemIndex];
          Click;
          Change;
        END;
      end;
    CBN_SETFOCUS:
      begin
        FIsFocused := True;
        FFocusChanged := True;
        SetIme;
      end;
    CBN_KILLFOCUS:
      begin
        FIsFocused := False;
        FFocusChanged := True;
        ResetIme;
      end;
  end;
end;

procedure TPieComboBox.Change;
begin
  inherited Changed;
  if Assigned(FOnChange) then FOnChange(Self);
  SetItemProperties;
end;

procedure TPieComboBox.DrawItem(Index: Integer; Rect: TRect;
  State: TOwnerDrawState);
VAR
  C: TColor;
begin
  C := Font.Color;
  case FStyle of
    csDropDown, csSimple: DrawBoldStyle(Index, Rect, State);
    csDropDownList: DrawBoldStyle(Index, Rect, State);
    csOwnerDrawFixed,
    csOwnerDrawVariable: if Assigned(FOnDrawItem) then FOnDrawItem(Self, Index, Rect, State);
  end;
  Font.Color := C;
end;

procedure TPieComboBox.DropDown;
begin
  if Assigned(FOnDropDown) then FOnDropDown(Self);
end;

procedure TPieComboBox.MeasureItem(Index: Integer; var AHeight: Integer);
var
  Metrics: TTextMetric;
  H, B: Integer;
  DC: HDC;
begin
  IF {(FStyle <> csOwnerDraw) AND} (Index >-1) THEN WITH Canvas do begin
    {Standard-hhe}
    DC := GetDC(0);
    TRY
      Canvas.Handle := DC;
      Canvas.Font := Self.Font;
      GetTextMetrics(DC, Metrics);
      {IF Metrics.tmHeight > AHeight THEN} AHeight := Metrics.tmHeight;
      {abweichende Hhe}
      CASE FItemHeightStyle OF
      ihcFix: AHeight := ItemHeight;
      ihcFont  : BEGIN
                 IF FAnyFonts AND Assigned(Items.Fonts[Index])
                   THEN Canvas.Font := Items.Fonts[Index]
                   ELSE Canvas.Font := Self.Font;
                GetTextMetrics(Canvas.Handle, Metrics);
                AHeight := Metrics.tmHeight;
                END;
      ihcBitmap: BEGIN
                IF Assigned(Items.Bitmaps[Index]) AND NOT(Items.Bitmaps[Index].Empty) THEN BEGIN
                  H := Items.Bitmaps[Index].Height;
                  B := Items.Bitmaps[Index].Width;
                  IF Width / B < 1 THEN H := round(Width / B * H);
                  H := H+2; {oben und unten 1 Pixel Abstand lassen}
                  AHeight := H;
                END;
                END;
      ihcFontBitmap: BEGIN
                IF FAnyFonts AND Assigned(Items.Fonts[Index])
                  THEN Canvas.Font := Items.Fonts[Index]
                  ELSE Canvas.Font := Self.Font;
                GetTextMetrics(Canvas.Handle, Metrics);
                AHeight := Metrics.tmHeight;
                IF Assigned(Items.Bitmaps[Index]) AND NOT(Items.Bitmaps[Index].Empty) THEN BEGIN
                  H := Items.Bitmaps[Index].Height;
                  B := Items.Bitmaps[Index].Width;
                  IF Width / B < 1 THEN H := round(Width / B * H);
                  H := H+2; {oben und unten 1 Pixel Abstand lassen}
                  IF H > AHeight THEN AHeight := H;
                END;
                END;
      END;
    FINALLY
    Canvas.Handle := 0;
    ReleaseDC(0, DC);
    END;
  END ELSE if Assigned(FOnMeasureItem) then FOnMeasureItem(Self, Index, AHeight)
end;

procedure TPieComboBox.CNDrawItem(var Message: TWMDrawItem);
var
  State: TOwnerDrawState;
begin
  with Message.DrawItemStruct^ do
  begin
    {$IFDEF D5_OR_HIGHER}
    State := TOwnerDrawState(Word(Message.DrawItemStruct^.ItemState));
    {$ELSE}
    State := TOwnerDrawState(WordRec(LongRec(itemState).Lo).Lo);
    {$ENDIF}
    FCanvas.Handle := hDC;
    FCanvas.Font := Font;
    FCanvas.Brush := Brush;
    if (ItemID < uint(Items.Count)) THEN BEGIN
{      IF (odSelected in State) then  begin
        FCanvas.Brush.Color := clHighlight;
        FCanvas.Font.Color := clHighlightText
      end;}
      DrawItem(itemID, rcItem, State);
    END else FCanvas.FillRect(rcItem);
    if odFocused in State then DrawFocusRect(hDC, rcItem);
    FCanvas.Handle := 0;
  end;
end;

procedure TPieComboBox.CNMeasureItem(var Message: TWMMeasureItem);
begin
  with Message.MeasureItemStruct^ do
  begin
    itemHeight := FItemHeight;
    if FStyle = csOwnerDrawVariable then
      MeasureItem(itemID, Integer(itemHeight));
  end;
end;

procedure TPieComboBox.WMLButtonDown(var Message: TWMLButtonDown);
var
  Form: TCustomForm;
begin
  if (DragMode = dmAutomatic) and (Style = csDropDownList) and
      (Message.XPos < (Width - GetSystemMetrics(SM_CXHSCROLL))) then
  begin
    SetFocus;
    BeginDrag(False);
    Exit;
  end;
  inherited;
  if MouseCapture then
  begin
    Form := GetParentForm(Self);
    if (Form <> nil) and (Form.ActiveControl <> Self) then
      MouseCapture := False;
  end;
end;

function TPieComboBox.DrawItemBitmap(Index: integer; ARect: TRect): TRect;
VAR
  R: TRect;
  H, B, M, I, J: Integer;
  Fak1: Double;
  Bitmap: TBitmap;
begin
  R := Rect(0,0,0,0);
  Bitmap := Items.Bitmaps[Index];
  IF Assigned(Bitmap) THEN BEGIN
    R := ARect;
    dec(R.Bottom);
    inc(R.Top);
    H := Bitmap.Height;
    B := Bitmap.Width;
    IF (H>0) AND (B>0) THEN BEGIN
      IF FBitmapStyle = bscPattern THEN BEGIN
        IF H > (ARect.Bottom - ARect.Top) THEN H := (ARect.Bottom - ARect.Top);
        FOR I := 0 TO ((ARect.Right - ARect.Left) DIV B) DO
        FOR J := 0 TO ((ARect.Bottom - ARect.Top) DIV H)-1 DO BEGIN
          R := Rect(I*B+ARect.Left, J*H+ARect.Top,
                (I+1)*B+ARect.Left, (J+1)*H+ARect.Top);
          Canvas.StretchDraw(R, Bitmap);
        END;
      END
      ELSE BEGIN
        Fak1 := (R.Bottom-R.Top);
        Fak1 := Fak1 / H;
        IF FBitmapStyle = bscLeft THEN BEGIN
          R.Bottom  := R.Top + round(H*Fak1);
          R.Right   := R.Left + round(B*Fak1);
        END;
        IF FBitmapStyle = bscRight THEN BEGIN
          R.Bottom  := R.Top + round(H*Fak1);
          R.Left    := R.Right - round(B*Fak1);
        END;
        IF FBitmapStyle = bscCenter THEN BEGIN
          R.Bottom  := R.Top + round(H*Fak1);
          M         := (R.Right-R.Left) DIV 2;
          R.Left    := M - round(B*Fak1) DIV 2;
          R.Right   := M + round(B*Fak1) DIV 2;
        END;
        IF FBitmapStyle = bscStretch THEN BEGIN
        END;
        Canvas.StretchDraw(R, Items.Bitmaps[Index]);
      END;
    END ELSE R := Rect(R.Left,R.Top,R.Left,R.Top);
  END;
  Result := R;
end;

procedure TPieComboBox.DrawBoldStyle(Index: integer; ARect: TRect; State: TOwnerDrawState);
TYPE
  PInteger = ^Integer;
var  {Art = 0: Normal, 1: BoldStyle}
  I: integer;
  BitmapRect, LastRect: TRect;
  YPos, Breite, Zeichenbreite, TabLinks, TabRechts, Position, B: Integer;
  T, Teil: string;
  R: TRect;
  TM: TextMetric;
begin
{************** Einstellungen vornehmen *******************}
  with Canvas do begin
    {manually set these colors to override the color change when
    the item is focused}
    IF FAnyColors
      THEN Brush.Color := Items.Colors[Index]
      ELSE Brush.Color := Color;
    IF FAnyFonts AND Assigned(Items.Fonts[Index])
      THEN Pen.Color := Items.Fonts[Index].Color
      ELSE Pen.Color := Self.Font.Color;
    IF FAnyFonts AND Assigned(Items.Fonts[Index])
      THEN Font := Items.Fonts[Index]
      ELSE Font := Self.Font;
    IF (FBackGroundStyle = bgscNone) OR
       (FAnyColors AND (Brush.Color <> Color))
       THEN FillRect(ARect)
       ELSE PaintBackground(ARect, FALSE);
    {Bei letztem Index: Hintergrund bis zum Schlu restaurieren}
    IF (FBackGroundStyle <> bgscNone) AND (Style = csSimple) AND (Index = Items.Count-1) THEN BEGIN
      LastRect := ARect;
      LastRect.Top := LastRect.Bottom;
      LastRect.Bottom := ClientRect.Bottom;
      PaintBackground(LastRect, FALSE);
    END;

{*********** Besonderheiten fr selektierte Items **********************************}
    IF odSelected in State THEN BEGIN
      IF FBoldStyle THEN BEGIN
        IF fsBold IN Font.Style
          THEN Font.Style := Font.Style - [fsBold]
          ELSE Font.Style := Font.Style + [fsBold];
      END
      ELSE BEGIN
        Brush.Color := clHighlight;
        Font.Color := clHighlightText;
        FillRect(ARect);
      END;
      {+++ Hint aktualisieren +++}
      UpdateHint(Index);
    END;
  END;

  {*********** Bitmap malen **********************************}
  BitmapRect := DrawItemBitmap(Index, ARect);

  B := 0;
  {************** Text ausgeben ***************************}
  Canvas.Brush.Style := bsClear;
  YPos := ARect.Top + (ARect.Bottom-ARect.Top-Canvas.TextHeight('Gg')) DIV 2;
  IF FShowHeader THEN BEGIN
    ZeichenBreite := Canvas.TextWidth('x');
    T := Items.Strings[Index];
    R.Top := ARect.Top; R.Bottom := ARect.Bottom;
    TabRechts := B;

    FOR I:=0 TO FHeader.Sections.Count-1 DO BEGIN

      {Tab-Positionen in Pixel ermittlen}
      TabLinks := TabRechts + 2;
      TabRechts := TabRechts + FHeader.Sections[I].Width;
      IF I=0 THEN TabRechts := TabRechts - B - 3; {verschobenen FHeader ausgleichen (3 Pixel)}

      {Teilstring ermitteln}
      Position := Pos(#9, T);
      if Position > 0 THEN BEGIN
        Teil := copy(T, 1, Position-1);
        T := copy(T, Position+1, length(T) - Position);
      END
      ELSE BEGIN
        Teil := T;
        T := '';
      END;

      {Teilstring ausgeben}
      GetTextMetrics(Canvas.Handle, TM); {fr Ermittlung des berhanges bei kursiver Schrift}
      Breite := Canvas.TextWidth(Teil) + TM.tmOverhang;
      IF Breite < (TabRechts-2-TabLinks) THEN BEGIN
        CASE FHeader.Sections[I].Alignment OF
        taLeftJustify: R.Left := TabLinks;
        taRightJustify: R.Left := TabRechts-Breite-2;
        taCenter: R.Left := TabLinks + (TabRechts-2-Breite-TabLinks)DIV 2;
        END;
        R.Right := TabRechts-2;
        Canvas.TextRect(R, R.Left, YPos, Teil);
      END
      ELSE BEGIN
        R.Left := TabLinks;
        R.Right := TabRechts-2-3*ZeichenBreite;
        IF R.Right > R.Left THEN Canvas.TextRect(R, R.Left, YPos, Teil);
        R.Left := R.Right+2;
        R.Right := TabRechts-2;
        IF R.Left > TabLinks THEN Canvas.TextRect(R, R.Left, YPos, '...');
      END;

      {Tabellenlinien ausgeben}
      IF FLineByTabStops THEN BEGIN
        Canvas.MoveTo(TabRechts, ARect.Top);
        IF (Style = csSimple) AND (Index = Items.Count-1)
          THEN Canvas.LineTo(TabRechts, Height)
          ELSE Canvas.LineTo(TabRechts, ARect.Bottom);
      END;
    END;
  END  {IF FShowHeader ...}
  ELSE BEGIN
    GetTextMetrics(Canvas.Handle, TM); {fr Ermittlung des berhanges bei kursiver Schrift}
    Breite := Canvas.TextWidth(Items.Strings[Index]) + TM.tmOverhang;
    R.Top := ARect.Top; R.Bottom := ARect.Bottom; R.Left := B+2; R.Right := ARect.Right;
    CASE FAlignment OF
    taLeftJustify: ;
    taRightJustify: R.Left := R.Right-Breite-2;
    taCenter: R.Left := R.Left + (R.Right-2-Breite-R.Left)DIV 2;
    END;
    Canvas.TextRect(R, R.Left, YPos, Items.Strings[Index]);
  END; {IF FShowHeader ...}
  Canvas.Brush.Style := bsSolid;
end;

procedure TPieComboBox.SetItemProperties;
VAR
  EditDC: HDC;
begin
  //nur wenn Style = csSimple oder csDropDown
  //nur wenn gltiger ItemIndex
  IF NOT(Style IN [csSimple, csDropDown]) THEN exit;
  IF ItemIndex < 0 THEN exit;

  EditDC := GetDC(EditHandle);
  TRY
    {$R-}
    IF FAnyFonts AND Assigned(Items.Fonts[ItemIndex])
      THEN FEditFontIntern.Assign(Items.Fonts[ItemIndex])
      ELSE FEditFontIntern.Assign(Font);
    FEditFontIntern.Size := Font.Size;
    FEditFontIntern.Style := FEditFontIntern.Style - [fsBold];
    SendMessage(EditHandle, wm_SetFont, FEditFontIntern.Handle, 1);
    IF FAnyColors
      THEN SelectObject(EditDC, CreateSolidBrush(Items.Colors[ItemIndex]))
      ELSE SelectObject(EditDC, CreateSolidBrush(Color));
  FINALLY
    ReleaseDC(EditHandle, EditDC);
  END;

end;

procedure TPieComboBox.SetAlignment(Value: TAlignment);
begin
  IF Value <> FAlignment THEN BEGIN
    FAlignment := Value;
    IF NOT FShowHeader THEN Invalidate;
  END;
end;

procedure TPieComboBox.SetAnyColors(Value: Boolean);
begin
  IF Value <> FAnyColors THEN BEGIN
    FAnyColors := Value;
    Repaint;
  END;
end;

procedure TPieComboBox.SetAnyFonts(Value: Boolean);
begin
  IF Value <> FAnyFonts THEN BEGIN
    FAnyFonts := Value;
    {Es kann sich die Hhe der Eintrge ndern}
    CalculateItemHeight;
    Repaint;
  END;
end;

procedure TPieComboBox.SetBitmapStyle(AStyle: TBitmapStyle);
begin
  if FBitmapStyle <> AStyle then begin
    FBitmapStyle := AStyle;
    Perform(CB_SETCURSEL, Perform(CB_GETCURSEL, 0, 0), 0);
    Repaint;
  end;
end;

procedure TPieComboBox.SetBoldStyle(AStyle: Boolean);
begin
  if FBoldStyle <> AStyle then begin
    FBoldStyle := AStyle;
    Perform(CB_SETCURSEL, Perform(CB_GETCURSEL, 0, 0), 0);
  end;
end;

procedure TPieComboBox.SetItemHeightStyle(AStyle: TItemHeightStyle);
begin
  if FItemHeightStyle <> AStyle then begin
    FItemHeightStyle := AStyle;
    {Es kann sich die Hhe der Eintrge ndern}
    CalculateItemHeight;
    Repaint;
  end;
end;

procedure TPieComboBox.SetLineByTabStops(Value: Boolean);
begin
  if FLineByTabStops <> Value then begin
    FLineByTabStops := Value;
    Invalidate;
  end;
end;

procedure TPieComboBox.SetHCVisible(Value: Boolean);
begin
  IF Value <> FShowHeader THEN BEGIN
    FShowHeader := Value;
    FHeader.Visible := Value;
    IF Value
      THEN FHeader.SetBounds(Left, Top-FHeader.Height, Width, FHeader.Height)
      ELSE FHeader.SetBounds(-10, 0, 0, FHeader.Height);
    Invalidate;
  END;
end;

function TPieComboBox.GetHCS: THeaderSections;
begin
  Result := FHeader.Sections;
end;

procedure TPieComboBox.SetHCS(Value: THeaderSections);
begin
  FHeader.Sections := Value;
end;

{$IFDEF D5_OR_HIGHER}
function TPieComboBox.GetHCImages: TCustomImageList;
begin
  Result := FHeader.Images;
end;

procedure TPieComboBox.SetHCImages(Value: TCustomImageList);
begin
  FHeader.Images := Value;
end;
{$ENDIF}

function TPieComboBox.GetHCStyle: THeaderStyle;
begin
  Result := FHeader.Style;
end;

procedure TPieComboBox.SetHCStyle(Value: THeaderStyle);
begin
  FHeader.Style := Value;
end;

function TPieComboBox.GetHCFont: TFont;
begin
  Result := FHeader.Font;
end;

procedure TPieComboBox.SetHCFont(Value: TFont);
begin
  FHeader.Font := Value;
end;

function TPieComboBox.GetOnSectionClick: TSectionNotifyEvent;
begin
  Result := FHeader.OnSectionClick;
end;

procedure TPieComboBox.SetOnSectionClick(Value: TSectionNotifyEvent);
begin
  FHeader.OnSectionClick := Value;
end;

procedure TPieComboBox.HeaderSectionResize(HeaderControl: THeaderControl; Section: THeaderSection);
begin
  Invalidate;
end;

function TPieComboBox.ItemAtPos(Pos: TPoint; Existing: Boolean): Integer;
var
  Count: Integer;
  ItemRect: TRect;
  P, H: Integer;
begin
  if PtInRect(ClientRect, Pos) then
  begin
    Result := 0;
    Count := FItems.Count;
    IF Style = csSimple THEN P := 0 ELSE P := Height;
    while Result < Count do begin
      H := Perform(CB_GETITEMHEIGHT, Result, 0);
      ItemRect := Rect(0, P, Width, P+H);
      if PtInRect(ItemRect, Pos) then Exit;
      P := P + H;
      Inc(Result);
    end;
    if not Existing then Exit;
  end;
  Result := -1;
end;

procedure TPieComboBox.UpdateHint(Index: Integer);
VAR
  MausP: TPoint;
  Idx: Integer;
BEGIN
  Idx := Index;
  IF Idx < 0 THEN BEGIN
    GetCursorPos(MausP);
    MausP := ScreenToClient(MausP);
    Idx := ItematPos(MausP, True);
  END;
  IF Idx > -1 THEN BEGIN
    IF HelpContext <> Items.HelpContexts[Idx] THEN
      HelpContext := Items.HelpContexts[Idx];
    IF Hint <> Items.Hints[Idx] THEN BEGIN
      Hint := Items.Hints[Idx];
    END;
  END;
  Perform(CM_HINTSHOW, 0, 0);
  {Mauszeiger auf Eltern simulieren --> damit wird der Hint wieder aktualisiert}
  GetCursorPos(MausP);
  SendMessage(Parent.Handle, wm_MouseMove, 0, 0);
  SendMessage(Parent.Handle, wm_MouseMove, 0, MausP.X + (MausP.Y SHL 16));
END;
{******************************************************}
{******************************************************}
{******************************************************}
procedure TPieComboBoxItemsfenster.Prop_zeigen;
begin
  Zeile := ComboBox.ItemIndex;
  Zeilenlabel2.Caption := Str_Number(Zeile+1);
  Gesamtzeilenlabel2.Caption := Str_Number(ComboBox.Items.Count);

  IF Zeile > -1 THEN BEGIN
    TRY
      IF Assigned(ComboBox.Items.Bitmaps[Zeile]) AND NOT(ComboBox.Items.Bitmaps[Zeile].Empty)
        THEN BitmapVorschau.Picture.Assign(ComboBox.Items.Bitmaps[Zeile])
        ELSE BitmapVorschau.Picture.Assign(NIL);
      ColorShape.Brush.Color := ComboBox.Items.Colors[Zeile];
      Edit.Color := ComboBox.Items.Colors[Zeile];
      IF Assigned(ComboBox.Items.Fonts[Zeile]) THEN BEGIN
        FontBtn.Font := ComboBox.Items.Fonts[Zeile];
        Edit.Font := ComboBox.Items.Fonts[Zeile];
      END
      ELSE BEGIN
        FontBtn.ParentFont := TRUE;
        Edit.ParentFont := TRUE;
      END;
      Edit.Font.Height := -11;
      HelpUpDown.Position := ComboBox.Items.HelpContexts[Zeile];
      HelpEdit.Caption := IntToStr(ComboBox.Items.HelpContexts[Zeile]);
    EXCEPT
      ON EAccessViolation DO;
    END;
  END;
end;

procedure TPieComboBoxItemsfenster.ComboBoxClick(Sender: TObject);
begin
  IF ComboBox.ItemIndex < 0 THEN exit;
  Edit.Text := ComboBox.Items.Strings[ComboBox.ItemIndex];
  Prop_zeigen;
  Edit.SetFocus;
end;

procedure TPieComboBoxItemsfenster.ComboBoxMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  IF (Button = mbLeft) THEN WITH ComboBox DO BEGIN
    IF (ItematPos(Point(X,Y), TRUE) >= 0) AND
       (ItematPos(Point(X,Y), TRUE) < Items.Count) THEN BEGIN
      Zieh_Item := ItematPos(Point(X,Y), TRUE);
    END;
  END;
end;

procedure TPieComboBoxItemsfenster.ComboBoxDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := ((Source = ComboBox) AND   {Befehl verschieben}
             (ComboBox.ItemAtPos(Point(X,Y), TRUE) >= 0) AND
             (ComboBox.ItemAtPos(Point(X,Y), TRUE) <> Zieh_Item)
            );
end;

procedure TPieComboBoxItemsfenster.ComboBoxDragDrop(Sender, Source: TObject; X, Y: Integer);
VAR
  Dropposition: Integer;
begin
  IF (Source = ComboBox) THEN BEGIN
    Dropposition := ComboBox.ItemAtPos(Point(X,Y), TRUE);
    IF Dropposition >= 0 THEN ComboBox.Items.Move(Dropposition, Zieh_Item);
  END;
end;

procedure TPieComboBoxItemsfenster.InsertBtnClick(Sender: TObject);
CONST
  CRLF = #$0D+#$0A;
VAR
  S: string;
  I: Integer;
begin
  S := Edit.Text;
  IF (length(S) > 1) AND (copy(S, length(S)-2, 2) = CRLF) THEN
    S := copy(S, length(S)-2, 2);
  I := ComboBox.ItemIndex;
  IF I<0 THEN I:=0;
  ComboBox.Items.Insert(I, S);
  Prop_zeigen;
end;

procedure TPieComboBoxItemsfenster.DeleteBtnClick(Sender: TObject);
begin
  ComboBox.Items.Delete(ComboBox.ItemIndex);
  Prop_zeigen;
end;

procedure TPieComboBoxItemsfenster.ChangeBtnClick(Sender: TObject);
CONST
  CRLF = #$0D+#$0A;
VAR
  S: string;
begin
  S := Edit.Text;
  IF (length(S) > 1) AND (copy(S, length(S)-2, 2) = CRLF) THEN
    S := copy(S, length(S)-2, 2);
  ComboBox.Items.Strings[ComboBox.ItemIndex] := S;
  Prop_zeigen;
end;

procedure TPieComboBoxItemsfenster.ColorBtnClick(Sender: TObject);
begin
  ColorDialog.Color := ComboBox.Items.Colors[Zeile];
  IF ColorDialog.Execute THEN BEGIN
    ComboBox.Items.Colors[Zeile] := ColorDialog.Color;
    ComboBox.Repaint;
    Prop_zeigen;
  END;
end;

procedure TPieComboBoxItemsfenster.FormShow(Sender: TObject);
begin
  ComboBox.Align := alNone;
  ComboBox.FHeader.Top := ComboBox.Top;
  ComboBox.Top := ComboBox.Top + ComboBox.FHeader.Height;
  ComboBox.Height := ComboBox.Height - ComboBox.FHeader.Height;
  CASE ComboBox.ItemHeightStyle OF
  ihcFix        : IHStyle.ItemIndex := 0;
  ihcFont       : IHStyle.ItemIndex := 1;
  ihcBitmap     : IHStyle.ItemIndex := 2;
  ihcFontBitmap : IHStyle.ItemIndex := 3;
  END;
  CASE ComboBox.BitmapStyle OF
  bscLeft       : BStyle.ItemIndex := 0;
  bscRight      : BStyle.ItemIndex := 1;
  bscCenter     : BStyle.ItemIndex := 2;
  bscStretch    : BStyle.ItemIndex := 3;
  bscPattern    : BStyle.ItemIndex := 4;
  END;
  CASE ComboBox.BackGroundStyle OF
  bgscNone      : BGStyle.ItemIndex := 0;
  bgscCenter    : BGStyle.ItemIndex := 1;
  bgscStretch   : BGStyle.ItemIndex := 2;
  bgscPattern   : BGStyle.ItemIndex := 3;
  END;
  UT.Checked := ComboBox.ShowHeader;
  UTClick(UT);
  LBTS.Checked := ComboBox.LineByTabStops;
  HSGroup.ItemIndex := Integer(ComboBox.HeaderStyle);
  AnyColors.Checked := ComboBox.AnyColors;
  AnyFonts.Checked := ComboBox.AnyFonts;
  BoldStyle.Checked := ComboBox.BoldStyle;
  Edit.Clear;
  ComboBox.ItemIndex := ComboBox.Items.Count-1;
  IF ComboBox.ItemIndex > -1 THEN BEGIN
    Edit.Text := ComboBox.Items.Strings[ComboBox.ItemIndex];
    Prop_zeigen;
  END;
end;

procedure TPieComboBoxItemsfenster.EditEnter(Sender: TObject);
begin
  Edit.SelectAll;
end;

procedure TPieComboBoxItemsfenster.EditChange(Sender: TObject);
begin
  Prop_zeigen;
end;

procedure TPieComboBoxItemsfenster.FontBtnClick(Sender: TObject);
begin
  FontDialog.Font := FontBtn.Font;
  IF FontDialog.Execute THEN BEGIN
    ComboBox.Items.Fonts[Zeile] := FontDialog.Font;
    ComboBox.Repaint;
    Prop_zeigen;
  END;
end;

procedure TPieComboBoxItemsfenster.HintBtnClick(Sender: TObject);
begin
  HintDialog.Zeilentext := ComboBox.Items.Hints[Zeile];
  IF HintDialog.Execute THEN BEGIN
    ComboBox.Items.Hints[Zeile] := HintDialog.Zeilentext;
  END;
end;

procedure TPieComboBoxItemsfenster.LoeschBtnClick(Sender: TObject);
begin
  ComboBox.Clear;
end;

procedure TPieComboBoxItemsfenster.UTClick(Sender: TObject);
begin
  ComboBox.ShowHeader := UT.Checked;
  HSGroup.Enabled := UT.Checked;
  LBTS.Enabled := UT.Checked;
  HFButton.Enabled := UT.Checked;
end;

procedure TPieComboBoxItemsfenster.AnyColorsClick(Sender: TObject);
begin
  ComboBox.AnyColors := AnyColors.Checked;
end;

procedure TPieComboBoxItemsfenster.AnyFontsClick(Sender: TObject);
begin
  ComboBox.AnyFonts := AnyFonts.Checked;
end;

procedure TPieComboBoxItemsfenster.FormCreate(Sender: TObject);
begin
  ComboBox := TPieComboBox.Create(Self);
  ComboBox.Parent := EditPanel;
  ComboBox.FHeader.Parent := EditPanel;
  ComboBox.Top := 89;
  ComboBox.Left := 4;
  ComboBox.Style := csSimple;
  ComboBox.Height := 230;
  ComboBox.Align := alClient;
  ComboBox.OnClick := ComboBoxClick;
  ComboBox.OnMouseDown := ComboBoxMouseDown;
  ComboBox.OnDragOver := ComboBoxDragOver;
  ComboBox.OnDragDrop := ComboBoxDragDrop;
  HintDialog := TPieZeilenDialog.Create(Self);
  WITH HintDialog DO BEGIN
    PasswordChar := #0;
    Labeltext := 'Hint';
    Ueberschrift := 'Hint fr diesen Item eingeben';
    Oktext := '&Ok';
    Abbrechentext := '&Abbrechen';
    KommazuPunkt := False;
    Left := 384;
    Top := 56;
  end;
end;

procedure TPieComboBoxItemsfenster.FormDestroy(Sender: TObject);
begin
  HintDialog.Free;
  ComboBox.Free;
end;

procedure TPieComboBoxItemsfenster.BitmapBtnClick(Sender: TObject);
VAR
  B: TBitmap;
begin
  IF OpenPicDialog.Execute THEN BEGIN
    B := TBitmap.Create;
    TRY
      B.LoadFromFile(OpenPicDialog.FileName);
      ComboBox.Items.Bitmaps[Zeile] := B;
    FINALLY
      B.Destroy;
    END;
    ComboBox.Repaint;
    Prop_zeigen;
  END;
end;

procedure TPieComboBoxItemsfenster.IHStyleClick(Sender: TObject);
begin
  CASE IHStyle.ItemIndex OF
  0: ComboBox.ItemHeightStyle := ihcFix;
  1: ComboBox.ItemHeightStyle := ihcFont;
  2: ComboBox.ItemHeightStyle := ihcBitmap;
  3: ComboBox.ItemHeightStyle := ihcFontBitmap;
  END;
end;

procedure TPieComboBoxItemsfenster.BStyleClick(Sender: TObject);
begin
  CASE BStyle.ItemIndex OF
  0: ComboBox.BitmapStyle := bscLeft;
  1: ComboBox.BitmapStyle := bscRight;
  2: ComboBox.BitmapStyle := bscCenter;
  3: ComboBox.BitmapStyle := bscStretch;
  4: ComboBox.BitmapStyle := bscPattern;
  END;
end;

procedure TPieComboBoxItemsfenster.BoldStyleClick(Sender: TObject);
begin
  ComboBox.BoldStyle := BoldStyle.Checked;
end;

procedure TPieComboBoxItemsfenster.LBTSClick(Sender: TObject);
begin
  ComboBox.LineByTabStops := LBTS.Checked;
end;

procedure TPieComboBoxItemsfenster.HSGroupClick(Sender: TObject);
begin
  ComboBox.HeaderStyle := THeaderStyle(HSGroup.ItemIndex);
end;

procedure TPieComboBoxItemsfenster.HFButtonClick(Sender: TObject);
begin
  FontDialog.Font := ComboBox.HeaderFont;
  IF FontDialog.Execute THEN
    ComboBox.HeaderFont := FontDialog.Font;
end;

procedure TPieComboBoxItemsfenster.HelpUpDownChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
  ComboBox.Items.HelpContexts[Zeile] := HelpUpDown.Position;
  HelpEdit.Caption := IntToStr(HelpUpDown.Position);
end;

procedure TPieComboBoxItemsfenster.BGButtonClick(Sender: TObject);
begin
  IF OpenPicDialog.Execute THEN
    ComboBox.BackGround.LoadFromFile(OpenPicDialog.FileName);
end;

procedure TPieComboBoxItemsfenster.BGStyleClick(Sender: TObject);
begin
  CASE BGStyle.ItemIndex OF
  0: ComboBox.BackGroundStyle := bgscNone;
  1: ComboBox.BackGroundStyle := bgscCenter;
  2: ComboBox.BackGroundStyle := bgscStretch;
  3: ComboBox.BackGroundStyle := bgscPattern;
  END;
end;

end.
