{
--------------------------------------------------------------------------------

Author: Philip Bairstow.
E-Mail: Philip@pbairstow.com
www: www.pbairstow.com
ICQ: 47850165

23 June 2000.

Version information:

    Version 1.0 -  Allows you to launch a url within the default internet browser
                   when clicked on also there is an option of typing a subject
                   for the message.
   
    If you use this product then you agree with the Following:
    
    The Author does not accpet responsability for the loss or damage caused
    either directly or indirectly by using this software.
    You may not sell or profit in any way from this software without the
    written permission from the named author and any associates.
    This software may be freely distributed as long aa all origional files are
    unchanged and this header is not modified in any way. You should report any
    bugs to the above email address.

    Installation:

    Copy all the delphi files into a directory on the Delphi Search Path then
    Choose install component from within the Component Menu with in the delphi
    IDE then locate the file Emaillabel.pas within the directory you copied it
    into.

--------------------------------------------------------------------------------
}

{$R Urllabel.res}

unit UrlLabel;

interface

uses
  Windows,SysUtils,Classes,StdCtrls,ShellAPI,Graphics,Messages,Controls,LabelTypes,Dialogs, Forms;

type

  TUrlLabel = class(TPBLabel)
  private
    FURL: string;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Click; override;
  published
    property URL: string           read FURL          write FURL;
end;

procedure Register;

implementation

procedure Register;
begin
   RegisterComponents('PBSoftware', [TUrlLabel]);
end;

//------------------------------------------------------------------------------

constructor TUrlLabel.Create( AOwner : TComponent );
begin
   inherited Create(AOwner);
   Font.Color := clBlue;
   Font.Style := [fsUnderline];
end;

//------------------------------------------------------------------------------

procedure TUrlLabel.Click;
var
   TempURL: string;
   Result: LongWord;
begin
   inherited Click;
     begin
       TempUrl := FURL;
       If Trim(TempUrl) <> '' then
       begin
         Result := ShellExecute(GetDeskTopWindow(),'Open',PChar(TempUrl), nil, nil, SW_SHOW);
       end
      Else
       raise Exception.Create('Error: Property URL not Specified')
     end;
end;

//------------------------------------------------------------------------------

destructor TUrlLabel.Destroy;
begin
   inherited;
end;

end.
