{
--------------------------------------------------------------------------------

Author: Philip Bairstow.
E-Mail: Philip@pbairstow.com
www: www.pbairstow.com
ICQ: 47850165

23 June 2000.

Version information:

    Version 1.0 -  Allows you to launch the default email client when
                   clicked on also there is an option of typing a subject
                   for the message.
   
    If you use this product then you agree with the Following:
    
    The Author does not accpet responsability for the loss or damage caused
    either directly or indirectly by using this software.
    You may not sell or profit in any way from this software without the
    written permission from the named author and any associates.
    This software may be freely distributed as long aa all origional files are
    unchanged and this header is not modified in any way. You should report any
    bugs to the above email address.

    Installation:

    Copy all the delphi files into a directory on the Delphi Search Path then
    Choose install component from within the Component Menu with in the delphi
    IDE then locate the file Emaillabel.pas within the directory you copied it
    into.

--------------------------------------------------------------------------------
}

{$R Emaillabel.res}

unit Emaillabel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ShellAPI, LabelTypes;

type

  TEmaillabel = class(TPBLabel)
  private
    FSubject, FRecipient: string;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Click; override;
  published
    Property Subject  : String     read FSubject      write FSubject;
    Property Recipient: String     read FRecipient    write FRecipient;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('PBSoftware', [TEmaillabel]);
end;

//------------------------------------------------------------------------------

constructor TEmaillabel.Create( AOwner : TComponent );
begin
   inherited Create(AOwner);
   Font.Color := clBlue;
   Font.Style := [fsUnderline];
end;

//------------------------------------------------------------------------------

procedure TEmaillabel.Click;
var
   TempURL: string;

begin
   inherited Click;
 Try
    If Trim(Recipient) <> '' then
    begin
      TempUrl := ConCat('mailto:',Recipient,'?subject='+Subject);
      ShellExecute(GetDesktopWindow(),'Open',PChar(TempUrl), nil, nil, SW_SHOWNORMAL);
    end
   Else
      raise Exception.Create('Error: Please Specify a Recipients Email Address')
Except
  On EAccessViolation do Raise;
  end;
end;

//------------------------------------------------------------------------------

destructor TEmaillabel.Destroy;
begin
   inherited;
end;

end.
