unit Main;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, PBFolderDialog, ShlObj, CheckLst, ActiveX, ExtCtrls;

type
	TForm1 = class(TForm)
		Edit1: TEdit;
    Edit2: TEdit;
    SelectFolder: TButton;
    Label1: TLabel;
    Label2: TLabel;
		Label3: TLabel;
    PBFolderDialog1: TPBFolderDialog;
    Label4: TLabel;
    Edit3: TEdit;
    Label5: TLabel;
    Label6: TLabel;
    Bevel1: TBevel;
    ExecutePIDL: TButton;
    Label7: TLabel;
    Edit4: TEdit;
    Label8: TLabel;
    ComboBox1: TComboBox;
    Label9: TLabel;
    CheckListBox1: TCheckListBox;
    Label10: TLabel;
    Bevel2: TBevel;
    procedure SelectFolderClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ExecutePIDLClick(Sender: TObject);
    procedure PBFolderDialog1SelectionChanged(Sender: TPBFolderDialog;
      DialogHandle: HWND; const ItemIDList: PItemIDList;
      const Folder: String; const Attr: Cardinal);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
	Form1: TForm1;
	PIDL : PItemIDList;

implementation

{$R *.DFM}

procedure TForm1.SelectFolderClick(Sender: TObject);
var
	t : integer;
begin
	PBFolderDialog1.SpecialFolder := StrToIntDef(Edit3.Text, -1);
	PBFolderDialog1.Folder := Edit1.Text;
	PBFolderDialog1.RootFolder := TSHFolders(ComboBox1.ItemIndex);
	PBFolderDialog1.Flags := [];
	for t := 0 to CheckListBox1.Items.Count - 1 do
	begin
		if CheckListBox1.Checked[t]
			then PBFolderDialog1.Flags := PBFolderDialog1.Flags
			+ [TBrowseInfoFlags(t)];
	end;
	if PBFolderDialog1.Execute then
	begin
		Edit1.Text := PBFolderDialog1.Folder;
		Edit2.Text := PBFolderDialog1.DisplayName;
		Edit3.Text := IntToStr(PBFolderDialog1.SpecialFolder);
		Edit4.Text := IntToStr(PBFolderDialog1.FolderAttributes);
	end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
	t : integer;
begin
	Edit1.Text := PBFolderDialog1.Folder;
	Edit2.Text := PBFolderDialog1.DisplayName;
	Edit3.Text := IntToStr(PBFolderDialog1.SpecialFolder);
	Edit4.Text := '0';
	Randomize;
	ComboBox1.ItemIndex := Ord(PBFolderDialog1.RootFolder);
	for t := 0 to CheckListBox1.Items.Count - 1 do
	begin
		CheckListBox1.Checked[t] := (TBrowseInfoFlags(t) in PBFolderDialog1.Flags);
	end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
// This line requires ActiveX unit
	if PIDL <> nil then CoTaskMemFree(PIDL);
end;

procedure TForm1.ExecutePIDLClick(Sender: TObject);
var
	t : integer;
begin
	PBFolderDialog1.SpecialFolder := StrToIntDef(Edit3.Text, -1);
	PBFolderDialog1.Folder := Edit1.Text;
	PBFolderDialog1.RootFolder := TSHFolders(ComboBox1.ItemIndex);
	for t := 0 to CheckListBox1.Items.Count - 1 do
	begin
		if CheckListBox1.Checked[t]
			then PBFolderDialog1.Flags := PBFolderDialog1.Flags
			+ [TBrowseInfoFlags(t)];
	end;
	if PBFolderDialog1.ExecutePIDL(PIDL) then
	begin
		Edit1.Text := PBFolderDialog1.Folder;
		Edit2.Text := PBFolderDialog1.DisplayName;
		Edit3.Text := IntToStr(PBFolderDialog1.SpecialFolder);
		Edit4.Text := IntToStr(PBFolderDialog1.FolderAttributes);
	end;
end;

procedure TForm1.PBFolderDialog1SelectionChanged(Sender: TPBFolderDialog;
  DialogHandle: HWND; const ItemIDList: PItemIDList; const Folder: String;
  const Attr: Cardinal);
begin
// Add ShlObj to the uses clause when you implement OnSelectionChanged.
	Label3.Color := Random(MaxInt);
end;

end.

