unit MSDBCheckListBox;

interface

uses    DB, DBCtrls, Forms, Menus, Controls, SysUtils,
        Messages, Classes, Graphics, StdCtrls, CheckLst;

type
    TMSDBCheckListBox = Class( TCheckListBox )

    private
    FDataLink: TFieldDataLink;
    FCharChecked : Char;
    FCharUnChecked : Char;
    FCharGrayed : Char;

    function GetDataField: String;
    function GetDataSource: TDataSource;
    procedure SetDataField( const value: String );
    procedure SetDataSource( value: TDataSource );

    procedure DataChange( sender: TObject );
    procedure UpdateData( Sender: TObject );

    procedure CMExit( var Message: TCMExit ); message CM_EXIT;


    protected
    procedure KeyPress( var Key: Char ); override;
    procedure Notification( AComponent: TComponent; Operation: TOperation ); override;
    procedure ClickCheck; override;
    public
    constructor Create( owner: TComponent ); override;
    destructor Destroy; override;

    published
    property DataField:  String read GetDataField write SetDataField;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property CharChecked: Char read FCharChecked write FCharChecked;
    property CharUnChecked: Char read FCharUnChecked write FCharUnChecked;
    property CharGrayed: Char read FCharGrayed write FCharGrayed;
    end;


procedure Register;

implementation

procedure Register;

begin
RegisterComponents( 'Beispiele', [ TMSDBCheckListBox ] );
end;

{ TMSDBCheckListBox }

function TMSDBCheckListBox.GetDataField: String;
begin
Result := FDataLink.FieldName
end;

function TMSDBCheckListBox.GetDataSource: TDataSource;
begin
Result := FDataLink.DataSource
end;


procedure TMSDBCheckListBox.SetDataField( const Value: String );
begin
FDataLink.FieldName := Value;
end;

procedure TMSDBCheckListBox.SetDataSource( Value: TDataSource );
begin
FDataLink.DataSource := Value;
end;


procedure TMSDBCheckListBox.UpdateData( Sender: TObject );
var I,K,R : Integer;
    S : String;
    FFieldType : Integer;
begin
FFieldType := -1;
if (FDataLink.Field is TIntegerField) then
  FFieldType := 0;
if (FDataLink.Field is TLargeintField) then
  FFieldType := 1;
if (FDataLink.Field is TStringField) then
  FFieldType := 2;
if (FFieldType < 0) then
  begin
  raise EDatabaseError.Create('DataFieldType needs Integer- or String-Type!');
  end;

case FFieldType of
  0 : begin
      R := 0;
      K := 0;
      for I := 0 to Items.Count - 1 do
        begin
        if (not Header[I])and(K<32) then
          begin
          case State[I] of
            cbChecked : R := R or (1 shl K);
            else;
            end;
          Inc(K);
          end;
        end;
      FDataLink.Field.AsInteger  := R;
      end;
  2 : begin
      S:= '';
      for I := 0 to Items.Count - 1 do
        begin
        if not Header[I] then
          case State[I] of
            cbUnchecked : S := S + FCharUnChecked;
            cbChecked : S := S + FCharChecked;
            cbGrayed : S := S + FCharGrayed;
          else;
          end;
        end;
      FDataLink.Field.AsString := S;
      end;
  else;
  end;
end;


procedure TMSDBCheckListBox.DataChange( sender: TObject );

{   A change to the underlying data is reflected in the state of the checkbox.
}
var I,K,R : Integer;
    S : String;
    FFieldType : Integer;
begin
FFieldType := -1;
if (FDataLink.Field is TIntegerField) then
  FFieldType := 0;
if (FDataLink.Field is TLargeintField) then
  FFieldType := 1;
if (FDataLink.Field is TStringField) then
  FFieldType := 2;
if (FFieldType < 0) then
  begin
  raise EDatabaseError.Create('DataFieldType needs Integer- or String-Type!');
  end;
case FFieldType of
  0 : begin
      R := FDataLink.Field.AsInteger;
      K := 0;
      for I := 0 to Items.Count - 1 do
        begin
        if (not Header[I])and(K<32) then
          begin
          if (R and (1 shl K)) = 0 then
            State[I] := cbUnChecked
            else
            State[I] := cbChecked;
          Inc(K);
          end;
        end;
      end;
  2 : begin
      S:= FDataLink.Field.AsString;
      K := 1;
      for I := 0 to Items.Count - 1 do
        begin
        if not Header[I] then
          begin
          if K <= Length(S) then
            begin
            if S[K] = FCharUnChecked then
              State[I] := cbUnchecked
              else
              if S[K] = FCharChecked then
                State[I] := cbChecked
                else
                State[I] := cbGrayed;
            end;
          Inc(K);
          end;
        end;
      end;
  else;
  end;
end;

constructor TMSDBCheckListBox.Create( owner: TComponent );
begin
inherited Create( owner );
FCharChecked := 'Y';
FCharUnChecked := 'N';
FCharGrayed := '-';
FDataLink := TFieldDataLink.Create;
FDataLink.Control := Self;
FDataLink.OnDataChange := DataChange;
FDataLink.OnUpdateData := UpdateData
end;

destructor TMSDBCheckListBox.Destroy;
begin
FDataLink.Free;
inherited Destroy
end;

procedure TMSDBCheckListBox.CMExit( var Message: TCMExit );
begin
  try
    FDataLink.UpdateRecord;
  except
    SetFocus;
    raise;
  end;
  inherited
end;

procedure TMSDBCheckListBox.Notification( AComponent: TComponent; Operation: TOperation );
begin
inherited Notification( AComponent, Operation );
if ( ( Operation = opRemove ) and ( FDataLink <> nil ) and ( AComponent = DataSource ) ) then
  DataSource := nil
end;



procedure TMSDBCheckListBox.ClickCheck;
var AState : TCheckBoxState;
begin
AState := State[ItemIndex];
if FDataLink.Edit then
  begin
  State[ItemIndex] := AState;
  inherited ClickCheck;
  FDataLink.Modified
  end
end;

procedure TMSDBCheckListBox.KeyPress(var Key: Char);
begin
case Key of
//  #8, ' ': begin
//           FDataLink.Edit;
//           end;
  #27: begin
       FDataLink.Reset;
//       Key := #0;
       end;
  end;
inherited KeyPress( Key );
end;


end.
