//------------------------------------------------------------------------------
// Author : Regardt Kruger
// E-Mail : bytes99@hotmail.com
//
//
// Use this component to create links to any e-mail adress or home page or
// even your 'c:\' drive...you get the picture!
//------------------------------------------------------------------------------


unit LnkLabel;

interface

uses
   Windows,SysUtils,Classes,StdCtrls,ShellAPI,Graphics,Messages,Controls,Dialogs, Forms;

type
  TLnkLabel = class(TCustomLabel)
  private
    sURL : string;
    EColor : TColor;
    LColor : TColor;
    VColor : TColor;

    procedure MouseEnter(var mMsg : TMessage); message CM_MouseEnter;
    procedure MouseLeave(var mMsg : TMessage); message CM_MouseLeave;

  protected

  public
    ix,iy : integer;
    Constructor Create(aOwner : TComponent); override;
    procedure Click; override;

  published
    property Font;
    property Caption;
    property Enabled;
    property ParentShowHint;
    property ShowHint;
    property Hint;
    property Transparent;
    property Visible;
    property Link : String read sURL write sURL;
    property Cursor;
    property EnterFontColor : TColor read EColor write EColor;
    property LeaveFontColor  : TColor read LColor write LColor;
    property VisitedColor   : TColor read VColor write VColor;

  end;
  var
   rglabel : TLnkLabel;

procedure Register;

implementation

//------------------------------------------------------------------------------
procedure Register;
begin
  RegisterComponents('Custom', [TLnkLabel]);
end;
//------------------------------------------------------------------------------
procedure TLnkLabel.Click;
begin
 shellexecute((Owner as  TForm).Handle ,'OPEN',pChar(sURL),'','',SW_SHOW);
 LColor := VColor;
end;
//------------------------------------------------------------------------------
constructor TLnkLabel.Create(aOwner: TComponent);
begin
  inherited create(aOwner);
    if (csDesigning in ComponentState) then
     begin
      Font.Color := clblue;
      Font.Style := [fsUnderline];
      Cursor := crHandPoint;
      sUrl := 'mailto:bytes99@hotmail.com';
      Transparent := True;
      EColor := clRed;
      LColor := clBlue;
      VColor := clNavy;
     end;
end;
//------------------------------------------------------------------------------
procedure TLnkLabel.MouseEnter(var mMsg: TMessage);
begin
  font.color := EColor;
end;
//------------------------------------------------------------------------------
procedure TLnkLabel.MouseLeave(var mMsg: TMessage);
begin
  font.color := LColor;
end;
//------------------------------------------------------------------------------
end.
