unit LCDScreenAbout;

////////////////////////////////////////////////////////////////////////////////
//
//  TLCDScreen / TLCDAnimator v3.0 (22/jan/02)
//  written by Jacques VOIRIN
//  E-Mail: jacques.voirin@iname.com
//
////////////////////////////////////////////////////////////////////////////////


interface

uses
  Dialogs,

    {$IFDEF  VER140}
      DesignIntf, DesignEditors,
    {$ELSE}
      DsgnIntf,
    {$ENDIF}

  LCDScreen;


type

////////////////////////////////////////////////////////////////////////////////
//
//  TAbout Editor
//
////////////////////////////////////////////////////////////////////////////////

  TAboutProperty = class(TStringProperty)
  public
    function  GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;


procedure Register;


implementation

////////////////////////////////////////////////////////////////////////////////
//
//  TAbout Editor routines.
//
////////////////////////////////////////////////////////////////////////////////

function TAboutProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;


procedure TAboutProperty.Edit;
begin
  MessageDlg(#13 + ' TLCDScreen / TLCDAnimator version 3.0  (22/jan/02)' +
             #13 + #13 + 'written by Jacques VOIRIN (jacques.voirin@iname.com)'
             + #13, mtInformation, [mbOk], 0);
end;


////////////////////////////////////////////////////////////////////////////////
//
// TLCDScreen About routines.
//
////////////////////////////////////////////////////////////////////////////////

function GetAbout: string;
begin
  GetAbout := 'About LCDScreen';
end;


procedure SetAbout(Value: string);
begin
  // just for syntax
end;


////////////////////////////////////////////////////////////////////////////////
//
// Registration of the 'About...' property for LCDScreen and LCDAnimator.
//
////////////////////////////////////////////////////////////////////////////////

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(string), TLCDScreen, 'About', TAboutProperty);
  RegisterPropertyEditor(TypeInfo(string), TLCDAnimator, 'About', TAboutProperty);
end;

end.
