{******************************************************************************}
{                                                                              }
{ Project JEDI Code Library (JCL)                                              }
{                                                                              }
{ The contents of this file are subject to the Mozilla Public License Version  }
{ 1.1 (the "License"); you may not use this file except in compliance with the }
{ License. You may obtain a copy of the License at http://www.mozilla.org/MPL/ }
{                                                                              }
{ Software distributed under the License is distributed on an "AS IS" basis,   }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for }
{ the specific language governing rights and limitations under the License.    }
{                                                                              }
{ The Original Code is JclIniFiles.pas.                                        }
{                                                                              }
{ The Initial Developer of the Original Code is documented in the accompanying }
{ help file JCL.chm. Portions created by these individuals are Copyright (C)   }
{ of these individuals.                                                        }
{                                                                              }
{******************************************************************************}
{                                                                              }
{ Unit owner: Eric S. Fisher                                                   }
{ Last modified: January, 30 2001                                              }
{                                                                              }
{******************************************************************************}

unit JclIniFiles;

{$I JCL.INC}

{$WEAKPACKAGEUNIT ON}

interface

{$IFDEF WIN32}
uses
  Windows;
{$ENDIF WIN32}

//------------------------------------------------------------------------------
// Initialization (ini) Files
//------------------------------------------------------------------------------

function IniReadBool(const FileName, Section, Line: string): Boolean;
function IniReadInteger(const FileName, Section, Line: string): Integer;
function IniReadString(const FileName, Section, Line: string): string;
procedure IniWriteBool(const FileName, Section, Line: string; Value: Boolean);
procedure IniWriteInteger(const FileName, Section, Line: string; Value: Integer);
procedure IniWriteString(const FileName, Section, Line, Value: string);

implementation

uses
  IniFiles;

//==============================================================================
// Initialization Files
//==============================================================================

function IniReadBool(const FileName, Section, Line: string): Boolean;
var
  Ini: TIniFile;
begin
  Ini := TIniFile.Create(FileName);
  try
    Result := Ini.ReadBool(Section, Line, False);
  finally
    Ini.Free;
  end;
end;

//------------------------------------------------------------------------------

function IniReadInteger(const FileName, Section, Line: string): Integer;
var
  Ini: TIniFile;
begin
  Ini := TIniFile.Create(FileName);
  try
    Result := Ini.ReadInteger(Section, Line, 0);
  finally
    Ini.Free;
  end;
end;

//------------------------------------------------------------------------------

function IniReadString(const FileName, Section, Line: string): string;
var
  Ini: TIniFile;
begin
  Ini := TIniFile.Create(FileName);
  try
    Result := Ini.ReadString(Section, Line, '');
  finally
    Ini.Free;
  end;
end;

//------------------------------------------------------------------------------

procedure IniWriteBool(const FileName, Section, Line: string; Value: Boolean);
var
  Ini: TIniFile;
begin
  Ini := TIniFile.Create(FileName);
  try
    Ini.WriteBool(Section, Line, Value);
  finally
    Ini.Free;
  end;
end;

//------------------------------------------------------------------------------

procedure IniWriteInteger(const FileName, Section, Line: string; Value: Integer);
var
  Ini: TIniFile;
begin
  Ini := TIniFile.Create(FileName);
  try
    Ini.WriteInteger(Section, Line, Value);
  finally
    Ini.Free;
  end;
end;

//------------------------------------------------------------------------------

procedure IniWriteString(const FileName, Section, Line, Value: string);
var
  Ini: TIniFile;
begin
  Ini := TIniFile.Create(FileName);
  try
    Ini.WriteString(Section, Line, Value);
  finally
    Ini.Free;
  end;
end;

end.
