(*************************************************************************)
(*                                                                       *)
(*                      FastGEO Ordered Polygon Unit                     *)
(*                         Release Version 0.0.1                         *)
(*                                                                       *)
(* Author: Arash Partow 1997-2004                                        *)
(* Copyright notice:                                                     *)
(*                                                                       *)
(* Free use of the FastGEO Ordered Polygon is permitted under the        *)
(* guidelines and in accordance with the most current version of the     *)
(* Common Public License.                                                *)
(* http://www.opensource.org/licenses/cpl.php                            *)
(*                                                                       *)
(* Description:                                                          *)
(* This is a simple implementation of re-ordering a complex              *)
(* self-intersecting polygon into a simple concave polygon using FastGEO *)
(* as the base for geometric primitives.                                 *)
(*************************************************************************)

unit OrderedPolygonUnit;

interface

Uses FastGEO;

Type TOrdPolyPoint2D = Record
                        x  :Double;
                        y  :Double;
                        ang:Double;
                       End;

Type TOrdPolyPoint3D = Record
                        x  :Double;
                        y  :Double;
                        z  :Double;
                        ang:Double;
                       End;


Type TOrderedPolygon2D = Class

     private
      Point: Array Of TOrdPolyPoint2D;


     public

      Procedure OrderedPolygon(Var Pnt: Array Of TPoint2D);

     private

      Procedure Swap(I,J:LongInt);
      Procedure RQSort(Left,Right:LongInt);
      Function  Partition(Left,Right:LongInt):LongInt;

End;



Type TOrderedPolygon3D = Class

     private
      Point: Array Of TOrdPolyPoint3D;


     public

      Procedure OrderedPolygon(Var Pnt: Array Of TPoint3D);

     private

      Procedure Swap(I,J:LongInt);
      Procedure RQSort(Left,Right:LongInt);
      Function  Partition(Left,Right:LongInt):LongInt;

End;


implementation

Procedure TOrderedPolygon2D.OrderedPolygon(Var Pnt: Array Of TPoint2D);
Var I        : Integer;
    LargestX : Double;
    Len      : LongInt;
Begin
 //If Length(Pnt) = 0 Then Exit;
 Point := Nil;
 SetLength(Point,Length(Pnt));
 Len := Length(Pnt);
 LargestX := 0;
 For I:=  0 to Len-1 Do
  Begin
   Point[I].x   := Pnt[I].x;
   Point[I].y   := Pnt[I].y;
   Point[I].ang := 0.0;
   If Point[I].y < Point[0].y Then Swap(0,I);
   If Point[I].x > LargestX Then LargestX := Point[i].x;
  End;

 For I:=  1 to Len-1 Do
  Begin
   Point[I].ang := VertexAngle(LargestX,Point[0].y,Point[0].x,Point[0].y,Point[i].x,Point[i].y);
  End;

  RQSort(1,Len-1);

 For I:=  0 to Len-1 Do
  Begin
   Pnt[I].x := Point[I].x;
   Pnt[I].y := Point[I].y;
  End;

End;

Procedure TOrderedPolygon2D.Swap(I,J:LongInt);
Var Temp: TOrdPolyPoint2D;
Begin
 Temp     := Point[I];
 Point[I] := Point[J];
 Point[J] := Temp;
End;


(* Quick sorts main block *)
Procedure TOrderedPolygon2D.RQSort(Left,Right:LongInt);
Var I:Integer;
Begin
 (* ends have crossed over pivot *)
 If Right <= Left Then Exit;

 (* paritition array *)
 i := Partition(Left,Right);

 (*
    apply quick-sort to both left
    and right sides of pivoting
 *)

 RQSort(Left,i-1);
 RQSort(i+1,Right);
End;


(* paritition method for quick-sort *)
Function TOrderedPolygon2D.Partition(Left,Right:LongInt):LongInt;
Var
 I,J,Middle:Integer;
 Pivot     :TOrdPolyPoint2D;
Begin
 i      := Left;
 j      := Right;
 Middle := (Left+Right) Div 2;

 { Median of 3 Pivot Selection }
 If Point[Middle].Ang < Point[Left].Ang   Then Swap(Left, Middle);
 If Point[Right].Ang  < Point[Middle].Ang Then Swap(Right,Middle);
 If Point[Middle].Ang < Point[Left].Ang   Then Swap(Left, Middle);

 Pivot.Ang := Point[Right].Ang;

 Repeat

  While (Pivot.Ang >= Point[i].Ang) And (i < Right) Do Inc(i);
  While  Pivot.Ang <= Point[j].Ang Do
   Begin
    Dec(j);
    If J-1 < 0 then Break;
   End;
  If i < j Then  Swap(i, j);

 Until i >= j;

 Swap(i,Right);
 Result:=i;
End;





Procedure TOrderedPolygon3D.OrderedPolygon(Var Pnt: Array Of TPoint3D);
Var I        : Integer;
    LargestX : Double;
    LargestZ : Double;
Begin
 SetLength(Point,Length(Pnt));
 LargestX := 0;
 LargestZ := 0;
 For I:=  0 to Length(Pnt)-1 Do
  Begin
   Point[I].x   := Pnt[I].x;
   Point[I].y   := Pnt[I].y;
   Point[I].z   := Pnt[I].z;
   Point[I].ang := 0.0;
   If Point[I].y < Point[0].y Then Swap(0,I);
   If Point[I].x > LargestX Then LargestX := Point[i].x;
   If Point[I].z > LargestZ Then LargestZ := Point[i].z;
  End;

 For I:=  1 to Length(Pnt)-1 Do
  Begin
   Point[I].ang := VertexAngle(LargestX,Point[0].y,LargestZ,Point[0].x,Point[0].y,Point[0].z,Point[i].x,Point[i].y,Point[i].z);
  End;

  RQSort(1,Length(Point)-1);

 For I:=  0 to Length(Pnt)-1 Do
  Begin
   Pnt[I].x   := Point[I].x;
   Pnt[I].y   := Point[I].y;
   Pnt[I].z   := Point[I].z;
  End;

End;

Procedure TOrderedPolygon3D.Swap(I,J:LongInt);
Var Temp: TOrdPolyPoint3D;
Begin
 Temp     := Point[I];
 Point[I] := Point[J];
 Point[J] := Temp;
End;


(* Quick sorts main block *)
Procedure TOrderedPolygon3D.RQSort(Left,Right:LongInt);
Var I:Integer;
Begin
 (* ends have crossed over pivot *)
 If Right <= Left Then Exit;

 (* paritition array *)
 i := Partition(Left,Right);

 (*
    apply quick-sort to both left
    and right sides of pivoting
 *)

 RQSort(Left,i-1);
 RQSort(i+1,Right);
End;


(* paritition method for quick-sort *)
Function TOrderedPolygon3D.Partition(Left,Right:LongInt):LongInt;
Var
 I,J,Middle:LongInt;
 Pivot     :TOrdPolyPoint3D;
Begin
 i      := Left;
 j      := Right;
 Middle := (Left+Right) Div 2;

 { Median of 3 Pivot Selection }
 If Point[Middle].Ang < Point[Left].Ang   Then Swap(Left, Middle);
 If Point[Right].Ang  < Point[Middle].Ang Then Swap(Right,Middle);
 If Point[Middle].Ang < Point[Left].Ang   Then Swap(Left, Middle);

 Pivot.Ang := Point[Right].Ang;

 Repeat

  While (Pivot.Ang >= Point[i].Ang) And (i < Right) Do Inc(i);
  While  Pivot.Ang <= Point[j].Ang Do
   Begin
    Dec(j);
    If J-1 < 0 then Break;
   End;
  If i < j Then  Swap(i, j);

 Until i >= j;

 Swap(i,Right);
 Result:=i;
End;




end.
