(*************************************************************************)
(*                                                                       *)
(*                        FastGEO Ordered Polygon                        *)
(*                         Release Version 0.0.1                         *)
(*                                                                       *)
(* Author: Arash Partow 1997-2004                                        *)
(* Copyright notice:                                                     *)
(*                                                                       *)
(* Free use of the FastGEO Ordered Polygon is permitted under the        *)
(* guidelines and in accordance with the most current version of the     *)
(* Common Public License.                                                *)
(* http://www.opensource.org/licenses/cpl.php                            *)
(*                                                                       *)
(* Description:                                                          *)
(* This is a simple implementation of re-ordering a complex              *)
(* 2D/3D self-intersecting polygon into a simple concave polygon using   *)
(* FastGEO as the base for geometric primitives.                         *)
(*************************************************************************)

unit OrderedPolyFrm;

interface

uses
  Windows, Messages, SysUtils, Variants,
  Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls,
  OrderedPolygonUnit, FastGEO, FastGEOGraphics;

type
  TOrderedPolygonForm = class(TForm)
    Surface        : TPaintBox;
    Panel1         : TPanel;
    StatusBar1     : TStatusBar;
    Splitter1      : TSplitter;
    Panel2         : TPanel;
    GenRandPntsBtn : TButton;
    DispEdgeBtn    : TButton;
    OrdPolyBtn     : TButton;
    procedure FormCreate(Sender: TObject);
    procedure GenRandPntsBtnClick(Sender: TObject);
    procedure DispEdgeBtnClick(Sender: TObject);
    procedure OrdPolyBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure DrawPoints;
    procedure DisplayEdges;
  end;

Const MAX_POINTS = 100;

var OrderedPolygonForm : TOrderedPolygonForm;
    Point              : Array Of TPoint2D;

implementation

{$R *.dfm}

procedure TOrderedPolygonForm.FormCreate(Sender: TObject);
begin
 SetLength(Point,MAX_POINTS);
end;

procedure TOrderedPolygonForm.DrawPoints;
Var I :Integer;
   FGr: TFastGeoGraphics;
Begin
 Surface.Canvas.Brush.Style := bsSolid;
 Surface.Canvas.Brush.Color := clWhite;
 Surface.Canvas.FillRect(Rect(0,0,Surface.Width,Surface.Height));
 Surface.Canvas.Brush.Color := clBlack;
 Surface.Canvas.Pen.Color   := clBlack;
 Surface.Canvas.Pen.Width   := 3;
 FGr := TFastGeoGraphics.Create(Surface.Canvas);
 For I:= 0 To MAX_POINTS-1 Do
  Begin
   FGr.DrawPoint(Point[I]);
  End;
End;

procedure TOrderedPolygonForm.DisplayEdges;
Var I :Integer;
   FGr: TFastGeoGraphics;
Begin
 Surface.Canvas.Brush.Style:=bsSolid;
 Surface.Canvas.Brush.Color:=clWhite;
 Surface.Canvas.FillRect(Rect(0,0,Surface.Width,Surface.Height));
 Surface.Canvas.Brush.Color:=clBlack;
 Surface.Canvas.Pen.Color:= clBlack;
 Surface.Canvas.Pen.Width:=2;
 FGr := TFastGeoGraphics.Create(Surface.Canvas);
 For I:= 0 To MAX_POINTS-1 Do
  Begin
   FGr.DrawLine(Point[I], Point[(I+1) Mod MAX_POINTS]);
  End;
End;

procedure TOrderedPolygonForm.GenRandPntsBtnClick(Sender: TObject);
begin
 GenerateRandomPoints(10,10,Surface.Width-10,Surface.Height-10,Point);
 DrawPoints;
end;

procedure TOrderedPolygonForm.DispEdgeBtnClick(Sender: TObject);
begin
 DisplayEdges;
end;

procedure TOrderedPolygonForm.OrdPolyBtnClick(Sender: TObject);
Var OrdPoly    : TOrderedPolygon2D;
begin
 OrdPoly := TOrderedPolygon2D.Create;
 OrdPoly.OrderedPolygon(Point);
 DisplayEdges;
end;

end.
